import * as tslib_1 from "tslib";
var I18NextModule_1;
import { NgModule } from '@angular/core';
import { I18NEXT_ERROR_HANDLING_STRATEGY, I18NEXT_NAMESPACE, I18NEXT_SCOPE, I18NEXT_SERVICE, I18NEXT_NAMESPACE_RESOLVER } from './I18NEXT_TOKENS';
import { I18NextCapPipe } from './I18NextCapPipe';
import { NativeErrorHandlingStrategy } from './I18NextErrorHandlingStrategies';
import { I18NextFormatPipe } from './I18NextFormatPipe';
import { I18NextPipe } from './I18NextPipe';
import { I18NextService } from './I18NextService';
import { I18NextTitle } from './I18NextTitle';
export * from './I18NEXT_TOKENS';
export * from './I18NextPipe';
export * from './I18NextCapPipe';
export * from './I18NextFormatPipe';
export * from './I18NextService';
export * from './I18NextTitle';
export * from './I18NextErrorHandlingStrategies';
export function resolver(activatedRouteSnapshot, routerStateSnapshot) {
    let namespaces = [];
    namespaces = activatedRouteSnapshot.data && activatedRouteSnapshot.data.i18nextNamespaces || namespaces;
    return this.loadNamespaces(namespaces.filter(n => n));
}
export function i18nextNamespaceResolverFactory(i18next) {
    return resolver.bind(i18next);
}
let I18NextModule = I18NextModule_1 = class I18NextModule {
    static forRoot(params = {}) {
        return {
            ngModule: I18NextModule_1,
            providers: [
                {
                    provide: I18NEXT_SERVICE,
                    useClass: I18NextService
                },
                {
                    provide: I18NEXT_ERROR_HANDLING_STRATEGY,
                    useClass: params.errorHandlingStrategy || NativeErrorHandlingStrategy
                },
                I18NextService,
                I18NextPipe,
                I18NextCapPipe,
                I18NextFormatPipe,
                I18NextTitle,
                {
                    provide: I18NEXT_NAMESPACE_RESOLVER,
                    useFactory: i18nextNamespaceResolverFactory,
                    deps: [I18NEXT_SERVICE]
                }
            ]
        };
    }
    static interpolationFormat(customFormat = null) {
        function formatDelegate(value, format, lng) {
            let formatedValue = defaultInterpolationFormat(value, format, lng);
            if (customFormat === null)
                return formatedValue;
            return customFormat(formatedValue, format, lng);
        }
        return formatDelegate;
    }
};
I18NextModule = I18NextModule_1 = tslib_1.__decorate([
    NgModule({
        providers: [
            {
                provide: I18NEXT_NAMESPACE,
                useValue: ''
            },
            {
                provide: I18NEXT_SCOPE,
                useValue: ''
            },
            I18NextPipe,
            I18NextCapPipe,
            I18NextFormatPipe,
            I18NextTitle
        ],
        declarations: [
            I18NextPipe,
            I18NextCapPipe,
            I18NextFormatPipe
        ],
        exports: [
            I18NextPipe,
            I18NextCapPipe,
            I18NextFormatPipe
        ]
    })
], I18NextModule);
export { I18NextModule };
export function defaultInterpolationFormat(value, format, lng = undefined) {
    if (!value)
        return value;
    switch (format) {
        case 'upper':
        case 'uppercase':
            return value.toUpperCase();
        case 'lower':
        case 'lowercase':
            return value.toLowerCase();
        case 'cap':
        case 'capitalize':
            return value.charAt(0).toUpperCase() + value.slice(1);
        case null:
        case undefined:
        case 'none':
        default:
            return value;
    }
}
//# sourceMappingURL=data:application/json;base64,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