import * as tslib_1 from "tslib";
import { Inject, Injectable, Pipe } from '@angular/core';
import { I18NEXT_SERVICE } from './I18NEXT_TOKENS';
var I18NextFormatPipe = /** @class */ (function () {
    function I18NextFormatPipe(translateI18Next) {
        this.translateI18Next = translateI18Next;
    }
    I18NextFormatPipe.prototype.transform = function (value, options) {
        var opts = typeof (options) === 'string' ? { format: options } : options;
        return this.translateI18Next.format(value, opts.format, opts.lng);
    };
    I18NextFormatPipe = tslib_1.__decorate([
        Injectable(),
        Pipe({
            name: 'i18nextFormat'
        }),
        tslib_1.__param(0, Inject(I18NEXT_SERVICE)),
        tslib_1.__metadata("design:paramtypes", [Object])
    ], I18NextFormatPipe);
    return I18NextFormatPipe;
}());
export { I18NextFormatPipe };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiSTE4TmV4dEZvcm1hdFBpcGUuanMiLCJzb3VyY2VSb290Ijoibmc6Ly9hbmd1bGFyLWkxOG5leHQvIiwic291cmNlcyI6WyJJMThOZXh0Rm9ybWF0UGlwZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsT0FBTyxFQUFFLE1BQU0sRUFBRSxVQUFVLEVBQUUsSUFBSSxFQUFpQixNQUFNLGVBQWUsQ0FBQztBQUV4RSxPQUFPLEVBQUUsZUFBZSxFQUFFLE1BQU0sa0JBQWtCLENBQUM7QUFPbkQ7SUFFRSwyQkFDcUMsZ0JBQXFDO1FBQXJDLHFCQUFnQixHQUFoQixnQkFBZ0IsQ0FBcUI7SUFDdkUsQ0FBQztJQUVHLHFDQUFTLEdBQWhCLFVBQWlCLEtBQVUsRUFBRSxPQUF3QjtRQUNuRCxJQUFJLElBQUksR0FBUSxPQUFNLENBQUMsT0FBTyxDQUFDLEtBQUssUUFBUSxDQUFDLENBQUMsQ0FBQyxFQUFFLE1BQU0sRUFBRSxPQUFPLEVBQUUsQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDO1FBQzdFLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxLQUFLLEVBQUUsSUFBSSxDQUFDLE1BQU0sRUFBRSxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDcEUsQ0FBQztJQVRVLGlCQUFpQjtRQUo3QixVQUFVLEVBQUU7UUFDWixJQUFJLENBQUM7WUFDRixJQUFJLEVBQUUsZUFBZTtTQUN4QixDQUFDO1FBSUssbUJBQUEsTUFBTSxDQUFDLGVBQWUsQ0FBQyxDQUFBOztPQUhqQixpQkFBaUIsQ0FVN0I7SUFBRCx3QkFBQztDQUFBLEFBVkQsSUFVQztTQVZZLGlCQUFpQiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEluamVjdCwgSW5qZWN0YWJsZSwgUGlwZSwgUGlwZVRyYW5zZm9ybSB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xyXG5cclxuaW1wb3J0IHsgSTE4TkVYVF9TRVJWSUNFIH0gZnJvbSAnLi9JMThORVhUX1RPS0VOUyc7XHJcbmltcG9ydCB7IElUcmFuc2xhdGlvblNlcnZpY2UgfSBmcm9tICcuL0lUcmFuc2xhdGlvblNlcnZpY2UnO1xyXG5cclxuQEluamVjdGFibGUoKVxyXG5AUGlwZSh7XHJcbiAgICBuYW1lOiAnaTE4bmV4dEZvcm1hdCdcclxufSlcclxuZXhwb3J0IGNsYXNzIEkxOE5leHRGb3JtYXRQaXBlIGltcGxlbWVudHMgUGlwZVRyYW5zZm9ybSB7XHJcblxyXG4gIGNvbnN0cnVjdG9yKFxyXG4gICAgICBASW5qZWN0KEkxOE5FWFRfU0VSVklDRSkgcHJpdmF0ZSB0cmFuc2xhdGVJMThOZXh0OiBJVHJhbnNsYXRpb25TZXJ2aWNlXHJcbiAgKSB7fVxyXG5cclxuICBwdWJsaWMgdHJhbnNmb3JtKHZhbHVlOiBhbnksIG9wdGlvbnM6IE9iamVjdCB8IHN0cmluZyk6IHN0cmluZyB7XHJcbiAgICBsZXQgb3B0czogYW55ID0gdHlwZW9mKG9wdGlvbnMpID09PSAnc3RyaW5nJyA/IHsgZm9ybWF0OiBvcHRpb25zIH0gOiBvcHRpb25zO1xyXG4gICAgcmV0dXJuIHRoaXMudHJhbnNsYXRlSTE4TmV4dC5mb3JtYXQodmFsdWUsIG9wdHMuZm9ybWF0LCBvcHRzLmxuZyk7XHJcbiAgfVxyXG59XHJcbiJdfQ==