import * as tslib_1 from "tslib";
import { NgModule } from '@angular/core';
import { I18NEXT_ERROR_HANDLING_STRATEGY, I18NEXT_NAMESPACE, I18NEXT_SCOPE, I18NEXT_SERVICE, I18NEXT_NAMESPACE_RESOLVER } from './I18NEXT_TOKENS';
import { I18NextCapPipe } from './I18NextCapPipe';
import { NativeErrorHandlingStrategy } from './I18NextErrorHandlingStrategies';
import { I18NextFormatPipe } from './I18NextFormatPipe';
import { I18NextPipe } from './I18NextPipe';
import { I18NextService } from './I18NextService';
import { I18NextTitle } from './I18NextTitle';
export * from './I18NEXT_TOKENS';
export * from './I18NextPipe';
export * from './I18NextCapPipe';
export * from './I18NextFormatPipe';
export * from './I18NextService';
export * from './I18NextTitle';
export * from './I18NextErrorHandlingStrategies';
export function resolver(activatedRouteSnapshot, routerStateSnapshot) {
    var namespaces = [];
    namespaces = activatedRouteSnapshot.data && activatedRouteSnapshot.data.i18nextNamespaces || namespaces;
    return this.loadNamespaces(namespaces.filter(function (n) { return n; }));
}
export function i18nextNamespaceResolverFactory(i18next) {
    return resolver.bind(i18next);
}
var I18NextModule = /** @class */ (function () {
    function I18NextModule() {
    }
    I18NextModule_1 = I18NextModule;
    I18NextModule.forRoot = function (params) {
        if (params === void 0) { params = {}; }
        return {
            ngModule: I18NextModule_1,
            providers: [
                {
                    provide: I18NEXT_SERVICE,
                    useClass: I18NextService
                },
                {
                    provide: I18NEXT_ERROR_HANDLING_STRATEGY,
                    useClass: params.errorHandlingStrategy || NativeErrorHandlingStrategy
                },
                I18NextService,
                I18NextPipe,
                I18NextCapPipe,
                I18NextFormatPipe,
                I18NextTitle,
                {
                    provide: I18NEXT_NAMESPACE_RESOLVER,
                    useFactory: i18nextNamespaceResolverFactory,
                    deps: [I18NEXT_SERVICE]
                }
            ]
        };
    };
    I18NextModule.interpolationFormat = function (customFormat) {
        if (customFormat === void 0) { customFormat = null; }
        function formatDelegate(value, format, lng) {
            var formatedValue = defaultInterpolationFormat(value, format, lng);
            if (customFormat === null)
                return formatedValue;
            return customFormat(formatedValue, format, lng);
        }
        return formatDelegate;
    };
    var I18NextModule_1;
    I18NextModule = I18NextModule_1 = tslib_1.__decorate([
        NgModule({
            providers: [
                {
                    provide: I18NEXT_NAMESPACE,
                    useValue: ''
                },
                {
                    provide: I18NEXT_SCOPE,
                    useValue: ''
                },
                I18NextPipe,
                I18NextCapPipe,
                I18NextFormatPipe,
                I18NextTitle
            ],
            declarations: [
                I18NextPipe,
                I18NextCapPipe,
                I18NextFormatPipe
            ],
            exports: [
                I18NextPipe,
                I18NextCapPipe,
                I18NextFormatPipe
            ]
        })
    ], I18NextModule);
    return I18NextModule;
}());
export { I18NextModule };
export function defaultInterpolationFormat(value, format, lng) {
    if (lng === void 0) { lng = undefined; }
    if (!value)
        return value;
    switch (format) {
        case 'upper':
        case 'uppercase':
            return value.toUpperCase();
        case 'lower':
        case 'lowercase':
            return value.toLowerCase();
        case 'cap':
        case 'capitalize':
            return value.charAt(0).toUpperCase() + value.slice(1);
        case null:
        case undefined:
        case 'none':
        default:
            return value;
    }
}
//# sourceMappingURL=data:application/json;base64,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