/*!
 * devextreme-angular
 * Version: 19.2.3
 * Build date: Tue Oct 22 2019
 *
 * Copyright (c) 2012 - 2019 Developer Express Inc. ALL RIGHTS RESERVED
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file in the root of the project for details.
 *
 * https://github.com/DevExpress/devextreme-angular
 */
/* tslint:disable:use-input-property-decorator */
import { Directive, NgModule, TemplateRef, ViewContainerRef, Input, Renderer2, NgZone } from '@angular/core';
import { DxTemplateHost } from './template-host';
import { getElement } from './utils';
import * as events from 'devextreme/events';
export var DX_TEMPLATE_WRAPPER_CLASS = 'dx-template-wrapper';
var RenderData = /** @class */ (function () {
    function RenderData() {
    }
    return RenderData;
}());
export { RenderData };
var DxTemplateDirective = /** @class */ (function () {
    function DxTemplateDirective(templateRef, viewContainerRef, templateHost, renderer, zone) {
        this.templateRef = templateRef;
        this.viewContainerRef = viewContainerRef;
        this.renderer = renderer;
        this.zone = zone;
        templateHost.setTemplate(this);
    }
    Object.defineProperty(DxTemplateDirective.prototype, "dxTemplateOf", {
        set: function (value) {
            this.name = value;
        },
        enumerable: true,
        configurable: true
    });
    ;
    DxTemplateDirective.prototype.renderTemplate = function (renderData) {
        var _this = this;
        var childView = this.viewContainerRef.createEmbeddedView(this.templateRef, {
            '$implicit': renderData.model,
            index: renderData.index
        });
        var container = getElement(renderData.container);
        if (renderData.container) {
            childView.rootNodes.forEach(function (element) {
                _this.renderer.appendChild(container, element);
            });
        }
        return childView;
    };
    DxTemplateDirective.prototype.render = function (renderData) {
        var _this = this;
        var childView;
        if (this.zone.isStable) {
            childView = this.zone.run(function () {
                return _this.renderTemplate(renderData);
            });
        }
        else {
            childView = this.renderTemplate(renderData);
            // =========== WORKAROUND =============
            // https://github.com/angular/angular/issues/12243
            childView['detectChanges']();
            // =========== /WORKAROUND =============
        }
        childView.rootNodes.forEach(function (element) {
            if (element.nodeType === 1) {
                _this.renderer.addClass(element, DX_TEMPLATE_WRAPPER_CLASS);
            }
            events.one(element, 'dxremove', function (_a, params) {
                if (!params || !params._angularIntegration) {
                    childView.destroy();
                }
            });
        });
        return childView.rootNodes;
    };
    DxTemplateDirective.decorators = [
        { type: Directive, args: [{
                    selector: '[dxTemplate]'
                },] },
    ];
    /** @nocollapse */
    DxTemplateDirective.ctorParameters = function () { return [
        { type: TemplateRef },
        { type: ViewContainerRef },
        { type: DxTemplateHost },
        { type: Renderer2 },
        { type: NgZone }
    ]; };
    DxTemplateDirective.propDecorators = {
        dxTemplateOf: [{ type: Input }]
    };
    return DxTemplateDirective;
}());
export { DxTemplateDirective };
var DxTemplateModule = /** @class */ (function () {
    function DxTemplateModule() {
    }
    DxTemplateModule.decorators = [
        { type: NgModule, args: [{
                    declarations: [DxTemplateDirective],
                    exports: [DxTemplateDirective]
                },] },
    ];
    return DxTemplateModule;
}());
export { DxTemplateModule };

//# sourceMappingURL=data:application/json;base64,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