/*!
 * devextreme-angular
 * Version: 19.2.3
 * Build date: Tue Oct 22 2019
 *
 * Copyright (c) 2012 - 2019 Developer Express Inc. ALL RIGHTS RESERVED
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file in the root of the project for details.
 *
 * https://github.com/DevExpress/devextreme-angular
 */
import { Injectable } from '@angular/core';
import * as commonUtils from 'devextreme/core/utils/common';
var WatcherHelper = /** @class */ (function () {
    function WatcherHelper() {
        this._watchers = [];
    }
    WatcherHelper.prototype.getWatchMethod = function () {
        var _this = this;
        var watchMethod = function (valueGetter, valueChangeCallback, options) {
            var oldValue = valueGetter();
            options = options || {};
            if (!options.skipImmediate) {
                valueChangeCallback(oldValue);
            }
            var watcher = function () {
                var newValue = valueGetter();
                if (_this._isDifferentValues(oldValue, newValue, options.deep)) {
                    valueChangeCallback(newValue);
                    oldValue = newValue;
                }
            };
            _this._watchers.push(watcher);
            return function () {
                var index = _this._watchers.indexOf(watcher);
                if (index !== -1) {
                    _this._watchers.splice(index, 1);
                }
            };
        };
        return watchMethod;
    };
    WatcherHelper.prototype._isDifferentValues = function (oldValue, newValue, deepCheck) {
        var comparableNewValue = this._toComparable(newValue);
        var comparableOldValue = this._toComparable(oldValue);
        var isObjectValues = comparableNewValue instanceof Object && comparableOldValue instanceof Object;
        if (deepCheck && isObjectValues) {
            return this._checkObjectsFields(newValue, oldValue);
        }
        return comparableNewValue !== comparableOldValue;
    };
    WatcherHelper.prototype._toComparable = function (value) {
        if (value instanceof Date) {
            return value.getTime();
        }
        return value;
    };
    WatcherHelper.prototype._checkObjectsFields = function (checkingFromObject, checkingToObject) {
        for (var field in checkingFromObject) {
            var oldValue = this._toComparable(checkingFromObject[field]);
            var newValue = this._toComparable(checkingToObject[field]);
            var isEqualObjects = false;
            if (typeof oldValue === 'object' && typeof newValue === 'object') {
                isEqualObjects = commonUtils.equalByValue(oldValue, newValue);
            }
            if (oldValue !== newValue && !isEqualObjects) {
                return true;
            }
        }
    };
    WatcherHelper.prototype.checkWatchers = function () {
        for (var _i = 0, _a = this._watchers; _i < _a.length; _i++) {
            var watcher = _a[_i];
            watcher();
        }
    };
    WatcherHelper.decorators = [
        { type: Injectable },
    ];
    return WatcherHelper;
}());
export { WatcherHelper };

//# sourceMappingURL=data:application/json;base64,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