/*!
 * devextreme-angular
 * Version: 19.2.3
 * Build date: Tue Oct 22 2019
 *
 * Copyright (c) 2012 - 2019 Developer Express Inc. ALL RIGHTS RESERVED
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file in the root of the project for details.
 *
 * https://github.com/DevExpress/devextreme-angular
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/* tslint:disable:max-line-length */
/* tslint:disable:use-input-property-decorator */
import { Component, NgModule, Host, ElementRef, Renderer2, Inject, SkipSelf, ContentChildren, forwardRef, QueryList } from '@angular/core';
import { DOCUMENT } from '@angular/common';
import { NestedOptionHost, extractTemplate } from '../../core/nested-option';
import { DxTemplateHost } from '../../core/template-host';
import { DxiButtonGroupItem } from './base/button-group-item-dxi';
import { DxiValidationRuleComponent } from './validation-rule-dxi';
import { DxiTabComponent } from './tab-dxi';
import { DxiLocationComponent } from './location-dxi';
var DxiItemComponent = /** @class */ (function (_super) {
    __extends(DxiItemComponent, _super);
    function DxiItemComponent(parentOptionHost, optionHost, renderer, document, templateHost, element) {
        var _this = _super.call(this) || this;
        _this.renderer = renderer;
        _this.document = document;
        _this.element = element;
        parentOptionHost.setNestedOption(_this);
        optionHost.setHost(_this, _this._fullOptionPath.bind(_this));
        templateHost.setHost(_this);
        return _this;
    }
    Object.defineProperty(DxiItemComponent.prototype, "_optionPath", {
        get: function () {
            return 'items';
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxiItemComponent.prototype, "itemsChildren", {
        get: function () {
            return this._getOption('items');
        },
        set: function (value) {
            this.setChildren('items', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxiItemComponent.prototype, "validationRulesChildren", {
        get: function () {
            return this._getOption('validationRules');
        },
        set: function (value) {
            this.setChildren('validationRules', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxiItemComponent.prototype, "tabsChildren", {
        get: function () {
            return this._getOption('tabs');
        },
        set: function (value) {
            this.setChildren('tabs', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxiItemComponent.prototype, "locationChildren", {
        get: function () {
            return this._getOption('location');
        },
        set: function (value) {
            this.setChildren('location', value);
        },
        enumerable: true,
        configurable: true
    });
    DxiItemComponent.prototype.setTemplate = function (template) {
        this.template = template;
    };
    DxiItemComponent.prototype.ngAfterViewInit = function () {
        extractTemplate(this, this.element, this.renderer, this.document);
    };
    DxiItemComponent.decorators = [
        { type: Component, args: [{
                    selector: 'dxi-item',
                    template: '<ng-content></ng-content>',
                    styles: [':host { display: block; }'],
                    providers: [NestedOptionHost, DxTemplateHost],
                    inputs: [
                        'disabled',
                        'html',
                        'icon',
                        'template',
                        'text',
                        'title',
                        'visible',
                        'onClick',
                        'type',
                        'baseSize',
                        'box',
                        'ratio',
                        'shrink',
                        'hint',
                        'beginGroup',
                        'closeMenuOnClick',
                        'items',
                        'selectable',
                        'selected',
                        'colSpan',
                        'cssClass',
                        'dataField',
                        'editorOptions',
                        'editorType',
                        'helpText',
                        'isRequired',
                        'itemType',
                        'label',
                        'name',
                        'validationRules',
                        'visibleIndex',
                        'alignItemLabels',
                        'caption',
                        'colCount',
                        'colCountByScreen',
                        'tabPanelOptions',
                        'tabs',
                        'badge',
                        'tabTemplate',
                        'alignment',
                        'buttonOptions',
                        'horizontalAlignment',
                        'verticalAlignment',
                        'height',
                        'width',
                        'imageAlt',
                        'imageSrc',
                        'formatName',
                        'formatValues',
                        'locateInMenu',
                        'location',
                        'menuItemTemplate',
                        'options',
                        'showText',
                        'widget',
                        'key',
                        'showChevron',
                        'menuTemplate',
                        'heightRatio',
                        'widthRatio',
                        'expanded',
                        'hasItems',
                        'parentId'
                    ]
                },] },
    ];
    /** @nocollapse */
    DxiItemComponent.ctorParameters = function () { return [
        { type: NestedOptionHost, decorators: [{ type: SkipSelf }, { type: Host }] },
        { type: NestedOptionHost, decorators: [{ type: Host }] },
        { type: Renderer2 },
        { type: undefined, decorators: [{ type: Inject, args: [DOCUMENT,] }] },
        { type: DxTemplateHost, decorators: [{ type: Host }] },
        { type: ElementRef }
    ]; };
    DxiItemComponent.propDecorators = {
        itemsChildren: [{ type: ContentChildren, args: [forwardRef(function () { return DxiItemComponent; }),] }],
        validationRulesChildren: [{ type: ContentChildren, args: [forwardRef(function () { return DxiValidationRuleComponent; }),] }],
        tabsChildren: [{ type: ContentChildren, args: [forwardRef(function () { return DxiTabComponent; }),] }],
        locationChildren: [{ type: ContentChildren, args: [forwardRef(function () { return DxiLocationComponent; }),] }]
    };
    return DxiItemComponent;
}(DxiButtonGroupItem));
export { DxiItemComponent };
var DxiItemModule = /** @class */ (function () {
    function DxiItemModule() {
    }
    DxiItemModule.decorators = [
        { type: NgModule, args: [{
                    declarations: [
                        DxiItemComponent
                    ],
                    exports: [
                        DxiItemComponent
                    ],
                },] },
    ];
    return DxiItemModule;
}());
export { DxiItemModule };

//# sourceMappingURL=data:application/json;base64,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