"use strict";
/*!
 * devextreme-angular
 * Version: 19.2.3
 * Build date: Tue Oct 22 2019
 *
 * Copyright (c) 2012 - 2019 Developer Express Inc. ALL RIGHTS RESERVED
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file in the root of the project for details.
 *
 * https://github.com/DevExpress/devextreme-angular
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var platform_browser_1 = require("@angular/platform-browser");
var platform_browser_2 = require("@angular/platform-browser");
var core_1 = require("@angular/core");
var diagram_1 = require("devextreme/ui/diagram");
var component_1 = require("../core/component");
var template_host_1 = require("../core/template-host");
var integration_1 = require("../core/integration");
var template_1 = require("../core/template");
var nested_option_1 = require("../core/nested-option");
var watcher_helper_1 = require("../core/watcher-helper");
var iterable_differ_helper_1 = require("../core/iterable-differ-helper");
var context_menu_1 = require("./nested/context-menu");
var custom_shape_dxi_1 = require("./nested/custom-shape-dxi");
var connection_point_dxi_1 = require("./nested/connection-point-dxi");
var edges_1 = require("./nested/edges");
var export_1 = require("./nested/export");
var grid_size_1 = require("./nested/grid-size");
var nodes_1 = require("./nested/nodes");
var auto_layout_1 = require("./nested/auto-layout");
var page_size_1 = require("./nested/page-size");
var item_dxi_1 = require("./nested/item-dxi");
var properties_panel_1 = require("./nested/properties-panel");
var group_dxi_1 = require("./nested/group-dxi");
var toolbar_1 = require("./nested/toolbar");
var toolbox_1 = require("./nested/toolbox");
var zoom_level_1 = require("./nested/zoom-level");
var custom_shape_dxi_2 = require("./nested/custom-shape-dxi");
/**
 * [tags] ctp The Diagram widget provides a visual interface to help you design new and modify existing diagrams. #include common-ctp-note with { component: "Diagram" }
 */
var DxDiagramComponent = /** @class */ (function (_super) {
    __extends(DxDiagramComponent, _super);
    function DxDiagramComponent(elementRef, ngZone, templateHost, _watcherHelper, _idh, optionHost, transferState, platformId) {
        var _this = _super.call(this, elementRef, ngZone, templateHost, _watcherHelper, transferState, platformId) || this;
        _this._watcherHelper = _watcherHelper;
        _this._idh = _idh;
        _this._createEventEmitters([
            { subscribe: 'contentReady', emit: 'onContentReady' },
            { subscribe: 'dataChanged', emit: 'onDataChanged' },
            { subscribe: 'disposing', emit: 'onDisposing' },
            { subscribe: 'initialized', emit: 'onInitialized' },
            { subscribe: 'optionChanged', emit: 'onOptionChanged' },
            { emit: 'accessKeyChange' },
            { emit: 'activeStateEnabledChange' },
            { emit: 'autoZoomChange' },
            { emit: 'contextMenuChange' },
            { emit: 'customShapesChange' },
            { emit: 'disabledChange' },
            { emit: 'edgesChange' },
            { emit: 'elementAttrChange' },
            { emit: 'exportChange' },
            { emit: 'focusStateEnabledChange' },
            { emit: 'fullScreenChange' },
            { emit: 'gridSizeChange' },
            { emit: 'heightChange' },
            { emit: 'hintChange' },
            { emit: 'hoverStateEnabledChange' },
            { emit: 'nodesChange' },
            { emit: 'pageColorChange' },
            { emit: 'pageOrientationChange' },
            { emit: 'pageSizeChange' },
            { emit: 'propertiesPanelChange' },
            { emit: 'readOnlyChange' },
            { emit: 'rtlEnabledChange' },
            { emit: 'showGridChange' },
            { emit: 'simpleViewChange' },
            { emit: 'snapToGridChange' },
            { emit: 'tabIndexChange' },
            { emit: 'toolbarChange' },
            { emit: 'toolboxChange' },
            { emit: 'unitsChange' },
            { emit: 'viewUnitsChange' },
            { emit: 'visibleChange' },
            { emit: 'widthChange' },
            { emit: 'zoomLevelChange' }
        ]);
        _this._idh.setHost(_this);
        optionHost.setHost(_this);
        return _this;
    }
    Object.defineProperty(DxDiagramComponent.prototype, "accessKey", {
        /**
         * Specifies the shortcut key that sets focus on the widget.
         */
        get: function () {
            return this._getOption('accessKey');
        },
        set: function (value) {
            this._setOption('accessKey', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "activeStateEnabled", {
        /**
         * Specifies whether or not the widget changes its state when interacting with a user.
         */
        get: function () {
            return this._getOption('activeStateEnabled');
        },
        set: function (value) {
            this._setOption('activeStateEnabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "autoZoom", {
        /**
         * Specifies whether the Diagram widget automatically zooms the work area.
         */
        get: function () {
            return this._getOption('autoZoom');
        },
        set: function (value) {
            this._setOption('autoZoom', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "contextMenu", {
        /**
         * Configures the context menu's settings.
         */
        get: function () {
            return this._getOption('contextMenu');
        },
        set: function (value) {
            this._setOption('contextMenu', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "customShapes", {
        /**
         * Provide access to an array of custom shapes.
         */
        get: function () {
            return this._getOption('customShapes');
        },
        set: function (value) {
            this._setOption('customShapes', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "disabled", {
        /**
         * Specifies whether the widget responds to user interaction.
         */
        get: function () {
            return this._getOption('disabled');
        },
        set: function (value) {
            this._setOption('disabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "edges", {
        /**
         * Allows you to bind the collection of diagram edges to a data source.
         */
        get: function () {
            return this._getOption('edges');
        },
        set: function (value) {
            this._setOption('edges', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "elementAttr", {
        /**
         * Specifies the attributes to be attached to the widget's root element.
         */
        get: function () {
            return this._getOption('elementAttr');
        },
        set: function (value) {
            this._setOption('elementAttr', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "export", {
        /**
         * Configures export settings.
         */
        get: function () {
            return this._getOption('export');
        },
        set: function (value) {
            this._setOption('export', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "focusStateEnabled", {
        /**
         * Specifies whether the widget can be focused using keyboard navigation.
         */
        get: function () {
            return this._getOption('focusStateEnabled');
        },
        set: function (value) {
            this._setOption('focusStateEnabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "fullScreen", {
        /**
         * Specifies whether or not to display the widget in full-screen mode.
         */
        get: function () {
            return this._getOption('fullScreen');
        },
        set: function (value) {
            this._setOption('fullScreen', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "gridSize", {
        /**
         * Specifies the grid pitch.
         */
        get: function () {
            return this._getOption('gridSize');
        },
        set: function (value) {
            this._setOption('gridSize', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "height", {
        /**
         * Specifies the widget's height.
         */
        get: function () {
            return this._getOption('height');
        },
        set: function (value) {
            this._setOption('height', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "hint", {
        /**
         * Specifies text for a hint that appears when a user pauses on the widget.
         */
        get: function () {
            return this._getOption('hint');
        },
        set: function (value) {
            this._setOption('hint', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "hoverStateEnabled", {
        /**
         * Specifies whether the widget changes its state when a user pauses on it.
         */
        get: function () {
            return this._getOption('hoverStateEnabled');
        },
        set: function (value) {
            this._setOption('hoverStateEnabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "nodes", {
        /**
         * Allows you to bind the collection of diagram nodes to a data source.
         */
        get: function () {
            return this._getOption('nodes');
        },
        set: function (value) {
            this._setOption('nodes', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "pageColor", {
        /**
         * Specifies the color of a diagram page.
         */
        get: function () {
            return this._getOption('pageColor');
        },
        set: function (value) {
            this._setOption('pageColor', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "pageOrientation", {
        /**
         * Specifies the page orientation.
         */
        get: function () {
            return this._getOption('pageOrientation');
        },
        set: function (value) {
            this._setOption('pageOrientation', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "pageSize", {
        /**
         * Specifies a size of pages.
         */
        get: function () {
            return this._getOption('pageSize');
        },
        set: function (value) {
            this._setOption('pageSize', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "propertiesPanel", {
        /**
         * Provides access to Properties panel settings.
         */
        get: function () {
            return this._getOption('propertiesPanel');
        },
        set: function (value) {
            this._setOption('propertiesPanel', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "readOnly", {
        /**
         * Specifies whether the diagram is read-only.
         */
        get: function () {
            return this._getOption('readOnly');
        },
        set: function (value) {
            this._setOption('readOnly', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "rtlEnabled", {
        /**
         * Switches the widget to a right-to-left representation.
         */
        get: function () {
            return this._getOption('rtlEnabled');
        },
        set: function (value) {
            this._setOption('rtlEnabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "showGrid", {
        /**
         * Specifies whether grid lines are visible.
         */
        get: function () {
            return this._getOption('showGrid');
        },
        set: function (value) {
            this._setOption('showGrid', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "simpleView", {
        /**
         * Switch the Diagram widget to simple view mode.
         */
        get: function () {
            return this._getOption('simpleView');
        },
        set: function (value) {
            this._setOption('simpleView', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "snapToGrid", {
        /**
         * Specifies whether diagram elements should snap to grid lines.
         */
        get: function () {
            return this._getOption('snapToGrid');
        },
        set: function (value) {
            this._setOption('snapToGrid', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "tabIndex", {
        /**
         * Specifies the number of the element when the Tab key is used for navigating.
         */
        get: function () {
            return this._getOption('tabIndex');
        },
        set: function (value) {
            this._setOption('tabIndex', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "toolbar", {
        /**
         * Provides access to toolbar settings.
         */
        get: function () {
            return this._getOption('toolbar');
        },
        set: function (value) {
            this._setOption('toolbar', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "toolbox", {
        /**
         * Provides access to toolbox settings.
         */
        get: function () {
            return this._getOption('toolbox');
        },
        set: function (value) {
            this._setOption('toolbox', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "units", {
        /**
         * Specifies the unit for measurement options (for example, defaultHeight, gridSize, leftExpr).
         */
        get: function () {
            return this._getOption('units');
        },
        set: function (value) {
            this._setOption('units', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "viewUnits", {
        /**
         * Specifies the measurement unit that is displayed in user interface elements.
         */
        get: function () {
            return this._getOption('viewUnits');
        },
        set: function (value) {
            this._setOption('viewUnits', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "visible", {
        /**
         * Specifies whether the widget is visible.
         */
        get: function () {
            return this._getOption('visible');
        },
        set: function (value) {
            this._setOption('visible', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "width", {
        /**
         * Specifies the widget's width.
         */
        get: function () {
            return this._getOption('width');
        },
        set: function (value) {
            this._setOption('width', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "zoomLevel", {
        /**
         * Specifies the zoom level.
         */
        get: function () {
            return this._getOption('zoomLevel');
        },
        set: function (value) {
            this._setOption('zoomLevel', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDiagramComponent.prototype, "customShapesChildren", {
        get: function () {
            return this._getOption('customShapes');
        },
        set: function (value) {
            this.setChildren('customShapes', value);
        },
        enumerable: true,
        configurable: true
    });
    DxDiagramComponent.prototype._createInstance = function (element, options) {
        return new diagram_1.default(element, options);
    };
    DxDiagramComponent.prototype.ngOnDestroy = function () {
        this._destroyWidget();
    };
    DxDiagramComponent.prototype.ngOnChanges = function (changes) {
        _super.prototype.ngOnChanges.call(this, changes);
        this.setupChanges('customShapes', changes);
    };
    DxDiagramComponent.prototype.setupChanges = function (prop, changes) {
        if (!(prop in this._optionsToUpdate)) {
            this._idh.setup(prop, changes);
        }
    };
    DxDiagramComponent.prototype.ngDoCheck = function () {
        this._idh.doCheck('customShapes');
        this._watcherHelper.checkWatchers();
        _super.prototype.ngDoCheck.call(this);
        _super.prototype.clearChangedOptions.call(this);
    };
    DxDiagramComponent.prototype._setOption = function (name, value) {
        var isSetup = this._idh.setupSingle(name, value);
        var isChanged = this._idh.getChanges(name, value) !== null;
        if (isSetup || isChanged) {
            _super.prototype._setOption.call(this, name, value);
        }
    };
    DxDiagramComponent.decorators = [
        { type: core_1.Component, args: [{
                    selector: 'dx-diagram',
                    template: '',
                    providers: [
                        template_host_1.DxTemplateHost,
                        watcher_helper_1.WatcherHelper,
                        nested_option_1.NestedOptionHost,
                        iterable_differ_helper_1.IterableDifferHelper
                    ]
                },] },
    ];
    /** @nocollapse */
    DxDiagramComponent.ctorParameters = function () { return [
        { type: core_1.ElementRef },
        { type: core_1.NgZone },
        { type: template_host_1.DxTemplateHost },
        { type: watcher_helper_1.WatcherHelper },
        { type: iterable_differ_helper_1.IterableDifferHelper },
        { type: nested_option_1.NestedOptionHost },
        { type: platform_browser_2.TransferState },
        { type: undefined, decorators: [{ type: core_1.Inject, args: [core_1.PLATFORM_ID,] }] }
    ]; };
    DxDiagramComponent.propDecorators = {
        accessKey: [{ type: core_1.Input }],
        activeStateEnabled: [{ type: core_1.Input }],
        autoZoom: [{ type: core_1.Input }],
        contextMenu: [{ type: core_1.Input }],
        customShapes: [{ type: core_1.Input }],
        disabled: [{ type: core_1.Input }],
        edges: [{ type: core_1.Input }],
        elementAttr: [{ type: core_1.Input }],
        export: [{ type: core_1.Input }],
        focusStateEnabled: [{ type: core_1.Input }],
        fullScreen: [{ type: core_1.Input }],
        gridSize: [{ type: core_1.Input }],
        height: [{ type: core_1.Input }],
        hint: [{ type: core_1.Input }],
        hoverStateEnabled: [{ type: core_1.Input }],
        nodes: [{ type: core_1.Input }],
        pageColor: [{ type: core_1.Input }],
        pageOrientation: [{ type: core_1.Input }],
        pageSize: [{ type: core_1.Input }],
        propertiesPanel: [{ type: core_1.Input }],
        readOnly: [{ type: core_1.Input }],
        rtlEnabled: [{ type: core_1.Input }],
        showGrid: [{ type: core_1.Input }],
        simpleView: [{ type: core_1.Input }],
        snapToGrid: [{ type: core_1.Input }],
        tabIndex: [{ type: core_1.Input }],
        toolbar: [{ type: core_1.Input }],
        toolbox: [{ type: core_1.Input }],
        units: [{ type: core_1.Input }],
        viewUnits: [{ type: core_1.Input }],
        visible: [{ type: core_1.Input }],
        width: [{ type: core_1.Input }],
        zoomLevel: [{ type: core_1.Input }],
        onContentReady: [{ type: core_1.Output }],
        onDataChanged: [{ type: core_1.Output }],
        onDisposing: [{ type: core_1.Output }],
        onInitialized: [{ type: core_1.Output }],
        onOptionChanged: [{ type: core_1.Output }],
        accessKeyChange: [{ type: core_1.Output }],
        activeStateEnabledChange: [{ type: core_1.Output }],
        autoZoomChange: [{ type: core_1.Output }],
        contextMenuChange: [{ type: core_1.Output }],
        customShapesChange: [{ type: core_1.Output }],
        disabledChange: [{ type: core_1.Output }],
        edgesChange: [{ type: core_1.Output }],
        elementAttrChange: [{ type: core_1.Output }],
        exportChange: [{ type: core_1.Output }],
        focusStateEnabledChange: [{ type: core_1.Output }],
        fullScreenChange: [{ type: core_1.Output }],
        gridSizeChange: [{ type: core_1.Output }],
        heightChange: [{ type: core_1.Output }],
        hintChange: [{ type: core_1.Output }],
        hoverStateEnabledChange: [{ type: core_1.Output }],
        nodesChange: [{ type: core_1.Output }],
        pageColorChange: [{ type: core_1.Output }],
        pageOrientationChange: [{ type: core_1.Output }],
        pageSizeChange: [{ type: core_1.Output }],
        propertiesPanelChange: [{ type: core_1.Output }],
        readOnlyChange: [{ type: core_1.Output }],
        rtlEnabledChange: [{ type: core_1.Output }],
        showGridChange: [{ type: core_1.Output }],
        simpleViewChange: [{ type: core_1.Output }],
        snapToGridChange: [{ type: core_1.Output }],
        tabIndexChange: [{ type: core_1.Output }],
        toolbarChange: [{ type: core_1.Output }],
        toolboxChange: [{ type: core_1.Output }],
        unitsChange: [{ type: core_1.Output }],
        viewUnitsChange: [{ type: core_1.Output }],
        visibleChange: [{ type: core_1.Output }],
        widthChange: [{ type: core_1.Output }],
        zoomLevelChange: [{ type: core_1.Output }],
        customShapesChildren: [{ type: core_1.ContentChildren, args: [custom_shape_dxi_2.DxiCustomShapeComponent,] }]
    };
    return DxDiagramComponent;
}(component_1.DxComponent));
exports.DxDiagramComponent = DxDiagramComponent;
var DxDiagramModule = /** @class */ (function () {
    function DxDiagramModule() {
    }
    DxDiagramModule.decorators = [
        { type: core_1.NgModule, args: [{
                    imports: [
                        context_menu_1.DxoContextMenuModule,
                        custom_shape_dxi_1.DxiCustomShapeModule,
                        connection_point_dxi_1.DxiConnectionPointModule,
                        edges_1.DxoEdgesModule,
                        export_1.DxoExportModule,
                        grid_size_1.DxoGridSizeModule,
                        nodes_1.DxoNodesModule,
                        auto_layout_1.DxoAutoLayoutModule,
                        page_size_1.DxoPageSizeModule,
                        item_dxi_1.DxiItemModule,
                        properties_panel_1.DxoPropertiesPanelModule,
                        group_dxi_1.DxiGroupModule,
                        toolbar_1.DxoToolbarModule,
                        toolbox_1.DxoToolboxModule,
                        zoom_level_1.DxoZoomLevelModule,
                        integration_1.DxIntegrationModule,
                        template_1.DxTemplateModule,
                        platform_browser_1.BrowserTransferStateModule
                    ],
                    declarations: [
                        DxDiagramComponent
                    ],
                    exports: [
                        DxDiagramComponent,
                        context_menu_1.DxoContextMenuModule,
                        custom_shape_dxi_1.DxiCustomShapeModule,
                        connection_point_dxi_1.DxiConnectionPointModule,
                        edges_1.DxoEdgesModule,
                        export_1.DxoExportModule,
                        grid_size_1.DxoGridSizeModule,
                        nodes_1.DxoNodesModule,
                        auto_layout_1.DxoAutoLayoutModule,
                        page_size_1.DxoPageSizeModule,
                        item_dxi_1.DxiItemModule,
                        properties_panel_1.DxoPropertiesPanelModule,
                        group_dxi_1.DxiGroupModule,
                        toolbar_1.DxoToolbarModule,
                        toolbox_1.DxoToolboxModule,
                        zoom_level_1.DxoZoomLevelModule,
                        template_1.DxTemplateModule
                    ]
                },] },
    ];
    return DxDiagramModule;
}());
exports.DxDiagramModule = DxDiagramModule;
//# sourceMappingURL=diagram.js.map