/*!
 * devextreme-angular
 * Version: 19.2.3
 * Build date: Tue Oct 22 2019
 *
 * Copyright (c) 2012 - 2019 Developer Express Inc. ALL RIGHTS RESERVED
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file in the root of the project for details.
 *
 * https://github.com/DevExpress/devextreme-angular
 */
import { TransferState } from '@angular/platform-browser';
import { ElementRef, NgZone, OnDestroy, EventEmitter } from '@angular/core';
import DxDraggable from 'devextreme/ui/draggable';
import { DxComponent } from '../core/component';
import { DxTemplateHost } from '../core/template-host';
import { NestedOptionHost } from '../core/nested-option';
import { WatcherHelper } from '../core/watcher-helper';
/**
 * Draggable is a user interface utility that allows widget elements to be dragged and dropped.
 */
export declare class DxDraggableComponent extends DxComponent implements OnDestroy {
    instance: DxDraggable;
    /**
     * Enables automatic scrolling while dragging an item beyond the viewport.
     */
    autoScroll: boolean;
    /**
     * Specifies a DOM element that limits the dragging area.
     */
    boundary: Element | JQuery;
    /**
     * Allows a user to drag clones of items instead of actual items.
     */
    clone: boolean;
    /**
     * Specifies a custom container in which the draggable item should be rendered.
     */
    container: Element | JQuery;
    /**
     * Specifies the cursor offset from the dragged item.
     */
    cursorOffset: string | {
        x?: number;
        y?: number;
    };
    /**
     * A container for custom data.
     */
    data: any;
    /**
     * Specifies the directions in which an item can be dragged.
     */
    dragDirection: string;
    /**
     * Specifies custom markup to be shown instead of the item being dragged.
     */
    dragTemplate: any;
    /**
     * Specifies the attributes to be attached to the widget's root element.
     */
    elementAttr: any;
    /**
     * Allows you to group several widgets, so that users can drag and drop items between them.
     */
    group: string;
    /**
     * Specifies a CSS selector (ID or class) that should act as the drag handle(s) for the item(s).
     */
    handle: string;
    /**
     * Specifies the widget's height.
     */
    height: number | Function | string;
    /**
     * Switches the widget to a right-to-left representation.
     */
    rtlEnabled: boolean;
    /**
     * Specifies the distance in pixels from the edge of viewport at which scrolling should start. Applies only if autoScroll is true.
     */
    scrollSensitivity: number;
    /**
     * Specifies the scrolling speed when dragging an item beyond the viewport. Applies only if autoScroll is true.
     */
    scrollSpeed: number;
    /**
     * Specifies the widget's width.
     */
    width: number | Function | string;
    /**
     * A function that is executed before the widget is disposed of.
     */
    onDisposing: EventEmitter<any>;
    /**
     * A function that is called when drag gesture is finished.
     */
    onDragEnd: EventEmitter<any>;
    /**
     * A function that is called every time a draggable item is moved.
     */
    onDragMove: EventEmitter<any>;
    /**
     * A function that is called when the drag gesture is initialized.
     */
    onDragStart: EventEmitter<any>;
    /**
     * A function used in JavaScript frameworks to save the widget instance.
     */
    onInitialized: EventEmitter<any>;
    /**
     * A function that is executed after a widget option is changed.
     */
    onOptionChanged: EventEmitter<any>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    autoScrollChange: EventEmitter<boolean>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    boundaryChange: EventEmitter<Element | JQuery>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    cloneChange: EventEmitter<boolean>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    containerChange: EventEmitter<Element | JQuery>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    cursorOffsetChange: EventEmitter<string | {
        x?: number;
        y?: number;
    }>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    dataChange: EventEmitter<any>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    dragDirectionChange: EventEmitter<string>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    dragTemplateChange: EventEmitter<any>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    elementAttrChange: EventEmitter<any>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    groupChange: EventEmitter<string>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    handleChange: EventEmitter<string>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    heightChange: EventEmitter<number | Function | string>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    rtlEnabledChange: EventEmitter<boolean>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    scrollSensitivityChange: EventEmitter<number>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    scrollSpeedChange: EventEmitter<number>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    widthChange: EventEmitter<number | Function | string>;
    constructor(elementRef: ElementRef, ngZone: NgZone, templateHost: DxTemplateHost, _watcherHelper: WatcherHelper, optionHost: NestedOptionHost, transferState: TransferState, platformId: any);
    protected _createInstance(element: any, options: any): DxDraggable;
    ngOnDestroy(): void;
}
export declare class DxDraggableModule {
}
