"use strict";
/*!
 * devextreme-angular
 * Version: 19.2.3
 * Build date: Tue Oct 22 2019
 *
 * Copyright (c) 2012 - 2019 Developer Express Inc. ALL RIGHTS RESERVED
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file in the root of the project for details.
 *
 * https://github.com/DevExpress/devextreme-angular
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var platform_browser_1 = require("@angular/platform-browser");
var platform_browser_2 = require("@angular/platform-browser");
var core_1 = require("@angular/core");
var draggable_1 = require("devextreme/ui/draggable");
var component_1 = require("../core/component");
var template_host_1 = require("../core/template-host");
var integration_1 = require("../core/integration");
var template_1 = require("../core/template");
var nested_option_1 = require("../core/nested-option");
var watcher_helper_1 = require("../core/watcher-helper");
var cursor_offset_1 = require("./nested/cursor-offset");
/**
 * Draggable is a user interface utility that allows widget elements to be dragged and dropped.
 */
var DxDraggableComponent = /** @class */ (function (_super) {
    __extends(DxDraggableComponent, _super);
    function DxDraggableComponent(elementRef, ngZone, templateHost, _watcherHelper, optionHost, transferState, platformId) {
        var _this = _super.call(this, elementRef, ngZone, templateHost, _watcherHelper, transferState, platformId) || this;
        _this._createEventEmitters([
            { subscribe: 'disposing', emit: 'onDisposing' },
            { subscribe: 'dragEnd', emit: 'onDragEnd' },
            { subscribe: 'dragMove', emit: 'onDragMove' },
            { subscribe: 'dragStart', emit: 'onDragStart' },
            { subscribe: 'initialized', emit: 'onInitialized' },
            { subscribe: 'optionChanged', emit: 'onOptionChanged' },
            { emit: 'autoScrollChange' },
            { emit: 'boundaryChange' },
            { emit: 'cloneChange' },
            { emit: 'containerChange' },
            { emit: 'cursorOffsetChange' },
            { emit: 'dataChange' },
            { emit: 'dragDirectionChange' },
            { emit: 'dragTemplateChange' },
            { emit: 'elementAttrChange' },
            { emit: 'groupChange' },
            { emit: 'handleChange' },
            { emit: 'heightChange' },
            { emit: 'rtlEnabledChange' },
            { emit: 'scrollSensitivityChange' },
            { emit: 'scrollSpeedChange' },
            { emit: 'widthChange' }
        ]);
        optionHost.setHost(_this);
        return _this;
    }
    Object.defineProperty(DxDraggableComponent.prototype, "autoScroll", {
        /**
         * Enables automatic scrolling while dragging an item beyond the viewport.
         */
        get: function () {
            return this._getOption('autoScroll');
        },
        set: function (value) {
            this._setOption('autoScroll', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDraggableComponent.prototype, "boundary", {
        /**
         * Specifies a DOM element that limits the dragging area.
         */
        get: function () {
            return this._getOption('boundary');
        },
        set: function (value) {
            this._setOption('boundary', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDraggableComponent.prototype, "clone", {
        /**
         * Allows a user to drag clones of items instead of actual items.
         */
        get: function () {
            return this._getOption('clone');
        },
        set: function (value) {
            this._setOption('clone', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDraggableComponent.prototype, "container", {
        /**
         * Specifies a custom container in which the draggable item should be rendered.
         */
        get: function () {
            return this._getOption('container');
        },
        set: function (value) {
            this._setOption('container', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDraggableComponent.prototype, "cursorOffset", {
        /**
         * Specifies the cursor offset from the dragged item.
         */
        get: function () {
            return this._getOption('cursorOffset');
        },
        set: function (value) {
            this._setOption('cursorOffset', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDraggableComponent.prototype, "data", {
        /**
         * A container for custom data.
         */
        get: function () {
            return this._getOption('data');
        },
        set: function (value) {
            this._setOption('data', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDraggableComponent.prototype, "dragDirection", {
        /**
         * Specifies the directions in which an item can be dragged.
         */
        get: function () {
            return this._getOption('dragDirection');
        },
        set: function (value) {
            this._setOption('dragDirection', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDraggableComponent.prototype, "dragTemplate", {
        /**
         * Specifies custom markup to be shown instead of the item being dragged.
         */
        get: function () {
            return this._getOption('dragTemplate');
        },
        set: function (value) {
            this._setOption('dragTemplate', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDraggableComponent.prototype, "elementAttr", {
        /**
         * Specifies the attributes to be attached to the widget's root element.
         */
        get: function () {
            return this._getOption('elementAttr');
        },
        set: function (value) {
            this._setOption('elementAttr', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDraggableComponent.prototype, "group", {
        /**
         * Allows you to group several widgets, so that users can drag and drop items between them.
         */
        get: function () {
            return this._getOption('group');
        },
        set: function (value) {
            this._setOption('group', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDraggableComponent.prototype, "handle", {
        /**
         * Specifies a CSS selector (ID or class) that should act as the drag handle(s) for the item(s).
         */
        get: function () {
            return this._getOption('handle');
        },
        set: function (value) {
            this._setOption('handle', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDraggableComponent.prototype, "height", {
        /**
         * Specifies the widget's height.
         */
        get: function () {
            return this._getOption('height');
        },
        set: function (value) {
            this._setOption('height', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDraggableComponent.prototype, "rtlEnabled", {
        /**
         * Switches the widget to a right-to-left representation.
         */
        get: function () {
            return this._getOption('rtlEnabled');
        },
        set: function (value) {
            this._setOption('rtlEnabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDraggableComponent.prototype, "scrollSensitivity", {
        /**
         * Specifies the distance in pixels from the edge of viewport at which scrolling should start. Applies only if autoScroll is true.
         */
        get: function () {
            return this._getOption('scrollSensitivity');
        },
        set: function (value) {
            this._setOption('scrollSensitivity', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDraggableComponent.prototype, "scrollSpeed", {
        /**
         * Specifies the scrolling speed when dragging an item beyond the viewport. Applies only if autoScroll is true.
         */
        get: function () {
            return this._getOption('scrollSpeed');
        },
        set: function (value) {
            this._setOption('scrollSpeed', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDraggableComponent.prototype, "width", {
        /**
         * Specifies the widget's width.
         */
        get: function () {
            return this._getOption('width');
        },
        set: function (value) {
            this._setOption('width', value);
        },
        enumerable: true,
        configurable: true
    });
    DxDraggableComponent.prototype._createInstance = function (element, options) {
        return new draggable_1.default(element, options);
    };
    DxDraggableComponent.prototype.ngOnDestroy = function () {
        this._destroyWidget();
    };
    DxDraggableComponent.decorators = [
        { type: core_1.Component, args: [{
                    selector: 'dx-draggable',
                    template: '<ng-content></ng-content>',
                    providers: [
                        template_host_1.DxTemplateHost,
                        watcher_helper_1.WatcherHelper,
                        nested_option_1.NestedOptionHost
                    ]
                },] },
    ];
    /** @nocollapse */
    DxDraggableComponent.ctorParameters = function () { return [
        { type: core_1.ElementRef },
        { type: core_1.NgZone },
        { type: template_host_1.DxTemplateHost },
        { type: watcher_helper_1.WatcherHelper },
        { type: nested_option_1.NestedOptionHost },
        { type: platform_browser_2.TransferState },
        { type: undefined, decorators: [{ type: core_1.Inject, args: [core_1.PLATFORM_ID,] }] }
    ]; };
    DxDraggableComponent.propDecorators = {
        autoScroll: [{ type: core_1.Input }],
        boundary: [{ type: core_1.Input }],
        clone: [{ type: core_1.Input }],
        container: [{ type: core_1.Input }],
        cursorOffset: [{ type: core_1.Input }],
        data: [{ type: core_1.Input }],
        dragDirection: [{ type: core_1.Input }],
        dragTemplate: [{ type: core_1.Input }],
        elementAttr: [{ type: core_1.Input }],
        group: [{ type: core_1.Input }],
        handle: [{ type: core_1.Input }],
        height: [{ type: core_1.Input }],
        rtlEnabled: [{ type: core_1.Input }],
        scrollSensitivity: [{ type: core_1.Input }],
        scrollSpeed: [{ type: core_1.Input }],
        width: [{ type: core_1.Input }],
        onDisposing: [{ type: core_1.Output }],
        onDragEnd: [{ type: core_1.Output }],
        onDragMove: [{ type: core_1.Output }],
        onDragStart: [{ type: core_1.Output }],
        onInitialized: [{ type: core_1.Output }],
        onOptionChanged: [{ type: core_1.Output }],
        autoScrollChange: [{ type: core_1.Output }],
        boundaryChange: [{ type: core_1.Output }],
        cloneChange: [{ type: core_1.Output }],
        containerChange: [{ type: core_1.Output }],
        cursorOffsetChange: [{ type: core_1.Output }],
        dataChange: [{ type: core_1.Output }],
        dragDirectionChange: [{ type: core_1.Output }],
        dragTemplateChange: [{ type: core_1.Output }],
        elementAttrChange: [{ type: core_1.Output }],
        groupChange: [{ type: core_1.Output }],
        handleChange: [{ type: core_1.Output }],
        heightChange: [{ type: core_1.Output }],
        rtlEnabledChange: [{ type: core_1.Output }],
        scrollSensitivityChange: [{ type: core_1.Output }],
        scrollSpeedChange: [{ type: core_1.Output }],
        widthChange: [{ type: core_1.Output }]
    };
    return DxDraggableComponent;
}(component_1.DxComponent));
exports.DxDraggableComponent = DxDraggableComponent;
var DxDraggableModule = /** @class */ (function () {
    function DxDraggableModule() {
    }
    DxDraggableModule.decorators = [
        { type: core_1.NgModule, args: [{
                    imports: [
                        cursor_offset_1.DxoCursorOffsetModule,
                        integration_1.DxIntegrationModule,
                        template_1.DxTemplateModule,
                        platform_browser_1.BrowserTransferStateModule
                    ],
                    declarations: [
                        DxDraggableComponent
                    ],
                    exports: [
                        DxDraggableComponent,
                        cursor_offset_1.DxoCursorOffsetModule,
                        template_1.DxTemplateModule
                    ]
                },] },
    ];
    return DxDraggableModule;
}());
exports.DxDraggableModule = DxDraggableModule;
//# sourceMappingURL=draggable.js.map