"use strict";
/*!
 * devextreme-angular
 * Version: 19.2.3
 * Build date: Tue Oct 22 2019
 *
 * Copyright (c) 2012 - 2019 Developer Express Inc. ALL RIGHTS RESERVED
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file in the root of the project for details.
 *
 * https://github.com/DevExpress/devextreme-angular
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var platform_browser_1 = require("@angular/platform-browser");
var platform_browser_2 = require("@angular/platform-browser");
var core_1 = require("@angular/core");

var drop_down_button_1 = require("devextreme/ui/drop_down_button");
var component_1 = require("../core/component");
var template_host_1 = require("../core/template-host");
var integration_1 = require("../core/integration");
var template_1 = require("../core/template");
var nested_option_1 = require("../core/nested-option");
var watcher_helper_1 = require("../core/watcher-helper");
var iterable_differ_helper_1 = require("../core/iterable-differ-helper");
var drop_down_options_1 = require("./nested/drop-down-options");
var animation_1 = require("./nested/animation");
var hide_1 = require("./nested/hide");
var show_1 = require("./nested/show");
var position_1 = require("./nested/position");
var at_1 = require("./nested/at");
var boundary_offset_1 = require("./nested/boundary-offset");
var collision_1 = require("./nested/collision");
var my_1 = require("./nested/my");
var offset_1 = require("./nested/offset");
var toolbar_item_dxi_1 = require("./nested/toolbar-item-dxi");
var item_dxi_1 = require("./nested/item-dxi");
var item_dxi_2 = require("./nested/item-dxi");
/**
 * The DropDownButton is a button that opens a drop-down menu.
 */
var DxDropDownButtonComponent = /** @class */ (function (_super) {
    __extends(DxDropDownButtonComponent, _super);
    function DxDropDownButtonComponent(elementRef, ngZone, templateHost, _watcherHelper, _idh, optionHost, transferState, platformId) {
        var _this = _super.call(this, elementRef, ngZone, templateHost, _watcherHelper, transferState, platformId) || this;
        _this._watcherHelper = _watcherHelper;
        _this._idh = _idh;
        _this._createEventEmitters([
            { subscribe: 'buttonClick', emit: 'onButtonClick' },
            { subscribe: 'contentReady', emit: 'onContentReady' },
            { subscribe: 'disposing', emit: 'onDisposing' },
            { subscribe: 'initialized', emit: 'onInitialized' },
            { subscribe: 'itemClick', emit: 'onItemClick' },
            { subscribe: 'optionChanged', emit: 'onOptionChanged' },
            { subscribe: 'selectionChanged', emit: 'onSelectionChanged' },
            { emit: 'accessKeyChange' },
            { emit: 'activeStateEnabledChange' },
            { emit: 'dataSourceChange' },
            { emit: 'deferRenderingChange' },
            { emit: 'disabledChange' },
            { emit: 'displayExprChange' },
            { emit: 'dropDownContentTemplateChange' },
            { emit: 'dropDownOptionsChange' },
            { emit: 'elementAttrChange' },
            { emit: 'focusStateEnabledChange' },
            { emit: 'heightChange' },
            { emit: 'hintChange' },
            { emit: 'hoverStateEnabledChange' },
            { emit: 'iconChange' },
            { emit: 'itemsChange' },
            { emit: 'itemTemplateChange' },
            { emit: 'keyExprChange' },
            { emit: 'noDataTextChange' },
            { emit: 'openedChange' },
            { emit: 'rtlEnabledChange' },
            { emit: 'selectedItemChange' },
            { emit: 'selectedItemKeyChange' },
            { emit: 'showArrowIconChange' },
            { emit: 'splitButtonChange' },
            { emit: 'stylingModeChange' },
            { emit: 'tabIndexChange' },
            { emit: 'textChange' },
            { emit: 'useSelectModeChange' },
            { emit: 'visibleChange' },
            { emit: 'widthChange' },
            { emit: 'wrapItemTextChange' }
        ]);
        _this._idh.setHost(_this);
        optionHost.setHost(_this);
        return _this;
    }
    Object.defineProperty(DxDropDownButtonComponent.prototype, "accessKey", {
        /**
         * Specifies the shortcut key that sets focus on the widget.
         */
        get: function () {
            return this._getOption('accessKey');
        },
        set: function (value) {
            this._setOption('accessKey', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "activeStateEnabled", {
        /**
         * Specifies whether or not the widget changes its state when interacting with a user.
         */
        get: function () {
            return this._getOption('activeStateEnabled');
        },
        set: function (value) {
            this._setOption('activeStateEnabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "dataSource", {
        /**
         * Provides data for the drop-down menu.
         */
        get: function () {
            return this._getOption('dataSource');
        },
        set: function (value) {
            this._setOption('dataSource', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "deferRendering", {
        /**
         * Specifies whether to wait until the drop-down menu is opened the first time to render its content.
         */
        get: function () {
            return this._getOption('deferRendering');
        },
        set: function (value) {
            this._setOption('deferRendering', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "disabled", {
        /**
         * Specifies whether the widget responds to user interaction.
         */
        get: function () {
            return this._getOption('disabled');
        },
        set: function (value) {
            this._setOption('disabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "displayExpr", {
        /**
         * Specifies the data field whose values should be displayed in the drop-down menu.
         */
        get: function () {
            return this._getOption('displayExpr');
        },
        set: function (value) {
            this._setOption('displayExpr', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "dropDownContentTemplate", {
        /**
         * Specifies custom content for the drop-down field.
         */
        get: function () {
            return this._getOption('dropDownContentTemplate');
        },
        set: function (value) {
            this._setOption('dropDownContentTemplate', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "dropDownOptions", {
        /**
         * Configures the drop-down field.
         */
        get: function () {
            return this._getOption('dropDownOptions');
        },
        set: function (value) {
            this._setOption('dropDownOptions', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "elementAttr", {
        /**
         * Specifies the attributes to be attached to the widget's root element.
         */
        get: function () {
            return this._getOption('elementAttr');
        },
        set: function (value) {
            this._setOption('elementAttr', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "focusStateEnabled", {
        /**
         * Specifies whether users can use keyboard to focus the widget.
         */
        get: function () {
            return this._getOption('focusStateEnabled');
        },
        set: function (value) {
            this._setOption('focusStateEnabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "height", {
        /**
         * Specifies the widget's height.
         */
        get: function () {
            return this._getOption('height');
        },
        set: function (value) {
            this._setOption('height', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "hint", {
        /**
         * Specifies text for a hint that appears when a user pauses on the widget.
         */
        get: function () {
            return this._getOption('hint');
        },
        set: function (value) {
            this._setOption('hint', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "hoverStateEnabled", {
        /**
         * Specifies whether the widget changes its state when a user hovers the mouse pointer over it.
         */
        get: function () {
            return this._getOption('hoverStateEnabled');
        },
        set: function (value) {
            this._setOption('hoverStateEnabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "icon", {
        /**
         * Specifies the button's icon.
         */
        get: function () {
            return this._getOption('icon');
        },
        set: function (value) {
            this._setOption('icon', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "items", {
        /**
         * Provides drop-down menu items.
         */
        get: function () {
            return this._getOption('items');
        },
        set: function (value) {
            this._setOption('items', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "itemTemplate", {
        /**
         * Specifies a custom template for drop-down menu items.
         */
        get: function () {
            return this._getOption('itemTemplate');
        },
        set: function (value) {
            this._setOption('itemTemplate', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "keyExpr", {
        /**
         * Specifies which data field provides keys used to distinguish between the selected drop-down menu items.
         */
        get: function () {
            return this._getOption('keyExpr');
        },
        set: function (value) {
            this._setOption('keyExpr', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "noDataText", {
        /**
         * Specifies text or HTML markup displayed in the drop-down menu when it does not contain any items.
         */
        get: function () {
            return this._getOption('noDataText');
        },
        set: function (value) {
            this._setOption('noDataText', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "opened", {
        /**
         * Specifies whether the drop-down menu is opened.
         */
        get: function () {
            return this._getOption('opened');
        },
        set: function (value) {
            this._setOption('opened', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "rtlEnabled", {
        /**
         * Switches the widget to a right-to-left representation.
         */
        get: function () {
            return this._getOption('rtlEnabled');
        },
        set: function (value) {
            this._setOption('rtlEnabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "selectedItem", {
        /**
         * Contains the selected item's data. Available when useSelectMode is true.
         */
        get: function () {
            return this._getOption('selectedItem');
        },
        set: function (value) {
            this._setOption('selectedItem', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "selectedItemKey", {
        /**
         * Contains the selected item's key and allows you to specify the initially selected item. Applies when useSelectMode is true.
         */
        get: function () {
            return this._getOption('selectedItemKey');
        },
        set: function (value) {
            this._setOption('selectedItemKey', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "showArrowIcon", {
        /**
         * Specifies whether the arrow icon should be displayed.
         */
        get: function () {
            return this._getOption('showArrowIcon');
        },
        set: function (value) {
            this._setOption('showArrowIcon', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "splitButton", {
        /**
         * Specifies whether to split the button in two: one executes an action, the other opens and closes the drop-down menu.
         */
        get: function () {
            return this._getOption('splitButton');
        },
        set: function (value) {
            this._setOption('splitButton', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "stylingMode", {
        /**
         * Specifies how the button is styled.
         */
        get: function () {
            return this._getOption('stylingMode');
        },
        set: function (value) {
            this._setOption('stylingMode', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "tabIndex", {
        /**
         * Specifies the number of the element when the Tab key is used for navigating.
         */
        get: function () {
            return this._getOption('tabIndex');
        },
        set: function (value) {
            this._setOption('tabIndex', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "text", {
        /**
         * Specifies the button's text. Applies only if useSelectMode is false.
         */
        get: function () {
            return this._getOption('text');
        },
        set: function (value) {
            this._setOption('text', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "useSelectMode", {
        /**
         * Specifies whether the widget stores the selected drop-down menu item.
         */
        get: function () {
            return this._getOption('useSelectMode');
        },
        set: function (value) {
            this._setOption('useSelectMode', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "visible", {
        /**
         * Specifies whether the widget is visible.
         */
        get: function () {
            return this._getOption('visible');
        },
        set: function (value) {
            this._setOption('visible', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "width", {
        /**
         * Specifies the widget's width.
         */
        get: function () {
            return this._getOption('width');
        },
        set: function (value) {
            this._setOption('width', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "wrapItemText", {
        /**
         * Specifies whether text that exceeds the drop-down list width should be wrapped.
         */
        get: function () {
            return this._getOption('wrapItemText');
        },
        set: function (value) {
            this._setOption('wrapItemText', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxDropDownButtonComponent.prototype, "itemsChildren", {
        get: function () {
            return this._getOption('items');
        },
        set: function (value) {
            this.setChildren('items', value);
        },
        enumerable: true,
        configurable: true
    });
    DxDropDownButtonComponent.prototype._createInstance = function (element, options) {
        return new drop_down_button_1.default(element, options);
    };
    DxDropDownButtonComponent.prototype.ngOnDestroy = function () {
        this._destroyWidget();
    };
    DxDropDownButtonComponent.prototype.ngOnChanges = function (changes) {
        _super.prototype.ngOnChanges.call(this, changes);
        this.setupChanges('dataSource', changes);
        this.setupChanges('items', changes);
    };
    DxDropDownButtonComponent.prototype.setupChanges = function (prop, changes) {
        if (!(prop in this._optionsToUpdate)) {
            this._idh.setup(prop, changes);
        }
    };
    DxDropDownButtonComponent.prototype.ngDoCheck = function () {
        this._idh.doCheck('dataSource');
        this._idh.doCheck('items');
        this._watcherHelper.checkWatchers();
        _super.prototype.ngDoCheck.call(this);
        _super.prototype.clearChangedOptions.call(this);
    };
    DxDropDownButtonComponent.prototype._setOption = function (name, value) {
        var isSetup = this._idh.setupSingle(name, value);
        var isChanged = this._idh.getChanges(name, value) !== null;
        if (isSetup || isChanged) {
            _super.prototype._setOption.call(this, name, value);
        }
    };
    DxDropDownButtonComponent.decorators = [
        { type: core_1.Component, args: [{
                    selector: 'dx-drop-down-button',
                    template: '',
                    providers: [
                        template_host_1.DxTemplateHost,
                        watcher_helper_1.WatcherHelper,
                        nested_option_1.NestedOptionHost,
                        iterable_differ_helper_1.IterableDifferHelper
                    ]
                },] },
    ];
    /** @nocollapse */
    DxDropDownButtonComponent.ctorParameters = function () { return [
        { type: core_1.ElementRef },
        { type: core_1.NgZone },
        { type: template_host_1.DxTemplateHost },
        { type: watcher_helper_1.WatcherHelper },
        { type: iterable_differ_helper_1.IterableDifferHelper },
        { type: nested_option_1.NestedOptionHost },
        { type: platform_browser_2.TransferState },
        { type: undefined, decorators: [{ type: core_1.Inject, args: [core_1.PLATFORM_ID,] }] }
    ]; };
    DxDropDownButtonComponent.propDecorators = {
        accessKey: [{ type: core_1.Input }],
        activeStateEnabled: [{ type: core_1.Input }],
        dataSource: [{ type: core_1.Input }],
        deferRendering: [{ type: core_1.Input }],
        disabled: [{ type: core_1.Input }],
        displayExpr: [{ type: core_1.Input }],
        dropDownContentTemplate: [{ type: core_1.Input }],
        dropDownOptions: [{ type: core_1.Input }],
        elementAttr: [{ type: core_1.Input }],
        focusStateEnabled: [{ type: core_1.Input }],
        height: [{ type: core_1.Input }],
        hint: [{ type: core_1.Input }],
        hoverStateEnabled: [{ type: core_1.Input }],
        icon: [{ type: core_1.Input }],
        items: [{ type: core_1.Input }],
        itemTemplate: [{ type: core_1.Input }],
        keyExpr: [{ type: core_1.Input }],
        noDataText: [{ type: core_1.Input }],
        opened: [{ type: core_1.Input }],
        rtlEnabled: [{ type: core_1.Input }],
        selectedItem: [{ type: core_1.Input }],
        selectedItemKey: [{ type: core_1.Input }],
        showArrowIcon: [{ type: core_1.Input }],
        splitButton: [{ type: core_1.Input }],
        stylingMode: [{ type: core_1.Input }],
        tabIndex: [{ type: core_1.Input }],
        text: [{ type: core_1.Input }],
        useSelectMode: [{ type: core_1.Input }],
        visible: [{ type: core_1.Input }],
        width: [{ type: core_1.Input }],
        wrapItemText: [{ type: core_1.Input }],
        onButtonClick: [{ type: core_1.Output }],
        onContentReady: [{ type: core_1.Output }],
        onDisposing: [{ type: core_1.Output }],
        onInitialized: [{ type: core_1.Output }],
        onItemClick: [{ type: core_1.Output }],
        onOptionChanged: [{ type: core_1.Output }],
        onSelectionChanged: [{ type: core_1.Output }],
        accessKeyChange: [{ type: core_1.Output }],
        activeStateEnabledChange: [{ type: core_1.Output }],
        dataSourceChange: [{ type: core_1.Output }],
        deferRenderingChange: [{ type: core_1.Output }],
        disabledChange: [{ type: core_1.Output }],
        displayExprChange: [{ type: core_1.Output }],
        dropDownContentTemplateChange: [{ type: core_1.Output }],
        dropDownOptionsChange: [{ type: core_1.Output }],
        elementAttrChange: [{ type: core_1.Output }],
        focusStateEnabledChange: [{ type: core_1.Output }],
        heightChange: [{ type: core_1.Output }],
        hintChange: [{ type: core_1.Output }],
        hoverStateEnabledChange: [{ type: core_1.Output }],
        iconChange: [{ type: core_1.Output }],
        itemsChange: [{ type: core_1.Output }],
        itemTemplateChange: [{ type: core_1.Output }],
        keyExprChange: [{ type: core_1.Output }],
        noDataTextChange: [{ type: core_1.Output }],
        openedChange: [{ type: core_1.Output }],
        rtlEnabledChange: [{ type: core_1.Output }],
        selectedItemChange: [{ type: core_1.Output }],
        selectedItemKeyChange: [{ type: core_1.Output }],
        showArrowIconChange: [{ type: core_1.Output }],
        splitButtonChange: [{ type: core_1.Output }],
        stylingModeChange: [{ type: core_1.Output }],
        tabIndexChange: [{ type: core_1.Output }],
        textChange: [{ type: core_1.Output }],
        useSelectModeChange: [{ type: core_1.Output }],
        visibleChange: [{ type: core_1.Output }],
        widthChange: [{ type: core_1.Output }],
        wrapItemTextChange: [{ type: core_1.Output }],
        itemsChildren: [{ type: core_1.ContentChildren, args: [item_dxi_2.DxiItemComponent,] }]
    };
    return DxDropDownButtonComponent;
}(component_1.DxComponent));
exports.DxDropDownButtonComponent = DxDropDownButtonComponent;
var DxDropDownButtonModule = /** @class */ (function () {
    function DxDropDownButtonModule() {
    }
    DxDropDownButtonModule.decorators = [
        { type: core_1.NgModule, args: [{
                    imports: [
                        drop_down_options_1.DxoDropDownOptionsModule,
                        animation_1.DxoAnimationModule,
                        hide_1.DxoHideModule,
                        show_1.DxoShowModule,
                        position_1.DxoPositionModule,
                        at_1.DxoAtModule,
                        boundary_offset_1.DxoBoundaryOffsetModule,
                        collision_1.DxoCollisionModule,
                        my_1.DxoMyModule,
                        offset_1.DxoOffsetModule,
                        toolbar_item_dxi_1.DxiToolbarItemModule,
                        item_dxi_1.DxiItemModule,
                        integration_1.DxIntegrationModule,
                        template_1.DxTemplateModule,
                        platform_browser_1.BrowserTransferStateModule
                    ],
                    declarations: [
                        DxDropDownButtonComponent
                    ],
                    exports: [
                        DxDropDownButtonComponent,
                        drop_down_options_1.DxoDropDownOptionsModule,
                        animation_1.DxoAnimationModule,
                        hide_1.DxoHideModule,
                        show_1.DxoShowModule,
                        position_1.DxoPositionModule,
                        at_1.DxoAtModule,
                        boundary_offset_1.DxoBoundaryOffsetModule,
                        collision_1.DxoCollisionModule,
                        my_1.DxoMyModule,
                        offset_1.DxoOffsetModule,
                        toolbar_item_dxi_1.DxiToolbarItemModule,
                        item_dxi_1.DxiItemModule,
                        template_1.DxTemplateModule
                    ]
                },] },
    ];
    return DxDropDownButtonModule;
}());
exports.DxDropDownButtonModule = DxDropDownButtonModule;
//# sourceMappingURL=drop-down-button.js.map