"use strict";
/*!
 * devextreme-angular
 * Version: 19.2.3
 * Build date: Tue Oct 22 2019
 *
 * Copyright (c) 2012 - 2019 Developer Express Inc. ALL RIGHTS RESERVED
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file in the root of the project for details.
 *
 * https://github.com/DevExpress/devextreme-angular
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var platform_browser_1 = require("@angular/platform-browser");
var platform_browser_2 = require("@angular/platform-browser");
var core_1 = require("@angular/core");
var gantt_1 = require("devextreme/ui/gantt");
var component_1 = require("../core/component");
var template_host_1 = require("../core/template-host");
var integration_1 = require("../core/integration");
var template_1 = require("../core/template");
var nested_option_1 = require("../core/nested-option");
var watcher_helper_1 = require("../core/watcher-helper");
var iterable_differ_helper_1 = require("../core/iterable-differ-helper");
var column_dxi_1 = require("./nested/column-dxi");
var button_dxi_1 = require("./nested/button-dxi");
var header_filter_1 = require("./nested/header-filter");
var lookup_1 = require("./nested/lookup");
var format_1 = require("./nested/format");
var form_item_1 = require("./nested/form-item");
var label_1 = require("./nested/label");
var validation_rule_dxi_1 = require("./nested/validation-rule-dxi");
var dependencies_1 = require("./nested/dependencies");
var editing_1 = require("./nested/editing");
var resource_assignments_1 = require("./nested/resource-assignments");
var resources_1 = require("./nested/resources");
var tasks_1 = require("./nested/tasks");
var column_dxi_2 = require("./nested/column-dxi");
/**
 * [tags] ctp The Gantt is a widget that displays the task flow and dependencies between tasks. #include common-ctp-note with { component: "Gantt" }
 */
var DxGanttComponent = /** @class */ (function (_super) {
    __extends(DxGanttComponent, _super);
    function DxGanttComponent(elementRef, ngZone, templateHost, _watcherHelper, _idh, optionHost, transferState, platformId) {
        var _this = _super.call(this, elementRef, ngZone, templateHost, _watcherHelper, transferState, platformId) || this;
        _this._watcherHelper = _watcherHelper;
        _this._idh = _idh;
        _this._createEventEmitters([
            { subscribe: 'contentReady', emit: 'onContentReady' },
            { subscribe: 'disposing', emit: 'onDisposing' },
            { subscribe: 'initialized', emit: 'onInitialized' },
            { subscribe: 'optionChanged', emit: 'onOptionChanged' },
            { subscribe: 'selectionChanged', emit: 'onSelectionChanged' },
            { emit: 'accessKeyChange' },
            { emit: 'activeStateEnabledChange' },
            { emit: 'allowSelectionChange' },
            { emit: 'columnsChange' },
            { emit: 'dependenciesChange' },
            { emit: 'disabledChange' },
            { emit: 'editingChange' },
            { emit: 'elementAttrChange' },
            { emit: 'focusStateEnabledChange' },
            { emit: 'heightChange' },
            { emit: 'hintChange' },
            { emit: 'hoverStateEnabledChange' },
            { emit: 'resourceAssignmentsChange' },
            { emit: 'resourcesChange' },
            { emit: 'rtlEnabledChange' },
            { emit: 'scaleTypeChange' },
            { emit: 'selectedRowKeyChange' },
            { emit: 'showResourcesChange' },
            { emit: 'showRowLinesChange' },
            { emit: 'tabIndexChange' },
            { emit: 'taskListWidthChange' },
            { emit: 'tasksChange' },
            { emit: 'taskTitlePositionChange' },
            { emit: 'visibleChange' },
            { emit: 'widthChange' }
        ]);
        _this._idh.setHost(_this);
        optionHost.setHost(_this);
        return _this;
    }
    Object.defineProperty(DxGanttComponent.prototype, "accessKey", {
        /**
         * Specifies the shortcut key that sets focus on the widget.
         */
        get: function () {
            return this._getOption('accessKey');
        },
        set: function (value) {
            this._setOption('accessKey', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxGanttComponent.prototype, "activeStateEnabled", {
        /**
         * Specifies whether or not the widget changes its state when interacting with a user.
         */
        get: function () {
            return this._getOption('activeStateEnabled');
        },
        set: function (value) {
            this._setOption('activeStateEnabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxGanttComponent.prototype, "allowSelection", {
        /**
         * Specifies whether users can select tasks in the Gantt.
         */
        get: function () {
            return this._getOption('allowSelection');
        },
        set: function (value) {
            this._setOption('allowSelection', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxGanttComponent.prototype, "columns", {
        /**
         * An array of columns in the Gantt.
         */
        get: function () {
            return this._getOption('columns');
        },
        set: function (value) {
            this._setOption('columns', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxGanttComponent.prototype, "dependencies", {
        /**
         * Configures dependencies.
         */
        get: function () {
            return this._getOption('dependencies');
        },
        set: function (value) {
            this._setOption('dependencies', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxGanttComponent.prototype, "disabled", {
        /**
         * Specifies whether the widget responds to user interaction.
         */
        get: function () {
            return this._getOption('disabled');
        },
        set: function (value) {
            this._setOption('disabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxGanttComponent.prototype, "editing", {
        /**
         * Configures edit options.
         */
        get: function () {
            return this._getOption('editing');
        },
        set: function (value) {
            this._setOption('editing', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxGanttComponent.prototype, "elementAttr", {
        /**
         * Specifies the attributes to be attached to the widget's root element.
         */
        get: function () {
            return this._getOption('elementAttr');
        },
        set: function (value) {
            this._setOption('elementAttr', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxGanttComponent.prototype, "focusStateEnabled", {
        /**
         * Specifies whether the widget can be focused using keyboard navigation.
         */
        get: function () {
            return this._getOption('focusStateEnabled');
        },
        set: function (value) {
            this._setOption('focusStateEnabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxGanttComponent.prototype, "height", {
        /**
         * Specifies the widget's height.
         */
        get: function () {
            return this._getOption('height');
        },
        set: function (value) {
            this._setOption('height', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxGanttComponent.prototype, "hint", {
        /**
         * Specifies text for a hint that appears when a user pauses on the widget.
         */
        get: function () {
            return this._getOption('hint');
        },
        set: function (value) {
            this._setOption('hint', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxGanttComponent.prototype, "hoverStateEnabled", {
        /**
         * Specifies whether the widget changes its state when a user pauses on it.
         */
        get: function () {
            return this._getOption('hoverStateEnabled');
        },
        set: function (value) {
            this._setOption('hoverStateEnabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxGanttComponent.prototype, "resourceAssignments", {
        /**
         * Configures resource assignments.
         */
        get: function () {
            return this._getOption('resourceAssignments');
        },
        set: function (value) {
            this._setOption('resourceAssignments', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxGanttComponent.prototype, "resources", {
        /**
         * Configures task resources.
         */
        get: function () {
            return this._getOption('resources');
        },
        set: function (value) {
            this._setOption('resources', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxGanttComponent.prototype, "rtlEnabled", {
        /**
         * Switches the widget to a right-to-left representation.
         */
        get: function () {
            return this._getOption('rtlEnabled');
        },
        set: function (value) {
            this._setOption('rtlEnabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxGanttComponent.prototype, "scaleType", {
        /**
         * Specifies the zoom level of tasks in the Gantt chart.
         */
        get: function () {
            return this._getOption('scaleType');
        },
        set: function (value) {
            this._setOption('scaleType', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxGanttComponent.prototype, "selectedRowKey", {
        /**
         * Allows you to select a row or determine which row is selected.
         */
        get: function () {
            return this._getOption('selectedRowKey');
        },
        set: function (value) {
            this._setOption('selectedRowKey', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxGanttComponent.prototype, "showResources", {
        /**
         * Specifies whether to display task resources.
         */
        get: function () {
            return this._getOption('showResources');
        },
        set: function (value) {
            this._setOption('showResources', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxGanttComponent.prototype, "showRowLines", {
        /**
         * Specifies whether to show/hide horizontal faint lines that separate tasks.
         */
        get: function () {
            return this._getOption('showRowLines');
        },
        set: function (value) {
            this._setOption('showRowLines', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxGanttComponent.prototype, "tabIndex", {
        /**
         * Specifies the number of the element when the Tab key is used for navigating.
         */
        get: function () {
            return this._getOption('tabIndex');
        },
        set: function (value) {
            this._setOption('tabIndex', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxGanttComponent.prototype, "taskListWidth", {
        /**
         * Specifies the width of the task list in pixels.
         */
        get: function () {
            return this._getOption('taskListWidth');
        },
        set: function (value) {
            this._setOption('taskListWidth', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxGanttComponent.prototype, "tasks", {
        /**
         * Configures tasks.
         */
        get: function () {
            return this._getOption('tasks');
        },
        set: function (value) {
            this._setOption('tasks', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxGanttComponent.prototype, "taskTitlePosition", {
        /**
         * Specifies a task's title position.
         */
        get: function () {
            return this._getOption('taskTitlePosition');
        },
        set: function (value) {
            this._setOption('taskTitlePosition', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxGanttComponent.prototype, "visible", {
        /**
         * Specifies whether the widget is visible.
         */
        get: function () {
            return this._getOption('visible');
        },
        set: function (value) {
            this._setOption('visible', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxGanttComponent.prototype, "width", {
        /**
         * Specifies the widget's width.
         */
        get: function () {
            return this._getOption('width');
        },
        set: function (value) {
            this._setOption('width', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxGanttComponent.prototype, "columnsChildren", {
        get: function () {
            return this._getOption('columns');
        },
        set: function (value) {
            this.setChildren('columns', value);
        },
        enumerable: true,
        configurable: true
    });
    DxGanttComponent.prototype._createInstance = function (element, options) {
        return new gantt_1.default(element, options);
    };
    DxGanttComponent.prototype.ngOnDestroy = function () {
        this._destroyWidget();
    };
    DxGanttComponent.prototype.ngOnChanges = function (changes) {
        _super.prototype.ngOnChanges.call(this, changes);
        this.setupChanges('columns', changes);
    };
    DxGanttComponent.prototype.setupChanges = function (prop, changes) {
        if (!(prop in this._optionsToUpdate)) {
            this._idh.setup(prop, changes);
        }
    };
    DxGanttComponent.prototype.ngDoCheck = function () {
        this._idh.doCheck('columns');
        this._watcherHelper.checkWatchers();
        _super.prototype.ngDoCheck.call(this);
        _super.prototype.clearChangedOptions.call(this);
    };
    DxGanttComponent.prototype._setOption = function (name, value) {
        var isSetup = this._idh.setupSingle(name, value);
        var isChanged = this._idh.getChanges(name, value) !== null;
        if (isSetup || isChanged) {
            _super.prototype._setOption.call(this, name, value);
        }
    };
    DxGanttComponent.decorators = [
        { type: core_1.Component, args: [{
                    selector: 'dx-gantt',
                    template: '',
                    providers: [
                        template_host_1.DxTemplateHost,
                        watcher_helper_1.WatcherHelper,
                        nested_option_1.NestedOptionHost,
                        iterable_differ_helper_1.IterableDifferHelper
                    ]
                },] },
    ];
    /** @nocollapse */
    DxGanttComponent.ctorParameters = function () { return [
        { type: core_1.ElementRef },
        { type: core_1.NgZone },
        { type: template_host_1.DxTemplateHost },
        { type: watcher_helper_1.WatcherHelper },
        { type: iterable_differ_helper_1.IterableDifferHelper },
        { type: nested_option_1.NestedOptionHost },
        { type: platform_browser_2.TransferState },
        { type: undefined, decorators: [{ type: core_1.Inject, args: [core_1.PLATFORM_ID,] }] }
    ]; };
    DxGanttComponent.propDecorators = {
        accessKey: [{ type: core_1.Input }],
        activeStateEnabled: [{ type: core_1.Input }],
        allowSelection: [{ type: core_1.Input }],
        columns: [{ type: core_1.Input }],
        dependencies: [{ type: core_1.Input }],
        disabled: [{ type: core_1.Input }],
        editing: [{ type: core_1.Input }],
        elementAttr: [{ type: core_1.Input }],
        focusStateEnabled: [{ type: core_1.Input }],
        height: [{ type: core_1.Input }],
        hint: [{ type: core_1.Input }],
        hoverStateEnabled: [{ type: core_1.Input }],
        resourceAssignments: [{ type: core_1.Input }],
        resources: [{ type: core_1.Input }],
        rtlEnabled: [{ type: core_1.Input }],
        scaleType: [{ type: core_1.Input }],
        selectedRowKey: [{ type: core_1.Input }],
        showResources: [{ type: core_1.Input }],
        showRowLines: [{ type: core_1.Input }],
        tabIndex: [{ type: core_1.Input }],
        taskListWidth: [{ type: core_1.Input }],
        tasks: [{ type: core_1.Input }],
        taskTitlePosition: [{ type: core_1.Input }],
        visible: [{ type: core_1.Input }],
        width: [{ type: core_1.Input }],
        onContentReady: [{ type: core_1.Output }],
        onDisposing: [{ type: core_1.Output }],
        onInitialized: [{ type: core_1.Output }],
        onOptionChanged: [{ type: core_1.Output }],
        onSelectionChanged: [{ type: core_1.Output }],
        accessKeyChange: [{ type: core_1.Output }],
        activeStateEnabledChange: [{ type: core_1.Output }],
        allowSelectionChange: [{ type: core_1.Output }],
        columnsChange: [{ type: core_1.Output }],
        dependenciesChange: [{ type: core_1.Output }],
        disabledChange: [{ type: core_1.Output }],
        editingChange: [{ type: core_1.Output }],
        elementAttrChange: [{ type: core_1.Output }],
        focusStateEnabledChange: [{ type: core_1.Output }],
        heightChange: [{ type: core_1.Output }],
        hintChange: [{ type: core_1.Output }],
        hoverStateEnabledChange: [{ type: core_1.Output }],
        resourceAssignmentsChange: [{ type: core_1.Output }],
        resourcesChange: [{ type: core_1.Output }],
        rtlEnabledChange: [{ type: core_1.Output }],
        scaleTypeChange: [{ type: core_1.Output }],
        selectedRowKeyChange: [{ type: core_1.Output }],
        showResourcesChange: [{ type: core_1.Output }],
        showRowLinesChange: [{ type: core_1.Output }],
        tabIndexChange: [{ type: core_1.Output }],
        taskListWidthChange: [{ type: core_1.Output }],
        tasksChange: [{ type: core_1.Output }],
        taskTitlePositionChange: [{ type: core_1.Output }],
        visibleChange: [{ type: core_1.Output }],
        widthChange: [{ type: core_1.Output }],
        columnsChildren: [{ type: core_1.ContentChildren, args: [column_dxi_2.DxiColumnComponent,] }]
    };
    return DxGanttComponent;
}(component_1.DxComponent));
exports.DxGanttComponent = DxGanttComponent;
var DxGanttModule = /** @class */ (function () {
    function DxGanttModule() {
    }
    DxGanttModule.decorators = [
        { type: core_1.NgModule, args: [{
                    imports: [
                        column_dxi_1.DxiColumnModule,
                        button_dxi_1.DxiButtonModule,
                        header_filter_1.DxoHeaderFilterModule,
                        lookup_1.DxoLookupModule,
                        format_1.DxoFormatModule,
                        form_item_1.DxoFormItemModule,
                        label_1.DxoLabelModule,
                        validation_rule_dxi_1.DxiValidationRuleModule,
                        dependencies_1.DxoDependenciesModule,
                        editing_1.DxoEditingModule,
                        resource_assignments_1.DxoResourceAssignmentsModule,
                        resources_1.DxoResourcesModule,
                        tasks_1.DxoTasksModule,
                        integration_1.DxIntegrationModule,
                        template_1.DxTemplateModule,
                        platform_browser_1.BrowserTransferStateModule
                    ],
                    declarations: [
                        DxGanttComponent
                    ],
                    exports: [
                        DxGanttComponent,
                        column_dxi_1.DxiColumnModule,
                        button_dxi_1.DxiButtonModule,
                        header_filter_1.DxoHeaderFilterModule,
                        lookup_1.DxoLookupModule,
                        format_1.DxoFormatModule,
                        form_item_1.DxoFormItemModule,
                        label_1.DxoLabelModule,
                        validation_rule_dxi_1.DxiValidationRuleModule,
                        dependencies_1.DxoDependenciesModule,
                        editing_1.DxoEditingModule,
                        resource_assignments_1.DxoResourceAssignmentsModule,
                        resources_1.DxoResourcesModule,
                        tasks_1.DxoTasksModule,
                        template_1.DxTemplateModule
                    ]
                },] },
    ];
    return DxGanttModule;
}());
exports.DxGanttModule = DxGanttModule;
//# sourceMappingURL=gantt.js.map