"use strict";
/*!
 * devextreme-angular
 * Version: 19.2.3
 * Build date: Tue Oct 22 2019
 *
 * Copyright (c) 2012 - 2019 Developer Express Inc. ALL RIGHTS RESERVED
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file in the root of the project for details.
 *
 * https://github.com/DevExpress/devextreme-angular
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var platform_browser_1 = require("@angular/platform-browser");
var platform_browser_2 = require("@angular/platform-browser");
var core_1 = require("@angular/core");

var html_editor_1 = require("devextreme/ui/html_editor");
var validator_1 = require("./validator");
var forms_1 = require("@angular/forms");
var component_1 = require("../core/component");
var template_host_1 = require("../core/template-host");
var integration_1 = require("../core/integration");
var template_1 = require("../core/template");
var nested_option_1 = require("../core/nested-option");
var watcher_helper_1 = require("../core/watcher-helper");
var iterable_differ_helper_1 = require("../core/iterable-differ-helper");
var media_resizing_1 = require("./nested/media-resizing");
var mention_dxi_1 = require("./nested/mention-dxi");
var toolbar_1 = require("./nested/toolbar");
var item_dxi_1 = require("./nested/item-dxi");
var variables_1 = require("./nested/variables");
var mention_dxi_2 = require("./nested/mention-dxi");
var CUSTOM_VALUE_ACCESSOR_PROVIDER = {
    provide: forms_1.NG_VALUE_ACCESSOR,
    useExisting: core_1.forwardRef(function () { return DxHtmlEditorComponent; }),
    multi: true
};
/**
 * [tags] ctp HtmlEditor is a WYSIWYG editor that allows you to format textual and visual content and to output it in HTML or Markdown. HtmlEditor is built on top of and requires Quill. #include common-ctp-note with { component: "HtmlEditor" }
 */
var DxHtmlEditorComponent = /** @class */ (function (_super) {
    __extends(DxHtmlEditorComponent, _super);
    function DxHtmlEditorComponent(elementRef, ngZone, templateHost, _watcherHelper, _idh, optionHost, transferState, platformId) {
        var _this = _super.call(this, elementRef, ngZone, templateHost, _watcherHelper, transferState, platformId) || this;
        _this._watcherHelper = _watcherHelper;
        _this._idh = _idh;
        _this.touched = function (_) { };
        _this._createEventEmitters([
            { subscribe: 'contentReady', emit: 'onContentReady' },
            { subscribe: 'disposing', emit: 'onDisposing' },
            { subscribe: 'focusIn', emit: 'onFocusIn' },
            { subscribe: 'focusOut', emit: 'onFocusOut' },
            { subscribe: 'initialized', emit: 'onInitialized' },
            { subscribe: 'optionChanged', emit: 'onOptionChanged' },
            { subscribe: 'valueChanged', emit: 'onValueChanged' },
            { emit: 'accessKeyChange' },
            { emit: 'activeStateEnabledChange' },
            { emit: 'customizeModulesChange' },
            { emit: 'disabledChange' },
            { emit: 'elementAttrChange' },
            { emit: 'focusStateEnabledChange' },
            { emit: 'heightChange' },
            { emit: 'hintChange' },
            { emit: 'hoverStateEnabledChange' },
            { emit: 'isValidChange' },
            { emit: 'mediaResizingChange' },
            { emit: 'mentionsChange' },
            { emit: 'nameChange' },
            { emit: 'placeholderChange' },
            { emit: 'readOnlyChange' },
            { emit: 'rtlEnabledChange' },
            { emit: 'tabIndexChange' },
            { emit: 'toolbarChange' },
            { emit: 'validationErrorChange' },
            { emit: 'validationErrorsChange' },
            { emit: 'validationMessageModeChange' },
            { emit: 'validationStatusChange' },
            { emit: 'valueChange' },
            { emit: 'valueTypeChange' },
            { emit: 'variablesChange' },
            { emit: 'visibleChange' },
            { emit: 'widthChange' },
            { emit: 'onBlur' }
        ]);
        _this._idh.setHost(_this);
        optionHost.setHost(_this);
        return _this;
    }
    Object.defineProperty(DxHtmlEditorComponent.prototype, "accessKey", {
        /**
         * Specifies the shortcut key that sets focus on the widget.
         */
        get: function () {
            return this._getOption('accessKey');
        },
        set: function (value) {
            this._setOption('accessKey', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxHtmlEditorComponent.prototype, "activeStateEnabled", {
        /**
         * Specifies whether or not the widget changes its state when interacting with a user.
         */
        get: function () {
            return this._getOption('activeStateEnabled');
        },
        set: function (value) {
            this._setOption('activeStateEnabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxHtmlEditorComponent.prototype, "customizeModules", {
        /**
         * Allows you to customize Quill and 3rd-party modules.
         */
        get: function () {
            return this._getOption('customizeModules');
        },
        set: function (value) {
            this._setOption('customizeModules', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxHtmlEditorComponent.prototype, "disabled", {
        /**
         * Specifies whether the widget responds to user interaction.
         */
        get: function () {
            return this._getOption('disabled');
        },
        set: function (value) {
            this._setOption('disabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxHtmlEditorComponent.prototype, "elementAttr", {
        /**
         * Specifies the attributes to be attached to the widget's root element.
         */
        get: function () {
            return this._getOption('elementAttr');
        },
        set: function (value) {
            this._setOption('elementAttr', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxHtmlEditorComponent.prototype, "focusStateEnabled", {
        /**
         * Specifies whether the widget can be focused using keyboard navigation.
         */
        get: function () {
            return this._getOption('focusStateEnabled');
        },
        set: function (value) {
            this._setOption('focusStateEnabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxHtmlEditorComponent.prototype, "height", {
        /**
         * Specifies the widget's height.
         */
        get: function () {
            return this._getOption('height');
        },
        set: function (value) {
            this._setOption('height', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxHtmlEditorComponent.prototype, "hint", {
        /**
         * Specifies text for a hint that appears when a user pauses on the widget.
         */
        get: function () {
            return this._getOption('hint');
        },
        set: function (value) {
            this._setOption('hint', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxHtmlEditorComponent.prototype, "hoverStateEnabled", {
        /**
         * Specifies whether the widget changes its state when a user pauses on it.
         */
        get: function () {
            return this._getOption('hoverStateEnabled');
        },
        set: function (value) {
            this._setOption('hoverStateEnabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxHtmlEditorComponent.prototype, "isValid", {
        /**
         * Specifies or indicates whether the editor's value is valid.
         */
        get: function () {
            return this._getOption('isValid');
        },
        set: function (value) {
            this._setOption('isValid', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxHtmlEditorComponent.prototype, "mediaResizing", {
        /**
         * Configures media resizing.
         */
        get: function () {
            return this._getOption('mediaResizing');
        },
        set: function (value) {
            this._setOption('mediaResizing', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxHtmlEditorComponent.prototype, "mentions", {
        /**
         * Configures mentions.
         */
        get: function () {
            return this._getOption('mentions');
        },
        set: function (value) {
            this._setOption('mentions', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxHtmlEditorComponent.prototype, "name", {
        /**
         * The value to be assigned to the `name` attribute of the underlying HTML element.
         */
        get: function () {
            return this._getOption('name');
        },
        set: function (value) {
            this._setOption('name', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxHtmlEditorComponent.prototype, "placeholder", {
        /**
         * Specifies the text displayed when the input field is empty.
         */
        get: function () {
            return this._getOption('placeholder');
        },
        set: function (value) {
            this._setOption('placeholder', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxHtmlEditorComponent.prototype, "readOnly", {
        /**
         * Specifies whether the editor is read-only.
         */
        get: function () {
            return this._getOption('readOnly');
        },
        set: function (value) {
            this._setOption('readOnly', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxHtmlEditorComponent.prototype, "rtlEnabled", {
        /**
         * Switches the widget to a right-to-left representation.
         */
        get: function () {
            return this._getOption('rtlEnabled');
        },
        set: function (value) {
            this._setOption('rtlEnabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxHtmlEditorComponent.prototype, "tabIndex", {
        /**
         * Specifies the number of the element when the Tab key is used for navigating.
         */
        get: function () {
            return this._getOption('tabIndex');
        },
        set: function (value) {
            this._setOption('tabIndex', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxHtmlEditorComponent.prototype, "toolbar", {
        /**
         * Configures the widget's toolbar.
         */
        get: function () {
            return this._getOption('toolbar');
        },
        set: function (value) {
            this._setOption('toolbar', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxHtmlEditorComponent.prototype, "validationError", {
        /**
         * Information on the broken validation rule. Contains the first item from the validationErrors array.
         */
        get: function () {
            return this._getOption('validationError');
        },
        set: function (value) {
            this._setOption('validationError', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxHtmlEditorComponent.prototype, "validationErrors", {
        /**
         * An array of the validation rules that failed.
         */
        get: function () {
            return this._getOption('validationErrors');
        },
        set: function (value) {
            this._setOption('validationErrors', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxHtmlEditorComponent.prototype, "validationMessageMode", {
        /**
         * Specifies how the message about the validation rules that are not satisfied by this editor's value is displayed.
         */
        get: function () {
            return this._getOption('validationMessageMode');
        },
        set: function (value) {
            this._setOption('validationMessageMode', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxHtmlEditorComponent.prototype, "validationStatus", {
        /**
         * Indicates or specifies the current validation status.
         */
        get: function () {
            return this._getOption('validationStatus');
        },
        set: function (value) {
            this._setOption('validationStatus', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxHtmlEditorComponent.prototype, "value", {
        /**
         * Specifies the widget's value.
         */
        get: function () {
            return this._getOption('value');
        },
        set: function (value) {
            this._setOption('value', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxHtmlEditorComponent.prototype, "valueType", {
        /**
         * Specifies in which markup language the value is stored.
         */
        get: function () {
            return this._getOption('valueType');
        },
        set: function (value) {
            this._setOption('valueType', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxHtmlEditorComponent.prototype, "variables", {
        /**
         * Configures variables, which are placeholders to be replaced with actual values when processing text.
         */
        get: function () {
            return this._getOption('variables');
        },
        set: function (value) {
            this._setOption('variables', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxHtmlEditorComponent.prototype, "visible", {
        /**
         * Specifies whether the widget is visible.
         */
        get: function () {
            return this._getOption('visible');
        },
        set: function (value) {
            this._setOption('visible', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxHtmlEditorComponent.prototype, "width", {
        /**
         * Specifies the widget's width.
         */
        get: function () {
            return this._getOption('width');
        },
        set: function (value) {
            this._setOption('width', value);
        },
        enumerable: true,
        configurable: true
    });
    DxHtmlEditorComponent.prototype.change = function (_) { };
    Object.defineProperty(DxHtmlEditorComponent.prototype, "mentionsChildren", {
        get: function () {
            return this._getOption('mentions');
        },
        set: function (value) {
            this.setChildren('mentions', value);
        },
        enumerable: true,
        configurable: true
    });
    DxHtmlEditorComponent.prototype._createInstance = function (element, options) {
        return new html_editor_1.default(element, options);
    };
    DxHtmlEditorComponent.prototype.writeValue = function (value) {
        this.eventHelper.lockedValueChangeEvent = true;
        this.value = value;
        this.eventHelper.lockedValueChangeEvent = false;
    };
    DxHtmlEditorComponent.prototype.setDisabledState = function (isDisabled) {
        this.disabled = isDisabled;
    };
    DxHtmlEditorComponent.prototype.registerOnChange = function (fn) { this.change = fn; };
    DxHtmlEditorComponent.prototype.registerOnTouched = function (fn) { this.touched = fn; };
    DxHtmlEditorComponent.prototype._createWidget = function (element) {
        var _this = this;
        _super.prototype._createWidget.call(this, element);
        this.instance.on('focusOut', function (e) {
            _this.eventHelper.fireNgEvent('onBlur', [e]);
        });
    };
    DxHtmlEditorComponent.prototype.ngOnDestroy = function () {
        this._destroyWidget();
    };
    DxHtmlEditorComponent.prototype.ngOnChanges = function (changes) {
        _super.prototype.ngOnChanges.call(this, changes);
        this.setupChanges('mentions', changes);
        this.setupChanges('validationErrors', changes);
    };
    DxHtmlEditorComponent.prototype.setupChanges = function (prop, changes) {
        if (!(prop in this._optionsToUpdate)) {
            this._idh.setup(prop, changes);
        }
    };
    DxHtmlEditorComponent.prototype.ngDoCheck = function () {
        this._idh.doCheck('mentions');
        this._idh.doCheck('validationErrors');
        this._watcherHelper.checkWatchers();
        _super.prototype.ngDoCheck.call(this);
        _super.prototype.clearChangedOptions.call(this);
    };
    DxHtmlEditorComponent.prototype._setOption = function (name, value) {
        var isSetup = this._idh.setupSingle(name, value);
        var isChanged = this._idh.getChanges(name, value) !== null;
        if (isSetup || isChanged) {
            _super.prototype._setOption.call(this, name, value);
        }
    };
    DxHtmlEditorComponent.prototype.ngOnInit = function () {
        _super.prototype.ngOnInit.call(this);
        if (this.validator) {
            this.validator.createInstanceOnInit = false;
        }
    };
    DxHtmlEditorComponent.prototype.ngAfterViewInit = function () {
        _super.prototype.ngAfterViewInit.call(this);
        if (this.validator) {
            this.validator.createInstance(this.element.nativeElement);
        }
    };
    DxHtmlEditorComponent.decorators = [
        { type: core_1.Component, args: [{
                    selector: 'dx-html-editor',
                    template: '<ng-content></ng-content>',
                    providers: [
                        template_host_1.DxTemplateHost,
                        watcher_helper_1.WatcherHelper,
                        CUSTOM_VALUE_ACCESSOR_PROVIDER,
                        nested_option_1.NestedOptionHost,
                        iterable_differ_helper_1.IterableDifferHelper
                    ]
                },] },
    ];
    /** @nocollapse */
    DxHtmlEditorComponent.ctorParameters = function () { return [
        { type: core_1.ElementRef },
        { type: core_1.NgZone },
        { type: template_host_1.DxTemplateHost },
        { type: watcher_helper_1.WatcherHelper },
        { type: iterable_differ_helper_1.IterableDifferHelper },
        { type: nested_option_1.NestedOptionHost },
        { type: platform_browser_2.TransferState },
        { type: undefined, decorators: [{ type: core_1.Inject, args: [core_1.PLATFORM_ID,] }] }
    ]; };
    DxHtmlEditorComponent.propDecorators = {
        validator: [{ type: core_1.ContentChild, args: [validator_1.DxValidatorComponent,] }],
        accessKey: [{ type: core_1.Input }],
        activeStateEnabled: [{ type: core_1.Input }],
        customizeModules: [{ type: core_1.Input }],
        disabled: [{ type: core_1.Input }],
        elementAttr: [{ type: core_1.Input }],
        focusStateEnabled: [{ type: core_1.Input }],
        height: [{ type: core_1.Input }],
        hint: [{ type: core_1.Input }],
        hoverStateEnabled: [{ type: core_1.Input }],
        isValid: [{ type: core_1.Input }],
        mediaResizing: [{ type: core_1.Input }],
        mentions: [{ type: core_1.Input }],
        name: [{ type: core_1.Input }],
        placeholder: [{ type: core_1.Input }],
        readOnly: [{ type: core_1.Input }],
        rtlEnabled: [{ type: core_1.Input }],
        tabIndex: [{ type: core_1.Input }],
        toolbar: [{ type: core_1.Input }],
        validationError: [{ type: core_1.Input }],
        validationErrors: [{ type: core_1.Input }],
        validationMessageMode: [{ type: core_1.Input }],
        validationStatus: [{ type: core_1.Input }],
        value: [{ type: core_1.Input }],
        valueType: [{ type: core_1.Input }],
        variables: [{ type: core_1.Input }],
        visible: [{ type: core_1.Input }],
        width: [{ type: core_1.Input }],
        onContentReady: [{ type: core_1.Output }],
        onDisposing: [{ type: core_1.Output }],
        onFocusIn: [{ type: core_1.Output }],
        onFocusOut: [{ type: core_1.Output }],
        onInitialized: [{ type: core_1.Output }],
        onOptionChanged: [{ type: core_1.Output }],
        onValueChanged: [{ type: core_1.Output }],
        accessKeyChange: [{ type: core_1.Output }],
        activeStateEnabledChange: [{ type: core_1.Output }],
        customizeModulesChange: [{ type: core_1.Output }],
        disabledChange: [{ type: core_1.Output }],
        elementAttrChange: [{ type: core_1.Output }],
        focusStateEnabledChange: [{ type: core_1.Output }],
        heightChange: [{ type: core_1.Output }],
        hintChange: [{ type: core_1.Output }],
        hoverStateEnabledChange: [{ type: core_1.Output }],
        isValidChange: [{ type: core_1.Output }],
        mediaResizingChange: [{ type: core_1.Output }],
        mentionsChange: [{ type: core_1.Output }],
        nameChange: [{ type: core_1.Output }],
        placeholderChange: [{ type: core_1.Output }],
        readOnlyChange: [{ type: core_1.Output }],
        rtlEnabledChange: [{ type: core_1.Output }],
        tabIndexChange: [{ type: core_1.Output }],
        toolbarChange: [{ type: core_1.Output }],
        validationErrorChange: [{ type: core_1.Output }],
        validationErrorsChange: [{ type: core_1.Output }],
        validationMessageModeChange: [{ type: core_1.Output }],
        validationStatusChange: [{ type: core_1.Output }],
        valueChange: [{ type: core_1.Output }],
        valueTypeChange: [{ type: core_1.Output }],
        variablesChange: [{ type: core_1.Output }],
        visibleChange: [{ type: core_1.Output }],
        widthChange: [{ type: core_1.Output }],
        onBlur: [{ type: core_1.Output }],
        change: [{ type: core_1.HostListener, args: ['valueChange', ['$event'],] }],
        touched: [{ type: core_1.HostListener, args: ['onBlur', ['$event'],] }],
        mentionsChildren: [{ type: core_1.ContentChildren, args: [mention_dxi_2.DxiMentionComponent,] }]
    };
    return DxHtmlEditorComponent;
}(component_1.DxComponent));
exports.DxHtmlEditorComponent = DxHtmlEditorComponent;
var DxHtmlEditorModule = /** @class */ (function () {
    function DxHtmlEditorModule() {
    }
    DxHtmlEditorModule.decorators = [
        { type: core_1.NgModule, args: [{
                    imports: [
                        media_resizing_1.DxoMediaResizingModule,
                        mention_dxi_1.DxiMentionModule,
                        toolbar_1.DxoToolbarModule,
                        item_dxi_1.DxiItemModule,
                        variables_1.DxoVariablesModule,
                        integration_1.DxIntegrationModule,
                        template_1.DxTemplateModule,
                        platform_browser_1.BrowserTransferStateModule
                    ],
                    declarations: [
                        DxHtmlEditorComponent
                    ],
                    exports: [
                        DxHtmlEditorComponent,
                        media_resizing_1.DxoMediaResizingModule,
                        mention_dxi_1.DxiMentionModule,
                        toolbar_1.DxoToolbarModule,
                        item_dxi_1.DxiItemModule,
                        variables_1.DxoVariablesModule,
                        template_1.DxTemplateModule
                    ]
                },] },
    ];
    return DxHtmlEditorModule;
}());
exports.DxHtmlEditorModule = DxHtmlEditorModule;
//# sourceMappingURL=html-editor.js.map