/*!
 * devextreme-angular
 * Version: 19.2.3
 * Build date: Tue Oct 22 2019
 *
 * Copyright (c) 2012 - 2019 Developer Express Inc. ALL RIGHTS RESERVED
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file in the root of the project for details.
 *
 * https://github.com/DevExpress/devextreme-angular
 */
import { TransferState } from '@angular/platform-browser';
import { ElementRef, NgZone, OnDestroy, EventEmitter } from '@angular/core';
import DxSortable from 'devextreme/ui/sortable';
import { DxComponent } from '../core/component';
import { DxTemplateHost } from '../core/template-host';
import { NestedOptionHost } from '../core/nested-option';
import { WatcherHelper } from '../core/watcher-helper';
/**
 * Sortable is a user interface utility that allows a widget's items to be reordered via drag and drop gestures.
 */
export declare class DxSortableComponent extends DxComponent implements OnDestroy {
    instance: DxSortable;
    /**
     * Allows a user to drop an item inside another item.
     */
    allowDropInsideItem: boolean;
    /**
     * Allows a user to reorder sortable items.
     */
    allowReordering: boolean;
    /**
     * Enables automatic scrolling while dragging an item beyond the viewport.
     */
    autoScroll: boolean;
    /**
     * Specifies a DOM element that limits the dragging area.
     */
    boundary: Element | JQuery;
    /**
     * Specifies a custom container in which the draggable item should be rendered.
     */
    container: Element | JQuery;
    /**
     * Specifies the cursor offset from the dragged item.
     */
    cursorOffset: string | {
        x?: number;
        y?: number;
    };
    /**
     * A container for custom data.
     */
    data: any;
    /**
     * Specifies the directions in which an item can be dragged.
     */
    dragDirection: string;
    /**
     * Specifies custom markup to be shown instead of the item being dragged.
     */
    dragTemplate: any;
    /**
     * Specifies how to highlight the item's drop position.
     */
    dropFeedbackMode: string;
    /**
     * Specifies the attributes to be attached to the widget's root element.
     */
    elementAttr: any;
    /**
     * Specifies a CSS selector for the items that can be dragged.
     */
    filter: string;
    /**
     * Allows you to group several widgets, so that users can drag and drop items between them.
     */
    group: string;
    /**
     * Specifies a CSS selector (ID or class) that should act as the drag handle(s) for the item(s).
     */
    handle: string;
    /**
     * Specifies the widget's height.
     */
    height: number | Function | string;
    /**
     * Notifies the widget of the items' orientation.
     */
    itemOrientation: string;
    /**
     * Moves an element in the HTML markup when it is dropped.
     */
    moveItemOnDrop: boolean;
    /**
     * Switches the widget to a right-to-left representation.
     */
    rtlEnabled: boolean;
    /**
     * Specifies the distance in pixels from the edge of viewport at which scrolling should start. Applies only if autoScroll is true.
     */
    scrollSensitivity: number;
    /**
     * Specifies the scrolling speed when dragging an item beyond the viewport. Applies only if autoScroll is true.
     */
    scrollSpeed: number;
    /**
     * Specifies the widget's width.
     */
    width: number | Function | string;
    /**
     * A function that is called when a new item is added.
     */
    onAdd: EventEmitter<any>;
    /**
     * A function that is executed before the widget is disposed of.
     */
    onDisposing: EventEmitter<any>;
    /**
     * A function that is called when the dragged item's position in the list is changed.
     */
    onDragChange: EventEmitter<any>;
    /**
     * A function that is called when the drag gesture is finished.
     */
    onDragEnd: EventEmitter<any>;
    /**
     * A function that is called every time a draggable item is moved.
     */
    onDragMove: EventEmitter<any>;
    /**
     * A function that is called when drag gesture is initialized.
     */
    onDragStart: EventEmitter<any>;
    /**
     * A function used in JavaScript frameworks to save the widget instance.
     */
    onInitialized: EventEmitter<any>;
    /**
     * A function that is executed after a widget option is changed.
     */
    onOptionChanged: EventEmitter<any>;
    /**
     * A function that is called when a draggable item is removed.
     */
    onRemove: EventEmitter<any>;
    /**
     * A function that is called when the draggable items are reordered.
     */
    onReorder: EventEmitter<any>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    allowDropInsideItemChange: EventEmitter<boolean>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    allowReorderingChange: EventEmitter<boolean>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    autoScrollChange: EventEmitter<boolean>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    boundaryChange: EventEmitter<Element | JQuery>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    containerChange: EventEmitter<Element | JQuery>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    cursorOffsetChange: EventEmitter<string | {
        x?: number;
        y?: number;
    }>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    dataChange: EventEmitter<any>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    dragDirectionChange: EventEmitter<string>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    dragTemplateChange: EventEmitter<any>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    dropFeedbackModeChange: EventEmitter<string>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    elementAttrChange: EventEmitter<any>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    filterChange: EventEmitter<string>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    groupChange: EventEmitter<string>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    handleChange: EventEmitter<string>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    heightChange: EventEmitter<number | Function | string>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    itemOrientationChange: EventEmitter<string>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    moveItemOnDropChange: EventEmitter<boolean>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    rtlEnabledChange: EventEmitter<boolean>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    scrollSensitivityChange: EventEmitter<number>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    scrollSpeedChange: EventEmitter<number>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    widthChange: EventEmitter<number | Function | string>;
    constructor(elementRef: ElementRef, ngZone: NgZone, templateHost: DxTemplateHost, _watcherHelper: WatcherHelper, optionHost: NestedOptionHost, transferState: TransferState, platformId: any);
    protected _createInstance(element: any, options: any): DxSortable;
    ngOnDestroy(): void;
}
export declare class DxSortableModule {
}
