"use strict";
/*!
 * devextreme-angular
 * Version: 19.2.3
 * Build date: Tue Oct 22 2019
 *
 * Copyright (c) 2012 - 2019 Developer Express Inc. ALL RIGHTS RESERVED
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file in the root of the project for details.
 *
 * https://github.com/DevExpress/devextreme-angular
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var platform_browser_1 = require("@angular/platform-browser");
var platform_browser_2 = require("@angular/platform-browser");
var core_1 = require("@angular/core");
var validation_summary_1 = require("devextreme/ui/validation_summary");
var component_1 = require("../core/component");
var template_host_1 = require("../core/template-host");
var integration_1 = require("../core/integration");
var template_1 = require("../core/template");
var nested_option_1 = require("../core/nested-option");
var watcher_helper_1 = require("../core/watcher-helper");
var iterable_differ_helper_1 = require("../core/iterable-differ-helper");
var item_dxi_1 = require("./nested/item-dxi");
var item_dxi_2 = require("./nested/item-dxi");
/**
 * A widget for displaying the result of checking validation rules for editors.
 */
var DxValidationSummaryComponent = /** @class */ (function (_super) {
    __extends(DxValidationSummaryComponent, _super);
    function DxValidationSummaryComponent(elementRef, ngZone, templateHost, _watcherHelper, _idh, optionHost, transferState, platformId) {
        var _this = _super.call(this, elementRef, ngZone, templateHost, _watcherHelper, transferState, platformId) || this;
        _this._watcherHelper = _watcherHelper;
        _this._idh = _idh;
        _this._createEventEmitters([
            { subscribe: 'contentReady', emit: 'onContentReady' },
            { subscribe: 'disposing', emit: 'onDisposing' },
            { subscribe: 'initialized', emit: 'onInitialized' },
            { subscribe: 'itemClick', emit: 'onItemClick' },
            { subscribe: 'optionChanged', emit: 'onOptionChanged' },
            { emit: 'elementAttrChange' },
            { emit: 'hoverStateEnabledChange' },
            { emit: 'itemsChange' },
            { emit: 'itemTemplateChange' },
            { emit: 'validationGroupChange' }
        ]);
        _this._idh.setHost(_this);
        optionHost.setHost(_this);
        return _this;
    }
    Object.defineProperty(DxValidationSummaryComponent.prototype, "elementAttr", {
        /**
         * Specifies the attributes to be attached to the widget's root element.
         */
        get: function () {
            return this._getOption('elementAttr');
        },
        set: function (value) {
            this._setOption('elementAttr', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxValidationSummaryComponent.prototype, "hoverStateEnabled", {
        /**
         * Specifies whether the widget changes its state when a user pauses on it.
         */
        get: function () {
            return this._getOption('hoverStateEnabled');
        },
        set: function (value) {
            this._setOption('hoverStateEnabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxValidationSummaryComponent.prototype, "items", {
        /**
         * An array of items displayed by the widget.
         */
        get: function () {
            return this._getOption('items');
        },
        set: function (value) {
            this._setOption('items', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxValidationSummaryComponent.prototype, "itemTemplate", {
        /**
         * Specifies a custom template for items.
         */
        get: function () {
            return this._getOption('itemTemplate');
        },
        set: function (value) {
            this._setOption('itemTemplate', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxValidationSummaryComponent.prototype, "validationGroup", {
        /**
         * Specifies the validation group for which summary should be generated.
         */
        get: function () {
            return this._getOption('validationGroup');
        },
        set: function (value) {
            this._setOption('validationGroup', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxValidationSummaryComponent.prototype, "itemsChildren", {
        get: function () {
            return this._getOption('items');
        },
        set: function (value) {
            this.setChildren('items', value);
        },
        enumerable: true,
        configurable: true
    });
    DxValidationSummaryComponent.prototype._createInstance = function (element, options) {
        return new validation_summary_1.default(element, options);
    };
    DxValidationSummaryComponent.prototype.ngOnDestroy = function () {
        this._destroyWidget();
    };
    DxValidationSummaryComponent.prototype.ngOnChanges = function (changes) {
        _super.prototype.ngOnChanges.call(this, changes);
        this.setupChanges('items', changes);
    };
    DxValidationSummaryComponent.prototype.setupChanges = function (prop, changes) {
        if (!(prop in this._optionsToUpdate)) {
            this._idh.setup(prop, changes);
        }
    };
    DxValidationSummaryComponent.prototype.ngDoCheck = function () {
        this._idh.doCheck('items');
        this._watcherHelper.checkWatchers();
        _super.prototype.ngDoCheck.call(this);
        _super.prototype.clearChangedOptions.call(this);
    };
    DxValidationSummaryComponent.prototype._setOption = function (name, value) {
        var isSetup = this._idh.setupSingle(name, value);
        var isChanged = this._idh.getChanges(name, value) !== null;
        if (isSetup || isChanged) {
            _super.prototype._setOption.call(this, name, value);
        }
    };
    DxValidationSummaryComponent.decorators = [
        { type: core_1.Component, args: [{
                    selector: 'dx-validation-summary',
                    template: '',
                    providers: [
                        template_host_1.DxTemplateHost,
                        watcher_helper_1.WatcherHelper,
                        nested_option_1.NestedOptionHost,
                        iterable_differ_helper_1.IterableDifferHelper
                    ]
                },] },
    ];
    /** @nocollapse */
    DxValidationSummaryComponent.ctorParameters = function () { return [
        { type: core_1.ElementRef },
        { type: core_1.NgZone },
        { type: template_host_1.DxTemplateHost },
        { type: watcher_helper_1.WatcherHelper },
        { type: iterable_differ_helper_1.IterableDifferHelper },
        { type: nested_option_1.NestedOptionHost },
        { type: platform_browser_2.TransferState },
        { type: undefined, decorators: [{ type: core_1.Inject, args: [core_1.PLATFORM_ID,] }] }
    ]; };
    DxValidationSummaryComponent.propDecorators = {
        elementAttr: [{ type: core_1.Input }],
        hoverStateEnabled: [{ type: core_1.Input }],
        items: [{ type: core_1.Input }],
        itemTemplate: [{ type: core_1.Input }],
        validationGroup: [{ type: core_1.Input }],
        onContentReady: [{ type: core_1.Output }],
        onDisposing: [{ type: core_1.Output }],
        onInitialized: [{ type: core_1.Output }],
        onItemClick: [{ type: core_1.Output }],
        onOptionChanged: [{ type: core_1.Output }],
        elementAttrChange: [{ type: core_1.Output }],
        hoverStateEnabledChange: [{ type: core_1.Output }],
        itemsChange: [{ type: core_1.Output }],
        itemTemplateChange: [{ type: core_1.Output }],
        validationGroupChange: [{ type: core_1.Output }],
        itemsChildren: [{ type: core_1.ContentChildren, args: [item_dxi_2.DxiItemComponent,] }]
    };
    return DxValidationSummaryComponent;
}(component_1.DxComponent));
exports.DxValidationSummaryComponent = DxValidationSummaryComponent;
var DxValidationSummaryModule = /** @class */ (function () {
    function DxValidationSummaryModule() {
    }
    DxValidationSummaryModule.decorators = [
        { type: core_1.NgModule, args: [{
                    imports: [
                        item_dxi_1.DxiItemModule,
                        integration_1.DxIntegrationModule,
                        template_1.DxTemplateModule,
                        platform_browser_1.BrowserTransferStateModule
                    ],
                    declarations: [
                        DxValidationSummaryComponent
                    ],
                    exports: [
                        DxValidationSummaryComponent,
                        item_dxi_1.DxiItemModule,
                        template_1.DxTemplateModule
                    ]
                },] },
    ];
    return DxValidationSummaryModule;
}());
exports.DxValidationSummaryModule = DxValidationSummaryModule;
//# sourceMappingURL=validation-summary.js.map