"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const testing_1 = require("@angular-devkit/schematics/testing");
const path = require("path");
const collectionPath = path.join(__dirname, '../collection.json');
const appOptions = {
    name: 'testApp',
    projectRoot: '',
    inlineStyle: false,
    inlineTemplate: false,
    routing: true,
    style: 'css',
    skipTests: false,
    skipPackageJson: false
};
const workspaceOptions = {
    name: 'workspace',
    version: '6.0.0'
};
const angularSchematicsCollection = require.resolve('../../node_modules/@schematics/angular/collection.json');
const schematicRunner = new testing_1.SchematicTestRunner('@schematics/angular', angularSchematicsCollection);
let appTree;
beforeEach(() => __awaiter(void 0, void 0, void 0, function* () {
    appTree = yield schematicRunner.runSchematicAsync('workspace', workspaceOptions).toPromise();
    appTree = yield schematicRunner.runSchematicAsync('application', appOptions, appTree).toPromise();
}));
describe('add-app-template', () => {
    it('should add DevExtreme', () => __awaiter(void 0, void 0, void 0, function* () {
        const runner = new testing_1.SchematicTestRunner('schematics', collectionPath);
        const tree = yield runner.runSchematicAsync('add-app-template', {}, appTree).toPromise();
        const packageConfig = JSON.parse(tree.readContent('package.json'));
        expect('devextreme' in packageConfig.dependencies).toBe(true);
    }));
    it('should consider the `project` option', () => __awaiter(void 0, void 0, void 0, function* () {
        appTree = yield schematicRunner.runSchematicAsync('application', {
            name: 'testApp2',
            inlineStyle: false,
            inlineTemplate: false,
            routing: true,
            style: 'scss',
            projectRoot: 'projects/testApp2'
        }, appTree).toPromise();
        const runner = new testing_1.SchematicTestRunner('schematics', collectionPath);
        const tree = yield runner.runSchematicAsync('add-app-template', {
            project: 'testApp2'
        }, appTree).toPromise();
        expect(tree.files)
            .toContain('/devextreme.json');
        expect(tree.files)
            .toContain('/projects/testApp2/src/themes/metadata.base.json');
        expect(tree.files)
            .toContain('/projects/testApp2/src/app/pages/home/home.component.ts');
    }));
    it('should consider the `updateBudgets` option', () => __awaiter(void 0, void 0, void 0, function* () {
        const runner = new testing_1.SchematicTestRunner('schematics', collectionPath);
        const tree = yield runner.runSchematicAsync('add-app-template', { updateBudgets: true }, appTree).toPromise();
        const angularContent = JSON.parse(tree.readContent('/angular.json'));
        const budgets = angularContent.projects.testApp.architect.build.configurations.production.budgets;
        expect(budgets[0].maximumWarning).toEqual('4mb');
    }));
});
//# sourceMappingURL=index_spec.js.map