"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const schematics_1 = require("@angular-devkit/schematics");
const core_1 = require("@angular-devkit/core");
const path_1 = require("path");
const semver_1 = require("semver");
const project_1 = require("../utility/project");
const string_1 = require("../utility/string");
const styles_1 = require("../utility/styles");
const modify_json_file_1 = require("../utility/modify-json-file");
const dependencies_1 = require("@schematics/angular/utility/dependencies");
const source_1 = require("../utility/source");
const change_1 = require("../utility/change");
const routing_1 = require("../utility/routing");
const ast_utils_1 = require("@schematics/angular/utility/ast-utils");
const workspace_1 = require("@schematics/angular/utility/workspace");
const patch_1 = require("../utility/patch");
const projectFilesSource = './files/src';
const workspaceFilesSource = './files';
function addScriptSafe(scripts, name, value) {
    const currentValue = scripts[name];
    if (!currentValue) {
        scripts[name] = value;
        return;
    }
    const alterName = `origin-${name}`;
    const safeValue = `npm run ${alterName} && ${value}`;
    if (currentValue === value || currentValue === safeValue) {
        return;
    }
    scripts[alterName] = currentValue;
    scripts[name] = safeValue;
}
function addBuildThemeScript() {
    return (host) => {
        (0, modify_json_file_1.modifyJSONFile)(host, './package.json', config => {
            const scripts = config['scripts'];
            addScriptSafe(scripts, 'build-themes', 'devextreme build');
            addScriptSafe(scripts, 'postinstall', 'npm run build-themes');
            return config;
        });
        return host;
    };
}
function addCustomThemeStyles(host, options, sourcePath = '') {
    return __awaiter(this, void 0, void 0, function* () {
        const projectName = yield (0, project_1.getProjectName)(host, options.project);
        (0, modify_json_file_1.modifyJSONFile)(host, './angular.json', config => {
            const stylesList = [
                `${sourcePath}/dx-styles.scss`,
                `${sourcePath}/themes/generated/theme.additional.css`,
                `${sourcePath}/themes/generated/theme.base.css`,
                'node_modules/devextreme/dist/css/dx.common.css'
            ];
            return (0, styles_1.addStylesToApp)(projectName, config, stylesList);
        });
        return host;
    });
}
function updateBudgets(host, options) {
    return __awaiter(this, void 0, void 0, function* () {
        const projectName = yield (0, project_1.getProjectName)(host, options.project);
        (0, modify_json_file_1.modifyJSONFile)(host, './angular.json', config => {
            const budgets = config.projects[projectName].architect.build.configurations.production.budgets;
            const budget = budgets.find((item) => item.type === 'initial');
            if (budget) {
                budget.maximumWarning = '4mb';
                budget.maximumError = '7mb';
            }
            return config;
        });
        return host;
    });
}
function addViewportToBody(sourcePath = '') {
    return (host) => {
        const indexPath = (0, path_1.join)(sourcePath, 'index.html');
        let indexContent = host.read(indexPath).toString();
        indexContent = indexContent.replace(/<body>/, '<body class="dx-viewport">');
        host.overwrite(indexPath, indexContent);
        return host;
    };
}
function modifyFileRule(path, callback) {
    return (host) => {
        const source = (0, source_1.getSourceFile)(host, path);
        if (!source) {
            return host;
        }
        const changes = callback(source);
        return (0, change_1.applyChanges)(host, changes, path);
    };
}
function updateAppModule(host, sourcePath) {
    const appModulePath = sourcePath + 'app.module.ts';
    const importSetter = (importName, path) => {
        return (source) => {
            return (0, ast_utils_1.addImportToModule)(source, appModulePath, importName, path);
        };
    };
    const providerSetter = (importName, path) => {
        return (source) => {
            return (0, ast_utils_1.addProviderToModule)(source, appModulePath, importName, path);
        };
    };
    const rules = [
        modifyFileRule(appModulePath, importSetter('SideNavOuterToolbarModule', './layouts')),
        modifyFileRule(appModulePath, importSetter('SideNavInnerToolbarModule', './layouts')),
        modifyFileRule(appModulePath, importSetter('SingleCardModule', './layouts')),
        modifyFileRule(appModulePath, importSetter('FooterModule', './shared/components')),
        modifyFileRule(appModulePath, importSetter('ResetPasswordFormModule', './shared/components')),
        modifyFileRule(appModulePath, importSetter('CreateAccountFormModule', './shared/components')),
        modifyFileRule(appModulePath, importSetter('ChangePasswordFormModule', './shared/components')),
        modifyFileRule(appModulePath, importSetter('LoginFormModule', './shared/components')),
        modifyFileRule(appModulePath, providerSetter('AuthService', './shared/services')),
        modifyFileRule(appModulePath, providerSetter('ScreenService', './shared/services')),
        modifyFileRule(appModulePath, providerSetter('AppInfoService', './shared/services')),
        modifyFileRule(appModulePath, importSetter('UnauthenticatedContentModule', './unauthenticated-content')),
    ];
    if (!hasRoutingModule(host, sourcePath)) {
        rules.push(modifyFileRule(appModulePath, importSetter('AppRoutingModule', './app-routing.module')));
    }
    return (0, schematics_1.chain)(rules);
}
function getComponentName(host, sourcePath) {
    let name = '';
    const index = 1;
    if (!host.exists(sourcePath + 'app.component.ts')) {
        name = 'app';
    }
    while (!name) {
        const componentName = `app${index}`;
        if (!host.exists(`${sourcePath}${componentName}.component.ts`)) {
            name = componentName;
        }
    }
    return name;
}
function hasRoutingModule(host, sourcePath) {
    return host.exists(sourcePath + 'app-routing.module.ts');
}
function addPackagesToDependency(globalNgCliVersion) {
    const version = new semver_1.SemVer(globalNgCliVersion.replace(/\^|\~/g, ''));
    return (host) => {
        (0, dependencies_1.addPackageJsonDependency)(host, {
            type: dependencies_1.NodeDependencyType.Default,
            name: '@angular/cdk',
            version: `~${version.major}.${version.minor}.0`
        });
        return host;
    };
}
function modifyContentByTemplate(sourcePath = '', templateSourcePath, filePath, templateOptions = {}, modifyContent) {
    return (host, context) => {
        const modifyIfExists = (fileEntry) => {
            const fileEntryPath = (0, path_1.join)(sourcePath, fileEntry.path.toString());
            if (!host.exists(fileEntryPath)) {
                return fileEntry;
            }
            const templateContent = fileEntry.content.toString();
            let modifiedContent = templateContent;
            const currentContent = host.read(fileEntryPath).toString();
            if (modifyContent) {
                modifiedContent = modifyContent(templateContent, currentContent, fileEntryPath);
            }
            // NOTE: Workaround for https://github.com/angular/angular-cli/issues/11337
            if (modifiedContent !== currentContent) {
                host.overwrite(fileEntryPath, modifiedContent);
            }
            return null;
        };
        const rules = [
            (0, schematics_1.filter)(path => {
                return !filePath || (0, path_1.join)('./', path) === (0, path_1.join)('./', filePath);
            }),
            (0, schematics_1.template)(templateOptions),
            (0, schematics_1.forEach)(modifyIfExists),
            (0, schematics_1.move)(sourcePath)
        ];
        const modifiedSource = (0, schematics_1.apply)((0, schematics_1.url)(templateSourcePath), rules);
        const resultRule = (0, schematics_1.mergeWith)(modifiedSource);
        return (0, schematics_1.callRule)(resultRule, host, context);
    };
}
function updateDevextremeConfig(sourcePath = '') {
    const devextremeConfigPath = '/devextreme.json';
    const templateOptions = {
        sourcePath
    };
    const modifyConfig = (templateContent, currentContent) => {
        const oldConfig = JSON.parse(currentContent);
        const newConfig = JSON.parse(templateContent);
        [].push.apply(oldConfig.build.commands, newConfig.build.commands);
        return JSON.stringify(oldConfig, null, '  ');
    };
    return modifyContentByTemplate('./', workspaceFilesSource, devextremeConfigPath, templateOptions, modifyConfig);
}
const modifyRoutingModule = (host, routingModulePath) => {
    // TODO: Try to use the isolated host to generate the result string
    let source = (0, source_1.getSourceFile)(host, routingModulePath);
    const importChange = (0, ast_utils_1.insertImport)(source, routingModulePath, 'LoginFormComponent', './shared/components');
    const providerChanges = (0, ast_utils_1.addProviderToModule)(source, routingModulePath, 'AuthGuardService', './shared/services');
    (0, change_1.applyChanges)(host, [importChange, ...providerChanges], routingModulePath);
    source = (0, source_1.getSourceFile)(host, routingModulePath);
    const routes = (0, routing_1.findRoutesInSource)(source);
    if (!(0, routing_1.hasComponentInRoutes)(routes, 'login-form')) {
        const loginFormRoute = (0, routing_1.getRoute)('login-form');
        (0, change_1.insertItemToArray)(host, routingModulePath, routes, loginFormRoute);
    }
};
function default_1(options) {
    return (host) => __awaiter(this, void 0, void 0, function* () {
        const ngConfig = host.read('./angular.json').toString();
        const defaultProjectName = (0, modify_json_file_1.parseJson)(ngConfig).defaultProject;
        const project = yield (0, project_1.getProjectName)(host, options.project);
        const workspace = yield (0, workspace_1.getWorkspace)(host);
        const ngProject = workspace.projects.get(project);
        const prefix = ngProject === null || ngProject === void 0 ? void 0 : ngProject.prefix;
        const title = (0, string_1.humanize)(project);
        const appPath = yield (0, project_1.getApplicationPath)(host, project);
        const sourcePath = yield (0, project_1.getSourceRootPath)(host, project);
        const layout = options.layout;
        const override = options.resolveConflicts === 'override';
        const componentName = override ? 'app' : getComponentName(host, appPath);
        const pathToCss = sourcePath === null || sourcePath === void 0 ? void 0 : sourcePath.replace(/\/?(\w)+\/?/g, '../');
        const templateOptions = {
            name: componentName,
            layout,
            title,
            strings: core_1.strings,
            path: pathToCss,
            prefix
        };
        const modifyContent = (templateContent, currentContent, filePath) => {
            if ((0, path_1.basename)(filePath) === 'styles.scss') {
                return `${currentContent}\n${templateContent}`;
            }
            if ((0, path_1.basename)(filePath) === 'app-routing.module.ts' && hasRoutingModule(host, appPath)) {
                modifyRoutingModule(host, filePath);
                return currentContent;
            }
            return templateContent;
        };
        const rules = [
            modifyContentByTemplate(sourcePath, projectFilesSource, null, templateOptions, modifyContent),
            updateDevextremeConfig(sourcePath),
            updateAppModule(host, appPath),
            addBuildThemeScript(),
            () => addCustomThemeStyles(host, options, sourcePath),
            addViewportToBody(sourcePath),
            addPackagesToDependency(options.globalNgCliVersion)
        ];
        if (options.updateBudgets) {
            rules.push(() => updateBudgets(host, options));
        }
        if (!options.skipInstall) {
            rules.push((_, context) => {
                context.addTask(new patch_1.PatchNodePackageInstallTask());
            });
        }
        if (override) {
            if (project === defaultProjectName) {
                rules.push(modifyContentByTemplate('./', workspaceFilesSource, 'e2e/src/app.e2e-spec.ts', { title }));
                rules.push(modifyContentByTemplate('./', workspaceFilesSource, 'e2e/src/app.po.ts'));
            }
        }
        return (0, schematics_1.chain)(rules);
    });
}
exports.default = default_1;
//# sourceMappingURL=index.js.map