"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const testing_1 = require("@angular-devkit/schematics/testing");
const path = require("path");
const collectionPath = path.join(__dirname, '../collection.json');
describe('view', () => {
    const appOptions = {
        name: 'testApp',
        projectRoot: '',
        inlineStyle: false,
        inlineTemplate: false,
        routing: true,
        style: 'css',
        skipTests: false,
        skipPackageJson: false
    };
    const workspaceOptions = {
        name: 'workspace',
        version: '6.0.0'
    };
    const componentOptions = {
        name: 'test',
        inlineStyle: false,
        inlineTemplate: false,
        changeDetection: 'Default',
        styleext: 'css',
        skipImport: true,
        module: undefined,
        export: false,
        project: 'testApp'
    };
    const angularSchematicsCollection = require.resolve('../../node_modules/@schematics/angular/collection.json');
    const schematicRunner = new testing_1.SchematicTestRunner('@schematics/angular', angularSchematicsCollection);
    let appTree;
    beforeEach(() => __awaiter(void 0, void 0, void 0, function* () {
        appTree = yield schematicRunner.runSchematicAsync('workspace', workspaceOptions).toPromise();
        appTree = yield schematicRunner.runSchematicAsync('application', appOptions, appTree).toPromise();
    }));
    it('should create new view', () => __awaiter(void 0, void 0, void 0, function* () {
        const runner = new testing_1.SchematicTestRunner('schematics', collectionPath);
        let tree = yield runner.runSchematicAsync('add-layout', { layout: 'side-nav-outer-toolbar' }, appTree).toPromise();
        tree = yield runner.runSchematicAsync('add-view', componentOptions, appTree).toPromise();
        expect(tree.files).toContain('/src/app/pages/test/test.component.ts');
        expect(tree.files).toContain('/src/app/pages/test/test.component.html');
        const content = tree.readContent('/src/app/pages/test/test.component.html');
        expect(content).toMatch(/<h2 class="content-block">Test<\/h2>/);
    }));
    it('should add view to default routing module', () => __awaiter(void 0, void 0, void 0, function* () {
        const options = Object.assign(Object.assign({}, componentOptions), { addRoute: true });
        const runner = new testing_1.SchematicTestRunner('schematics', collectionPath);
        let tree = yield runner.runSchematicAsync('add-layout', { layout: 'side-nav-outer-toolbar' }, appTree).toPromise();
        tree = yield runner.runSchematicAsync('add-view', options, tree).toPromise();
        tree = yield runner.runSchematicAsync('add-view', Object.assign(Object.assign({}, options), { name: 'test2' }), tree).toPromise();
        const moduleContent = tree.readContent('/src/app/app-routing.module.ts');
        expect(moduleContent).toContain(`const routes: Routes = [
  {
    path: 'pages/test2',
    component: Test2Component,
    canActivate: [ AuthGuardService ]
  },
  {
    path: 'pages/test',
    component: TestComponent,
    canActivate: [ AuthGuardService ]
  },
  {
    path: 'login-form',
    component: LoginFormComponent,
    canActivate: [ AuthGuardService ]
  },
  {
    path: '**',
    redirectTo: 'pages/test'
  }
];`);
    }));
    it('should add view to other routing module', () => __awaiter(void 0, void 0, void 0, function* () {
        const options = Object.assign(Object.assign({}, componentOptions), { addRoute: true, module: 'test/test-routing' });
        const runner = new testing_1.SchematicTestRunner('schematics', collectionPath);
        let tree = yield runner.runExternalSchematicAsync('@schematics/angular', 'module', {
            name: 'test',
            routing: true,
            project: 'testApp'
        }, appTree).toPromise();
        tree = yield runner.runSchematicAsync('add-layout', {
            layout: 'side-nav-outer-toolbar',
            project: 'testApp',
            name: 'test'
        }, tree).toPromise();
        tree = yield runner.runSchematicAsync('add-view', options, tree).toPromise();
        const moduleContent = tree.readContent('/src/app/test/test-routing.module.ts');
        expect(moduleContent).toMatch(/component: TestComponent/);
        expect(moduleContent).toMatch(/path: 'pages\/test'/);
        expect(moduleContent).toContain('canActivate: [ AuthGuardService ]');
    }));
    it('should add view to navigation', () => __awaiter(void 0, void 0, void 0, function* () {
        const runner = new testing_1.SchematicTestRunner('schematics', collectionPath);
        let tree = yield runner.runSchematicAsync('add-layout', { layout: 'side-nav-outer-toolbar' }, appTree).toPromise();
        tree = yield runner.runSchematicAsync('add-view', componentOptions, tree).toPromise();
        componentOptions.name = 'some test';
        componentOptions.icon = 'home';
        tree = yield runner.runSchematicAsync('add-view', componentOptions, tree).toPromise();
        const moduleContent = tree.readContent('/src/app/app-navigation.ts');
        expect(moduleContent).toMatch(/text: 'Some Test'/);
        expect(moduleContent).toMatch(/icon: 'home'/);
        expect(moduleContent).toMatch(/text: 'Test'/);
        expect(moduleContent).toMatch(/icon: 'folder'/);
        expect(moduleContent).toContain(`navigation = [
  {
    text: 'Test',
    path: '/pages/test',
    icon: 'folder'
  },
  {
    text: 'Some Test',
    path: '/pages/some-test',
    icon: 'home'
  }
];`);
        const pageContent = tree.readContent('/src/app/pages/some-test/some-test.component.html');
        expect(pageContent).toMatch(/<h2 class="content-block">Some Test<\/h2>/);
    }));
    it('should create new view with path', () => __awaiter(void 0, void 0, void 0, function* () {
        const runner = new testing_1.SchematicTestRunner('schematics', collectionPath);
        componentOptions.name = 'folder/test';
        let tree = yield runner.runSchematicAsync('add-layout', { layout: 'side-nav-outer-toolbar' }, appTree).toPromise();
        tree = yield runner.runSchematicAsync('add-view', componentOptions, appTree).toPromise();
        expect(tree.files).toContain('/src/app/folder/test/test.component.ts');
        expect(tree.files).toContain('/src/app/folder/test/test.component.html');
    }));
});
//# sourceMappingURL=index_spec.js.map