"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const testing_1 = require("@angular-devkit/schematics/testing");
const path = require("path");
const latest_versions_1 = require("../utility/latest-versions");
const collectionPath = path.join(__dirname, '../collection.json');
describe('install', () => {
    // TODO: Extract workspase preparing somewhere
    const appOptions = {
        name: 'testApp',
        projectRoot: '',
        inlineStyle: false,
        inlineTemplate: false,
        routing: true,
        style: 'css',
        skipTests: false,
        skipPackageJson: false
    };
    const workspaceOptions = {
        name: 'workspace',
        // TODO: use angular latest-versions module
        version: '12.0.0'
    };
    const angularSchematicsCollection = require.resolve('../../node_modules/@schematics/angular/collection.json');
    const schematicRunner = new testing_1.SchematicTestRunner('@schematics/angular', angularSchematicsCollection);
    let appTree;
    beforeEach(() => __awaiter(void 0, void 0, void 0, function* () {
        appTree = yield schematicRunner.runSchematicAsync('workspace', workspaceOptions).toPromise();
        appTree = yield schematicRunner.runSchematicAsync('application', appOptions, appTree).toPromise();
    }));
    it('should add devextreme dependency (default)', () => __awaiter(void 0, void 0, void 0, function* () {
        const runner = new testing_1.SchematicTestRunner('schematics', collectionPath);
        const tree = yield runner.runSchematicAsync('install', {}, appTree).toPromise();
        const packageConfig = JSON.parse(tree.readContent('package.json'));
        expect(packageConfig.dependencies['devextreme']).toBe(latest_versions_1.latestVersions['devextreme']);
        expect(packageConfig.dependencies['devextreme-angular']).toBe(latest_versions_1.latestVersions['devextreme-angular']);
        expect(packageConfig.devDependencies['devextreme-themebuilder']).toBe(latest_versions_1.latestVersions['devextreme']);
    }));
    it('should add devextreme dependency (custom)', () => __awaiter(void 0, void 0, void 0, function* () {
        const runner = new testing_1.SchematicTestRunner('schematics', collectionPath);
        const tree = yield runner.runSchematicAsync('install', { dxversion: '18.2.5' }, appTree).toPromise();
        const packageConfig = JSON.parse(tree.readContent('package.json'));
        expect(packageConfig.dependencies.devextreme).toBe('18.2.5');
        expect(packageConfig.devDependencies['devextreme-themebuilder']).toBe('18.2.5');
    }));
    it('should add devextreme cli devDependency', () => __awaiter(void 0, void 0, void 0, function* () {
        const runner = new testing_1.SchematicTestRunner('schematics', collectionPath);
        const tree = yield runner.runSchematicAsync('install', { dxversion: '18.2.5' }, appTree).toPromise();
        const packageConfig = JSON.parse(tree.readContent('package.json'));
        expect(packageConfig.devDependencies['devextreme-cli']).toBeDefined();
    }));
    it('should add devextreme styles', () => __awaiter(void 0, void 0, void 0, function* () {
        const runner = new testing_1.SchematicTestRunner('schematics', collectionPath);
        const tree = yield runner.runSchematicAsync('install', {}, appTree).toPromise();
        const angularConfig = JSON.parse(tree.readContent('angular.json'));
        const styles = angularConfig['projects']['testApp']['architect']['build']['options']['styles'];
        expect(styles[0]).toBe('node_modules/devextreme/dist/css/dx.light.css');
    }));
    it('should register jszip', () => __awaiter(void 0, void 0, void 0, function* () {
        const runner = new testing_1.SchematicTestRunner('schematics', collectionPath);
        const tree = yield runner.runSchematicAsync('install', {}, appTree).toPromise();
        const tsconfig = JSON.parse(tree.readContent('tsconfig.app.json'));
        const jszip = tsconfig['compilerOptions']['paths']['jszip'];
        expect(jszip[0]).toBe('node_modules/jszip/dist/jszip.min.js');
    }));
    it('should add devextreme styles to the specified project', () => __awaiter(void 0, void 0, void 0, function* () {
        const secondAppOptions = {
            name: 'testApp2',
            inlineStyle: false,
            inlineTemplate: false,
            projectRoot: 'src2',
            routing: true,
            style: 'css',
            skipTests: false,
            skipPackageJson: false
        };
        appTree = yield schematicRunner.runSchematicAsync('application', secondAppOptions, appTree).toPromise();
        const runner = new testing_1.SchematicTestRunner('schematics', collectionPath);
        const tree = yield runner.runSchematicAsync('install', { project: 'testApp2' }, appTree).toPromise();
        const angularConfig = JSON.parse(tree.readContent('angular.json'));
        const styles = angularConfig['projects']['testApp2']['architect']['build']['options']['styles'];
        expect(styles[0]).toBe('node_modules/devextreme/dist/css/dx.light.css');
        expect(angularConfig['projects']['testApp']['architect']['build']['options']['styles'].length).toBe(1);
    }));
});
//# sourceMappingURL=index_spec.js.map