"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.insertItemToArray = exports.applyChanges = void 0;
const newLine = `
`;
function applyChanges(host, changes, filePath) {
    const recorder = host.beginUpdate(filePath);
    changes.forEach((change) => {
        recorder.insertLeft(change.pos, change.toAdd);
    });
    host.commitUpdate(recorder);
    return host;
}
exports.applyChanges = applyChanges;
// TODO: implement options.index
// TODO: implement spaces shift calculation
function insertItemToArray(host, filePath, node, item, options = { location: 'start' }) {
    const isItemValid = /^\s*\{[\s\S]*\}\s*$/m.test(item);
    if (!isItemValid) {
        return host;
    }
    const nodeContent = node.getText();
    const nodePosition = node.getStart();
    const leftBracketPosition = nodePosition + nodeContent.indexOf('[');
    const rightBracketPosition = nodePosition + nodeContent.lastIndexOf(']');
    let itemPosition = leftBracketPosition + 1;
    let fileRecorder = host.beginUpdate(filePath);
    item = newLine + item;
    const isNodeEmpty = !/\[[\s\S]*\S+[\s\S]*\]/m.test(nodeContent);
    if (isNodeEmpty) {
        const formattedArray = `[${newLine}]`;
        fileRecorder.remove(leftBracketPosition, rightBracketPosition - leftBracketPosition + 1);
        fileRecorder.insertLeft(leftBracketPosition, formattedArray);
        host.commitUpdate(fileRecorder);
        fileRecorder = host.beginUpdate(filePath);
    }
    else {
        if (options.location === 'end') {
            itemPosition = nodePosition + nodeContent.lastIndexOf('}') + 1;
            item = ',' + item;
        }
        else {
            item = item + ',';
        }
    }
    fileRecorder.insertLeft(itemPosition, item);
    host.commitUpdate(fileRecorder);
    return host;
}
exports.insertItemToArray = insertItemToArray;
//# sourceMappingURL=change.js.map