"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getRootPath = exports.getSourceRootPath = exports.getApplicationPath = exports.getProjectName = void 0;
const workspace_1 = require("@schematics/angular/utility/workspace");
function getProjectName(host, projectName) {
    return __awaiter(this, void 0, void 0, function* () {
        const projects = [];
        const workspace = yield (0, workspace_1.getWorkspace)(host);
        /* tslint:disable-next-line:variable-name */
        workspace.projects.forEach((_v, k) => {
            projects.push(k);
        });
        return projectName && projects.includes(projectName) ? projectName : projects[0];
    });
}
exports.getProjectName = getProjectName;
function getApplicationPath(host, projectName) {
    return __awaiter(this, void 0, void 0, function* () {
        const sourcePath = yield getSourceRootPath(host, projectName);
        return sourcePath ? `${sourcePath}/app/` : 'src/app/';
    });
}
exports.getApplicationPath = getApplicationPath;
function getSourceRootPath(host, projectName) {
    return __awaiter(this, void 0, void 0, function* () {
        const workspace = yield (0, workspace_1.getWorkspace)(host);
        const project = workspace.projects.get(projectName);
        return project && (project.sourceRoot || project.root);
    });
}
exports.getSourceRootPath = getSourceRootPath;
function getRootPath(host, projectName) {
    return __awaiter(this, void 0, void 0, function* () {
        const workspace = yield (0, workspace_1.getWorkspace)(host);
        const project = workspace.projects.get(projectName);
        return project && project.root;
    });
}
exports.getRootPath = getRootPath;
//# sourceMappingURL=project.js.map