"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addStylesToApp = void 0;
const array_1 = require("./array");
function cleanStyles(projectStyles, defaultStyles) {
    return projectStyles.filter((style) => {
        return style !== defaultStyles[0] && style !== defaultStyles[1];
    });
}
function addStylesToApp(project, config, styles) {
    const projectBuildOptopns = config['projects'][project]['architect']['build']['options'];
    const defaultStyles = [
        'node_modules/devextreme/dist/css/dx.light.css'
    ];
    let projectStyles = projectBuildOptopns['styles'];
    if (!styles) {
        styles = defaultStyles;
    }
    else {
        projectStyles = cleanStyles(projectStyles, defaultStyles);
    }
    styles.forEach((style) => {
        projectStyles.unshift(style);
    });
    projectBuildOptopns['styles'] = (0, array_1.makeArrayUnique)(projectStyles);
    return config;
}
exports.addStylesToApp = addStylesToApp;
//# sourceMappingURL=styles.js.map