/*!
 * DevExtreme (dx.web.debug.js)
 * Version: 19.2.3
 * Build date: Tue Oct 22 2019
 *
 * Copyright (c) 2012 - 2019 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
 */
"use strict";
! function(modules) {
    var installedModules = {};

    function __webpack_require__(moduleId) {
        if (installedModules[moduleId]) {
            return installedModules[moduleId].exports
        }
        var module = installedModules[moduleId] = {
            i: moduleId,
            l: false,
            exports: {}
        };
        modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
        module.l = true;
        return module.exports
    }
    __webpack_require__.m = modules;
    __webpack_require__.c = installedModules;
    __webpack_require__.d = function(exports, name, getter) {
        if (!__webpack_require__.o(exports, name)) {
            Object.defineProperty(exports, name, {
                configurable: false,
                enumerable: true,
                get: getter
            })
        }
    };
    __webpack_require__.n = function(module) {
        var getter = module && module.__esModule ? function() {
            return module.default
        } : function() {
            return module
        };
        __webpack_require__.d(getter, "a", getter);
        return getter
    };
    __webpack_require__.o = function(object, property) {
        return Object.prototype.hasOwnProperty.call(object, property)
    };
    __webpack_require__.p = "";
    return __webpack_require__(__webpack_require__.s = 893)
}([
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/utils/extend.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var isPlainObject = __webpack_require__( /*! ./type */ 1).isPlainObject;
        var extendFromObject = function(target, source, overrideExistingValues) {
            target = target || {};
            for (var prop in source) {
                if (Object.prototype.hasOwnProperty.call(source, prop)) {
                    var value = source[prop];
                    if (!(prop in target) || overrideExistingValues) {
                        target[prop] = value
                    }
                }
            }
            return target
        };
        var extend = function extend(target) {
            target = target || {};
            var i = 1,
                deep = false;
            if ("boolean" === typeof target) {
                deep = target;
                target = arguments[1] || {};
                i++
            }
            for (; i < arguments.length; i++) {
                var source = arguments[i];
                if (null == source) {
                    continue
                }
                for (var key in source) {
                    var clone, targetValue = target[key],
                        sourceValue = source[key],
                        sourceValueIsArray = false;
                    if ("__proto__" === key || target === sourceValue) {
                        continue
                    }
                    if (deep && sourceValue && (isPlainObject(sourceValue) || (sourceValueIsArray = Array.isArray(sourceValue)))) {
                        if (sourceValueIsArray) {
                            clone = targetValue && Array.isArray(targetValue) ? targetValue : []
                        } else {
                            clone = targetValue && isPlainObject(targetValue) ? targetValue : {}
                        }
                        target[key] = extend(deep, clone, sourceValue)
                    } else {
                        if (void 0 !== sourceValue) {
                            target[key] = sourceValue
                        }
                    }
                }
            }
            return target
        };
        exports.extend = extend;
        exports.extendFromObject = extendFromObject
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/core/utils/type.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var types = {
            "[object Array]": "array",
            "[object Date]": "date",
            "[object Object]": "object",
            "[object String]": "string",
            "[object Null]": "null"
        };
        var type = function(object) {
            var typeOfObject = Object.prototype.toString.call(object);
            return "object" === ("undefined" === typeof object ? "undefined" : _typeof(object)) ? types[typeOfObject] || "object" : "undefined" === typeof object ? "undefined" : _typeof(object)
        };
        var isBoolean = function(object) {
            return "boolean" === typeof object
        };
        var isExponential = function(value) {
            return isNumeric(value) && value.toString().indexOf("e") !== -1
        };
        var isDate = function(object) {
            return "date" === type(object)
        };
        var isDefined = function(object) {
            return null !== object && void 0 !== object
        };
        var isFunction = function(object) {
            return "function" === typeof object
        };
        var isString = function(object) {
            return "string" === typeof object
        };
        var isNumeric = function(object) {
            return "number" === typeof object && isFinite(object) || !isNaN(object - parseFloat(object))
        };
        var isObject = function(object) {
            return "object" === type(object)
        };
        var isEmptyObject = function(object) {
            var property;
            for (property in object) {
                return false
            }
            return true
        };
        var isPlainObject = function(object) {
            if (!object || "[object Object]" !== Object.prototype.toString.call(object)) {
                return false
            }
            var proto = Object.getPrototypeOf(object),
                ctor = Object.hasOwnProperty.call(proto, "constructor") && proto.constructor;
            return "function" === typeof ctor && Object.toString.call(ctor) === Object.toString.call(Object)
        };
        var isPrimitive = function(value) {
            return ["object", "array", "function"].indexOf(type(value)) === -1
        };
        var isWindow = function(object) {
            return null != object && object === object.window
        };
        var isRenderer = function(object) {
            return !!(object.jquery || object.dxRenderer)
        };
        var isPromise = function(object) {
            return object && isFunction(object.then)
        };
        var isDeferred = function(object) {
            return object && isFunction(object.done) && isFunction(object.fail)
        };
        exports.isBoolean = isBoolean;
        exports.isExponential = isExponential;
        exports.isDate = isDate;
        exports.isDefined = isDefined;
        exports.isFunction = isFunction;
        exports.isString = isString;
        exports.isNumeric = isNumeric;
        exports.isObject = isObject;
        exports.isEmptyObject = isEmptyObject;
        exports.isPlainObject = isPlainObject;
        exports.isPrimitive = isPrimitive;
        exports.isWindow = isWindow;
        exports.isRenderer = isRenderer;
        exports.isPromise = isPromise;
        exports.isDeferred = isDeferred;
        exports.type = type
    },
    /*!***********************************************!*\
      !*** ./artifacts/transpiled/core/renderer.js ***!
      \***********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var rendererBase = __webpack_require__( /*! ./renderer_base */ 258);
        module.exports = rendererBase.get()
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/core/utils/iterator.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var map = function(values, callback) {
            if (Array.isArray(values)) {
                return values.map(callback)
            }
            var result = [];
            for (var key in values) {
                result.push(callback(values[key], key))
            }
            return result
        };
        var each = function(values, callback) {
            if (!values) {
                return
            }
            if ("length" in values) {
                for (var i = 0; i < values.length; i++) {
                    if (false === callback.call(values[i], i, values[i])) {
                        break
                    }
                }
            } else {
                for (var key in values) {
                    if (false === callback.call(values[key], key, values[key])) {
                        break
                    }
                }
            }
            return values
        };
        var reverseEach = function(array, callback) {
            if (!array || !("length" in array) || 0 === array.length) {
                return
            }
            for (var i = array.length - 1; i >= 0; i--) {
                if (false === callback.call(array[i], i, array[i])) {
                    break
                }
            }
        };
        exports.map = map;
        exports.each = each;
        exports.reverseEach = reverseEach
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/utils/common.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var _config = __webpack_require__( /*! ../config */ 29);
        var _config2 = _interopRequireDefault(_config);
        var _guid = __webpack_require__( /*! ../guid */ 34);
        var _guid2 = _interopRequireDefault(_guid);
        var _deferred = __webpack_require__( /*! ../utils/deferred */ 6);
        var _data = __webpack_require__( /*! ./data */ 20);
        var _iterator = __webpack_require__( /*! ./iterator */ 3);
        var _type = __webpack_require__( /*! ./type */ 1);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var ensureDefined = function(value, defaultValue) {
            return (0, _type.isDefined)(value) ? value : defaultValue
        };
        var executeAsync = function(action, context) {
            var deferred = new _deferred.Deferred;
            var normalizedContext = context || this;
            var timerId = void 0;
            var task = {
                promise: deferred.promise(),
                abort: function() {
                    clearTimeout(timerId);
                    deferred.rejectWith(normalizedContext)
                }
            };
            var callback = function() {
                var result = action.call(normalizedContext);
                if (result && result.done && (0, _type.isFunction)(result.done)) {
                    result.done(function() {
                        deferred.resolveWith(normalizedContext)
                    })
                } else {
                    deferred.resolveWith(normalizedContext)
                }
            };
            timerId = (arguments[2] || setTimeout)(callback, "number" === typeof context ? context : 0);
            return task
        };
        var delayedFuncs = [];
        var delayedNames = [];
        var delayedDeferreds = [];
        var executingName = void 0;
        var deferExecute = function(name, func, deferred) {
            if (executingName && executingName !== name) {
                delayedFuncs.push(func);
                delayedNames.push(name);
                deferred = deferred || new _deferred.Deferred;
                delayedDeferreds.push(deferred);
                return deferred
            } else {
                var oldExecutingName = executingName;
                var currentDelayedCount = delayedDeferreds.length;
                executingName = name;
                var result = func();
                if (!result) {
                    if (delayedDeferreds.length > currentDelayedCount) {
                        result = _deferred.when.apply(this, delayedDeferreds.slice(currentDelayedCount))
                    } else {
                        if (deferred) {
                            deferred.resolve()
                        }
                    }
                }
                executingName = oldExecutingName;
                if (deferred && result && result.done) {
                    result.done(deferred.resolve).fail(deferred.reject)
                }
                if (!executingName && delayedFuncs.length) {
                    ("render" === delayedNames.shift() ? deferRender : deferUpdate)(delayedFuncs.shift(), delayedDeferreds.shift())
                }
                return result || (0, _deferred.when)()
            }
        };
        var deferRender = function(func, deferred) {
            return deferExecute("render", func, deferred)
        };
        var deferUpdate = function(func, deferred) {
            return deferExecute("update", func, deferred)
        };
        var deferRenderer = function(func) {
            return function() {
                var that = this;
                return deferExecute("render", function() {
                    return func.call(that)
                })
            }
        };
        var deferUpdater = function(func) {
            return function() {
                var that = this;
                return deferExecute("update", function() {
                    return func.call(that)
                })
            }
        };
        var findBestMatches = function(targetFilter, items, mapFn) {
            var bestMatches = [];
            var maxMatchCount = 0;
            (0, _iterator.each)(items, function(index, itemSrc) {
                var matchCount = 0;
                var item = mapFn ? mapFn(itemSrc) : itemSrc;
                (0, _iterator.each)(targetFilter, function(paramName, targetValue) {
                    var value = item[paramName];
                    if (void 0 === value) {
                        return
                    }
                    if (match(value, targetValue)) {
                        matchCount++;
                        return
                    }
                    matchCount = -1;
                    return false
                });
                if (matchCount < maxMatchCount) {
                    return
                }
                if (matchCount > maxMatchCount) {
                    bestMatches.length = 0;
                    maxMatchCount = matchCount
                }
                bestMatches.push(itemSrc)
            });
            return bestMatches
        };
        var match = function(value, targetValue) {
            if (Array.isArray(value) && Array.isArray(targetValue)) {
                var mismatch = false;
                (0, _iterator.each)(value, function(index, valueItem) {
                    if (valueItem !== targetValue[index]) {
                        mismatch = true;
                        return false
                    }
                });
                if (mismatch) {
                    return false
                }
                return true
            }
            if (value === targetValue) {
                return true
            }
            return false
        };
        var splitPair = function(raw) {
            switch ("undefined" === typeof raw ? "undefined" : _typeof(raw)) {
                case "string":
                    return raw.split(/\s+/, 2);
                case "object":
                    return [raw.x || raw.h, raw.y || raw.v];
                case "number":
                    return [raw];
                default:
                    return raw
            }
        };
        var normalizeKey = function(id) {
            var key = (0, _type.isString)(id) ? id : id.toString();
            var arr = key.match(/[^a-zA-Z0-9_]/g);
            arr && (0, _iterator.each)(arr, function(_, sign) {
                key = key.replace(sign, "__" + sign.charCodeAt() + "__")
            });
            return key
        };
        var denormalizeKey = function(key) {
            var arr = key.match(/__\d+__/g);
            arr && arr.forEach(function(char) {
                var charCode = parseInt(char.replace("__", ""));
                key = key.replace(char, String.fromCharCode(charCode))
            });
            return key
        };
        var pairToObject = function(raw, preventRound) {
            var pair = splitPair(raw);
            var h = preventRound ? parseFloat(pair && pair[0]) : parseInt(pair && pair[0], 10);
            var v = preventRound ? parseFloat(pair && pair[1]) : parseInt(pair && pair[1], 10);
            if (!isFinite(h)) {
                h = 0
            }
            if (!isFinite(v)) {
                v = h
            }
            return {
                h: h,
                v: v
            }
        };
        var getKeyHash = function(key) {
            if (key instanceof _guid2.default) {
                return key.toString()
            } else {
                if ((0, _type.isObject)(key) || Array.isArray(key)) {
                    try {
                        var keyHash = JSON.stringify(key);
                        return "{}" === keyHash ? key : keyHash
                    } catch (e) {
                        return key
                    }
                }
            }
            return key
        };
        var escapeRegExp = function(string) {
            return string.replace(/[[\]{}\-()*+?.\\^$|\s]/g, "\\$&")
        };
        var applyServerDecimalSeparator = function(value) {
            var separator = (0, _config2.default)().serverDecimalSeparator;
            if ((0, _type.isDefined)(value)) {
                value = value.toString().replace(".", separator)
            }
            return value
        };
        var noop = function() {};
        var asyncNoop = function() {
            return (new _deferred.Deferred).resolve().promise()
        };
        var grep = function(elements, checkFunction, invert) {
            var result = [];
            var check = void 0;
            var expectedCheck = !invert;
            for (var i = 0; i < elements.length; i++) {
                check = !!checkFunction(elements[i], i);
                if (check === expectedCheck) {
                    result.push(elements[i])
                }
            }
            return result
        };
        var arraysEqualByValue = function(array1, array2, depth) {
            if (array1.length !== array2.length) {
                return false
            }
            for (var i = 0; i < array1.length; i++) {
                if (!equalByValue(array1[i], array2[i], depth + 1)) {
                    return false
                }
            }
            return true
        };
        var objectsEqualByValue = function(object1, object2, depth) {
            for (var propertyName in object1) {
                if (Object.prototype.hasOwnProperty.call(object1, propertyName) && !equalByValue(object1[propertyName], object2[propertyName], depth + 1)) {
                    return false
                }
            }
            for (var _propertyName in object2) {
                if (!(_propertyName in object1)) {
                    return false
                }
            }
            return true
        };
        var maxEqualityDepth = 3;
        var equalByValue = function(object1, object2, depth) {
            depth = depth || 0;
            object1 = (0, _data.toComparable)(object1, true);
            object2 = (0, _data.toComparable)(object2, true);
            if (object1 === object2 || depth >= maxEqualityDepth) {
                return true
            }
            if ((0, _type.isObject)(object1) && (0, _type.isObject)(object2)) {
                return objectsEqualByValue(object1, object2, depth)
            } else {
                if (Array.isArray(object1) && Array.isArray(object2)) {
                    return arraysEqualByValue(object1, object2, depth)
                }
            }
            return false
        };
        exports.ensureDefined = ensureDefined;
        exports.executeAsync = executeAsync;
        exports.deferRender = deferRender;
        exports.deferRenderer = deferRenderer;
        exports.deferUpdate = deferUpdate;
        exports.deferUpdater = deferUpdater;
        exports.pairToObject = pairToObject;
        exports.splitPair = splitPair;
        exports.findBestMatches = findBestMatches;
        exports.normalizeKey = normalizeKey;
        exports.denormalizeKey = denormalizeKey;
        exports.getKeyHash = getKeyHash;
        exports.escapeRegExp = escapeRegExp;
        exports.applyServerDecimalSeparator = applyServerDecimalSeparator;
        exports.noop = noop;
        exports.asyncNoop = asyncNoop;
        exports.grep = grep;
        exports.equalByValue = equalByValue
    },
    /*!***********************************************************!*\
      !*** ./artifacts/transpiled/events/core/events_engine.js ***!
      \***********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var registerEventCallbacks = __webpack_require__( /*! ./event_registrator_callbacks */ 124);
        var extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend;
        var domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 13);
        var windowUtils = __webpack_require__( /*! ../../core/utils/window */ 7);
        var window = windowUtils.getWindow();
        var injector = __webpack_require__( /*! ../../core/utils/dependency_injector */ 56);
        var typeUtils = __webpack_require__( /*! ../../core/utils/type */ 1);
        var Callbacks = __webpack_require__( /*! ../../core/utils/callbacks */ 26);
        var isWindow = typeUtils.isWindow;
        var isFunction = typeUtils.isFunction;
        var isString = typeUtils.isString;
        var errors = __webpack_require__( /*! ../../core/errors */ 21);
        var WeakMap = __webpack_require__( /*! ../../core/polyfills/weak_map */ 180);
        var hookTouchProps = __webpack_require__( /*! ../../events/core/hook_touch_props */ 259);
        var callOnce = __webpack_require__( /*! ../../core/utils/call_once */ 61);
        var EMPTY_EVENT_NAME = "dxEmptyEventType";
        var NATIVE_EVENTS_TO_SUBSCRIBE = {
            mouseenter: "mouseover",
            mouseleave: "mouseout",
            pointerenter: "pointerover",
            pointerleave: "pointerout"
        };
        var NATIVE_EVENTS_TO_TRIGGER = {
            focusin: "focus",
            focusout: "blur"
        };
        var NO_BUBBLE_EVENTS = ["blur", "focus", "load"];
        var forcePassiveFalseEventNames = ["touchmove", "wheel", "mousewheel"];
        var matchesSafe = function(target, selector) {
            return !isWindow(target) && "#document" !== target.nodeName && domAdapter.elementMatches(target, selector)
        };
        var elementDataMap = new WeakMap;
        var guid = 0;
        var skipEvent;
        var special = function() {
            var specialData = {};
            registerEventCallbacks.add(function(eventName, eventObject) {
                specialData[eventName] = eventObject
            });
            return {
                getField: function(eventName, field) {
                    return specialData[eventName] && specialData[eventName][field]
                },
                callMethod: function(eventName, methodName, context, args) {
                    return specialData[eventName] && specialData[eventName][methodName] && specialData[eventName][methodName].apply(context, args)
                }
            }
        }();
        var applyForEach = function applyForEach(args, method) {
            var element = args[0];
            if (!element) {
                return
            }
            if (domAdapter.isNode(element) || isWindow(element)) {
                method.apply(eventsEngine, args)
            } else {
                if (!isString(element) && "length" in element) {
                    var itemArgs = Array.prototype.slice.call(args, 0);
                    Array.prototype.forEach.call(element, function(itemElement) {
                        itemArgs[0] = itemElement;
                        applyForEach(itemArgs, method)
                    })
                } else {
                    throw errors.Error("E0025")
                }
            }
        };
        var getHandler = function(method) {
            return function() {
                applyForEach(arguments, method)
            }
        };
        var detectPassiveEventHandlersSupport = function() {
            var isSupported = false;
            try {
                var options = Object.defineProperty({}, "passive", {
                    get: function() {
                        isSupported = true;
                        return true
                    }
                });
                window.addEventListener("test", null, options)
            } catch (e) {}
            return isSupported
        };
        var passiveEventHandlersSupported = callOnce(detectPassiveEventHandlersSupport);
        var getHandlersController = function(element, eventName) {
            var elementData = elementDataMap.get(element);
            eventName = eventName || "";
            var eventNameParts = eventName.split(".");
            var namespaces = eventNameParts.slice(1);
            var eventNameIsDefined = !!eventNameParts[0];
            eventName = eventNameParts[0] || EMPTY_EVENT_NAME;
            if (!elementData) {
                elementData = {};
                elementDataMap.set(element, elementData)
            }
            if (!elementData[eventName]) {
                elementData[eventName] = {
                    handleObjects: [],
                    nativeHandler: null
                }
            }
            var eventData = elementData[eventName];
            return {
                addHandler: function(handler, selector, data) {
                    var callHandler = function(e, extraParameters) {
                        var secondaryTargetIsInside, result, handlerArgs = [e],
                            target = e.currentTarget,
                            relatedTarget = e.relatedTarget;
                        if (eventName in NATIVE_EVENTS_TO_SUBSCRIBE) {
                            secondaryTargetIsInside = relatedTarget && target && (relatedTarget === target || target.contains(relatedTarget))
                        }
                        if (void 0 !== extraParameters) {
                            handlerArgs.push(extraParameters)
                        }
                        special.callMethod(eventName, "handle", element, [e, data]);
                        if (!secondaryTargetIsInside) {
                            result = handler.apply(target, handlerArgs)
                        }
                        if (false === result) {
                            e.preventDefault();
                            e.stopPropagation()
                        }
                    };
                    var wrappedHandler = function(e, extraParameters) {
                        if (skipEvent && e.type === skipEvent) {
                            return
                        }
                        e.data = data;
                        e.delegateTarget = element;
                        if (selector) {
                            var currentTarget = e.target;
                            while (currentTarget && currentTarget !== element) {
                                if (matchesSafe(currentTarget, selector)) {
                                    e.currentTarget = currentTarget;
                                    callHandler(e, extraParameters)
                                }
                                currentTarget = currentTarget.parentNode
                            }
                        } else {
                            e.currentTarget = e.delegateTarget || e.target;
                            callHandler(e, extraParameters)
                        }
                    };
                    var handleObject = {
                        handler: handler,
                        wrappedHandler: wrappedHandler,
                        selector: selector,
                        type: eventName,
                        data: data,
                        namespace: namespaces.join("."),
                        namespaces: namespaces,
                        guid: ++guid
                    };
                    eventData.handleObjects.push(handleObject);
                    var firstHandlerForTheType = 1 === eventData.handleObjects.length;
                    var shouldAddNativeListener = firstHandlerForTheType && eventNameIsDefined;
                    var nativeListenerOptions;
                    if (shouldAddNativeListener) {
                        shouldAddNativeListener = !special.callMethod(eventName, "setup", element, [data, namespaces, handler])
                    }
                    if (shouldAddNativeListener) {
                        eventData.nativeHandler = getNativeHandler(eventName);
                        if (passiveEventHandlersSupported() && forcePassiveFalseEventNames.indexOf(eventName) > -1) {
                            nativeListenerOptions = {
                                passive: false
                            }
                        }
                        eventData.removeListener = domAdapter.listen(element, NATIVE_EVENTS_TO_SUBSCRIBE[eventName] || eventName, eventData.nativeHandler, nativeListenerOptions)
                    }
                    special.callMethod(eventName, "add", element, [handleObject])
                },
                removeHandler: function(handler, selector) {
                    var removeByEventName = function(eventName) {
                        var eventData = elementData[eventName];
                        if (!eventData.handleObjects.length) {
                            delete elementData[eventName];
                            return
                        }
                        var removedHandler;
                        eventData.handleObjects = eventData.handleObjects.filter(function(handleObject) {
                            var skip = namespaces.length && !isSubset(handleObject.namespaces, namespaces) || handler && handleObject.handler !== handler || selector && handleObject.selector !== selector;
                            if (!skip) {
                                removedHandler = handleObject.handler;
                                special.callMethod(eventName, "remove", element, [handleObject])
                            }
                            return skip
                        });
                        var lastHandlerForTheType = !eventData.handleObjects.length;
                        var shouldRemoveNativeListener = lastHandlerForTheType && eventName !== EMPTY_EVENT_NAME;
                        if (shouldRemoveNativeListener) {
                            special.callMethod(eventName, "teardown", element, [namespaces, removedHandler]);
                            if (eventData.nativeHandler) {
                                eventData.removeListener()
                            }
                            delete elementData[eventName]
                        }
                    };
                    if (eventNameIsDefined) {
                        removeByEventName(eventName)
                    } else {
                        for (var name in elementData) {
                            removeByEventName(name)
                        }
                    }
                    var elementDataIsEmpty = 0 === Object.keys(elementData).length;
                    if (elementDataIsEmpty) {
                        elementDataMap.delete(element)
                    }
                },
                callHandlers: function(event, extraParameters) {
                    var forceStop = false;
                    var handleCallback = function(handleObject) {
                        if (forceStop) {
                            return
                        }
                        if (!namespaces.length || isSubset(handleObject.namespaces, namespaces)) {
                            handleObject.wrappedHandler(event, extraParameters);
                            forceStop = event.isImmediatePropagationStopped()
                        }
                    };
                    eventData.handleObjects.forEach(handleCallback);
                    if (namespaces.length && elementData[EMPTY_EVENT_NAME]) {
                        elementData[EMPTY_EVENT_NAME].handleObjects.forEach(handleCallback)
                    }
                }
            }
        };
        var getNativeHandler = function(subscribeName) {
            return function(event, extraParameters) {
                var handlersController = getHandlersController(this, subscribeName);
                event = eventsEngine.Event(event);
                handlersController.callHandlers(event, extraParameters)
            }
        };
        var isSubset = function(original, checked) {
            for (var i = 0; i < checked.length; i++) {
                if (original.indexOf(checked[i]) < 0) {
                    return false
                }
            }
            return true
        };
        var normalizeOnArguments = function(callback) {
            return function(element, eventName, selector, data, handler) {
                if (!handler) {
                    handler = data;
                    data = void 0
                }
                if ("string" !== typeof selector) {
                    data = selector;
                    selector = void 0
                }
                if (!handler && "string" === typeof eventName) {
                    handler = data || selector;
                    selector = void 0;
                    data = void 0
                }
                callback(element, eventName, selector, data, handler)
            }
        };
        var normalizeOffArguments = function(callback) {
            return function(element, eventName, selector, handler) {
                if ("function" === typeof selector) {
                    handler = selector;
                    selector = void 0
                }
                callback(element, eventName, selector, handler)
            }
        };
        var normalizeTriggerArguments = function(callback) {
            return function(element, src, extraParameters) {
                if ("string" === typeof src) {
                    src = {
                        type: src
                    }
                }
                if (!src.target) {
                    src.target = element
                }
                src.currentTarget = element;
                if (!src.delegateTarget) {
                    src.delegateTarget = element
                }
                if (!src.type && src.originalEvent) {
                    src.type = src.originalEvent.type
                }
                callback(element, src instanceof eventsEngine.Event ? src : eventsEngine.Event(src), extraParameters)
            }
        };
        var normalizeEventArguments = function(callback) {
            return function(src, config) {
                if (!(this instanceof eventsEngine.Event)) {
                    return new eventsEngine.Event(src, config)
                }
                if (!src) {
                    src = {}
                }
                if ("string" === typeof src) {
                    src = {
                        type: src
                    }
                }
                if (!config) {
                    config = {}
                }
                callback.call(this, src, config)
            }
        };
        var iterate = function(callback) {
            var iterateEventNames = function(element, eventName) {
                if (eventName && eventName.indexOf(" ") > -1) {
                    var args = Array.prototype.slice.call(arguments, 0);
                    eventName.split(" ").forEach(function(eventName) {
                        args[1] = eventName;
                        callback.apply(this, args)
                    })
                } else {
                    callback.apply(this, arguments)
                }
            };
            return function(element, eventName) {
                if ("object" === ("undefined" === typeof eventName ? "undefined" : _typeof(eventName))) {
                    var args = Array.prototype.slice.call(arguments, 0);
                    for (var name in eventName) {
                        args[1] = name;
                        args[args.length - 1] = eventName[name];
                        iterateEventNames.apply(this, args)
                    }
                } else {
                    iterateEventNames.apply(this, arguments)
                }
            }
        };
        var callNativeMethod = function(eventName, element) {
            var nativeMethodName = NATIVE_EVENTS_TO_TRIGGER[eventName] || eventName;
            var isLinkClickEvent = function(eventName, element) {
                return "click" === eventName && "a" === element.localName
            };
            if (isLinkClickEvent(eventName, element)) {
                return
            }
            if (isFunction(element[nativeMethodName])) {
                skipEvent = eventName;
                element[nativeMethodName]();
                skipEvent = void 0
            }
        };
        var calculateWhich = function(event) {
            var setForMouseEvent = function(event) {
                var mouseEventRegex = /^(?:mouse|pointer|contextmenu|drag|drop)|click/;
                return !event.which && void 0 !== event.button && mouseEventRegex.test(event.type)
            };
            var setForKeyEvent = function(event) {
                return null == event.which && 0 === event.type.indexOf("key")
            };
            if (setForKeyEvent(event)) {
                return null != event.charCode ? event.charCode : event.keyCode
            }
            if (setForMouseEvent(event)) {
                var whichByButton = {
                    1: 1,
                    2: 3,
                    3: 1,
                    4: 2
                };
                return whichByButton[event.button]
            }
            return event.which
        };
        var eventsEngine = injector({
            on: getHandler(normalizeOnArguments(iterate(function(element, eventName, selector, data, handler) {
                var handlersController = getHandlersController(element, eventName);
                handlersController.addHandler(handler, selector, data)
            }))),
            one: getHandler(normalizeOnArguments(function(element, eventName, selector, data, handler) {
                var oneTimeHandler = function oneTimeHandler() {
                    eventsEngine.off(element, eventName, selector, oneTimeHandler);
                    handler.apply(this, arguments)
                };
                eventsEngine.on(element, eventName, selector, data, oneTimeHandler)
            })),
            off: getHandler(normalizeOffArguments(iterate(function(element, eventName, selector, handler) {
                var handlersController = getHandlersController(element, eventName);
                handlersController.removeHandler(handler, selector)
            }))),
            trigger: getHandler(normalizeTriggerArguments(function(element, event, extraParameters) {
                var eventName = event.type;
                var handlersController = getHandlersController(element, event.type);
                special.callMethod(eventName, "trigger", element, [event, extraParameters]);
                handlersController.callHandlers(event, extraParameters);
                var noBubble = special.getField(eventName, "noBubble") || event.isPropagationStopped() || NO_BUBBLE_EVENTS.indexOf(eventName) !== -1;
                if (!noBubble) {
                    var parents = [];
                    var getParents = function getParents(element) {
                        var parent = element.parentNode;
                        if (parent) {
                            parents.push(parent);
                            getParents(parent)
                        }
                    };
                    getParents(element);
                    parents.push(window);
                    var i = 0;
                    while (parents[i] && !event.isPropagationStopped()) {
                        var parentDataByEvent = getHandlersController(parents[i], event.type);
                        parentDataByEvent.callHandlers(extend(event, {
                            currentTarget: parents[i]
                        }), extraParameters);
                        i++
                    }
                }
                if (element.nodeType || isWindow(element)) {
                    special.callMethod(eventName, "_default", element, [event, extraParameters]);
                    callNativeMethod(eventName, element)
                }
            })),
            triggerHandler: getHandler(normalizeTriggerArguments(function(element, event, extraParameters) {
                var handlersController = getHandlersController(element, event.type);
                handlersController.callHandlers(event, extraParameters)
            }))
        });
        var initEvent = function(EventClass) {
            if (EventClass) {
                eventsEngine.Event = EventClass;
                eventsEngine.Event.prototype = EventClass.prototype
            }
        };
        initEvent(normalizeEventArguments(function(src, config) {
            var that = this;
            var propagationStopped = false;
            var immediatePropagationStopped = false;
            var defaultPrevented = false;
            extend(that, src);
            if (src instanceof eventsEngine.Event || windowUtils.hasWindow() && src instanceof window.Event) {
                that.originalEvent = src;
                that.currentTarget = void 0
            }
            if (!(src instanceof eventsEngine.Event)) {
                extend(that, {
                    isPropagationStopped: function() {
                        return !!(propagationStopped || that.originalEvent && that.originalEvent.propagationStopped)
                    },
                    stopPropagation: function() {
                        propagationStopped = true;
                        that.originalEvent && that.originalEvent.stopPropagation()
                    },
                    isImmediatePropagationStopped: function() {
                        return immediatePropagationStopped
                    },
                    stopImmediatePropagation: function() {
                        this.stopPropagation();
                        immediatePropagationStopped = true;
                        that.originalEvent && that.originalEvent.stopImmediatePropagation()
                    },
                    isDefaultPrevented: function() {
                        return !!(defaultPrevented || that.originalEvent && that.originalEvent.defaultPrevented)
                    },
                    preventDefault: function() {
                        defaultPrevented = true;
                        that.originalEvent && that.originalEvent.preventDefault()
                    }
                })
            }
            addProperty("which", calculateWhich, that);
            if (0 === src.type.indexOf("touch")) {
                delete config.pageX;
                delete config.pageY
            }
            extend(that, config);
            that.guid = ++guid
        }));
        var addProperty = function(propName, hook, eventInstance) {
            Object.defineProperty(eventInstance || eventsEngine.Event.prototype, propName, {
                enumerable: true,
                configurable: true,
                get: function() {
                    return this.originalEvent && hook(this.originalEvent)
                },
                set: function(value) {
                    Object.defineProperty(this, propName, {
                        enumerable: true,
                        configurable: true,
                        writable: true,
                        value: value
                    })
                }
            })
        };
        hookTouchProps(addProperty);
        var beforeSetStrategy = Callbacks();
        var afterSetStrategy = Callbacks();
        eventsEngine.set = function(engine) {
            beforeSetStrategy.fire();
            eventsEngine.inject(engine);
            initEvent(engine.Event);
            afterSetStrategy.fire()
        };
        eventsEngine.subscribeGlobal = function() {
            applyForEach(arguments, normalizeOnArguments(function() {
                var args = arguments;
                eventsEngine.on.apply(this, args);
                beforeSetStrategy.add(function() {
                    var offArgs = Array.prototype.slice.call(args, 0);
                    offArgs.splice(3, 1);
                    eventsEngine.off.apply(this, offArgs)
                });
                afterSetStrategy.add(function() {
                    eventsEngine.on.apply(this, args)
                })
            }))
        };
        eventsEngine.forcePassiveFalseEventNames = forcePassiveFalseEventNames;
        eventsEngine.passiveEventHandlersSupported = passiveEventHandlersSupported;
        eventsEngine.elementDataMap = elementDataMap;
        eventsEngine.detectPassiveEventHandlersSupport = detectPassiveEventHandlersSupport;
        module.exports = eventsEngine
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/core/utils/deferred.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var typeUtils = __webpack_require__( /*! ../utils/type */ 1);
        var isPromise = typeUtils.isPromise;
        var isDeferred = typeUtils.isDeferred;
        var extend = __webpack_require__( /*! ../utils/extend */ 0).extend;
        var Callbacks = __webpack_require__( /*! ../utils/callbacks */ 26);
        var deferredConfig = [{
            method: "resolve",
            handler: "done",
            state: "resolved"
        }, {
            method: "reject",
            handler: "fail",
            state: "rejected"
        }, {
            method: "notify",
            handler: "progress"
        }];
        var _Deferred = function() {
            var that = this;
            this._state = "pending";
            this._promise = {};
            deferredConfig.forEach(function(config) {
                var methodName = config.method;
                this[methodName + "Callbacks"] = new Callbacks;
                this[methodName] = function() {
                    return this[methodName + "With"](this._promise, arguments)
                }.bind(this);
                this._promise[config.handler] = function(handler) {
                    if (!handler) {
                        return this
                    }
                    var callbacks = that[methodName + "Callbacks"];
                    if (callbacks.fired()) {
                        handler.apply(that[methodName + "Context"], that[methodName + "Args"])
                    } else {
                        callbacks.add(function(context, args) {
                            handler.apply(context, args)
                        }.bind(this))
                    }
                    return this
                }
            }.bind(this));
            this._promise.always = function(handler) {
                return this.done(handler).fail(handler)
            };
            this._promise.catch = function(handler) {
                return this.then(null, handler)
            };
            this._promise.then = function(resolve, reject) {
                var result = new _Deferred;
                ["done", "fail"].forEach(function(method) {
                    var callback = "done" === method ? resolve : reject;
                    this[method](function() {
                        if (!callback) {
                            result["done" === method ? "resolve" : "reject"].apply(this, arguments);
                            return
                        }
                        var callbackResult = callback && callback.apply(this, arguments);
                        if (isDeferred(callbackResult)) {
                            callbackResult.done(result.resolve).fail(result.reject)
                        } else {
                            if (isPromise(callbackResult)) {
                                callbackResult.then(result.resolve, result.reject)
                            } else {
                                result.resolve.apply(this, typeUtils.isDefined(callbackResult) ? [callbackResult] : arguments)
                            }
                        }
                    })
                }.bind(this));
                return result.promise()
            };
            this._promise.state = function() {
                return that._state
            };
            this._promise.promise = function(args) {
                return args ? extend(args, that._promise) : that._promise
            };
            this._promise.promise(this)
        };
        deferredConfig.forEach(function(config) {
            var methodName = config.method;
            var state = config.state;
            _Deferred.prototype[methodName + "With"] = function(context, args) {
                var callbacks = this[methodName + "Callbacks"];
                if ("pending" === this.state()) {
                    this[methodName + "Args"] = args;
                    this[methodName + "Context"] = context;
                    if (state) {
                        this._state = state
                    }
                    callbacks.fire(context, args)
                }
                return this
            }
        });
        exports.fromPromise = function(promise, context) {
            if (isDeferred(promise)) {
                return promise
            } else {
                if (isPromise(promise)) {
                    var d = new _Deferred;
                    promise.then(function() {
                        d.resolveWith.apply(d, [context].concat([
                            [].slice.call(arguments)
                        ]))
                    }, function() {
                        d.rejectWith.apply(d, [context].concat([
                            [].slice.call(arguments)
                        ]))
                    });
                    return d
                }
            }
            return (new _Deferred).resolveWith(context, [promise])
        };
        var when = function() {
            if (1 === arguments.length) {
                return exports.fromPromise(arguments[0])
            }
            var values = [].slice.call(arguments),
                contexts = [],
                resolvedCount = 0,
                deferred = new _Deferred;
            var updateState = function(i) {
                return function(value) {
                    contexts[i] = this;
                    values[i] = arguments.length > 1 ? [].slice.call(arguments) : value;
                    resolvedCount++;
                    if (resolvedCount === values.length) {
                        deferred.resolveWith(contexts, values)
                    }
                }
            };
            for (var i = 0; i < values.length; i++) {
                if (isDeferred(values[i])) {
                    values[i].promise().done(updateState(i)).fail(deferred.reject)
                } else {
                    resolvedCount++
                }
            }
            if (resolvedCount === values.length) {
                deferred.resolveWith(contexts, values)
            }
            return deferred.promise()
        };
        exports.setStrategy = function(value) {
            _Deferred = value.Deferred;
            when = value.when
        };
        exports.Deferred = function() {
            return new _Deferred
        };
        exports.when = function() {
            return when.apply(this, arguments)
        }
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/utils/window.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var domAdapter = __webpack_require__( /*! ../dom_adapter */ 13);
        var _hasWindow = "undefined" !== typeof window;
        var windowObject = _hasWindow && window;
        if (!windowObject) {
            windowObject = {};
            windowObject.window = windowObject
        }
        module.exports = {
            hasWindow: function() {
                return _hasWindow
            },
            getWindow: function() {
                return windowObject
            },
            hasProperty: function(prop) {
                return this.hasWindow() && prop in windowObject
            },
            defaultScreenFactorFunc: function(width) {
                if (width < 768) {
                    return "xs"
                } else {
                    if (width < 992) {
                        return "sm"
                    } else {
                        if (width < 1200) {
                            return "md"
                        } else {
                            return "lg"
                        }
                    }
                }
            },
            getCurrentScreenFactor: function(screenFactorCallback) {
                var screenFactorFunc = screenFactorCallback || this.defaultScreenFactorFunc;
                var windowWidth = domAdapter.getDocumentElement().clientWidth;
                return screenFactorFunc(windowWidth)
            },
            getNavigator: function() {
                return this.hasWindow() ? windowObject.navigator : {
                    userAgent: ""
                }
            }
        }
    },
    /*!************************************************************!*\
      !*** ./artifacts/transpiled/core/component_registrator.js ***!
      \************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ./renderer */ 2);
        var callbacks = __webpack_require__( /*! ./component_registrator_callbacks */ 154);
        var errors = __webpack_require__( /*! ./errors */ 21);
        var publicComponentUtils = __webpack_require__( /*! ./utils/public_component */ 135);
        var registerComponent = function(name, namespace, componentClass) {
            if (!componentClass) {
                componentClass = namespace
            } else {
                namespace[name] = componentClass
            }
            publicComponentUtils.name(componentClass, name);
            callbacks.fire(name, componentClass)
        };
        var registerRendererComponent = function(name, componentClass) {
            $.fn[name] = function(options) {
                var result, isMemberInvoke = "string" === typeof options;
                if (isMemberInvoke) {
                    var memberName = options,
                        memberArgs = [].slice.call(arguments).slice(1);
                    this.each(function() {
                        var instance = componentClass.getInstance(this);
                        if (!instance) {
                            throw errors.Error("E0009", name)
                        }
                        var member = instance[memberName],
                            memberValue = member.apply(instance, memberArgs);
                        if (void 0 === result) {
                            result = memberValue
                        }
                    })
                } else {
                    this.each(function() {
                        var instance = componentClass.getInstance(this);
                        if (instance) {
                            instance.option(options)
                        } else {
                            new componentClass(this, options)
                        }
                    });
                    result = this
                }
                return result
            }
        };
        callbacks.add(registerRendererComponent);
        module.exports = registerComponent
    },
    /*!**********************************************!*\
      !*** ./artifacts/transpiled/events/utils.js ***!
      \**********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _renderer = __webpack_require__( /*! ../core/renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _events_engine = __webpack_require__( /*! ./core/events_engine */ 5);
        var _events_engine2 = _interopRequireDefault(_events_engine);
        var _errors = __webpack_require__( /*! ../core/errors */ 21);
        var _errors2 = _interopRequireDefault(_errors);
        var _selectors = __webpack_require__( /*! ../ui/widget/selectors */ 65);
        var _extend = __webpack_require__( /*! ../core/utils/extend */ 0);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var KEY_MAP = {
            backspace: "backspace",
            tab: "tab",
            enter: "enter",
            escape: "escape",
            pageup: "pageUp",
            pagedown: "pageDown",
            end: "end",
            home: "home",
            arrowleft: "leftArrow",
            arrowup: "upArrow",
            arrowright: "rightArrow",
            arrowdown: "downArrow",
            "delete": "del",
            " ": "space",
            f: "F",
            a: "A",
            "*": "asterisk",
            "-": "minus",
            alt: "alt",
            control: "control",
            shift: "shift",
            left: "leftArrow",
            up: "upArrow",
            right: "rightArrow",
            down: "downArrow",
            multiply: "asterisk",
            spacebar: "space",
            del: "del",
            subtract: "minus",
            esc: "escape"
        };
        var LEGACY_KEY_CODES = {
            8: "backspace",
            9: "tab",
            13: "enter",
            27: "escape",
            33: "pageUp",
            34: "pageDown",
            35: "end",
            36: "home",
            37: "leftArrow",
            38: "upArrow",
            39: "rightArrow",
            40: "downArrow",
            46: "del",
            32: "space",
            70: "F",
            65: "A",
            106: "asterisk",
            109: "minus",
            189: "minus",
            173: "minus",
            16: "shift",
            17: "control",
            18: "alt"
        };
        var eventSource = function() {
            var EVENT_SOURCES_REGEX = {
                dx: /^dx/i,
                mouse: /(mouse|wheel)/i,
                touch: /^touch/i,
                keyboard: /^key/i,
                pointer: /^(ms)?pointer/i
            };
            return function(e) {
                var result = "other";
                (0, _iterator.each)(EVENT_SOURCES_REGEX, function(key) {
                    if (this.test(e.type)) {
                        result = key;
                        return false
                    }
                });
                return result
            }
        }();
        var isDxEvent = function(e) {
            return "dx" === eventSource(e)
        };
        var isNativeMouseEvent = function(e) {
            return "mouse" === eventSource(e)
        };
        var isNativeTouchEvent = function(e) {
            return "touch" === eventSource(e)
        };
        var isPointerEvent = function(e) {
            return "pointer" === eventSource(e)
        };
        var isMouseEvent = function(e) {
            return isNativeMouseEvent(e) || (isPointerEvent(e) || isDxEvent(e)) && "mouse" === e.pointerType
        };
        var isDxMouseWheelEvent = function(e) {
            return e && "dxmousewheel" === e.type
        };
        var isTouchEvent = function(e) {
            return isNativeTouchEvent(e) || (isPointerEvent(e) || isDxEvent(e)) && "touch" === e.pointerType
        };
        var isKeyboardEvent = function(e) {
            return "keyboard" === eventSource(e)
        };
        var isFakeClickEvent = function(e) {
            return 0 === e.screenX && !e.offsetX && 0 === e.pageX
        };
        var eventData = function(e) {
            return {
                x: e.pageX,
                y: e.pageY,
                time: e.timeStamp
            }
        };
        var eventDelta = function(from, to) {
            return {
                x: to.x - from.x,
                y: to.y - from.y,
                time: to.time - from.time || 1
            }
        };
        var hasTouches = function(e) {
            if (isNativeTouchEvent(e)) {
                return (e.originalEvent.touches || []).length
            }
            if (isDxEvent(e)) {
                return (e.pointers || []).length
            }
            return 0
        };
        var needSkipEvent = function(e) {
            var target = e.target;
            var $target = (0, _renderer2.default)(target);
            var touchInInput = $target.is("input, textarea, select");
            if ($target.is(".dx-skip-gesture-event *, .dx-skip-gesture-event")) {
                return true
            }
            if (isDxMouseWheelEvent(e)) {
                var isTextArea = $target.is("textarea") && $target.hasClass("dx-texteditor-input");
                if (isTextArea) {
                    return false
                }
                var isContentEditable = target.isContentEditable || target.hasAttribute("contenteditable");
                if (isContentEditable) {
                    return false
                }
                var isInputFocused = $target.is("input[type='number'], textarea, select") && $target.is(":focus");
                return isInputFocused
            }
            if (isMouseEvent(e)) {
                return touchInInput || e.which > 1
            }
            if (isTouchEvent(e)) {
                return touchInInput && (0, _selectors.focused)($target)
            }
        };
        var fixMethod = function(e) {
            return e
        };
        var setEventFixMethod = function(func) {
            fixMethod = func
        };
        var copyEvent = function(originalEvent) {
            return fixMethod(_events_engine2.default.Event(originalEvent, originalEvent), originalEvent)
        };
        var createEvent = function(originalEvent, args) {
            var event = copyEvent(originalEvent);
            if (args) {
                (0, _extend.extend)(event, args)
            }
            return event
        };
        var fireEvent = function(props) {
            var event = createEvent(props.originalEvent, props);
            _events_engine2.default.trigger(props.delegateTarget || event.target, event);
            return event
        };
        var addNamespace = function addNamespace(eventNames, namespace) {
            if (!namespace) {
                throw _errors2.default.Error("E0017")
            }
            if ("string" === typeof eventNames) {
                if (eventNames.indexOf(" ") === -1) {
                    return eventNames + "." + namespace
                }
                return addNamespace(eventNames.split(/\s+/g), namespace)
            }(0, _iterator.each)(eventNames, function(index, eventName) {
                eventNames[index] = eventName + "." + namespace
            });
            return eventNames.join(" ")
        };
        var normalizeKeyName = function(event) {
            var isKeySupported = !!event.key;
            var key = isKeySupported ? event.key : event.which;
            if (!key) {
                return
            }
            if (isKeySupported) {
                key = KEY_MAP[key.toLowerCase()] || key
            } else {
                key = LEGACY_KEY_CODES[key] || String.fromCharCode(key)
            }
            return key
        };
        var getChar = function(event) {
            return event.key || String.fromCharCode(event.which)
        };
        module.exports = {
            eventSource: eventSource,
            isPointerEvent: isPointerEvent,
            isMouseEvent: isMouseEvent,
            isDxMouseWheelEvent: isDxMouseWheelEvent,
            isTouchEvent: isTouchEvent,
            isKeyboardEvent: isKeyboardEvent,
            isFakeClickEvent: isFakeClickEvent,
            hasTouches: hasTouches,
            eventData: eventData,
            eventDelta: eventDelta,
            needSkipEvent: needSkipEvent,
            createEvent: createEvent,
            fireEvent: fireEvent,
            addNamespace: addNamespace,
            setEventFixMethod: setEventFixMethod,
            normalizeKeyName: normalizeKeyName,
            getChar: getChar
        }
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/localization/message.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _renderer = __webpack_require__( /*! ../core/renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _dependency_injector = __webpack_require__( /*! ../core/utils/dependency_injector */ 56);
        var _dependency_injector2 = _interopRequireDefault(_dependency_injector);
        var _extend = __webpack_require__( /*! ../core/utils/extend */ 0);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _string = __webpack_require__( /*! ../core/utils/string */ 45);
        var _inflector = __webpack_require__( /*! ../core/utils/inflector */ 32);
        var _core = __webpack_require__( /*! ./core */ 80);
        var _core2 = _interopRequireDefault(_core);
        var _default_messages = __webpack_require__( /*! ./default_messages */ 463);
        var _default_messages2 = _interopRequireDefault(_default_messages);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var baseDictionary = (0, _extend.extend)(true, {}, _default_messages2.default);
        var getDataByLocale = function(localeData, locale) {
            return localeData[locale] || {}
        };
        var newMessages = {};
        var messageLocalization = (0, _dependency_injector2.default)({
            engine: function() {
                return "base"
            },
            _dictionary: baseDictionary,
            load: function(messages) {
                (0, _extend.extend)(true, this._dictionary, messages)
            },
            _localizablePrefix: "@",
            setup: function(localizablePrefix) {
                this._localizablePrefix = localizablePrefix
            },
            localizeString: function(text) {
                var that = this;
                var regex = new RegExp("(^|[^a-zA-Z_0-9" + that._localizablePrefix + "-]+)(" + that._localizablePrefix + "{1,2})([a-zA-Z_0-9-]+)", "g");
                var escapeString = that._localizablePrefix + that._localizablePrefix;
                return text.replace(regex, function(str, prefix, escape, localizationKey) {
                    var defaultResult = that._localizablePrefix + localizationKey;
                    var result = void 0;
                    if (escape !== escapeString) {
                        result = that.format(localizationKey)
                    }
                    if (!result) {
                        newMessages[localizationKey] = (0, _inflector.humanize)(localizationKey)
                    }
                    return prefix + (result || defaultResult)
                })
            },
            localizeNode: function(node) {
                var that = this;
                (0, _renderer2.default)(node).each(function(index, nodeItem) {
                    if (!nodeItem.nodeType) {
                        return
                    }
                    if (3 === nodeItem.nodeType) {
                        nodeItem.nodeValue = that.localizeString(nodeItem.nodeValue)
                    } else {
                        if (!(0, _renderer2.default)(nodeItem).is("iframe")) {
                            (0, _iterator.each)(nodeItem.attributes || [], function(index, attr) {
                                if ("string" === typeof attr.value) {
                                    var localizedValue = that.localizeString(attr.value);
                                    if (attr.value !== localizedValue) {
                                        attr.value = localizedValue
                                    }
                                }
                            });
                            (0, _renderer2.default)(nodeItem).contents().each(function(index, node) {
                                that.localizeNode(node)
                            })
                        }
                    }
                })
            },
            getMessagesByLocales: function() {
                return this._dictionary
            },
            getDictionary: function(onlyNew) {
                if (onlyNew) {
                    return newMessages
                }
                return (0, _extend.extend)({}, newMessages, this.getMessagesByLocales()[_core2.default.locale()])
            },
            getFormatter: function(key) {
                return this._getFormatterBase(key) || this._getFormatterBase(key, "en")
            },
            _getFormatterBase: function(key, locale) {
                var _this = this;
                var message = _core2.default.getValueByClosestLocale(function(locale) {
                    return getDataByLocale(_this._dictionary, locale)[key]
                });
                if (message) {
                    return function() {
                        var args = 1 === arguments.length && Array.isArray(arguments[0]) ? arguments[0].slice(0) : Array.prototype.slice.call(arguments, 0);
                        args.unshift(message);
                        return _string.format.apply(this, args)
                    }
                }
            },
            format: function(key) {
                var formatter = this.getFormatter(key);
                var values = Array.prototype.slice.call(arguments, 1);
                return formatter && formatter.apply(this, values) || ""
            }
        });
        module.exports = messageLocalization
    },
    /*!************************************************!*\
      !*** ./artifacts/transpiled/core/utils/dom.js ***!
      \************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var elementStrategy, $ = __webpack_require__( /*! ../../core/renderer */ 2),
            config = __webpack_require__( /*! ../../core/config */ 29),
            domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 13),
            windowUtils = __webpack_require__( /*! ./window */ 7),
            window = windowUtils.getWindow(),
            eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            inArray = __webpack_require__( /*! ./array */ 14).inArray,
            typeUtils = __webpack_require__( /*! ./type */ 1),
            isDefined = typeUtils.isDefined,
            isRenderer = typeUtils.isRenderer,
            htmlParser = __webpack_require__( /*! ../../core/utils/html_parser */ 260);
        var resetActiveElement = function() {
            var activeElement = domAdapter.getActiveElement(),
                body = domAdapter.getBody();
            if (activeElement && activeElement !== body && activeElement.blur) {
                try {
                    activeElement.blur()
                } catch (e) {
                    body.blur()
                }
            }
        };
        var clearSelection = function() {
            var selection = window.getSelection();
            if (!selection) {
                return
            }
            if ("Caret" === selection.type) {
                return
            }
            if (selection.empty) {
                selection.empty()
            } else {
                if (selection.removeAllRanges) {
                    try {
                        selection.removeAllRanges()
                    } catch (e) {}
                }
            }
        };
        var closestCommonParent = function(startTarget, endTarget) {
            var $startTarget = $(startTarget),
                $endTarget = $(endTarget);
            if ($startTarget[0] === $endTarget[0]) {
                return $startTarget[0]
            }
            var $startParents = $startTarget.parents(),
                $endParents = $endTarget.parents(),
                startingParent = Math.min($startParents.length, $endParents.length);
            for (var i = -startingParent; i < 0; i++) {
                if ($startParents.get(i) === $endParents.get(i)) {
                    return $startParents.get(i)
                }
            }
        };
        var triggerVisibilityChangeEvent = function(eventName) {
            var VISIBILITY_CHANGE_SELECTOR = ".dx-visibility-change-handler";
            return function(element) {
                var $element = $(element || "body");
                var changeHandlers = $element.filter(VISIBILITY_CHANGE_SELECTOR).add($element.find(VISIBILITY_CHANGE_SELECTOR));
                for (var i = 0; i < changeHandlers.length; i++) {
                    eventsEngine.triggerHandler(changeHandlers[i], eventName)
                }
            }
        };
        var uniqueId = function() {
            var counter = 0;
            return function(prefix) {
                return (prefix || "") + counter++
            }
        }();
        var dataOptionsAttributeName = "data-options";
        var getElementOptions = function(element) {
            var optionsString = $(element).attr(dataOptionsAttributeName) || "";
            return config().optionsParser(optionsString)
        };
        var createComponents = function(elements, componentTypes) {
            var result = [],
                selector = "[" + dataOptionsAttributeName + "]";
            var $items = elements.find(selector).add(elements.filter(selector));
            $items.each(function(index, element) {
                var $element = $(element),
                    options = getElementOptions(element);
                for (var componentName in options) {
                    if (!componentTypes || inArray(componentName, componentTypes) > -1) {
                        if ($element[componentName]) {
                            $element[componentName](options[componentName]);
                            result.push($element[componentName]("instance"))
                        }
                    }
                }
            });
            return result
        };
        var createMarkupFromString = function(str) {
            if (!window.WinJS) {
                return $(htmlParser.parseHTML(str))
            }
            var tempElement = $("<div>");
            window.WinJS.Utilities.setInnerHTMLUnsafe(tempElement.get(0), str);
            return tempElement.contents()
        };
        var extractTemplateMarkup = function(element) {
            element = $(element);
            var templateTag = element.length && element.filter(function() {
                var $node = $(this);
                return $node.is("script[type]") && $node.attr("type").indexOf("script") < 0
            });
            if (templateTag.length) {
                return templateTag.eq(0).html()
            } else {
                element = $("<div>").append(element);
                return element.html()
            }
        };
        var normalizeTemplateElement = function normalizeTemplateElement(element) {
            var $element = isDefined(element) && (element.nodeType || isRenderer(element)) ? $(element) : $("<div>").html(element).contents();
            if (1 === $element.length) {
                if ($element.is("script")) {
                    $element = normalizeTemplateElement($element.html().trim())
                } else {
                    if ($element.is("table")) {
                        $element = $element.children("tbody").contents()
                    }
                }
            }
            return $element
        };
        var clipboardText = function(event, text) {
            var clipboard = event.originalEvent && event.originalEvent.clipboardData || window.clipboardData;
            if (1 === arguments.length) {
                return clipboard && clipboard.getData("Text")
            }
            clipboard && clipboard.setData("Text", text)
        };
        var contains = function(container, element) {
            if (!element) {
                return false
            }
            element = domAdapter.isTextNode(element) ? element.parentNode : element;
            return domAdapter.isDocument(container) ? container.documentElement.contains(element) : container.contains(element)
        };
        var getPublicElement = function($element) {
            return elementStrategy($element)
        };
        var setPublicElementWrapper = function(value) {
            elementStrategy = value
        };
        setPublicElementWrapper(function(element) {
            return element && element.get(0)
        });
        var createTextElementHiddenCopy = function(element, text, options) {
            var elementStyles = window.getComputedStyle($(element).get(0));
            var includePaddings = options && options.includePaddings;
            return $("<div>").text(text).css({
                fontStyle: elementStyles.fontStyle,
                fontVariant: elementStyles.fontVariant,
                fontWeight: elementStyles.fontWeight,
                fontSize: elementStyles.fontSize,
                fontFamily: elementStyles.fontFamily,
                letterSpacing: elementStyles.letterSpacing,
                border: elementStyles.border,
                paddingTop: includePaddings ? elementStyles.paddingTop : "",
                paddingRight: includePaddings ? elementStyles.paddingRight : "",
                paddingBottom: includePaddings ? elementStyles.paddingBottom : "",
                paddingLeft: includePaddings ? elementStyles.paddingLeft : "",
                visibility: "hidden",
                whiteSpace: "nowrap",
                position: "absolute",
                "float": "left"
            })
        };
        exports.setPublicElementWrapper = setPublicElementWrapper;
        exports.resetActiveElement = resetActiveElement;
        exports.createMarkupFromString = createMarkupFromString;
        exports.triggerShownEvent = triggerVisibilityChangeEvent("dxshown");
        exports.triggerHidingEvent = triggerVisibilityChangeEvent("dxhiding");
        exports.triggerResizeEvent = triggerVisibilityChangeEvent("dxresize");
        exports.getElementOptions = getElementOptions;
        exports.createComponents = createComponents;
        exports.extractTemplateMarkup = extractTemplateMarkup;
        exports.normalizeTemplateElement = normalizeTemplateElement;
        exports.clearSelection = clearSelection;
        exports.uniqueId = uniqueId;
        exports.closestCommonParent = closestCommonParent;
        exports.clipboardText = clipboardText;
        exports.contains = contains;
        exports.getPublicElement = getPublicElement;
        exports.createTextElementHiddenCopy = createTextElementHiddenCopy
    }, ,
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/core/dom_adapter.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var _dependency_injector = __webpack_require__( /*! ./utils/dependency_injector */ 56);
        var _dependency_injector2 = _interopRequireDefault(_dependency_injector);
        var _common = __webpack_require__( /*! ./utils/common */ 4);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var ELEMENT_NODE = 1;
        var TEXT_NODE = 3;
        var DOCUMENT_NODE = 9;
        var nativeDOMAdapterStrategy = {
            querySelectorAll: function(element, selector) {
                return element.querySelectorAll(selector)
            },
            elementMatches: function(element, selector) {
                var _this = this;
                var matches = element.matches || element.matchesSelector || element.mozMatchesSelector || element.msMatchesSelector || element.oMatchesSelector || element.webkitMatchesSelector || function(selector) {
                    var doc = element.document || element.ownerDocument;
                    if (!doc) {
                        return false
                    }
                    var items = _this.querySelectorAll(doc, selector);
                    for (var i = 0; i < items.length; i++) {
                        if (items[i] === element) {
                            return true
                        }
                    }
                };
                return matches.call(element, selector)
            },
            createElement: function(tagName, context) {
                context = context || this._document;
                return context.createElement(tagName)
            },
            createElementNS: function(ns, tagName, context) {
                context = context || this._document;
                return context.createElementNS(ns, tagName)
            },
            createTextNode: function(text, context) {
                context = context || this._document;
                return context.createTextNode(text)
            },
            isNode: function(element) {
                return "object" === ("undefined" === typeof element ? "undefined" : _typeof(element)) && "nodeType" in element
            },
            isElementNode: function(element) {
                return element && element.nodeType === ELEMENT_NODE
            },
            isTextNode: function(element) {
                return element && element.nodeType === TEXT_NODE
            },
            isDocument: function(element) {
                return element && element.nodeType === DOCUMENT_NODE
            },
            removeElement: function(element) {
                var parentNode = element && element.parentNode;
                if (parentNode) {
                    parentNode.removeChild(element)
                }
            },
            insertElement: function(parentElement, newElement, nextSiblingElement) {
                if (parentElement && newElement && parentElement !== newElement) {
                    if (nextSiblingElement) {
                        parentElement.insertBefore(newElement, nextSiblingElement)
                    } else {
                        parentElement.appendChild(newElement)
                    }
                }
            },
            getAttribute: function(element, name) {
                return element.getAttribute(name)
            },
            setAttribute: function(element, name, value) {
                element.setAttribute(name, value)
            },
            removeAttribute: function(element, name) {
                element.removeAttribute(name)
            },
            setProperty: function(element, name, value) {
                element[name] = value
            },
            setText: function(element, text) {
                if (element) {
                    element.textContent = text
                }
            },
            setClass: function(element, className, isAdd) {
                if (1 === element.nodeType && className) {
                    if (element.classList) {
                        if (isAdd) {
                            element.classList.add(className)
                        } else {
                            element.classList.remove(className)
                        }
                    } else {
                        var classNameSupported = "string" === typeof element.className;
                        var elementClass = classNameSupported ? element.className : this.getAttribute(element, "class") || "";
                        var classNames = elementClass.split(" ");
                        var classIndex = classNames.indexOf(className);
                        var resultClassName = void 0;
                        if (isAdd && classIndex < 0) {
                            resultClassName = elementClass ? elementClass + " " + className : className
                        }
                        if (!isAdd && classIndex >= 0) {
                            classNames.splice(classIndex, 1);
                            resultClassName = classNames.join(" ")
                        }
                        if (void 0 !== resultClassName) {
                            if (classNameSupported) {
                                element.className = resultClassName
                            } else {
                                this.setAttribute(element, "class", resultClassName)
                            }
                        }
                    }
                }
            },
            setStyle: function(element, name, value) {
                element.style[name] = value || ""
            },
            _document: "undefined" === typeof document ? void 0 : document,
            getDocument: function() {
                return this._document
            },
            getActiveElement: function() {
                return this._document.activeElement
            },
            getBody: function() {
                return this._document.body
            },
            createDocumentFragment: function() {
                return this._document.createDocumentFragment()
            },
            getDocumentElement: function() {
                return this._document.documentElement
            },
            getLocation: function() {
                return this._document.location
            },
            getSelection: function() {
                return this._document.selection
            },
            getReadyState: function() {
                return this._document.readyState
            },
            getHead: function() {
                return this._document.head
            },
            hasDocumentProperty: function(property) {
                return property in this._document
            },
            listen: function(element, event, callback, options) {
                if (!element || !("addEventListener" in element)) {
                    return _common.noop
                }
                element.addEventListener(event, callback, options);
                return function() {
                    element.removeEventListener(event, callback)
                }
            }
        };
        module.exports = (0, _dependency_injector2.default)(nativeDOMAdapterStrategy)
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/core/utils/array.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var isDefined = __webpack_require__( /*! ./type */ 1).isDefined,
            each = __webpack_require__( /*! ./iterator */ 3).each,
            objectUtils = __webpack_require__( /*! ./object */ 47),
            config = __webpack_require__( /*! ../config */ 29);
        var isEmpty = function(entity) {
            return Array.isArray(entity) && !entity.length
        };
        var wrapToArray = function(entity) {
            return Array.isArray(entity) ? entity : [entity]
        };
        var intersection = function(a, b) {
            if (!Array.isArray(a) || 0 === a.length || !Array.isArray(b) || 0 === b.length) {
                return []
            }
            var result = [];
            each(a, function(_, value) {
                var index = inArray(value, b);
                if (index !== -1) {
                    result.push(value)
                }
            });
            return result
        };
        var removeDuplicates = function(from, what) {
            if (!Array.isArray(from) || 0 === from.length) {
                return []
            }
            if (!Array.isArray(what) || 0 === what.length) {
                return from.slice()
            }
            var result = [];
            each(from, function(_, value) {
                var index = inArray(value, what);
                if (index === -1) {
                    result.push(value)
                }
            });
            return result
        };
        var normalizeIndexes = function(items, indexParameterName, currentItem, needIndexCallback) {
            var indexedItems = {},
                parameterIndex = 0,
                useLegacyVisibleIndex = config().useLegacyVisibleIndex;
            each(items, function(index, item) {
                index = item[indexParameterName];
                if (index >= 0) {
                    indexedItems[index] = indexedItems[index] || [];
                    if (item === currentItem) {
                        indexedItems[index].unshift(item)
                    } else {
                        indexedItems[index].push(item)
                    }
                } else {
                    item[indexParameterName] = void 0
                }
            });
            if (!useLegacyVisibleIndex) {
                each(items, function() {
                    if (!isDefined(this[indexParameterName]) && (!needIndexCallback || needIndexCallback(this))) {
                        while (indexedItems[parameterIndex]) {
                            parameterIndex++
                        }
                        indexedItems[parameterIndex] = [this];
                        parameterIndex++
                    }
                })
            }
            parameterIndex = 0;
            objectUtils.orderEach(indexedItems, function(index, items) {
                each(items, function() {
                    if (index >= 0) {
                        this[indexParameterName] = parameterIndex++
                    }
                })
            });
            if (useLegacyVisibleIndex) {
                each(items, function() {
                    if (!isDefined(this[indexParameterName]) && (!needIndexCallback || needIndexCallback(this))) {
                        this[indexParameterName] = parameterIndex++
                    }
                })
            }
            return parameterIndex
        };
        var inArray = function(value, object) {
            if (!object) {
                return -1
            }
            var array = Array.isArray(object) ? object : object.toArray();
            return array.indexOf(value)
        };
        var merge = function(array1, array2) {
            for (var i = 0; i < array2.length; i++) {
                array1[array1.length] = array2[i]
            }
            return array1
        };
        var find = function(array, condition) {
            for (var i = 0; i < array.length; i++) {
                if (condition(array[i])) {
                    return array[i]
                }
            }
        };
        exports.isEmpty = isEmpty;
        exports.wrapToArray = wrapToArray;
        exports.intersection = intersection;
        exports.removeDuplicates = removeDuplicates;
        exports.normalizeIndexes = normalizeIndexes;
        exports.inArray = inArray;
        exports.merge = merge;
        exports.find = find
    },
    /*!********************************************!*\
      !*** ./artifacts/transpiled/core/class.js ***!
      \********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var errors = __webpack_require__( /*! ./errors */ 21),
            typeUtils = __webpack_require__( /*! ./utils/type */ 1);
        var wrapOverridden = function(baseProto, methodName, method) {
            return function() {
                var prevCallBase = this.callBase;
                this.callBase = baseProto[methodName];
                try {
                    return method.apply(this, arguments)
                } finally {
                    this.callBase = prevCallBase
                }
            }
        };
        var clonePrototype = function(obj) {
            var func = function() {};
            func.prototype = obj.prototype;
            return new func
        };
        var redefine = function(members) {
            var overridden, memberName, member, that = this;
            if (!members) {
                return that
            }
            for (memberName in members) {
                member = members[memberName];
                overridden = "function" === typeof that.prototype[memberName] && "function" === typeof member;
                that.prototype[memberName] = overridden ? wrapOverridden(that.parent.prototype, memberName, member) : member
            }
            return that
        };
        var include = function() {
            var argument, name, i, classObj = this;
            var hasClassObjOwnProperty = Object.prototype.hasOwnProperty.bind(classObj);
            var isES6Class = !hasClassObjOwnProperty("_includedCtors") && !hasClassObjOwnProperty("_includedPostCtors");
            if (isES6Class) {
                classObj._includedCtors = classObj._includedCtors.slice(0);
                classObj._includedPostCtors = classObj._includedPostCtors.slice(0)
            }
            for (i = 0; i < arguments.length; i++) {
                argument = arguments[i];
                if (argument.ctor) {
                    classObj._includedCtors.push(argument.ctor)
                }
                if (argument.postCtor) {
                    classObj._includedPostCtors.push(argument.postCtor)
                }
                for (name in argument) {
                    if ("ctor" === name || "postCtor" === name) {
                        continue
                    }
                    if (name in classObj.prototype) {
                        throw errors.Error("E0002", name)
                    }
                    classObj.prototype[name] = argument[name]
                }
            }
            return classObj
        };
        var subclassOf = function(parentClass) {
            if (this.parent === parentClass) {
                return true
            }
            if (!this.parent || !this.parent.subclassOf) {
                return false
            }
            return this.parent.subclassOf(parentClass)
        };
        var abstract = function() {
            throw errors.Error("E0001")
        };
        var copyStatic = function() {
            var hasOwn = Object.prototype.hasOwnProperty;
            return function(source, destination) {
                for (var key in source) {
                    if (!hasOwn.call(source, key)) {
                        return
                    }
                    destination[key] = source[key]
                }
            }
        }();
        var classImpl = function() {};
        classImpl.inherit = function(members) {
            var inheritor = function() {
                if (!this || typeUtils.isWindow(this) || "function" !== typeof this.constructor) {
                    throw errors.Error("E0003")
                }
                var i, instance = this,
                    ctor = instance.ctor,
                    includedCtors = instance.constructor._includedCtors,
                    includedPostCtors = instance.constructor._includedPostCtors;
                for (i = 0; i < includedCtors.length; i++) {
                    includedCtors[i].call(instance)
                }
                if (ctor) {
                    ctor.apply(instance, arguments)
                }
                for (i = 0; i < includedPostCtors.length; i++) {
                    includedPostCtors[i].call(instance)
                }
            };
            inheritor.prototype = clonePrototype(this);
            copyStatic(this, inheritor);
            inheritor.inherit = this.inherit;
            inheritor.abstract = abstract;
            inheritor.redefine = redefine;
            inheritor.include = include;
            inheritor.subclassOf = subclassOf;
            inheritor.parent = this;
            inheritor._includedCtors = this._includedCtors ? this._includedCtors.slice(0) : [];
            inheritor._includedPostCtors = this._includedPostCtors ? this._includedPostCtors.slice(0) : [];
            inheritor.prototype.constructor = inheritor;
            inheritor.redefine(members);
            return inheritor
        };
        classImpl.abstract = abstract;
        module.exports = classImpl
    },
    /*!**********************************************!*\
      !*** ./artifacts/transpiled/core/devices.js ***!
      \**********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            windowUtils = __webpack_require__( /*! ./utils/window */ 7),
            navigator = windowUtils.getNavigator(),
            window = windowUtils.getWindow(),
            extend = __webpack_require__( /*! ./utils/extend */ 0).extend,
            isPlainObject = __webpack_require__( /*! ./utils/type */ 1).isPlainObject,
            each = __webpack_require__( /*! ./utils/iterator */ 3).each,
            Class = __webpack_require__( /*! ./class */ 15),
            errors = __webpack_require__( /*! ./errors */ 21),
            Callbacks = __webpack_require__( /*! ./utils/callbacks */ 26),
            resizeCallbacks = __webpack_require__( /*! ./utils/resize_callbacks */ 134),
            EventsMixin = __webpack_require__( /*! ./events_mixin */ 85),
            SessionStorage = __webpack_require__( /*! ./utils/storage */ 288).sessionStorage,
            viewPort = __webpack_require__( /*! ./utils/view_port */ 72),
            Config = __webpack_require__( /*! ./config */ 29);
        var KNOWN_UA_TABLE = {
            iPhone: "iPhone",
            iPhone5: "iPhone",
            iPhone6: "iPhone",
            iPhone6plus: "iPhone",
            iPad: "iPad",
            iPadMini: "iPad Mini",
            androidPhone: "Android Mobile",
            androidTablet: "Android",
            msSurface: "Windows ARM Tablet PC",
            desktop: "desktop"
        };
        var DEFAULT_DEVICE = {
            deviceType: "desktop",
            platform: "generic",
            version: [],
            phone: false,
            tablet: false,
            android: false,
            ios: false,
            generic: true,
            grade: "A",
            mac: false
        };
        var uaParsers = {
            generic: function(userAgent) {
                var isPhone = /windows phone/i.test(userAgent) || userAgent.match(/WPDesktop/),
                    isTablet = !isPhone && /Windows(.*)arm(.*)Tablet PC/i.test(userAgent),
                    isDesktop = !isPhone && !isTablet && /msapphost/i.test(userAgent),
                    isMac = /((intel|ppc) mac os x)/.test(userAgent.toLowerCase());
                if (!(isPhone || isTablet || isDesktop || isMac)) {
                    return
                }
                return {
                    deviceType: isPhone ? "phone" : isTablet ? "tablet" : "desktop",
                    platform: "generic",
                    version: [],
                    grade: "A",
                    mac: isMac
                }
            },
            ios: function(userAgent) {
                if (!/ip(hone|od|ad)/i.test(userAgent)) {
                    return
                }
                var isPhone = /ip(hone|od)/i.test(userAgent),
                    matches = userAgent.match(/os (\d+)_(\d+)_?(\d+)?/i),
                    version = matches ? [parseInt(matches[1], 10), parseInt(matches[2], 10), parseInt(matches[3] || 0, 10)] : [],
                    isIPhone4 = 480 === window.screen.height,
                    grade = isIPhone4 ? "B" : "A";
                return {
                    deviceType: isPhone ? "phone" : "tablet",
                    platform: "ios",
                    version: version,
                    grade: grade
                }
            },
            android: function(userAgent) {
                if (!/android|htc_|silk/i.test(userAgent)) {
                    return
                }
                var isPhone = /mobile/i.test(userAgent),
                    matches = userAgent.match(/android (\d+)\.?(\d+)?\.?(\d+)?/i),
                    version = matches ? [parseInt(matches[1], 10), parseInt(matches[2] || 0, 10), parseInt(matches[3] || 0, 10)] : [],
                    worseThan4_4 = version.length > 1 && (version[0] < 4 || 4 === version[0] && version[1] < 4),
                    grade = worseThan4_4 ? "B" : "A";
                return {
                    deviceType: isPhone ? "phone" : "tablet",
                    platform: "android",
                    version: version,
                    grade: grade
                }
            }
        };
        var Devices = Class.inherit({
            ctor: function(options) {
                this._window = options && options.window || window;
                this._realDevice = this._getDevice();
                this._currentDevice = void 0;
                this._currentOrientation = void 0;
                this.changed = Callbacks();
                if (windowUtils.hasWindow()) {
                    this._recalculateOrientation();
                    resizeCallbacks.add(this._recalculateOrientation.bind(this))
                }
            },
            current: function(deviceOrName) {
                if (deviceOrName) {
                    this._currentDevice = this._getDevice(deviceOrName);
                    this._forced = true;
                    this.changed.fire();
                    return
                }
                if (!this._currentDevice) {
                    deviceOrName = void 0;
                    try {
                        deviceOrName = this._getDeviceOrNameFromWindowScope()
                    } catch (e) {
                        deviceOrName = this._getDeviceNameFromSessionStorage()
                    } finally {
                        if (!deviceOrName) {
                            deviceOrName = this._getDeviceNameFromSessionStorage()
                        }
                        if (deviceOrName) {
                            this._forced = true
                        }
                    }
                    this._currentDevice = this._getDevice(deviceOrName)
                }
                return this._currentDevice
            },
            real: function() {
                var forceDevice = arguments[0];
                if (isPlainObject(forceDevice)) {
                    extend(this._realDevice, forceDevice);
                    return
                }
                return extend({}, this._realDevice)
            },
            orientation: function() {
                return this._currentOrientation
            },
            isForced: function() {
                return this._forced
            },
            isRippleEmulator: function() {
                return !!this._window.tinyHippos
            },
            _getCssClasses: function(device) {
                var result = [];
                var realDevice = this._realDevice;
                device = device || this.current();
                if (device.deviceType) {
                    result.push("dx-device-" + device.deviceType);
                    if ("desktop" !== device.deviceType) {
                        result.push("dx-device-mobile")
                    }
                }
                result.push("dx-device-" + realDevice.platform);
                if (realDevice.version && realDevice.version.length) {
                    result.push("dx-device-" + realDevice.platform + "-" + realDevice.version[0])
                }
                if (devices.isSimulator()) {
                    result.push("dx-simulator")
                }
                if (Config().rtlEnabled) {
                    result.push("dx-rtl")
                }
                return result
            },
            attachCssClasses: function(element, device) {
                this._deviceClasses = this._getCssClasses(device).join(" ");
                $(element).addClass(this._deviceClasses)
            },
            detachCssClasses: function(element) {
                $(element).removeClass(this._deviceClasses)
            },
            isSimulator: function() {
                try {
                    return this._isSimulator || windowUtils.hasWindow() && this._window.top !== this._window.self && this._window.top["dx-force-device"] || this.isRippleEmulator()
                } catch (e) {
                    return false
                }
            },
            forceSimulator: function() {
                this._isSimulator = true
            },
            _getDevice: function(deviceName) {
                if ("genericPhone" === deviceName) {
                    deviceName = {
                        deviceType: "phone",
                        platform: "generic",
                        generic: true
                    }
                }
                if (isPlainObject(deviceName)) {
                    return this._fromConfig(deviceName)
                } else {
                    var ua;
                    if (deviceName) {
                        ua = KNOWN_UA_TABLE[deviceName];
                        if (!ua) {
                            throw errors.Error("E0005")
                        }
                    } else {
                        ua = navigator.userAgent
                    }
                    return this._fromUA(ua)
                }
            },
            _getDeviceOrNameFromWindowScope: function() {
                var result;
                if (windowUtils.hasWindow() && (this._window.top["dx-force-device-object"] || this._window.top["dx-force-device"])) {
                    result = this._window.top["dx-force-device-object"] || this._window.top["dx-force-device"]
                }
                return result
            },
            _getDeviceNameFromSessionStorage: function() {
                var sessionStorage = SessionStorage();
                if (!sessionStorage) {
                    return
                }
                var deviceOrName = sessionStorage.getItem("dx-force-device");
                try {
                    return JSON.parse(deviceOrName)
                } catch (ex) {
                    return deviceOrName
                }
            },
            _fromConfig: function(config) {
                var result = extend({}, DEFAULT_DEVICE, this._currentDevice, config),
                    shortcuts = {
                        phone: "phone" === result.deviceType,
                        tablet: "tablet" === result.deviceType,
                        android: "android" === result.platform,
                        ios: "ios" === result.platform,
                        generic: "generic" === result.platform
                    };
                return extend(result, shortcuts)
            },
            _fromUA: function(ua) {
                var config;
                each(uaParsers, function(platform, parser) {
                    config = parser(ua);
                    return !config
                });
                if (config) {
                    return this._fromConfig(config)
                }
                return DEFAULT_DEVICE
            },
            _changeOrientation: function() {
                var $window = $(this._window),
                    orientation = $window.height() > $window.width() ? "portrait" : "landscape";
                if (this._currentOrientation === orientation) {
                    return
                }
                this._currentOrientation = orientation;
                this.fireEvent("orientationChanged", [{
                    orientation: orientation
                }])
            },
            _recalculateOrientation: function() {
                var windowWidth = $(this._window).width();
                if (this._currentWidth === windowWidth) {
                    return
                }
                this._currentWidth = windowWidth;
                this._changeOrientation()
            }
        }).include(EventsMixin);
        var devices = new Devices;
        viewPort.changeCallback.add(function(viewPort, prevViewport) {
            devices.detachCssClasses(prevViewport);
            devices.attachCssClasses(viewPort)
        });
        module.exports = devices
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/ui/widget/ui.widget.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            Action = __webpack_require__( /*! ../../core/action */ 111),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            inArray = __webpack_require__( /*! ../../core/utils/array */ 14).inArray,
            each = __webpack_require__( /*! ../../core/utils/iterator */ 3).each,
            commonUtils = __webpack_require__( /*! ../../core/utils/common */ 4),
            typeUtils = __webpack_require__( /*! ../../core/utils/type */ 1),
            domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 13),
            DOMComponentWithTemplate = __webpack_require__( /*! ../../core/dom_component_with_template */ 171),
            KeyboardProcessor = __webpack_require__( /*! ./ui.keyboard_processor */ 172),
            selectors = __webpack_require__( /*! ./selectors */ 65),
            eventUtils = __webpack_require__( /*! ../../events/utils */ 9),
            hoverEvents = __webpack_require__( /*! ../../events/hover */ 150),
            feedbackEvents = __webpack_require__( /*! ../../events/core/emitter.feedback */ 128),
            clickEvent = __webpack_require__( /*! ../../events/click */ 19);
        var UI_FEEDBACK = "UIFeedback",
            WIDGET_CLASS = "dx-widget",
            ACTIVE_STATE_CLASS = "dx-state-active",
            DISABLED_STATE_CLASS = "dx-state-disabled",
            INVISIBLE_STATE_CLASS = "dx-state-invisible",
            HOVER_STATE_CLASS = "dx-state-hover",
            FOCUSED_STATE_CLASS = "dx-state-focused",
            FEEDBACK_SHOW_TIMEOUT = 30,
            FEEDBACK_HIDE_TIMEOUT = 400,
            FOCUS_NAMESPACE = "Focus";
        var Widget = DOMComponentWithTemplate.inherit({
            _supportedKeys: function() {
                return {}
            },
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    disabled: false,
                    visible: true,
                    hint: void 0,
                    activeStateEnabled: false,
                    onContentReady: null,
                    hoverStateEnabled: false,
                    focusStateEnabled: false,
                    tabIndex: 0,
                    accessKey: null,
                    onFocusIn: null,
                    onFocusOut: null,
                    _keyboardProcessor: void 0
                })
            },
            _feedbackShowTimeout: FEEDBACK_SHOW_TIMEOUT,
            _feedbackHideTimeout: FEEDBACK_HIDE_TIMEOUT,
            _init: function() {
                this.callBase();
                this._initContentReadyAction()
            },
            _clearInnerOptionCache: function(optionContainer) {
                this[optionContainer + "Cache"] = {}
            },
            _cacheInnerOptions: function(optionContainer, optionValue) {
                var cacheName = optionContainer + "Cache";
                this[cacheName] = extend(this[cacheName], optionValue)
            },
            _getOptionsFromContainer: function(_ref) {
                var name = _ref.name,
                    fullName = _ref.fullName,
                    value = _ref.value;
                var options = {};
                if (name === fullName) {
                    options = value
                } else {
                    var option = fullName.split(".").pop();
                    options[option] = value
                }
                return options
            },
            _innerOptionChanged: function(innerWidget, args) {
                var options = this._getOptionsFromContainer(args);
                innerWidget && innerWidget.option(options);
                this._cacheInnerOptions(args.name, options)
            },
            _getInnerOptionsCache: function(optionContainer) {
                return this[optionContainer + "Cache"]
            },
            _initInnerOptionCache: function(optionContainer) {
                this._clearInnerOptionCache(optionContainer);
                this._cacheInnerOptions(optionContainer, this.option(optionContainer))
            },
            _bindInnerWidgetOptions: function(innerWidget, optionsContainer) {
                this._options[optionsContainer] = extend({}, innerWidget.option());
                innerWidget.on("optionChanged", function(e) {
                    this._options[optionsContainer] = extend({}, e.component.option())
                }.bind(this))
            },
            _getAriaTarget: function() {
                return this._focusTarget()
            },
            _initContentReadyAction: function() {
                this._contentReadyAction = this._createActionByOption("onContentReady", {
                    excludeValidators: ["disabled", "readOnly"]
                })
            },
            _initMarkup: function() {
                this.$element().addClass(WIDGET_CLASS);
                this._toggleDisabledState(this.option("disabled"));
                this._toggleVisibility(this.option("visible"));
                this._renderHint();
                if (this._isFocusable()) {
                    this._renderFocusTarget()
                }
                this.callBase()
            },
            _render: function() {
                this.callBase();
                this._renderContent();
                this._renderFocusState();
                this._attachFeedbackEvents();
                this._attachHoverEvents()
            },
            _renderHint: function() {
                var hint = this.option("hint");
                this.$element().attr("title", hint ? hint : null)
            },
            _renderContent: function() {
                var _this = this;
                commonUtils.deferRender(function() {
                    if (_this._disposed) {
                        return
                    }
                    return _this._renderContentImpl()
                }).done(function() {
                    if (_this._disposed) {
                        return
                    }
                    _this._fireContentReadyAction()
                })
            },
            _renderContentImpl: commonUtils.noop,
            _fireContentReadyAction: commonUtils.deferRenderer(function() {
                this._contentReadyAction()
            }),
            _dispose: function() {
                this._contentReadyAction = null;
                this.callBase()
            },
            _resetActiveState: function() {
                this._toggleActiveState(this._eventBindingTarget(), false)
            },
            _clean: function() {
                this._cleanFocusState();
                this._resetActiveState();
                this.callBase();
                this.$element().empty()
            },
            _toggleVisibility: function(visible) {
                this.$element().toggleClass(INVISIBLE_STATE_CLASS, !visible);
                this.setAria("hidden", !visible || void 0)
            },
            _renderFocusState: function() {
                this._attachKeyboardEvents();
                if (!this._isFocusable()) {
                    return
                }
                this._renderFocusTarget();
                this._attachFocusEvents();
                this._renderAccessKey()
            },
            _renderAccessKey: function() {
                var focusTarget = this._focusTarget();
                focusTarget.attr("accesskey", this.option("accessKey"));
                var clickNamespace = eventUtils.addNamespace(clickEvent.name, UI_FEEDBACK);
                eventsEngine.off(focusTarget, clickNamespace);
                this.option("accessKey") && eventsEngine.on(focusTarget, clickNamespace, function(e) {
                    if (eventUtils.isFakeClickEvent(e)) {
                        e.stopImmediatePropagation();
                        this.focus()
                    }
                }.bind(this))
            },
            _isFocusable: function() {
                return this.option("focusStateEnabled") && !this.option("disabled")
            },
            _eventBindingTarget: function() {
                return this.$element()
            },
            _focusTarget: function() {
                return this._getActiveElement()
            },
            _getActiveElement: function() {
                var activeElement = this._eventBindingTarget();
                if (this._activeStateUnit) {
                    activeElement = activeElement.find(this._activeStateUnit).not("." + DISABLED_STATE_CLASS)
                }
                return activeElement
            },
            _renderFocusTarget: function() {
                this._focusTarget().attr("tabIndex", this.option("tabIndex"))
            },
            _keyboardEventBindingTarget: function() {
                return this._eventBindingTarget()
            },
            _detachFocusEvents: function() {
                var $element = this._focusEventTarget(),
                    namespace = this.NAME + FOCUS_NAMESPACE,
                    focusEvents = eventUtils.addNamespace("focusin", namespace);
                focusEvents = focusEvents + " " + eventUtils.addNamespace("focusout", namespace);
                if (domAdapter.hasDocumentProperty("onbeforeactivate")) {
                    focusEvents = focusEvents + " " + eventUtils.addNamespace("beforeactivate", namespace)
                }
                eventsEngine.off($element, focusEvents)
            },
            _attachFocusEvents: function() {
                var namespace = this.NAME + FOCUS_NAMESPACE,
                    focusInEvent = eventUtils.addNamespace("focusin", namespace),
                    focusOutEvent = eventUtils.addNamespace("focusout", namespace);
                var $focusTarget = this._focusEventTarget();
                eventsEngine.on($focusTarget, focusInEvent, this._focusInHandler.bind(this));
                eventsEngine.on($focusTarget, focusOutEvent, this._focusOutHandler.bind(this));
                if (domAdapter.hasDocumentProperty("onbeforeactivate")) {
                    var beforeActivateEvent = eventUtils.addNamespace("beforeactivate", namespace);
                    eventsEngine.on(this._focusEventTarget(), beforeActivateEvent, function(e) {
                        if (!$(e.target).is(selectors.focusable)) {
                            e.preventDefault()
                        }
                    })
                }
            },
            _refreshFocusEvent: function() {
                this._detachFocusEvents();
                this._attachFocusEvents()
            },
            _focusEventTarget: function() {
                return this._focusTarget()
            },
            _focusInHandler: function(e) {
                if (e.isDefaultPrevented()) {
                    return
                }
                var that = this;
                that._createActionByOption("onFocusIn", {
                    beforeExecute: function() {
                        that._updateFocusState(e, true)
                    },
                    excludeValidators: ["readOnly"]
                })({
                    event: e
                })
            },
            _focusOutHandler: function(e) {
                if (e.isDefaultPrevented()) {
                    return
                }
                var that = this;
                that._createActionByOption("onFocusOut", {
                    beforeExecute: function() {
                        that._updateFocusState(e, false)
                    },
                    excludeValidators: ["readOnly", "disabled"]
                })({
                    event: e
                })
            },
            _updateFocusState: function(e, isFocused) {
                var target = e.target;
                if (inArray(target, this._focusTarget()) !== -1) {
                    this._toggleFocusClass(isFocused, $(target))
                }
            },
            _toggleFocusClass: function(isFocused, $element) {
                var $focusTarget = $element && $element.length ? $element : this._focusTarget();
                $focusTarget.toggleClass(FOCUSED_STATE_CLASS, isFocused)
            },
            _hasFocusClass: function(element) {
                var $focusTarget = $(element || this._focusTarget());
                return $focusTarget.hasClass(FOCUSED_STATE_CLASS)
            },
            _isFocused: function() {
                return this._hasFocusClass()
            },
            _attachKeyboardEvents: function() {
                var processor = this.option("_keyboardProcessor");
                if (processor) {
                    this._keyboardProcessor = processor.reinitialize(this._keyboardHandler, this)
                } else {
                    if (this.option("focusStateEnabled")) {
                        this._disposeKeyboardProcessor();
                        this._keyboardProcessor = new KeyboardProcessor({
                            element: this._keyboardEventBindingTarget(),
                            handler: this._keyboardHandler,
                            focusTarget: this._focusTarget(),
                            context: this
                        })
                    }
                }
            },
            _keyboardHandler: function(options) {
                var e = options.originalEvent;
                var keyName = options.keyName;
                var keyCode = options.which;
                var keys = this._supportedKeys(e),
                    func = keys[keyName] || keys[keyCode];
                if (void 0 !== func) {
                    var handler = func.bind(this);
                    return handler(e) || false
                } else {
                    return true
                }
            },
            _refreshFocusState: function() {
                this._cleanFocusState();
                this._renderFocusState()
            },
            _cleanFocusState: function() {
                var $element = this._focusTarget();
                this._detachFocusEvents();
                this._toggleFocusClass(false);
                $element.removeAttr("tabIndex");
                this._disposeKeyboardProcessor()
            },
            _disposeKeyboardProcessor: function() {
                if (this._keyboardProcessor) {
                    this._keyboardProcessor.dispose();
                    delete this._keyboardProcessor
                }
            },
            _attachHoverEvents: function() {
                var that = this,
                    hoverableSelector = that._activeStateUnit,
                    nameStart = eventUtils.addNamespace(hoverEvents.start, UI_FEEDBACK),
                    nameEnd = eventUtils.addNamespace(hoverEvents.end, UI_FEEDBACK);
                eventsEngine.off(that._eventBindingTarget(), nameStart, hoverableSelector);
                eventsEngine.off(that._eventBindingTarget(), nameEnd, hoverableSelector);
                if (that.option("hoverStateEnabled")) {
                    var startAction = new Action(function(args) {
                        that._hoverStartHandler(args.event);
                        that._refreshHoveredElement($(args.element))
                    }, {
                        excludeValidators: ["readOnly"]
                    });
                    var $eventBindingTarget = that._eventBindingTarget();
                    eventsEngine.on($eventBindingTarget, nameStart, hoverableSelector, function(e) {
                        startAction.execute({
                            element: $(e.target),
                            event: e
                        })
                    });
                    eventsEngine.on($eventBindingTarget, nameEnd, hoverableSelector, function(e) {
                        that._hoverEndHandler(e);
                        that._forgetHoveredElement()
                    })
                } else {
                    that._toggleHoverClass(false)
                }
            },
            _hoverStartHandler: commonUtils.noop,
            _hoverEndHandler: commonUtils.noop,
            _attachFeedbackEvents: function() {
                var feedbackAction, feedbackActionDisabled, that = this,
                    feedbackSelector = that._activeStateUnit,
                    activeEventName = eventUtils.addNamespace(feedbackEvents.active, UI_FEEDBACK),
                    inactiveEventName = eventUtils.addNamespace(feedbackEvents.inactive, UI_FEEDBACK);
                eventsEngine.off(that._eventBindingTarget(), activeEventName, feedbackSelector);
                eventsEngine.off(that._eventBindingTarget(), inactiveEventName, feedbackSelector);
                if (that.option("activeStateEnabled")) {
                    var feedbackActionHandler = function(args) {
                        var $element = $(args.element),
                            value = args.value,
                            dxEvent = args.event;
                        that._toggleActiveState($element, value, dxEvent)
                    };
                    eventsEngine.on(that._eventBindingTarget(), activeEventName, feedbackSelector, {
                        timeout: that._feedbackShowTimeout
                    }, function(e) {
                        feedbackAction = feedbackAction || new Action(feedbackActionHandler);
                        feedbackAction.execute({
                            element: $(e.currentTarget),
                            value: true,
                            event: e
                        })
                    });
                    eventsEngine.on(that._eventBindingTarget(), inactiveEventName, feedbackSelector, {
                        timeout: that._feedbackHideTimeout
                    }, function(e) {
                        feedbackActionDisabled = feedbackActionDisabled || new Action(feedbackActionHandler, {
                            excludeValidators: ["disabled", "readOnly"]
                        });
                        feedbackActionDisabled.execute({
                            element: $(e.currentTarget),
                            value: false,
                            event: e
                        })
                    })
                }
            },
            _toggleActiveState: function($element, value) {
                this._toggleHoverClass(!value);
                $element.toggleClass(ACTIVE_STATE_CLASS, value)
            },
            _refreshHoveredElement: function(hoveredElement) {
                var selector = this._activeStateUnit || this._eventBindingTarget();
                this._forgetHoveredElement();
                this._hoveredElement = hoveredElement.closest(selector);
                this._toggleHoverClass(true)
            },
            _forgetHoveredElement: function() {
                this._toggleHoverClass(false);
                delete this._hoveredElement
            },
            _toggleHoverClass: function(value) {
                if (this._hoveredElement) {
                    this._hoveredElement.toggleClass(HOVER_STATE_CLASS, value && this.option("hoverStateEnabled"))
                }
            },
            _toggleDisabledState: function(value) {
                this.$element().toggleClass(DISABLED_STATE_CLASS, Boolean(value));
                this._toggleHoverClass(!value);
                this.setAria("disabled", value || void 0)
            },
            _setWidgetOption: function(widgetName, args) {
                if (!this[widgetName]) {
                    return
                }
                if (typeUtils.isPlainObject(args[0])) {
                    each(args[0], function(option, value) {
                        this._setWidgetOption(widgetName, [option, value])
                    }.bind(this));
                    return
                }
                var optionName = args[0];
                var value = args[1];
                if (1 === args.length) {
                    value = this.option(optionName)
                }
                var widgetOptionMap = this[widgetName + "OptionMap"];
                this[widgetName].option(widgetOptionMap ? widgetOptionMap(optionName) : optionName, value)
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "disabled":
                        this._toggleDisabledState(args.value);
                        this._refreshFocusState();
                        break;
                    case "hint":
                        this._renderHint();
                        break;
                    case "activeStateEnabled":
                        this._attachFeedbackEvents();
                        break;
                    case "hoverStateEnabled":
                        this._attachHoverEvents();
                        break;
                    case "tabIndex":
                    case "_keyboardProcessor":
                    case "focusStateEnabled":
                        this._refreshFocusState();
                        break;
                    case "onFocusIn":
                    case "onFocusOut":
                        break;
                    case "accessKey":
                        this._renderAccessKey();
                        break;
                    case "visible":
                        var visible = args.value;
                        this._toggleVisibility(visible);
                        if (this._isVisibilityChangeSupported()) {
                            this._checkVisibilityChanged(args.value ? "shown" : "hiding")
                        }
                        break;
                    case "onContentReady":
                        this._initContentReadyAction();
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _isVisible: function() {
                return this.callBase() && this.option("visible")
            },
            beginUpdate: function() {
                this._ready(false);
                this.callBase()
            },
            endUpdate: function() {
                this.callBase();
                if (this._initialized) {
                    this._ready(true)
                }
            },
            _ready: function(value) {
                if (0 === arguments.length) {
                    return this._isReady
                }
                this._isReady = value
            },
            setAria: function() {
                var setAttribute = function(option) {
                    var attrName = "role" === option.name || "id" === option.name ? option.name : "aria-" + option.name,
                        attrValue = option.value;
                    if (typeUtils.isDefined(attrValue)) {
                        attrValue = attrValue.toString()
                    } else {
                        attrValue = null
                    }
                    option.target.attr(attrName, attrValue)
                };
                if (!typeUtils.isPlainObject(arguments[0])) {
                    setAttribute({
                        name: arguments[0],
                        value: arguments[1],
                        target: arguments[2] || this._getAriaTarget()
                    })
                } else {
                    var $target = arguments[1] || this._getAriaTarget();
                    each(arguments[0], function(key, value) {
                        setAttribute({
                            name: key,
                            value: value,
                            target: $target
                        })
                    })
                }
            },
            isReady: function() {
                return this._ready()
            },
            repaint: function() {
                this._refresh()
            },
            focus: function() {
                eventsEngine.trigger(this._focusTarget(), "focus")
            },
            registerKeyHandler: function(key, handler) {
                var currentKeys = this._supportedKeys(),
                    addingKeys = {};
                addingKeys[key] = handler;
                this._supportedKeys = function() {
                    return extend(currentKeys, addingKeys)
                }
            }
        });
        module.exports = Widget
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/ui/widget/ui.errors.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var errorUtils = __webpack_require__( /*! ../../core/utils/error */ 132),
            errors = __webpack_require__( /*! ../../core/errors */ 21);
        module.exports = errorUtils(errors.ERROR_MESSAGES, {
            E1001: "Module '{0}'. Controller '{1}' is already registered",
            E1002: "Module '{0}'. Controller '{1}' does not inherit from DevExpress.ui.dxDataGrid.Controller",
            E1003: "Module '{0}'. View '{1}' is already registered",
            E1004: "Module '{0}'. View '{1}' does not inherit from DevExpress.ui.dxDataGrid.View",
            E1005: "Public method '{0}' is already registered",
            E1006: "Public method '{0}.{1}' does not exist",
            E1007: "State storing cannot be provided due to the restrictions of the browser",
            E1010: "The template does not contain the TextBox widget",
            E1011: 'Items cannot be deleted from the List. Implement the "remove" function in the data store',
            E1012: "Editing type '{0}' with the name '{1}' is unsupported",
            E1016: "Unexpected type of data source is provided for a lookup column",
            E1018: "The 'collapseAll' method cannot be called if you use a remote data source",
            E1019: "Search mode '{0}' is unavailable",
            E1020: "The type cannot be changed after initialization",
            E1021: "{0} '{1}' you are trying to remove does not exist",
            E1022: 'The "markers" option is given an invalid value. Assign an array instead',
            E1023: 'The "routes" option is given an invalid value. Assign an array instead',
            E1025: "This layout is too complex to render",
            E1026: 'The "calculateCustomSummary" function is missing from a field whose "summaryType" option is set to "custom"',
            E1030: "Unknown ScrollView refresh strategy: '{0}'",
            E1031: "Unknown subscription in the Scheduler widget: '{0}'",
            E1032: "Unknown start date in an appointment: '{0}'",
            E1033: "Unknown step in the date navigator: '{0}'",
            E1034: "The browser does not implement an API for saving files",
            E1035: "The editor cannot be created because of an internal error: {0}",
            E1037: "Invalid structure of grouped data",
            E1038: "The browser does not support local storages for local web pages",
            E1039: "A cell's position cannot be calculated",
            E1040: "The '{0}' key value is not unique within the data array",
            E1041: "The '{0}' script is referenced after the DevExtreme scripts or not referenced at all",
            E1042: "{0} requires the key field to be specified",
            E1043: "Changes cannot be processed due to the incorrectly set key",
            E1044: "The key field specified by the keyExpr option does not match the key field specified in the data store",
            E1045: "Editing requires the key field to be specified in the data store",
            E1046: "The '{0}' key field is not found in data objects",
            E1047: 'The "{0}" field is not found in the fields array',
            E1048: 'The "{0}" operation is not found in the filterOperations array',
            E1049: "Column '{0}': filtering is allowed but the 'dataField' or 'name' option is not specified",
            E1050: "The validationRules option does not apply to third-party editors defined in the editCellTemplate",
            E1051: 'HtmlEditor\'s valueType is "{0}", but the {0} converter was not imported.',
            E1052: '{0} should have the "dataSource" option specified',
            E1053: 'The "buttons" option accepts an array that contains only objects or string values',
            E1054: "All text editor buttons must have names",
            E1055: 'One or several text editor buttons have invalid or non-unique "name" values',
            E1056: 'The {0} widget does not support buttons of the "{1}" type',
            E1057: 'The {0} widget does not support asynchronous validation rules in the "{1}" edit mode',
            W1001: 'The "key" option cannot be modified after initialization',
            W1002: "An item with the key '{0}' does not exist",
            W1003: "A group with the key '{0}' in which you are trying to select items does not exist",
            W1004: "The item '{0}' you are trying to select in the group '{1}' does not exist",
            W1005: "Due to column data types being unspecified, data has been loaded twice in order to apply initial filter settings. To resolve this issue, specify data types for all grid columns.",
            W1006: "The map service returned the following error: '{0}'",
            W1007: "No item with key {0} was found in the data source, but this key was used as the parent key for item {1}",
            W1008: "Cannot scroll to the '{0}' date because it does not exist on the current view",
            W1009: "Searching works only if data is specified using the dataSource option",
            W1010: "The capability to select all items works with source data of plain structure only",
            W1011: 'The "keyExpr" option is not applied when dataSource is not an array',
            W1012: "The '{0}' key field is not found in data objects",
            W1013: 'The "message" field in the dialog component was renamed to "messageHtml". Change your code correspondingly. In addition, if you used HTML code in the message, make sure that it is secure',
            W1014: "The Floating Action Button exceeds the recommended speed dial action count. If you need to display more speed dial actions, increase the maxSpeedDialActionCount option value in the global config."
        })
    },
    /*!**********************************************!*\
      !*** ./artifacts/transpiled/events/click.js ***!
      \**********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            eventsEngine = __webpack_require__( /*! ../events/core/events_engine */ 5),
            devices = __webpack_require__( /*! ../core/devices */ 16),
            domAdapter = __webpack_require__( /*! ../core/dom_adapter */ 13),
            domUtils = __webpack_require__( /*! ../core/utils/dom */ 11),
            animationFrame = __webpack_require__( /*! ../animation/frame */ 113),
            eventUtils = __webpack_require__( /*! ./utils */ 9),
            pointerEvents = __webpack_require__( /*! ./pointer */ 24),
            Emitter = __webpack_require__( /*! ./core/emitter */ 126),
            registerEmitter = __webpack_require__( /*! ./core/emitter_registrator */ 95),
            compareVersions = __webpack_require__( /*! ../core/utils/version */ 53).compare;
        var CLICK_EVENT_NAME = "dxclick",
            TOUCH_BOUNDARY = 10,
            abs = Math.abs;
        var isInput = function(element) {
            return $(element).is("input, textarea, select, button ,:focus, :focus *")
        };
        var misc = {
            requestAnimationFrame: animationFrame.requestAnimationFrame,
            cancelAnimationFrame: animationFrame.cancelAnimationFrame
        };
        var ClickEmitter = Emitter.inherit({
            ctor: function(element) {
                this.callBase(element);
                this._makeElementClickable($(element))
            },
            _makeElementClickable: function($element) {
                if (!$element.attr("onclick")) {
                    $element.attr("onclick", "void(0)")
                }
            },
            start: function(e) {
                this._blurPrevented = e.isDefaultPrevented();
                this._startTarget = e.target;
                this._startEventData = eventUtils.eventData(e)
            },
            end: function(e) {
                if (this._eventOutOfElement(e, this.getElement().get(0)) || e.type === pointerEvents.cancel) {
                    this._cancel(e);
                    return
                }
                if (!isInput(e.target) && !this._blurPrevented) {
                    domUtils.resetActiveElement()
                }
                this._accept(e);
                this._clickAnimationFrame = misc.requestAnimationFrame(function() {
                    this._fireClickEvent(e)
                }.bind(this))
            },
            _eventOutOfElement: function(e, element) {
                var target = e.target,
                    targetChanged = !domUtils.contains(element, target) && element !== target,
                    gestureDelta = eventUtils.eventDelta(eventUtils.eventData(e), this._startEventData),
                    boundsExceeded = abs(gestureDelta.x) > TOUCH_BOUNDARY || abs(gestureDelta.y) > TOUCH_BOUNDARY;
                return targetChanged || boundsExceeded
            },
            _fireClickEvent: function(e) {
                this._fireEvent(CLICK_EVENT_NAME, e, {
                    target: domUtils.closestCommonParent(this._startTarget, e.target)
                })
            },
            dispose: function() {
                misc.cancelAnimationFrame(this._clickAnimationFrame)
            }
        });
        ! function() {
            var NATIVE_CLICK_CLASS = "dx-native-click";
            var realDevice = devices.real(),
                useNativeClick = realDevice.generic || realDevice.ios && compareVersions(realDevice.version, [9, 3]) >= 0 || realDevice.android && compareVersions(realDevice.version, [5]) >= 0;
            var isNativeClickEvent = function(target) {
                return useNativeClick || $(target).closest("." + NATIVE_CLICK_CLASS).length
            };
            var prevented = null,
                lastFiredEvent = null;
            var clickHandler = function(e) {
                var originalEvent = e.originalEvent,
                    eventAlreadyFired = lastFiredEvent === originalEvent || originalEvent && originalEvent.DXCLICK_FIRED,
                    leftButton = !e.which || 1 === e.which;
                if (leftButton && !prevented && isNativeClickEvent(e.target) && !eventAlreadyFired) {
                    if (originalEvent) {
                        originalEvent.DXCLICK_FIRED = true
                    }
                    lastFiredEvent = originalEvent;
                    eventUtils.fireEvent({
                        type: CLICK_EVENT_NAME,
                        originalEvent: e
                    })
                }
            };
            ClickEmitter = ClickEmitter.inherit({
                _makeElementClickable: function($element) {
                    if (!isNativeClickEvent($element)) {
                        this.callBase($element)
                    }
                    eventsEngine.on($element, "click", clickHandler)
                },
                configure: function(data) {
                    this.callBase(data);
                    if (data.useNative) {
                        this.getElement().addClass(NATIVE_CLICK_CLASS)
                    }
                },
                start: function(e) {
                    prevented = null;
                    if (!isNativeClickEvent(e.target)) {
                        this.callBase(e)
                    }
                },
                end: function(e) {
                    if (!isNativeClickEvent(e.target)) {
                        this.callBase(e)
                    }
                },
                cancel: function() {
                    prevented = true
                },
                dispose: function() {
                    this.callBase();
                    eventsEngine.off(this.getElement(), "click", clickHandler)
                }
            });
            exports.useNativeClick = useNativeClick
        }();
        ! function() {
            var desktopDevice = devices.real().generic;
            if (!desktopDevice) {
                var startTarget = null,
                    blurPrevented = false;
                var pointerDownHandler = function(e) {
                    startTarget = e.target;
                    blurPrevented = e.isDefaultPrevented()
                };
                var clickHandler = function(e) {
                    var $target = $(e.target);
                    if (!blurPrevented && startTarget && !$target.is(startTarget) && !$(startTarget).is("label") && isInput($target)) {
                        domUtils.resetActiveElement()
                    }
                    startTarget = null;
                    blurPrevented = false
                };
                var NATIVE_CLICK_FIXER_NAMESPACE = "NATIVE_CLICK_FIXER",
                    document = domAdapter.getDocument();
                eventsEngine.subscribeGlobal(document, eventUtils.addNamespace(pointerEvents.down, NATIVE_CLICK_FIXER_NAMESPACE), pointerDownHandler);
                eventsEngine.subscribeGlobal(document, eventUtils.addNamespace("click", NATIVE_CLICK_FIXER_NAMESPACE), clickHandler)
            }
        }();
        registerEmitter({
            emitter: ClickEmitter,
            bubble: true,
            events: [CLICK_EVENT_NAME]
        });
        exports.name = CLICK_EVENT_NAME;
        exports.misc = misc
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/core/utils/data.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var errors = __webpack_require__( /*! ../errors */ 21),
            Class = __webpack_require__( /*! ../class */ 15),
            objectUtils = __webpack_require__( /*! ./object */ 47),
            typeUtils = __webpack_require__( /*! ./type */ 1),
            each = __webpack_require__( /*! ./iterator */ 3).each,
            variableWrapper = __webpack_require__( /*! ./variable_wrapper */ 87),
            unwrapVariable = variableWrapper.unwrap,
            isWrapped = variableWrapper.isWrapped,
            assign = variableWrapper.assign;
        var bracketsToDots = function(expr) {
            return expr.replace(/\[/g, ".").replace(/\]/g, "")
        };
        var readPropValue = function(obj, propName, options) {
            options = options || {};
            if ("this" === propName) {
                return unwrap(obj, options)
            }
            return unwrap(obj[propName], options)
        };
        var assignPropValue = function(obj, propName, value, options) {
            if ("this" === propName) {
                throw new errors.Error("E4016")
            }
            var propValue = obj[propName];
            if (options.unwrapObservables && isWrapped(propValue)) {
                assign(propValue, value)
            } else {
                obj[propName] = value
            }
        };
        var prepareOptions = function(options) {
            options = options || {};
            options.unwrapObservables = void 0 !== options.unwrapObservables ? options.unwrapObservables : true;
            return options
        };
        var unwrap = function(value, options) {
            return options.unwrapObservables ? unwrapVariable(value) : value
        };
        var compileGetter = function(expr) {
            if (arguments.length > 1) {
                expr = [].slice.call(arguments)
            }
            if (!expr || "this" === expr) {
                return function(obj) {
                    return obj
                }
            }
            if ("string" === typeof expr) {
                expr = bracketsToDots(expr);
                var path = expr.split(".");
                return function(obj, options) {
                    options = prepareOptions(options);
                    var functionAsIs = options.functionsAsIs,
                        hasDefaultValue = "defaultValue" in options,
                        current = unwrap(obj, options);
                    for (var i = 0; i < path.length; i++) {
                        if (!current) {
                            if (null == current && hasDefaultValue) {
                                return options.defaultValue
                            }
                            break
                        }
                        var pathPart = path[i];
                        if (hasDefaultValue && typeUtils.isObject(current) && !(pathPart in current)) {
                            return options.defaultValue
                        }
                        var next = unwrap(current[pathPart], options);
                        if (!functionAsIs && typeUtils.isFunction(next)) {
                            next = next.call(current)
                        }
                        current = next
                    }
                    return current
                }
            }
            if (Array.isArray(expr)) {
                return combineGetters(expr)
            }
            if (typeUtils.isFunction(expr)) {
                return expr
            }
        };
        var combineGetters = function(getters) {
            var compiledGetters = {};
            for (var i = 0, l = getters.length; i < l; i++) {
                var getter = getters[i];
                compiledGetters[getter] = compileGetter(getter)
            }
            return function(obj, options) {
                var result;
                each(compiledGetters, function(name) {
                    var current, path, pathItem, last, i, value = this(obj, options);
                    if (void 0 === value) {
                        return
                    }
                    current = result || (result = {});
                    path = name.split(".");
                    last = path.length - 1;
                    for (i = 0; i < last; i++) {
                        pathItem = path[i];
                        if (!(pathItem in current)) {
                            current[pathItem] = {}
                        }
                        current = current[pathItem]
                    }
                    current[path[last]] = value
                });
                return result
            }
        };
        var ensurePropValueDefined = function(obj, propName, value, options) {
            if (typeUtils.isDefined(value)) {
                return value
            }
            var newValue = {};
            assignPropValue(obj, propName, newValue, options);
            return newValue
        };
        var compileSetter = function(expr) {
            expr = bracketsToDots(expr || "this").split(".");
            var lastLevelIndex = expr.length - 1;
            return function(obj, value, options) {
                options = prepareOptions(options);
                var currentValue = unwrap(obj, options);
                expr.forEach(function(propertyName, levelIndex) {
                    var propertyValue = readPropValue(currentValue, propertyName, options),
                        isPropertyFunc = !options.functionsAsIs && typeUtils.isFunction(propertyValue) && !isWrapped(propertyValue);
                    if (levelIndex === lastLevelIndex) {
                        if (options.merge && typeUtils.isPlainObject(value) && (!typeUtils.isDefined(propertyValue) || typeUtils.isPlainObject(propertyValue))) {
                            propertyValue = ensurePropValueDefined(currentValue, propertyName, propertyValue, options);
                            objectUtils.deepExtendArraySafe(propertyValue, value, false, true)
                        } else {
                            if (isPropertyFunc) {
                                currentValue[propertyName](value)
                            } else {
                                assignPropValue(currentValue, propertyName, value, options)
                            }
                        }
                    } else {
                        propertyValue = ensurePropValueDefined(currentValue, propertyName, propertyValue, options);
                        if (isPropertyFunc) {
                            propertyValue = propertyValue.call(currentValue)
                        }
                        currentValue = propertyValue
                    }
                })
            }
        };
        var toComparable = function(value, caseSensitive) {
            if (value instanceof Date) {
                return value.getTime()
            }
            if (value && value instanceof Class && value.valueOf) {
                return value.valueOf()
            }
            if (!caseSensitive && "string" === typeof value) {
                return value.toLowerCase()
            }
            return value
        };
        exports.compileGetter = compileGetter;
        exports.compileSetter = compileSetter;
        exports.toComparable = toComparable
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/core/errors.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var errorUtils = __webpack_require__( /*! ./utils/error */ 132);
        module.exports = errorUtils({
            E0001: "Method is not implemented",
            E0002: "Member name collision: {0}",
            E0003: "A class must be instantiated using the 'new' keyword",
            E0004: "The NAME property of the component is not specified",
            E0005: "Unknown device",
            E0006: "Unknown endpoint key is requested",
            E0007: "'Invalidate' method is called outside the update transaction",
            E0008: "Type of the option name is not appropriate to create an action",
            E0009: "Component '{0}' has not been initialized for an element",
            E0010: "Animation configuration with the '{0}' type requires '{1}' configuration as {2}",
            E0011: "Unknown animation type '{0}'",
            E0012: "jQuery version is too old. Please upgrade jQuery to 1.10.0 or later",
            E0013: "KnockoutJS version is too old. Please upgrade KnockoutJS to 2.3.0 or later",
            E0014: "The 'release' method shouldn't be called for an unlocked Lock object",
            E0015: "Queued task returned an unexpected result",
            E0017: "Event namespace is not defined",
            E0018: "DevExpress.ui.DevExpressPopup widget is required",
            E0020: "Template engine '{0}' is not supported",
            E0021: "Unknown theme is set: {0}",
            E0022: "LINK[rel=DevExpress-theme] tags must go before DevExpress included scripts",
            E0023: "Template name is not specified",
            E0024: "DevExtreme bundle already included",
            E0025: "Unexpected argument type",
            E0100: "Unknown validation type is detected",
            E0101: "Misconfigured range validation rule is detected",
            E0102: "Misconfigured comparison validation rule is detected",
            E0103: "validationCallback of an asynchronous rule should return jQuery or a native promise",
            E0110: "Unknown validation group is detected",
            E0120: "Adapter for a DevExpressValidator component cannot be configured",
            E0121: "The 'customItem' field of the 'onCustomItemCreating' function's parameter should contain a custom item or Promise that is resolved after the item is created.",
            W0000: "'{0}' is deprecated in {1}. {2}",
            W0001: "{0} - '{1}' option is deprecated in {2}. {3}",
            W0002: "{0} - '{1}' method is deprecated in {2}. {3}",
            W0003: "{0} - '{1}' property is deprecated in {2}. {3}",
            W0004: "Timeout for theme loading is over: {0}",
            W0005: "'{0}' event is deprecated in {1}. {2}",
            W0006: "Invalid recurrence rule: '{0}'",
            W0007: "'{0}' Globalize culture is not defined",
            W0008: "Invalid view name: '{0}'",
            W0009: "Invalid time zone name: '{0}'",
            W0010: "{0} is deprecated in {1}. {2}",
            W0011: "Number parsing is invoked while the parser is not defined",
            W0012: "Date parsing is invoked while the parser is not defined",
            W0013: "'{0}' file is deprecated in {1}. {2}",
            W0014: "{0} - '{1}' type is deprecated in {2}. {3}",
            W0015: "Instead of returning a value from the '{0}' function, write it into the '{1}' field of the function's parameter.",
            W0016: 'The "{0}" option does not accept the "{1}" value since v.{2}. {3}.'
        })
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/core/utils/date.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var typeUtils = __webpack_require__( /*! ./type */ 1),
            adjust = __webpack_require__( /*! ./math */ 30).adjust,
            each = __webpack_require__( /*! ./iterator */ 3).each,
            camelize = __webpack_require__( /*! ./inflector */ 32).camelize,
            isObject = typeUtils.isObject,
            isString = typeUtils.isString,
            isDate = typeUtils.isDate,
            isDefined = typeUtils.isDefined;
        var dateUnitIntervals = ["millisecond", "second", "minute", "hour", "day", "week", "month", "quarter", "year"];
        var toMilliseconds = function toMilliseconds(value) {
            switch (value) {
                case "millisecond":
                    return 1;
                case "second":
                    return 1e3 * toMilliseconds("millisecond");
                case "minute":
                    return 60 * toMilliseconds("second");
                case "hour":
                    return 60 * toMilliseconds("minute");
                case "day":
                    return 24 * toMilliseconds("hour");
                case "week":
                    return 7 * toMilliseconds("day");
                case "month":
                    return 30 * toMilliseconds("day");
                case "quarter":
                    return 3 * toMilliseconds("month");
                case "year":
                    return 365 * toMilliseconds("day");
                default:
                    return 0
            }
        };
        var getDatesInterval = function(startDate, endDate, intervalUnit) {
            var delta = endDate.getTime() - startDate.getTime(),
                millisecondCount = toMilliseconds(intervalUnit) || 1;
            return Math.floor(delta / millisecondCount)
        };
        var getNextDateUnit = function(unit, withWeeks) {
            var interval = getDateUnitInterval(unit);
            switch (interval) {
                case "millisecond":
                    return "second";
                case "second":
                    return "minute";
                case "minute":
                    return "hour";
                case "hour":
                    return "day";
                case "day":
                    return withWeeks ? "week" : "month";
                case "week":
                    return "month";
                case "month":
                    return "quarter";
                case "quarter":
                    return "year";
                case "year":
                    return "year";
                default:
                    return 0
            }
        };
        var convertMillisecondsToDateUnits = function(value) {
            var i, dateUnitCount, dateUnitInterval, dateUnitIntervals = ["millisecond", "second", "minute", "hour", "day", "month", "year"],
                result = {};
            for (i = dateUnitIntervals.length - 1; i >= 0; i--) {
                dateUnitInterval = dateUnitIntervals[i];
                dateUnitCount = Math.floor(value / toMilliseconds(dateUnitInterval));
                if (dateUnitCount > 0) {
                    result[dateUnitInterval + "s"] = dateUnitCount;
                    value -= convertDateUnitToMilliseconds(dateUnitInterval, dateUnitCount)
                }
            }
            return result
        };
        var dateToMilliseconds = function(tickInterval) {
            var milliseconds = 0;
            if (isObject(tickInterval)) {
                each(tickInterval, function(key, value) {
                    milliseconds += convertDateUnitToMilliseconds(key.substr(0, key.length - 1), value)
                })
            }
            if (isString(tickInterval)) {
                milliseconds = convertDateUnitToMilliseconds(tickInterval, 1)
            }
            return milliseconds
        };
        var convertDateUnitToMilliseconds = function(dateUnit, count) {
            return toMilliseconds(dateUnit) * count
        };
        var getDateUnitInterval = function(tickInterval) {
            var i, maxInterval = -1;
            if (isString(tickInterval)) {
                return tickInterval
            }
            if (isObject(tickInterval)) {
                each(tickInterval, function(key, value) {
                    for (i = 0; i < dateUnitIntervals.length; i++) {
                        if (value && (key === dateUnitIntervals[i] + "s" || key === dateUnitIntervals[i]) && maxInterval < i) {
                            maxInterval = i
                        }
                    }
                });
                return dateUnitIntervals[maxInterval]
            }
            return ""
        };
        var tickIntervalToFormatMap = {
            millisecond: "millisecond",
            second: "longtime",
            minute: "shorttime",
            hour: "shorttime",
            day: "day",
            week: "day",
            month: "month",
            quarter: "quarter",
            year: "year"
        };

        function getDateFormatByTickInterval(tickInterval) {
            return tickIntervalToFormatMap[getDateUnitInterval(tickInterval)] || ""
        }
        var getQuarter = function(month) {
            return Math.floor(month / 3)
        };
        var getFirstQuarterMonth = function(month) {
            return 3 * getQuarter(month)
        };
        var correctDateWithUnitBeginning = function(date, dateInterval, withCorrection, firstDayOfWeek) {
            date = new Date(date.getTime());
            var firstQuarterMonth, month, oldDate = new Date(date.getTime()),
                dateUnitInterval = getDateUnitInterval(dateInterval);
            switch (dateUnitInterval) {
                case "second":
                    date = new Date(1e3 * Math.floor(oldDate.getTime() / 1e3));
                    break;
                case "minute":
                    date = new Date(6e4 * Math.floor(oldDate.getTime() / 6e4));
                    break;
                case "hour":
                    date = new Date(36e5 * Math.floor(oldDate.getTime() / 36e5));
                    break;
                case "year":
                    date.setMonth(0);
                case "month":
                    date.setDate(1);
                case "day":
                    date.setHours(0, 0, 0, 0);
                    break;
                case "week":
                    date = getFirstWeekDate(date, firstDayOfWeek || 0);
                    date.setHours(0, 0, 0, 0);
                    break;
                case "quarter":
                    firstQuarterMonth = getFirstQuarterMonth(date.getMonth());
                    month = date.getMonth();
                    date.setDate(1);
                    date.setHours(0, 0, 0, 0);
                    if (month !== firstQuarterMonth) {
                        date.setMonth(firstQuarterMonth)
                    }
            }
            if (withCorrection && "hour" !== dateUnitInterval && "minute" !== dateUnitInterval && "second" !== dateUnitInterval) {
                fixTimezoneGap(oldDate, date)
            }
            return date
        };
        var trimTime = function(date) {
            return dateUtils.correctDateWithUnitBeginning(date, "day")
        };
        var setToDayEnd = function(date) {
            var result = dateUtils.trimTime(date);
            result.setDate(result.getDate() + 1);
            return new Date(result.getTime() - 1)
        };
        var getDatesDifferences = function(date1, date2) {
            var differences, counter = 0;
            differences = {
                year: date1.getFullYear() !== date2.getFullYear(),
                month: date1.getMonth() !== date2.getMonth(),
                day: date1.getDate() !== date2.getDate(),
                hour: date1.getHours() !== date2.getHours(),
                minute: date1.getMinutes() !== date2.getMinutes(),
                second: date1.getSeconds() !== date2.getSeconds(),
                millisecond: date1.getMilliseconds() !== date2.getMilliseconds()
            };
            each(differences, function(key, value) {
                if (value) {
                    counter++
                }
            });
            if (0 === counter && 0 !== getTimezonesDifference(date1, date2)) {
                differences.hour = true;
                counter++
            }
            differences.count = counter;
            return differences
        };

        function addDateInterval(value, interval, dir) {
            var result = new Date(value.getTime()),
                intervalObject = isString(interval) ? getDateIntervalByString(interval.toLowerCase()) : typeUtils.isNumeric(interval) ? convertMillisecondsToDateUnits(interval) : interval;
            if (intervalObject.years) {
                result.setFullYear(result.getFullYear() + intervalObject.years * dir)
            }
            if (intervalObject.quarters) {
                result.setMonth(result.getMonth() + 3 * intervalObject.quarters * dir)
            }
            if (intervalObject.months) {
                result.setMonth(result.getMonth() + intervalObject.months * dir)
            }
            if (intervalObject.weeks) {
                result.setDate(result.getDate() + 7 * intervalObject.weeks * dir)
            }
            if (intervalObject.days) {
                result.setDate(result.getDate() + intervalObject.days * dir)
            }
            if (intervalObject.hours) {
                result.setTime(result.getTime() + 36e5 * intervalObject.hours * dir)
            }
            if (intervalObject.minutes) {
                result.setTime(result.getTime() + 6e4 * intervalObject.minutes * dir)
            }
            if (intervalObject.seconds) {
                result.setTime(result.getTime() + 1e3 * intervalObject.seconds * dir)
            }
            if (intervalObject.milliseconds) {
                result.setTime(result.getTime() + intervalObject.milliseconds * dir)
            }
            return result
        }
        var addInterval = function(value, interval, isNegative) {
            var dir = isNegative ? -1 : 1;
            return isDate(value) ? addDateInterval(value, interval, dir) : adjust(value + interval * dir, interval)
        };
        var getSequenceByInterval = function(min, max, interval) {
            var cur, intervals = [];
            intervals.push(isDate(min) ? new Date(min.getTime()) : min);
            cur = min;
            while (cur < max) {
                cur = addInterval(cur, interval);
                intervals.push(cur)
            }
            return intervals
        };
        var getViewFirstCellDate = function(viewType, date) {
            if ("month" === viewType) {
                return new Date(date.getFullYear(), date.getMonth(), 1)
            }
            if ("year" === viewType) {
                return new Date(date.getFullYear(), 0, date.getDate())
            }
            if ("decade" === viewType) {
                return new Date(getFirstYearInDecade(date), date.getMonth(), date.getDate())
            }
            if ("century" === viewType) {
                return new Date(getFirstDecadeInCentury(date), date.getMonth(), date.getDate())
            }
        };
        var getViewLastCellDate = function(viewType, date) {
            if ("month" === viewType) {
                return new Date(date.getFullYear(), date.getMonth(), getLastMonthDay(date))
            }
            if ("year" === viewType) {
                return new Date(date.getFullYear(), 11, date.getDate())
            }
            if ("decade" === viewType) {
                return new Date(getFirstYearInDecade(date) + 9, date.getMonth(), date.getDate())
            }
            if ("century" === viewType) {
                return new Date(getFirstDecadeInCentury(date) + 90, date.getMonth(), date.getDate())
            }
        };
        var getViewMinBoundaryDate = function(viewType, date) {
            var resultDate = new Date(date.getFullYear(), date.getMonth(), 1);
            if ("month" === viewType) {
                return resultDate
            }
            resultDate.setMonth(0);
            if ("year" === viewType) {
                return resultDate
            }
            if ("decade" === viewType) {
                resultDate.setFullYear(getFirstYearInDecade(date))
            }
            if ("century" === viewType) {
                resultDate.setFullYear(getFirstDecadeInCentury(date))
            }
            return resultDate
        };
        var getViewMaxBoundaryDate = function(viewType, date) {
            var resultDate = new Date(date);
            resultDate.setDate(getLastMonthDay(date));
            if ("month" === viewType) {
                return resultDate
            }
            resultDate.setMonth(11);
            resultDate.setDate(getLastMonthDay(resultDate));
            if ("year" === viewType) {
                return resultDate
            }
            if ("decade" === viewType) {
                resultDate.setFullYear(getFirstYearInDecade(date) + 9)
            }
            if ("century" === viewType) {
                resultDate.setFullYear(getFirstDecadeInCentury(date) + 99)
            }
            return resultDate
        };
        var getLastMonthDay = function(date) {
            var resultDate = new Date(date.getFullYear(), date.getMonth() + 1, 0);
            return resultDate.getDate()
        };
        var sameView = function(view, date1, date2) {
            return dateUtils[camelize("same " + view)](date1, date2)
        };
        var getViewUp = function(typeView) {
            switch (typeView) {
                case "month":
                    return "year";
                case "year":
                    return "decade";
                case "decade":
                    return "century"
            }
        };
        var getViewDown = function(typeView) {
            switch (typeView) {
                case "century":
                    return "decade";
                case "decade":
                    return "year";
                case "year":
                    return "month"
            }
        };
        var getDifferenceInMonth = function(typeView) {
            var difference = 1;
            if ("year" === typeView) {
                difference = 12
            }
            if ("decade" === typeView) {
                difference = 120
            }
            if ("century" === typeView) {
                difference = 1200
            }
            return difference
        };
        var getDifferenceInMonthForCells = function(typeView) {
            var difference = 1;
            if ("decade" === typeView) {
                difference = 12
            }
            if ("century" === typeView) {
                difference = 120
            }
            return difference
        };
        var getDateIntervalByString = function(intervalString) {
            var result = {};
            switch (intervalString) {
                case "year":
                    result.years = 1;
                    break;
                case "month":
                    result.months = 1;
                    break;
                case "quarter":
                    result.months = 3;
                    break;
                case "week":
                    result.weeks = 1;
                    break;
                case "day":
                    result.days = 1;
                    break;
                case "hour":
                    result.hours = 1;
                    break;
                case "minute":
                    result.minutes = 1;
                    break;
                case "second":
                    result.seconds = 1;
                    break;
                case "millisecond":
                    result.milliseconds = 1
            }
            return result
        };
        var sameDate = function(date1, date2) {
            return sameMonthAndYear(date1, date2) && date1.getDate() === date2.getDate()
        };
        var sameMonthAndYear = function(date1, date2) {
            return sameYear(date1, date2) && date1.getMonth() === date2.getMonth()
        };
        var sameYear = function(date1, date2) {
            return date1 && date2 && date1.getFullYear() === date2.getFullYear()
        };
        var sameDecade = function(date1, date2) {
            if (!isDefined(date1) || !isDefined(date2)) {
                return
            }
            var startDecadeDate1 = date1.getFullYear() - date1.getFullYear() % 10,
                startDecadeDate2 = date2.getFullYear() - date2.getFullYear() % 10;
            return date1 && date2 && startDecadeDate1 === startDecadeDate2
        };
        var sameCentury = function(date1, date2) {
            if (!isDefined(date1) || !isDefined(date2)) {
                return
            }
            var startCenturyDate1 = date1.getFullYear() - date1.getFullYear() % 100,
                startCenturyDate2 = date2.getFullYear() - date2.getFullYear() % 100;
            return date1 && date2 && startCenturyDate1 === startCenturyDate2
        };
        var getFirstDecadeInCentury = function(date) {
            return date && date.getFullYear() - date.getFullYear() % 100
        };
        var getFirstYearInDecade = function(date) {
            return date && date.getFullYear() - date.getFullYear() % 10
        };
        var getShortDateFormat = function() {
            return "yyyy/MM/dd"
        };
        var getFirstMonthDate = function(date) {
            if (!isDefined(date)) {
                return
            }
            var newDate = new Date(date.getFullYear(), date.getMonth(), 1);
            return newDate
        };
        var getLastMonthDate = function(date) {
            if (!isDefined(date)) {
                return
            }
            var newDate = new Date(date.getFullYear(), date.getMonth() + 1, 0);
            return newDate
        };
        var getFirstWeekDate = function(date, firstDayOfWeek) {
            var delta = (date.getDay() - firstDayOfWeek + 7) % 7;
            var result = new Date(date);
            result.setDate(date.getDate() - delta);
            return result
        };
        var normalizeDateByWeek = function(date, currentDate) {
            var differenceInDays = dateUtils.getDatesInterval(date, currentDate, "day"),
                resultDate = new Date(date);
            if (differenceInDays >= 6) {
                resultDate = new Date(resultDate.setDate(resultDate.getDate() + 7))
            }
            return resultDate
        };
        var dateInRange = function(date, min, max, format) {
            if ("date" === format) {
                min = min && dateUtils.correctDateWithUnitBeginning(min, "day");
                max = max && dateUtils.correctDateWithUnitBeginning(max, "day");
                date = date && dateUtils.correctDateWithUnitBeginning(date, "day")
            }
            return normalizeDate(date, min, max) === date
        };
        var dateTimeFromDecimal = function(number) {
            var hours = Math.floor(number),
                minutes = number % 1 * 60;
            return {
                hours: hours,
                minutes: minutes
            }
        };
        var roundDateByStartDayHour = function(date, startDayHour) {
            var startTime = this.dateTimeFromDecimal(startDayHour),
                result = new Date(date);
            if (date.getHours() === startTime.hours && date.getMinutes() < startTime.minutes || date.getHours() < startTime.hours) {
                result.setHours(startTime.hours, startTime.minutes, 0, 0)
            }
            return result
        };
        var normalizeDate = function(date, min, max) {
            var normalizedDate = date;
            if (!isDefined(date)) {
                return date
            }
            if (isDefined(min) && date < min) {
                normalizedDate = min
            }
            if (isDefined(max) && date > max) {
                normalizedDate = max
            }
            return normalizedDate
        };
        var fixTimezoneGap = function(oldDate, newDate) {
            if (!isDefined(oldDate)) {
                return
            }
            var sign, trial, diff = newDate.getHours() - oldDate.getHours();
            if (0 === diff) {
                return
            }
            sign = 1 === diff || diff === -23 ? -1 : 1;
            trial = new Date(newDate.getTime() + 36e5 * sign);
            if (sign > 0 || trial.getDate() === newDate.getDate()) {
                newDate.setTime(trial.getTime())
            }
        };
        var roundToHour = function(date) {
            date.setHours(date.getHours() + 1);
            date.setMinutes(0);
            return date
        };
        var getTimezonesDifference = function(min, max) {
            return 60 * (max.getTimezoneOffset() - min.getTimezoneOffset()) * 1e3
        };
        var makeDate = function(date) {
            return new Date(date)
        };
        var getDatesOfInterval = function(startDate, endDate, step) {
            var currentDate = new Date(startDate.getTime()),
                result = [];
            while (currentDate < endDate) {
                result.push(new Date(currentDate.getTime()));
                currentDate = this.addInterval(currentDate, step)
            }
            return result
        };
        var dateUtils = {
            dateUnitIntervals: dateUnitIntervals,
            convertMillisecondsToDateUnits: convertMillisecondsToDateUnits,
            dateToMilliseconds: dateToMilliseconds,
            getNextDateUnit: getNextDateUnit,
            convertDateUnitToMilliseconds: convertDateUnitToMilliseconds,
            getDateUnitInterval: getDateUnitInterval,
            getDateFormatByTickInterval: getDateFormatByTickInterval,
            getDatesDifferences: getDatesDifferences,
            correctDateWithUnitBeginning: correctDateWithUnitBeginning,
            trimTime: trimTime,
            setToDayEnd: setToDayEnd,
            roundDateByStartDayHour: roundDateByStartDayHour,
            dateTimeFromDecimal: dateTimeFromDecimal,
            addDateInterval: addDateInterval,
            addInterval: addInterval,
            getSequenceByInterval: getSequenceByInterval,
            getDateIntervalByString: getDateIntervalByString,
            sameDate: sameDate,
            sameMonthAndYear: sameMonthAndYear,
            sameMonth: sameMonthAndYear,
            sameYear: sameYear,
            sameDecade: sameDecade,
            sameCentury: sameCentury,
            sameView: sameView,
            getDifferenceInMonth: getDifferenceInMonth,
            getDifferenceInMonthForCells: getDifferenceInMonthForCells,
            getFirstYearInDecade: getFirstYearInDecade,
            getFirstDecadeInCentury: getFirstDecadeInCentury,
            getShortDateFormat: getShortDateFormat,
            getViewFirstCellDate: getViewFirstCellDate,
            getViewLastCellDate: getViewLastCellDate,
            getViewDown: getViewDown,
            getViewUp: getViewUp,
            getLastMonthDay: getLastMonthDay,
            getLastMonthDate: getLastMonthDate,
            getFirstMonthDate: getFirstMonthDate,
            getFirstWeekDate: getFirstWeekDate,
            normalizeDateByWeek: normalizeDateByWeek,
            getQuarter: getQuarter,
            getFirstQuarterMonth: getFirstQuarterMonth,
            dateInRange: dateInRange,
            roundToHour: roundToHour,
            normalizeDate: normalizeDate,
            getViewMinBoundaryDate: getViewMinBoundaryDate,
            getViewMaxBoundaryDate: getViewMaxBoundaryDate,
            fixTimezoneGap: fixTimezoneGap,
            getTimezonesDifference: getTimezonesDifference,
            makeDate: makeDate,
            getDatesInterval: getDatesInterval,
            getDatesOfInterval: getDatesOfInterval
        };
        module.exports = dateUtils
    },
    /*!****************************************************************!*\
      !*** ./artifacts/transpiled/ui/data_grid/ui.data_grid.core.js ***!
      \****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _uiGrid_core = __webpack_require__( /*! ../grid_core/ui.grid_core.utils */ 36);
        var _uiGrid_core2 = _interopRequireDefault(_uiGrid_core);
        var _uiGrid_core3 = __webpack_require__( /*! ../grid_core/ui.grid_core.modules */ 38);
        var _uiGrid_core4 = _interopRequireDefault(_uiGrid_core3);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }(0, _extend.extend)(exports, _uiGrid_core4.default, _uiGrid_core2.default, {
            modules: []
        })
    },
    /*!************************************************!*\
      !*** ./artifacts/transpiled/events/pointer.js ***!
      \************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _support = __webpack_require__( /*! ../core/utils/support */ 44);
        var _support2 = _interopRequireDefault(_support);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _browser = __webpack_require__( /*! ../core/utils/browser */ 25);
        var _browser2 = _interopRequireDefault(_browser);
        var _devices = __webpack_require__( /*! ../core/devices */ 16);
        var _devices2 = _interopRequireDefault(_devices);
        var _event_registrator = __webpack_require__( /*! ./core/event_registrator */ 71);
        var _event_registrator2 = _interopRequireDefault(_event_registrator);
        var _touch = __webpack_require__( /*! ./pointer/touch */ 273);
        var _touch2 = _interopRequireDefault(_touch);
        var _mspointer = __webpack_require__( /*! ./pointer/mspointer */ 460);
        var _mspointer2 = _interopRequireDefault(_mspointer);
        var _mouse = __webpack_require__( /*! ./pointer/mouse */ 275);
        var _mouse2 = _interopRequireDefault(_mouse);
        var _mouse_and_touch = __webpack_require__( /*! ./pointer/mouse_and_touch */ 461);
        var _mouse_and_touch2 = _interopRequireDefault(_mouse_and_touch);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var getStrategy = function(support, device, browser) {
            if (support.pointerEvents && browser.msie) {
                return _mspointer2.default
            }
            var tablet = device.tablet,
                phone = device.phone;
            if (support.touch && !(tablet || phone)) {
                return _mouse_and_touch2.default
            }
            if (support.touch) {
                return _touch2.default
            }
            return _mouse2.default
        };
        var EventStrategy = getStrategy(_support2.default, _devices2.default.real(), _browser2.default);
        (0, _iterator.each)(EventStrategy.map, function(pointerEvent, originalEvents) {
            (0, _event_registrator2.default)(pointerEvent, new EventStrategy(pointerEvent, originalEvents))
        });
        var pointer = {
            down: "dxpointerdown",
            up: "dxpointerup",
            move: "dxpointermove",
            cancel: "dxpointercancel",
            enter: "dxpointerenter",
            leave: "dxpointerleave",
            over: "dxpointerover",
            out: "dxpointerout"
        };
        pointer.getStrategy = getStrategy;
        module.exports = pointer
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled/core/utils/browser.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var extend = __webpack_require__( /*! ./extend */ 0).extend,
            windowUtils = __webpack_require__( /*! ./window */ 7),
            navigator = windowUtils.getNavigator();
        var webkitRegExp = /(webkit)[ \/]([\w.]+)/,
            ieRegExp = /(msie) (\d{1,2}\.\d)/,
            ie11RegExp = /(trident).*rv:(\d{1,2}\.\d)/,
            msEdge = /(edge)\/((\d+)?[\w.]+)/,
            safari = /(safari)/i,
            mozillaRegExp = /(mozilla)(?:.*? rv:([\w.]+))/;
        var browserFromUA = function(ua) {
            ua = ua.toLowerCase();
            var result = {},
                matches = ieRegExp.exec(ua) || ie11RegExp.exec(ua) || msEdge.exec(ua) || ua.indexOf("compatible") < 0 && mozillaRegExp.exec(ua) || webkitRegExp.exec(ua) || [],
                browserName = matches[1],
                browserVersion = matches[2];
            if ("webkit" === browserName) {
                result.webkit = true;
                if (ua.indexOf("chrome") >= 0 || ua.indexOf("crios") >= 0) {
                    browserName = "chrome";
                    browserVersion = /(?:Chrome|CriOS)\/(\d+\.\d+)/i.exec(ua);
                    browserVersion = browserVersion && browserVersion[1]
                } else {
                    if (ua.indexOf("fxios") >= 0) {
                        browserName = "mozilla";
                        browserVersion = /FxiOS\/(\d+\.\d+)/i.exec(ua);
                        browserVersion = browserVersion && browserVersion[1]
                    } else {
                        if (safari.exec(ua)) {
                            browserName = "safari";
                            browserVersion = /Version\/([0-9.]+)/i.exec(ua);
                            browserVersion = browserVersion && browserVersion[1]
                        }
                    }
                }
            }
            if ("trident" === browserName || "edge" === browserName) {
                browserName = "msie"
            }
            if (browserName) {
                result[browserName] = true;
                result.version = browserVersion
            }
            return result
        };
        module.exports = extend({
            _fromUA: browserFromUA
        }, browserFromUA(navigator.userAgent))
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/core/utils/callbacks.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Callback = function(options) {
            this._options = options || {};
            this._list = [];
            this._queue = [];
            this._firing = false;
            this._fired = false;
            this._firingIndexes = []
        };
        Callback.prototype._fireCore = function(context, args) {
            var firingIndexes = this._firingIndexes,
                list = this._list,
                stopOnFalse = this._options.stopOnFalse,
                step = firingIndexes.length;
            for (firingIndexes[step] = 0; firingIndexes[step] < list.length; firingIndexes[step]++) {
                var result = list[firingIndexes[step]].apply(context, args);
                if (false === result && stopOnFalse) {
                    break
                }
            }
            firingIndexes.pop()
        };
        Callback.prototype.add = function(fn) {
            if ("function" === typeof fn && (!this._options.unique || !this.has(fn))) {
                this._list.push(fn)
            }
            return this
        };
        Callback.prototype.remove = function(fn) {
            var list = this._list,
                firingIndexes = this._firingIndexes,
                index = list.indexOf(fn);
            if (index > -1) {
                list.splice(index, 1);
                if (this._firing && firingIndexes.length) {
                    for (var step = 0; step < firingIndexes.length; step++) {
                        if (index <= firingIndexes[step]) {
                            firingIndexes[step]--
                        }
                    }
                }
            }
            return this
        };
        Callback.prototype.has = function(fn) {
            var list = this._list;
            return fn ? list.indexOf(fn) > -1 : !!list.length
        };
        Callback.prototype.empty = function(fn) {
            this._list = [];
            return this
        };
        Callback.prototype.fireWith = function(context, args) {
            var queue = this._queue;
            args = args || [];
            args = args.slice ? args.slice() : args;
            if (this._options.syncStrategy) {
                this._firing = true;
                this._fireCore(context, args)
            } else {
                queue.push([context, args]);
                if (this._firing) {
                    return
                }
                this._firing = true;
                while (queue.length) {
                    var memory = queue.shift();
                    this._fireCore(memory[0], memory[1])
                }
            }
            this._firing = false;
            this._fired = true;
            return this
        };
        Callback.prototype.fire = function() {
            this.fireWith(this, arguments)
        };
        Callback.prototype.fired = function() {
            return this._fired
        };
        var Callbacks = function(options) {
            return new Callback(options)
        };
        module.exports = Callbacks
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/animation/translator.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var dataUtils = __webpack_require__( /*! ../core/element_data */ 40),
            type = __webpack_require__( /*! ../core/utils/type */ 1).type;
        var TRANSLATOR_DATA_KEY = "dxTranslator",
            TRANSFORM_MATRIX_REGEX = /matrix(3d)?\((.+?)\)/,
            TRANSLATE_REGEX = /translate(?:3d)?\((.+?)\)/;
        var locate = function($element) {
            var translate = getTranslate($element);
            return {
                left: translate.x,
                top: translate.y
            }
        };
        var move = function($element, position) {
            var translate, left = position.left,
                top = position.top;
            if (void 0 === left) {
                translate = getTranslate($element);
                translate.y = top || 0
            } else {
                if (void 0 === top) {
                    translate = getTranslate($element);
                    translate.x = left || 0
                } else {
                    translate = {
                        x: left || 0,
                        y: top || 0,
                        z: 0
                    };
                    cacheTranslate($element, translate)
                }
            }
            $element.css({
                transform: getTranslateCss(translate)
            });
            if (isPercentValue(left) || isPercentValue(top)) {
                clearCache($element)
            }
        };
        var isPercentValue = function(value) {
            return "string" === type(value) && "%" === value[value.length - 1]
        };
        var getTranslate = function($element) {
            var result = $element.length ? dataUtils.data($element.get(0), TRANSLATOR_DATA_KEY) : null;
            if (!result) {
                var transformValue = $element.css("transform") || getTranslateCss({
                        x: 0,
                        y: 0
                    }),
                    matrix = transformValue.match(TRANSFORM_MATRIX_REGEX),
                    is3D = matrix && matrix[1];
                if (matrix) {
                    matrix = matrix[2].split(",");
                    if ("3d" === is3D) {
                        matrix = matrix.slice(12, 15)
                    } else {
                        matrix.push(0);
                        matrix = matrix.slice(4, 7)
                    }
                } else {
                    matrix = [0, 0, 0]
                }
                result = {
                    x: parseFloat(matrix[0]),
                    y: parseFloat(matrix[1]),
                    z: parseFloat(matrix[2])
                };
                cacheTranslate($element, result)
            }
            return result
        };
        var cacheTranslate = function($element, translate) {
            if ($element.length) {
                dataUtils.data($element.get(0), TRANSLATOR_DATA_KEY, translate)
            }
        };
        var clearCache = function($element) {
            if ($element.length) {
                dataUtils.removeData($element.get(0), TRANSLATOR_DATA_KEY)
            }
        };
        var resetPosition = function($element, finishTransition) {
            var originalTransition, stylesConfig = {
                left: 0,
                top: 0,
                transform: "none"
            };
            if (finishTransition) {
                originalTransition = $element.css("transition");
                stylesConfig.transition = "none"
            }
            $element.css(stylesConfig);
            clearCache($element);
            if (finishTransition) {
                $element.get(0).offsetHeight;
                $element.css("transition", originalTransition)
            }
        };
        var parseTranslate = function(translateString) {
            var result = translateString.match(TRANSLATE_REGEX);
            if (!result || !result[1]) {
                return
            }
            result = result[1].split(",");
            result = {
                x: parseFloat(result[0]),
                y: parseFloat(result[1]),
                z: parseFloat(result[2])
            };
            return result
        };
        var getTranslateCss = function(translate) {
            translate.x = translate.x || 0;
            translate.y = translate.y || 0;
            var xValueString = isPercentValue(translate.x) ? translate.x : translate.x + "px";
            var yValueString = isPercentValue(translate.y) ? translate.y : translate.y + "px";
            return "translate(" + xValueString + ", " + yValueString + ")"
        };
        exports.move = move;
        exports.locate = locate;
        exports.clearCache = clearCache;
        exports.parseTranslate = parseTranslate;
        exports.getTranslate = getTranslate;
        exports.getTranslateCss = getTranslateCss;
        exports.resetPosition = resetPosition
    },
    /*!****************************************************************!*\
      !*** ./artifacts/transpiled/ui/tree_list/ui.tree_list.core.js ***!
      \****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _uiGrid_core = __webpack_require__( /*! ../grid_core/ui.grid_core.modules */ 38);
        var _uiGrid_core2 = _interopRequireDefault(_uiGrid_core);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }(0, _extend.extend)(exports, _uiGrid_core2.default, {
            modules: [],
            foreachNodes: function(nodes, callBack) {
                for (var i = 0; i < nodes.length; i++) {
                    if (false !== callBack(nodes[i]) && nodes[i].hasChildren && nodes[i].children.length) {
                        this.foreachNodes(nodes[i].children, callBack)
                    }
                }
            }
        })
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/core/config.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _extend = __webpack_require__( /*! ./utils/extend */ 0);
        var _extend2 = _interopRequireDefault(_extend);
        var _errors = __webpack_require__( /*! ./errors */ 21);
        var _errors2 = _interopRequireDefault(_errors);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var config = {
            rtlEnabled: false,
            defaultCurrency: "USD",
            oDataFilterToLower: true,
            serverDecimalSeparator: ".",
            decimalSeparator: ".",
            thousandsSeparator: ",",
            forceIsoDateParsing: true,
            wrapActionsBeforeExecute: true,
            useLegacyStoreResult: false,
            useJQuery: void 0,
            editorStylingMode: void 0,
            useLegacyVisibleIndex: false,
            floatingActionButtonConfig: {
                icon: "add",
                closeIcon: "close",
                label: "",
                position: {
                    at: "right bottom",
                    my: "right bottom",
                    offset: {
                        x: -16,
                        y: -16
                    }
                },
                maxSpeedDialActionCount: 5,
                shading: false,
                direction: "auto"
            },
            optionsParser: function(optionsString) {
                if ("{" !== optionsString.trim().charAt(0)) {
                    optionsString = "{" + optionsString + "}"
                }
                try {
                    return new Function("return " + optionsString)()
                } catch (ex) {
                    throw _errors2.default.Error("E3018", ex, optionsString)
                }
            }
        };
        var deprecatedFields = ["decimalSeparator", "thousandsSeparator"];
        var configMethod = function() {
            if (!arguments.length) {
                return config
            }
            var newConfig = arguments.length <= 0 ? void 0 : arguments[0];
            deprecatedFields.forEach(function(deprecatedField) {
                if (newConfig[deprecatedField]) {
                    var message = "Now, the " + deprecatedField + " is selected based on the specified locale.";
                    _errors2.default.log("W0003", "config", deprecatedField, "19.2", message)
                }
            });
            _extend2.default.extend(config, newConfig)
        };
        if ("undefined" !== typeof DevExpress && DevExpress.config) {
            configMethod(DevExpress.config)
        }
        module.exports = configMethod
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/core/utils/math.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var isExponential = __webpack_require__( /*! ./type */ 1).isExponential;
        var sign = function(value) {
            if (0 === value) {
                return 0
            }
            return value / Math.abs(value)
        };
        var fitIntoRange = function(value, minValue, maxValue) {
            var isMinValueUndefined = !minValue && 0 !== minValue,
                isMaxValueUndefined = !maxValue && 0 !== maxValue;
            isMinValueUndefined && (minValue = !isMaxValueUndefined ? Math.min(value, maxValue) : value);
            isMaxValueUndefined && (maxValue = !isMinValueUndefined ? Math.max(value, minValue) : value);
            return Math.min(Math.max(value, minValue), maxValue)
        };
        var inRange = function(value, minValue, maxValue) {
            return value >= minValue && value <= maxValue
        };

        function getExponent(value) {
            return Math.abs(parseInt(value.toExponential().split("e")[1]))
        }

        function _isEdgeBug() {
            var value = 3e-4,
                correctValue = "0.000300",
                precisionValue = 3;
            return correctValue !== value.toPrecision(precisionValue)
        }

        function adjust(value, interval) {
            var separatedAdjustedValue, precision = getPrecision(interval || 0) + 2,
                separatedValue = value.toString().split("."),
                sourceValue = value,
                absValue = Math.abs(value),
                isExponentValue = isExponential(value),
                integerPart = absValue > 1 ? 10 : 0;
            if (1 === separatedValue.length) {
                return value
            }
            if (!isExponentValue) {
                if (isExponential(interval)) {
                    precision = separatedValue[0].length + getExponent(interval)
                }
                value = absValue;
                value = value - Math.floor(value) + integerPart
            }
            precision = _isEdgeBug() && getExponent(value) > 6 || precision > 7 ? 15 : 7;
            if (!isExponentValue) {
                separatedAdjustedValue = parseFloat(value.toPrecision(precision)).toString().split(".");
                if (separatedAdjustedValue[0] === integerPart.toString()) {
                    return parseFloat(separatedValue[0] + "." + separatedAdjustedValue[1])
                }
            }
            return parseFloat(sourceValue.toPrecision(precision))
        }

        function getPrecision(value) {
            var mantissa, positionOfDelimiter, str = value.toString();
            if (str.indexOf(".") < 0) {
                return 0
            }
            mantissa = str.split(".");
            positionOfDelimiter = mantissa[1].indexOf("e");
            return positionOfDelimiter >= 0 ? positionOfDelimiter : mantissa[1].length
        }

        function getRoot(x, n) {
            if (x < 0 && n % 2 !== 1) {
                return NaN
            }
            var y = Math.pow(Math.abs(x), 1 / n);
            return n % 2 === 1 && x < 0 ? -y : y
        }

        function solveCubicEquation(a, b, c, d) {
            var min = 1e-8;
            if (Math.abs(a) < min) {
                a = b;
                b = c;
                c = d;
                if (Math.abs(a) < min) {
                    a = b;
                    b = c;
                    if (Math.abs(a) < min) {
                        return []
                    }
                    return [-b / a]
                }
                var D2 = b * b - 4 * a * c;
                if (Math.abs(D2) < min) {
                    return [-b / (2 * a)]
                } else {
                    if (D2 > 0) {
                        return [(-b + Math.sqrt(D2)) / (2 * a), (-b - Math.sqrt(D2)) / (2 * a)]
                    }
                }
                return []
            }
            var p = (3 * a * c - b * b) / (3 * a * a);
            var q = (2 * b * b * b - 9 * a * b * c + 27 * a * a * d) / (27 * a * a * a);
            var roots;
            var u;
            if (Math.abs(p) < min) {
                roots = [getRoot(-q, 3)]
            } else {
                if (Math.abs(q) < min) {
                    roots = [0].concat(p < 0 ? [Math.sqrt(-p), -Math.sqrt(-p)] : [])
                } else {
                    var D3 = q * q / 4 + p * p * p / 27;
                    if (Math.abs(D3) < min) {
                        roots = [-1.5 * q / p, 3 * q / p]
                    } else {
                        if (D3 > 0) {
                            u = getRoot(-q / 2 - Math.sqrt(D3), 3);
                            roots = [u - p / (3 * u)]
                        } else {
                            u = 2 * Math.sqrt(-p / 3);
                            var t = Math.acos(3 * q / p / u) / 3;
                            var k = 2 * Math.PI / 3;
                            roots = [u * Math.cos(t), u * Math.cos(t - k), u * Math.cos(t - 2 * k)]
                        }
                    }
                }
            }
            for (var i = 0; i < roots.length; i++) {
                roots[i] -= b / (3 * a)
            }
            return roots
        }
        exports.sign = sign;
        exports.fitIntoRange = fitIntoRange;
        exports.inRange = inRange;
        exports.adjust = adjust;
        exports.getPrecision = getPrecision;
        exports.getExponent = getExponent;
        exports.getRoot = getRoot;
        exports.solveCubicEquation = solveCubicEquation
    },
    /*!*******************************************!*\
      !*** ./artifacts/transpiled/ui/themes.js ***!
      \*******************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            domAdapter = __webpack_require__( /*! ../core/dom_adapter */ 13),
            windowUtils = __webpack_require__( /*! ../core/utils/window */ 7),
            window = windowUtils.getWindow(),
            Deferred = __webpack_require__( /*! ../core/utils/deferred */ 6).Deferred,
            errors = __webpack_require__( /*! ./widget/ui.errors */ 18),
            domUtils = __webpack_require__( /*! ../core/utils/dom */ 11),
            readyCallbacks = __webpack_require__( /*! ../core/utils/ready_callbacks */ 48),
            ready = readyCallbacks.add,
            each = __webpack_require__( /*! ../core/utils/iterator */ 3).each,
            devices = __webpack_require__( /*! ../core/devices */ 16),
            viewPortUtils = __webpack_require__( /*! ../core/utils/view_port */ 72),
            themeReadyCallback = __webpack_require__( /*! ./themes_callback */ 277),
            viewPort = viewPortUtils.value,
            Promise = __webpack_require__( /*! ../core/polyfills/promise */ 66),
            viewPortChanged = viewPortUtils.changeCallback;
        var DX_LINK_SELECTOR = "link[rel=dx-theme]",
            THEME_ATTR = "data-theme",
            ACTIVE_ATTR = "data-active",
            DX_HAIRLINES_CLASS = "dx-hairlines";
        var context, $activeThemeLink, knownThemes, currentThemeName, pendingThemeName;
        var timerId;
        var THEME_MARKER_PREFIX = "dx.";

        function readThemeMarker() {
            if (!windowUtils.hasWindow()) {
                return null
            }
            var result, element = $("<div>", context).addClass("dx-theme-marker").appendTo(context.documentElement);
            try {
                result = element.css("fontFamily");
                if (!result) {
                    return null
                }
                result = result.replace(/["']/g, "");
                if (result.substr(0, THEME_MARKER_PREFIX.length) !== THEME_MARKER_PREFIX) {
                    return null
                }
                return result.substr(THEME_MARKER_PREFIX.length)
            } finally {
                element.remove()
            }
        }

        function waitForThemeLoad(themeName) {
            var waitStartTime;
            pendingThemeName = themeName;

            function handleLoaded() {
                pendingThemeName = null;
                themeReadyCallback.fire();
                themeReadyCallback.empty()
            }
            if (isPendingThemeLoaded()) {
                handleLoaded()
            } else {
                waitStartTime = Date.now();
                timerId = setInterval(function() {
                    var isLoaded = isPendingThemeLoaded(),
                        isTimeout = !isLoaded && Date.now() - waitStartTime > 15e3;
                    if (isTimeout) {
                        errors.log("W0004", pendingThemeName)
                    }
                    if (isLoaded || isTimeout) {
                        clearInterval(timerId);
                        timerId = void 0;
                        handleLoaded()
                    }
                }, 10)
            }
        }

        function isPendingThemeLoaded() {
            return !pendingThemeName || readThemeMarker() === pendingThemeName
        }

        function processMarkup() {
            var $allThemeLinks = $(DX_LINK_SELECTOR, context);
            if (!$allThemeLinks.length) {
                return
            }
            knownThemes = {};
            $activeThemeLink = $(domUtils.createMarkupFromString("<link rel=stylesheet>"), context);
            $allThemeLinks.each(function() {
                var link = $(this, context),
                    fullThemeName = link.attr(THEME_ATTR),
                    url = link.attr("href"),
                    isActive = "true" === link.attr(ACTIVE_ATTR);
                knownThemes[fullThemeName] = {
                    url: url,
                    isActive: isActive
                }
            });
            $allThemeLinks.last().after($activeThemeLink);
            $allThemeLinks.remove()
        }

        function resolveFullThemeName(desiredThemeName) {
            var desiredThemeParts = desiredThemeName ? desiredThemeName.split(".") : [],
                result = null;
            if (knownThemes) {
                if (desiredThemeName in knownThemes) {
                    return desiredThemeName
                }
                each(knownThemes, function(knownThemeName, themeData) {
                    var knownThemeParts = knownThemeName.split(".");
                    if (desiredThemeParts[0] && knownThemeParts[0] !== desiredThemeParts[0]) {
                        return
                    }
                    if (desiredThemeParts[1] && desiredThemeParts[1] !== knownThemeParts[1]) {
                        return
                    }
                    if (desiredThemeParts[2] && desiredThemeParts[2] !== knownThemeParts[2]) {
                        return
                    }
                    if (!result || themeData.isActive) {
                        result = knownThemeName
                    }
                    if (themeData.isActive) {
                        return false
                    }
                })
            }
            return result
        }

        function initContext(newContext) {
            try {
                if (newContext !== context) {
                    knownThemes = null
                }
            } catch (x) {
                knownThemes = null
            }
            context = newContext
        }

        function init(options) {
            options = options || {};
            initContext(options.context || domAdapter.getDocument());
            if (!context) {
                return
            }
            processMarkup();
            currentThemeName = void 0;
            current(options)
        }

        function current(options) {
            if (!arguments.length) {
                currentThemeName = currentThemeName || readThemeMarker();
                return currentThemeName
            }
            detachCssClasses(viewPort());
            options = options || {};
            if ("string" === typeof options) {
                options = {
                    theme: options
                }
            }
            var currentThemeData, isAutoInit = options._autoInit,
                loadCallback = options.loadCallback;
            currentThemeName = resolveFullThemeName(options.theme || currentThemeName);
            if (currentThemeName) {
                currentThemeData = knownThemes[currentThemeName]
            }
            if (loadCallback) {
                themeReadyCallback.add(loadCallback)
            }
            if (currentThemeData) {
                $activeThemeLink.attr("href", knownThemes[currentThemeName].url);
                if ((themeReadyCallback.has() || options._forceTimeout) && !timerId) {
                    waitForThemeLoad(currentThemeName)
                } else {
                    if (pendingThemeName) {
                        pendingThemeName = currentThemeName
                    }
                }
            } else {
                if (isAutoInit) {
                    themeReadyCallback.fire();
                    themeReadyCallback.empty()
                } else {
                    throw errors.Error("E0021", currentThemeName)
                }
            }
            checkThemeDeprecation();
            attachCssClasses(viewPortUtils.originalViewPort(), currentThemeName)
        }

        function getCssClasses(themeName) {
            themeName = themeName || current();
            var result = [],
                themeNameParts = themeName && themeName.split(".");
            if (themeNameParts) {
                result.push("dx-theme-" + themeNameParts[0], "dx-theme-" + themeNameParts[0] + "-typography");
                if (themeNameParts.length > 1) {
                    result.push("dx-color-scheme-" + themeNameParts[1] + (isMaterial(themeName) ? "-" + themeNameParts[2] : ""))
                }
            }
            return result
        }
        var themeClasses;

        function attachCssClasses(element, themeName) {
            themeClasses = getCssClasses(themeName).join(" ");
            $(element).addClass(themeClasses);
            var activateHairlines = function() {
                var pixelRatio = windowUtils.hasWindow() && window.devicePixelRatio;
                if (!pixelRatio || pixelRatio < 2) {
                    return
                }
                var $tester = $("<div>");
                $tester.css("border", ".5px solid transparent");
                $("body").append($tester);
                if (1 === $tester.outerHeight()) {
                    $(element).addClass(DX_HAIRLINES_CLASS);
                    themeClasses += " " + DX_HAIRLINES_CLASS
                }
                $tester.remove()
            };
            activateHairlines()
        }

        function detachCssClasses(element) {
            $(element).removeClass(themeClasses)
        }

        function themeReady(callback) {
            themeReadyCallback.add(callback)
        }

        function isTheme(themeRegExp, themeName) {
            if (!themeName) {
                themeName = currentThemeName || readThemeMarker()
            }
            return new RegExp(themeRegExp).test(themeName)
        }

        function isMaterial(themeName) {
            return isTheme("material", themeName)
        }

        function isIos7(themeName) {
            return isTheme("ios7", themeName)
        }

        function isGeneric(themeName) {
            return isTheme("generic", themeName)
        }

        function isDark(themeName) {
            return isTheme("dark", themeName)
        }

        function checkThemeDeprecation() {
            if (isIos7()) {
                errors.log("W0010", "The 'ios7' theme", "19.1", "Use the 'generic' theme instead.")
            }
        }

        function isWebFontLoaded(text, fontWeight) {
            var testedFont = "Roboto, RobotoFallback, Arial";
            var etalonFont = "Arial";
            var document = domAdapter.getDocument();
            var testElement = document.createElement("span");
            testElement.style.position = "absolute";
            testElement.style.top = "-9999px";
            testElement.style.left = "-9999px";
            testElement.style.visibility = "hidden";
            testElement.style.fontFamily = etalonFont;
            testElement.style.fontSize = "250px";
            testElement.style.fontWeight = fontWeight;
            testElement.innerHTML = text;
            document.body.appendChild(testElement);
            var etalonFontWidth = testElement.offsetWidth;
            testElement.style.fontFamily = testedFont;
            var testedFontWidth = testElement.offsetWidth;
            testElement.parentNode.removeChild(testElement);
            return etalonFontWidth !== testedFontWidth
        }

        function waitWebFont(text, fontWeight) {
            var interval = 15;
            var timeout = 2e3;
            return new Promise(function(resolve) {
                var check = function() {
                    if (isWebFontLoaded(text, fontWeight)) {
                        clear()
                    }
                };
                var clear = function() {
                    clearInterval(intervalId);
                    clearTimeout(timeoutId);
                    resolve()
                };
                var intervalId = setInterval(check, interval);
                var timeoutId = setTimeout(clear, timeout)
            })
        }
        var initDeferred = new Deferred;

        function autoInit() {
            init({
                _autoInit: true,
                _forceTimeout: true
            });
            if ($(DX_LINK_SELECTOR, context).length) {
                throw errors.Error("E0022")
            }
            initDeferred.resolve()
        }
        if (windowUtils.hasWindow()) {
            autoInit()
        } else {
            ready(autoInit)
        }
        viewPortChanged.add(function(viewPort, prevViewPort) {
            initDeferred.done(function() {
                detachCssClasses(prevViewPort);
                attachCssClasses(viewPort)
            })
        });
        devices.changed.add(function() {
            init({
                _autoInit: true
            })
        });
        exports.current = current;
        exports.ready = themeReady;
        exports.init = init;
        exports.attachCssClasses = attachCssClasses;
        exports.detachCssClasses = detachCssClasses;
        exports.waitForThemeLoad = waitForThemeLoad;
        exports.isMaterial = isMaterial;
        exports.isIos7 = isIos7;
        exports.isGeneric = isGeneric;
        exports.isDark = isDark;
        exports.isWebFontLoaded = isWebFontLoaded;
        exports.waitWebFont = waitWebFont;
        exports.resetTheme = function() {
            $activeThemeLink && $activeThemeLink.attr("href", "about:blank");
            currentThemeName = null;
            pendingThemeName = null
        }
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/core/utils/inflector.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var map = __webpack_require__( /*! ./iterator */ 3).map;
        var _normalize = function(text) {
            if (void 0 === text || null === text) {
                return ""
            }
            return String(text)
        };
        var _upperCaseFirst = function(text) {
            return _normalize(text).charAt(0).toUpperCase() + text.substr(1)
        };
        var _chop = function(text) {
            return _normalize(text).replace(/([a-z\d])([A-Z])/g, "$1 $2").split(/[\s_-]+/)
        };
        var dasherize = function(text) {
            return map(_chop(text), function(p) {
                return p.toLowerCase()
            }).join("-")
        };
        var underscore = function(text) {
            return dasherize(text).replace(/-/g, "_")
        };
        var camelize = function(text, upperFirst) {
            return map(_chop(text), function(p, i) {
                p = p.toLowerCase();
                if (upperFirst || i > 0) {
                    p = _upperCaseFirst(p)
                }
                return p
            }).join("")
        };
        var humanize = function(text) {
            return _upperCaseFirst(dasherize(text).replace(/-/g, " "))
        };
        var titleize = function(text) {
            return map(_chop(text), function(p) {
                return _upperCaseFirst(p.toLowerCase())
            }).join(" ")
        };
        var DIGIT_CHARS = ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"];
        var captionize = function(name) {
            var i, char, captionList = [],
                isPrevCharNewWord = false,
                isNewWord = false;
            for (i = 0; i < name.length; i++) {
                char = name.charAt(i);
                isNewWord = char === char.toUpperCase() && "-" !== char && ")" !== char && "/" !== char || char in DIGIT_CHARS;
                if ("_" === char || "." === char) {
                    char = " ";
                    isNewWord = true
                } else {
                    if (0 === i) {
                        char = char.toUpperCase();
                        isNewWord = true
                    } else {
                        if (!isPrevCharNewWord && isNewWord) {
                            if (captionList.length > 0) {
                                captionList.push(" ")
                            }
                        }
                    }
                }
                captionList.push(char);
                isPrevCharNewWord = isNewWord
            }
            return captionList.join("")
        };
        exports.dasherize = dasherize;
        exports.camelize = camelize;
        exports.humanize = humanize;
        exports.titleize = titleize;
        exports.underscore = underscore;
        exports.captionize = captionize
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/localization/date.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _dependency_injector = __webpack_require__( /*! ../core/utils/dependency_injector */ 56);
        var _dependency_injector2 = _interopRequireDefault(_dependency_injector);
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _iterator2 = _interopRequireDefault(_iterator);
        var _array = __webpack_require__( /*! ../core/utils/array */ 14);
        var _errors = __webpack_require__( /*! ../core/errors */ 21);
        var _errors2 = _interopRequireDefault(_errors);
        var _date = __webpack_require__( /*! ./ldml/date.formatter */ 264);
        var _date2 = __webpack_require__( /*! ./ldml/date.format */ 209);
        var _date3 = __webpack_require__( /*! ./ldml/date.parser */ 211);
        var _default_date_names = __webpack_require__( /*! ./default_date_names */ 265);
        var _default_date_names2 = _interopRequireDefault(_default_date_names);
        var _first_day_of_week_data = __webpack_require__( /*! ./cldr-data/first_day_of_week_data */ 445);
        var _first_day_of_week_data2 = _interopRequireDefault(_first_day_of_week_data);
        var _core = __webpack_require__( /*! ./core */ 80);
        var _number = __webpack_require__( /*! ./number */ 51);
        var _number2 = _interopRequireDefault(_number);
        var _date4 = __webpack_require__( /*! ./intl/date */ 446);
        var _date5 = _interopRequireDefault(_date4);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var DEFAULT_DAY_OF_WEEK_INDEX = 0;
        var hasIntl = "undefined" !== typeof Intl;
        var FORMATS_TO_PATTERN_MAP = {
            shortdate: "M/d/y",
            shorttime: "h:mm a",
            longdate: "EEEE, MMMM d, y",
            longtime: "h:mm:ss a",
            monthandday: "MMMM d",
            monthandyear: "MMMM y",
            quarterandyear: "QQQ y",
            day: "d",
            year: "y",
            shortdateshorttime: "M/d/y, h:mm a",
            mediumdatemediumtime: "MMMM d, h:mm a",
            longdatelongtime: "EEEE, MMMM d, y, h:mm:ss a",
            month: "LLLL",
            shortyear: "yy",
            dayofweek: "EEEE",
            quarter: "QQQ",
            hour: "HH",
            minute: "mm",
            second: "ss",
            millisecond: "SSS",
            "datetime-local": "yyyy-MM-ddTHH':'mm':'ss"
        };
        var possiblePartPatterns = {
            year: ["y", "yy", "yyyy"],
            day: ["d", "dd"],
            month: ["M", "MM", "MMM", "MMMM"],
            hours: ["H", "HH", "h", "hh", "ah"],
            minutes: ["m", "mm"],
            seconds: ["s", "ss"],
            milliseconds: ["S", "SS", "SSS"]
        };
        var dateLocalization = (0, _dependency_injector2.default)({
            engine: function() {
                return "base"
            },
            _getPatternByFormat: function(format) {
                return FORMATS_TO_PATTERN_MAP[format.toLowerCase()]
            },
            _expandPattern: function(pattern) {
                return this._getPatternByFormat(pattern) || pattern
            },
            formatUsesMonthName: function(format) {
                return this._expandPattern(format).indexOf("MMMM") !== -1
            },
            formatUsesDayName: function(format) {
                return this._expandPattern(format).indexOf("EEEE") !== -1
            },
            getFormatParts: function(format) {
                var pattern = this._getPatternByFormat(format) || format;
                var result = [];
                _iterator2.default.each(pattern.split(/\W+/), function(_, formatPart) {
                    _iterator2.default.each(possiblePartPatterns, function(partName, possiblePatterns) {
                        if ((0, _array.inArray)(formatPart, possiblePatterns) > -1) {
                            result.push(partName)
                        }
                    })
                });
                return result
            },
            getMonthNames: function(format) {
                return _default_date_names2.default.getMonthNames(format)
            },
            getDayNames: function(format) {
                return _default_date_names2.default.getDayNames(format)
            },
            getQuarterNames: function(format) {
                return _default_date_names2.default.getQuarterNames(format)
            },
            getPeriodNames: function(format) {
                return _default_date_names2.default.getPeriodNames(format)
            },
            getTimeSeparator: function() {
                return ":"
            },
            is24HourFormat: function(format) {
                var amTime = new Date(2017, 0, 20, 11, 0, 0, 0);
                var pmTime = new Date(2017, 0, 20, 23, 0, 0, 0);
                var amTimeFormatted = this.format(amTime, format);
                var pmTimeFormatted = this.format(pmTime, format);
                for (var i = 0; i < amTimeFormatted.length; i++) {
                    if (amTimeFormatted[i] !== pmTimeFormatted[i]) {
                        return !isNaN(parseInt(amTimeFormatted[i]))
                    }
                }
            },
            format: function(date, _format) {
                if (!date) {
                    return
                }
                if (!_format) {
                    return date
                }
                var formatter = void 0;
                if ("function" === typeof _format) {
                    formatter = _format
                } else {
                    if (_format.formatter) {
                        formatter = _format.formatter
                    } else {
                        _format = _format.type || _format;
                        if ((0, _type.isString)(_format)) {
                            _format = FORMATS_TO_PATTERN_MAP[_format.toLowerCase()] || _format;
                            return _number2.default.convertDigits((0, _date.getFormatter)(_format, this)(date))
                        }
                    }
                }
                if (!formatter) {
                    return
                }
                return formatter(date)
            },
            parse: function(text, format) {
                var that = this;
                var result = void 0;
                var ldmlFormat = void 0;
                var formatter = void 0;
                if (!text) {
                    return
                }
                if (!format) {
                    return this.parse(text, "shortdate")
                }
                if (format.parser) {
                    return format.parser(text)
                }
                if ("string" === typeof format && !FORMATS_TO_PATTERN_MAP[format.toLowerCase()]) {
                    ldmlFormat = format
                } else {
                    formatter = function(value) {
                        var text = that.format(value, format);
                        return _number2.default.convertDigits(text, true)
                    };
                    try {
                        ldmlFormat = (0, _date2.getFormat)(formatter)
                    } catch (e) {}
                }
                if (ldmlFormat) {
                    text = _number2.default.convertDigits(text, true);
                    return (0, _date3.getParser)(ldmlFormat, this)(text)
                }
                _errors2.default.log("W0012");
                result = new Date(text);
                if (!result || isNaN(result.getTime())) {
                    return
                }
                return result
            },
            firstDayOfWeekIndex: function() {
                var index = (0, _core.getValueByClosestLocale)(function(locale) {
                    return _first_day_of_week_data2.default[locale]
                });
                return void 0 === index ? DEFAULT_DAY_OF_WEEK_INDEX : index
            }
        });
        if (hasIntl) {
            dateLocalization.inject(_date5.default)
        }
        module.exports = dateLocalization
    },
    /*!*******************************************!*\
      !*** ./artifacts/transpiled/core/guid.js ***!
      \*******************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Class = __webpack_require__( /*! ./class */ 15);
        var Guid = Class.inherit({
            ctor: function(value) {
                if (value) {
                    value = String(value)
                }
                this._value = this._normalize(value || this._generate())
            },
            _normalize: function(value) {
                value = value.replace(/[^a-f0-9]/gi, "").toLowerCase();
                while (value.length < 32) {
                    value += "0"
                }
                return [value.substr(0, 8), value.substr(8, 4), value.substr(12, 4), value.substr(16, 4), value.substr(20, 12)].join("-")
            },
            _generate: function() {
                var value = "";
                for (var i = 0; i < 32; i++) {
                    value += Math.round(15 * Math.random()).toString(16)
                }
                return value
            },
            toString: function() {
                return this._value
            },
            valueOf: function() {
                return this._value
            },
            toJSON: function() {
                return this._value
            }
        });
        module.exports = Guid
    },
    /*!*******************************************!*\
      !*** ./artifacts/transpiled/ui/button.js ***!
      \*******************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            eventsEngine = __webpack_require__( /*! ../events/core/events_engine */ 5),
            iconUtils = __webpack_require__( /*! ../core/utils/icon */ 54),
            domUtils = __webpack_require__( /*! ../core/utils/dom */ 11),
            devices = __webpack_require__( /*! ../core/devices */ 16),
            registerComponent = __webpack_require__( /*! ../core/component_registrator */ 8),
            extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            ValidationMixin = __webpack_require__( /*! ./validation/validation_mixin */ 177),
            ValidationEngine = __webpack_require__( /*! ./validation_engine */ 101),
            Widget = __webpack_require__( /*! ./widget/ui.widget */ 17),
            inkRipple = __webpack_require__( /*! ./widget/utils.ink_ripple */ 69),
            eventUtils = __webpack_require__( /*! ../events/utils */ 9),
            themes = __webpack_require__( /*! ./themes */ 31),
            clickEvent = __webpack_require__( /*! ../events/click */ 19),
            FunctionTemplate = __webpack_require__( /*! ../core/templates/function_template */ 98).FunctionTemplate;
        var BUTTON_CLASS = "dx-button",
            BUTTON_CONTENT_CLASS = "dx-button-content",
            BUTTON_HAS_TEXT_CLASS = "dx-button-has-text",
            BUTTON_HAS_ICON_CLASS = "dx-button-has-icon",
            BUTTON_ICON_RIGHT_CLASS = "dx-button-icon-right",
            ICON_RIGHT_CLASS = "dx-icon-right",
            BUTTON_STYLING_MODE_CLASS_PREFIX = "dx-button-mode-",
            ALLOWED_STYLE_CLASSES = [BUTTON_STYLING_MODE_CLASS_PREFIX + "contained", BUTTON_STYLING_MODE_CLASS_PREFIX + "text", BUTTON_STYLING_MODE_CLASS_PREFIX + "outlined"],
            TEMPLATE_WRAPPER_CLASS = "dx-template-wrapper",
            BUTTON_TEXT_CLASS = "dx-button-text",
            ANONYMOUS_TEMPLATE_NAME = "content",
            BUTTON_LEFT_ICON_POSITION = "left",
            BUTTON_FEEDBACK_HIDE_TIMEOUT = 100;
        var Button = Widget.inherit({
            _supportedKeys: function() {
                var that = this,
                    click = function(e) {
                        e.preventDefault();
                        that._executeClickAction(e)
                    };
                return extend(this.callBase(), {
                    space: click,
                    enter: click
                })
            },
            _setDeprecatedOptions: function() {
                this.callBase()
            },
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    hoverStateEnabled: true,
                    onClick: null,
                    type: "normal",
                    text: "",
                    icon: "",
                    iconPosition: BUTTON_LEFT_ICON_POSITION,
                    validationGroup: void 0,
                    activeStateEnabled: true,
                    template: "content",
                    useSubmitBehavior: false,
                    useInkRipple: false,
                    _templateData: {},
                    stylingMode: "contained"
                })
            },
            _defaultOptionsRules: function() {
                return this.callBase().concat([{
                    device: function() {
                        return "desktop" === devices.real().deviceType && !devices.isSimulator()
                    },
                    options: {
                        focusStateEnabled: true
                    }
                }, {
                    device: function() {
                        var themeName = themes.current();
                        return themes.isMaterial(themeName)
                    },
                    options: {
                        useInkRipple: true
                    }
                }])
            },
            _getAnonymousTemplateName: function() {
                return ANONYMOUS_TEMPLATE_NAME
            },
            _feedbackHideTimeout: BUTTON_FEEDBACK_HIDE_TIMEOUT,
            _initTemplates: function() {
                this.callBase();
                var that = this;
                this._defaultTemplates.content = new FunctionTemplate(function(options) {
                    var data = options.model,
                        $iconElement = iconUtils.getImageContainer(data && data.icon),
                        $textContainer = data && data.text ? $("<span>").text(data.text).addClass(BUTTON_TEXT_CLASS) : void 0,
                        $container = $(options.container);
                    $container.append($textContainer);
                    if (that.option("iconPosition") === BUTTON_LEFT_ICON_POSITION) {
                        $container.prepend($iconElement)
                    } else {
                        $iconElement.addClass(ICON_RIGHT_CLASS);
                        $container.append($iconElement)
                    }
                })
            },
            _initMarkup: function() {
                this.$element().addClass(BUTTON_CLASS);
                this._renderType();
                this._renderStylingMode();
                this.option("useInkRipple") && this._renderInkRipple();
                this._renderClick();
                this.setAria("role", "button");
                this._updateAriaLabel();
                this.callBase();
                this._updateContent()
            },
            _renderInkRipple: function() {
                var isOnlyIconButton = !this.option("text") && this.option("icon") || "back" === this.option("type"),
                    config = {};
                if (isOnlyIconButton) {
                    extend(config, {
                        waveSizeCoefficient: 1,
                        useHoldAnimation: false,
                        isCentered: true
                    })
                }
                this._inkRipple = inkRipple.render(config)
            },
            _toggleActiveState: function($element, value, e) {
                this.callBase.apply(this, arguments);
                if (!this._inkRipple) {
                    return
                }
                var config = {
                    element: this._$content,
                    event: e
                };
                if (value) {
                    this._inkRipple.showWave(config)
                } else {
                    this._inkRipple.hideWave(config)
                }
            },
            _updateContent: function() {
                var $element = this.$element(),
                    data = this._getContentData();
                if (this._$content) {
                    this._$content.empty()
                } else {
                    this._$content = $("<div>").addClass(BUTTON_CONTENT_CLASS).appendTo($element)
                }
                $element.toggleClass(BUTTON_HAS_ICON_CLASS, !!data.icon).toggleClass(BUTTON_ICON_RIGHT_CLASS, !!data.icon && this.option("iconPosition") !== BUTTON_LEFT_ICON_POSITION).toggleClass(BUTTON_HAS_TEXT_CLASS, !!data.text);
                var transclude = this._getAnonymousTemplateName() === this.option("template"),
                    template = this._getTemplateByOption("template"),
                    $result = $(template.render({
                        model: data,
                        container: domUtils.getPublicElement(this._$content),
                        transclude: transclude
                    }));
                if ($result.hasClass(TEMPLATE_WRAPPER_CLASS)) {
                    this._$content.replaceWith($result);
                    this._$content = $result;
                    this._$content.addClass(BUTTON_CONTENT_CLASS)
                }
                if (this.option("useSubmitBehavior")) {
                    this._renderSubmitInput()
                }
            },
            _setDisabled: function(value) {
                this.option("disabled", value)
            },
            _waitForValidationCompleting: function(complete) {
                var _this = this;
                complete.then(function(result) {
                    _this._validationStatus = result.status;
                    _this._setDisabled(false);
                    if ("valid" === _this._validationStatus) {
                        _this._$submitInput.get(0).click()
                    }
                    return result
                })
            },
            _getSubmitAction: function() {
                var _this2 = this;
                return this._createAction(function(_ref) {
                    var e = _ref.event;
                    if (_this2._needValidate) {
                        var validationGroup = ValidationEngine.getGroupConfig(_this2._findGroup());
                        if (validationGroup) {
                            var result = validationGroup.validate();
                            _this2._validationStatus = result.status;
                            if ("pending" === _this2._validationStatus) {
                                _this2._needValidate = false;
                                _this2._setDisabled(true);
                                _this2._waitForValidationCompleting(result.complete)
                            }
                        }
                    } else {
                        _this2._needValidate = true
                    }
                    "valid" !== _this2._validationStatus && e.preventDefault();
                    e.stopPropagation()
                })
            },
            _renderSubmitInput: function() {
                var submitAction = this._getSubmitAction();
                this._needValidate = true;
                this._validationStatus = "valid";
                this._$submitInput = $("<input>").attr("type", "submit").attr("tabindex", -1).addClass("dx-button-submit-input").appendTo(this._$content);
                eventsEngine.on(this._$submitInput, "click", function(e) {
                    submitAction({
                        event: e
                    })
                })
            },
            _getContentData: function() {
                var icon = this.option("icon"),
                    text = this.option("text"),
                    back = "back" === this.option("type");
                if (back && !icon) {
                    icon = "back"
                }
                return extend({
                    icon: icon,
                    text: text
                }, this.option("_templateData"))
            },
            _renderClick: function() {
                var that = this,
                    eventName = eventUtils.addNamespace(clickEvent.name, this.NAME),
                    actionConfig = {
                        excludeValidators: ["readOnly"]
                    };
                if (this.option("useSubmitBehavior")) {
                    actionConfig.afterExecute = function(e) {
                        setTimeout(function() {
                            e.component._$submitInput.get(0).click()
                        })
                    }
                }
                this._clickAction = this._createActionByOption("onClick", actionConfig);
                eventsEngine.off(this.$element(), eventName);
                eventsEngine.on(this.$element(), eventName, function(e) {
                    that._executeClickAction(e)
                })
            },
            _executeClickAction: function(e) {
                this._clickAction({
                    event: e,
                    validationGroup: ValidationEngine.getGroupConfig(this._findGroup())
                })
            },
            _updateAriaLabel: function() {
                var icon = this.option("icon"),
                    text = this.option("text");
                if ("image" === iconUtils.getImageSourceType(icon)) {
                    if (icon.indexOf("base64") === -1) {
                        icon = icon.replace(/.+\/([^.]+)\..+$/, "$1")
                    } else {
                        icon = "Base64"
                    }
                }
                var ariaLabel = text || icon || "";
                ariaLabel = ariaLabel.toString().trim();
                this.setAria("label", ariaLabel.length ? ariaLabel : null)
            },
            _renderType: function() {
                var type = this.option("type");
                if (type) {
                    this.$element().addClass("dx-button-" + type)
                }
            },
            _renderStylingMode: function() {
                var _this3 = this;
                var optionName = "stylingMode";
                ALLOWED_STYLE_CLASSES.forEach(function(className) {
                    return _this3.$element().removeClass(className)
                });
                var stylingModeClass = BUTTON_STYLING_MODE_CLASS_PREFIX + this.option(optionName);
                if (ALLOWED_STYLE_CLASSES.indexOf(stylingModeClass) === -1) {
                    var defaultOptionValue = this._getDefaultOptions()[optionName];
                    stylingModeClass = BUTTON_STYLING_MODE_CLASS_PREFIX + defaultOptionValue
                }
                this.$element().addClass(stylingModeClass)
            },
            _refreshType: function(prevType) {
                var type = this.option("type");
                prevType && this.$element().removeClass("dx-button-" + prevType).addClass("dx-button-" + type);
                if (!this.$element().hasClass(BUTTON_HAS_ICON_CLASS) && "back" === type) {
                    this._updateContent()
                }
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "onClick":
                        this._renderClick();
                        break;
                    case "icon":
                    case "text":
                        this._updateContent();
                        this._updateAriaLabel();
                        break;
                    case "type":
                        this._refreshType(args.previousValue);
                        this._updateContent();
                        this._updateAriaLabel();
                        break;
                    case "_templateData":
                        break;
                    case "template":
                    case "iconPosition":
                        this._updateContent();
                        break;
                    case "stylingMode":
                        this._renderStylingMode();
                        break;
                    case "useInkRipple":
                    case "useSubmitBehavior":
                        this._invalidate();
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _clean: function() {
                delete this._inkRipple;
                this.callBase();
                delete this._$content
            }
        }).include(ValidationMixin);
        registerComponent("dxButton", Button);
        module.exports = Button
    },
    /*!*****************************************************************!*\
      !*** ./artifacts/transpiled/ui/grid_core/ui.grid_core.utils.js ***!
      \*****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _renderer = __webpack_require__( /*! ../../core/renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 6);
        var _filtering = __webpack_require__( /*! ../shared/filtering */ 165);
        var _string = __webpack_require__( /*! ../../core/utils/string */ 45);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _data = __webpack_require__( /*! ../../core/utils/data */ 20);
        var _common = __webpack_require__( /*! ../../core/utils/common */ 4);
        var _load_panel = __webpack_require__( /*! ../load_panel */ 162);
        var _load_panel2 = _interopRequireDefault(_load_panel);
        var _utils = __webpack_require__( /*! ../../data/utils */ 41);
        var _format_helper = __webpack_require__( /*! ../../format_helper */ 63);
        var _format_helper2 = _interopRequireDefault(_format_helper);
        var _object = __webpack_require__( /*! ../../core/utils/object */ 47);
        var _window = __webpack_require__( /*! ../../core/utils/window */ 7);
        var _events_engine = __webpack_require__( /*! ../../events/core/events_engine */ 5);
        var _events_engine2 = _interopRequireDefault(_events_engine);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var DATAGRID_SELECTION_DISABLED_CLASS = "dx-selection-disabled",
            DATAGRID_GROUP_OPENED_CLASS = "dx-datagrid-group-opened",
            DATAGRID_GROUP_CLOSED_CLASS = "dx-datagrid-group-closed",
            DATAGRID_EXPAND_CLASS = "dx-datagrid-expand",
            NO_DATA_CLASS = "nodata",
            DATE_INTERVAL_SELECTORS = {
                year: function(value) {
                    return value && value.getFullYear()
                },
                month: function(value) {
                    return value && value.getMonth() + 1
                },
                day: function(value) {
                    return value && value.getDate()
                },
                quarter: function(value) {
                    return value && Math.floor(value.getMonth() / 3) + 1
                },
                hour: function(value) {
                    return value && value.getHours()
                },
                minute: function(value) {
                    return value && value.getMinutes()
                },
                second: function(value) {
                    return value && value.getSeconds()
                }
            };
        module.exports = function() {
            var getIntervalSelector = function() {
                var groupInterval, nameIntervalSelector, data = arguments[1],
                    value = this.calculateCellValue(data);
                if (!(0, _type.isDefined)(value)) {
                    return null
                } else {
                    if (isDateType(this.dataType)) {
                        nameIntervalSelector = arguments[0];
                        return DATE_INTERVAL_SELECTORS[nameIntervalSelector](value)
                    } else {
                        if ("number" === this.dataType) {
                            groupInterval = arguments[0];
                            return Math.floor(Number(value) / groupInterval) * groupInterval
                        }
                    }
                }
            };
            var equalSelectors = function(selector1, selector2) {
                if ((0, _type.isFunction)(selector1) && (0, _type.isFunction)(selector2)) {
                    if (selector1.originalCallback && selector2.originalCallback) {
                        return selector1.originalCallback === selector2.originalCallback
                    }
                }
                return selector1 === selector2
            };
            var isDateType = function(dataType) {
                return "date" === dataType || "datetime" === dataType
            };
            var setEmptyText = function($container) {
                $container.get(0).textContent = "\xa0"
            };
            var getWidgetInstance = function($element) {
                var editorData = $element.data && $element.data(),
                    dxComponents = editorData && editorData.dxComponents,
                    widgetName = dxComponents && dxComponents[0];
                return widgetName && editorData[widgetName]
            };
            return {
                renderNoDataText: function($element) {
                    var that = this;
                    $element = $element || this.element();
                    if (!$element) {
                        return
                    }
                    var noDataClass = that.addWidgetPrefix(NO_DATA_CLASS),
                        noDataElement = $element.find("." + noDataClass).last(),
                        isVisible = this._dataController.isEmpty(),
                        isLoading = this._dataController.isLoading();
                    if (!noDataElement.length) {
                        noDataElement = (0, _renderer2.default)("<span>").addClass(noDataClass).appendTo($element)
                    }
                    if (isVisible && !isLoading) {
                        noDataElement.removeClass("dx-hidden").text(that._getNoDataText())
                    } else {
                        noDataElement.addClass("dx-hidden")
                    }
                },
                renderLoadPanel: function($element, $container, isLocalStore) {
                    var loadPanelOptions, that = this;
                    that._loadPanel && that._loadPanel.$element().remove();
                    loadPanelOptions = that.option("loadPanel");
                    if (loadPanelOptions && ("auto" === loadPanelOptions.enabled ? !isLocalStore : loadPanelOptions.enabled)) {
                        loadPanelOptions = (0, _extend.extend)({
                            shading: false,
                            message: loadPanelOptions.text,
                            position: function() {
                                var $window = (0, _renderer2.default)((0, _window.getWindow)());
                                if ($element.height() > $window.height()) {
                                    return {
                                        of: $window,
                                        boundary: $element,
                                        collision: "fit"
                                    }
                                }
                                return {
                                    of: $element
                                }
                            },
                            container: $container
                        }, loadPanelOptions);
                        that._loadPanel = that._createComponent((0, _renderer2.default)("<div>").appendTo($container), _load_panel2.default, loadPanelOptions)
                    } else {
                        that._loadPanel = null
                    }
                },
                getIndexByKey: function(key, items, keyName) {
                    var item, index = -1;
                    if (void 0 !== key && Array.isArray(items)) {
                        keyName = arguments.length <= 2 ? "key" : keyName;
                        for (var i = 0; i < items.length; i++) {
                            item = (0, _type.isDefined)(keyName) ? items[i][keyName] : items[i];
                            if ((0, _common.equalByValue)(key, item)) {
                                index = i;
                                break
                            }
                        }
                    }
                    return index
                },
                combineFilters: function(filters, operation) {
                    var i, resultFilter = [];
                    operation = operation || "and";
                    for (i = 0; i < filters.length; i++) {
                        if (!filters[i]) {
                            continue
                        }
                        if (resultFilter.length) {
                            resultFilter.push(operation)
                        }
                        resultFilter.push(filters[i])
                    }
                    if (1 === resultFilter.length) {
                        resultFilter = resultFilter[0]
                    }
                    if (resultFilter.length) {
                        return resultFilter
                    }
                },
                checkChanges: function(changes, changeNames) {
                    var i, changesWithChangeNamesCount = 0;
                    for (i = 0; i < changeNames.length; i++) {
                        if (changes[changeNames[i]]) {
                            changesWithChangeNamesCount++
                        }
                    }
                    return changes.length && changes.length === changesWithChangeNamesCount
                },
                equalFilterParameters: function(filter1, filter2) {
                    var i;
                    if (Array.isArray(filter1) && Array.isArray(filter2)) {
                        if (filter1.length !== filter2.length) {
                            return false
                        } else {
                            for (i = 0; i < filter1.length; i++) {
                                if (!module.exports.equalFilterParameters(filter1[i], filter2[i])) {
                                    return false
                                }
                            }
                        }
                        return true
                    } else {
                        if ((0, _type.isFunction)(filter1) && filter1.columnIndex >= 0 && (0, _type.isFunction)(filter2) && filter2.columnIndex >= 0) {
                            return filter1.columnIndex === filter2.columnIndex && (0, _data.toComparable)(filter1.filterValue) === (0, _data.toComparable)(filter2.filterValue)
                        } else {
                            return (0, _data.toComparable)(filter1) == (0, _data.toComparable)(filter2)
                        }
                    }
                },
                proxyMethod: function(instance, methodName, defaultResult) {
                    if (!instance[methodName]) {
                        instance[methodName] = function() {
                            var dataSource = this._dataSource;
                            return dataSource ? dataSource[methodName].apply(dataSource, arguments) : defaultResult
                        }
                    }
                },
                formatValue: function(value, options) {
                    var valueText = _format_helper2.default.format(value, options.format) || value && value.toString() || "",
                        formatObject = {
                            value: value,
                            valueText: options.getDisplayFormat ? options.getDisplayFormat(valueText) : valueText,
                            target: options.target || "row",
                            groupInterval: options.groupInterval
                        };
                    return options.customizeText ? options.customizeText.call(options, formatObject) : formatObject.valueText
                },
                getFormatOptionsByColumn: function(column, target) {
                    return {
                        format: column.format,
                        getDisplayFormat: column.getDisplayFormat,
                        customizeText: column.customizeText,
                        target: target,
                        trueText: column.trueText,
                        falseText: column.falseText
                    }
                },
                getDisplayValue: function(column, value, data, rowType) {
                    if (column.displayValueMap && void 0 !== column.displayValueMap[value]) {
                        return column.displayValueMap[value]
                    } else {
                        if (column.calculateDisplayValue && data && "group" !== rowType) {
                            return column.calculateDisplayValue(data)
                        } else {
                            if (column.lookup && !("group" === rowType && (column.calculateGroupValue || column.calculateDisplayValue))) {
                                return column.lookup.calculateCellValue(value)
                            }
                        }
                    }
                    return value
                },
                getGroupRowSummaryText: function(summaryItems, summaryTexts) {
                    var i, summaryItem, result = "(";
                    for (i = 0; i < summaryItems.length; i++) {
                        summaryItem = summaryItems[i];
                        result += (i > 0 ? ", " : "") + module.exports.getSummaryText(summaryItem, summaryTexts)
                    }
                    return result += ")"
                },
                getSummaryText: function(summaryItem, summaryTexts) {
                    var displayFormat = summaryItem.displayFormat || summaryItem.columnCaption && summaryTexts[summaryItem.summaryType + "OtherColumn"] || summaryTexts[summaryItem.summaryType];
                    return this.formatValue(summaryItem.value, {
                        format: summaryItem.valueFormat,
                        getDisplayFormat: function(valueText) {
                            return displayFormat ? (0, _string.format)(displayFormat, valueText, summaryItem.columnCaption) : valueText
                        },
                        customizeText: summaryItem.customizeText
                    })
                },
                normalizeSortingInfo: function(sort) {
                    sort = sort || [];
                    var result, i;
                    result = (0, _utils.normalizeSortingInfo)(sort);
                    for (i = 0; i < sort.length; i++) {
                        if (sort && sort[i] && void 0 !== sort[i].isExpanded) {
                            result[i].isExpanded = sort[i].isExpanded
                        }
                        if (sort && sort[i] && void 0 !== sort[i].groupInterval) {
                            result[i].groupInterval = sort[i].groupInterval
                        }
                    }
                    return result
                },
                getFormatByDataType: function(dataType) {
                    switch (dataType) {
                        case "date":
                            return "shortDate";
                        case "datetime":
                            return "shortDateShortTime"
                    }
                },
                getHeaderFilterGroupParameters: function(column, remoteGrouping) {
                    var result = [],
                        dataField = column.dataField || column.name,
                        groupInterval = (0, _filtering.getGroupInterval)(column);
                    if (groupInterval) {
                        (0, _iterator.each)(groupInterval, function(index, interval) {
                            result.push(remoteGrouping ? {
                                selector: dataField,
                                groupInterval: interval,
                                isExpanded: index < groupInterval.length - 1
                            } : getIntervalSelector.bind(column, interval))
                        });
                        return result
                    }
                    if (remoteGrouping) {
                        result = [{
                            selector: dataField,
                            isExpanded: false
                        }]
                    } else {
                        result = function result(data) {
                            var result = column.calculateCellValue(data);
                            if (void 0 === result || "" === result) {
                                result = null
                            }
                            return result
                        };
                        if (column.sortingMethod) {
                            result = [{
                                selector: result,
                                compare: column.sortingMethod.bind(column)
                            }]
                        }
                    }
                    return result
                },
                equalSortParameters: function(sortParameters1, sortParameters2, ignoreIsExpanded) {
                    var i;
                    sortParameters1 = module.exports.normalizeSortingInfo(sortParameters1);
                    sortParameters2 = module.exports.normalizeSortingInfo(sortParameters2);
                    if (Array.isArray(sortParameters1) && Array.isArray(sortParameters2)) {
                        if (sortParameters1.length !== sortParameters2.length) {
                            return false
                        } else {
                            for (i = 0; i < sortParameters1.length; i++) {
                                if (!equalSelectors(sortParameters1[i].selector, sortParameters2[i].selector) || sortParameters1[i].desc !== sortParameters2[i].desc || sortParameters1[i].groupInterval !== sortParameters2[i].groupInterval || !ignoreIsExpanded && Boolean(sortParameters1[i].isExpanded) !== Boolean(sortParameters2[i].isExpanded)) {
                                    return false
                                }
                            }
                        }
                        return true
                    } else {
                        return (!sortParameters1 || !sortParameters1.length) === (!sortParameters2 || !sortParameters2.length)
                    }
                },
                getPointsByColumns: function(items, pointCreated, isVertical, startColumnIndex) {
                    var point, i, item, offset, prevItemOffset, rtlEnabled, cellsLength = items.length,
                        notCreatePoint = false,
                        columnIndex = startColumnIndex || 0,
                        result = [];
                    for (i = 0; i <= cellsLength; i++) {
                        if (i < cellsLength) {
                            item = items.eq(i);
                            offset = item.offset();
                            rtlEnabled = "rtl" === item.css("direction")
                        }
                        point = {
                            index: columnIndex,
                            x: offset ? offset.left + (!isVertical && rtlEnabled ^ i === cellsLength ? item[0].getBoundingClientRect().width : 0) : 0,
                            y: offset ? offset.top + (isVertical && i === cellsLength ? item[0].getBoundingClientRect().height : 0) : 0,
                            columnIndex: columnIndex
                        };
                        if (!isVertical && i > 0) {
                            prevItemOffset = items.eq(i - 1).offset();
                            if (prevItemOffset.top < point.y) {
                                point.y = prevItemOffset.top
                            }
                        }
                        if (pointCreated) {
                            notCreatePoint = pointCreated(point)
                        }
                        if (!notCreatePoint) {
                            result.push(point)
                        }
                        columnIndex++
                    }
                    return result
                },
                createObjectWithChanges: function(target, changes) {
                    var result = target ? Object.create(Object.getPrototypeOf(target)) : {},
                        targetWithoutPrototype = (0, _extend.extendFromObject)({}, target);
                    (0, _object.deepExtendArraySafe)(result, targetWithoutPrototype, true, true);
                    return (0, _object.deepExtendArraySafe)(result, changes, true, true)
                },
                getExpandCellTemplate: function() {
                    return {
                        allowRenderToDetachedContainer: true,
                        render: function(container, options) {
                            var rowsView, $container = (0, _renderer2.default)(container);
                            if ((0, _type.isDefined)(options.value) && !(options.data && options.data.isContinuation) && !options.row.isNewRow) {
                                rowsView = options.component.getView("rowsView");
                                $container.addClass(DATAGRID_EXPAND_CLASS).addClass(DATAGRID_SELECTION_DISABLED_CLASS);
                                (0, _renderer2.default)("<div>").addClass(options.value ? DATAGRID_GROUP_OPENED_CLASS : DATAGRID_GROUP_CLOSED_CLASS).appendTo($container);
                                rowsView.setAria("label", options.value ? rowsView.localize("dxDataGrid-ariaCollapse") : rowsView.localize("dxDataGrid-ariaExpand"), $container)
                            } else {
                                setEmptyText($container)
                            }
                        }
                    }
                },
                setEmptyText: setEmptyText,
                isDateType: isDateType,
                getSelectionRange: function(focusedElement) {
                    try {
                        if (focusedElement) {
                            return {
                                selectionStart: focusedElement.selectionStart,
                                selectionEnd: focusedElement.selectionEnd
                            }
                        }
                    } catch (e) {}
                    return {}
                },
                setSelectionRange: function(focusedElement, selectionRange) {
                    try {
                        if (focusedElement && focusedElement.setSelectionRange) {
                            focusedElement.setSelectionRange(selectionRange.selectionStart, selectionRange.selectionEnd)
                        }
                    } catch (e) {}
                },
                focusAndSelectElement: function(component, $element) {
                    _events_engine2.default.trigger($element, "focus");
                    var isSelectTextOnEditingStart = component.option("editing.selectTextOnEditStart"),
                        keyboardController = component.getController("keyboardNavigation"),
                        isEditingNavigationMode = keyboardController && keyboardController._isFastEditingStarted();
                    if (isSelectTextOnEditingStart && !isEditingNavigationMode && $element.is(".dx-texteditor-input")) {
                        var editor = getWidgetInstance($element.closest(".dx-texteditor"));
                        (0, _deferred.when)(editor && editor._loadItemDeferred).done(function() {
                            $element.get(0).select()
                        })
                    }
                },
                getWidgetInstance: getWidgetInstance,
                getLastResizableColumnIndex: function(columns, resultWidths) {
                    var hasResizableColumns = columns.some(function(column) {
                        return column && !column.command && !column.fixed && false !== column.allowResizing
                    });
                    for (var lastColumnIndex = columns.length - 1; columns[lastColumnIndex]; lastColumnIndex--) {
                        var column = columns[lastColumnIndex],
                            width = resultWidths && resultWidths[lastColumnIndex],
                            allowResizing = !hasResizableColumns || false !== column.allowResizing;
                        if (!column.command && !column.fixed && "adaptiveHidden" !== width && allowResizing) {
                            break
                        }
                    }
                    return lastColumnIndex
                },
                isElementInCurrentGrid: function(controller, $element) {
                    if ($element && $element.length) {
                        var $grid = $element.closest("." + controller.getWidgetContainerClass()).parent();
                        return $grid.is(controller.component.$element())
                    }
                    return false
                }
            }
        }()
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/data/errors.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var errorUtils = __webpack_require__( /*! ../core/utils/error */ 132),
            coreErrors = __webpack_require__( /*! ../core/errors */ 21),
            handlers = {};
        var errors = errorUtils(coreErrors.ERROR_MESSAGES, {
            E4000: "[DevExpress.data]: {0}",
            E4001: "Unknown aggregating function is detected: '{0}'",
            E4002: "Unsupported OData protocol version is used",
            E4003: "Unknown filter operation is used: {0}",
            E4004: "The thenby() method is called before the sortby() method",
            E4005: "Store requires a key expression for this operation",
            E4006: "ArrayStore 'data' option must be an array",
            E4007: "Compound keys cannot be auto-generated",
            E4008: "Attempt to insert an item with the a duplicated key",
            E4009: "Data item cannot be found",
            E4010: "CustomStore does not support creating queries",
            E4011: "Custom Store method is not implemented or is not a function: {0}",
            E4012: "Custom Store method returns an invalid value: {0}",
            E4013: "Local Store requires the 'name' configuration option is specified",
            E4014: "Unknown data type is specified for ODataStore: {0}",
            E4015: "Unknown entity name or alias is used: {0}",
            E4016: "The compileSetter(expr) method is called with 'self' passed as a parameter",
            E4017: "Keys cannot be modified",
            E4018: "The server has returned a non-numeric value in a response to an item count request",
            E4019: "Mixing of group operators inside a single group of filter expression is not allowed",
            E4020: "Unknown store type is detected: {0}",
            E4021: "The server response does not provide the totalCount value",
            E4022: "The server response does not provide the groupCount value",
            E4023: "Could not parse the following XML: {0}",
            W4000: "Data returned from the server has an incorrect structure",
            W4001: 'The {0} field is listed in both "keyType" and "fieldTypes". The value of "fieldTypes" is used.',
            W4002: "Data loading has failed for some cells due to the following error: {0}"
        });

        function handleError(error) {
            var id = "E4000";
            if (error && "__id" in error) {
                id = error.__id
            }
            errors.log(id, error)
        }
        var errorHandler = null;
        var _errorHandler = function(error) {
            handleError(error);
            if (handlers.errorHandler) {
                handlers.errorHandler(error)
            }
        };
        handlers = {
            errors: errors,
            errorHandler: errorHandler,
            _errorHandler: _errorHandler
        };
        module.exports = handlers
    },
    /*!*******************************************************************!*\
      !*** ./artifacts/transpiled/ui/grid_core/ui.grid_core.modules.js ***!
      \*******************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _renderer = __webpack_require__( /*! ../../core/renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _events_engine = __webpack_require__( /*! ../../events/core/events_engine */ 5);
        var _events_engine2 = _interopRequireDefault(_events_engine);
        var _class = __webpack_require__( /*! ../../core/class */ 15);
        var _class2 = _interopRequireDefault(_class);
        var _callbacks = __webpack_require__( /*! ../../core/utils/callbacks */ 26);
        var _callbacks2 = _interopRequireDefault(_callbacks);
        var _common = __webpack_require__( /*! ../../core/utils/common */ 4);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _array = __webpack_require__( /*! ../../core/utils/array */ 14);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        var _ui = __webpack_require__( /*! ../widget/ui.errors */ 18);
        var _ui2 = _interopRequireDefault(_ui);
        var _message = __webpack_require__( /*! ../../localization/message */ 10);
        var _message2 = _interopRequireDefault(_message);
        var _window = __webpack_require__( /*! ../../core/utils/window */ 7);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var WIDGET_WITH_LEGACY_CONTAINER_NAME = "dxDataGrid";
        var ModuleItem = _class2.default.inherit({
            _endUpdateCore: function() {},
            ctor: function(component) {
                var that = this;
                that._updateLockCount = 0;
                that.component = component;
                that._actions = {};
                that._actionConfigs = {};
                (0, _iterator.each)(this.callbackNames() || [], function(index, name) {
                    var flags = that.callbackFlags(name) || {};
                    flags.unique = true, flags.syncStrategy = true;
                    that[this] = (0, _callbacks2.default)(flags)
                })
            },
            init: function() {},
            callbackNames: function() {},
            callbackFlags: function() {},
            publicMethods: function() {},
            beginUpdate: function() {
                this._updateLockCount++
            },
            endUpdate: function() {
                if (this._updateLockCount > 0) {
                    this._updateLockCount--;
                    if (!this._updateLockCount) {
                        this._endUpdateCore()
                    }
                }
            },
            option: function(name) {
                var component = this.component,
                    optionCache = component._optionCache;
                if (1 === arguments.length && optionCache) {
                    if (!(name in optionCache)) {
                        optionCache[name] = component.option(name)
                    }
                    return optionCache[name]
                }
                return component.option.apply(component, arguments)
            },
            localize: function(name) {
                var optionCache = this.component._optionCache;
                if (optionCache) {
                    if (!(name in optionCache)) {
                        optionCache[name] = _message2.default.format(name)
                    }
                    return optionCache[name]
                }
                return _message2.default.format(name)
            },
            on: function() {
                return this.component.on.apply(this.component, arguments)
            },
            off: function() {
                return this.component.off.apply(this.component, arguments)
            },
            optionChanged: function(args) {
                if (args.name in this._actions) {
                    this.createAction(args.name, this._actionConfigs[args.name]);
                    args.handled = true
                }
            },
            getAction: function(actionName) {
                return this._actions[actionName]
            },
            setAria: function(name, value, $target) {
                var target = $target.get(0),
                    prefix = "role" !== name && "id" !== name ? "aria-" : "";
                if (target.setAttribute) {
                    target.setAttribute(prefix + name, value)
                } else {
                    $target.attr(prefix + name, value)
                }
            },
            _createComponent: function() {
                return this.component._createComponent.apply(this.component, arguments)
            },
            getController: function(name) {
                return this.component._controllers[name]
            },
            createAction: function(actionName, config) {
                var action;
                if ((0, _type.isFunction)(actionName)) {
                    action = this.component._createAction(actionName.bind(this), config);
                    return function(e) {
                        action({
                            event: e
                        })
                    }
                } else {
                    this._actions[actionName] = this.component._createActionByOption(actionName, config);
                    this._actionConfigs[actionName] = config
                }
            },
            executeAction: function(actionName, options) {
                var action = this._actions[actionName];
                return action && action(options)
            },
            dispose: function() {
                var that = this;
                (0, _iterator.each)(that.callbackNames() || [], function() {
                    that[this].empty()
                })
            },
            addWidgetPrefix: function(className) {
                var componentName = this.component.NAME;
                return "dx-" + componentName.slice(2).toLowerCase() + (className ? "-" + className : "")
            },
            getWidgetContainerClass: function() {
                var containerName = this.component.NAME === WIDGET_WITH_LEGACY_CONTAINER_NAME ? null : "container";
                return this.addWidgetPrefix(containerName)
            }
        });
        var Controller = ModuleItem;
        var ViewController = Controller.inherit({
            getView: function(name) {
                return this.component._views[name]
            },
            getViews: function() {
                return this.component._views
            }
        });
        var View = ModuleItem.inherit({
            _isReady: function() {
                return this.component.isReady()
            },
            _endUpdateCore: function() {
                this.callBase();
                if (!this._isReady() && this._requireReady) {
                    this._requireRender = false;
                    this.component._requireResize = false
                }
                if (this._requireRender) {
                    this._requireRender = false;
                    this.render(this._$parent)
                }
            },
            _invalidate: function(requireResize, requireReady) {
                this._requireRender = true;
                this.component._requireResize = (0, _window.hasWindow)() && (this.component._requireResize || requireResize);
                this._requireReady = this._requireReady || requireReady
            },
            _renderCore: function() {},
            _resizeCore: function() {},
            _afterRender: function() {},
            _parentElement: function() {
                return this._$parent
            },
            ctor: function(component) {
                this.callBase(component);
                this.renderCompleted = (0, _callbacks2.default)();
                this.resizeCompleted = (0, _callbacks2.default)()
            },
            element: function() {
                return this._$element
            },
            getElementHeight: function() {
                var $element = this.element();
                if (!$element) {
                    return 0
                }
                var marginTop = parseFloat($element.css("marginTop")) || 0,
                    marginBottom = parseFloat($element.css("marginBottom")) || 0,
                    offsetHeight = $element.get(0).offsetHeight;
                return offsetHeight + marginTop + marginBottom
            },
            isVisible: function() {
                return true
            },
            getTemplate: function(name) {
                return this.component._getTemplate(name)
            },
            render: function($parent, options) {
                var $element = this._$element,
                    isVisible = this.isVisible();
                if (!$element && !$parent) {
                    return
                }
                this._requireReady = false;
                if (!$element) {
                    $element = this._$element = (0, _renderer2.default)("<div>").appendTo($parent);
                    this._$parent = $parent
                }
                $element.toggleClass("dx-hidden", !isVisible);
                if (isVisible) {
                    this.component._optionCache = {};
                    this._renderCore(options);
                    this.component._optionCache = void 0;
                    this._afterRender($parent);
                    this.renderCompleted.fire(options)
                }
            },
            resize: function() {
                this.isResizing = true;
                this._resizeCore();
                this.resizeCompleted.fire();
                this.isResizing = false
            },
            focus: function() {
                _events_engine2.default.trigger(this.element(), "focus")
            }
        });
        var MODULES_ORDER_MAX_INDEX = 1e6;
        var processModules = function(that, componentClass) {
            var modules = componentClass.modules,
                modulesOrder = componentClass.modulesOrder,
                controllerTypes = componentClass.controllerTypes || {},
                viewTypes = componentClass.viewTypes || {};
            if (!componentClass.controllerTypes) {
                if (modulesOrder) {
                    modules.sort(function(module1, module2) {
                        var orderIndex1 = (0, _array.inArray)(module1.name, modulesOrder);
                        var orderIndex2 = (0, _array.inArray)(module2.name, modulesOrder);
                        if (orderIndex1 < 0) {
                            orderIndex1 = MODULES_ORDER_MAX_INDEX
                        }
                        if (orderIndex2 < 0) {
                            orderIndex2 = MODULES_ORDER_MAX_INDEX
                        }
                        return orderIndex1 - orderIndex2
                    })
                }(0, _iterator.each)(modules, function() {
                    var controllers = this.controllers,
                        moduleName = this.name,
                        views = this.views;
                    controllers && (0, _iterator.each)(controllers, function(name, type) {
                        if (controllerTypes[name]) {
                            throw _ui2.default.Error("E1001", moduleName, name)
                        } else {
                            if (!(type && type.subclassOf && type.subclassOf(Controller))) {
                                type.subclassOf(Controller);
                                throw _ui2.default.Error("E1002", moduleName, name)
                            }
                        }
                        controllerTypes[name] = type
                    });
                    views && (0, _iterator.each)(views, function(name, type) {
                        if (viewTypes[name]) {
                            throw _ui2.default.Error("E1003", moduleName, name)
                        } else {
                            if (!(type && type.subclassOf && type.subclassOf(View))) {
                                throw _ui2.default.Error("E1004", moduleName, name)
                            }
                        }
                        viewTypes[name] = type
                    })
                });
                (0, _iterator.each)(modules, function() {
                    var extenders = this.extenders;
                    if (extenders) {
                        extenders.controllers && (0, _iterator.each)(extenders.controllers, function(name, extender) {
                            if (controllerTypes[name]) {
                                controllerTypes[name] = controllerTypes[name].inherit(extender)
                            }
                        });
                        extenders.views && (0, _iterator.each)(extenders.views, function(name, extender) {
                            if (viewTypes[name]) {
                                viewTypes[name] = viewTypes[name].inherit(extender)
                            }
                        })
                    }
                });
                componentClass.controllerTypes = controllerTypes;
                componentClass.viewTypes = viewTypes
            }
            var registerPublicMethods = function(that, name, moduleItem) {
                var publicMethods = moduleItem.publicMethods();
                if (publicMethods) {
                    (0, _iterator.each)(publicMethods, function(index, methodName) {
                        if (moduleItem[methodName]) {
                            if (!that[methodName]) {
                                that[methodName] = function() {
                                    return moduleItem[methodName].apply(moduleItem, arguments)
                                }
                            } else {
                                throw _ui2.default.Error("E1005", methodName)
                            }
                        } else {
                            throw _ui2.default.Error("E1006", name, methodName)
                        }
                    })
                }
            };
            var createModuleItems = function(moduleTypes) {
                var moduleItems = {};
                (0, _iterator.each)(moduleTypes, function(name, moduleType) {
                    var moduleItem = new moduleType(that);
                    moduleItem.name = name;
                    registerPublicMethods(that, name, moduleItem);
                    moduleItems[name] = moduleItem
                });
                return moduleItems
            };
            that._controllers = createModuleItems(controllerTypes);
            that._views = createModuleItems(viewTypes)
        };
        var callModuleItemsMethod = function(that, methodName, args) {
            args = args || [];
            if (that._controllers) {
                (0, _iterator.each)(that._controllers, function() {
                    this[methodName] && this[methodName].apply(this, args)
                })
            }
            if (that._views) {
                (0, _iterator.each)(that._views, function() {
                    this[methodName] && this[methodName].apply(this, args)
                })
            }
        };
        module.exports = {
            modules: [],
            View: View,
            ViewController: ViewController,
            Controller: Controller,
            registerModule: function(name, module) {
                var i, modules = this.modules;
                for (i = 0; i < modules.length; i++) {
                    if (modules[i].name === name) {
                        return
                    }
                }
                module.name = name;
                modules.push(module);
                delete this.controllerTypes;
                delete this.viewTypes
            },
            registerModulesOrder: function(moduleNames) {
                this.modulesOrder = moduleNames
            },
            unregisterModule: function(name) {
                this.modules = (0, _common.grep)(this.modules, function(module) {
                    return module.name !== name
                });
                delete this.controllerTypes;
                delete this.viewTypes
            },
            processModules: processModules,
            callModuleItemsMethod: callModuleItemsMethod
        }
    },
    /*!**********************************************!*\
      !*** ./artifacts/transpiled/animation/fx.js ***!
      \**********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            window = __webpack_require__( /*! ../core/utils/window */ 7).getWindow(),
            eventsEngine = __webpack_require__( /*! ../events/core/events_engine */ 5),
            errors = __webpack_require__( /*! ../core/errors */ 21),
            getPublicElement = __webpack_require__( /*! ../core/utils/dom */ 11).getPublicElement,
            extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            typeUtils = __webpack_require__( /*! ../core/utils/type */ 1),
            iteratorUtils = __webpack_require__( /*! ../core/utils/iterator */ 3),
            translator = __webpack_require__( /*! ./translator */ 27),
            easing = __webpack_require__( /*! ./easing */ 272),
            animationFrame = __webpack_require__( /*! ./frame */ 113),
            support = __webpack_require__( /*! ../core/utils/support */ 44),
            positionUtils = __webpack_require__( /*! ./position */ 78),
            removeEvent = __webpack_require__( /*! ../core/remove_event */ 136),
            eventUtils = __webpack_require__( /*! ../events/utils */ 9),
            deferredUtils = __webpack_require__( /*! ../core/utils/deferred */ 6),
            when = deferredUtils.when,
            Deferred = deferredUtils.Deferred,
            removeEventName = eventUtils.addNamespace(removeEvent, "dxFX"),
            isFunction = typeUtils.isFunction,
            isPlainObject = typeUtils.isPlainObject,
            noop = __webpack_require__( /*! ../core/utils/common */ 4).noop;
        var RELATIVE_VALUE_REGEX = /^([+-])=(.*)/i,
            ANIM_DATA_KEY = "dxAnimData",
            ANIM_QUEUE_KEY = "dxAnimQueue",
            TRANSFORM_PROP = "transform";
        var TransitionAnimationStrategy = {
            initAnimation: function($element, config) {
                $element.css({
                    transitionProperty: "none"
                });
                if ("string" === typeof config.from) {
                    $element.addClass(config.from)
                } else {
                    setProps($element, config.from)
                }
                var that = this,
                    deferred = new Deferred,
                    cleanupWhen = config.cleanupWhen;
                config.transitionAnimation = {
                    deferred: deferred,
                    finish: function() {
                        that._finishTransition($element);
                        if (cleanupWhen) {
                            when(deferred, cleanupWhen).always(function() {
                                that._cleanup($element, config)
                            })
                        } else {
                            that._cleanup($element, config)
                        }
                        deferred.resolveWith($element, [config, $element])
                    }
                };
                this._completeAnimationCallback($element, config).done(function() {
                    config.transitionAnimation.finish()
                }).fail(function() {
                    deferred.rejectWith($element, [config, $element])
                });
                if (!config.duration) {
                    config.transitionAnimation.finish()
                }
                $element.css("transform")
            },
            animate: function($element, config) {
                this._startAnimation($element, config);
                return config.transitionAnimation.deferred.promise()
            },
            _completeAnimationCallback: function($element, config) {
                var simulatedEndEventTimer, waitForJSCompleteTimer, that = this,
                    startTime = Date.now() + config.delay,
                    deferred = new Deferred,
                    transitionEndFired = new Deferred,
                    simulatedTransitionEndFired = new Deferred,
                    transitionEndEventName = support.transitionEndEventName() + ".dxFX";
                config.transitionAnimation.cleanup = function() {
                    clearTimeout(simulatedEndEventTimer);
                    clearTimeout(waitForJSCompleteTimer);
                    eventsEngine.off($element, transitionEndEventName);
                    eventsEngine.off($element, removeEventName)
                };
                eventsEngine.one($element, transitionEndEventName, function() {
                    if (Date.now() - startTime >= config.duration) {
                        transitionEndFired.reject()
                    }
                });
                eventsEngine.off($element, removeEventName);
                eventsEngine.on($element, removeEventName, function() {
                    that.stop($element, config);
                    deferred.reject()
                });
                waitForJSCompleteTimer = setTimeout(function() {
                    simulatedEndEventTimer = setTimeout(function() {
                        simulatedTransitionEndFired.reject()
                    }, config.duration + config.delay + fx._simulatedTransitionEndDelay);
                    when(transitionEndFired, simulatedTransitionEndFired).fail(function() {
                        deferred.resolve()
                    }.bind(this))
                });
                return deferred.promise()
            },
            _startAnimation: function($element, config) {
                $element.css({
                    transitionProperty: "all",
                    transitionDelay: config.delay + "ms",
                    transitionDuration: config.duration + "ms",
                    transitionTimingFunction: config.easing
                });
                if ("string" === typeof config.to) {
                    $element[0].className += " " + config.to
                } else {
                    if (config.to) {
                        setProps($element, config.to)
                    }
                }
            },
            _finishTransition: function($element) {
                $element.css("transition", "none")
            },
            _cleanup: function($element, config) {
                config.transitionAnimation.cleanup();
                if ("string" === typeof config.from) {
                    $element.removeClass(config.from);
                    $element.removeClass(config.to)
                }
            },
            stop: function($element, config, jumpToEnd) {
                if (!config) {
                    return
                }
                if (jumpToEnd) {
                    config.transitionAnimation.finish()
                } else {
                    if (isPlainObject(config.to)) {
                        iteratorUtils.each(config.to, function(key) {
                            $element.css(key, $element.css(key))
                        })
                    }
                    this._finishTransition($element);
                    this._cleanup($element, config)
                }
            }
        };
        var FrameAnimationStrategy = {
            initAnimation: function($element, config) {
                setProps($element, config.from)
            },
            animate: function($element, config) {
                var deferred = new Deferred,
                    that = this;
                if (!config) {
                    return deferred.reject().promise()
                }
                iteratorUtils.each(config.to, function(prop) {
                    if (void 0 === config.from[prop]) {
                        config.from[prop] = that._normalizeValue($element.css(prop))
                    }
                });
                if (config.to[TRANSFORM_PROP]) {
                    config.from[TRANSFORM_PROP] = that._parseTransform(config.from[TRANSFORM_PROP]);
                    config.to[TRANSFORM_PROP] = that._parseTransform(config.to[TRANSFORM_PROP])
                }
                config.frameAnimation = {
                    to: config.to,
                    from: config.from,
                    currentValue: config.from,
                    easing: easing.convertTransitionTimingFuncToEasing(config.easing),
                    duration: config.duration,
                    startTime: (new Date).valueOf(),
                    finish: function() {
                        this.currentValue = this.to;
                        this.draw();
                        animationFrame.cancelAnimationFrame(config.frameAnimation.animationFrameId);
                        deferred.resolve()
                    },
                    draw: function() {
                        if (config.draw) {
                            config.draw(this.currentValue);
                            return
                        }
                        var currentValue = extend({}, this.currentValue);
                        if (currentValue[TRANSFORM_PROP]) {
                            currentValue[TRANSFORM_PROP] = iteratorUtils.map(currentValue[TRANSFORM_PROP], function(value, prop) {
                                if ("translate" === prop) {
                                    return translator.getTranslateCss(value)
                                } else {
                                    if ("scale" === prop) {
                                        return "scale(" + value + ")"
                                    } else {
                                        if ("rotate" === prop.substr(0, prop.length - 1)) {
                                            return prop + "(" + value + "deg)"
                                        }
                                    }
                                }
                            }).join(" ")
                        }
                        $element.css(currentValue)
                    }
                };
                if (config.delay) {
                    config.frameAnimation.startTime += config.delay;
                    config.frameAnimation.delayTimeout = setTimeout(function() {
                        that._startAnimation($element, config)
                    }, config.delay)
                } else {
                    that._startAnimation($element, config)
                }
                return deferred.promise()
            },
            _startAnimation: function($element, config) {
                eventsEngine.off($element, removeEventName);
                eventsEngine.on($element, removeEventName, function() {
                    if (config.frameAnimation) {
                        animationFrame.cancelAnimationFrame(config.frameAnimation.animationFrameId)
                    }
                });
                this._animationStep($element, config)
            },
            _parseTransform: function(transformString) {
                var result = {};
                iteratorUtils.each(transformString.match(/(\w|\d)+\([^)]*\)\s*/g), function(i, part) {
                    var translateData = translator.parseTranslate(part),
                        scaleData = part.match(/scale\((.+?)\)/),
                        rotateData = part.match(/(rotate.)\((.+)deg\)/);
                    if (translateData) {
                        result.translate = translateData
                    }
                    if (scaleData && scaleData[1]) {
                        result.scale = parseFloat(scaleData[1])
                    }
                    if (rotateData && rotateData[1]) {
                        result[rotateData[1]] = parseFloat(rotateData[2])
                    }
                });
                return result
            },
            stop: function($element, config, jumpToEnd) {
                var frameAnimation = config && config.frameAnimation;
                if (!frameAnimation) {
                    return
                }
                animationFrame.cancelAnimationFrame(frameAnimation.animationFrameId);
                clearTimeout(frameAnimation.delayTimeout);
                if (jumpToEnd) {
                    frameAnimation.finish()
                }
                delete config.frameAnimation
            },
            _animationStep: function($element, config) {
                var frameAnimation = config && config.frameAnimation;
                if (!frameAnimation) {
                    return
                }
                var now = (new Date).valueOf();
                if (now >= frameAnimation.startTime + frameAnimation.duration) {
                    frameAnimation.finish();
                    return
                }
                frameAnimation.currentValue = this._calcStepValue(frameAnimation, now - frameAnimation.startTime);
                frameAnimation.draw();
                var that = this;
                frameAnimation.animationFrameId = animationFrame.requestAnimationFrame(function() {
                    that._animationStep($element, config)
                })
            },
            _calcStepValue: function(frameAnimation, currentDuration) {
                var calcValueRecursively = function calcValueRecursively(from, to) {
                    var result = Array.isArray(to) ? [] : {};
                    var calcEasedValue = function(propName) {
                        var x = currentDuration / frameAnimation.duration,
                            t = currentDuration,
                            b = 1 * from[propName],
                            c = to[propName] - from[propName],
                            d = frameAnimation.duration;
                        return easing.getEasing(frameAnimation.easing)(x, t, b, c, d)
                    };
                    iteratorUtils.each(to, function(propName, endPropValue) {
                        if ("string" === typeof endPropValue && false === parseFloat(endPropValue, 10)) {
                            return true
                        }
                        result[propName] = "object" === ("undefined" === typeof endPropValue ? "undefined" : _typeof(endPropValue)) ? calcValueRecursively(from[propName], endPropValue) : calcEasedValue(propName)
                    });
                    return result
                };
                return calcValueRecursively(frameAnimation.from, frameAnimation.to)
            },
            _normalizeValue: function(value) {
                var numericValue = parseFloat(value, 10);
                if (false === numericValue) {
                    return value
                }
                return numericValue
            }
        };
        var FallbackToNoAnimationStrategy = {
            initAnimation: function() {},
            animate: function() {
                return (new Deferred).resolve().promise()
            },
            stop: noop,
            isSynchronous: true
        };
        var getAnimationStrategy = function(config) {
            config = config || {};
            var animationStrategies = {
                transition: support.transition() ? TransitionAnimationStrategy : FrameAnimationStrategy,
                frame: FrameAnimationStrategy,
                noAnimation: FallbackToNoAnimationStrategy
            };
            var strategy = config.strategy || "transition";
            if ("css" === config.type && !support.transition()) {
                strategy = "noAnimation"
            }
            return animationStrategies[strategy]
        };
        var baseConfigValidator = function(config, animationType, validate, typeMessage) {
            iteratorUtils.each(["from", "to"], function() {
                if (!validate(config[this])) {
                    throw errors.Error("E0010", animationType, this, typeMessage)
                }
            })
        };
        var isObjectConfigValidator = function(config, animationType) {
            return baseConfigValidator(config, animationType, function(target) {
                return isPlainObject(target)
            }, "a plain object")
        };
        var isStringConfigValidator = function(config, animationType) {
            return baseConfigValidator(config, animationType, function(target) {
                return "string" === typeof target
            }, "a string")
        };
        var CustomAnimationConfigurator = {
            setup: function() {}
        };
        var CssAnimationConfigurator = {
            validateConfig: function(config) {
                isStringConfigValidator(config, "css")
            },
            setup: function() {}
        };
        var positionAliases = {
            top: {
                my: "bottom center",
                at: "top center"
            },
            bottom: {
                my: "top center",
                at: "bottom center"
            },
            right: {
                my: "left center",
                at: "right center"
            },
            left: {
                my: "right center",
                at: "left center"
            }
        };
        var SlideAnimationConfigurator = {
            validateConfig: function(config) {
                isObjectConfigValidator(config, "slide")
            },
            setup: function($element, config) {
                var location = translator.locate($element);
                if ("slide" !== config.type) {
                    var positioningConfig = "slideIn" === config.type ? config.from : config.to;
                    positioningConfig.position = extend({
                        of: window
                    }, positionAliases[config.direction]);
                    setupPosition($element, positioningConfig)
                }
                this._setUpConfig(location, config.from);
                this._setUpConfig(location, config.to);
                translator.clearCache($element)
            },
            _setUpConfig: function(location, config) {
                config.left = "left" in config ? config.left : "+=0";
                config.top = "top" in config ? config.top : "+=0";
                this._initNewPosition(location, config)
            },
            _initNewPosition: function(location, config) {
                var position = {
                    left: config.left,
                    top: config.top
                };
                delete config.left;
                delete config.top;
                var relativeValue = this._getRelativeValue(position.left);
                if (void 0 !== relativeValue) {
                    position.left = relativeValue + location.left
                } else {
                    config.left = 0
                }
                relativeValue = this._getRelativeValue(position.top);
                if (void 0 !== relativeValue) {
                    position.top = relativeValue + location.top
                } else {
                    config.top = 0
                }
                config[TRANSFORM_PROP] = translator.getTranslateCss({
                    x: position.left,
                    y: position.top
                })
            },
            _getRelativeValue: function(value) {
                var relativeValue;
                if ("string" === typeof value && (relativeValue = RELATIVE_VALUE_REGEX.exec(value))) {
                    return parseInt(relativeValue[1] + "1") * relativeValue[2]
                }
            }
        };
        var FadeAnimationConfigurator = {
            setup: function($element, config) {
                var toOpacity, from = config.from,
                    fromOpacity = isPlainObject(from) ? config.skipElementInitialStyles ? 0 : $element.css("opacity") : String(from);
                switch (config.type) {
                    case "fadeIn":
                        toOpacity = 1;
                        break;
                    case "fadeOut":
                        toOpacity = 0;
                        break;
                    default:
                        toOpacity = String(config.to)
                }
                config.from = {
                    visibility: "visible",
                    opacity: fromOpacity
                };
                config.to = {
                    opacity: toOpacity
                }
            }
        };
        var PopAnimationConfigurator = {
            validateConfig: function(config) {
                isObjectConfigValidator(config, "pop")
            },
            setup: function($element, config) {
                var from = config.from,
                    to = config.to,
                    fromOpacity = "opacity" in from ? from.opacity : $element.css("opacity"),
                    toOpacity = "opacity" in to ? to.opacity : 1,
                    fromScale = "scale" in from ? from.scale : 0,
                    toScale = "scale" in to ? to.scale : 1;
                config.from = {
                    opacity: fromOpacity
                };
                var translate = translator.getTranslate($element);
                config.from[TRANSFORM_PROP] = this._getCssTransform(translate, fromScale);
                config.to = {
                    opacity: toOpacity
                };
                config.to[TRANSFORM_PROP] = this._getCssTransform(translate, toScale)
            },
            _getCssTransform: function(translate, scale) {
                return translator.getTranslateCss(translate) + "scale(" + scale + ")"
            }
        };
        var animationConfigurators = {
            custom: CustomAnimationConfigurator,
            slide: SlideAnimationConfigurator,
            slideIn: SlideAnimationConfigurator,
            slideOut: SlideAnimationConfigurator,
            fade: FadeAnimationConfigurator,
            fadeIn: FadeAnimationConfigurator,
            fadeOut: FadeAnimationConfigurator,
            pop: PopAnimationConfigurator,
            css: CssAnimationConfigurator
        };
        var getAnimationConfigurator = function(config) {
            var result = animationConfigurators[config.type];
            if (!result) {
                throw errors.Error("E0011", config.type)
            }
            return result
        };
        var defaultJSConfig = {
                type: "custom",
                from: {},
                to: {},
                duration: 400,
                start: noop,
                complete: noop,
                easing: "ease",
                delay: 0
            },
            defaultCssConfig = {
                duration: 400,
                easing: "ease",
                delay: 0
            };
        var setupAnimationOnElement = function() {
            var animation = this,
                $element = animation.element,
                config = animation.config;
            setupPosition($element, config.from);
            setupPosition($element, config.to);
            animation.configurator.setup($element, config);
            $element.data(ANIM_DATA_KEY, animation);
            if (fx.off) {
                config.duration = 0;
                config.delay = 0
            }
            animation.strategy.initAnimation($element, config);
            if (config.start) {
                var element = getPublicElement($element);
                config.start.apply(this, [element, config])
            }
        };
        var onElementAnimationComplete = function(animation) {
            var $element = animation.element,
                config = animation.config;
            $element.removeData(ANIM_DATA_KEY);
            if (config.complete) {
                var element = getPublicElement($element);
                config.complete.apply(this, [element, config])
            }
            animation.deferred.resolveWith(this, [$element, config])
        };
        var startAnimationOnElement = function() {
            var animation = this,
                $element = animation.element,
                config = animation.config;
            animation.isStarted = true;
            return animation.strategy.animate($element, config).done(function() {
                onElementAnimationComplete(animation)
            }).fail(function() {
                animation.deferred.rejectWith(this, [$element, config])
            })
        };
        var stopAnimationOnElement = function(jumpToEnd) {
            var animation = this,
                $element = animation.element,
                config = animation.config;
            clearTimeout(animation.startTimeout);
            if (!animation.isStarted) {
                animation.start()
            }
            animation.strategy.stop($element, config, jumpToEnd)
        };
        var scopedRemoveEvent = eventUtils.addNamespace(removeEvent, "dxFXStartAnimation");
        var subscribeToRemoveEvent = function(animation) {
            eventsEngine.off(animation.element, scopedRemoveEvent);
            eventsEngine.on(animation.element, scopedRemoveEvent, function() {
                fx.stop(animation.element)
            });
            animation.deferred.always(function() {
                eventsEngine.off(animation.element, scopedRemoveEvent)
            })
        };
        var createAnimation = function(element, initialConfig) {
            var defaultConfig = "css" === initialConfig.type ? defaultCssConfig : defaultJSConfig,
                config = extend(true, {}, defaultConfig, initialConfig),
                configurator = getAnimationConfigurator(config),
                strategy = getAnimationStrategy(config),
                animation = {
                    element: $(element),
                    config: config,
                    configurator: configurator,
                    strategy: strategy,
                    isSynchronous: strategy.isSynchronous,
                    setup: setupAnimationOnElement,
                    start: startAnimationOnElement,
                    stop: stopAnimationOnElement,
                    deferred: new Deferred
                };
            if (isFunction(configurator.validateConfig)) {
                configurator.validateConfig(config)
            }
            subscribeToRemoveEvent(animation);
            return animation
        };
        var animate = function(element, config) {
            var $element = $(element);
            if (!$element.length) {
                return (new Deferred).resolve().promise()
            }
            var animation = createAnimation($element, config);
            pushInAnimationQueue($element, animation);
            return animation.deferred.promise()
        };
        var pushInAnimationQueue = function($element, animation) {
            var queueData = getAnimQueueData($element);
            writeAnimQueueData($element, queueData);
            queueData.push(animation);
            if (!isAnimating($element)) {
                shiftFromAnimationQueue($element, queueData)
            }
        };
        var getAnimQueueData = function($element) {
            return $element.data(ANIM_QUEUE_KEY) || []
        };
        var writeAnimQueueData = function($element, queueData) {
            $element.data(ANIM_QUEUE_KEY, queueData)
        };
        var destroyAnimQueueData = function($element) {
            $element.removeData(ANIM_QUEUE_KEY)
        };
        var isAnimating = function($element) {
            return !!$element.data(ANIM_DATA_KEY)
        };
        var shiftFromAnimationQueue = function shiftFromAnimationQueue($element, queueData) {
            queueData = getAnimQueueData($element);
            if (!queueData.length) {
                return
            }
            var animation = queueData.shift();
            if (0 === queueData.length) {
                destroyAnimQueueData($element)
            }
            executeAnimation(animation).done(function() {
                if (!isAnimating($element)) {
                    shiftFromAnimationQueue($element)
                }
            })
        };
        var executeAnimation = function(animation) {
            animation.setup();
            if (fx.off || animation.isSynchronous) {
                animation.start()
            } else {
                animation.startTimeout = setTimeout(function() {
                    animation.start()
                })
            }
            return animation.deferred.promise()
        };
        var setupPosition = function($element, config) {
            if (!config || !config.position) {
                return
            }
            var win = $(window),
                left = 0,
                top = 0,
                position = positionUtils.calculate($element, config.position),
                offset = $element.offset(),
                currentPosition = $element.position();
            if (currentPosition.top > offset.top) {
                top = win.scrollTop()
            }
            if (currentPosition.left > offset.left) {
                left = win.scrollLeft()
            }
            extend(config, {
                left: position.h.location - offset.left + currentPosition.left - left,
                top: position.v.location - offset.top + currentPosition.top - top
            });
            delete config.position
        };
        var setProps = function($element, props) {
            iteratorUtils.each(props, function(key, value) {
                try {
                    $element.css(key, typeUtils.isFunction(value) ? value() : value)
                } catch (e) {}
            })
        };
        var stop = function(element, jumpToEnd) {
            var $element = $(element),
                queueData = getAnimQueueData($element);
            iteratorUtils.each(queueData, function(_, animation) {
                animation.config.delay = 0;
                animation.config.duration = 0;
                animation.isSynchronous = true
            });
            if (!isAnimating($element)) {
                shiftFromAnimationQueue($element, queueData)
            }
            var animation = $element.data(ANIM_DATA_KEY);
            if (animation) {
                animation.stop(jumpToEnd)
            }
            $element.removeData(ANIM_DATA_KEY);
            destroyAnimQueueData($element)
        };
        var fx = {
            off: false,
            animationTypes: animationConfigurators,
            animate: animate,
            createAnimation: createAnimation,
            isAnimating: isAnimating,
            stop: stop,
            _simulatedTransitionEndDelay: 100
        };
        module.exports = fx
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/element_data.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var WeakMap = __webpack_require__( /*! ./polyfills/weak_map */ 180);
        var domAdapter = __webpack_require__( /*! ./dom_adapter */ 13);
        var eventsEngine = __webpack_require__( /*! ../events/core/events_engine */ 5);
        var MemorizedCallbacks = __webpack_require__( /*! ./memorized_callbacks */ 181);
        var dataMap = new WeakMap;
        var strategy;
        var strategyChanging = new MemorizedCallbacks;
        var beforeCleanData = function() {};
        var afterCleanData = function() {};
        var setDataStrategy = exports.setDataStrategy = function(value) {
            strategyChanging.fire(value);
            strategy = value;
            var cleanData = strategy.cleanData;
            strategy.cleanData = function(nodes) {
                beforeCleanData(nodes);
                var result = cleanData.call(this, nodes);
                afterCleanData(nodes);
                return result
            }
        };
        setDataStrategy({
            data: function() {
                var element = arguments[0];
                var key = arguments[1];
                var value = arguments[2];
                if (!element) {
                    return
                }
                var elementData = dataMap.get(element);
                if (!elementData) {
                    elementData = {};
                    dataMap.set(element, elementData)
                }
                if (void 0 === key) {
                    return elementData
                }
                if (2 === arguments.length) {
                    return elementData[key]
                }
                elementData[key] = value;
                return value
            },
            removeData: function(element, key) {
                if (!element) {
                    return
                }
                if (void 0 === key) {
                    dataMap.delete(element)
                } else {
                    var elementData = dataMap.get(element);
                    if (elementData) {
                        delete elementData[key]
                    }
                }
            },
            cleanData: function(elements) {
                for (var i = 0; i < elements.length; i++) {
                    eventsEngine.off(elements[i]);
                    dataMap.delete(elements[i])
                }
            }
        });
        exports.setDataStrategy = setDataStrategy;
        exports.getDataStrategy = function() {
            return strategy
        };
        exports.data = function() {
            return strategy.data.apply(this, arguments)
        };
        exports.strategyChanging = strategyChanging;
        exports.beforeCleanData = function(callback) {
            beforeCleanData = callback
        };
        exports.afterCleanData = function(callback) {
            afterCleanData = callback
        };
        exports.cleanData = function(nodes) {
            return strategy.cleanData.call(this, nodes)
        };
        exports.removeData = function(element, key) {
            return strategy.removeData.call(this, element, key)
        };
        exports.cleanDataRecursive = function(element, cleanSelf) {
            if (!domAdapter.isElementNode(element)) {
                return
            }
            var childElements = element.getElementsByTagName("*");
            strategy.cleanData(childElements);
            if (cleanSelf) {
                strategy.cleanData([element])
            }
        }
    },
    /*!********************************************!*\
      !*** ./artifacts/transpiled/data/utils.js ***!
      \********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var _type2 = _interopRequireDefault(_type);
        var _dom_adapter = __webpack_require__( /*! ../core/dom_adapter */ 13);
        var _dom_adapter2 = _interopRequireDefault(_dom_adapter);
        var _ready_callbacks = __webpack_require__( /*! ../core/utils/ready_callbacks */ 48);
        var _window = __webpack_require__( /*! ../core/utils/window */ 7);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _data = __webpack_require__( /*! ../core/utils/data */ 20);
        var _deferred = __webpack_require__( /*! ../core/utils/deferred */ 6);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _toConsumableArray(arr) {
            if (Array.isArray(arr)) {
                for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
                    arr2[i] = arr[i]
                }
                return arr2
            } else {
                return Array.from(arr)
            }
        }
        var XHR_ERROR_UNLOAD = "DEVEXTREME_XHR_ERROR_UNLOAD";
        var normalizeBinaryCriterion = function(crit) {
            return [crit[0], crit.length < 3 ? "=" : String(crit[1]).toLowerCase(), crit.length < 2 ? true : crit[crit.length - 1]]
        };
        var normalizeSortingInfo = function(info) {
            if (!Array.isArray(info)) {
                info = [info]
            }
            return (0, _iterator.map)(info, function(i) {
                var result = {
                    selector: (0, _type.isFunction)(i) || "string" === typeof i ? i : i.getter || i.field || i.selector,
                    desc: !!(i.desc || "d" === String(i.dir).charAt(0).toLowerCase())
                };
                if (i.compare) {
                    result.compare = i.compare
                }
                return result
            })
        };
        var errorMessageFromXhr = function() {
            var textStatusMessages = {
                timeout: "Network connection timeout",
                error: "Unspecified network error",
                parsererror: "Unexpected server response"
            };
            var textStatusDetails = {
                timeout: "possible causes: the remote host is not accessible, overloaded or is not included into the domain white-list when being run in the native container",
                error: "if the remote host is located on another domain, make sure it properly supports cross-origin resource sharing (CORS), or use the JSONP approach instead",
                parsererror: "the remote host did not respond with valid JSON data"
            };
            var explainTextStatus = function(textStatus) {
                var result = textStatusMessages[textStatus];
                if (!result) {
                    return textStatus
                }
                result += " (" + textStatusDetails[textStatus] + ")";
                return result
            };
            var unloading;
            (0, _ready_callbacks.add)(function() {
                var window = (0, _window.getWindow)();
                _dom_adapter2.default.listen(window, "beforeunload", function() {
                    unloading = true
                })
            });
            return function(xhr, textStatus) {
                if (unloading) {
                    return XHR_ERROR_UNLOAD
                }
                if (xhr.status < 400) {
                    return explainTextStatus(textStatus)
                }
                return xhr.statusText
            }
        }();
        var aggregators = {
            count: {
                seed: 0,
                step: function(count) {
                    return 1 + count
                }
            },
            sum: {
                seed: 0,
                step: function(sum, item) {
                    return sum + item
                }
            },
            min: {
                step: function(min, item) {
                    return item < min ? item : min
                }
            },
            max: {
                step: function(max, item) {
                    return item > max ? item : max
                }
            },
            avg: {
                seed: [0, 0],
                step: function(pair, value) {
                    return [pair[0] + value, pair[1] + 1]
                },
                finalize: function(pair) {
                    return pair[1] ? pair[0] / pair[1] : NaN
                }
            }
        };
        var processRequestResultLock = function() {
            var lockDeferred, lockCount = 0;
            var obtain = function() {
                if (0 === lockCount) {
                    lockDeferred = new _deferred.Deferred
                }
                lockCount++
            };
            var release = function() {
                lockCount--;
                if (lockCount < 1) {
                    lockDeferred.resolve()
                }
            };
            var promise = function() {
                var deferred = 0 === lockCount ? (new _deferred.Deferred).resolve() : lockDeferred;
                return deferred.promise()
            };
            var reset = function() {
                lockCount = 0;
                if (lockDeferred) {
                    lockDeferred.resolve()
                }
            };
            return {
                obtain: obtain,
                release: release,
                promise: promise,
                reset: reset
            }
        }();

        function isDisjunctiveOperator(condition) {
            return /^(or|\|\||\|)$/i.test(condition)
        }

        function isConjunctiveOperator(condition) {
            return /^(and|&&|&)$/i.test(condition)
        }
        var keysEqual = function(keyExpr, key1, key2) {
            if (Array.isArray(keyExpr)) {
                var name, names = (0, _iterator.map)(key1, function(v, k) {
                    return k
                });
                for (var i = 0; i < names.length; i++) {
                    name = names[i];
                    if ((0, _data.toComparable)(key1[name], true) != (0, _data.toComparable)(key2[name], true)) {
                        return false
                    }
                }
                return true
            }
            return (0, _data.toComparable)(key1, true) == (0, _data.toComparable)(key2, true)
        };
        var BASE64_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
        var base64_encode = function(input) {
            if (!Array.isArray(input)) {
                input = stringToByteArray(String(input))
            }
            var result = "";

            function getBase64Char(index) {
                return BASE64_CHARS.charAt(index)
            }
            for (var i = 0; i < input.length; i += 3) {
                var octet1 = input[i],
                    octet2 = input[i + 1],
                    octet3 = input[i + 2];
                result += (0, _iterator.map)([octet1 >> 2, (3 & octet1) << 4 | octet2 >> 4, isNaN(octet2) ? 64 : (15 & octet2) << 2 | octet3 >> 6, isNaN(octet3) ? 64 : 63 & octet3], getBase64Char).join("")
            }
            return result
        };
        var stringToByteArray = function(str) {
            var code, i, bytes = [];
            for (i = 0; i < str.length; i++) {
                code = str.charCodeAt(i);
                if (code < 128) {
                    bytes.push(code)
                } else {
                    if (code < 2048) {
                        bytes.push(192 + (code >> 6), 128 + (63 & code))
                    } else {
                        if (code < 65536) {
                            bytes.push(224 + (code >> 12), 128 + (code >> 6 & 63), 128 + (63 & code))
                        } else {
                            if (code < 2097152) {
                                bytes.push(240 + (code >> 18), 128 + (code >> 12 & 63), 128 + (code >> 6 & 63), 128 + (63 & code))
                            }
                        }
                    }
                }
            }
            return bytes
        };
        var isUnaryOperation = function(crit) {
            return "!" === crit[0] && Array.isArray(crit[1])
        };
        var isGroupOperator = function(value) {
            return "and" === value || "or" === value
        };
        var isGroupCriterion = function(crit) {
            var first = crit[0],
                second = crit[1];
            if (Array.isArray(first)) {
                return true
            }
            if (_type2.default.isFunction(first)) {
                if (Array.isArray(second) || _type2.default.isFunction(second) || isGroupOperator(second)) {
                    return true
                }
            }
            return false
        };
        var trivialPromise = function() {
            var d = new _deferred.Deferred;
            return d.resolve.apply(d, arguments).promise()
        };
        var rejectedPromise = function() {
            var d = new _deferred.Deferred;
            return d.reject.apply(d, arguments).promise()
        };

        function throttle(func, timeout) {
            var timeoutId, lastArgs;
            return function() {
                var _this = this;
                lastArgs = arguments;
                if (!timeoutId) {
                    timeoutId = setTimeout(function() {
                        timeoutId = void 0;
                        if (lastArgs) {
                            func.call(_this, lastArgs)
                        }
                    }, (0, _type.isFunction)(timeout) ? timeout() : timeout)
                }
                return timeoutId
            }
        }

        function throttleChanges(func, timeout) {
            var cache = [],
                throttled = throttle(function() {
                    func.call(this, cache);
                    cache = []
                }, timeout);
            return function(changes) {
                if (Array.isArray(changes)) {
                    var _cache;
                    (_cache = cache).push.apply(_cache, _toConsumableArray(changes))
                }
                return throttled.call(this, cache)
            }
        }
        var utils = {
            XHR_ERROR_UNLOAD: XHR_ERROR_UNLOAD,
            normalizeBinaryCriterion: normalizeBinaryCriterion,
            normalizeSortingInfo: normalizeSortingInfo,
            errorMessageFromXhr: errorMessageFromXhr,
            aggregators: aggregators,
            keysEqual: keysEqual,
            throttleChanges: throttleChanges,
            trivialPromise: trivialPromise,
            rejectedPromise: rejectedPromise,
            isDisjunctiveOperator: isDisjunctiveOperator,
            isConjunctiveOperator: isConjunctiveOperator,
            processRequestResultLock: processRequestResultLock,
            isUnaryOperation: isUnaryOperation,
            isGroupCriterion: isGroupCriterion,
            base64_encode: base64_encode
        };
        module.exports = utils
    },
    /*!********************************************!*\
      !*** ./artifacts/transpiled/data/query.js ***!
      \********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var arrayQueryImpl = __webpack_require__( /*! ./array_query */ 156),
            remoteQueryImpl = __webpack_require__( /*! ./remote_query */ 482);
        var queryImpl = {
            array: arrayQueryImpl,
            remote: remoteQueryImpl
        };
        var query = function() {
            var impl = Array.isArray(arguments[0]) ? "array" : "remote";
            return queryImpl[impl].apply(this, arguments)
        };
        module.exports = query;
        module.exports.queryImpl = queryImpl
    },
    /*!******************************************!*\
      !*** ./artifacts/transpiled/ui/popup.js ***!
      \******************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            window = __webpack_require__( /*! ../core/utils/window */ 7).getWindow(),
            translator = __webpack_require__( /*! ../animation/translator */ 27),
            camelize = __webpack_require__( /*! ../core/utils/inflector */ 32).camelize,
            noop = __webpack_require__( /*! ../core/utils/common */ 4).noop,
            getPublicElement = __webpack_require__( /*! ../core/utils/dom */ 11).getPublicElement,
            each = __webpack_require__( /*! ../core/utils/iterator */ 3).each,
            isDefined = __webpack_require__( /*! ../core/utils/type */ 1).isDefined,
            inArray = __webpack_require__( /*! ../core/utils/array */ 14).inArray,
            extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            browser = __webpack_require__( /*! ../core/utils/browser */ 25),
            compareVersions = __webpack_require__( /*! ../core/utils/version */ 53).compare,
            messageLocalization = __webpack_require__( /*! ../localization/message */ 10),
            devices = __webpack_require__( /*! ../core/devices */ 16),
            registerComponent = __webpack_require__( /*! ../core/component_registrator */ 8),
            Button = __webpack_require__( /*! ./button */ 35),
            themes = __webpack_require__( /*! ./themes */ 31),
            Overlay = __webpack_require__( /*! ./overlay */ 59),
            EmptyTemplate = __webpack_require__( /*! ../core/templates/empty_template */ 96).EmptyTemplate,
            domUtils = __webpack_require__( /*! ../core/utils/dom */ 11),
            sizeUtils = __webpack_require__( /*! ../core/utils/size */ 176),
            windowUtils = __webpack_require__( /*! ../core/utils/window */ 7);
        __webpack_require__( /*! ./toolbar/ui.toolbar.base */ 297);
        var POPUP_CLASS = "dx-popup",
            POPUP_WRAPPER_CLASS = "dx-popup-wrapper",
            POPUP_FULL_SCREEN_CLASS = "dx-popup-fullscreen",
            POPUP_FULL_SCREEN_WIDTH_CLASS = "dx-popup-fullscreen-width",
            POPUP_NORMAL_CLASS = "dx-popup-normal",
            POPUP_CONTENT_CLASS = "dx-popup-content",
            POPUP_DRAGGABLE_CLASS = "dx-popup-draggable",
            POPUP_TITLE_CLASS = "dx-popup-title",
            POPUP_TITLE_CLOSEBUTTON_CLASS = "dx-closebutton",
            POPUP_BOTTOM_CLASS = "dx-popup-bottom",
            TEMPLATE_WRAPPER_CLASS = "dx-template-wrapper",
            POPUP_CONTENT_FLEX_HEIGHT_CLASS = "dx-popup-flex-height",
            POPUP_CONTENT_INHERIT_HEIGHT_CLASS = "dx-popup-inherit-height",
            ALLOWED_TOOLBAR_ITEM_ALIASES = ["cancel", "clear", "done"],
            BUTTON_DEFAULT_TYPE = "default",
            BUTTON_NORMAL_TYPE = "normal",
            BUTTON_TEXT_MODE = "text",
            BUTTON_CONTAINED_MODE = "contained";
        var IS_IE11 = browser.msie && 11 === parseInt(browser.version);
        var IS_OLD_SAFARI = browser.safari && compareVersions(browser.version, [11]) < 0;
        var HEIGHT_STRATEGIES = {
            "static": "",
            inherit: POPUP_CONTENT_INHERIT_HEIGHT_CLASS,
            flex: POPUP_CONTENT_FLEX_HEIGHT_CLASS
        };
        var getButtonPlace = function(name) {
            var device = devices.current(),
                platform = device.platform,
                toolbar = "bottom",
                location = "before";
            if ("ios" === platform) {
                switch (name) {
                    case "cancel":
                        toolbar = "top";
                        break;
                    case "clear":
                        toolbar = "top";
                        location = "after";
                        break;
                    case "done":
                        location = "after"
                }
            } else {
                if ("android" === platform && device.version && parseInt(device.version[0]) > 4) {
                    switch (name) {
                        case "cancel":
                            location = "after";
                            break;
                        case "done":
                            location = "after"
                    }
                } else {
                    if ("android" === platform) {
                        location = "center"
                    }
                }
            }
            return {
                toolbar: toolbar,
                location: location
            }
        };
        var Popup = Overlay.inherit({
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    fullScreen: false,
                    title: "",
                    showTitle: true,
                    titleTemplate: "title",
                    onTitleRendered: null,
                    dragEnabled: false,
                    toolbarItems: [],
                    showCloseButton: false,
                    bottomTemplate: "bottom",
                    useDefaultToolbarButtons: false,
                    useFlatToolbarButtons: false,
                    autoResizeEnabled: true
                })
            },
            _defaultOptionsRules: function() {
                var themeName = themes.current();
                return this.callBase().concat([{
                    device: {
                        platform: "ios"
                    },
                    options: {
                        animation: this._iosAnimation
                    }
                }, {
                    device: {
                        platform: "android"
                    },
                    options: {
                        animation: this._androidAnimation
                    }
                }, {
                    device: {
                        platform: "generic"
                    },
                    options: {
                        showCloseButton: true
                    }
                }, {
                    device: function(_device) {
                        return "desktop" === devices.real().deviceType && "generic" === _device.platform
                    },
                    options: {
                        dragEnabled: true
                    }
                }, {
                    device: function() {
                        return "desktop" === devices.real().deviceType && !devices.isSimulator()
                    },
                    options: {
                        focusStateEnabled: true
                    }
                }, {
                    device: function() {
                        return themes.isMaterial(themeName)
                    },
                    options: {
                        useDefaultToolbarButtons: true,
                        useFlatToolbarButtons: true
                    }
                }])
            },
            _iosAnimation: {
                show: {
                    type: "slide",
                    duration: 400,
                    from: {
                        position: {
                            my: "top",
                            at: "bottom"
                        }
                    },
                    to: {
                        position: {
                            my: "center",
                            at: "center"
                        }
                    }
                },
                hide: {
                    type: "slide",
                    duration: 400,
                    from: {
                        opacity: 1,
                        position: {
                            my: "center",
                            at: "center"
                        }
                    },
                    to: {
                        opacity: 1,
                        position: {
                            my: "top",
                            at: "bottom"
                        }
                    }
                }
            },
            _androidAnimation: function() {
                var fullScreenConfig = {
                        show: {
                            type: "slide",
                            duration: 300,
                            from: {
                                top: "30%",
                                opacity: 0
                            },
                            to: {
                                top: 0,
                                opacity: 1
                            }
                        },
                        hide: {
                            type: "slide",
                            duration: 300,
                            from: {
                                top: 0,
                                opacity: 1
                            },
                            to: {
                                top: "30%",
                                opacity: 0
                            }
                        }
                    },
                    defaultConfig = {
                        show: {
                            type: "fade",
                            duration: 400,
                            from: 0,
                            to: 1
                        },
                        hide: {
                            type: "fade",
                            duration: 400,
                            from: 1,
                            to: 0
                        }
                    };
                return this.option("fullScreen") ? fullScreenConfig : defaultConfig
            },
            _init: function() {
                this.callBase();
                this.$element().addClass(POPUP_CLASS);
                this._wrapper().addClass(POPUP_WRAPPER_CLASS);
                this._$popupContent = this._$content.wrapInner($("<div>").addClass(POPUP_CONTENT_CLASS)).children().eq(0)
            },
            _render: function() {
                var isFullscreen = this.option("fullScreen");
                this._toggleFullScreenClass(isFullscreen);
                this.callBase()
            },
            _toggleFullScreenClass: function(value) {
                this._$content.toggleClass(POPUP_FULL_SCREEN_CLASS, value).toggleClass(POPUP_NORMAL_CLASS, !value)
            },
            _initTemplates: function() {
                this.callBase();
                this._defaultTemplates.title = new EmptyTemplate;
                this._defaultTemplates.bottom = new EmptyTemplate
            },
            _renderContentImpl: function() {
                this._renderTitle();
                this.callBase();
                this._renderBottom()
            },
            _renderTitle: function() {
                var items = this._getToolbarItems("top"),
                    titleText = this.option("title"),
                    showTitle = this.option("showTitle");
                if (showTitle && !!titleText) {
                    items.unshift({
                        location: devices.current().ios ? "center" : "before",
                        text: titleText
                    })
                }
                if (showTitle || items.length > 0) {
                    this._$title && this._$title.remove();
                    var $title = $("<div>").addClass(POPUP_TITLE_CLASS).insertBefore(this.$content());
                    this._$title = this._renderTemplateByType("titleTemplate", items, $title).addClass(POPUP_TITLE_CLASS);
                    this._renderDrag();
                    this._executeTitleRenderAction(this._$title)
                } else {
                    if (this._$title) {
                        this._$title.detach()
                    }
                }
            },
            _renderTemplateByType: function(optionName, data, $container, additionalToolbarOptions) {
                var template = this._getTemplateByOption(optionName),
                    toolbarTemplate = template instanceof EmptyTemplate;
                if (toolbarTemplate) {
                    var toolbarOptions = extend(additionalToolbarOptions, {
                        items: data,
                        rtlEnabled: this.option("rtlEnabled"),
                        useDefaultButtons: this.option("useDefaultToolbarButtons"),
                        useFlatButtons: this.option("useFlatToolbarButtons")
                    });
                    this._getTemplate("dx-polymorph-widget").render({
                        container: $container,
                        model: {
                            widget: "dxToolbarBase",
                            options: toolbarOptions
                        }
                    });
                    var $toolbar = $container.children("div");
                    $container.replaceWith($toolbar);
                    return $toolbar
                } else {
                    var $result = $(template.render({
                        container: getPublicElement($container)
                    }));
                    if ($result.hasClass(TEMPLATE_WRAPPER_CLASS)) {
                        $container.replaceWith($result);
                        $container = $result
                    }
                    return $container
                }
            },
            _executeTitleRenderAction: function($titleElement) {
                this._getTitleRenderAction()({
                    titleElement: getPublicElement($titleElement)
                })
            },
            _getTitleRenderAction: function() {
                return this._titleRenderAction || this._createTitleRenderAction()
            },
            _createTitleRenderAction: function() {
                return this._titleRenderAction = this._createActionByOption("onTitleRendered", {
                    element: this.element(),
                    excludeValidators: ["disabled", "readOnly"]
                })
            },
            _getCloseButton: function() {
                return {
                    toolbar: "top",
                    location: "after",
                    template: this._getCloseButtonRenderer()
                }
            },
            _getCloseButtonRenderer: function() {
                return function(_, __, container) {
                    var $button = $("<div>").addClass(POPUP_TITLE_CLOSEBUTTON_CLASS);
                    this._createComponent($button, Button, {
                        icon: "close",
                        onClick: this._createToolbarItemAction(void 0),
                        integrationOptions: {}
                    });
                    $(container).append($button)
                }.bind(this)
            },
            _getToolbarItems: function(toolbar) {
                var toolbarItems = this.option("toolbarItems");
                var toolbarsItems = [];
                this._toolbarItemClasses = [];
                var currentPlatform = devices.current().platform,
                    index = 0;
                each(toolbarItems, function(_, data) {
                    var isShortcut = isDefined(data.shortcut),
                        item = isShortcut ? getButtonPlace(data.shortcut) : data;
                    if (isShortcut && "ios" === currentPlatform && index < 2) {
                        item.toolbar = "top";
                        index++
                    }
                    item.toolbar = data.toolbar || item.toolbar || "top";
                    if (item && item.toolbar === toolbar) {
                        if (isShortcut) {
                            extend(item, {
                                location: data.location
                            }, this._getToolbarItemByAlias(data))
                        }
                        var isLTROrder = "generic" === currentPlatform;
                        if ("done" === data.shortcut && isLTROrder || "cancel" === data.shortcut && !isLTROrder) {
                            toolbarsItems.unshift(item)
                        } else {
                            toolbarsItems.push(item)
                        }
                    }
                }.bind(this));
                if ("top" === toolbar && this.option("showCloseButton") && this.option("showTitle")) {
                    toolbarsItems.push(this._getCloseButton())
                }
                return toolbarsItems
            },
            _getLocalizationKey: function(itemType) {
                return "done" === itemType.toLowerCase() ? "OK" : camelize(itemType, true)
            },
            _getToolbarItemByAlias: function(data) {
                var that = this,
                    itemType = data.shortcut;
                if (inArray(itemType, ALLOWED_TOOLBAR_ITEM_ALIASES) < 0) {
                    return false
                }
                var itemConfig = extend({
                    text: messageLocalization.format(this._getLocalizationKey(itemType)),
                    onClick: this._createToolbarItemAction(data.onClick),
                    integrationOptions: {},
                    type: that.option("useDefaultToolbarButtons") ? BUTTON_DEFAULT_TYPE : BUTTON_NORMAL_TYPE,
                    stylingMode: that.option("useFlatToolbarButtons") ? BUTTON_TEXT_MODE : BUTTON_CONTAINED_MODE
                }, data.options || {});
                var itemClass = POPUP_CLASS + "-" + itemType;
                this._toolbarItemClasses.push(itemClass);
                return {
                    template: function(_, __, container) {
                        var $toolbarItem = $("<div>").addClass(itemClass).appendTo(container);
                        that._createComponent($toolbarItem, Button, itemConfig)
                    }
                }
            },
            _createToolbarItemAction: function(clickAction) {
                return this._createAction(clickAction, {
                    afterExecute: function(e) {
                        e.component.hide()
                    }
                })
            },
            _renderBottom: function() {
                var items = this._getToolbarItems("bottom");
                if (items.length) {
                    this._$bottom && this._$bottom.remove();
                    var $bottom = $("<div>").addClass(POPUP_BOTTOM_CLASS).insertAfter(this.$content());
                    this._$bottom = this._renderTemplateByType("bottomTemplate", items, $bottom, {
                        compactMode: true
                    }).addClass(POPUP_BOTTOM_CLASS);
                    this._toggleClasses()
                } else {
                    this._$bottom && this._$bottom.detach()
                }
            },
            _toggleClasses: function() {
                var aliases = ALLOWED_TOOLBAR_ITEM_ALIASES;
                each(aliases, function(_, alias) {
                    var className = POPUP_CLASS + "-" + alias;
                    if (inArray(className, this._toolbarItemClasses) >= 0) {
                        this._wrapper().addClass(className + "-visible");
                        this._$bottom.addClass(className)
                    } else {
                        this._wrapper().removeClass(className + "-visible");
                        this._$bottom.removeClass(className)
                    }
                }.bind(this))
            },
            _getDragTarget: function() {
                return this.topToolbar()
            },
            _renderGeometryImpl: function(isDimensionChanged) {
                if (!isDimensionChanged) {
                    this._resetContentHeight()
                }
                this.callBase.apply(this, arguments);
                this._setContentHeight()
            },
            _resetContentHeight: function() {
                this._$popupContent.css({
                    height: "auto"
                })
            },
            _renderDrag: function() {
                this.callBase();
                this._$content.toggleClass(POPUP_DRAGGABLE_CLASS, this.option("dragEnabled"))
            },
            _renderResize: function() {
                this.callBase();
                this._resizable.option("onResize", function() {
                    this._setContentHeight();
                    this._actions.onResize(arguments)
                }.bind(this))
            },
            _setContentHeight: function() {
                (this.option("forceApplyBindings") || noop)();
                var overlayContent = this.overlayContent().get(0),
                    currentHeightStrategyClass = this._chooseHeightStrategy(overlayContent);
                this.$content().css(this._getHeightCssStyles(currentHeightStrategyClass, overlayContent));
                this._setHeightClasses(this.overlayContent(), currentHeightStrategyClass)
            },
            _heightStrategyChangeOffset: function(currentHeightStrategyClass, popupVerticalPaddings) {
                return currentHeightStrategyClass === HEIGHT_STRATEGIES.flex ? -popupVerticalPaddings : 0
            },
            _chooseHeightStrategy: function(overlayContent) {
                var isAutoWidth = "auto" === overlayContent.style.width || "" === overlayContent.style.width,
                    currentHeightStrategyClass = HEIGHT_STRATEGIES.static;
                if (this._isAutoHeight() && this.option("autoResizeEnabled")) {
                    if (isAutoWidth || IS_OLD_SAFARI) {
                        if (!IS_IE11) {
                            currentHeightStrategyClass = HEIGHT_STRATEGIES.inherit
                        }
                    } else {
                        currentHeightStrategyClass = HEIGHT_STRATEGIES.flex
                    }
                }
                return currentHeightStrategyClass
            },
            _getHeightCssStyles: function(currentHeightStrategyClass, overlayContent) {
                var cssStyles = {},
                    contentMaxHeight = this._getOptionValue("maxHeight", overlayContent),
                    contentMinHeight = this._getOptionValue("minHeight", overlayContent),
                    popupHeightParts = this._splitPopupHeight(),
                    toolbarsAndVerticalOffsetsHeight = popupHeightParts.header + popupHeightParts.footer + popupHeightParts.contentVerticalOffsets + popupHeightParts.popupVerticalOffsets + this._heightStrategyChangeOffset(currentHeightStrategyClass, popupHeightParts.popupVerticalPaddings);
                if (currentHeightStrategyClass === HEIGHT_STRATEGIES.static) {
                    if (!this._isAutoHeight() || contentMaxHeight || contentMinHeight) {
                        var contentHeight = overlayContent.getBoundingClientRect().height - toolbarsAndVerticalOffsetsHeight;
                        cssStyles = {
                            height: Math.max(0, contentHeight),
                            minHeight: "auto",
                            maxHeight: "auto"
                        }
                    }
                } else {
                    var container = $(this._getContainer()).get(0),
                        maxHeightValue = sizeUtils.addOffsetToMaxHeight(contentMaxHeight, -toolbarsAndVerticalOffsetsHeight, container),
                        minHeightValue = sizeUtils.addOffsetToMinHeight(contentMinHeight, -toolbarsAndVerticalOffsetsHeight, container);
                    cssStyles = {
                        height: "auto",
                        minHeight: minHeightValue,
                        maxHeight: maxHeightValue
                    }
                }
                return cssStyles
            },
            _setHeightClasses: function($container, currentClass) {
                var excessClasses = "";
                for (var name in HEIGHT_STRATEGIES) {
                    if (HEIGHT_STRATEGIES[name] !== currentClass) {
                        excessClasses += " " + HEIGHT_STRATEGIES[name]
                    }
                }
                $container.removeClass(excessClasses).addClass(currentClass)
            },
            _isAutoHeight: function() {
                return "auto" === this.overlayContent().get(0).style.height
            },
            _splitPopupHeight: function() {
                var topToolbar = this.topToolbar(),
                    bottomToolbar = this.bottomToolbar();
                return {
                    header: sizeUtils.getVisibleHeight(topToolbar && topToolbar.get(0)),
                    footer: sizeUtils.getVisibleHeight(bottomToolbar && bottomToolbar.get(0)),
                    contentVerticalOffsets: sizeUtils.getVerticalOffsets(this.overlayContent().get(0), true),
                    popupVerticalOffsets: sizeUtils.getVerticalOffsets(this.$content().get(0), true),
                    popupVerticalPaddings: sizeUtils.getVerticalOffsets(this.$content().get(0), false)
                }
            },
            _useFixedPosition: function() {
                return this.callBase() || this.option("fullScreen")
            },
            _renderDimensions: function() {
                if (this.option("fullScreen")) {
                    this._$content.css({
                        width: "100%",
                        height: "100%"
                    })
                } else {
                    this.callBase.apply(this, arguments)
                }
                if (windowUtils.hasWindow()) {
                    this._renderFullscreenWidthClass()
                }
            },
            _renderFullscreenWidthClass: function() {
                this.overlayContent().toggleClass(POPUP_FULL_SCREEN_WIDTH_CLASS, this.overlayContent().outerWidth() === $(window).width())
            },
            refreshPosition: function() {
                this._renderPosition()
            },
            _renderPosition: function() {
                if (this.option("fullScreen")) {
                    translator.move(this._$content, {
                        top: 0,
                        left: 0
                    })
                } else {
                    (this.option("forceApplyBindings") || noop)();
                    return this.callBase.apply(this, arguments)
                }
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "showTitle":
                    case "title":
                    case "titleTemplate":
                        this._renderTitle();
                        this._renderGeometry();
                        break;
                    case "bottomTemplate":
                        this._renderBottom();
                        this._renderGeometry();
                        break;
                    case "onTitleRendered":
                        this._createTitleRenderAction(args.value);
                        break;
                    case "toolbarItems":
                    case "useDefaultToolbarButtons":
                    case "useFlatToolbarButtons":
                        var shouldRenderGeometry = !args.fullName.match(/^toolbarItems((\[\d+\])(\.(options|visible).*)?)?$/);
                        this._renderTitle();
                        this._renderBottom();
                        if (shouldRenderGeometry) {
                            this._renderGeometry()
                        }
                        break;
                    case "dragEnabled":
                        this._renderDrag();
                        break;
                    case "autoResizeEnabled":
                        this._renderGeometry();
                        domUtils.triggerResizeEvent(this._$content);
                        break;
                    case "fullScreen":
                        this._toggleFullScreenClass(args.value);
                        this._toggleSafariScrolling(!args.value);
                        this._renderGeometry();
                        domUtils.triggerResizeEvent(this._$content);
                        break;
                    case "showCloseButton":
                        this._renderTitle();
                        break;
                    default:
                        this.callBase(args)
                }
            },
            bottomToolbar: function() {
                return this._$bottom
            },
            topToolbar: function() {
                return this._$title
            },
            $content: function() {
                return this._$popupContent
            },
            content: function() {
                return getPublicElement(this._$popupContent)
            },
            overlayContent: function() {
                return this._$content
            }
        });
        registerComponent("dxPopup", Popup);
        module.exports = Popup
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled/core/utils/support.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _array = __webpack_require__( /*! ./array */ 14);
        var _dom_adapter = __webpack_require__( /*! ../dom_adapter */ 13);
        var _common = __webpack_require__( /*! ./common */ 4);
        var _call_once = __webpack_require__( /*! ./call_once */ 61);
        var _call_once2 = _interopRequireDefault(_call_once);
        var _window = __webpack_require__( /*! ./window */ 7);
        var _window2 = _interopRequireDefault(_window);
        var _devices = __webpack_require__( /*! ../devices */ 16);
        var _devices2 = _interopRequireDefault(_devices);
        var _style = __webpack_require__( /*! ./style */ 86);
        var _style2 = _interopRequireDefault(_style);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var _windowUtils$getNavig = _window2.default.getNavigator(),
            maxTouchPoints = _windowUtils$getNavig.maxTouchPoints,
            msMaxTouchPoints = _windowUtils$getNavig.msMaxTouchPoints,
            pointerEnabled = _windowUtils$getNavig.pointerEnabled;
        var hasProperty = _window2.default.hasProperty.bind(_window2.default);
        var transitionEndEventNames = {
            webkitTransition: "webkitTransitionEnd",
            MozTransition: "transitionend",
            OTransition: "oTransitionEnd",
            msTransition: "MsTransitionEnd",
            transition: "transitionend"
        };
        var supportProp = function(prop) {
            return !!_style2.default.styleProp(prop)
        };
        var isNativeScrollingSupported = function() {
            var _devices$real = _devices2.default.real(),
                platform = _devices$real.platform,
                version = _devices$real.version,
                isMac = _devices$real.mac;
            var isObsoleteAndroid = version && version[0] < 4 && "android" === platform;
            var isNativeScrollDevice = !isObsoleteAndroid && (0, _array.inArray)(platform, ["ios", "android"]) > -1 || isMac;
            return isNativeScrollDevice
        };
        var inputType = function(type) {
            if ("text" === type) {
                return true
            }
            var input = (0, _dom_adapter.createElement)("input");
            try {
                input.setAttribute("type", type);
                input.value = "wrongValue";
                return !input.value
            } catch (e) {
                return false
            }
        };
        var detectTouchEvents = function(hasWindowProperty, maxTouchPoints) {
            return (hasWindowProperty("ontouchstart") || !!maxTouchPoints) && !hasWindowProperty("callPhantom")
        };
        var detectPointerEvent = function(hasWindowProperty, pointerEnabled) {
            var isPointerEnabled = (0, _common.ensureDefined)(pointerEnabled, true);
            var canUsePointerEvent = (0, _common.ensureDefined)(pointerEnabled, false);
            return hasWindowProperty("PointerEvent") && isPointerEnabled || canUsePointerEvent
        };
        var touchEvents = detectTouchEvents(hasProperty, maxTouchPoints);
        var pointerEvents = detectPointerEvent(hasProperty, pointerEnabled);
        var touchPointersPresent = !!maxTouchPoints || !!msMaxTouchPoints;
        exports.detectTouchEvents = detectTouchEvents;
        exports.detectPointerEvent = detectPointerEvent;
        exports.touchEvents = touchEvents;
        exports.pointerEvents = pointerEvents;
        exports.touch = touchEvents || pointerEvents && touchPointersPresent;
        exports.transition = (0, _call_once2.default)(function() {
            return supportProp("transition")
        });
        exports.transitionEndEventName = (0, _call_once2.default)(function() {
            return transitionEndEventNames[_style2.default.styleProp("transition")]
        });
        exports.animation = (0, _call_once2.default)(function() {
            return supportProp("animation")
        });
        exports.nativeScrolling = isNativeScrollingSupported();
        exports.styleProp = _style2.default.styleProp;
        exports.stylePropPrefix = _style2.default.stylePropPrefix;
        exports.supportProp = supportProp;
        exports.inputType = inputType
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/utils/string.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var typeUtils = __webpack_require__( /*! ./type */ 1);
        var encodeHtml = function() {
            var encodeRegExp = [new RegExp("&", "g"), new RegExp('"', "g"), new RegExp("'", "g"), new RegExp("<", "g"), new RegExp(">", "g")];
            return function(str) {
                return String(str).replace(encodeRegExp[0], "&amp;").replace(encodeRegExp[1], "&quot;").replace(encodeRegExp[2], "&#39;").replace(encodeRegExp[3], "&lt;").replace(encodeRegExp[4], "&gt;")
            }
        }();
        var splitQuad = function(raw) {
            switch ("undefined" === typeof raw ? "undefined" : _typeof(raw)) {
                case "string":
                    return raw.split(/\s+/, 4);
                case "object":
                    return [raw.x || raw.h || raw.left, raw.y || raw.v || raw.top, raw.x || raw.h || raw.right, raw.y || raw.v || raw.bottom];
                case "number":
                    return [raw];
                default:
                    return raw
            }
        };
        var quadToObject = function(raw) {
            var quad = splitQuad(raw),
                left = parseInt(quad && quad[0], 10),
                top = parseInt(quad && quad[1], 10),
                right = parseInt(quad && quad[2], 10),
                bottom = parseInt(quad && quad[3], 10);
            if (!isFinite(left)) {
                left = 0
            }
            if (!isFinite(top)) {
                top = left
            }
            if (!isFinite(right)) {
                right = left
            }
            if (!isFinite(bottom)) {
                bottom = top
            }
            return {
                top: top,
                right: right,
                bottom: bottom,
                left: left
            }
        };
        var stringFormat = function() {
            var replaceDollarCount, reg, value, s = arguments[0],
                values = [].slice.call(arguments).slice(1);
            if (typeUtils.isFunction(s)) {
                return s.apply(this, values)
            }
            for (var i = 0; i < values.length; i++) {
                reg = new RegExp("\\{" + i + "\\}", "gm");
                value = values[i];
                if ("string" === typeUtils.type(value) && value.indexOf("$") >= 0) {
                    replaceDollarCount = "$".replace("$", "$$").length;
                    value = value.replace("$", 1 === replaceDollarCount ? "$$$$" : "$$")
                }
                s = s.replace(reg, value)
            }
            return s
        };
        var replaceAll = function() {
            var quote = function(str) {
                return (str + "").replace(/([+*?.[^\]$(){}><|=!:])/g, "\\$1")
            };
            return function(text, searchToken, replacementToken) {
                return text.replace(new RegExp("(" + quote(searchToken) + ")", "gi"), replacementToken)
            }
        }();
        var isEmpty = function() {
            var SPACE_REGEXP = /\s/g;
            return function(text) {
                return !text || !text.replace(SPACE_REGEXP, "")
            }
        }();
        exports.encodeHtml = encodeHtml;
        exports.quadToObject = quadToObject;
        exports.format = stringFormat;
        exports.replaceAll = replaceAll;
        exports.isEmpty = isEmpty
    },
    /*!**************************************************************!*\
      !*** ./artifacts/transpiled/data/data_source/data_source.js ***!
      \**************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Class = __webpack_require__( /*! ../../core/class */ 15),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            commonUtils = __webpack_require__( /*! ../../core/utils/common */ 4),
            iteratorUtils = __webpack_require__( /*! ../../core/utils/iterator */ 3),
            ajax = __webpack_require__( /*! ../../core/utils/ajax */ 62),
            typeUtils = __webpack_require__( /*! ../../core/utils/type */ 1),
            dataUtils = __webpack_require__( /*! ../utils */ 41),
            arrayUtils = __webpack_require__( /*! ../array_utils */ 138),
            Store = __webpack_require__( /*! ../abstract_store */ 100),
            ArrayStore = __webpack_require__( /*! ../array_store */ 68),
            CustomStore = __webpack_require__( /*! ../custom_store */ 151),
            EventsMixin = __webpack_require__( /*! ../../core/events_mixin */ 85),
            errors = __webpack_require__( /*! ../errors */ 37).errors,
            array = __webpack_require__( /*! ../../core/utils/array */ 14),
            queue = __webpack_require__( /*! ../../core/utils/queue */ 271),
            deferredUtils = __webpack_require__( /*! ../../core/utils/deferred */ 6),
            when = deferredUtils.when,
            Deferred = deferredUtils.Deferred,
            __isString = typeUtils.isString,
            __isNumber = typeUtils.isNumeric,
            __isBoolean = typeUtils.isBoolean,
            __isDefined = typeUtils.isDefined;
        var CANCELED_TOKEN = "canceled";

        function OperationManager() {
            this._counter = -1;
            this._deferreds = {}
        }
        OperationManager.prototype.constructor = OperationManager;
        OperationManager.prototype.add = function(deferred) {
            this._counter += 1;
            this._deferreds[this._counter] = deferred;
            return this._counter
        };
        OperationManager.prototype.remove = function(operationId) {
            return delete this._deferreds[operationId]
        };
        OperationManager.prototype.cancel = function(operationId) {
            if (operationId in this._deferreds) {
                this._deferreds[operationId].reject(CANCELED_TOKEN);
                return true
            }
            return false
        };
        OperationManager.prototype.cancelAll = function() {
            while (this._counter > -1) {
                this.cancel(this._counter);
                this._counter--
            }
        };

        function isPending(deferred) {
            return "pending" === deferred.state()
        }

        function normalizeDataSourceOptions(options, normalizationOptions) {
            var store;

            function createCustomStoreFromLoadFunc() {
                var storeConfig = {};
                iteratorUtils.each(["useDefaultSearch", "key", "load", "loadMode", "cacheRawData", "byKey", "lookup", "totalCount", "insert", "update", "remove"], function() {
                    storeConfig[this] = options[this];
                    delete options[this]
                });
                return new CustomStore(storeConfig)
            }

            function createStoreFromConfig(storeConfig) {
                var alias = storeConfig.type;
                delete storeConfig.type;
                return Store.create(alias, storeConfig)
            }

            function createCustomStoreFromUrl(url) {
                return new CustomStore({
                    load: function() {
                        return ajax.sendRequest({
                            url: url,
                            dataType: "json"
                        })
                    },
                    loadMode: normalizationOptions && normalizationOptions.fromUrlLoadMode
                })
            }
            if ("string" === typeof options) {
                options = {
                    paginate: false,
                    store: createCustomStoreFromUrl(options)
                }
            }
            if (void 0 === options) {
                options = []
            }
            if (Array.isArray(options) || options instanceof Store) {
                options = {
                    store: options
                }
            } else {
                options = extend({}, options)
            }
            if (void 0 === options.store) {
                options.store = []
            }
            store = options.store;
            if ("load" in options) {
                store = createCustomStoreFromLoadFunc()
            } else {
                if (Array.isArray(store)) {
                    store = new ArrayStore(store)
                } else {
                    if (typeUtils.isPlainObject(store)) {
                        store = createStoreFromConfig(extend({}, store))
                    }
                }
            }
            options.store = store;
            return options
        }

        function normalizeStoreLoadOptionAccessorArguments(originalArguments) {
            switch (originalArguments.length) {
                case 0:
                    return;
                case 1:
                    return originalArguments[0]
            }
            return [].slice.call(originalArguments)
        }

        function generateStoreLoadOptionAccessor(optionName) {
            return function() {
                var args = normalizeStoreLoadOptionAccessorArguments(arguments);
                if (void 0 === args) {
                    return this._storeLoadOptions[optionName]
                }
                this._storeLoadOptions[optionName] = args
            }
        }

        function mapDataRespectingGrouping(items, mapper, groupInfo) {
            function mapRecursive(items, level) {
                if (!Array.isArray(items)) {
                    return items
                }
                return level ? mapGroup(items, level) : iteratorUtils.map(items, mapper)
            }

            function mapGroup(group, level) {
                return iteratorUtils.map(group, function(item) {
                    var result = {
                        key: item.key,
                        items: mapRecursive(item.items, level - 1)
                    };
                    if ("aggregates" in item) {
                        result.aggregates = item.aggregates
                    }
                    return result
                })
            }
            return mapRecursive(items, groupInfo ? dataUtils.normalizeSortingInfo(groupInfo).length : 0)
        }

        function normalizeLoadResult(data, extra) {
            if (data && !Array.isArray(data) && data.data) {
                extra = data;
                data = data.data
            }
            if (!Array.isArray(data)) {
                data = [data]
            }
            return {
                data: data,
                extra: extra
            }
        }
        var DataSource = Class.inherit({
            ctor: function(options) {
                var _this = this;
                var that = this;
                options = normalizeDataSourceOptions(options);
                var onPushHandler = 0 !== options.pushAggregationTimeout ? dataUtils.throttleChanges(this._onPush, function() {
                    if (void 0 === options.pushAggregationTimeout) {
                        return 5 * that._changedTime
                    }
                    return options.pushAggregationTimeout
                }) : this._onPush;
                this._changedTime = 0;
                this._onPushHandler = function(changes) {
                    _this._aggregationTimeoutId = onPushHandler.call(_this, changes)
                };
                this._store = options.store;
                this._store.on("push", this._onPushHandler);
                this._storeLoadOptions = this._extractLoadOptions(options);
                this._mapFunc = options.map;
                this._postProcessFunc = options.postProcess;
                this._pageIndex = void 0 !== options.pageIndex ? options.pageIndex : 0;
                this._pageSize = void 0 !== options.pageSize ? options.pageSize : 20;
                this._loadingCount = 0;
                this._loadQueue = this._createLoadQueue();
                this._searchValue = "searchValue" in options ? options.searchValue : null;
                this._searchOperation = options.searchOperation || "contains";
                this._searchExpr = options.searchExpr;
                this._paginate = options.paginate;
                this._reshapeOnPush = __isDefined(options.reshapeOnPush) ? options.reshapeOnPush : false;
                iteratorUtils.each(["onChanged", "onLoadError", "onLoadingChanged", "onCustomizeLoadResult", "onCustomizeStoreLoadOptions"], function(_, optionName) {
                    if (optionName in options) {
                        that.on(optionName.substr(2, 1).toLowerCase() + optionName.substr(3), options[optionName])
                    }
                });
                this._operationManager = new OperationManager;
                this._init()
            },
            _init: function() {
                this._items = [];
                this._userData = {};
                this._totalCount = -1;
                this._isLoaded = false;
                if (!__isDefined(this._paginate)) {
                    this._paginate = !this.group()
                }
                this._isLastPage = !this._paginate
            },
            dispose: function() {
                this._store.off("push", this._onPushHandler);
                this._disposeEvents();
                clearTimeout(this._aggregationTimeoutId);
                delete this._store;
                if (this._delayedLoadTask) {
                    this._delayedLoadTask.abort()
                }
                this._operationManager.cancelAll();
                this._disposed = true
            },
            _extractLoadOptions: function(options) {
                var result = {},
                    names = ["sort", "filter", "select", "group", "requireTotalCount"],
                    customNames = this._store._customLoadOptions();
                if (customNames) {
                    names = names.concat(customNames)
                }
                iteratorUtils.each(names, function() {
                    result[this] = options[this]
                });
                return result
            },
            loadOptions: function() {
                return this._storeLoadOptions
            },
            items: function() {
                return this._items
            },
            pageIndex: function(newIndex) {
                if (!__isNumber(newIndex)) {
                    return this._pageIndex
                }
                this._pageIndex = newIndex;
                this._isLastPage = !this._paginate
            },
            paginate: function(value) {
                if (!__isBoolean(value)) {
                    return this._paginate
                }
                if (this._paginate !== value) {
                    this._paginate = value;
                    this.pageIndex(0)
                }
            },
            pageSize: function(value) {
                if (!__isNumber(value)) {
                    return this._pageSize
                }
                this._pageSize = value
            },
            isLastPage: function() {
                return this._isLastPage
            },
            sort: generateStoreLoadOptionAccessor("sort"),
            filter: function() {
                var newFilter = normalizeStoreLoadOptionAccessorArguments(arguments);
                if (void 0 === newFilter) {
                    return this._storeLoadOptions.filter
                }
                this._storeLoadOptions.filter = newFilter;
                this.pageIndex(0)
            },
            group: generateStoreLoadOptionAccessor("group"),
            select: generateStoreLoadOptionAccessor("select"),
            requireTotalCount: function(value) {
                if (!__isBoolean(value)) {
                    return this._storeLoadOptions.requireTotalCount
                }
                this._storeLoadOptions.requireTotalCount = value
            },
            searchValue: function(value) {
                if (arguments.length < 1) {
                    return this._searchValue
                }
                this._searchValue = value;
                this.pageIndex(0)
            },
            searchOperation: function(op) {
                if (!__isString(op)) {
                    return this._searchOperation
                }
                this._searchOperation = op;
                this.pageIndex(0)
            },
            searchExpr: function(expr) {
                var argc = arguments.length;
                if (0 === argc) {
                    return this._searchExpr
                }
                if (argc > 1) {
                    expr = [].slice.call(arguments)
                }
                this._searchExpr = expr;
                this.pageIndex(0)
            },
            store: function() {
                return this._store
            },
            key: function() {
                return this._store && this._store.key()
            },
            totalCount: function() {
                return this._totalCount
            },
            isLoaded: function() {
                return this._isLoaded
            },
            isLoading: function() {
                return this._loadingCount > 0
            },
            beginLoading: function() {
                this._changeLoadingCount(1)
            },
            endLoading: function() {
                this._changeLoadingCount(-1)
            },
            _createLoadQueue: function() {
                return queue.create()
            },
            _changeLoadingCount: function(increment) {
                var newLoading, oldLoading = this.isLoading();
                this._loadingCount += increment;
                newLoading = this.isLoading();
                if (oldLoading ^ newLoading) {
                    this.fireEvent("loadingChanged", [newLoading])
                }
            },
            _scheduleLoadCallbacks: function(deferred) {
                var that = this;
                that.beginLoading();
                deferred.always(function() {
                    that.endLoading()
                })
            },
            _scheduleFailCallbacks: function(deferred) {
                var that = this;
                deferred.fail(function() {
                    if (arguments[0] === CANCELED_TOKEN) {
                        return
                    }
                    that.fireEvent("loadError", arguments)
                })
            },
            _fireChanged: function(args) {
                var date = new Date;
                this.fireEvent("changed", args);
                this._changedTime = new Date - date
            },
            _scheduleChangedCallbacks: function(deferred) {
                var _this2 = this;
                deferred.done(function() {
                    _this2._fireChanged()
                })
            },
            loadSingle: function(propName, propValue) {
                var that = this;
                var d = new Deferred,
                    key = this.key(),
                    store = this._store,
                    options = this._createStoreLoadOptions(),
                    handleDone = function(data) {
                        if (!__isDefined(data) || array.isEmpty(data)) {
                            d.reject(new errors.Error("E4009"))
                        } else {
                            if (!Array.isArray(data)) {
                                data = [data]
                            }
                            d.resolve(that._applyMapFunction(data)[0])
                        }
                    };
                this._scheduleFailCallbacks(d);
                if (arguments.length < 2) {
                    propValue = propName;
                    propName = key
                }
                delete options.skip;
                delete options.group;
                delete options.refresh;
                delete options.pageIndex;
                delete options.searchString;

                function shouldForceByKey() {
                    return store instanceof CustomStore && !store._byKeyViaLoad()
                }(function() {
                    if (propName === key || shouldForceByKey()) {
                        return store.byKey(propValue, options)
                    }
                    options.take = 1;
                    options.filter = options.filter ? [options.filter, [propName, propValue]] : [propName, propValue];
                    return store.load(options)
                })().fail(d.reject).done(handleDone);
                return d.promise()
            },
            load: function() {
                var loadOperation, that = this,
                    d = new Deferred;

                function loadTask() {
                    if (that._disposed) {
                        return
                    }
                    if (!isPending(d)) {
                        return
                    }
                    return that._loadFromStore(loadOperation, d)
                }
                this._scheduleLoadCallbacks(d);
                this._scheduleFailCallbacks(d);
                this._scheduleChangedCallbacks(d);
                loadOperation = this._createLoadOperation(d);
                this.fireEvent("customizeStoreLoadOptions", [loadOperation]);
                this._loadQueue.add(function() {
                    if ("number" === typeof loadOperation.delay) {
                        that._delayedLoadTask = commonUtils.executeAsync(loadTask, loadOperation.delay)
                    } else {
                        loadTask()
                    }
                    return d.promise()
                });
                return d.promise({
                    operationId: loadOperation.operationId
                })
            },
            _onPush: function(changes) {
                var _this3 = this;
                if (this._reshapeOnPush) {
                    this.load()
                } else {
                    this.fireEvent("changing", [{
                        changes: changes
                    }]);
                    var group = this.group(),
                        items = this.items(),
                        groupLevel = 0,
                        dataSourceChanges = this.paginate() || group ? changes.filter(function(item) {
                            return "update" === item.type
                        }) : changes;
                    if (group) {
                        groupLevel = Array.isArray(group) ? group.length : 1
                    }
                    if (this._mapFunc) {
                        dataSourceChanges.forEach(function(item) {
                            if ("insert" === item.type) {
                                item.data = _this3._mapFunc(item.data)
                            }
                        })
                    }
                    arrayUtils.applyBatch(this.store(), items, dataSourceChanges, groupLevel, true);
                    this._fireChanged([{
                        changes: changes
                    }])
                }
            },
            _createLoadOperation: function(deferred) {
                var id = this._operationManager.add(deferred),
                    options = this._createStoreLoadOptions();
                deferred.always(function() {
                    this._operationManager.remove(id)
                }.bind(this));
                return {
                    operationId: id,
                    storeLoadOptions: options
                }
            },
            reload: function() {
                var store = this.store();
                if (store instanceof CustomStore) {
                    store.clearRawDataCache()
                }
                this._init();
                return this.load()
            },
            cancel: function(operationId) {
                return this._operationManager.cancel(operationId)
            },
            cancelAll: function() {
                return this._operationManager.cancelAll()
            },
            _addSearchOptions: function(storeLoadOptions) {
                if (this._disposed) {
                    return
                }
                if (this.store()._useDefaultSearch) {
                    this._addSearchFilter(storeLoadOptions)
                } else {
                    storeLoadOptions.searchOperation = this._searchOperation;
                    storeLoadOptions.searchValue = this._searchValue;
                    storeLoadOptions.searchExpr = this._searchExpr
                }
            },
            _createStoreLoadOptions: function() {
                var result = extend({}, this._storeLoadOptions);
                this._addSearchOptions(result);
                if (this._paginate) {
                    if (this._pageSize) {
                        result.skip = this._pageIndex * this._pageSize;
                        result.take = this._pageSize
                    }
                }
                result.userData = this._userData;
                return result
            },
            _addSearchFilter: function(storeLoadOptions) {
                var value = this._searchValue,
                    op = this._searchOperation,
                    selector = this._searchExpr,
                    searchFilter = [];
                if (!value) {
                    return
                }
                if (!selector) {
                    selector = "this"
                }
                if (!Array.isArray(selector)) {
                    selector = [selector]
                }
                iteratorUtils.each(selector, function(i, item) {
                    if (searchFilter.length) {
                        searchFilter.push("or")
                    }
                    searchFilter.push([item, op, value])
                });
                if (storeLoadOptions.filter) {
                    storeLoadOptions.filter = [searchFilter, storeLoadOptions.filter]
                } else {
                    storeLoadOptions.filter = searchFilter
                }
            },
            _loadFromStore: function(loadOptions, pendingDeferred) {
                var that = this;

                function handleSuccess(data, extra) {
                    function processResult() {
                        var loadResult = extend(normalizeLoadResult(data, extra), loadOptions);
                        that.fireEvent("customizeLoadResult", [loadResult]);
                        when(loadResult.data).done(function(data) {
                            loadResult.data = data;
                            that._processStoreLoadResult(loadResult, pendingDeferred)
                        }).fail(pendingDeferred.reject)
                    }
                    if (that._disposed) {
                        return
                    }
                    if (!isPending(pendingDeferred)) {
                        return
                    }
                    processResult()
                }
                if (loadOptions.data) {
                    return (new Deferred).resolve(loadOptions.data).done(handleSuccess)
                }
                return this.store().load(loadOptions.storeLoadOptions).done(handleSuccess).fail(pendingDeferred.reject)
            },
            _processStoreLoadResult: function(loadResult, pendingDeferred) {
                var that = this,
                    data = loadResult.data,
                    extra = loadResult.extra,
                    storeLoadOptions = loadResult.storeLoadOptions;

                function resolvePendingDeferred() {
                    that._isLoaded = true;
                    that._totalCount = isFinite(extra.totalCount) ? extra.totalCount : -1;
                    return pendingDeferred.resolve(data, extra)
                }

                function proceedLoadingTotalCount() {
                    that.store().totalCount(storeLoadOptions).done(function(count) {
                        extra.totalCount = count;
                        resolvePendingDeferred()
                    }).fail(pendingDeferred.reject)
                }
                if (that._disposed) {
                    return
                }
                data = that._applyPostProcessFunction(that._applyMapFunction(data));
                if (!typeUtils.isPlainObject(extra)) {
                    extra = {}
                }
                that._items = data;
                if (!data.length || !that._paginate || that._pageSize && data.length < that._pageSize) {
                    that._isLastPage = true
                }
                if (storeLoadOptions.requireTotalCount && !isFinite(extra.totalCount)) {
                    proceedLoadingTotalCount()
                } else {
                    resolvePendingDeferred()
                }
            },
            _applyMapFunction: function(data) {
                if (this._mapFunc) {
                    return mapDataRespectingGrouping(data, this._mapFunc, this.group())
                }
                return data
            },
            _applyPostProcessFunction: function(data) {
                if (this._postProcessFunc) {
                    return this._postProcessFunc(data)
                }
                return data
            }
        }).include(EventsMixin);
        exports.DataSource = DataSource;
        exports.normalizeDataSourceOptions = normalizeDataSourceOptions;
        exports.normalizeLoadResult = normalizeLoadResult
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/utils/object.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var typeUtils = __webpack_require__( /*! ./type */ 1),
            variableWrapper = __webpack_require__( /*! ./variable_wrapper */ 87);
        var clone = function() {
            function Clone() {}
            return function(obj) {
                Clone.prototype = obj;
                return new Clone
            }
        }();
        var orderEach = function(map, func) {
            var key, i, keys = [];
            for (key in map) {
                if (Object.prototype.hasOwnProperty.call(map, key)) {
                    keys.push(key)
                }
            }
            keys.sort(function(x, y) {
                var isNumberX = typeUtils.isNumeric(x),
                    isNumberY = typeUtils.isNumeric(y);
                if (isNumberX && isNumberY) {
                    return x - y
                }
                if (isNumberX && !isNumberY) {
                    return -1
                }
                if (!isNumberX && isNumberY) {
                    return 1
                }
                if (x < y) {
                    return -1
                }
                if (x > y) {
                    return 1
                }
                return 0
            });
            for (i = 0; i < keys.length; i++) {
                key = keys[i];
                func(key, map[key])
            }
        };
        var assignValueToProperty = function(target, property, value, assignByReference) {
            if (!assignByReference && variableWrapper.isWrapped(target[property])) {
                variableWrapper.assign(target[property], value)
            } else {
                target[property] = value
            }
        };
        var deepExtendArraySafe = function deepExtendArraySafe(target, changes, extendComplexObject, assignByReference) {
            var prevValue, newValue;
            for (var name in changes) {
                prevValue = target[name];
                newValue = changes[name];
                if ("__proto__" === name || target === newValue) {
                    continue
                }
                if (typeUtils.isPlainObject(newValue)) {
                    var goDeeper = extendComplexObject ? typeUtils.isObject(prevValue) : typeUtils.isPlainObject(prevValue);
                    newValue = deepExtendArraySafe(goDeeper ? prevValue : {}, newValue, extendComplexObject, assignByReference)
                }
                if (void 0 !== newValue && prevValue !== newValue) {
                    assignValueToProperty(target, name, newValue, assignByReference)
                }
            }
            return target
        };
        exports.clone = clone;
        exports.orderEach = orderEach;
        exports.deepExtendArraySafe = deepExtendArraySafe
    },
    /*!************************************************************!*\
      !*** ./artifacts/transpiled/core/utils/ready_callbacks.js ***!
      \************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var domAdapter = __webpack_require__( /*! ../dom_adapter */ 13);
        var injector = __webpack_require__( /*! ./dependency_injector */ 56);
        var windowUtils = __webpack_require__( /*! ./window */ 7);
        var callOnce = __webpack_require__( /*! ./call_once */ 61);
        var callbacks = [];
        var isReady = function() {
            return "complete" === domAdapter.getReadyState() || "loading" !== domAdapter.getReadyState() && !domAdapter.getDocumentElement().doScroll
        };
        var subscribeReady = callOnce(function() {
            var removeListener = domAdapter.listen(domAdapter.getDocument(), "DOMContentLoaded", function() {
                readyCallbacks.fire();
                removeListener()
            })
        });
        var readyCallbacks = {
            add: function(callback) {
                var hasWindow = windowUtils.hasWindow();
                if (hasWindow && isReady()) {
                    callback()
                } else {
                    callbacks.push(callback);
                    hasWindow && subscribeReady()
                }
            },
            fire: function() {
                callbacks.forEach(function(callback) {
                    return callback()
                });
                callbacks = []
            }
        };
        module.exports = injector(readyCallbacks)
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/ui/editor/editor.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _renderer = __webpack_require__( /*! ../../core/renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _element_data = __webpack_require__( /*! ../../core/element_data */ 40);
        var _element_data2 = _interopRequireDefault(_element_data);
        var _callbacks = __webpack_require__( /*! ../../core/utils/callbacks */ 26);
        var _callbacks2 = _interopRequireDefault(_callbacks);
        var _common = __webpack_require__( /*! ../../core/utils/common */ 4);
        var _common2 = _interopRequireDefault(_common);
        var _window = __webpack_require__( /*! ../../core/utils/window */ 7);
        var _window2 = _interopRequireDefault(_window);
        var _position = __webpack_require__( /*! ../../core/utils/position */ 99);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _guid = __webpack_require__( /*! ../../core/guid */ 34);
        var _guid2 = _interopRequireDefault(_guid);
        var _ui = __webpack_require__( /*! ../widget/ui.widget */ 17);
        var _ui2 = _interopRequireDefault(_ui);
        var _validation_mixin = __webpack_require__( /*! ../validation/validation_mixin */ 177);
        var _validation_mixin2 = _interopRequireDefault(_validation_mixin);
        var _overlay = __webpack_require__( /*! ../overlay */ 59);
        var _overlay2 = _interopRequireDefault(_overlay);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var READONLY_STATE_CLASS = "dx-state-readonly",
            INVALID_CLASS = "dx-invalid",
            INVALID_MESSAGE = "dx-invalid-message",
            INVALID_MESSAGE_CONTENT = "dx-invalid-message-content",
            INVALID_MESSAGE_AUTO = "dx-invalid-message-auto",
            INVALID_MESSAGE_ALWAYS = "dx-invalid-message-always",
            DX_INVALID_BADGE_CLASS = "dx-show-invalid-badge",
            VALIDATION_TARGET = "dx-validation-target",
            VALIDATION_MESSAGE_MIN_WIDTH = 100,
            VALIDATION_STATUS_VALID = "valid",
            VALIDATION_STATUS_INVALID = "invalid";
        var getValidationErrorMessage = function(validationErrors) {
            var validationErrorMessage = "";
            if (validationErrors) {
                validationErrors.forEach(function(err) {
                    if (err.message) {
                        validationErrorMessage += (validationErrorMessage ? "<br />" : "") + err.message
                    }
                })
            }
            return validationErrorMessage
        };
        var Editor = _ui2.default.inherit({
            ctor: function() {
                this.showValidationMessageTimeout = null;
                this.callBase.apply(this, arguments)
            },
            _initOptions: function(options) {
                this.callBase.apply(this, arguments);
                this._initValidationOptions(options)
            },
            _init: function() {
                this.callBase();
                this.validationRequest = (0, _callbacks2.default)();
                this._initInnerOptionCache("validationTooltipOptions");
                var $element = this.$element();
                $element.addClass(DX_INVALID_BADGE_CLASS);
                if ($element) {
                    _element_data2.default.data($element[0], VALIDATION_TARGET, this)
                }
            },
            _getDefaultOptions: function() {
                return (0, _extend.extend)(this.callBase(), {
                    value: null,
                    name: "",
                    onValueChanged: null,
                    readOnly: false,
                    isValid: true,
                    validationError: null,
                    validationErrors: null,
                    validationStatus: VALIDATION_STATUS_VALID,
                    validationMessageMode: "auto",
                    validationBoundary: void 0,
                    validationMessageOffset: {
                        h: 0,
                        v: 0
                    },
                    validationTooltipOptions: {}
                })
            },
            _attachKeyboardEvents: function() {
                if (this.option("readOnly")) {
                    return
                }
                this.callBase();
                if (this._keyboardProcessor) {
                    this._attachChildKeyboardEvents()
                }
            },
            _attachChildKeyboardEvents: _common2.default.noop,
            _setOptionsByReference: function() {
                this.callBase();
                (0, _extend.extend)(this._optionsByReference, {
                    validationError: true
                })
            },
            _createValueChangeAction: function() {
                this._valueChangeAction = this._createActionByOption("onValueChanged", {
                    excludeValidators: ["disabled", "readOnly"]
                })
            },
            _suppressValueChangeAction: function() {
                this._valueChangeActionSuppressed = true
            },
            _resumeValueChangeAction: function() {
                this._valueChangeActionSuppressed = false
            },
            _initMarkup: function() {
                this._toggleReadOnlyState();
                this._setSubmitElementName(this.option("name"));
                this.callBase();
                this._renderValidationState()
            },
            _raiseValueChangeAction: function(value, previousValue) {
                if (!this._valueChangeAction) {
                    this._createValueChangeAction()
                }
                this._valueChangeAction(this._valueChangeArgs(value, previousValue))
            },
            _valueChangeArgs: function(value, previousValue) {
                return {
                    value: value,
                    previousValue: previousValue,
                    event: this._valueChangeEventInstance
                }
            },
            _saveValueChangeEvent: function(e) {
                this._valueChangeEventInstance = e
            },
            _focusInHandler: function(e) {
                var _this = this;
                var isValidationMessageShownOnFocus = "auto" === this.option("validationMessageMode");
                if (this._canValueBeChangedByClick() && isValidationMessageShownOnFocus) {
                    this._$validationMessage && this._$validationMessage.removeClass(INVALID_MESSAGE_AUTO);
                    clearTimeout(this.showValidationMessageTimeout);
                    this.showValidationMessageTimeout = setTimeout(function() {
                        return _this._$validationMessage && _this._$validationMessage.addClass(INVALID_MESSAGE_AUTO)
                    }, 150)
                }
                return this.callBase(e)
            },
            _canValueBeChangedByClick: function() {
                return false
            },
            _renderValidationState: function() {
                var isValid = this.option("isValid") && this.option("validationStatus") !== VALIDATION_STATUS_INVALID,
                    validationMessageMode = this.option("validationMessageMode"),
                    $element = this.$element();
                var validationErrors = this.option("validationErrors");
                if (!validationErrors && this.option("validationError")) {
                    validationErrors = [this.option("validationError")]
                }
                $element.toggleClass(INVALID_CLASS, !isValid);
                this.setAria(VALIDATION_STATUS_INVALID, !isValid || void 0);
                if (!_window2.default.hasWindow()) {
                    return
                }
                if (this._$validationMessage) {
                    this._$validationMessage.remove();
                    this.setAria("describedby", null);
                    this._$validationMessage = null
                }
                var validationErrorMessage = getValidationErrorMessage(validationErrors);
                if (!isValid && validationErrorMessage) {
                    this._$validationMessage = (0, _renderer2.default)("<div>").addClass(INVALID_MESSAGE).html(validationErrorMessage).appendTo($element);
                    var validationTarget = this._getValidationMessageTarget();
                    this._validationMessage = this._createComponent(this._$validationMessage, _overlay2.default, (0, _extend.extend)({
                        integrationOptions: {},
                        templatesRenderAsynchronously: false,
                        target: validationTarget,
                        shading: false,
                        width: "auto",
                        height: "auto",
                        container: $element,
                        position: this._getValidationMessagePosition("below"),
                        closeOnOutsideClick: false,
                        closeOnTargetScroll: false,
                        animation: null,
                        visible: true,
                        propagateOutsideClick: true,
                        _checkParentVisibility: false
                    }, this._getInnerOptionsCache("validationTooltipOptions")));
                    this._$validationMessage.toggleClass(INVALID_MESSAGE_AUTO, "auto" === validationMessageMode).toggleClass(INVALID_MESSAGE_ALWAYS, "always" === validationMessageMode);
                    var messageId = "dx-" + new _guid2.default;
                    this._validationMessage.$content().addClass(INVALID_MESSAGE_CONTENT).attr("id", messageId);
                    this.setAria("describedby", messageId);
                    this._setValidationMessageMaxWidth();
                    this._bindInnerWidgetOptions(this._validationMessage, "validationTooltipOptions")
                }
            },
            _setValidationMessageMaxWidth: function() {
                if (!this._validationMessage) {
                    return
                }
                if (0 === this._getValidationMessageTarget().outerWidth()) {
                    this._validationMessage.option("maxWidth", "100%");
                    return
                }
                var validationMessageMaxWidth = Math.max(VALIDATION_MESSAGE_MIN_WIDTH, this._getValidationMessageTarget().outerWidth());
                this._validationMessage.option("maxWidth", validationMessageMaxWidth)
            },
            _getValidationMessageTarget: function() {
                return this.$element()
            },
            _getValidationMessagePosition: function(positionRequest) {
                var rtlEnabled = this.option("rtlEnabled"),
                    messagePositionSide = (0, _position.getDefaultAlignment)(rtlEnabled),
                    messageOriginalOffset = this.option("validationMessageOffset"),
                    messageOffset = {
                        h: messageOriginalOffset.h,
                        v: messageOriginalOffset.v
                    },
                    verticalPositions = "below" === positionRequest ? [" top", " bottom"] : [" bottom", " top"];
                if (rtlEnabled) {
                    messageOffset.h = -messageOffset.h
                }
                if ("below" !== positionRequest) {
                    messageOffset.v = -messageOffset.v
                }
                return {
                    offset: messageOffset,
                    boundary: this.option("validationBoundary"),
                    my: messagePositionSide + verticalPositions[0],
                    at: messagePositionSide + verticalPositions[1],
                    collision: "none flip"
                }
            },
            _toggleReadOnlyState: function() {
                this.$element().toggleClass(READONLY_STATE_CLASS, !!this.option("readOnly"));
                this.setAria("readonly", this.option("readOnly") || void 0)
            },
            _dispose: function() {
                var element = this.$element()[0];
                _element_data2.default.data(element, VALIDATION_TARGET, null);
                clearTimeout(this.showValidationMessageTimeout);
                this.callBase()
            },
            _setSubmitElementName: function(name) {
                var $submitElement = this._getSubmitElement();
                if (!$submitElement) {
                    return
                }
                if (name.length > 0) {
                    $submitElement.attr("name", name)
                } else {
                    $submitElement.removeAttr("name")
                }
            },
            _getSubmitElement: function() {
                return null
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "onValueChanged":
                        this._createValueChangeAction();
                        break;
                    case "isValid":
                    case "validationError":
                        this._synchronizeValidationOptions(args);
                        break;
                    case "validationErrors":
                    case "validationStatus":
                        this._synchronizeValidationOptions(args);
                        this._renderValidationState();
                        break;
                    case "validationBoundary":
                    case "validationMessageMode":
                        this._renderValidationState();
                        break;
                    case "validationTooltipOptions":
                        this._innerOptionChanged(this._validationMessage, args);
                        break;
                    case "readOnly":
                        this._toggleReadOnlyState();
                        this._refreshFocusState();
                        break;
                    case "value":
                        if (!this._valueChangeActionSuppressed) {
                            this._raiseValueChangeAction(args.value, args.previousValue);
                            this._saveValueChangeEvent(void 0)
                        }
                        if (args.value != args.previousValue) {
                            this.validationRequest.fire({
                                value: args.value,
                                editor: this
                            })
                        }
                        break;
                    case "width":
                        this.callBase(args);
                        this._setValidationMessageMaxWidth();
                        break;
                    case "name":
                        this._setSubmitElementName(args.value);
                        break;
                    default:
                        this.callBase(args)
                }
            },
            reset: function() {
                var defaultOptions = this._getDefaultOptions();
                this.option("value", defaultOptions.value)
            }
        }).include(_validation_mixin2.default);
        module.exports = Editor
    }, ,
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/localization/number.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _slicedToArray = function() {
            function sliceIterator(arr, i) {
                var _arr = [];
                var _n = true;
                var _d = false;
                var _e = void 0;
                try {
                    for (var _s, _i = arr[Symbol.iterator](); !(_n = (_s = _i.next()).done); _n = true) {
                        _arr.push(_s.value);
                        if (i && _arr.length === i) {
                            break
                        }
                    }
                } catch (err) {
                    _d = true;
                    _e = err
                } finally {
                    try {
                        if (!_n && _i.return) {
                            _i.return()
                        }
                    } finally {
                        if (_d) {
                            throw _e
                        }
                    }
                }
                return _arr
            }
            return function(arr, i) {
                if (Array.isArray(arr)) {
                    return arr
                } else {
                    if (Symbol.iterator in Object(arr)) {
                        return sliceIterator(arr, i)
                    } else {
                        throw new TypeError("Invalid attempt to destructure non-iterable instance")
                    }
                }
            }
        }();
        var _dependency_injector = __webpack_require__( /*! ../core/utils/dependency_injector */ 56);
        var _dependency_injector2 = _interopRequireDefault(_dependency_injector);
        var _array = __webpack_require__( /*! ../core/utils/array */ 14);
        var _common = __webpack_require__( /*! ../core/utils/common */ 4);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var _number = __webpack_require__( /*! ./ldml/number */ 286);
        var _number2 = _interopRequireDefault(_number);
        var _config = __webpack_require__( /*! ../core/config */ 29);
        var _config2 = _interopRequireDefault(_config);
        var _errors = __webpack_require__( /*! ../core/errors */ 21);
        var _errors2 = _interopRequireDefault(_errors);
        var _utils = __webpack_require__( /*! ./utils */ 262);
        var _currency = __webpack_require__( /*! ./currency */ 125);
        var _currency2 = _interopRequireDefault(_currency);
        var _number3 = __webpack_require__( /*! ./intl/number */ 441);
        var _number4 = _interopRequireDefault(_number3);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var hasIntl = "undefined" !== typeof Intl;
        var MAX_LARGE_NUMBER_POWER = 4;
        var DECIMAL_BASE = 10;
        var NUMERIC_FORMATS = ["currency", "fixedpoint", "exponential", "percent", "decimal"];
        var LargeNumberFormatPostfixes = {
            1: "K",
            2: "M",
            3: "B",
            4: "T"
        };
        var LargeNumberFormatPowers = {
            largenumber: "auto",
            thousands: 1,
            millions: 2,
            billions: 3,
            trillions: 4
        };
        var numberLocalization = (0, _dependency_injector2.default)({
            engine: function() {
                return "base"
            },
            numericFormats: NUMERIC_FORMATS,
            defaultLargeNumberFormatPostfixes: LargeNumberFormatPostfixes,
            _parseNumberFormatString: function(formatType) {
                var formatList = void 0;
                var formatObject = {};
                if (!formatType || "string" !== typeof formatType) {
                    return
                }
                formatList = formatType.toLowerCase().split(" ");
                (0, _iterator.each)(formatList, function(index, value) {
                    if ((0, _array.inArray)(value, NUMERIC_FORMATS) > -1) {
                        formatObject.formatType = value
                    } else {
                        if (value in LargeNumberFormatPowers) {
                            formatObject.power = LargeNumberFormatPowers[value]
                        }
                    }
                });
                if (formatObject.power && !formatObject.formatType) {
                    formatObject.formatType = "fixedpoint"
                }
                if (formatObject.formatType) {
                    return formatObject
                }
            },
            _calculateNumberPower: function(value, base, minPower, maxPower) {
                var number = Math.abs(value);
                var power = 0;
                if (number > 1) {
                    while (number && number >= base && (void 0 === maxPower || power < maxPower)) {
                        power++;
                        number /= base
                    }
                } else {
                    if (number > 0 && number < 1) {
                        while (number < 1 && (void 0 === minPower || power > minPower)) {
                            power--;
                            number *= base
                        }
                    }
                }
                return power
            },
            _getNumberByPower: function(number, power, base) {
                var result = number;
                while (power > 0) {
                    result /= base;
                    power--
                }
                while (power < 0) {
                    result *= base;
                    power++
                }
                return result
            },
            _formatNumber: function(value, formatObject, formatConfig) {
                var powerPostfix = void 0;
                var result = void 0;
                if ("auto" === formatObject.power) {
                    formatObject.power = this._calculateNumberPower(value, 1e3, 0, MAX_LARGE_NUMBER_POWER)
                }
                if (formatObject.power) {
                    value = this._getNumberByPower(value, formatObject.power, 1e3)
                }
                powerPostfix = this.defaultLargeNumberFormatPostfixes[formatObject.power] || "";
                result = this._formatNumberCore(value, formatObject.formatType, formatConfig);
                result = result.replace(/(\d|.$)(\D*)$/, "$1" + powerPostfix + "$2");
                return result
            },
            _formatNumberExponential: function(value, formatConfig) {
                var power = this._calculateNumberPower(value, DECIMAL_BASE);
                var number = this._getNumberByPower(value, power, DECIMAL_BASE);
                var powString = void 0;
                if (void 0 === formatConfig.precision) {
                    formatConfig.precision = 1
                }
                if (number.toFixed(formatConfig.precision || 0) >= DECIMAL_BASE) {
                    power++;
                    number /= DECIMAL_BASE
                }
                powString = (power >= 0 ? "+" : "") + power.toString();
                return this._formatNumberCore(number, "fixedpoint", formatConfig) + "E" + powString
            },
            _addZeroes: function(value, precision) {
                var multiplier = Math.pow(10, precision);
                var sign = value < 0 ? "-" : "";
                value = (Math.abs(value) * multiplier >>> 0) / multiplier;
                var result = value.toString();
                while (result.length < precision) {
                    result = "0" + result
                }
                return sign + result
            },
            _addGroupSeparators: function(value) {
                var parts = value.toString().split(".");
                return parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, (0, _config2.default)().thousandsSeparator) + (parts[1] ? (0, _config2.default)().decimalSeparator + parts[1] : "")
            },
            _formatNumberCore: function(value, format, formatConfig) {
                if ("exponential" === format) {
                    return this._formatNumberExponential(value, formatConfig)
                }
                if ("decimal" !== format && null !== formatConfig.precision) {
                    formatConfig.precision = formatConfig.precision || 0
                }
                if ("percent" === format) {
                    value = 100 * value
                }
                if (void 0 !== formatConfig.precision) {
                    if ("decimal" === format) {
                        value = this._addZeroes(value, formatConfig.precision)
                    } else {
                        value = null === formatConfig.precision ? value.toPrecision() : (0, _utils.toFixed)(value, formatConfig.precision)
                    }
                }
                if ("decimal" !== format) {
                    value = this._addGroupSeparators(value)
                } else {
                    value = value.toString().replace(".", (0, _config2.default)().decimalSeparator)
                }
                if ("percent" === format) {
                    value += "%"
                }
                return value
            },
            _normalizeFormat: function(format) {
                if (!format) {
                    return {}
                }
                if ("function" === typeof format) {
                    return format
                }
                if (!(0, _type.isPlainObject)(format)) {
                    format = {
                        type: format
                    }
                }
                return format
            },
            _getSeparators: function() {
                return {
                    decimalSeparator: this.getDecimalSeparator(),
                    thousandsSeparator: this.getThousandsSeparator()
                }
            },
            getThousandsSeparator: function() {
                return this.format(1e4, "fixedPoint")[2]
            },
            getDecimalSeparator: function() {
                return this.format(1.2, {
                    type: "fixedPoint",
                    precision: 1
                })[1]
            },
            convertDigits: function(value, toStandard) {
                var digits = this.format(90, "decimal");
                if ("string" !== typeof value || "0" === digits[1]) {
                    return value
                }
                var fromFirstDigit = toStandard ? digits[1] : "0";
                var toFirstDigit = toStandard ? "0" : digits[1];
                var fromLastDigit = toStandard ? digits[0] : "9";
                var regExp = new RegExp("[" + fromFirstDigit + "-" + fromLastDigit + "]", "g");
                return value.replace(regExp, function(char) {
                    return String.fromCharCode(char.charCodeAt(0) + (toFirstDigit.charCodeAt(0) - fromFirstDigit.charCodeAt(0)))
                })
            },
            getSign: function(text, format) {
                if ("-" === text.replace(/[^0-9-]/g, "").charAt(0)) {
                    return -1
                }
                if (!format) {
                    return 1
                }
                var separators = this._getSeparators();
                var regExp = new RegExp("[0-9" + (0, _common.escapeRegExp)(separators.decimalSeparator + separators.thousandsSeparator) + "]+", "g");
                var negativeEtalon = this.format(-1, format).replace(regExp, "1");
                var cleanedText = text.replace(regExp, "1");
                return cleanedText === negativeEtalon ? -1 : 1
            },
            format: function(value, _format) {
                if ("number" !== typeof value) {
                    return value
                }
                if ("number" === typeof _format) {
                    return value
                }
                _format = _format && _format.formatter || _format;
                if ("function" === typeof _format) {
                    return _format(value)
                }
                _format = this._normalizeFormat(_format);
                if (!_format.type) {
                    _format.type = "decimal"
                }
                var numberConfig = this._parseNumberFormatString(_format.type);
                if (!numberConfig) {
                    return this.convertDigits(_number2.default.getFormatter(_format.type, this._getSeparators())(value))
                }
                return this._formatNumber(value, numberConfig, _format)
            },
            parse: function(text, format) {
                if (!text) {
                    return
                }
                if (format && format.parser) {
                    return format.parser(text)
                }
                text = this.convertDigits(text, true);
                if (format && "string" !== typeof format) {
                    _errors2.default.log("W0011")
                }
                var decimalSeparator = this.getDecimalSeparator();
                var regExp = new RegExp("[^0-9" + (0, _common.escapeRegExp)(decimalSeparator) + "]", "g");
                var cleanedText = text.replace(regExp, "").replace(decimalSeparator, ".").replace(/\.$/g, "");
                if ("." === cleanedText || "" === cleanedText) {
                    return null
                }
                if (this._calcSignificantDigits(cleanedText) > 15) {
                    return NaN
                }
                var parsed = +cleanedText;
                return parsed * this.getSign(text, format)
            },
            _calcSignificantDigits: function(text) {
                var _text$split = text.split("."),
                    _text$split2 = _slicedToArray(_text$split, 2),
                    integer = _text$split2[0],
                    fractional = _text$split2[1];
                var calcDigitsAfterLeadingZeros = function(digits) {
                    var index = -1;
                    for (var i = 0; i < digits.length; i++) {
                        if ("0" !== digits[i]) {
                            index = i;
                            break
                        }
                    }
                    return index > -1 ? digits.length - index : 0
                };
                var result = 0;
                if (integer) {
                    result += calcDigitsAfterLeadingZeros(integer.split(""))
                }
                if (fractional) {
                    result += calcDigitsAfterLeadingZeros(fractional.split("").reverse())
                }
                return result
            }
        });
        numberLocalization.inject(_currency2.default);
        if (hasIntl) {
            numberLocalization.inject(_number4.default)
        }
        module.exports = numberLocalization
    },
    /*!*************************************************************************!*\
      !*** ./artifacts/transpiled/ui/collection/ui.collection_widget.edit.js ***!
      \*************************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _renderer = __webpack_require__( /*! ../../core/renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _events_engine = __webpack_require__( /*! ../../events/core/events_engine */ 5);
        var _events_engine2 = _interopRequireDefault(_events_engine);
        var _uiCollection_widget = __webpack_require__( /*! ./ui.collection_widget.base */ 481);
        var _uiCollection_widget2 = _interopRequireDefault(_uiCollection_widget);
        var _ui = __webpack_require__( /*! ../widget/ui.errors */ 18);
        var _ui2 = _interopRequireDefault(_ui);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        var _common = __webpack_require__( /*! ../../core/utils/common */ 4);
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _uiCollection_widgetEditStrategy = __webpack_require__( /*! ./ui.collection_widget.edit.strategy.plain */ 185);
        var _uiCollection_widgetEditStrategy2 = _interopRequireDefault(_uiCollection_widgetEditStrategy);
        var _data = __webpack_require__( /*! ../../core/utils/data */ 20);
        var _data_source = __webpack_require__( /*! ../../data/data_source/data_source */ 46);
        var _selection = __webpack_require__( /*! ../selection/selection */ 291);
        var _selection2 = _interopRequireDefault(_selection);
        var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 6);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _toConsumableArray(arr) {
            if (Array.isArray(arr)) {
                for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
                    arr2[i] = arr[i]
                }
                return arr2
            } else {
                return Array.from(arr)
            }
        }
        var ITEM_DELETING_DATA_KEY = "dxItemDeleting";
        var NOT_EXISTING_INDEX = -1;
        var indexExists = function(index) {
            return index !== NOT_EXISTING_INDEX
        };
        var CollectionWidget = _uiCollection_widget2.default.inherit({
            _setOptionsByReference: function() {
                this.callBase();
                (0, _extend.extend)(this._optionsByReference, {
                    selectedItem: true
                })
            },
            _getDefaultOptions: function() {
                return (0, _extend.extend)(this.callBase(), {
                    selectionMode: "none",
                    selectionRequired: false,
                    selectionByClick: true,
                    selectedItems: [],
                    selectedItemKeys: [],
                    maxFilterLengthInRequest: 1500,
                    keyExpr: null,
                    selectedIndex: NOT_EXISTING_INDEX,
                    selectedItem: null,
                    onSelectionChanged: null,
                    onItemReordered: null,
                    onItemDeleting: null,
                    onItemDeleted: null
                })
            },
            ctor: function(element, options) {
                this._userOptions = options || {};
                this.callBase(element, options)
            },
            _init: function() {
                this._initEditStrategy();
                this.callBase();
                this._initKeyGetter();
                this._initSelectionModule();
                if ("multi" === this.option("selectionMode")) {
                    this._showDeprecatedSelectionMode()
                }
            },
            _initKeyGetter: function() {
                this._keyGetter = (0, _data.compileGetter)(this.option("keyExpr"))
            },
            _getKeysByItems: function(selectedItems) {
                return this._editStrategy.getKeysByItems(selectedItems)
            },
            _getItemsByKeys: function(selectedItemKeys, selectedItems) {
                return this._editStrategy.getItemsByKeys(selectedItemKeys, selectedItems)
            },
            _getKeyByIndex: function(index) {
                return this._editStrategy.getKeyByIndex(index)
            },
            _getIndexByKey: function(key) {
                return this._editStrategy.getIndexByKey(key)
            },
            _getIndexByItemData: function(itemData) {
                return this._editStrategy.getIndexByItemData(itemData)
            },
            _isKeySpecified: function() {
                return !!(this._dataSource && this._dataSource.key())
            },
            _getCombinedFilter: function() {
                return this._dataSource && this._dataSource.filter()
            },
            key: function() {
                if (this.option("keyExpr")) {
                    return this.option("keyExpr")
                }
                return this._dataSource && this._dataSource.key()
            },
            keyOf: function(item) {
                var key = item;
                var store = this._dataSource && this._dataSource.store();
                if (this.option("keyExpr")) {
                    key = this._keyGetter(item)
                } else {
                    if (store) {
                        key = store.keyOf(item)
                    }
                }
                return key
            },
            _initSelectionModule: function() {
                var that = this,
                    itemsGetter = that._editStrategy.itemsGetter;
                this._selection = new _selection2.default({
                    mode: this.option("selectionMode"),
                    maxFilterLengthInRequest: this.option("maxFilterLengthInRequest"),
                    equalByReference: !this._isKeySpecified(),
                    onSelectionChanged: function(args) {
                        if (args.addedItemKeys.length || args.removedItemKeys.length) {
                            that.option("selectedItems", that._getItemsByKeys(args.selectedItemKeys, args.selectedItems));
                            that._updateSelectedItems(args)
                        }
                    },
                    filter: that._getCombinedFilter.bind(that),
                    totalCount: function() {
                        var items = that.option("items");
                        var dataSource = that._dataSource;
                        return dataSource && dataSource.totalCount() >= 0 ? dataSource.totalCount() : items.length
                    },
                    key: that.key.bind(that),
                    keyOf: that.keyOf.bind(that),
                    load: function(options) {
                        if (that._dataSource) {
                            var loadOptions = that._dataSource.loadOptions();
                            options.customQueryParams = loadOptions.customQueryParams;
                            options.userData = that._dataSource._userData
                        }
                        var store = that._dataSource && that._dataSource.store();
                        if (store) {
                            return store.load(options).done(function(loadResult) {
                                if (that._disposed) {
                                    return
                                }
                                var items = (0, _data_source.normalizeLoadResult)(loadResult).data;
                                that._dataSource._applyMapFunction(items)
                            })
                        } else {
                            return (new _deferred.Deferred).resolve(this.plainItems())
                        }
                    },
                    dataFields: function() {
                        return that._dataSource && that._dataSource.select()
                    },
                    plainItems: itemsGetter.bind(that._editStrategy)
                })
            },
            _initEditStrategy: function() {
                var Strategy = _uiCollection_widgetEditStrategy2.default;
                this._editStrategy = new Strategy(this)
            },
            _getSelectedItemIndices: function(keys) {
                var that = this,
                    indices = [];
                keys = keys || this._selection.getSelectedItemKeys();
                that._editStrategy.beginCache();
                (0, _iterator.each)(keys, function(_, key) {
                    var selectedIndex = that._getIndexByKey(key);
                    if (indexExists(selectedIndex)) {
                        indices.push(selectedIndex)
                    }
                });
                that._editStrategy.endCache();
                return indices
            },
            _initMarkup: function() {
                var _this = this;
                this._rendering = true;
                if (!this._dataSource || !this._dataSource.isLoading()) {
                    this._syncSelectionOptions().done(function() {
                        return _this._normalizeSelectedItems()
                    })
                }
                this.callBase()
            },
            _render: function() {
                this.callBase();
                this._rendering = false
            },
            _fireContentReadyAction: function() {
                this._rendering = false;
                this._rendered = true;
                this.callBase.apply(this, arguments)
            },
            _syncSelectionOptions: function(byOption) {
                byOption = byOption || this._chooseSelectOption();
                var selectedItem = void 0;
                var selectedIndex = void 0;
                var selectedItemKeys = void 0;
                var selectedItems = void 0;
                switch (byOption) {
                    case "selectedIndex":
                        selectedItem = this._editStrategy.getItemDataByIndex(this.option("selectedIndex"));
                        if ((0, _type.isDefined)(selectedItem)) {
                            this._setOptionSilent("selectedItems", [selectedItem]);
                            this._setOptionSilent("selectedItem", selectedItem);
                            this._setOptionSilent("selectedItemKeys", this._editStrategy.getKeysByItems([selectedItem]))
                        } else {
                            this._setOptionSilent("selectedItems", []);
                            this._setOptionSilent("selectedItemKeys", []);
                            this._setOptionSilent("selectedItem", null)
                        }
                        break;
                    case "selectedItems":
                        selectedItems = this.option("selectedItems") || [];
                        selectedIndex = this._editStrategy.getIndexByItemData(selectedItems[0]);
                        if (this.option("selectionRequired") && !indexExists(selectedIndex)) {
                            return this._syncSelectionOptions("selectedIndex")
                        }
                        this._setOptionSilent("selectedItem", selectedItems[0]);
                        this._setOptionSilent("selectedIndex", selectedIndex);
                        this._setOptionSilent("selectedItemKeys", this._editStrategy.getKeysByItems(selectedItems));
                        break;
                    case "selectedItem":
                        selectedItem = this.option("selectedItem");
                        selectedIndex = this._editStrategy.getIndexByItemData(selectedItem);
                        if (this.option("selectionRequired") && !indexExists(selectedIndex)) {
                            return this._syncSelectionOptions("selectedIndex")
                        }
                        if ((0, _type.isDefined)(selectedItem)) {
                            this._setOptionSilent("selectedItems", [selectedItem]);
                            this._setOptionSilent("selectedIndex", selectedIndex);
                            this._setOptionSilent("selectedItemKeys", this._editStrategy.getKeysByItems([selectedItem]))
                        } else {
                            this._setOptionSilent("selectedItems", []);
                            this._setOptionSilent("selectedItemKeys", []);
                            this._setOptionSilent("selectedIndex", NOT_EXISTING_INDEX)
                        }
                        break;
                    case "selectedItemKeys":
                        selectedItemKeys = this.option("selectedItemKeys");
                        if (this.option("selectionRequired")) {
                            var selectedItemIndex = this._getIndexByKey(selectedItemKeys[0]);
                            if (!indexExists(selectedItemIndex)) {
                                return this._syncSelectionOptions("selectedIndex")
                            }
                        }
                        return this._selection.setSelection(selectedItemKeys)
                }
                return (new _deferred.Deferred).resolve().promise()
            },
            _chooseSelectOption: function() {
                var optionName = "selectedIndex";
                var isOptionDefined = function(optionName) {
                    var optionValue = this.option(optionName),
                        length = (0, _type.isDefined)(optionValue) && optionValue.length;
                    return length || optionName in this._userOptions
                }.bind(this);
                if (isOptionDefined("selectedItems")) {
                    optionName = "selectedItems"
                } else {
                    if (isOptionDefined("selectedItem")) {
                        optionName = "selectedItem"
                    } else {
                        if (isOptionDefined("selectedItemKeys")) {
                            optionName = "selectedItemKeys"
                        }
                    }
                }
                return optionName
            },
            _compareKeys: function(oldKeys, newKeys) {
                if (oldKeys.length !== newKeys.length) {
                    return false
                }
                for (var i = 0; i < newKeys.length; i++) {
                    if (oldKeys[i] !== newKeys[i]) {
                        return false
                    }
                }
                return true
            },
            _normalizeSelectedItems: function() {
                if ("none" === this.option("selectionMode")) {
                    this._setOptionSilent("selectedItems", []);
                    this._syncSelectionOptions("selectedItems")
                } else {
                    if ("single" === this.option("selectionMode")) {
                        var newSelection = this.option("selectedItems");
                        if (newSelection.length > 1 || !newSelection.length && this.option("selectionRequired") && this.option("items") && this.option("items").length) {
                            var currentSelection = this._selection.getSelectedItems();
                            var normalizedSelection = void 0 === newSelection[0] ? currentSelection[0] : newSelection[0];
                            if (void 0 === normalizedSelection) {
                                normalizedSelection = this._editStrategy.itemsGetter()[0]
                            }
                            if (this.option("grouped") && normalizedSelection && normalizedSelection.items) {
                                normalizedSelection.items = [normalizedSelection.items[0]]
                            }
                            this._selection.setSelection(this._getKeysByItems([normalizedSelection]));
                            this._setOptionSilent("selectedItems", [normalizedSelection]);
                            return this._syncSelectionOptions("selectedItems")
                        } else {
                            this._selection.setSelection(this._getKeysByItems(newSelection))
                        }
                    } else {
                        var newKeys = this._getKeysByItems(this.option("selectedItems"));
                        var oldKeys = this._selection.getSelectedItemKeys();
                        if (!this._compareKeys(oldKeys, newKeys)) {
                            this._selection.setSelection(newKeys)
                        }
                    }
                }
                return (new _deferred.Deferred).resolve().promise()
            },
            _itemClickHandler: function(e) {
                this._createAction(function(e) {
                    this._itemSelectHandler(e.event)
                }.bind(this), {
                    validatingTargetName: "itemElement"
                })({
                    itemElement: (0, _renderer2.default)(e.currentTarget),
                    event: e
                });
                this.callBase.apply(this, arguments)
            },
            _itemSelectHandler: function(e) {
                if (!this.option("selectionByClick")) {
                    return
                }
                var $itemElement = e.currentTarget;
                if (this.isItemSelected($itemElement)) {
                    this.unselectItem(e.currentTarget)
                } else {
                    this.selectItem(e.currentTarget)
                }
            },
            _selectedItemElement: function(index) {
                return this._itemElements().eq(index)
            },
            _postprocessRenderItem: function(args) {
                if ("none" !== this.option("selectionMode")) {
                    var $itemElement = (0, _renderer2.default)(args.itemElement),
                        normalizedItemIndex = this._editStrategy.getNormalizedIndex($itemElement),
                        isItemSelected = this._isItemSelected(normalizedItemIndex);
                    this._processSelectableItem($itemElement, isItemSelected)
                }
            },
            _processSelectableItem: function($itemElement, isSelected) {
                $itemElement.toggleClass(this._selectedItemClass(), isSelected);
                this._setAriaSelected($itemElement, String(isSelected))
            },
            _updateSelectedItems: function(args) {
                var that = this,
                    addedItemKeys = args.addedItemKeys,
                    removedItemKeys = args.removedItemKeys;
                if (that._rendered && (addedItemKeys.length || removedItemKeys.length)) {
                    var selectionChangePromise = that._selectionChangePromise;
                    if (!that._rendering) {
                        var addedSelection = [];
                        var normalizedIndex = void 0;
                        var removedSelection = [];
                        that._editStrategy.beginCache();
                        for (var i = 0; i < addedItemKeys.length; i++) {
                            normalizedIndex = that._getIndexByKey(addedItemKeys[i]);
                            addedSelection.push(normalizedIndex);
                            that._addSelection(normalizedIndex)
                        }
                        for (var _i = 0; _i < removedItemKeys.length; _i++) {
                            normalizedIndex = that._getIndexByKey(removedItemKeys[_i]);
                            removedSelection.push(normalizedIndex);
                            that._removeSelection(normalizedIndex)
                        }
                        that._editStrategy.endCache();
                        that._updateSelection(addedSelection, removedSelection)
                    }(0, _deferred.when)(selectionChangePromise).done(function() {
                        that._fireSelectionChangeEvent(args.addedItems, args.removedItems)
                    })
                }
            },
            _fireSelectionChangeEvent: function(addedItems, removedItems) {
                this._createActionByOption("onSelectionChanged", {
                    excludeValidators: ["disabled", "readOnly"]
                })({
                    addedItems: addedItems,
                    removedItems: removedItems
                })
            },
            _updateSelection: _common.noop,
            _setAriaSelected: function($target, value) {
                this.setAria("selected", value, $target)
            },
            _removeSelection: function(normalizedIndex) {
                var $itemElement = this._editStrategy.getItemElement(normalizedIndex);
                if (indexExists(normalizedIndex)) {
                    this._processSelectableItem($itemElement, false);
                    _events_engine2.default.triggerHandler($itemElement, "stateChanged", false)
                }
            },
            _showDeprecatedSelectionMode: function() {
                _ui2.default.log("W0001", this.NAME, "selectionMode: 'multi'", "16.1", "Use selectionMode: 'multiple' instead");
                this.option("selectionMode", "multiple")
            },
            _addSelection: function(normalizedIndex) {
                var $itemElement = this._editStrategy.getItemElement(normalizedIndex);
                if (indexExists(normalizedIndex)) {
                    this._processSelectableItem($itemElement, true);
                    _events_engine2.default.triggerHandler($itemElement, "stateChanged", true)
                }
            },
            _isItemSelected: function(index) {
                var key = this._getKeyByIndex(index);
                return this._selection.isItemSelected(key)
            },
            _optionChanged: function(args) {
                var _this2 = this;
                switch (args.name) {
                    case "selectionMode":
                        if ("multi" === args.value) {
                            this._showDeprecatedSelectionMode()
                        } else {
                            this._invalidate()
                        }
                        break;
                    case "dataSource":
                        if (!args.value || Array.isArray(args.value) && !args.value.length) {
                            this.option("selectedItemKeys", [])
                        }
                        this.callBase(args);
                        break;
                    case "selectedIndex":
                    case "selectedItem":
                    case "selectedItems":
                    case "selectedItemKeys":
                        this._syncSelectionOptions(args.name).done(function() {
                            return _this2._normalizeSelectedItems()
                        });
                        break;
                    case "keyExpr":
                        this._initKeyGetter();
                        break;
                    case "selectionRequired":
                        this._normalizeSelectedItems();
                        break;
                    case "selectionByClick":
                    case "onSelectionChanged":
                    case "onItemDeleting":
                    case "onItemDeleted":
                    case "onItemReordered":
                    case "maxFilterLengthInRequest":
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _clearSelectedItems: function() {
                this._setOptionSilent("selectedItems", []);
                this._syncSelectionOptions("selectedItems")
            },
            _waitDeletingPrepare: function($itemElement) {
                if ($itemElement.data(ITEM_DELETING_DATA_KEY)) {
                    return (new _deferred.Deferred).resolve().promise()
                }
                $itemElement.data(ITEM_DELETING_DATA_KEY, true);
                var deferred = new _deferred.Deferred,
                    deletingActionArgs = {
                        cancel: false
                    },
                    deletePromise = this._itemEventHandler($itemElement, "onItemDeleting", deletingActionArgs, {
                        excludeValidators: ["disabled", "readOnly"]
                    });
                (0, _deferred.when)(deletePromise).always(function(value) {
                    var deletePromiseExists = !deletePromise,
                        deletePromiseResolved = !deletePromiseExists && "resolved" === deletePromise.state(),
                        argumentsSpecified = !!arguments.length,
                        shouldDelete = deletePromiseExists || deletePromiseResolved && !argumentsSpecified || deletePromiseResolved && value;
                    (0, _deferred.when)((0, _deferred.fromPromise)(deletingActionArgs.cancel)).always(function() {
                        $itemElement.data(ITEM_DELETING_DATA_KEY, false)
                    }).done(function(cancel) {
                        shouldDelete && !cancel ? deferred.resolve() : deferred.reject()
                    }).fail(deferred.reject)
                }.bind(this));
                return deferred.promise()
            },
            _deleteItemFromDS: function($item) {
                if (!this._dataSource) {
                    return (new _deferred.Deferred).resolve().promise()
                }
                var deferred = new _deferred.Deferred,
                    disabledState = this.option("disabled"),
                    dataStore = this._dataSource.store();
                this.option("disabled", true);
                if (!dataStore.remove) {
                    throw _ui2.default.Error("E1011")
                }
                dataStore.remove(dataStore.keyOf(this._getItemData($item))).done(function(key) {
                    if (void 0 !== key) {
                        deferred.resolve()
                    } else {
                        deferred.reject()
                    }
                }).fail(function() {
                    deferred.reject()
                });
                deferred.always(function() {
                    this.option("disabled", disabledState)
                }.bind(this));
                return deferred
            },
            _tryRefreshLastPage: function() {
                var deferred = new _deferred.Deferred;
                if (this._isLastPage() || this.option("grouped")) {
                    deferred.resolve()
                } else {
                    this._refreshLastPage().done(function() {
                        deferred.resolve()
                    })
                }
                return deferred.promise()
            },
            _refreshLastPage: function() {
                this._expectLastItemLoading();
                return this._dataSource.load()
            },
            _updateSelectionAfterDelete: function(index) {
                var key = this._getKeyByIndex(index);
                this._selection.deselect([key])
            },
            _updateIndicesAfterIndex: function(index) {
                var itemElements = this._itemElements();
                for (var i = index + 1; i < itemElements.length; i++) {
                    (0, _renderer2.default)(itemElements[i]).data(this._itemIndexKey(), i - 1)
                }
            },
            _simulateOptionChange: function(optionName) {
                var optionValue = this.option(optionName);
                if (optionValue instanceof _data_source.DataSource) {
                    return
                }
                this._optionChangedAction({
                    name: optionName,
                    fullName: optionName,
                    value: optionValue
                })
            },
            isItemSelected: function(itemElement) {
                return this._isItemSelected(this._editStrategy.getNormalizedIndex(itemElement))
            },
            selectItem: function(itemElement) {
                if ("none" === this.option("selectionMode")) {
                    return
                }
                var itemIndex = this._editStrategy.getNormalizedIndex(itemElement);
                if (!indexExists(itemIndex)) {
                    return
                }
                var key = this._getKeyByIndex(itemIndex);
                if (this._selection.isItemSelected(key)) {
                    return
                }
                if ("single" === this.option("selectionMode")) {
                    this._selection.setSelection([key])
                } else {
                    var selectedItemKeys = this.option("selectedItemKeys") || [];
                    this._selection.setSelection([].concat(_toConsumableArray(selectedItemKeys), [key]))
                }
            },
            unselectItem: function(itemElement) {
                var itemIndex = this._editStrategy.getNormalizedIndex(itemElement);
                if (!indexExists(itemIndex)) {
                    return
                }
                var selectedItemKeys = this._selection.getSelectedItemKeys();
                if (this.option("selectionRequired") && selectedItemKeys.length <= 1) {
                    return
                }
                var key = this._getKeyByIndex(itemIndex);
                if (!this._selection.isItemSelected(key)) {
                    return
                }
                this._selection.deselect([key])
            },
            _deleteItemElementByIndex: function(index) {
                this._updateSelectionAfterDelete(index);
                this._updateIndicesAfterIndex(index);
                this._editStrategy.deleteItemAtIndex(index)
            },
            _afterItemElementDeleted: function($item, deletedActionArgs) {
                var changingOption = this._dataSource ? "dataSource" : "items";
                this._simulateOptionChange(changingOption);
                this._itemEventHandler($item, "onItemDeleted", deletedActionArgs, {
                    beforeExecute: function() {
                        $item.remove()
                    },
                    excludeValidators: ["disabled", "readOnly"]
                });
                this._renderEmptyMessage()
            },
            deleteItem: function(itemElement) {
                var that = this,
                    deferred = new _deferred.Deferred,
                    $item = this._editStrategy.getItemElement(itemElement),
                    index = this._editStrategy.getNormalizedIndex(itemElement),
                    itemResponseWaitClass = this._itemResponseWaitClass();
                if (indexExists(index)) {
                    this._waitDeletingPrepare($item).done(function() {
                        $item.addClass(itemResponseWaitClass);
                        var deletedActionArgs = that._extendActionArgs($item);
                        that._deleteItemFromDS($item).done(function() {
                            that._deleteItemElementByIndex(index);
                            that._afterItemElementDeleted($item, deletedActionArgs);
                            that._tryRefreshLastPage().done(function() {
                                deferred.resolveWith(that)
                            })
                        }).fail(function() {
                            $item.removeClass(itemResponseWaitClass);
                            deferred.rejectWith(that)
                        })
                    }).fail(function() {
                        deferred.rejectWith(that)
                    })
                } else {
                    deferred.rejectWith(that)
                }
                return deferred.promise()
            },
            reorderItem: function(itemElement, toItemElement) {
                var deferred = new _deferred.Deferred,
                    that = this,
                    strategy = this._editStrategy,
                    $movingItem = strategy.getItemElement(itemElement),
                    $destinationItem = strategy.getItemElement(toItemElement),
                    movingIndex = strategy.getNormalizedIndex(itemElement),
                    destinationIndex = strategy.getNormalizedIndex(toItemElement),
                    changingOption = this._dataSource ? "dataSource" : "items";
                var canMoveItems = indexExists(movingIndex) && indexExists(destinationIndex) && movingIndex !== destinationIndex;
                if (canMoveItems) {
                    deferred.resolveWith(this)
                } else {
                    deferred.rejectWith(this)
                }
                return deferred.promise().done(function() {
                    $destinationItem[strategy.itemPlacementFunc(movingIndex, destinationIndex)]($movingItem);
                    strategy.moveItemAtIndexToIndex(movingIndex, destinationIndex);
                    this._updateIndicesAfterIndex(movingIndex);
                    that.option("selectedItems", that._getItemsByKeys(that._selection.getSelectedItemKeys(), that._selection.getSelectedItems()));
                    if ("items" === changingOption) {
                        that._simulateOptionChange(changingOption)
                    }
                    that._itemEventHandler($movingItem, "onItemReordered", {
                        fromIndex: strategy.getIndex(movingIndex),
                        toIndex: strategy.getIndex(destinationIndex)
                    }, {
                        excludeValidators: ["disabled", "readOnly"]
                    })
                })
            }
        });
        module.exports = CollectionWidget
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled/core/utils/version.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        exports.compare = function(x, y, maxLevel) {
            function normalizeArg(value) {
                if ("string" === typeof value) {
                    return value.split(".")
                }
                if ("number" === typeof value) {
                    return [value]
                }
                return value
            }
            x = normalizeArg(x);
            y = normalizeArg(y);
            var length = Math.max(x.length, y.length);
            if (isFinite(maxLevel)) {
                length = Math.min(length, maxLevel)
            }
            for (var i = 0; i < length; i++) {
                var xItem = parseInt(x[i] || 0, 10),
                    yItem = parseInt(y[i] || 0, 10);
                if (xItem < yItem) {
                    return -1
                }
                if (xItem > yItem) {
                    return 1
                }
            }
            return 0
        }
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/core/utils/icon.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _renderer = __webpack_require__( /*! ../../core/renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var ICON_CLASS = "dx-icon";
        var SVG_ICON_CLASS = "dx-svg-icon";
        var getImageSourceType = function(source) {
            if (!source || "string" !== typeof source) {
                return false
            }
            if (/^\s*<svg[^>]*>(.|\r\n|\r|\n)*?<\/svg>\s*$/i.test(source)) {
                return "svg"
            }
            if (/data:.*base64|\.|[^<\s]\//.test(source)) {
                return "image"
            }
            if (/^[\w-_]+$/.test(source)) {
                return "dxIcon"
            }
            if (/^\s?([\w-_]\s?)+$/.test(source)) {
                return "fontIcon"
            }
            return false
        };
        var getImageContainer = function(source) {
            switch (getImageSourceType(source)) {
                case "image":
                    return (0, _renderer2.default)("<img>").attr("src", source).addClass(ICON_CLASS);
                case "fontIcon":
                    return (0, _renderer2.default)("<i>").addClass(ICON_CLASS + " " + source);
                case "dxIcon":
                    return (0, _renderer2.default)("<i>").addClass(ICON_CLASS + " " + ICON_CLASS + "-" + source);
                case "svg":
                    return (0, _renderer2.default)("<i>").addClass(ICON_CLASS + " " + SVG_ICON_CLASS).append(source);
                default:
                    return null
            }
        };
        exports.getImageSourceType = getImageSourceType;
        exports.getImageContainer = getImageContainer
    },
    /*!***************************************************************!*\
      !*** ./artifacts/transpiled/core/utils/date_serialization.js ***!
      \***************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var config = __webpack_require__( /*! ../config */ 29),
            getLDMLFormatter = __webpack_require__( /*! ../../localization/ldml/date.formatter */ 264).getFormatter,
            defaultDateNames = __webpack_require__( /*! ../../localization/default_date_names */ 265),
            typeUtils = __webpack_require__( /*! ./type */ 1),
            isString = typeUtils.isString,
            isDate = typeUtils.isDate,
            isNumber = typeUtils.isNumeric;
        var NUMBER_SERIALIZATION_FORMAT = "number",
            DATE_SERIALIZATION_FORMAT = "yyyy/MM/dd",
            DATETIME_SERIALIZATION_FORMAT = "yyyy/MM/dd HH:mm:ss";
        var ISO8601_PATTERN = /^(\d{4,})(-)?(\d{2})(-)?(\d{2})(?:T(\d{2})(:)?(\d{2})?(:)?(\d{2}(?:\.(\d{1,3})\d*)?)?)?(Z|([+-])(\d{2})(:)?(\d{2})?)?$/;
        var ISO8601_TIME_PATTERN = /^(\d{2}):(\d{2})(:(\d{2}))?$/;
        var ISO8601_PATTERN_PARTS = ["", "yyyy", "", "MM", "", "dd", "THH", "", "mm", "", "ss", ".SSS"];
        var MILLISECOND_LENGHT = 3;
        var dateParser = function(text, skipISO8601Parsing) {
            var result;
            var parsedValue;
            if (isString(text) && !skipISO8601Parsing) {
                result = parseISO8601String(text)
            }
            if (!result) {
                parsedValue = !isDate(text) && Date.parse(text);
                result = isNumber(parsedValue) ? new Date(parsedValue) : text
            }
            return result
        };
        var parseISO8601String = function(text) {
            var parts = text.match(ISO8601_PATTERN);
            var timePart = function(part) {
                return +part || 0
            };
            if (!parts) {
                parts = text.match(ISO8601_TIME_PATTERN);
                if (parts) {
                    return new Date(0, 0, 0, timePart(parts[1]), timePart(parts[2]), timePart(parts[4]))
                }
                return
            }
            var year = parts[1],
                month = --parts[3],
                day = parts[5],
                timeZoneHour = 0,
                timeZoneMinute = 0;
            timeZoneHour = timePart(parts[14]);
            timeZoneMinute = timePart(parts[16]);
            if ("-" === parts[13]) {
                timeZoneHour = -timeZoneHour;
                timeZoneMinute = -timeZoneMinute
            }
            var hour = timePart(parts[6]) - timeZoneHour,
                minute = timePart(parts[8]) - timeZoneMinute,
                second = timePart(parts[10]),
                parseMilliseconds = function(part) {
                    part = part || "";
                    return timePart(part) * Math.pow(10, MILLISECOND_LENGHT - part.length)
                },
                millisecond = parseMilliseconds(parts[11]);
            if (parts[12]) {
                return new Date(Date.UTC(year, month, day, hour, minute, second, millisecond))
            }
            return new Date(year, month, day, hour, minute, second, millisecond)
        };
        var getIso8601Format = function(text, useUtc) {
            var parts = text.match(ISO8601_PATTERN),
                result = "";
            if (!parts) {
                parts = text.match(ISO8601_TIME_PATTERN);
                if (parts) {
                    return parts[3] ? "HH:mm:ss" : "HH:mm"
                }
                return
            }
            for (var i = 1; i < ISO8601_PATTERN_PARTS.length; i++) {
                if (parts[i]) {
                    result += ISO8601_PATTERN_PARTS[i] || parts[i]
                }
            }
            if ("Z" === parts[12]) {
                result += "'Z'"
            }
            if (parts[14]) {
                if (parts[15]) {
                    result += "xxx"
                } else {
                    if (parts[16]) {
                        result += "xx"
                    } else {
                        result += "x"
                    }
                }
            }
            return result
        };
        var deserializeDate = function(value) {
            if ("number" === typeof value) {
                return new Date(value)
            }
            return dateParser(value, !config().forceIsoDateParsing)
        };
        var serializeDate = function(value, serializationFormat) {
            if (!serializationFormat) {
                return value
            }
            if (!isDate(value)) {
                return null
            }
            if (serializationFormat === NUMBER_SERIALIZATION_FORMAT) {
                return value && value.valueOf ? value.valueOf() : null
            }
            return getLDMLFormatter(serializationFormat, defaultDateNames)(value)
        };
        var getDateSerializationFormat = function(value) {
            if ("number" === typeof value) {
                return NUMBER_SERIALIZATION_FORMAT
            } else {
                if (isString(value)) {
                    var format;
                    if (config().forceIsoDateParsing) {
                        format = getIso8601Format(value)
                    }
                    if (format) {
                        return format
                    } else {
                        if (value.indexOf(":") >= 0) {
                            return DATETIME_SERIALIZATION_FORMAT
                        } else {
                            return DATE_SERIALIZATION_FORMAT
                        }
                    }
                } else {
                    if (value) {
                        return null
                    }
                }
            }
        };
        module.exports = {
            dateParser: dateParser,
            deserializeDate: deserializeDate,
            serializeDate: serializeDate,
            getDateSerializationFormat: getDateSerializationFormat
        }
    },
    /*!****************************************************************!*\
      !*** ./artifacts/transpiled/core/utils/dependency_injector.js ***!
      \****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        module.exports = function(object) {
            var extend = __webpack_require__( /*! ./extend */ 0).extend,
                isFunction = __webpack_require__( /*! ./type */ 1).isFunction,
                each = __webpack_require__( /*! ./iterator */ 3).each,
                Class = __webpack_require__( /*! ../class */ 15);
            var BaseClass = Class.inherit(object),
                InjectedClass = BaseClass,
                instance = new InjectedClass(object),
                initialFields = {};
            var injectFields = function(injectionObject, initial) {
                each(injectionObject, function(key) {
                    if (isFunction(instance[key])) {
                        if (initial || !object[key]) {
                            object[key] = function() {
                                return instance[key].apply(object, arguments)
                            }
                        }
                    } else {
                        if (initial) {
                            initialFields[key] = object[key]
                        }
                        object[key] = instance[key]
                    }
                })
            };
            injectFields(object, true);
            object.inject = function(injectionObject) {
                InjectedClass = InjectedClass.inherit(injectionObject);
                instance = new InjectedClass;
                injectFields(injectionObject)
            };
            object.resetInjection = function() {
                extend(object, initialFields);
                InjectedClass = BaseClass;
                instance = new BaseClass
            };
            return object
        }
    },
    /*!********************************!*\
      !*** external "window.jQuery" ***!
      \********************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports) {
        module.exports = window.jQuery
    },
    /*!***************************************************************!*\
      !*** ./artifacts/transpiled/ui/html_editor/quill_importer.js ***!
      \***************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        exports.getQuill = void 0;
        var _ui = __webpack_require__( /*! ../widget/ui.errors */ 18);
        var _ui2 = _interopRequireDefault(_ui);
        var _window = __webpack_require__( /*! ../../core/utils/window */ 7);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var Quill = void 0;

        function getQuill() {
            if (!Quill) {
                Quill = requestQuill()
            }
            return Quill
        }

        function requestQuill() {
            var window = (0, _window.getWindow)();
            var quill = window && window.Quill || __webpack_require__( /*! quill */ 575);
            if (!quill) {
                throw _ui2.default.Error("E1041", "Quill")
            }
            return quill
        }
        exports.getQuill = getQuill
    },
    /*!********************************************!*\
      !*** ./artifacts/transpiled/ui/overlay.js ***!
      \********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        module.exports = __webpack_require__( /*! ./overlay/ui.overlay */ 478)
    },
    /*!****************************!*\
      !*** external "window.ko" ***!
      \****************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports) {
        module.exports = window.ko
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/core/utils/call_once.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var callOnce = function(handler) {
            var result;
            var _wrappedHandler = function() {
                result = handler.apply(this, arguments);
                _wrappedHandler = function() {
                    return result
                };
                return result
            };
            return function() {
                return _wrappedHandler.apply(this, arguments)
            }
        };
        module.exports = callOnce
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/core/utils/ajax.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Deferred = __webpack_require__( /*! ./deferred */ 6).Deferred;
        var domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 13);
        var httpRequest = __webpack_require__( /*! ../../core/http_request */ 453);
        var windowUtils = __webpack_require__( /*! ../../core/utils/window */ 7);
        var window = windowUtils.getWindow();
        var extendFromObject = __webpack_require__( /*! ./extend */ 0).extendFromObject;
        var isDefined = __webpack_require__( /*! ./type */ 1).isDefined;
        var Promise = __webpack_require__( /*! ../polyfills/promise */ 66);
        var injector = __webpack_require__( /*! ./dependency_injector */ 56);
        var SUCCESS = "success",
            ERROR = "error",
            TIMEOUT = "timeout",
            NO_CONTENT = "nocontent",
            PARSER_ERROR = "parsererror";
        var isStatusSuccess = function(status) {
            return 200 <= status && status < 300
        };
        var hasContent = function(status) {
            return 204 !== status
        };
        var paramsConvert = function(params) {
            var result = [];
            for (var name in params) {
                var value = params[name];
                if (void 0 === value) {
                    continue
                }
                if (null === value) {
                    value = ""
                }
                result.push(encodeURIComponent(name) + "=" + encodeURIComponent(value))
            }
            return result.join("&")
        };
        var createScript = function(options) {
            var script = domAdapter.createElement("script");
            for (var name in options) {
                script[name] = options[name]
            }
            return script
        };
        var removeScript = function(scriptNode) {
            scriptNode.parentNode.removeChild(scriptNode)
        };
        var appendToHead = function(element) {
            return domAdapter.getHead().appendChild(element)
        };
        var evalScript = function(code) {
            var script = createScript({
                text: code
            });
            appendToHead(script);
            removeScript(script)
        };
        var evalCrossDomainScript = function(url) {
            var script = createScript({
                src: url
            });
            return new Promise(function(resolve, reject) {
                var events = {
                    load: resolve,
                    error: reject
                };
                var loadHandler = function(e) {
                    events[e.type]();
                    removeScript(script)
                };
                for (var event in events) {
                    domAdapter.listen(script, event, loadHandler)
                }
                appendToHead(script)
            })
        };
        var getAcceptHeader = function(options) {
            var dataType = options.dataType || "*",
                scriptAccept = "text/javascript, application/javascript, application/ecmascript, application/x-ecmascript",
                accepts = {
                    "*": "*/*",
                    text: "text/plain",
                    html: "text/html",
                    xml: "application/xml, text/xml",
                    json: "application/json, text/javascript",
                    jsonp: scriptAccept,
                    script: scriptAccept
                };
            extendFromObject(accepts, options.accepts, true);
            return accepts[dataType] ? accepts[dataType] + ("*" !== dataType ? ", */*; q=0.01" : "") : accepts["*"]
        };
        var getContentTypeHeader = function(options) {
            var defaultContentType;
            if (options.data && !options.upload && "GET" !== getMethod(options)) {
                defaultContentType = "application/x-www-form-urlencoded;charset=utf-8"
            }
            return options.contentType || defaultContentType
        };
        var getDataFromResponse = function(xhr) {
            return xhr.responseType && "text" !== xhr.responseType || "string" !== typeof xhr.responseText ? xhr.response : xhr.responseText
        };
        var postProcess = function(deferred, xhr, dataType) {
            var data = getDataFromResponse(xhr);
            switch (dataType) {
                case "jsonp":
                    evalScript(data);
                    break;
                case "script":
                    evalScript(data);
                    deferred.resolve(data, SUCCESS, xhr);
                    break;
                case "json":
                    try {
                        deferred.resolve(JSON.parse(data), SUCCESS, xhr)
                    } catch (e) {
                        deferred.reject(xhr, PARSER_ERROR, e)
                    }
                    break;
                default:
                    deferred.resolve(data, SUCCESS, xhr)
            }
        };
        var isCrossDomain = function(url) {
            if (!windowUtils.hasWindow()) {
                return true
            }
            var crossDomain = false,
                originAnchor = domAdapter.createElement("a"),
                urlAnchor = domAdapter.createElement("a");
            originAnchor.href = window.location.href;
            try {
                urlAnchor.href = url;
                urlAnchor.href = urlAnchor.href;
                crossDomain = originAnchor.protocol + "//" + originAnchor.host !== urlAnchor.protocol + "//" + urlAnchor.host
            } catch (e) {
                crossDomain = true
            }
            return crossDomain
        };
        var setHttpTimeout = function(timeout, xhr) {
            return timeout && setTimeout(function() {
                xhr.customStatus = TIMEOUT;
                xhr.abort()
            }, timeout)
        };
        var getJsonpOptions = function(options) {
            if ("jsonp" === options.dataType) {
                var random = Math.random().toString().replace(/\D/g, ""),
                    callbackName = options.jsonpCallback || "dxCallback" + Date.now() + "_" + random,
                    callbackParameter = options.jsonp || "callback";
                options.data = options.data || {};
                options.data[callbackParameter] = callbackName;
                return callbackName
            }
        };
        var getRequestOptions = function(options, headers) {
            var params = options.data,
                paramsAlreadyString = "string" === typeof params,
                url = options.url || window.location.href;
            if (!paramsAlreadyString && !options.cache) {
                params = params || {};
                params._ = Date.now()
            }
            if (params && !options.upload) {
                if (!paramsAlreadyString) {
                    params = paramsConvert(params)
                }
                if ("GET" === getMethod(options)) {
                    if ("" !== params) {
                        url += (url.indexOf("?") > -1 ? "&" : "?") + params
                    }
                    params = null
                } else {
                    if (headers["Content-Type"] && headers["Content-Type"].indexOf("application/x-www-form-urlencoded") > -1) {
                        params = params.replace(/%20/g, "+")
                    }
                }
            }
            return {
                url: url,
                parameters: params
            }
        };
        var getMethod = function(options) {
            return (options.method || "GET").toUpperCase()
        };
        var getRequestHeaders = function(options) {
            var headers = options.headers || {};
            headers["Content-Type"] = headers["Content-Type"] || getContentTypeHeader(options);
            headers.Accept = headers.Accept || getAcceptHeader(options);
            if (!options.crossDomain && !headers["X-Requested-With"]) {
                headers["X-Requested-With"] = "XMLHttpRequest"
            }
            return headers
        };
        var sendRequest = function(options) {
            var timeoutId, xhr = httpRequest.getXhr(),
                d = new Deferred,
                result = d.promise(),
                async = isDefined(options.async) ? options.async : true, dataType = options.dataType, timeout = options.timeout || 0;
            options.crossDomain = isCrossDomain(options.url);
            var needScriptEvaluation = "jsonp" === dataType || "script" === dataType;
            if (void 0 === options.cache) {
                options.cache = !needScriptEvaluation
            }
            var callbackName = getJsonpOptions(options),
                headers = getRequestHeaders(options),
                requestOptions = getRequestOptions(options, headers),
                url = requestOptions.url,
                parameters = requestOptions.parameters;
            if (callbackName) {
                window[callbackName] = function(data) {
                    d.resolve(data, SUCCESS, xhr)
                }
            }
            if (options.crossDomain && needScriptEvaluation) {
                var reject = function() {
                        d.reject(xhr, ERROR)
                    },
                    resolve = function() {
                        if ("jsonp" === dataType) {
                            return
                        }
                        d.resolve(null, SUCCESS, xhr)
                    };
                evalCrossDomainScript(url).then(resolve, reject);
                return result
            }
            if (options.crossDomain && !("withCredentials" in xhr)) {
                d.reject(xhr, ERROR);
                return result
            }
            xhr.open(getMethod(options), url, async, options.username, options.password);
            if (async) {
                xhr.timeout = timeout;
                timeoutId = setHttpTimeout(timeout, xhr, d)
            }
            xhr.onreadystatechange = function(e) {
                if (4 === xhr.readyState) {
                    clearTimeout(timeoutId);
                    if (isStatusSuccess(xhr.status)) {
                        if (hasContent(xhr.status)) {
                            postProcess(d, xhr, dataType)
                        } else {
                            d.resolve(null, NO_CONTENT, xhr)
                        }
                    } else {
                        d.reject(xhr, xhr.customStatus || ERROR)
                    }
                }
            };
            if (options.upload) {
                xhr.upload.onprogress = options.upload.onprogress;
                xhr.upload.onloadstart = options.upload.onloadstart;
                xhr.upload.onabort = options.upload.onabort
            }
            if (options.xhrFields) {
                for (var field in options.xhrFields) {
                    xhr[field] = options.xhrFields[field]
                }
            }
            if ("arraybuffer" === options.responseType) {
                xhr.responseType = options.responseType
            }
            for (var name in headers) {
                if (Object.prototype.hasOwnProperty.call(headers, name) && isDefined(headers[name])) {
                    xhr.setRequestHeader(name, headers[name])
                }
            }
            if (options.beforeSend) {
                options.beforeSend(xhr)
            }
            xhr.send(parameters);
            result.abort = function() {
                xhr.abort()
            };
            return result
        };
        module.exports = injector({
            sendRequest: sendRequest
        })
    },
    /*!***********************************************!*\
      !*** ./artifacts/transpiled/format_helper.js ***!
      \***********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var typeUtils = __webpack_require__( /*! ./core/utils/type */ 1),
            dateUtils = __webpack_require__( /*! ./core/utils/date */ 22),
            numberLocalization = __webpack_require__( /*! ./localization/number */ 51),
            dateLocalization = __webpack_require__( /*! ./localization/date */ 33),
            dependencyInjector = __webpack_require__( /*! ./core/utils/dependency_injector */ 56);
        __webpack_require__( /*! ./localization/currency */ 125);
        module.exports = dependencyInjector({
            format: function(value, _format) {
                var formatIsValid = typeUtils.isString(_format) && "" !== _format || typeUtils.isPlainObject(_format) || typeUtils.isFunction(_format),
                    valueIsValid = typeUtils.isNumeric(value) || typeUtils.isDate(value);
                if (!formatIsValid || !valueIsValid) {
                    return typeUtils.isDefined(value) ? value.toString() : ""
                }
                if (typeUtils.isFunction(_format)) {
                    return _format(value)
                }
                if (typeUtils.isString(_format)) {
                    _format = {
                        type: _format
                    }
                }
                if (typeUtils.isNumeric(value)) {
                    return numberLocalization.format(value, _format)
                }
                if (typeUtils.isDate(value)) {
                    return dateLocalization.format(value, _format)
                }
            },
            getTimeFormat: function(showSecond) {
                return showSecond ? "longtime" : "shorttime"
            },
            _normalizeFormat: function(format) {
                if (!Array.isArray(format)) {
                    return format
                }
                if (1 === format.length) {
                    return format[0]
                }
                return function(date) {
                    return format.map(function(formatPart) {
                        return dateLocalization.format(date, formatPart)
                    }).join(" ")
                }
            },
            getDateFormatByDifferences: function(dateDifferences, intervalFormat) {
                var resultFormat = [],
                    needSpecialSecondFormatter = intervalFormat && dateDifferences.millisecond && !(dateDifferences.year || dateDifferences.month || dateDifferences.day);
                if (needSpecialSecondFormatter) {
                    var secondFormatter = function(date) {
                        return date.getSeconds() + date.getMilliseconds() / 1e3 + "s"
                    };
                    resultFormat.push(secondFormatter)
                } else {
                    if (dateDifferences.millisecond) {
                        resultFormat.push("millisecond")
                    }
                }
                if (dateDifferences.hour || dateDifferences.minute || !needSpecialSecondFormatter && dateDifferences.second) {
                    resultFormat.unshift(this.getTimeFormat(dateDifferences.second))
                }
                if (dateDifferences.year && dateDifferences.month && dateDifferences.day) {
                    if (intervalFormat && "month" === intervalFormat) {
                        return "monthandyear"
                    } else {
                        resultFormat.unshift("shortdate");
                        return this._normalizeFormat(resultFormat)
                    }
                }
                if (dateDifferences.year && dateDifferences.month) {
                    return "monthandyear"
                }
                if (dateDifferences.year && dateDifferences.quarter) {
                    return "quarterandyear"
                }
                if (dateDifferences.year) {
                    return "year"
                }
                if (dateDifferences.quarter) {
                    return "quarter"
                }
                if (dateDifferences.month && dateDifferences.day) {
                    if (intervalFormat) {
                        var monthDayFormatter = function(date) {
                            return dateLocalization.getMonthNames("abbreviated")[date.getMonth()] + " " + dateLocalization.format(date, "day")
                        };
                        resultFormat.unshift(monthDayFormatter)
                    } else {
                        resultFormat.unshift("monthandday")
                    }
                    return this._normalizeFormat(resultFormat)
                }
                if (dateDifferences.month) {
                    return "month"
                }
                if (dateDifferences.day) {
                    if (intervalFormat) {
                        resultFormat.unshift("day")
                    } else {
                        var dayFormatter = function(date) {
                            return dateLocalization.format(date, "dayofweek") + ", " + dateLocalization.format(date, "day")
                        };
                        resultFormat.unshift(dayFormatter)
                    }
                    return this._normalizeFormat(resultFormat)
                }
                return this._normalizeFormat(resultFormat)
            },
            getDateFormatByTicks: function(ticks) {
                var resultFormat, maxDiff, currentDiff, i;
                if (ticks.length > 1) {
                    maxDiff = dateUtils.getDatesDifferences(ticks[0], ticks[1]);
                    for (i = 1; i < ticks.length - 1; i++) {
                        currentDiff = dateUtils.getDatesDifferences(ticks[i], ticks[i + 1]);
                        if (maxDiff.count < currentDiff.count) {
                            maxDiff = currentDiff
                        }
                    }
                } else {
                    maxDiff = {
                        year: true,
                        month: true,
                        day: true,
                        hour: ticks[0].getHours() > 0,
                        minute: ticks[0].getMinutes() > 0,
                        second: ticks[0].getSeconds() > 0,
                        millisecond: ticks[0].getMilliseconds() > 0
                    }
                }
                resultFormat = this.getDateFormatByDifferences(maxDiff);
                return resultFormat
            },
            getDateFormatByTickInterval: function(startValue, endValue, tickInterval) {
                var resultFormat, dateDifferences, dateUnitInterval, dateDifferencesConverter = {
                        week: "day"
                    },
                    correctDateDifferences = function(dateDifferences, tickInterval, value) {
                        switch (tickInterval) {
                            case "year":
                            case "quarter":
                                dateDifferences.month = value;
                            case "month":
                                dateDifferences.day = value;
                            case "week":
                            case "day":
                                dateDifferences.hour = value;
                            case "hour":
                                dateDifferences.minute = value;
                            case "minute":
                                dateDifferences.second = value;
                            case "second":
                                dateDifferences.millisecond = value
                        }
                    },
                    correctDifferencesByMaxDate = function(differences, minDate, maxDate) {
                        if (!maxDate.getMilliseconds() && maxDate.getSeconds()) {
                            if (maxDate.getSeconds() - minDate.getSeconds() === 1) {
                                differences.millisecond = true;
                                differences.second = false
                            }
                        } else {
                            if (!maxDate.getSeconds() && maxDate.getMinutes()) {
                                if (maxDate.getMinutes() - minDate.getMinutes() === 1) {
                                    differences.second = true;
                                    differences.minute = false
                                }
                            } else {
                                if (!maxDate.getMinutes() && maxDate.getHours()) {
                                    if (maxDate.getHours() - minDate.getHours() === 1) {
                                        differences.minute = true;
                                        differences.hour = false
                                    }
                                } else {
                                    if (!maxDate.getHours() && maxDate.getDate() > 1) {
                                        if (maxDate.getDate() - minDate.getDate() === 1) {
                                            differences.hour = true;
                                            differences.day = false
                                        }
                                    } else {
                                        if (1 === maxDate.getDate() && maxDate.getMonth()) {
                                            if (maxDate.getMonth() - minDate.getMonth() === 1) {
                                                differences.day = true;
                                                differences.month = false
                                            }
                                        } else {
                                            if (!maxDate.getMonth() && maxDate.getFullYear()) {
                                                if (maxDate.getFullYear() - minDate.getFullYear() === 1) {
                                                    differences.month = true;
                                                    differences.year = false
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    };
                tickInterval = typeUtils.isString(tickInterval) ? tickInterval.toLowerCase() : tickInterval;
                dateDifferences = dateUtils.getDatesDifferences(startValue, endValue);
                if (startValue !== endValue) {
                    correctDifferencesByMaxDate(dateDifferences, startValue > endValue ? endValue : startValue, startValue > endValue ? startValue : endValue)
                }
                dateUnitInterval = dateUtils.getDateUnitInterval(dateDifferences);
                correctDateDifferences(dateDifferences, dateUnitInterval, true);
                dateUnitInterval = dateUtils.getDateUnitInterval(tickInterval || "second");
                correctDateDifferences(dateDifferences, dateUnitInterval, false);
                dateDifferences[dateDifferencesConverter[dateUnitInterval] || dateUnitInterval] = true;
                resultFormat = this.getDateFormatByDifferences(dateDifferences);
                return resultFormat
            }
        })
    },
    /*!******************************************************************!*\
      !*** ./artifacts/transpiled/core/templates/bindable_template.js ***!
      \******************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        exports.BindableTemplate = void 0;
        var _createClass = function() {
            function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                    var descriptor = props[i];
                    descriptor.enumerable = descriptor.enumerable || false;
                    descriptor.configurable = true;
                    if ("value" in descriptor) {
                        descriptor.writable = true
                    }
                    Object.defineProperty(target, descriptor.key, descriptor)
                }
            }
            return function(Constructor, protoProps, staticProps) {
                if (protoProps) {
                    defineProperties(Constructor.prototype, protoProps)
                }
                if (staticProps) {
                    defineProperties(Constructor, staticProps)
                }
                return Constructor
            }
        }();
        var _renderer = __webpack_require__( /*! ../renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _template_base = __webpack_require__( /*! ./template_base */ 73);
        var _events_engine = __webpack_require__( /*! ../../events/core/events_engine */ 5);
        var _remove_event = __webpack_require__( /*! ../remove_event */ 136);
        var _remove_event2 = _interopRequireDefault(_remove_event);
        var _type = __webpack_require__( /*! ../utils/type */ 1);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }

        function _possibleConstructorReturn(self, call) {
            if (!self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called")
            }
            return call && ("object" === typeof call || "function" === typeof call) ? call : self
        }

        function _inherits(subClass, superClass) {
            if ("function" !== typeof superClass && null !== superClass) {
                throw new TypeError("Super expression must either be null or a function, not " + typeof superClass)
            }
            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    enumerable: false,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) {
                Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass
            }
        }
        var watchChanges = function() {
            var globalWatch = function(data, watchMethod, callback) {
                return watchMethod(function() {
                    return data
                }, callback)
            };
            var fieldsWatch = function(data, watchMethod, fields, fieldsMap, callback) {
                var resolvedData = {};
                var missedFields = fields.slice();
                var watchHandlers = fields.map(function(name) {
                    var fieldGetter = fieldsMap[name];
                    return watchMethod(fieldGetter ? function() {
                        return fieldGetter(data)
                    } : function() {
                        return data[name]
                    }, function(value) {
                        resolvedData[name] = value;
                        if (missedFields.length) {
                            var index = missedFields.indexOf(name);
                            if (index >= 0) {
                                missedFields.splice(index, 1)
                            }
                        }
                        if (!missedFields.length) {
                            callback(resolvedData)
                        }
                    })
                });
                return function() {
                    watchHandlers.forEach(function(dispose) {
                        return dispose()
                    })
                }
            };
            return function(rawData, watchMethod, fields, fieldsMap, callback) {
                var fieldsDispose = void 0;
                var globalDispose = globalWatch(rawData, watchMethod, function(dataWithRawFields) {
                    fieldsDispose && fieldsDispose();
                    if ((0, _type.isPrimitive)(dataWithRawFields)) {
                        callback(dataWithRawFields);
                        return
                    }
                    fieldsDispose = fieldsWatch(dataWithRawFields, watchMethod, fields, fieldsMap, callback)
                });
                return function() {
                    fieldsDispose && fieldsDispose();
                    globalDispose && globalDispose()
                }
            }
        }();
        exports.BindableTemplate = function(_TemplateBase) {
            _inherits(BindableTemplate, _TemplateBase);

            function BindableTemplate(render, fields, watchMethod, fieldsMap) {
                _classCallCheck(this, BindableTemplate);
                var _this = _possibleConstructorReturn(this, (BindableTemplate.__proto__ || Object.getPrototypeOf(BindableTemplate)).call(this));
                _this._render = render;
                _this._fields = fields;
                _this._fieldsMap = fieldsMap || {};
                _this._watchMethod = watchMethod;
                return _this
            }
            _createClass(BindableTemplate, [{
                key: "_renderCore",
                value: function(options) {
                    var _this2 = this;
                    var $container = (0, _renderer2.default)(options.container);
                    var dispose = watchChanges(options.model, this._watchMethod, this._fields, this._fieldsMap, function(data) {
                        $container.empty();
                        _this2._render($container, data, options.model)
                    });
                    (0, _events_engine.on)($container, _remove_event2.default, dispose);
                    return $container.contents()
                }
            }]);
            return BindableTemplate
        }(_template_base.TemplateBase)
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/ui/widget/selectors.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 13);
        var _focusable = function(element, tabIndex) {
            if (!visible(element)) {
                return false
            }
            var nodeName = element.nodeName.toLowerCase(),
                isTabIndexNotNaN = !isNaN(tabIndex),
                isDisabled = element.disabled,
                isDefaultFocus = /^(input|select|textarea|button|object|iframe)$/.test(nodeName),
                isHyperlink = "a" === nodeName,
                isFocusable = true,
                isContentEditable = element.isContentEditable;
            if (isDefaultFocus || isContentEditable) {
                isFocusable = !isDisabled
            } else {
                if (isHyperlink) {
                    isFocusable = element.href || isTabIndexNotNaN
                } else {
                    isFocusable = isTabIndexNotNaN
                }
            }
            return isFocusable
        };
        var visible = function(element) {
            var $element = $(element);
            return $element.is(":visible") && "hidden" !== $element.css("visibility") && "hidden" !== $element.parents().css("visibility")
        };
        module.exports = {
            focusable: function(index, element) {
                return _focusable(element, $(element).attr("tabIndex"))
            },
            tabbable: function(index, element) {
                var tabIndex = $(element).attr("tabIndex");
                return (isNaN(tabIndex) || tabIndex >= 0) && _focusable(element, tabIndex)
            },
            focused: function($element) {
                var element = $($element).get(0);
                return domAdapter.getActiveElement() === element
            }
        }
    },
    /*!********************************************************!*\
      !*** ./artifacts/transpiled/core/polyfills/promise.js ***!
      \********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var deferredUtils = __webpack_require__( /*! ../../core/utils/deferred */ 6),
            windowUtils = __webpack_require__( /*! ../../core/utils/window */ 7),
            Deferred = deferredUtils.Deferred,
            when = deferredUtils.when,
            promise = windowUtils.hasWindow() ? windowUtils.getWindow().Promise : Promise;
        if (!promise) {
            promise = function(resolver) {
                var d = new Deferred;
                resolver(d.resolve.bind(this), d.reject.bind(this));
                return d.promise()
            };
            promise.resolve = function(val) {
                return (new Deferred).resolve(val).promise()
            };
            promise.reject = function(val) {
                return (new Deferred).reject(val).promise()
            };
            promise.all = function(promises) {
                return when.apply(this, promises).then(function() {
                    return [].slice.call(arguments)
                })
            }
        }
        module.exports = promise
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/events/drag.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            dataUtils = __webpack_require__( /*! ../core/element_data */ 40),
            wrapToArray = __webpack_require__( /*! ../core/utils/array */ 14).wrapToArray,
            inArray = __webpack_require__( /*! ../core/utils/array */ 14).inArray,
            iteratorUtils = __webpack_require__( /*! ../core/utils/iterator */ 3),
            contains = __webpack_require__( /*! ../core/utils/dom */ 11).contains,
            registerEvent = __webpack_require__( /*! ./core/event_registrator */ 71),
            eventUtils = __webpack_require__( /*! ./utils */ 9),
            GestureEmitter = __webpack_require__( /*! ./gesture/emitter.gesture */ 159),
            registerEmitter = __webpack_require__( /*! ./core/emitter_registrator */ 95);
        var DRAG_START_EVENT = "dxdragstart",
            DRAG_EVENT = "dxdrag",
            DRAG_END_EVENT = "dxdragend",
            DRAG_ENTER_EVENT = "dxdragenter",
            DRAG_LEAVE_EVENT = "dxdragleave",
            DROP_EVENT = "dxdrop",
            DX_DRAG_EVENTS_COUNT_KEY = "dxDragEventsCount";
        var knownDropTargets = [],
            knownDropTargetSelectors = [],
            knownDropTargetConfigs = [];
        var dropTargetRegistration = {
            setup: function(element, data) {
                var knownDropTarget = inArray(element, knownDropTargets) !== -1;
                if (!knownDropTarget) {
                    knownDropTargets.push(element);
                    knownDropTargetSelectors.push([]);
                    knownDropTargetConfigs.push(data || {})
                }
            },
            add: function(element, handleObj) {
                var index = inArray(element, knownDropTargets);
                this.updateEventsCounter(element, handleObj.type, 1);
                var selector = handleObj.selector;
                if (inArray(selector, knownDropTargetSelectors[index]) === -1) {
                    knownDropTargetSelectors[index].push(selector)
                }
            },
            updateEventsCounter: function(element, event, value) {
                if ([DRAG_ENTER_EVENT, DRAG_LEAVE_EVENT, DROP_EVENT].indexOf(event) > -1) {
                    var eventsCount = dataUtils.data(element, DX_DRAG_EVENTS_COUNT_KEY) || 0;
                    dataUtils.data(element, DX_DRAG_EVENTS_COUNT_KEY, Math.max(0, eventsCount + value))
                }
            },
            remove: function(element, handleObj) {
                this.updateEventsCounter(element, handleObj.type, -1)
            },
            teardown: function(element) {
                var handlersCount = dataUtils.data(element, DX_DRAG_EVENTS_COUNT_KEY);
                if (!handlersCount) {
                    var index = inArray(element, knownDropTargets);
                    knownDropTargets.splice(index, 1);
                    knownDropTargetSelectors.splice(index, 1);
                    knownDropTargetConfigs.splice(index, 1);
                    dataUtils.removeData(element, DX_DRAG_EVENTS_COUNT_KEY)
                }
            }
        };
        registerEvent(DRAG_ENTER_EVENT, dropTargetRegistration);
        registerEvent(DRAG_LEAVE_EVENT, dropTargetRegistration);
        registerEvent(DROP_EVENT, dropTargetRegistration);
        var getItemDelegatedTargets = function($element) {
            var dropTargetIndex = inArray($element.get(0), knownDropTargets),
                dropTargetSelectors = knownDropTargetSelectors[dropTargetIndex].filter(function(selector) {
                    return selector
                });
            var $delegatedTargets = $element.find(dropTargetSelectors.join(", "));
            if (inArray(void 0, knownDropTargetSelectors[dropTargetIndex]) !== -1) {
                $delegatedTargets = $delegatedTargets.add($element)
            }
            return $delegatedTargets
        };
        var getItemConfig = function($element) {
            var dropTargetIndex = inArray($element.get(0), knownDropTargets);
            return knownDropTargetConfigs[dropTargetIndex]
        };
        var getItemPosition = function(dropTargetConfig, $element) {
            if (dropTargetConfig.itemPositionFunc) {
                return dropTargetConfig.itemPositionFunc($element)
            } else {
                return $element.offset()
            }
        };
        var getItemSize = function(dropTargetConfig, $element) {
            if (dropTargetConfig.itemSizeFunc) {
                return dropTargetConfig.itemSizeFunc($element)
            }
            return {
                width: $element.get(0).getBoundingClientRect().width,
                height: $element.get(0).getBoundingClientRect().height
            }
        };
        var DragEmitter = GestureEmitter.inherit({
            ctor: function(element) {
                this.callBase(element);
                this.direction = "both"
            },
            _init: function(e) {
                this._initEvent = e
            },
            _start: function(e) {
                e = this._fireEvent(DRAG_START_EVENT, this._initEvent);
                this._maxLeftOffset = e.maxLeftOffset;
                this._maxRightOffset = e.maxRightOffset;
                this._maxTopOffset = e.maxTopOffset;
                this._maxBottomOffset = e.maxBottomOffset;
                var dropTargets = wrapToArray(e.targetElements || (null === e.targetElements ? [] : knownDropTargets));
                this._dropTargets = iteratorUtils.map(dropTargets, function(element) {
                    return $(element).get(0)
                })
            },
            _move: function(e) {
                var eventData = eventUtils.eventData(e),
                    dragOffset = this._calculateOffset(eventData);
                e = this._fireEvent(DRAG_EVENT, e, {
                    offset: dragOffset
                });
                this._processDropTargets(e);
                if (!e._cancelPreventDefault) {
                    e.preventDefault()
                }
            },
            _calculateOffset: function(eventData) {
                return {
                    x: this._calculateXOffset(eventData),
                    y: this._calculateYOffset(eventData)
                }
            },
            _calculateXOffset: function(eventData) {
                if ("vertical" !== this.direction) {
                    var offset = eventData.x - this._startEventData.x;
                    return this._fitOffset(offset, this._maxLeftOffset, this._maxRightOffset)
                }
                return 0
            },
            _calculateYOffset: function(eventData) {
                if ("horizontal" !== this.direction) {
                    var offset = eventData.y - this._startEventData.y;
                    return this._fitOffset(offset, this._maxTopOffset, this._maxBottomOffset)
                }
                return 0
            },
            _fitOffset: function(offset, minOffset, maxOffset) {
                if (null != minOffset) {
                    offset = Math.max(offset, -minOffset)
                }
                if (null != maxOffset) {
                    offset = Math.min(offset, maxOffset)
                }
                return offset
            },
            _processDropTargets: function(e) {
                var target = this._findDropTarget(e),
                    sameTarget = target === this._currentDropTarget;
                if (!sameTarget) {
                    this._fireDropTargetEvent(e, DRAG_LEAVE_EVENT);
                    this._currentDropTarget = target;
                    this._fireDropTargetEvent(e, DRAG_ENTER_EVENT)
                }
            },
            _fireDropTargetEvent: function(event, eventName) {
                if (!this._currentDropTarget) {
                    return
                }
                var eventData = {
                    type: eventName,
                    originalEvent: event,
                    draggingElement: this._$element.get(0),
                    target: this._currentDropTarget
                };
                eventUtils.fireEvent(eventData)
            },
            _findDropTarget: function(e) {
                var result, that = this;
                iteratorUtils.each(knownDropTargets, function(_, target) {
                    if (!that._checkDropTargetActive(target)) {
                        return
                    }
                    var $target = $(target);
                    iteratorUtils.each(getItemDelegatedTargets($target), function(_, delegatedTarget) {
                        var $delegatedTarget = $(delegatedTarget);
                        if (that._checkDropTarget(getItemConfig($target), $delegatedTarget, e)) {
                            result = delegatedTarget
                        }
                    })
                });
                return result
            },
            _checkDropTargetActive: function(target) {
                var active = false;
                iteratorUtils.each(this._dropTargets, function(_, activeTarget) {
                    active = active || activeTarget === target || contains(activeTarget, target);
                    return !active
                });
                return active
            },
            _checkDropTarget: function(config, $target, e) {
                var targetPosition = getItemPosition(config, $target);
                if (e.pageX < targetPosition.left) {
                    return false
                }
                if (e.pageY < targetPosition.top) {
                    return false
                }
                var targetSize = getItemSize(config, $target);
                if (e.pageX > targetPosition.left + targetSize.width) {
                    return false
                }
                if (e.pageY > targetPosition.top + targetSize.height) {
                    return false
                }
                if (config.checkDropTarget && !config.checkDropTarget($target)) {
                    return false
                }
                return $target
            },
            _end: function(e) {
                var eventData = eventUtils.eventData(e);
                this._fireEvent(DRAG_END_EVENT, e, {
                    offset: this._calculateOffset(eventData)
                });
                this._fireDropTargetEvent(e, DROP_EVENT);
                delete this._currentDropTarget
            }
        });
        registerEmitter({
            emitter: DragEmitter,
            events: [DRAG_START_EVENT, DRAG_EVENT, DRAG_END_EVENT]
        });
        exports.dropTargets = knownDropTargets;
        exports.move = DRAG_EVENT;
        exports.start = DRAG_START_EVENT;
        exports.end = DRAG_END_EVENT;
        exports.enter = DRAG_ENTER_EVENT;
        exports.leave = DRAG_LEAVE_EVENT;
        exports.drop = DROP_EVENT
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/data/array_store.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _utils = __webpack_require__( /*! ./utils */ 41);
        var _query = __webpack_require__( /*! ./query */ 42);
        var _query2 = _interopRequireDefault(_query);
        var _errors = __webpack_require__( /*! ./errors */ 37);
        var _abstract_store = __webpack_require__( /*! ./abstract_store */ 100);
        var _abstract_store2 = _interopRequireDefault(_abstract_store);
        var _array_utils = __webpack_require__( /*! ./array_utils */ 138);
        var _array_utils2 = _interopRequireDefault(_array_utils);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var ArrayStore = _abstract_store2.default.inherit({
            ctor: function(options) {
                if (Array.isArray(options)) {
                    options = {
                        data: options
                    }
                } else {
                    options = options || {}
                }
                this.callBase(options);
                var initialArray = options.data;
                if (initialArray && !Array.isArray(initialArray)) {
                    throw _errors.errors.Error("E4006")
                }
                this._array = initialArray || []
            },
            createQuery: function() {
                return (0, _query2.default)(this._array, {
                    errorHandler: this._errorHandler
                })
            },
            _byKeyImpl: function(key) {
                var index = _array_utils2.default.indexByKey(this, this._array, key);
                if (index === -1) {
                    return (0, _utils.rejectedPromise)(_errors.errors.Error("E4009"))
                }
                return (0, _utils.trivialPromise)(this._array[index])
            },
            _insertImpl: function(values) {
                return _array_utils2.default.insert(this, this._array, values)
            },
            _pushImpl: function(changes) {
                _array_utils2.default.applyBatch(this, this._array, changes)
            },
            _updateImpl: function(key, values) {
                return _array_utils2.default.update(this, this._array, key, values)
            },
            _removeImpl: function(key) {
                return _array_utils2.default.remove(this, this._array, key)
            },
            clear: function() {
                this.fireEvent("modifying");
                this._array = [];
                this.fireEvent("modified")
            }
        }, "array");
        module.exports = ArrayStore
    },
    /*!************************************************************!*\
      !*** ./artifacts/transpiled/ui/widget/utils.ink_ripple.js ***!
      \************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2);
        var INKRIPPLE_CLASS = "dx-inkripple",
            INKRIPPLE_WAVE_CLASS = "dx-inkripple-wave",
            INKRIPPLE_SHOWING_CLASS = "dx-inkripple-showing",
            INKRIPPLE_HIDING_CLASS = "dx-inkripple-hiding";
        var DEFAULT_WAVE_SIZE_COEFFICIENT = 2,
            MAX_WAVE_SIZE = 4e3,
            ANIMATION_DURATION = 300,
            HOLD_ANIMATION_DURATION = 1e3,
            DEFAULT_WAVE_INDEX = 0;
        var render = function(args) {
            args = args || {};
            if (void 0 === args.useHoldAnimation) {
                args.useHoldAnimation = true
            }
            var config = {
                waveSizeCoefficient: args.waveSizeCoefficient || DEFAULT_WAVE_SIZE_COEFFICIENT,
                isCentered: args.isCentered || false,
                wavesNumber: args.wavesNumber || 1,
                durations: getDurations(args.useHoldAnimation)
            };
            return {
                showWave: showWave.bind(this, config),
                hideWave: hideWave.bind(this, config)
            }
        };
        var getInkRipple = function(element) {
            var result = element.children("." + INKRIPPLE_CLASS);
            if (0 === result.length) {
                result = $("<div>").addClass(INKRIPPLE_CLASS).appendTo(element)
            }
            return result
        };
        var getWaves = function(element, wavesNumber) {
            var inkRipple = getInkRipple(element),
                result = inkRipple.children("." + INKRIPPLE_WAVE_CLASS).toArray();
            for (var i = result.length; i < wavesNumber; i++) {
                var $currentWave = $("<div>").appendTo(inkRipple).addClass(INKRIPPLE_WAVE_CLASS);
                result.push($currentWave[0])
            }
            return $(result)
        };
        var getWaveStyleConfig = function(args, config) {
            var left, top, element = config.element,
                elementWidth = element.outerWidth(),
                elementHeight = element.outerHeight(),
                elementDiagonal = parseInt(Math.sqrt(elementWidth * elementWidth + elementHeight * elementHeight)),
                waveSize = Math.min(MAX_WAVE_SIZE, parseInt(elementDiagonal * args.waveSizeCoefficient));
            if (args.isCentered) {
                left = (elementWidth - waveSize) / 2;
                top = (elementHeight - waveSize) / 2
            } else {
                var event = config.event,
                    position = config.element.offset(),
                    x = event.pageX - position.left,
                    y = event.pageY - position.top;
                left = x - waveSize / 2;
                top = y - waveSize / 2
            }
            return {
                left: left,
                top: top,
                height: waveSize,
                width: waveSize
            }
        };
        var showWave = function(args, config) {
            var $wave = getWaves(config.element, args.wavesNumber).eq(config.wave || DEFAULT_WAVE_INDEX);
            args.hidingTimeout && clearTimeout(args.hidingTimeout);
            hideSelectedWave($wave);
            $wave.css(getWaveStyleConfig(args, config));
            args.showingTimeout = setTimeout(showingWaveHandler.bind(this, args, $wave), 0)
        };
        var showingWaveHandler = function(args, $wave) {
            var durationCss = args.durations.showingScale + "ms";
            $wave.addClass(INKRIPPLE_SHOWING_CLASS).css("transitionDuration", durationCss)
        };
        var getDurations = function(useHoldAnimation) {
            return {
                showingScale: useHoldAnimation ? HOLD_ANIMATION_DURATION : ANIMATION_DURATION,
                hidingScale: ANIMATION_DURATION,
                hidingOpacity: ANIMATION_DURATION
            }
        };
        var hideSelectedWave = function($wave) {
            $wave.removeClass(INKRIPPLE_HIDING_CLASS).css("transitionDuration", "")
        };
        var hideWave = function(args, config) {
            args.showingTimeout && clearTimeout(args.showingTimeout);
            var $wave = getWaves(config.element, config.wavesNumber).eq(config.wave || DEFAULT_WAVE_INDEX),
                durations = args.durations,
                durationCss = durations.hidingScale + "ms, " + durations.hidingOpacity + "ms";
            $wave.addClass(INKRIPPLE_HIDING_CLASS).removeClass(INKRIPPLE_SHOWING_CLASS).css("transitionDuration", durationCss);
            var animationDuration = Math.max(durations.hidingScale, durations.hidingOpacity);
            args.hidingTimeout = setTimeout(hideSelectedWave.bind(this, $wave), animationDuration)
        };
        module.exports = {
            render: render
        }
    }, ,
    /*!***************************************************************!*\
      !*** ./artifacts/transpiled/events/core/event_registrator.js ***!
      \***************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var each = __webpack_require__( /*! ../../core/utils/iterator */ 3).each,
            callbacks = __webpack_require__( /*! ./event_registrator_callbacks */ 124);
        var registerEvent = function(name, eventObject) {
            var strategy = {};
            if ("noBubble" in eventObject) {
                strategy.noBubble = eventObject.noBubble
            }
            if ("bindType" in eventObject) {
                strategy.bindType = eventObject.bindType
            }
            if ("delegateType" in eventObject) {
                strategy.delegateType = eventObject.delegateType
            }
            each(["setup", "teardown", "add", "remove", "trigger", "handle", "_default", "dispose"], function(_, methodName) {
                if (!eventObject[methodName]) {
                    return
                }
                strategy[methodName] = function() {
                    var args = [].slice.call(arguments);
                    args.unshift(this);
                    return eventObject[methodName].apply(eventObject, args)
                }
            });
            callbacks.fire(name, strategy)
        };
        registerEvent.callbacks = callbacks;
        module.exports = registerEvent
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/core/utils/view_port.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../renderer */ 2),
            readyCallbacks = __webpack_require__( /*! ./ready_callbacks */ 48),
            ready = readyCallbacks.add,
            changeCallback = __webpack_require__( /*! ./callbacks */ 26)(),
            $originalViewPort = $();
        var value = function() {
            var $current;
            return function(element) {
                if (!arguments.length) {
                    return $current
                }
                var $element = $(element);
                $originalViewPort = $element;
                var isNewViewportFound = !!$element.length;
                var prevViewPort = value();
                $current = isNewViewportFound ? $element : $("body");
                changeCallback.fire(isNewViewportFound ? value() : $(), prevViewPort)
            }
        }();
        ready(function() {
            value(".dx-viewport")
        });
        exports.value = value;
        exports.changeCallback = changeCallback;
        exports.originalViewPort = function() {
            return $originalViewPort
        }
    },
    /*!**************************************************************!*\
      !*** ./artifacts/transpiled/core/templates/template_base.js ***!
      \**************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        exports.TemplateBase = exports.renderedCallbacks = void 0;
        var _createClass = function() {
            function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                    var descriptor = props[i];
                    descriptor.enumerable = descriptor.enumerable || false;
                    descriptor.configurable = true;
                    if ("value" in descriptor) {
                        descriptor.writable = true
                    }
                    Object.defineProperty(target, descriptor.key, descriptor)
                }
            }
            return function(Constructor, protoProps, staticProps) {
                if (protoProps) {
                    defineProperties(Constructor.prototype, protoProps)
                }
                if (staticProps) {
                    defineProperties(Constructor, staticProps)
                }
                return Constructor
            }
        }();
        var _renderer = __webpack_require__( /*! ../renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _dom_adapter = __webpack_require__( /*! ../dom_adapter */ 13);
        var _callbacks = __webpack_require__( /*! ../utils/callbacks */ 26);
        var _callbacks2 = _interopRequireDefault(_callbacks);
        var _dom = __webpack_require__( /*! ../utils/dom */ 11);
        var _errors = __webpack_require__( /*! ../errors */ 21);
        var _errors2 = _interopRequireDefault(_errors);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }
        var renderedCallbacks = exports.renderedCallbacks = (0, _callbacks2.default)({
            syncStrategy: true
        });
        exports.TemplateBase = function() {
            function TemplateBase() {
                _classCallCheck(this, TemplateBase)
            }
            _createClass(TemplateBase, [{
                key: "render",
                value: function(options) {
                    options = options || {};
                    var onRendered = options.onRendered;
                    delete options.onRendered;
                    var $result = this._renderCore(options);
                    this._ensureResultInContainer($result, options.container);
                    renderedCallbacks.fire($result, options.container);
                    onRendered && onRendered();
                    return $result
                }
            }, {
                key: "_ensureResultInContainer",
                value: function($result, container) {
                    if (!container) {
                        return
                    }
                    var $container = (0, _renderer2.default)(container);
                    var resultInContainer = (0, _dom.contains)($container.get(0), $result.get(0));
                    $container.append($result);
                    if (resultInContainer) {
                        return
                    }
                    var resultInBody = (0, _dom_adapter.getBody)().contains($container.get(0));
                    if (!resultInBody) {
                        return
                    }(0, _dom.triggerShownEvent)($result)
                }
            }, {
                key: "_renderCore",
                value: function() {
                    throw _errors2.default.Error("E0001")
                }
            }]);
            return TemplateBase
        }()
    },
    /*!***********************************!*\
      !*** external "window.Globalize" ***!
      \***********************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports) {
        module.exports = window.Globalize
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled/core/utils/console.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var isFunction = __webpack_require__( /*! ./type */ 1).isFunction;
        var noop = function() {};
        var getConsoleMethod = function(method) {
            if ("undefined" === typeof console || !isFunction(console[method])) {
                return noop
            }
            return console[method].bind(console)
        };
        var logger = {
            info: getConsoleMethod("info"),
            warn: getConsoleMethod("warn"),
            error: getConsoleMethod("error")
        };
        var debug = function() {
            function assert(condition, message) {
                if (!condition) {
                    throw new Error(message)
                }
            }

            function assertParam(parameter, message) {
                assert(null !== parameter && void 0 !== parameter, message)
            }
            return {
                assert: assert,
                assertParam: assertParam
            }
        }();
        exports.logger = logger;
        exports.debug = debug
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/ui/load_indicator.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            windowUtils = __webpack_require__( /*! ../core/utils/window */ 7),
            navigator = windowUtils.getNavigator(),
            support = __webpack_require__( /*! ../core/utils/support */ 44),
            themes = __webpack_require__( /*! ./themes */ 31),
            extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            devices = __webpack_require__( /*! ../core/devices */ 16),
            registerComponent = __webpack_require__( /*! ../core/component_registrator */ 8),
            Widget = __webpack_require__( /*! ./widget/ui.widget */ 17);
        var LOADINDICATOR_CLASS = "dx-loadindicator",
            LOADINDICATOR_WRAPPER_CLASS = "dx-loadindicator-wrapper",
            LOADINDICATOR_CONTENT_CLASS = "dx-loadindicator-content",
            LOADINDICATOR_ICON_CLASS = "dx-loadindicator-icon",
            LOADINDICATOR_SEGMENT_CLASS = "dx-loadindicator-segment",
            LOADINDICATOR_SEGMENT_INNER_CLASS = "dx-loadindicator-segment-inner",
            LOADINDICATOR_IMAGE_CLASS = "dx-loadindicator-image";
        var LoadIndicator = Widget.inherit({
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    indicatorSrc: "",
                    activeStateEnabled: false,
                    hoverStateEnabled: false,
                    _animatingSegmentCount: 1,
                    _animatingSegmentInner: false
                })
            },
            _defaultOptionsRules: function() {
                var themeName = themes.current();
                return this.callBase().concat([{
                    device: function() {
                        var realDevice = devices.real(),
                            obsoleteAndroid = "android" === realDevice.platform && !/chrome/i.test(navigator.userAgent);
                        return obsoleteAndroid
                    },
                    options: {
                        viaImage: true
                    }
                }, {
                    device: function() {
                        return themes.isIos7(themeName)
                    },
                    options: {
                        _animatingSegmentCount: 11
                    }
                }, {
                    device: function() {
                        return themes.isMaterial(themeName)
                    },
                    options: {
                        _animatingSegmentCount: 2,
                        _animatingSegmentInner: true
                    }
                }, {
                    device: function() {
                        return themes.isGeneric(themeName)
                    },
                    options: {
                        _animatingSegmentCount: 7
                    }
                }])
            },
            _init: function() {
                this.callBase();
                this.$element().addClass(LOADINDICATOR_CLASS)
            },
            _initMarkup: function() {
                this.callBase();
                this._renderWrapper();
                this._renderIndicatorContent();
                this._renderMarkup()
            },
            _renderWrapper: function() {
                this._$wrapper = $("<div>").addClass(LOADINDICATOR_WRAPPER_CLASS);
                this.$element().append(this._$wrapper)
            },
            _renderIndicatorContent: function() {
                this._$content = $("<div>").addClass(LOADINDICATOR_CONTENT_CLASS);
                this._$wrapper.append(this._$content)
            },
            _renderMarkup: function() {
                if (support.animation() && !this.option("viaImage") && !this.option("indicatorSrc")) {
                    this._renderMarkupForAnimation()
                } else {
                    this._renderMarkupForImage()
                }
            },
            _renderMarkupForAnimation: function() {
                var animatingSegmentInner = this.option("_animatingSegmentInner");
                this._$indicator = $("<div>").addClass(LOADINDICATOR_ICON_CLASS);
                this._$content.append(this._$indicator);
                for (var i = this.option("_animatingSegmentCount"); i >= 0; --i) {
                    var $segment = $("<div>").addClass(LOADINDICATOR_SEGMENT_CLASS).addClass(LOADINDICATOR_SEGMENT_CLASS + i);
                    if (animatingSegmentInner) {
                        $segment.append($("<div>").addClass(LOADINDICATOR_SEGMENT_INNER_CLASS))
                    }
                    this._$indicator.append($segment)
                }
            },
            _renderMarkupForImage: function() {
                var indicatorSrc = this.option("indicatorSrc");
                this._$wrapper.addClass(LOADINDICATOR_IMAGE_CLASS);
                if (indicatorSrc) {
                    this._$wrapper.css("backgroundImage", "url(" + indicatorSrc + ")")
                }
            },
            _renderDimensions: function() {
                this.callBase();
                this._updateContentSizeForAnimation()
            },
            _updateContentSizeForAnimation: function() {
                if (!this._$indicator) {
                    return
                }
                var width = this.option("width"),
                    height = this.option("height");
                if (width || height) {
                    width = this.$element().width();
                    height = this.$element().height();
                    var minDimension = Math.min(height, width);
                    this._$wrapper.css({
                        height: minDimension,
                        width: minDimension,
                        fontSize: minDimension
                    })
                }
            },
            _clean: function() {
                this.callBase();
                this._removeMarkupForAnimation();
                this._removeMarkupForImage()
            },
            _removeMarkupForAnimation: function() {
                if (!this._$indicator) {
                    return
                }
                this._$indicator.remove();
                delete this._$indicator
            },
            _removeMarkupForImage: function() {
                this._$wrapper.css("backgroundImage", "none")
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "_animatingSegmentCount":
                    case "_animatingSegmentInner":
                    case "indicatorSrc":
                        this._invalidate();
                        break;
                    default:
                        this.callBase(args)
                }
            }
        });
        registerComponent("dxLoadIndicator", LoadIndicator);
        module.exports = LoadIndicator
    },
    /*!*******************************************************************!*\
      !*** ./artifacts/transpiled/ui/pivot_grid/ui.pivot_grid.utils.js ***!
      \*******************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var _ajax = __webpack_require__( /*! ../../core/utils/ajax */ 62);
        var _data = __webpack_require__( /*! ../../core/utils/data */ 20);
        var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);
        var _date = __webpack_require__( /*! ../../localization/date */ 33);
        var _format_helper = __webpack_require__( /*! ../../format_helper */ 63);
        var _data_source = __webpack_require__( /*! ../../data/data_source/data_source */ 46);
        var _array_store = __webpack_require__( /*! ../../data/array_store */ 68);
        var _array_store2 = _interopRequireDefault(_array_store);
        var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 6);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var setFieldProperty = exports.setFieldProperty = function(field, property, value, isInitialization) {
            var initProperties = field._initProperties = field._initProperties || {},
                initValue = isInitialization ? value : field[property];
            if (!Object.prototype.hasOwnProperty.call(initProperties, property) || isInitialization) {
                initProperties[property] = initValue
            }
            field[property] = value
        };
        exports.sendRequest = function(options) {
            return (0, _ajax.sendRequest)(options)
        };
        var foreachTreeAsyncDate = new Date;

        function createForeachTreeFunc(isAsync) {
            var foreachTreeFunc = function foreachTreeFunc(items, callback, parentAtFirst, members, index, isChildrenProcessing) {
                members = members || [];
                items = items || [];
                var item, i, deferred, childrenDeferred;
                index = index || 0;

                function createForeachTreeAsyncHandler(deferred, i, isChildrenProcessing) {
                    (0, _deferred.when)(foreachTreeFunc(items, callback, parentAtFirst, members, i, isChildrenProcessing)).done(deferred.resolve)
                }
                for (i = index; i < items.length; i++) {
                    if (isAsync && i > index && i % 1e4 === 0 && new Date - foreachTreeAsyncDate >= 300) {
                        foreachTreeAsyncDate = new Date;
                        deferred = new _deferred.Deferred;
                        setTimeout(createForeachTreeAsyncHandler(deferred, i, false), 0);
                        return deferred
                    }
                    item = items[i];
                    if (!isChildrenProcessing) {
                        members.unshift(item);
                        if (parentAtFirst && false === callback(members, i)) {
                            return
                        }
                        if (item.children) {
                            childrenDeferred = foreachTreeFunc(item.children, callback, parentAtFirst, members);
                            if (isAsync && childrenDeferred) {
                                deferred = new _deferred.Deferred;
                                childrenDeferred.done(createForeachTreeAsyncHandler(deferred, i, true));
                                return deferred
                            }
                        }
                    }
                    isChildrenProcessing = false;
                    if (!parentAtFirst && false === callback(members, i)) {
                        return
                    }
                    members.shift();
                    if (items[i] !== item) {
                        i--
                    }
                }
            };
            return foreachTreeFunc
        }
        exports.foreachTree = createForeachTreeFunc(false);
        exports.foreachTreeAsync = createForeachTreeFunc(true);
        exports.findField = function(fields, id) {
            var i, field;
            if (fields && (0, _type.isDefined)(id)) {
                for (i = 0; i < fields.length; i++) {
                    field = fields[i];
                    if (field.name === id || field.caption === id || field.dataField === id || field.index === id) {
                        return i
                    }
                }
            }
            return -1
        };
        exports.formatValue = function(value, options) {
            var formatObject = {
                value: value,
                valueText: (0, _format_helper.format)(value, options.format) || ""
            };
            return options.customizeText ? options.customizeText.call(options, formatObject) : formatObject.valueText
        };
        exports.getCompareFunction = function(valueSelector) {
            return function(a, b) {
                var result = 0,
                    valueA = valueSelector(a),
                    valueB = valueSelector(b),
                    aIsDefined = (0, _type.isDefined)(valueA),
                    bIsDefined = (0, _type.isDefined)(valueB);
                if (aIsDefined && bIsDefined) {
                    if (valueA > valueB) {
                        result = 1
                    } else {
                        if (valueA < valueB) {
                            result = -1
                        }
                    }
                }
                if (aIsDefined && !bIsDefined) {
                    result = 1
                }
                if (!aIsDefined && bIsDefined) {
                    result = -1
                }
                return result
            }
        };
        exports.createPath = function(items) {
            var i, result = [];
            for (i = items.length - 1; i >= 0; i--) {
                result.push(items[i].key || items[i].value)
            }
            return result
        };
        exports.foreachDataLevel = function foreachDataLevel(data, callback, index, childrenField) {
            var item, i;
            index = index || 0;
            childrenField = childrenField || "children";
            if (data.length) {
                callback(data, index)
            }
            for (i = 0; i < data.length; i++) {
                item = data[i];
                if (item[childrenField] && item[childrenField].length) {
                    foreachDataLevel(item[childrenField], callback, index + 1, childrenField)
                }
            }
        };
        exports.mergeArraysByMaxValue = function(values1, values2) {
            var i, result = [];
            for (i = 0; i < values1.length; i++) {
                result.push(Math.max(values1[i] || 0, values2[i] || 0))
            }
            return result
        };
        exports.getExpandedLevel = function(options, axisName) {
            var dimensions = options[axisName],
                expandLevel = 0,
                expandedPaths = ("columns" === axisName ? options.columnExpandedPaths : options.rowExpandedPaths) || [];
            if (options.headerName === axisName) {
                expandLevel = options.path.length
            } else {
                if (options.headerName && options.headerName !== axisName && options.oppositePath) {
                    expandLevel = options.oppositePath.length
                } else {
                    (0, _iterator.each)(expandedPaths, function(_, path) {
                        expandLevel = Math.max(expandLevel, path.length)
                    })
                }
            }
            while (dimensions[expandLevel + 1] && dimensions[expandLevel].expanded) {
                expandLevel++
            }
            return expandLevel
        };

        function createGroupFields(item) {
            return (0, _iterator.map)(["year", "quarter", "month"], function(value, index) {
                return (0, _extend.extend)({}, item, {
                    groupInterval: value,
                    groupIndex: index
                })
            })
        }

        function parseFields(dataSource, fieldsList, path, fieldsDataType) {
            var result = [];
            (0, _iterator.each)(fieldsList || [], function(field, value) {
                if (field && 0 === field.indexOf("__")) {
                    return
                }
                var items, dataIndex = 1,
                    currentPath = path.length ? path + "." + field : field,
                    dataType = fieldsDataType[currentPath],
                    getter = (0, _data.compileGetter)(currentPath);
                while (!(0, _type.isDefined)(value) && dataSource[dataIndex]) {
                    value = getter(dataSource[dataIndex]);
                    dataIndex++
                }
                if (!dataType && (0, _type.isDefined)(value)) {
                    dataType = (0, _type.type)(value)
                }
                items = [{
                    dataField: currentPath,
                    dataType: dataType,
                    groupName: "date" === dataType ? field : void 0,
                    groupInterval: void 0,
                    displayFolder: path
                }];
                if ("date" === dataType) {
                    items = items.concat(createGroupFields(items[0]))
                } else {
                    if ("object" === dataType) {
                        items = parseFields(dataSource, value, currentPath, fieldsDataType)
                    }
                }
                result.push.apply(result, items)
            });
            return result
        }
        exports.discoverObjectFields = function(items, fields) {
            var fieldsDataType = exports.getFieldsDataType(fields);
            return parseFields(items, items[0], "", fieldsDataType)
        };
        exports.getFieldsDataType = function(fields) {
            var result = {};
            (0, _iterator.each)(fields, function(_, field) {
                result[field.dataField] = result[field.dataField] || field.dataType
            });
            return result
        };
        var DATE_INTERVAL_FORMATS = {
            month: function(value) {
                return (0, _date.getMonthNames)()[value - 1]
            },
            quarter: function(value) {
                return (0, _date.format)(new Date(2e3, 3 * value - 1), "quarter")
            },
            dayOfWeek: function(value) {
                return (0, _date.getDayNames)()[value]
            }
        };
        exports.setDefaultFieldValueFormatting = function(field) {
            if ("date" === field.dataType) {
                if (!field.format) {
                    setFieldProperty(field, "format", DATE_INTERVAL_FORMATS[field.groupInterval])
                }
            } else {
                if ("number" === field.dataType) {
                    var groupInterval = (0, _type.isNumeric)(field.groupInterval) && field.groupInterval > 0 && field.groupInterval;
                    if (groupInterval && !field.customizeText) {
                        setFieldProperty(field, "customizeText", function(formatObject) {
                            var secondValue = formatObject.value + groupInterval,
                                secondValueText = (0, _format_helper.format)(secondValue, field.format);
                            return formatObject.valueText && secondValueText ? formatObject.valueText + " - " + secondValueText : ""
                        })
                    }
                }
            }
        };
        exports.getFiltersByPath = function(fields, path) {
            var result = [];
            path = path || [];
            for (var i = 0; i < path.length; i++) {
                result.push((0, _extend.extend)({}, fields[i], {
                    groupIndex: null,
                    groupName: null,
                    filterType: "include",
                    filterValues: [path[i]]
                }))
            }
            return result
        };
        exports.storeDrillDownMixin = {
            createDrillDownDataSource: function(descriptions, params) {
                function createCustomStoreMethod(methodName) {
                    return function(options) {
                        var d;
                        if (arrayStore) {
                            d = arrayStore[methodName](options)
                        } else {
                            d = new _deferred.Deferred;
                            (0, _deferred.when)(items).done(function(data) {
                                arrayStore = new _array_store2.default(data);
                                arrayStore[methodName](options).done(d.resolve).fail(d.reject)
                            }).fail(d.reject)
                        }
                        return d
                    }
                }
                var arrayStore, items = this.getDrillDownItems(descriptions, params),
                    dataSource = new _data_source.DataSource({
                        load: createCustomStoreMethod("load"),
                        totalCount: createCustomStoreMethod("totalCount"),
                        key: this.key()
                    });
                return dataSource
            }
        };
        exports.capitalizeFirstLetter = function(string) {
            return string.charAt(0).toUpperCase() + string.slice(1)
        }
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled/animation/position.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            commonUtils = __webpack_require__( /*! ../core/utils/common */ 4),
            each = __webpack_require__( /*! ../core/utils/iterator */ 3).each,
            windowUtils = __webpack_require__( /*! ../core/utils/window */ 7),
            window = windowUtils.getWindow(),
            domAdapter = __webpack_require__( /*! ../core/dom_adapter */ 13),
            isWindow = __webpack_require__( /*! ../core/utils/type */ 1).isWindow,
            extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            browser = __webpack_require__( /*! ../core/utils/browser */ 25),
            translator = __webpack_require__( /*! ./translator */ 27),
            support = __webpack_require__( /*! ../core/utils/support */ 44);
        var horzRe = /left|right/,
            vertRe = /top|bottom/,
            collisionRe = /fit|flip|none/,
            IS_SAFARI = browser.safari;
        var normalizeAlign = function(raw) {
            var result = {
                h: "center",
                v: "center"
            };
            var pair = commonUtils.splitPair(raw);
            if (pair) {
                each(pair, function() {
                    var w = String(this).toLowerCase();
                    if (horzRe.test(w)) {
                        result.h = w
                    } else {
                        if (vertRe.test(w)) {
                            result.v = w
                        }
                    }
                })
            }
            return result
        };
        var normalizeOffset = function(raw) {
            return commonUtils.pairToObject(raw)
        };
        var normalizeCollision = function(raw) {
            var pair = commonUtils.splitPair(raw),
                h = String(pair && pair[0]).toLowerCase(),
                v = String(pair && pair[1]).toLowerCase();
            if (!collisionRe.test(h)) {
                h = "none"
            }
            if (!collisionRe.test(v)) {
                v = h
            }
            return {
                h: h,
                v: v
            }
        };
        var getAlignFactor = function(align) {
            switch (align) {
                case "center":
                    return .5;
                case "right":
                case "bottom":
                    return 1;
                default:
                    return 0
            }
        };
        var inverseAlign = function(align) {
            switch (align) {
                case "left":
                    return "right";
                case "right":
                    return "left";
                case "top":
                    return "bottom";
                case "bottom":
                    return "top";
                default:
                    return align
            }
        };
        var calculateOversize = function(data, bounds) {
            var oversize = 0;
            if (data.myLocation < bounds.min) {
                oversize += bounds.min - data.myLocation
            }
            if (data.myLocation > bounds.max) {
                oversize += data.myLocation - bounds.max
            }
            return oversize
        };
        var collisionSide = function(direction, data, bounds) {
            if (data.myLocation < bounds.min) {
                return "h" === direction ? "left" : "top"
            }
            if (data.myLocation > bounds.max) {
                return "h" === direction ? "right" : "bottom"
            }
            return "none"
        };
        var initMyLocation = function(data) {
            data.myLocation = data.atLocation + getAlignFactor(data.atAlign) * data.atSize - getAlignFactor(data.myAlign) * data.mySize + data.offset
        };
        var collisionResolvers = {
            fit: function(data, bounds) {
                var result = false;
                if (data.myLocation > bounds.max) {
                    data.myLocation = bounds.max;
                    result = true
                }
                if (data.myLocation < bounds.min) {
                    data.myLocation = bounds.min;
                    result = true
                }
                data.fit = result
            },
            flip: function(data, bounds) {
                data.flip = false;
                if ("center" === data.myAlign && "center" === data.atAlign) {
                    return
                }
                if (data.myLocation < bounds.min || data.myLocation > bounds.max) {
                    var inverseData = extend({}, data, {
                        myAlign: inverseAlign(data.myAlign),
                        atAlign: inverseAlign(data.atAlign),
                        offset: -data.offset
                    });
                    initMyLocation(inverseData);
                    inverseData.oversize = calculateOversize(inverseData, bounds);
                    if (inverseData.myLocation >= bounds.min && inverseData.myLocation <= bounds.max || data.oversize > inverseData.oversize) {
                        data.myLocation = inverseData.myLocation;
                        data.oversize = inverseData.oversize;
                        data.flip = true
                    }
                }
            },
            flipfit: function(data, bounds) {
                this.flip(data, bounds);
                this.fit(data, bounds)
            },
            none: function(data) {
                data.oversize = 0
            }
        };
        var scrollbarWidth;
        var calculateScrollbarWidth = function() {
            var $scrollDiv = $("<div>").css({
                    width: 100,
                    height: 100,
                    overflow: "scroll",
                    position: "absolute",
                    top: -9999
                }).appendTo($("body")),
                result = $scrollDiv.get(0).offsetWidth - $scrollDiv.get(0).clientWidth;
            $scrollDiv.remove();
            scrollbarWidth = result
        };
        var defaultPositionResult = {
            h: {
                location: 0,
                flip: false,
                fit: false,
                oversize: 0
            },
            v: {
                location: 0,
                flip: false,
                fit: false,
                oversize: 0
            }
        };
        var calculatePosition = function(what, options) {
            var $what = $(what),
                currentOffset = $what.offset(),
                result = extend(true, {}, defaultPositionResult, {
                    h: {
                        location: currentOffset.left
                    },
                    v: {
                        location: currentOffset.top
                    }
                });
            if (!options) {
                return result
            }
            var my = normalizeAlign(options.my),
                at = normalizeAlign(options.at),
                of = $(options.of).length && options.of || window,
                offset = normalizeOffset(options.offset),
                collision = normalizeCollision(options.collision),
                boundary = options.boundary,
                boundaryOffset = normalizeOffset(options.boundaryOffset);
            var h = {
                mySize: $what.outerWidth(),
                myAlign: my.h,
                atAlign: at.h,
                offset: offset.h,
                collision: collision.h,
                boundaryOffset: boundaryOffset.h
            };
            var v = {
                mySize: $what.outerHeight(),
                myAlign: my.v,
                atAlign: at.v,
                offset: offset.v,
                collision: collision.v,
                boundaryOffset: boundaryOffset.v
            };
            if ( of .preventDefault) {
                h.atLocation = of .pageX;
                v.atLocation = of .pageY;
                h.atSize = 0;
                v.atSize = 0
            } else {
                of = $( of );
                if (isWindow( of [0])) {
                    h.atLocation = of .scrollLeft();
                    v.atLocation = of .scrollTop();
                    h.atSize = of [0].innerWidth >= of [0].outerWidth ? of [0].innerWidth : of .width();
                    v.atSize = of [0].innerHeight >= of [0].outerHeight || IS_SAFARI ? of [0].innerHeight : of .height()
                } else {
                    if (9 === of [0].nodeType) {
                        h.atLocation = 0;
                        v.atLocation = 0;
                        h.atSize = of .width();
                        v.atSize = of .height()
                    } else {
                        var o = of .offset();
                        h.atLocation = o.left;
                        v.atLocation = o.top;
                        h.atSize = of .outerWidth();
                        v.atSize = of .outerHeight()
                    }
                }
            }
            initMyLocation(h);
            initMyLocation(v);
            var bounds = function() {
                var win = $(window),
                    windowWidth = win.width(),
                    windowHeight = win.height(),
                    left = win.scrollLeft(),
                    top = win.scrollTop(),
                    documentElement = domAdapter.getDocumentElement(),
                    hZoomLevel = support.touch ? documentElement.clientWidth / windowWidth : 1,
                    vZoomLevel = support.touch ? documentElement.clientHeight / windowHeight : 1;
                if (void 0 === scrollbarWidth) {
                    calculateScrollbarWidth()
                }
                var boundaryWidth = windowWidth,
                    boundaryHeight = windowHeight;
                if (boundary) {
                    var $boundary = $(boundary),
                        boundaryPosition = $boundary.offset();
                    left = boundaryPosition.left;
                    top = boundaryPosition.top;
                    boundaryWidth = $boundary.width();
                    boundaryHeight = $boundary.height()
                }
                return {
                    h: {
                        min: left + h.boundaryOffset,
                        max: left + boundaryWidth / hZoomLevel - h.mySize - h.boundaryOffset
                    },
                    v: {
                        min: top + v.boundaryOffset,
                        max: top + boundaryHeight / vZoomLevel - v.mySize - v.boundaryOffset
                    }
                }
            }();
            h.oversize = calculateOversize(h, bounds.h);
            v.oversize = calculateOversize(v, bounds.v);
            h.collisionSide = collisionSide("h", h, bounds.h);
            v.collisionSide = collisionSide("v", v, bounds.v);
            if (collisionResolvers[h.collision]) {
                collisionResolvers[h.collision](h, bounds.h)
            }
            if (collisionResolvers[v.collision]) {
                collisionResolvers[v.collision](v, bounds.v)
            }
            var preciser = function(number) {
                return options.precise ? number : Math.round(number)
            };
            extend(true, result, {
                h: {
                    location: preciser(h.myLocation),
                    oversize: preciser(h.oversize),
                    fit: h.fit,
                    flip: h.flip,
                    collisionSide: h.collisionSide
                },
                v: {
                    location: preciser(v.myLocation),
                    oversize: preciser(v.oversize),
                    fit: v.fit,
                    flip: v.flip,
                    collisionSide: v.collisionSide
                },
                precise: options.precise
            });
            return result
        };
        var position = function(what, options) {
            var $what = $(what);
            if (!options) {
                return $what.offset()
            }
            translator.resetPosition($what, true);
            var offset = $what.offset(),
                targetPosition = options.h && options.v ? options : calculatePosition($what, options);
            var preciser = function(number) {
                return options.precise ? number : Math.round(number)
            };
            translator.move($what, {
                left: targetPosition.h.location - preciser(offset.left),
                top: targetPosition.v.location - preciser(offset.top)
            });
            return targetPosition
        };
        var offset = function(element) {
            element = $(element).get(0);
            if (isWindow(element)) {
                return null
            } else {
                if (element && "pageY" in element && "pageX" in element) {
                    return {
                        top: element.pageY,
                        left: element.pageX
                    }
                }
            }
            return $(element).offset()
        };
        if (!position.inverseAlign) {
            position.inverseAlign = inverseAlign
        }
        if (!position.normalizeAlign) {
            position.normalizeAlign = normalizeAlign
        }
        module.exports = {
            calculateScrollbarWidth: calculateScrollbarWidth,
            calculate: calculatePosition,
            setup: position,
            offset: offset
        }
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/data_helper.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var DataSource = __webpack_require__( /*! ./data/data_source/data_source */ 46).DataSource,
            extend = __webpack_require__( /*! ./core/utils/extend */ 0).extend,
            normalizeDataSourceOptions = __webpack_require__( /*! ./data/data_source/data_source */ 46).normalizeDataSourceOptions;
        var DATA_SOURCE_OPTIONS_METHOD = "_dataSourceOptions",
            DATA_SOURCE_CHANGED_METHOD = "_dataSourceChangedHandler",
            DATA_SOURCE_LOAD_ERROR_METHOD = "_dataSourceLoadErrorHandler",
            DATA_SOURCE_LOADING_CHANGED_METHOD = "_dataSourceLoadingChangedHandler",
            DATA_SOURCE_FROM_URL_LOAD_MODE_METHOD = "_dataSourceFromUrlLoadMode",
            SPECIFIC_DATA_SOURCE_OPTION = "_getSpecificDataSourceOption";
        var DataHelperMixin = {
            postCtor: function() {
                this.on("disposing", function() {
                    this._disposeDataSource()
                }.bind(this))
            },
            _refreshDataSource: function() {
                this._initDataSource();
                this._loadDataSource()
            },
            _initDataSource: function() {
                var widgetDataSourceOptions, dataSourceType, dataSourceOptions = SPECIFIC_DATA_SOURCE_OPTION in this ? this[SPECIFIC_DATA_SOURCE_OPTION]() : this.option("dataSource");
                this._disposeDataSource();
                if (dataSourceOptions) {
                    if (dataSourceOptions instanceof DataSource) {
                        this._isSharedDataSource = true;
                        this._dataSource = dataSourceOptions
                    } else {
                        widgetDataSourceOptions = DATA_SOURCE_OPTIONS_METHOD in this ? this[DATA_SOURCE_OPTIONS_METHOD]() : {};
                        dataSourceType = this._dataSourceType ? this._dataSourceType() : DataSource;
                        dataSourceOptions = normalizeDataSourceOptions(dataSourceOptions, {
                            fromUrlLoadMode: DATA_SOURCE_FROM_URL_LOAD_MODE_METHOD in this && this[DATA_SOURCE_FROM_URL_LOAD_MODE_METHOD]()
                        });
                        this._dataSource = new dataSourceType(extend(true, {}, widgetDataSourceOptions, dataSourceOptions))
                    }
                    this._addDataSourceHandlers()
                }
            },
            _addDataSourceHandlers: function() {
                if (DATA_SOURCE_CHANGED_METHOD in this) {
                    this._addDataSourceChangeHandler()
                }
                if (DATA_SOURCE_LOAD_ERROR_METHOD in this) {
                    this._addDataSourceLoadErrorHandler()
                }
                if (DATA_SOURCE_LOADING_CHANGED_METHOD in this) {
                    this._addDataSourceLoadingChangedHandler()
                }
                this._addReadyWatcher()
            },
            _addReadyWatcher: function() {
                this._dataSource.on("loadingChanged", function(isLoading) {
                    this._ready && this._ready(!isLoading)
                }.bind(this))
            },
            _addDataSourceChangeHandler: function() {
                var dataSource = this._dataSource;
                this._proxiedDataSourceChangedHandler = function(e) {
                    this[DATA_SOURCE_CHANGED_METHOD](dataSource.items(), e)
                }.bind(this);
                dataSource.on("changed", this._proxiedDataSourceChangedHandler)
            },
            _addDataSourceLoadErrorHandler: function() {
                this._proxiedDataSourceLoadErrorHandler = this[DATA_SOURCE_LOAD_ERROR_METHOD].bind(this);
                this._dataSource.on("loadError", this._proxiedDataSourceLoadErrorHandler)
            },
            _addDataSourceLoadingChangedHandler: function() {
                this._proxiedDataSourceLoadingChangedHandler = this[DATA_SOURCE_LOADING_CHANGED_METHOD].bind(this);
                this._dataSource.on("loadingChanged", this._proxiedDataSourceLoadingChangedHandler)
            },
            _loadDataSource: function() {
                if (this._dataSource) {
                    var dataSource = this._dataSource;
                    if (dataSource.isLoaded()) {
                        this._proxiedDataSourceChangedHandler && this._proxiedDataSourceChangedHandler()
                    } else {
                        dataSource.load()
                    }
                }
            },
            _loadSingle: function(key, value) {
                key = "this" === key ? this._dataSource.key() || "this" : key;
                return this._dataSource.loadSingle(key, value)
            },
            _isLastPage: function() {
                return !this._dataSource || this._dataSource.isLastPage() || !this._dataSource._pageSize
            },
            _isDataSourceLoading: function() {
                return this._dataSource && this._dataSource.isLoading()
            },
            _disposeDataSource: function() {
                if (this._dataSource) {
                    if (this._isSharedDataSource) {
                        delete this._isSharedDataSource;
                        this._proxiedDataSourceChangedHandler && this._dataSource.off("changed", this._proxiedDataSourceChangedHandler);
                        this._proxiedDataSourceLoadErrorHandler && this._dataSource.off("loadError", this._proxiedDataSourceLoadErrorHandler);
                        this._proxiedDataSourceLoadingChangedHandler && this._dataSource.off("loadingChanged", this._proxiedDataSourceLoadingChangedHandler)
                    } else {
                        this._dataSource.dispose()
                    }
                    delete this._dataSource;
                    delete this._proxiedDataSourceChangedHandler;
                    delete this._proxiedDataSourceLoadErrorHandler;
                    delete this._proxiedDataSourceLoadingChangedHandler
                }
            },
            getDataSource: function() {
                return this._dataSource || null
            }
        };
        module.exports = DataHelperMixin
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/localization/core.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _dependency_injector = __webpack_require__( /*! ../core/utils/dependency_injector */ 56);
        var _dependency_injector2 = _interopRequireDefault(_dependency_injector);
        var _parent_locales = __webpack_require__( /*! ./cldr-data/parent_locales */ 442);
        var _parent_locales2 = _interopRequireDefault(_parent_locales);
        var _parentLocale = __webpack_require__( /*! ./parentLocale */ 443);
        var _parentLocale2 = _interopRequireDefault(_parentLocale);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var DEFAULT_LOCALE = "en";
        module.exports = (0, _dependency_injector2.default)({
            locale: function() {
                var currentLocale = DEFAULT_LOCALE;
                return function(locale) {
                    if (!locale) {
                        return currentLocale
                    }
                    currentLocale = locale
                }
            }(),
            getValueByClosestLocale: function(getter) {
                var locale = this.locale();
                var value = getter(locale);
                var isRootLocale = void 0;
                while (!value && !isRootLocale) {
                    locale = (0, _parentLocale2.default)(_parent_locales2.default, locale);
                    if (locale) {
                        value = getter(locale)
                    } else {
                        isRootLocale = true
                    }
                }
                if (void 0 === value && locale !== DEFAULT_LOCALE) {
                    return getter(DEFAULT_LOCALE)
                }
                return value
            }
        })
    },
    /*!*****************************************************************!*\
      !*** ./artifacts/transpiled/exporter/excel/excel.tag_helper.js ***!
      \*****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        var _type = __webpack_require__( /*! ../../core/utils/type */ 1);
        var tagHelper = {
            toXml: function(tagName, attributes, content) {
                var result = ["<", tagName];
                for (var attributeName in attributes) {
                    var attributeValue = attributes[attributeName];
                    if ((0, _type.isDefined)(attributeValue)) {
                        result.push(" ", attributeName, '="', attributeValue, '"')
                    }
                }
                if ((0, _type.isDefined)(content) && "" !== content) {
                    result.push(">", content, "</", tagName, ">")
                } else {
                    result.push(" />")
                }
                return result.join("")
            }
        };
        exports.default = tagHelper
    },
    /*!***************************************************************!*\
      !*** ./artifacts/transpiled/integration/jquery/use_jquery.js ***!
      \***************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var jQuery = __webpack_require__( /*! jquery */ 57);
        var config = __webpack_require__( /*! ../../core/config */ 29);
        var useJQuery = config().useJQuery;
        if (jQuery && false !== useJQuery) {
            config({
                useJQuery: true
            })
        }
        module.exports = function() {
            return jQuery && config().useJQuery
        }
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/data/store_helper.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var grep = __webpack_require__( /*! ../core/utils/common */ 4).grep,
            extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            each = __webpack_require__( /*! ../core/utils/iterator */ 3).each,
            arrayQuery = __webpack_require__( /*! ./array_query */ 156),
            normalizeSortingInfo = __webpack_require__( /*! ./utils */ 41).normalizeSortingInfo;

        function multiLevelGroup(query, groupInfo) {
            query = query.groupBy(groupInfo[0].selector);
            if (groupInfo.length > 1) {
                query = query.select(function(g) {
                    return extend({}, g, {
                        items: multiLevelGroup(arrayQuery(g.items), groupInfo.slice(1)).toArray()
                    })
                })
            }
            return query
        }

        function arrangeSortingInfo(groupInfo, sortInfo) {
            var filteredGroup = [];
            each(groupInfo, function(_, group) {
                var collision = grep(sortInfo, function(sort) {
                    return group.selector === sort.selector
                });
                if (collision.length < 1) {
                    filteredGroup.push(group)
                }
            });
            return filteredGroup.concat(sortInfo)
        }

        function queryByOptions(query, options, isCountQuery) {
            options = options || {};
            var filter = options.filter;
            if (filter) {
                query = query.filter(filter)
            }
            if (isCountQuery) {
                return query
            }
            var sort = options.sort,
                select = options.select,
                group = options.group,
                skip = options.skip,
                take = options.take;
            if (group) {
                group = normalizeSortingInfo(group);
                group.keepInitialKeyOrder = !!options.group.keepInitialKeyOrder
            }
            if (sort || group) {
                sort = normalizeSortingInfo(sort || []);
                if (group && !group.keepInitialKeyOrder) {
                    sort = arrangeSortingInfo(group, sort)
                }
                each(sort, function(index) {
                    query = query[index ? "thenBy" : "sortBy"](this.selector, this.desc, this.compare)
                })
            }
            if (select) {
                query = query.select(select)
            }
            if (group) {
                query = multiLevelGroup(query, group)
            }
            if (take || skip) {
                query = query.slice(skip || 0, take)
            }
            return query
        }
        module.exports = {
            multiLevelGroup: multiLevelGroup,
            arrangeSortingInfo: arrangeSortingInfo,
            queryByOptions: queryByOptions
        }
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled/core/dom_component.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _renderer = __webpack_require__( /*! ../core/renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _events_engine = __webpack_require__( /*! ../events/core/events_engine */ 5);
        var _events_engine2 = _interopRequireDefault(_events_engine);
        var _window = __webpack_require__( /*! ../core/utils/window */ 7);
        var _window2 = _interopRequireDefault(_window);
        var _extend = __webpack_require__( /*! ./utils/extend */ 0);
        var _config = __webpack_require__( /*! ./config */ 29);
        var _config2 = _interopRequireDefault(_config);
        var _errors = __webpack_require__( /*! ./errors */ 21);
        var _errors2 = _interopRequireDefault(_errors);
        var _dom = __webpack_require__( /*! ../core/utils/dom */ 11);
        var _resize_callbacks = __webpack_require__( /*! ../core/utils/resize_callbacks */ 134);
        var _resize_callbacks2 = _interopRequireDefault(_resize_callbacks);
        var _common = __webpack_require__( /*! ./utils/common */ 4);
        var _common2 = _interopRequireDefault(_common);
        var _iterator = __webpack_require__( /*! ./utils/iterator */ 3);
        var _type = __webpack_require__( /*! ./utils/type */ 1);
        var _array = __webpack_require__( /*! ./utils/array */ 14);
        var _public_component = __webpack_require__( /*! ./utils/public_component */ 135);
        var _public_component2 = _interopRequireDefault(_public_component);
        var _element_data = __webpack_require__( /*! ./element_data */ 40);
        var _element_data2 = _interopRequireDefault(_element_data);
        var _component = __webpack_require__( /*! ./component */ 112);
        var _component2 = _interopRequireDefault(_component);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var abstract = _component2.default.abstract;
        var RTL_DIRECTION_CLASS = "dx-rtl";
        var VISIBILITY_CHANGE_CLASS = "dx-visibility-change-handler";
        var VISIBILITY_CHANGE_EVENTNAMESPACE = "VisibilityChange";
        var DOMComponent = _component2.default.inherit({
            _getDefaultOptions: function() {
                return (0, _extend.extend)(this.callBase(), {
                    width: void 0,
                    height: void 0,
                    rtlEnabled: (0, _config2.default)().rtlEnabled,
                    elementAttr: {},
                    disabled: false,
                    integrationOptions: {}
                })
            },
            ctor: function(element, options) {
                this._$element = (0, _renderer2.default)(element);
                _public_component2.default.attachInstanceToElement(this._$element, this, this._dispose);
                this.callBase(options)
            },
            _getSynchronizableOptionsForCreateComponent: function() {
                return ["rtlEnabled", "disabled", "templatesRenderAsynchronously"]
            },
            _visibilityChanged: abstract,
            _dimensionChanged: abstract,
            _init: function() {
                this.callBase();
                this._attachWindowResizeCallback()
            },
            _setOptionsByDevice: function(instanceCustomRules) {
                this.callBase([].concat(this.constructor._classCustomRules || [], instanceCustomRules || []))
            },
            _isInitialOptionValue: function(name) {
                var isCustomOption = this.constructor._classCustomRules && Object.prototype.hasOwnProperty.call(this._convertRulesToOptions(this.constructor._classCustomRules), name);
                return !isCustomOption && this.callBase(name)
            },
            _attachWindowResizeCallback: function() {
                if (this._isDimensionChangeSupported()) {
                    var windowResizeCallBack = this._windowResizeCallBack = this._dimensionChanged.bind(this);
                    _resize_callbacks2.default.add(windowResizeCallBack)
                }
            },
            _isDimensionChangeSupported: function() {
                return this._dimensionChanged !== abstract
            },
            _renderComponent: function() {
                this._initMarkup();
                if (_window2.default.hasWindow()) {
                    this._render()
                }
            },
            _initMarkup: function() {
                this._renderElementAttributes();
                this._toggleRTLDirection(this.option("rtlEnabled"));
                this._renderVisibilityChange();
                this._renderDimensions()
            },
            _render: function() {
                this._attachVisibilityChangeHandlers()
            },
            _renderElementAttributes: function() {
                var attributes = (0, _extend.extend)({}, this.option("elementAttr")),
                    classNames = attributes.class;
                delete attributes.class;
                this.$element().attr(attributes).addClass(classNames)
            },
            _renderVisibilityChange: function() {
                if (this._isDimensionChangeSupported()) {
                    this._attachDimensionChangeHandlers()
                }
                if (!this._isVisibilityChangeSupported()) {
                    return
                }
                this.$element().addClass(VISIBILITY_CHANGE_CLASS)
            },
            _renderDimensions: function() {
                var $element = this.$element();
                var element = $element.get(0);
                var width = this._getOptionValue("width", element);
                var height = this._getOptionValue("height", element);
                if (this._isCssUpdateRequired(element, height, width)) {
                    $element.css({
                        width: width,
                        height: height
                    })
                }
            },
            _isCssUpdateRequired: function(element, height, width) {
                return !!(width || height || element.style.width || element.style.height)
            },
            _attachDimensionChangeHandlers: function() {
                var that = this;
                var resizeEventName = "dxresize." + this.NAME + VISIBILITY_CHANGE_EVENTNAMESPACE;
                _events_engine2.default.off(that.$element(), resizeEventName);
                _events_engine2.default.on(that.$element(), resizeEventName, function() {
                    that._dimensionChanged()
                })
            },
            _attachVisibilityChangeHandlers: function() {
                if (!this._isVisibilityChangeSupported()) {
                    return
                }
                var that = this;
                var hidingEventName = "dxhiding." + this.NAME + VISIBILITY_CHANGE_EVENTNAMESPACE;
                var shownEventName = "dxshown." + this.NAME + VISIBILITY_CHANGE_EVENTNAMESPACE;
                that._isHidden = !that._isVisible();
                _events_engine2.default.off(that.$element(), hidingEventName);
                _events_engine2.default.on(that.$element(), hidingEventName, function() {
                    that._checkVisibilityChanged("hiding")
                });
                _events_engine2.default.off(that.$element(), shownEventName);
                _events_engine2.default.on(that.$element(), shownEventName, function() {
                    that._checkVisibilityChanged("shown")
                })
            },
            _isVisible: function() {
                return this.$element().is(":visible")
            },
            _checkVisibilityChanged: function(event) {
                if ("hiding" === event && this._isVisible() && !this._isHidden) {
                    this._visibilityChanged(false);
                    this._isHidden = true
                } else {
                    if ("shown" === event && this._isVisible() && this._isHidden) {
                        this._isHidden = false;
                        this._visibilityChanged(true)
                    }
                }
            },
            _isVisibilityChangeSupported: function() {
                return this._visibilityChanged !== abstract && _window2.default.hasWindow()
            },
            _clean: _common2.default.noop,
            _modelByElement: function() {
                var modelByElement = this.option("modelByElement") || _common2.default.noop;
                return modelByElement(this.$element())
            },
            _invalidate: function() {
                if (!this._updateLockCount) {
                    throw _errors2.default.Error("E0007")
                }
                this._requireRefresh = true
            },
            _refresh: function() {
                this._clean();
                this._renderComponent()
            },
            _dispose: function() {
                this.callBase();
                this._clean();
                this._detachWindowResizeCallback()
            },
            _detachWindowResizeCallback: function() {
                if (this._isDimensionChangeSupported()) {
                    _resize_callbacks2.default.remove(this._windowResizeCallBack)
                }
            },
            _toggleRTLDirection: function(rtl) {
                this.$element().toggleClass(RTL_DIRECTION_CLASS, rtl)
            },
            _createComponent: function(element, component, config) {
                var _this = this;
                var that = this;
                config = config || {};
                var synchronizableOptions = _common2.default.grep(this._getSynchronizableOptionsForCreateComponent(), function(value) {
                    return !(value in config)
                });
                var nestedComponentOptions = that.option("nestedComponentOptions") || _common2.default.noop;
                var nestedComponentConfig = (0, _extend.extend)({
                    integrationOptions: this.option("integrationOptions")
                }, nestedComponentOptions(this));
                synchronizableOptions.forEach(function(optionName) {
                    nestedComponentConfig[optionName] = _this.option(optionName)
                });
                that._extendConfig(config, nestedComponentConfig);
                var instance;
                if ((0, _type.isString)(component)) {
                    var $element = (0, _renderer2.default)(element)[component](config);
                    instance = $element[component]("instance")
                } else {
                    if (element) {
                        instance = component.getInstance(element);
                        if (instance) {
                            instance.option(config)
                        } else {
                            instance = new component(element, config)
                        }
                    }
                }
                if (instance) {
                    var optionChangedHandler = function(args) {
                        if ((0, _array.inArray)(args.name, synchronizableOptions) >= 0) {
                            instance.option(args.name, args.value)
                        }
                    };
                    that.on("optionChanged", optionChangedHandler);
                    instance.on("disposing", function() {
                        that.off("optionChanged", optionChangedHandler)
                    })
                }
                return instance
            },
            _extendConfig: function(config, extendConfig) {
                (0, _iterator.each)(extendConfig, function(key, value) {
                    config[key] = Object.prototype.hasOwnProperty.call(config, key) ? config[key] : value
                })
            },
            _defaultActionConfig: function() {
                return (0, _extend.extend)(this.callBase(), {
                    context: this._modelByElement(this.$element())
                })
            },
            _defaultActionArgs: function() {
                var model = this._modelByElement(this.$element());
                return (0, _extend.extend)(this.callBase(), {
                    element: this.element(),
                    model: model
                })
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "width":
                    case "height":
                        this._renderDimensions();
                        break;
                    case "rtlEnabled":
                        this._invalidate();
                        break;
                    case "elementAttr":
                        this._renderElementAttributes();
                        break;
                    case "disabled":
                    case "integrationOptions":
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _removeAttributes: function(element) {
                var i = element.attributes.length - 1;
                for (; i >= 0; i--) {
                    var attribute = element.attributes[i];
                    if (!attribute) {
                        return
                    }
                    var attributeName = attribute.name;
                    if (0 === attributeName.indexOf("aria-") || attributeName.indexOf("dx-") !== -1 || "role" === attributeName || "style" === attributeName || "tabindex" === attributeName) {
                        element.removeAttribute(attributeName)
                    }
                }
            },
            _removeClasses: function(element) {
                var classes = element.className.split(" ").filter(function(cssClass) {
                    return 0 !== cssClass.lastIndexOf("dx-", 0)
                });
                element.className = classes.join(" ")
            },
            endUpdate: function() {
                var requireRender = !this._initializing && !this._initialized;
                this.callBase.apply(this, arguments);
                if (!this._updateLockCount) {
                    if (requireRender) {
                        this._renderComponent()
                    } else {
                        if (this._requireRefresh) {
                            this._requireRefresh = false;
                            this._refresh()
                        }
                    }
                }
            },
            $element: function() {
                return this._$element
            },
            element: function() {
                return (0, _dom.getPublicElement)(this.$element())
            },
            dispose: function() {
                var element = this.$element().get(0);
                _element_data2.default.cleanDataRecursive(element, true);
                element.textContent = "";
                this._removeAttributes(element);
                this._removeClasses(element)
            }
        });
        DOMComponent.getInstance = function(element) {
            return _public_component2.default.getInstanceByElement((0, _renderer2.default)(element), this)
        };
        DOMComponent.defaultOptions = function(rule) {
            this._classCustomRules = this._classCustomRules || [];
            this._classCustomRules.push(rule)
        };
        module.exports = DOMComponent
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/events_mixin.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var DefaultEventsStrategy = __webpack_require__( /*! ./events_strategy */ 458),
            each = __webpack_require__( /*! ./utils/iterator */ 3).each,
            isPlainObject = __webpack_require__( /*! ./utils/type */ 1).isPlainObject;
        module.exports = {
            ctor: function() {
                this._events = {};
                this.setEventsStrategy(new DefaultEventsStrategy(this))
            },
            setEventsStrategy: function(strategy) {
                if ("function" === typeof strategy) {
                    strategy = strategy(this)
                }
                this._eventsStrategy = strategy
            },
            hasEvent: function(eventName) {
                return this._eventsStrategy.hasEvent(eventName)
            },
            fireEvent: function(eventName, eventArgs) {
                this._eventsStrategy.fireEvent(eventName, eventArgs);
                return this
            },
            on: function(eventName, eventHandler) {
                if (isPlainObject(eventName)) {
                    each(eventName, function(e, h) {
                        this.on(e, h)
                    }.bind(this))
                } else {
                    this._eventsStrategy.on(eventName, eventHandler)
                }
                return this
            },
            off: function(eventName, eventHandler) {
                this._eventsStrategy.off(eventName, eventHandler);
                return this
            },
            _disposeEvents: function() {
                this._eventsStrategy.dispose()
            }
        }
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/core/utils/style.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var camelize = __webpack_require__( /*! ./inflector */ 32).camelize,
            callOnce = __webpack_require__( /*! ./call_once */ 61),
            typeUtils = __webpack_require__( /*! ./type */ 1),
            domAdapter = __webpack_require__( /*! ../dom_adapter */ 13);
        var jsPrefixes = ["", "Webkit", "Moz", "O", "Ms"],
            cssPrefixes = {
                "": "",
                Webkit: "-webkit-",
                Moz: "-moz-",
                O: "-o-",
                ms: "-ms-"
            },
            getStyles = callOnce(function() {
                return domAdapter.createElement("dx").style
            });
        var forEachPrefixes = function(prop, callBack) {
            prop = camelize(prop, true);
            var result;
            for (var i = 0, cssPrefixesCount = jsPrefixes.length; i < cssPrefixesCount; i++) {
                var jsPrefix = jsPrefixes[i];
                var prefixedProp = jsPrefix + prop;
                var lowerPrefixedProp = camelize(prefixedProp);
                result = callBack(lowerPrefixedProp, jsPrefix);
                if (void 0 === result) {
                    result = callBack(prefixedProp, jsPrefix)
                }
                if (void 0 !== result) {
                    break
                }
            }
            return result || ""
        };
        var styleProp = function(name) {
            if (name in getStyles()) {
                return name
            }
            var originalName = name;
            name = name.charAt(0).toUpperCase() + name.substr(1);
            for (var i = 1; i < jsPrefixes.length; i++) {
                var prefixedProp = jsPrefixes[i].toLowerCase() + name;
                if (prefixedProp in getStyles()) {
                    return prefixedProp
                }
            }
            return originalName
        };
        var stylePropPrefix = function(prop) {
            return forEachPrefixes(prop, function(specific, jsPrefix) {
                if (specific in getStyles()) {
                    return cssPrefixes[jsPrefix]
                }
            })
        };
        var pxExceptions = ["fillOpacity", "columnCount", "flexGrow", "flexShrink", "fontWeight", "lineHeight", "opacity", "zIndex", "zoom"];
        var normalizeStyleProp = function(prop, value) {
            if (typeUtils.isNumeric(value) && pxExceptions.indexOf(prop) === -1) {
                value += "px"
            }
            return value
        };
        var setDimensionProperty = function(elements, propertyName, value) {
            if (elements) {
                value = typeUtils.isNumeric(value) ? value += "px" : value;
                for (var i = 0; i < elements.length; ++i) {
                    elements[i].style[propertyName] = value
                }
            }
        };
        var setWidth = function(elements, value) {
            setDimensionProperty(elements, "width", value)
        };
        var setHeight = function(elements, value) {
            setDimensionProperty(elements, "height", value)
        };
        exports.styleProp = styleProp;
        exports.stylePropPrefix = stylePropPrefix;
        exports.normalizeStyleProp = normalizeStyleProp;
        exports.setWidth = setWidth;
        exports.setHeight = setHeight
    },
    /*!*************************************************************!*\
      !*** ./artifacts/transpiled/core/utils/variable_wrapper.js ***!
      \*************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var logger = __webpack_require__( /*! ./console */ 75).logger,
            dependencyInjector = __webpack_require__( /*! ./dependency_injector */ 56);
        module.exports = dependencyInjector({
            isWrapped: function() {
                return false
            },
            isWritableWrapped: function() {
                return false
            },
            wrap: function(value) {
                return value
            },
            unwrap: function(value) {
                return value
            },
            assign: function() {
                logger.error("Method 'assign' should not be used for not wrapped variables. Use 'isWrapped' method for ensuring.")
            }
        })
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/events/hold.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var eventUtils = __webpack_require__( /*! ./utils */ 9),
            Emitter = __webpack_require__( /*! ./core/emitter */ 126),
            registerEmitter = __webpack_require__( /*! ./core/emitter_registrator */ 95),
            abs = Math.abs;
        var HOLD_EVENT_NAME = "dxhold",
            HOLD_TIMEOUT = 750,
            TOUCH_BOUNDARY = 5;
        var HoldEmitter = Emitter.inherit({
            start: function(e) {
                this._startEventData = eventUtils.eventData(e);
                this._startTimer(e)
            },
            _startTimer: function(e) {
                var holdTimeout = "timeout" in this ? this.timeout : HOLD_TIMEOUT;
                this._holdTimer = setTimeout(function() {
                    this._requestAccept(e);
                    this._fireEvent(HOLD_EVENT_NAME, e, {
                        target: e.target
                    });
                    this._forgetAccept()
                }.bind(this), holdTimeout)
            },
            move: function(e) {
                if (this._touchWasMoved(e)) {
                    this._cancel(e)
                }
            },
            _touchWasMoved: function(e) {
                var delta = eventUtils.eventDelta(this._startEventData, eventUtils.eventData(e));
                return abs(delta.x) > TOUCH_BOUNDARY || abs(delta.y) > TOUCH_BOUNDARY
            },
            end: function() {
                this._stopTimer()
            },
            _stopTimer: function() {
                clearTimeout(this._holdTimer)
            },
            cancel: function() {
                this._stopTimer()
            },
            dispose: function() {
                this._stopTimer()
            }
        });
        registerEmitter({
            emitter: HoldEmitter,
            bubble: true,
            events: [HOLD_EVENT_NAME]
        });
        module.exports = {
            name: HOLD_EVENT_NAME
        }
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/ui/text_box.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        module.exports = __webpack_require__( /*! ./text_box/text_box */ 512)
    },
    /*!**************************************************************!*\
      !*** ./artifacts/transpiled/ui/scroll_view/ui.scrollable.js ***!
      \**************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            support = __webpack_require__( /*! ../../core/utils/support */ 44),
            browser = __webpack_require__( /*! ../../core/utils/browser */ 25),
            commonUtils = __webpack_require__( /*! ../../core/utils/common */ 4),
            typeUtils = __webpack_require__( /*! ../../core/utils/type */ 1),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            getPublicElement = __webpack_require__( /*! ../../core/utils/dom */ 11).getPublicElement,
            windowUtils = __webpack_require__( /*! ../../core/utils/window */ 7),
            navigator = windowUtils.getNavigator(),
            domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 13),
            devices = __webpack_require__( /*! ../../core/devices */ 16),
            registerComponent = __webpack_require__( /*! ../../core/component_registrator */ 8),
            DOMComponent = __webpack_require__( /*! ../../core/dom_component */ 84),
            selectors = __webpack_require__( /*! ../widget/selectors */ 65),
            eventUtils = __webpack_require__( /*! ../../events/utils */ 9),
            scrollEvents = __webpack_require__( /*! ./ui.events.emitter.gesture.scroll */ 219),
            simulatedStrategy = __webpack_require__( /*! ./ui.scrollable.simulated */ 309),
            NativeStrategy = __webpack_require__( /*! ./ui.scrollable.native */ 218),
            when = __webpack_require__( /*! ../../core/utils/deferred */ 6).when;
        var SCROLLABLE = "dxScrollable",
            SCROLLABLE_STRATEGY = "dxScrollableStrategy",
            SCROLLABLE_CLASS = "dx-scrollable",
            SCROLLABLE_DISABLED_CLASS = "dx-scrollable-disabled",
            SCROLLABLE_CONTAINER_CLASS = "dx-scrollable-container",
            SCROLLABLE_WRAPPER_CLASS = "dx-scrollable-wrapper",
            SCROLLABLE_CONTENT_CLASS = "dx-scrollable-content",
            SCROLLABLE_CUSTOMIZABLE_SCROLLBARS_CLASS = "dx-scrollable-customizable-scrollbars",
            VERTICAL = "vertical",
            HORIZONTAL = "horizontal",
            BOTH = "both";
        var deviceDependentOptions = function() {
            return [{
                device: function() {
                    return !support.nativeScrolling
                },
                options: {
                    useNative: false
                }
            }, {
                device: function(_device) {
                    return !devices.isSimulator() && "desktop" === devices.real().deviceType && "generic" === _device.platform
                },
                options: {
                    bounceEnabled: false,
                    scrollByThumb: true,
                    scrollByContent: support.touch,
                    showScrollbar: "onHover"
                }
            }]
        };
        var Scrollable = DOMComponent.inherit({
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    disabled: false,
                    onScroll: null,
                    direction: VERTICAL,
                    showScrollbar: "onScroll",
                    useNative: true,
                    bounceEnabled: true,
                    scrollByContent: true,
                    scrollByThumb: false,
                    onUpdated: null,
                    onStart: null,
                    onEnd: null,
                    onBounce: null,
                    onStop: null,
                    useSimulatedScrollbar: false,
                    useKeyboard: true,
                    inertiaEnabled: true,
                    pushBackValue: 0,
                    updateManually: false
                })
            },
            _defaultOptionsRules: function() {
                return this.callBase().concat(deviceDependentOptions(), [{
                    device: function() {
                        return support.nativeScrolling && "android" === devices.real().platform && !browser.mozilla
                    },
                    options: {
                        useSimulatedScrollbar: true
                    }
                }, {
                    device: function() {
                        return "ios" === devices.real().platform
                    },
                    options: {
                        pushBackValue: 1
                    }
                }])
            },
            _initOptions: function(options) {
                this.callBase(options);
                if (!("useSimulatedScrollbar" in options)) {
                    this._setUseSimulatedScrollbar()
                }
            },
            _setUseSimulatedScrollbar: function() {
                if (!this.initialOption("useSimulatedScrollbar")) {
                    this.option("useSimulatedScrollbar", !this.option("useNative"))
                }
            },
            _init: function() {
                this.callBase();
                this._initScrollableMarkup();
                this._locked = false
            },
            _visibilityChanged: function(visible) {
                if (visible) {
                    this.update();
                    this._updateRtlPosition();
                    this._savedScrollOffset && this.scrollTo(this._savedScrollOffset);
                    delete this._savedScrollOffset
                } else {
                    this._savedScrollOffset = this.scrollOffset()
                }
            },
            _initScrollableMarkup: function() {
                var $element = this.$element().addClass(SCROLLABLE_CLASS),
                    $container = this._$container = $("<div>").addClass(SCROLLABLE_CONTAINER_CLASS),
                    $wrapper = this._$wrapper = $("<div>").addClass(SCROLLABLE_WRAPPER_CLASS),
                    $content = this._$content = $("<div>").addClass(SCROLLABLE_CONTENT_CLASS);
                if (domAdapter.hasDocumentProperty("onbeforeactivate") && browser.msie && browser.version < 12) {
                    eventsEngine.on($element, eventUtils.addNamespace("beforeactivate", SCROLLABLE), function(e) {
                        if (!$(e.target).is(selectors.focusable)) {
                            e.preventDefault()
                        }
                    })
                }
                $content.append($element.contents()).appendTo($container);
                $container.appendTo($wrapper);
                $wrapper.appendTo($element)
            },
            _dimensionChanged: function() {
                this.update()
            },
            _attachNativeScrollbarsCustomizationCss: function() {
                if ("desktop" === devices.real().deviceType && !(navigator.platform.indexOf("Mac") > -1 && browser.webkit)) {
                    this.$element().addClass(SCROLLABLE_CUSTOMIZABLE_SCROLLBARS_CLASS)
                }
            },
            _initMarkup: function() {
                this.callBase();
                this._renderDirection()
            },
            _render: function() {
                this._renderStrategy();
                this._attachNativeScrollbarsCustomizationCss();
                this._attachEventHandlers();
                this._renderDisabledState();
                this._createActions();
                this.update();
                this.callBase();
                this._updateRtlPosition()
            },
            _updateRtlPosition: function() {
                var that = this,
                    rtl = that.option("rtlEnabled");
                this._updateBounds();
                if (rtl && this.option("direction") !== VERTICAL) {
                    commonUtils.deferUpdate(function() {
                        var left = that.scrollWidth() - that.clientWidth();
                        commonUtils.deferRender(function() {
                            that.scrollTo({
                                left: left
                            })
                        })
                    })
                }
            },
            _updateBounds: function() {
                this._strategy.updateBounds()
            },
            _attachEventHandlers: function() {
                var strategy = this._strategy;
                var initEventData = {
                    getDirection: strategy.getDirection.bind(strategy),
                    validate: this._validate.bind(this),
                    isNative: this.option("useNative"),
                    scrollTarget: this._$container
                };
                eventsEngine.off(this._$wrapper, "." + SCROLLABLE);
                eventsEngine.on(this._$wrapper, eventUtils.addNamespace(scrollEvents.init, SCROLLABLE), initEventData, this._initHandler.bind(this));
                eventsEngine.on(this._$wrapper, eventUtils.addNamespace(scrollEvents.start, SCROLLABLE), strategy.handleStart.bind(strategy));
                eventsEngine.on(this._$wrapper, eventUtils.addNamespace(scrollEvents.move, SCROLLABLE), strategy.handleMove.bind(strategy));
                eventsEngine.on(this._$wrapper, eventUtils.addNamespace(scrollEvents.end, SCROLLABLE), strategy.handleEnd.bind(strategy));
                eventsEngine.on(this._$wrapper, eventUtils.addNamespace(scrollEvents.cancel, SCROLLABLE), strategy.handleCancel.bind(strategy));
                eventsEngine.on(this._$wrapper, eventUtils.addNamespace(scrollEvents.stop, SCROLLABLE), strategy.handleStop.bind(strategy));
                eventsEngine.off(this._$container, "." + SCROLLABLE);
                eventsEngine.on(this._$container, eventUtils.addNamespace("scroll", SCROLLABLE), strategy.handleScroll.bind(strategy))
            },
            _validate: function(e) {
                if (this._isLocked()) {
                    return false
                }
                this._updateIfNeed();
                return this._strategy.validate(e)
            },
            _initHandler: function() {
                var strategy = this._strategy;
                strategy.handleInit.apply(strategy, arguments)
            },
            _renderDisabledState: function() {
                this.$element().toggleClass(SCROLLABLE_DISABLED_CLASS, this.option("disabled"));
                if (this.option("disabled")) {
                    this._lock()
                } else {
                    this._unlock()
                }
            },
            _renderDirection: function() {
                this.$element().removeClass("dx-scrollable-" + HORIZONTAL).removeClass("dx-scrollable-" + VERTICAL).removeClass("dx-scrollable-" + BOTH).addClass("dx-scrollable-" + this.option("direction"))
            },
            _renderStrategy: function() {
                this._createStrategy();
                this._strategy.render();
                this.$element().data(SCROLLABLE_STRATEGY, this._strategy)
            },
            _createStrategy: function() {
                this._strategy = this.option("useNative") ? new NativeStrategy(this) : new simulatedStrategy.SimulatedStrategy(this)
            },
            _createActions: function() {
                this._strategy && this._strategy.createActions()
            },
            _clean: function() {
                this._strategy && this._strategy.dispose()
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "onStart":
                    case "onEnd":
                    case "onStop":
                    case "onUpdated":
                    case "onScroll":
                    case "onBounce":
                        this._createActions();
                        break;
                    case "direction":
                        this._resetInactiveDirection();
                        this._invalidate();
                        break;
                    case "useNative":
                        this._setUseSimulatedScrollbar();
                        this._invalidate();
                        break;
                    case "inertiaEnabled":
                    case "scrollByContent":
                    case "scrollByThumb":
                    case "bounceEnabled":
                    case "useKeyboard":
                    case "showScrollbar":
                    case "useSimulatedScrollbar":
                    case "pushBackValue":
                        this._invalidate();
                        break;
                    case "disabled":
                        this._renderDisabledState();
                        this._strategy && this._strategy.disabledChanged();
                        break;
                    case "updateManually":
                        break;
                    case "width":
                        this.callBase(args);
                        this._updateRtlPosition();
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _resetInactiveDirection: function() {
                var inactiveProp = this._getInactiveProp();
                if (!inactiveProp || !windowUtils.hasWindow()) {
                    return
                }
                var scrollOffset = this.scrollOffset();
                scrollOffset[inactiveProp] = 0;
                this.scrollTo(scrollOffset)
            },
            _getInactiveProp: function() {
                var direction = this.option("direction");
                if (direction === VERTICAL) {
                    return "left"
                }
                if (direction === HORIZONTAL) {
                    return "top"
                }
            },
            _location: function() {
                return this._strategy.location()
            },
            _normalizeLocation: function(location) {
                if (typeUtils.isPlainObject(location)) {
                    var left = commonUtils.ensureDefined(location.left, location.x);
                    var top = commonUtils.ensureDefined(location.top, location.y);
                    return {
                        left: typeUtils.isDefined(left) ? -left : void 0,
                        top: typeUtils.isDefined(top) ? -top : void 0
                    }
                } else {
                    var direction = this.option("direction");
                    return {
                        left: direction !== VERTICAL ? -location : void 0,
                        top: direction !== HORIZONTAL ? -location : void 0
                    }
                }
            },
            _isLocked: function() {
                return this._locked
            },
            _lock: function() {
                this._locked = true
            },
            _unlock: function() {
                if (!this.option("disabled")) {
                    this._locked = false
                }
            },
            _isDirection: function(direction) {
                var current = this.option("direction");
                if (direction === VERTICAL) {
                    return current !== HORIZONTAL
                }
                if (direction === HORIZONTAL) {
                    return current !== VERTICAL
                }
                return current === direction
            },
            _updateAllowedDirection: function() {
                var allowedDirections = this._strategy._allowedDirections();
                if (this._isDirection(BOTH) && allowedDirections.vertical && allowedDirections.horizontal) {
                    this._allowedDirectionValue = BOTH
                } else {
                    if (this._isDirection(HORIZONTAL) && allowedDirections.horizontal) {
                        this._allowedDirectionValue = HORIZONTAL
                    } else {
                        if (this._isDirection(VERTICAL) && allowedDirections.vertical) {
                            this._allowedDirectionValue = VERTICAL
                        } else {
                            this._allowedDirectionValue = null
                        }
                    }
                }
            },
            _allowedDirection: function() {
                return this._allowedDirectionValue
            },
            _container: function() {
                return this._$container
            },
            $content: function() {
                return this._$content
            },
            content: function() {
                return getPublicElement(this._$content)
            },
            scrollOffset: function() {
                var location = this._location();
                return {
                    top: -location.top,
                    left: -location.left
                }
            },
            scrollTop: function() {
                return this.scrollOffset().top
            },
            scrollLeft: function() {
                return this.scrollOffset().left
            },
            clientHeight: function() {
                return this._$container.height()
            },
            scrollHeight: function() {
                return this.$content().outerHeight() - 2 * this._strategy.verticalOffset()
            },
            clientWidth: function() {
                return this._$container.width()
            },
            scrollWidth: function() {
                return this.$content().outerWidth()
            },
            update: function() {
                if (!this._strategy) {
                    return
                }
                return when(this._strategy.update()).done(function() {
                    this._updateAllowedDirection()
                }.bind(this))
            },
            scrollBy: function(distance) {
                distance = this._normalizeLocation(distance);
                if (!distance.top && !distance.left) {
                    return
                }
                this._updateIfNeed();
                this._strategy.scrollBy(distance)
            },
            scrollTo: function(targetLocation) {
                targetLocation = this._normalizeLocation(targetLocation);
                this._updateIfNeed();
                var location = this._location();
                if (!this.option("useNative")) {
                    targetLocation = this._strategy._applyScaleRatio(targetLocation);
                    location = this._strategy._applyScaleRatio(location)
                }
                var distance = this._normalizeLocation({
                    left: location.left - commonUtils.ensureDefined(targetLocation.left, location.left),
                    top: location.top - commonUtils.ensureDefined(targetLocation.top, location.top)
                });
                if (!distance.top && !distance.left) {
                    return
                }
                this._strategy.scrollBy(distance)
            },
            scrollToElement: function(element, offset) {
                offset = offset || {};
                var $element = $(element);
                var elementInsideContent = this.$content().find(element).length;
                var elementIsInsideContent = $element.parents("." + SCROLLABLE_CLASS).length - $element.parents("." + SCROLLABLE_CONTENT_CLASS).length === 0;
                if (!elementInsideContent || !elementIsInsideContent) {
                    return
                }
                var scrollPosition = {
                    top: 0,
                    left: 0
                };
                var direction = this.option("direction");
                if (direction !== VERTICAL) {
                    scrollPosition.left = this._scrollToElementPosition($element, HORIZONTAL, offset)
                }
                if (direction !== HORIZONTAL) {
                    scrollPosition.top = this._scrollToElementPosition($element, VERTICAL, offset)
                }
                this.scrollTo(scrollPosition)
            },
            _scrollToElementPosition: function($element, direction, offset) {
                var isVertical = direction === VERTICAL;
                var startOffset = (isVertical ? offset.top : offset.left) || 0;
                var endOffset = (isVertical ? offset.bottom : offset.right) || 0;
                var pushBackOffset = isVertical ? this._strategy.verticalOffset() : 0;
                var elementPositionRelativeToContent = this._elementPositionRelativeToContent($element, isVertical ? "top" : "left");
                var elementPosition = elementPositionRelativeToContent - pushBackOffset;
                var elementSize = $element[isVertical ? "outerHeight" : "outerWidth"]();
                var scrollLocation = isVertical ? this.scrollTop() : this.scrollLeft();
                var clientSize = isVertical ? this.clientHeight() : this.clientWidth();
                var startDistance = scrollLocation - elementPosition + startOffset;
                var endDistance = scrollLocation - elementPosition - elementSize + clientSize - endOffset;
                if (startDistance <= 0 && endDistance >= 0) {
                    return scrollLocation
                }
                return scrollLocation - (Math.abs(startDistance) > Math.abs(endDistance) ? endDistance : startDistance)
            },
            _elementPositionRelativeToContent: function($element, prop) {
                var result = 0;
                while (this._hasScrollContent($element)) {
                    result += $element.position()[prop];
                    $element = $element.offsetParent()
                }
                return result
            },
            _hasScrollContent: function($element) {
                var $content = this.$content();
                return $element.closest($content).length && !$element.is($content)
            },
            _updateIfNeed: function() {
                if (!this.option("updateManually")) {
                    this.update()
                }
            }
        });
        registerComponent(SCROLLABLE, Scrollable);
        module.exports = Scrollable;
        module.exports.deviceDependentOptions = deviceDependentOptions
    },
    /*!***********************************************!*\
      !*** ./artifacts/transpiled/ui/select_box.js ***!
      \***********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            commonUtils = __webpack_require__( /*! ../core/utils/common */ 4),
            typeUtils = __webpack_require__( /*! ../core/utils/type */ 1),
            isDefined = typeUtils.isDefined,
            isPromise = typeUtils.isPromise,
            extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            inArray = __webpack_require__( /*! ../core/utils/array */ 14).inArray,
            each = __webpack_require__( /*! ../core/utils/iterator */ 3).each,
            deferredUtils = __webpack_require__( /*! ../core/utils/deferred */ 6),
            getPublicElement = __webpack_require__( /*! ../core/utils/dom */ 11).getPublicElement,
            Deferred = deferredUtils.Deferred,
            errors = __webpack_require__( /*! ../core/errors */ 21),
            domAdapter = __webpack_require__( /*! ../core/dom_adapter */ 13),
            inkRipple = __webpack_require__( /*! ./widget/utils.ink_ripple */ 69),
            messageLocalization = __webpack_require__( /*! ../localization/message */ 10),
            registerComponent = __webpack_require__( /*! ../core/component_registrator */ 8),
            DropDownList = __webpack_require__( /*! ./drop_down_editor/ui.drop_down_list */ 216);
        var DISABLED_STATE_SELECTOR = ".dx-state-disabled",
            SELECTBOX_CLASS = "dx-selectbox",
            SELECTBOX_POPUP_CLASS = "dx-selectbox-popup",
            SELECTBOX_CONTAINER_CLASS = "dx-selectbox-container",
            SELECTBOX_POPUP_WRAPPER_CLASS = "dx-selectbox-popup-wrapper";
        var SelectBox = DropDownList.inherit({
            _supportedKeys: function() {
                var that = this,
                    parent = this.callBase(),
                    clearSelectBox = function(e) {
                        var isEditable = this._isEditable();
                        if (!isEditable) {
                            if (this.option("showClearButton")) {
                                e.preventDefault();
                                this.reset()
                            }
                        } else {
                            if (this._valueSubstituted()) {
                                this._preventFiltering = true
                            }
                        }
                        this._preventSubstitution = true
                    };
                var searchIfNeeded = function() {
                    if (that.option("searchEnabled") && that._valueSubstituted()) {
                        that._searchHandler()
                    }
                };
                return extend({}, parent, {
                    tab: function() {
                        if (this.option("opened") && "instantly" === this.option("applyValueMode")) {
                            this._cleanInputSelection()
                        }
                        if (this._wasSearch()) {
                            this._clearFilter()
                        }
                        parent.tab && parent.tab.apply(this, arguments)
                    },
                    upArrow: function() {
                        if (parent.upArrow && parent.upArrow.apply(this, arguments)) {
                            if (!this.option("opened")) {
                                this._setNextValue(-1)
                            }
                            return true
                        }
                    },
                    downArrow: function() {
                        if (parent.downArrow && parent.downArrow.apply(this, arguments)) {
                            if (!this.option("opened")) {
                                this._setNextValue(1)
                            }
                            return true
                        }
                    },
                    leftArrow: function() {
                        searchIfNeeded();
                        parent.leftArrow && parent.leftArrow.apply(this, arguments)
                    },
                    rightArrow: function() {
                        searchIfNeeded();
                        parent.rightArrow && parent.rightArrow.apply(this, arguments)
                    },
                    home: function() {
                        searchIfNeeded();
                        parent.home && parent.home.apply(this, arguments)
                    },
                    end: function() {
                        searchIfNeeded();
                        parent.end && parent.end.apply(this, arguments)
                    },
                    escape: function() {
                        parent.escape && parent.escape.apply(this, arguments);
                        this._cancelEditing()
                    },
                    enter: function(e) {
                        var isOpened = this.option("opened");
                        var inputText = this._input().val().trim();
                        var isCustomText = inputText && this._list && !this._list.option("focusedElement");
                        if (!inputText && this.option("value") && this.option("allowClearing")) {
                            this.option({
                                selectedItem: null,
                                value: null
                            });
                            this.close()
                        } else {
                            if (this.option("acceptCustomValue")) {
                                e.preventDefault();
                                if (isCustomText) {
                                    this._valueChangeEventHandler();
                                    if (isOpened) {
                                        this._toggleOpenState()
                                    }
                                }
                                return isOpened
                            }
                            if (parent.enter && parent.enter.apply(this, arguments)) {
                                return isOpened
                            }
                        }
                    },
                    space: function(e) {
                        var isOpened = this.option("opened"),
                            isSearchEnabled = this.option("searchEnabled"),
                            acceptCustomValue = this.option("acceptCustomValue");
                        if (!isOpened || isSearchEnabled || acceptCustomValue) {
                            return
                        }
                        e.preventDefault();
                        this._valueChangeEventHandler(e);
                        return true
                    },
                    backspace: clearSelectBox,
                    del: clearSelectBox
                })
            },
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    placeholder: messageLocalization.format("Select"),
                    fieldTemplate: null,
                    valueChangeEvent: "change",
                    acceptCustomValue: false,
                    onCustomItemCreating: function(e) {
                        if (!isDefined(e.customItem)) {
                            e.customItem = e.text
                        }
                    },
                    showSelectionControls: false,
                    autocompletionEnabled: true,
                    allowClearing: true,
                    tooltipEnabled: false,
                    openOnFieldClick: true,
                    showDropDownButton: true,
                    displayCustomValue: false,
                    _isAdaptablePopupPosition: false,
                    useInkRipple: false,
                    useHiddenSubmitElement: true
                })
            },
            _init: function() {
                this.callBase();
                this._initCustomItemCreatingAction()
            },
            _initMarkup: function() {
                this.$element().addClass(SELECTBOX_CLASS);
                this._renderTooltip();
                this.option("useInkRipple") && this._renderInkRipple();
                this.callBase();
                this._$container.addClass(SELECTBOX_CONTAINER_CLASS)
            },
            _renderInkRipple: function() {
                this._inkRipple = inkRipple.render()
            },
            _toggleActiveState: function($element, value, e) {
                this.callBase.apply(this, arguments);
                if (!this._inkRipple || this._isEditable()) {
                    return
                }
                var config = {
                    element: this._inputWrapper(),
                    event: e
                };
                if (value) {
                    this._inkRipple.showWave(config)
                } else {
                    this._inkRipple.hideWave(config)
                }
            },
            _createPopup: function() {
                this.callBase();
                this._popup.$element().addClass(SELECTBOX_POPUP_CLASS)
            },
            _popupWrapperClass: function() {
                return this.callBase() + " " + SELECTBOX_POPUP_WRAPPER_CLASS
            },
            _cancelEditing: function() {
                if (!this.option("searchEnabled") && this._list) {
                    this._focusListElement(null);
                    this._updateField(this.option("selectedItem"))
                }
            },
            _renderOpenedState: function() {
                this.callBase();
                if (this.option("opened")) {
                    this._scrollToSelectedItem();
                    this._focusSelectedElement()
                }
            },
            _focusSelectedElement: function() {
                var searchValue = this._searchValue();
                if (!searchValue) {
                    this._focusListElement(null);
                    return
                }
                var $listItems = this._list._itemElements(),
                    index = inArray(this.option("selectedItem"), this.option("items")),
                    focusedElement = index >= 0 && !this._isCustomItemSelected() ? $listItems.eq(index) : null;
                this._focusListElement(focusedElement)
            },
            _renderFocusedElement: function() {
                if (!this._list) {
                    return
                }
                var searchValue = this._searchValue();
                if (!searchValue || this.option("acceptCustomValue")) {
                    this._focusListElement(null);
                    return
                }
                var $listItems = this._list._itemElements(),
                    focusedElement = $listItems.not(DISABLED_STATE_SELECTOR).eq(0);
                this._focusListElement(focusedElement)
            },
            _focusListElement: function(element) {
                this._preventInputValueRender = true;
                this._list.option("focusedElement", getPublicElement(element));
                delete this._preventInputValueRender
            },
            _scrollToSelectedItem: function() {
                this._list && this._list.scrollToItem(this._list.option("selectedItem"))
            },
            _listContentReadyHandler: function() {
                this.callBase();
                var isPaginate = this._dataSource && this._dataSource.paginate();
                if (isPaginate && this._needPopupRepaint()) {
                    return
                }
                this._scrollToSelectedItem()
            },
            _renderValue: function() {
                this._renderInputValue();
                this._setSubmitValue();
                return (new Deferred).resolve()
            },
            _renderInputValue: function() {
                return this.callBase().always(function() {
                    this._renderInputValueAsync()
                }.bind(this))
            },
            _renderInputValueAsync: function() {
                this._renderTooltip();
                this._renderInputValueImpl().always(function() {
                    this._refreshSelected()
                }.bind(this))
            },
            _renderInputValueImpl: function() {
                this._renderField();
                return (new Deferred).resolve()
            },
            _setNextItem: function(step) {
                var item = this._calcNextItem(step),
                    value = this._valueGetter(item);
                this._setValue(value)
            },
            _setNextValue: function(step) {
                var dataSourceIsLoaded = this._dataSource.isLoaded() ? (new Deferred).resolve() : this._dataSource.load();
                dataSourceIsLoaded.done(function() {
                    var selectedIndex = this._getSelectedIndex(),
                        hasPages = this._dataSource.pageSize(),
                        isLastPage = this._dataSource.isLastPage(),
                        isLastItem = selectedIndex === this._items().length - 1;
                    if (hasPages && !isLastPage && isLastItem && step > 0) {
                        if (!this._popup) {
                            this._createPopup()
                        }
                        this._list._loadNextPage().done(this._setNextItem.bind(this, step))
                    } else {
                        this._setNextItem(step)
                    }
                }.bind(this))
            },
            _setSelectedItem: function(item) {
                var isUnknownItem = !this._isCustomValueAllowed() && void 0 === item;
                this.callBase(isUnknownItem ? null : item)
            },
            _isCustomValueAllowed: function() {
                return this.option("acceptCustomValue") || this.callBase()
            },
            _displayValue: function(item) {
                item = !isDefined(item) && this._isCustomValueAllowed() ? this.option("value") : item;
                return this.callBase(item)
            },
            _listConfig: function() {
                var result = extend(this.callBase(), {
                    pageLoadMode: "scrollBottom",
                    onSelectionChanged: this._getSelectionChangeHandler(),
                    selectedItem: this.option("selectedItem"),
                    onFocusedItemChanged: this._listFocusedItemChangeHandler.bind(this)
                });
                if (this.option("showSelectionControls")) {
                    extend(result, {
                        showSelectionControls: true,
                        selectionByClick: true
                    })
                }
                return result
            },
            _listFocusedItemChangeHandler: function(e) {
                if (this._preventInputValueRender) {
                    return
                }
                var list = e.component,
                    focusedElement = $(list.option("focusedElement")),
                    focusedItem = list._getItemData(focusedElement);
                this._updateField(focusedItem)
            },
            _updateField: function(item) {
                var fieldTemplate = this._getTemplateByOption("fieldTemplate");
                if (!(fieldTemplate && this.option("fieldTemplate"))) {
                    this._renderDisplayText(this._displayGetter(item));
                    return
                }
                this._renderField()
            },
            _getSelectionChangeHandler: function() {
                return this.option("showSelectionControls") ? this._selectionChangeHandler.bind(this) : commonUtils.noop
            },
            _selectionChangeHandler: function(e) {
                each(e.addedItems || [], function(_, addedItem) {
                    this._setValue(this._valueGetter(addedItem))
                }.bind(this))
            },
            _getActualSearchValue: function() {
                return this._dataSource.searchValue()
            },
            _toggleOpenState: function(isVisible) {
                if (this.option("disabled")) {
                    return
                }
                isVisible = arguments.length ? isVisible : !this.option("opened");
                if (!isVisible) {
                    this._restoreInputText()
                }
                if (this._wasSearch() && isVisible) {
                    this._wasSearch(false);
                    var showDataImmediately = this.option("showDataBeforeSearch") || 0 === this.option("minSearchLength");
                    if (showDataImmediately && this._dataSource) {
                        if (this._searchTimer) {
                            return
                        }
                        var searchValue = this._getActualSearchValue();
                        searchValue && this._wasSearch(true);
                        this._filterDataSource(searchValue || null)
                    } else {
                        this._setListOption("items", [])
                    }
                }
                if (isVisible) {
                    this._scrollToSelectedItem()
                }
                this.callBase(isVisible)
            },
            _renderTooltip: function() {
                if (this.option("tooltipEnabled")) {
                    this.$element().attr("title", this.option("displayValue"))
                }
            },
            _renderDimensions: function() {
                this.callBase();
                this._setPopupOption("width")
            },
            _isValueEqualInputText: function() {
                var initialSelectedItem = this.option("selectedItem");
                var value = this._displayGetter(initialSelectedItem);
                var displayValue = value ? String(value) : "";
                var inputText = this._searchValue();
                return displayValue === inputText
            },
            _popupHidingHandler: function() {
                if (this._isValueEqualInputText()) {
                    this._cancelEditing()
                }
                this.callBase()
            },
            _restoreInputText: function() {
                if (this.option("readOnly")) {
                    return
                }
                this._loadItemDeferred && this._loadItemDeferred.always(function() {
                    var initialSelectedItem = this.option("selectedItem");
                    if (this.option("acceptCustomValue")) {
                        this._updateField(initialSelectedItem);
                        return
                    }
                    if (this.option("searchEnabled")) {
                        if (!this._searchValue() && this.option("allowClearing")) {
                            this._clearTextValue();
                            return
                        }
                    }
                    if (this._isValueEqualInputText()) {
                        return
                    }
                    this._renderInputValue().always(function(selectedItem) {
                        var newSelectedItem = commonUtils.ensureDefined(selectedItem, initialSelectedItem);
                        this._setSelectedItem(newSelectedItem);
                        this._updateField(newSelectedItem);
                        this._clearFilter()
                    }.bind(this))
                }.bind(this))
            },
            _focusOutHandler: function(e) {
                if (!this._preventNestedFocusEvent(e)) {
                    this._clearSearchTimer();
                    this._restoreInputText()
                }
                this.callBase(e)
            },
            _clearTextValue: function() {
                this.option("value", null)
            },
            _shouldOpenPopup: function() {
                return this._needPassDataSourceToList()
            },
            _isFocused: function() {
                var activeElement = domAdapter.getActiveElement();
                return this.callBase() && $(activeElement).closest(this._input()).length > 0
            },
            _renderValueChangeEvent: function() {
                if (this._isEditable()) {
                    this.callBase()
                }
            },
            _isEditable: function() {
                return this.option("acceptCustomValue") || this.option("searchEnabled")
            },
            _fieldRenderData: function() {
                var $listFocused = this._list && this.option("opened") && $(this._list.option("focusedElement"));
                if ($listFocused && $listFocused.length) {
                    return this._list._getItemData($listFocused)
                }
                return this.option("selectedItem")
            },
            _readOnlyPropValue: function() {
                return !this._isEditable() || this.option("readOnly")
            },
            _isSelectedValue: function(value) {
                return this._isValueEquals(value, this.option("value"))
            },
            _shouldCloseOnItemClick: function() {
                return !(this.option("showSelectionControls") && "single" !== this.option("selectionMode"))
            },
            _listItemClickHandler: function(e) {
                var previousValue = this._getCurrentValue();
                this._focusListElement($(e.itemElement));
                this._saveValueChangeEvent(e.event);
                if (this._shouldClearFilter()) {
                    this._clearFilter()
                }
                this._completeSelection(this._valueGetter(e.itemData));
                if (this._shouldCloseOnItemClick()) {
                    this.option("opened", false)
                }
                if (this.option("searchEnabled") && previousValue === this._valueGetter(e.itemData)) {
                    this._updateField(e.itemData)
                }
            },
            _shouldClearFilter: function() {
                return this._wasSearch()
            },
            _completeSelection: function(value) {
                this._setValue(value)
            },
            _loadItem: function(value, cache) {
                var that = this,
                    deferred = new Deferred;
                this.callBase(value, cache).done(function(item) {
                    deferred.resolve(item)
                }.bind(this)).fail(function() {
                    var selectedItem = that.option("selectedItem");
                    if (that.option("acceptCustomValue") && value === that._valueGetter(selectedItem)) {
                        deferred.resolve(selectedItem)
                    } else {
                        deferred.reject()
                    }
                }.bind(this));
                return deferred.promise()
            },
            _loadInputValue: function(value, callback) {
                this._loadItemDeferred = this._loadItem(value).always(callback);
                return this._loadItemDeferred
            },
            _isCustomItemSelected: function() {
                var selectedItem = this.option("selectedItem"),
                    searchValue = this._searchValue(),
                    selectedItemText = this._displayGetter(selectedItem);
                return !selectedItemText || searchValue !== selectedItemText.toString()
            },
            _valueChangeEventHandler: function() {
                if (this.option("acceptCustomValue") && this._isCustomItemSelected()) {
                    this._customItemAddedHandler()
                }
            },
            _initCustomItemCreatingAction: function() {
                this._customItemCreatingAction = this._createActionByOption("onCustomItemCreating")
            },
            _createCustomItem: function(text) {
                var params = {
                        text: text
                    },
                    actionResult = this._customItemCreatingAction(params),
                    item = commonUtils.ensureDefined(actionResult, params.customItem);
                if (isDefined(actionResult)) {
                    errors.log("W0015", "onCustomItemCreating", "customItem")
                }
                return item
            },
            _customItemAddedHandler: function() {
                var searchValue = this._searchValue(),
                    item = this._createCustomItem(searchValue);
                if (void 0 === item) {
                    this._renderValue();
                    throw errors.Error("E0121")
                }
                if (isPromise(item)) {
                    deferredUtils.fromPromise(item).done(this._setCustomItem.bind(this)).fail(this._setCustomItem.bind(this, null))
                } else {
                    this._setCustomItem(item)
                }
            },
            _setCustomItem: function(item) {
                if (this._disposed) {
                    return
                }
                item = item || null;
                this.option("selectedItem", item);
                if (this._shouldClearFilter()) {
                    this._filterDataSource(null)
                }
                this._setValue(this._valueGetter(item));
                this._renderDisplayText(this._displayGetter(item))
            },
            _clearValueHandler: function(e) {
                this.callBase(e);
                return false
            },
            _wasSearch: function(value) {
                if (!arguments.length) {
                    return this._wasSearchValue
                }
                this._wasSearchValue = value
            },
            _searchHandler: function(e) {
                if (this._preventFiltering) {
                    delete this._preventFiltering;
                    return
                }
                if (this._needPassDataSourceToList()) {
                    this._wasSearch(true)
                }
                this.callBase(e)
            },
            _dataSourceFiltered: function(searchValue) {
                this.callBase();
                if (null !== searchValue) {
                    this._renderInputSubstitution();
                    this._renderFocusedElement()
                }
            },
            _valueSubstituted: function() {
                var input = this._input().get(0),
                    isAllSelected = 0 === input.selectionStart && input.selectionEnd === this._searchValue().length,
                    inputHasSelection = input.selectionStart !== input.selectionEnd;
                return this._wasSearch() && inputHasSelection && !isAllSelected
            },
            _shouldSubstitutionBeRendered: function() {
                return this.option("autocompletionEnabled") && !this._preventSubstitution && this.option("searchEnabled") && !this.option("acceptCustomValue") && "startswith" === this.option("searchMode")
            },
            _renderInputSubstitution: function() {
                if (!this._shouldSubstitutionBeRendered()) {
                    delete this._preventSubstitution;
                    return
                }
                var item = this._list && this._getPlainItems(this._list.option("items"))[0];
                if (!item) {
                    return
                }
                var $input = this._input(),
                    valueLength = $input.val().length;
                if (0 === valueLength) {
                    return
                }
                var inputElement = $input.get(0),
                    displayValue = this._displayGetter(item).toString();
                inputElement.value = displayValue;
                this._caret({
                    start: valueLength,
                    end: displayValue.length
                })
            },
            _cleanInputSelection: function() {
                var inputElement = this._input().get(0),
                    endPosition = inputElement.value.length;
                inputElement.selectionStart = endPosition;
                inputElement.selectionEnd = endPosition
            },
            _dispose: function() {
                this._renderInputValueAsync = commonUtils.noop;
                delete this._loadItemDeferred;
                this.callBase()
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "_isAdaptablePopupPosition":
                    case "autocompletionEnabled":
                        break;
                    case "onCustomItemCreating":
                        this._initCustomItemCreatingAction();
                        break;
                    case "tooltipEnabled":
                        this._renderTooltip();
                        break;
                    case "displayCustomValue":
                    case "acceptCustomValue":
                    case "showSelectionControls":
                    case "useInkRipple":
                        this._invalidate();
                        break;
                    case "selectedItem":
                        if (args.previousValue !== args.value) {
                            this.callBase(args)
                        }
                        break;
                    case "allowClearing":
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _clean: function() {
                delete this._inkRipple;
                this.callBase()
            }
        });
        registerComponent("dxSelectBox", SelectBox);
        module.exports = SelectBox
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/ui/context_menu.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _ui = __webpack_require__( /*! ./context_menu/ui.context_menu */ 335);
        var _ui2 = _interopRequireDefault(_ui);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        module.exports = _ui2.default
    }, ,
    /*!***************************************!*\
      !*** ./artifacts/transpiled/color.js ***!
      \***************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var standardColorNames = {
            aliceblue: "f0f8ff",
            antiquewhite: "faebd7",
            aqua: "00ffff",
            aquamarine: "7fffd4",
            azure: "f0ffff",
            beige: "f5f5dc",
            bisque: "ffe4c4",
            black: "000000",
            blanchedalmond: "ffebcd",
            blue: "0000ff",
            blueviolet: "8a2be2",
            brown: "a52a2a",
            burlywood: "deb887",
            cadetblue: "5f9ea0",
            chartreuse: "7fff00",
            chocolate: "d2691e",
            coral: "ff7f50",
            cornflowerblue: "6495ed",
            cornsilk: "fff8dc",
            crimson: "dc143c",
            cyan: "00ffff",
            darkblue: "00008b",
            darkcyan: "008b8b",
            darkgoldenrod: "b8860b",
            darkgray: "a9a9a9",
            darkgreen: "006400",
            darkkhaki: "bdb76b",
            darkmagenta: "8b008b",
            darkolivegreen: "556b2f",
            darkorange: "ff8c00",
            darkorchid: "9932cc",
            darkred: "8b0000",
            darksalmon: "e9967a",
            darkseagreen: "8fbc8f",
            darkslateblue: "483d8b",
            darkslategray: "2f4f4f",
            darkturquoise: "00ced1",
            darkviolet: "9400d3",
            deeppink: "ff1493",
            deepskyblue: "00bfff",
            dimgray: "696969",
            dodgerblue: "1e90ff",
            feldspar: "d19275",
            firebrick: "b22222",
            floralwhite: "fffaf0",
            forestgreen: "228b22",
            fuchsia: "ff00ff",
            gainsboro: "dcdcdc",
            ghostwhite: "f8f8ff",
            gold: "ffd700",
            goldenrod: "daa520",
            gray: "808080",
            green: "008000",
            greenyellow: "adff2f",
            honeydew: "f0fff0",
            hotpink: "ff69b4",
            indianred: "cd5c5c",
            indigo: "4b0082",
            ivory: "fffff0",
            khaki: "f0e68c",
            lavender: "e6e6fa",
            lavenderblush: "fff0f5",
            lawngreen: "7cfc00",
            lemonchiffon: "fffacd",
            lightblue: "add8e6",
            lightcoral: "f08080",
            lightcyan: "e0ffff",
            lightgoldenrodyellow: "fafad2",
            lightgrey: "d3d3d3",
            lightgreen: "90ee90",
            lightpink: "ffb6c1",
            lightsalmon: "ffa07a",
            lightseagreen: "20b2aa",
            lightskyblue: "87cefa",
            lightslateblue: "8470ff",
            lightslategray: "778899",
            lightsteelblue: "b0c4de",
            lightyellow: "ffffe0",
            lime: "00ff00",
            limegreen: "32cd32",
            linen: "faf0e6",
            magenta: "ff00ff",
            maroon: "800000",
            mediumaquamarine: "66cdaa",
            mediumblue: "0000cd",
            mediumorchid: "ba55d3",
            mediumpurple: "9370d8",
            mediumseagreen: "3cb371",
            mediumslateblue: "7b68ee",
            mediumspringgreen: "00fa9a",
            mediumturquoise: "48d1cc",
            mediumvioletred: "c71585",
            midnightblue: "191970",
            mintcream: "f5fffa",
            mistyrose: "ffe4e1",
            moccasin: "ffe4b5",
            navajowhite: "ffdead",
            navy: "000080",
            oldlace: "fdf5e6",
            olive: "808000",
            olivedrab: "6b8e23",
            orange: "ffa500",
            orangered: "ff4500",
            orchid: "da70d6",
            palegoldenrod: "eee8aa",
            palegreen: "98fb98",
            paleturquoise: "afeeee",
            palevioletred: "d87093",
            papayawhip: "ffefd5",
            peachpuff: "ffdab9",
            peru: "cd853f",
            pink: "ffc0cb",
            plum: "dda0dd",
            powderblue: "b0e0e6",
            purple: "800080",
            rebeccapurple: "663399",
            red: "ff0000",
            rosybrown: "bc8f8f",
            royalblue: "4169e1",
            saddlebrown: "8b4513",
            salmon: "fa8072",
            sandybrown: "f4a460",
            seagreen: "2e8b57",
            seashell: "fff5ee",
            sienna: "a0522d",
            silver: "c0c0c0",
            skyblue: "87ceeb",
            slateblue: "6a5acd",
            slategray: "708090",
            snow: "fffafa",
            springgreen: "00ff7f",
            steelblue: "4682b4",
            tan: "d2b48c",
            teal: "008080",
            thistle: "d8bfd8",
            tomato: "ff6347",
            turquoise: "40e0d0",
            violet: "ee82ee",
            violetred: "d02090",
            wheat: "f5deb3",
            white: "ffffff",
            whitesmoke: "f5f5f5",
            yellow: "ffff00",
            yellowgreen: "9acd32"
        };
        var standardColorTypes = [{
            re: /^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
            process: function(colorString) {
                return [parseInt(colorString[1], 10), parseInt(colorString[2], 10), parseInt(colorString[3], 10)]
            }
        }, {
            re: /^rgba\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3}),\s*(\d*\.*\d+)\)$/,
            process: function(colorString) {
                return [parseInt(colorString[1], 10), parseInt(colorString[2], 10), parseInt(colorString[3], 10), parseFloat(colorString[4])]
            }
        }, {
            re: /^#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})$/,
            process: function(colorString) {
                return [parseInt(colorString[1], 16), parseInt(colorString[2], 16), parseInt(colorString[3], 16)]
            }
        }, {
            re: /^#([a-f0-9]{1})([a-f0-9]{1})([a-f0-9]{1})$/,
            process: function(colorString) {
                return [parseInt(colorString[1] + colorString[1], 16), parseInt(colorString[2] + colorString[2], 16), parseInt(colorString[3] + colorString[3], 16)]
            }
        }, {
            re: /^hsv\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
            process: function(colorString) {
                var h = parseInt(colorString[1], 10),
                    s = parseInt(colorString[2], 10),
                    v = parseInt(colorString[3], 10),
                    rgb = hsvToRgb(h, s, v);
                return [rgb[0], rgb[1], rgb[2], 1, [h, s, v]]
            }
        }, {
            re: /^hsl\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
            process: function(colorString) {
                var h = parseInt(colorString[1], 10),
                    s = parseInt(colorString[2], 10),
                    l = parseInt(colorString[3], 10),
                    rgb = hslToRgb(h, s, l);
                return [rgb[0], rgb[1], rgb[2], 1, null, [h, s, l]]
            }
        }];

        function Color(value) {
            this.baseColor = value;
            var color;
            if (value) {
                color = String(value).toLowerCase().replace(/ /g, "");
                color = standardColorNames[color] ? "#" + standardColorNames[color] : color;
                color = parseColor(color)
            }
            if (!color) {
                this.colorIsInvalid = true
            }
            color = color || {};
            this.r = normalize(color[0]);
            this.g = normalize(color[1]);
            this.b = normalize(color[2]);
            this.a = normalize(color[3], 1, 1);
            if (color[4]) {
                this.hsv = {
                    h: color[4][0],
                    s: color[4][1],
                    v: color[4][2]
                }
            } else {
                this.hsv = toHsvFromRgb(this.r, this.g, this.b)
            }
            if (color[5]) {
                this.hsl = {
                    h: color[5][0],
                    s: color[5][1],
                    l: color[5][2]
                }
            } else {
                this.hsl = toHslFromRgb(this.r, this.g, this.b)
            }
        }

        function parseColor(color) {
            if ("transparent" === color) {
                return [0, 0, 0, 0]
            }
            var str, i = 0,
                ii = standardColorTypes.length;
            for (; i < ii; ++i) {
                str = standardColorTypes[i].re.exec(color);
                if (str) {
                    return standardColorTypes[i].process(str)
                }
            }
            return null
        }

        function normalize(colorComponent, def, max) {
            def = def || 0;
            max = max || 255;
            return colorComponent < 0 || isNaN(colorComponent) ? def : colorComponent > max ? max : colorComponent
        }

        function toHexFromRgb(r, g, b) {
            return "#" + (16777216 | r << 16 | g << 8 | b).toString(16).slice(1)
        }

        function toHsvFromRgb(r, g, b) {
            var H, S, V, max = Math.max(r, g, b),
                min = Math.min(r, g, b),
                delta = max - min;
            V = max;
            S = 0 === max ? 0 : 1 - min / max;
            if (max === min) {
                H = 0
            } else {
                switch (max) {
                    case r:
                        H = 60 * ((g - b) / delta);
                        if (g < b) {
                            H += 360
                        }
                        break;
                    case g:
                        H = 60 * ((b - r) / delta) + 120;
                        break;
                    case b:
                        H = 60 * ((r - g) / delta) + 240
                }
            }
            S *= 100;
            V *= 100 / 255;
            return {
                h: Math.round(H),
                s: Math.round(S),
                v: Math.round(V)
            }
        }

        function hsvToRgb(h, s, v) {
            var vDec, vInc, vMin, index, a, r, g, b;
            index = Math.floor(h % 360 / 60);
            vMin = (100 - s) * v / 100;
            a = (v - vMin) * (h % 60 / 60);
            vInc = vMin + a;
            vDec = v - a;
            switch (index) {
                case 0:
                    r = v;
                    g = vInc;
                    b = vMin;
                    break;
                case 1:
                    r = vDec;
                    g = v;
                    b = vMin;
                    break;
                case 2:
                    r = vMin;
                    g = v;
                    b = vInc;
                    break;
                case 3:
                    r = vMin;
                    g = vDec;
                    b = v;
                    break;
                case 4:
                    r = vInc;
                    g = vMin;
                    b = v;
                    break;
                case 5:
                    r = v;
                    g = vMin;
                    b = vDec
            }
            return [Math.round(2.55 * r), Math.round(2.55 * g), Math.round(2.55 * b)]
        }

        function calculateHue(r, g, b, delta) {
            var max = Math.max(r, g, b);
            switch (max) {
                case r:
                    return (g - b) / delta + (g < b ? 6 : 0);
                case g:
                    return (b - r) / delta + 2;
                case b:
                    return (r - g) / delta + 4
            }
        }

        function toHslFromRgb(r, g, b) {
            r = convertTo01Bounds(r, 255);
            g = convertTo01Bounds(g, 255);
            b = convertTo01Bounds(b, 255);
            var h, s, max = Math.max(r, g, b),
                min = Math.min(r, g, b),
                maxMinSum = max + min,
                l = maxMinSum / 2;
            if (max === min) {
                h = s = 0
            } else {
                var delta = max - min;
                if (l > .5) {
                    s = delta / (2 - maxMinSum)
                } else {
                    s = delta / maxMinSum
                }
                h = calculateHue(r, g, b, delta);
                h /= 6
            }
            return {
                h: _round(360 * h),
                s: _round(100 * s),
                l: _round(100 * l)
            }
        }

        function makeColorTint(colorPart, h) {
            var colorTint = h;
            if ("r" === colorPart) {
                colorTint = h + 1 / 3
            }
            if ("b" === colorPart) {
                colorTint = h - 1 / 3
            }
            return colorTint
        }

        function modifyColorTint(colorTint) {
            if (colorTint < 0) {
                colorTint += 1
            }
            if (colorTint > 1) {
                colorTint -= 1
            }
            return colorTint
        }

        function hueToRgb(p, q, colorTint) {
            colorTint = modifyColorTint(colorTint);
            if (colorTint < 1 / 6) {
                return p + 6 * (q - p) * colorTint
            }
            if (colorTint < .5) {
                return q
            }
            if (colorTint < 2 / 3) {
                return p + (q - p) * (2 / 3 - colorTint) * 6
            }
            return p
        }

        function hslToRgb(h, s, l) {
            var r, g, b;
            h = convertTo01Bounds(h, 360);
            s = convertTo01Bounds(s, 100);
            l = convertTo01Bounds(l, 100);
            if (0 === s) {
                r = g = b = l
            } else {
                var q = l < .5 ? l * (1 + s) : l + s - l * s,
                    p = 2 * l - q;
                r = hueToRgb(p, q, makeColorTint("r", h));
                g = hueToRgb(p, q, makeColorTint("g", h));
                b = hueToRgb(p, q, makeColorTint("b", h))
            }
            return [_round(255 * r), _round(255 * g), _round(255 * b)]
        }

        function convertTo01Bounds(n, max) {
            n = Math.min(max, Math.max(0, parseFloat(n)));
            if (Math.abs(n - max) < 1e-6) {
                return 1
            }
            return n % max / parseFloat(max)
        }

        function isIntegerBetweenMinAndMax(number, min, max) {
            min = min || 0;
            max = max || 255;
            if (number % 1 !== 0 || number < min || number > max || "number" !== typeof number || isNaN(number)) {
                return false
            }
            return true
        }
        var _round = Math.round;
        Color.prototype = {
            constructor: Color,
            highlight: function(step) {
                step = step || 10;
                return this.alter(step).toHex()
            },
            darken: function(step) {
                step = step || 10;
                return this.alter(-step).toHex()
            },
            alter: function(step) {
                var result = new Color;
                result.r = normalize(this.r + step);
                result.g = normalize(this.g + step);
                result.b = normalize(this.b + step);
                return result
            },
            blend: function(blendColor, opacity) {
                var other = blendColor instanceof Color ? blendColor : new Color(blendColor),
                    result = new Color;
                result.r = normalize(_round(this.r * (1 - opacity) + other.r * opacity));
                result.g = normalize(_round(this.g * (1 - opacity) + other.g * opacity));
                result.b = normalize(_round(this.b * (1 - opacity) + other.b * opacity));
                return result
            },
            toHex: function() {
                return toHexFromRgb(this.r, this.g, this.b)
            },
            getPureColor: function() {
                var rgb = hsvToRgb(this.hsv.h, 100, 100);
                return new Color("rgb(" + rgb.join(",") + ")")
            },
            isValidHex: function(hex) {
                return /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(hex)
            },
            isValidRGB: function(r, g, b) {
                if (!isIntegerBetweenMinAndMax(r) || !isIntegerBetweenMinAndMax(g) || !isIntegerBetweenMinAndMax(b)) {
                    return false
                }
                return true
            },
            isValidAlpha: function(a) {
                if (isNaN(a) || a < 0 || a > 1 || "number" !== typeof a) {
                    return false
                }
                return true
            },
            colorIsInvalid: false,
            fromHSL: function(hsl) {
                var color = new Color,
                    rgb = hslToRgb(hsl.h, hsl.s, hsl.l);
                color.r = rgb[0];
                color.g = rgb[1];
                color.b = rgb[2];
                return color
            }
        };
        module.exports = Color
    },
    /*!*****************************************************************!*\
      !*** ./artifacts/transpiled/events/core/emitter_registrator.js ***!
      \*****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            readyCallbacks = __webpack_require__( /*! ../../core/utils/ready_callbacks */ 48),
            domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 13),
            eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            dataUtils = __webpack_require__( /*! ../../core/element_data */ 40),
            Class = __webpack_require__( /*! ../../core/class */ 15),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            inArray = __webpack_require__( /*! ../../core/utils/array */ 14).inArray,
            each = __webpack_require__( /*! ../../core/utils/iterator */ 3).each,
            registerEvent = __webpack_require__( /*! ./event_registrator */ 71),
            eventUtils = __webpack_require__( /*! ../utils */ 9),
            pointerEvents = __webpack_require__( /*! ../pointer */ 24),
            wheelEvent = __webpack_require__( /*! ./wheel */ 127);
        var MANAGER_EVENT = "dxEventManager",
            EMITTER_DATA = "dxEmitter";
        var EventManager = Class.inherit({
            ctor: function() {
                this._attachHandlers();
                this.reset();
                this._proxiedCancelHandler = this._cancelHandler.bind(this);
                this._proxiedAcceptHandler = this._acceptHandler.bind(this)
            },
            _attachHandlers: function() {
                readyCallbacks.add(function() {
                    var document = domAdapter.getDocument();
                    eventsEngine.subscribeGlobal(document, eventUtils.addNamespace(pointerEvents.down, MANAGER_EVENT), this._pointerDownHandler.bind(this));
                    eventsEngine.subscribeGlobal(document, eventUtils.addNamespace(pointerEvents.move, MANAGER_EVENT), this._pointerMoveHandler.bind(this));
                    eventsEngine.subscribeGlobal(document, eventUtils.addNamespace([pointerEvents.up, pointerEvents.cancel].join(" "), MANAGER_EVENT), this._pointerUpHandler.bind(this));
                    eventsEngine.subscribeGlobal(document, eventUtils.addNamespace(wheelEvent.name, MANAGER_EVENT), this._mouseWheelHandler.bind(this))
                }.bind(this))
            },
            _eachEmitter: function(callback) {
                var activeEmitters = this._activeEmitters || [];
                var i = 0;
                while (activeEmitters.length > i) {
                    var emitter = activeEmitters[i];
                    if (false === callback(emitter)) {
                        break
                    }
                    if (activeEmitters[i] === emitter) {
                        i++
                    }
                }
            },
            _applyToEmitters: function(method, arg) {
                this._eachEmitter(function(emitter) {
                    emitter[method].call(emitter, arg)
                })
            },
            reset: function() {
                this._eachEmitter(this._proxiedCancelHandler);
                this._activeEmitters = []
            },
            resetEmitter: function(emitter) {
                this._proxiedCancelHandler(emitter)
            },
            _pointerDownHandler: function(e) {
                if (eventUtils.isMouseEvent(e) && e.which > 1) {
                    return
                }
                this._updateEmitters(e)
            },
            _updateEmitters: function(e) {
                if (!this._isSetChanged(e)) {
                    return
                }
                this._cleanEmitters(e);
                this._fetchEmitters(e)
            },
            _isSetChanged: function(e) {
                var currentSet = this._closestEmitter(e);
                var previousSet = this._emittersSet || [];
                var setChanged = currentSet.length !== previousSet.length;
                each(currentSet, function(index, emitter) {
                    setChanged = setChanged || previousSet[index] !== emitter;
                    return !setChanged
                });
                this._emittersSet = currentSet;
                return setChanged
            },
            _closestEmitter: function(e) {
                var that = this,
                    result = [],
                    $element = $(e.target);

                function handleEmitter(_, emitter) {
                    if (!!emitter && emitter.validatePointers(e) && emitter.validate(e)) {
                        emitter.addCancelCallback(that._proxiedCancelHandler);
                        emitter.addAcceptCallback(that._proxiedAcceptHandler);
                        result.push(emitter)
                    }
                }
                while ($element.length) {
                    var emitters = dataUtils.data($element.get(0), EMITTER_DATA) || [];
                    each(emitters, handleEmitter);
                    $element = $element.parent()
                }
                return result
            },
            _acceptHandler: function(acceptedEmitter, e) {
                var that = this;
                this._eachEmitter(function(emitter) {
                    if (emitter !== acceptedEmitter) {
                        that._cancelEmitter(emitter, e)
                    }
                })
            },
            _cancelHandler: function(canceledEmitter, e) {
                this._cancelEmitter(canceledEmitter, e)
            },
            _cancelEmitter: function(emitter, e) {
                var activeEmitters = this._activeEmitters;
                if (e) {
                    emitter.cancel(e)
                } else {
                    emitter.reset()
                }
                emitter.removeCancelCallback();
                emitter.removeAcceptCallback();
                var emitterIndex = inArray(emitter, activeEmitters);
                if (emitterIndex > -1) {
                    activeEmitters.splice(emitterIndex, 1)
                }
            },
            _cleanEmitters: function(e) {
                this._applyToEmitters("end", e);
                this.reset(e)
            },
            _fetchEmitters: function(e) {
                this._activeEmitters = this._emittersSet.slice();
                this._applyToEmitters("start", e)
            },
            _pointerMoveHandler: function(e) {
                this._applyToEmitters("move", e)
            },
            _pointerUpHandler: function(e) {
                this._updateEmitters(e)
            },
            _mouseWheelHandler: function(e) {
                if (!this._allowInterruptionByMouseWheel()) {
                    return
                }
                e.pointers = [null];
                this._pointerDownHandler(e);
                this._adjustWheelEvent(e);
                this._pointerMoveHandler(e);
                e.pointers = [];
                this._pointerUpHandler(e)
            },
            _allowInterruptionByMouseWheel: function() {
                var allowInterruption = true;
                this._eachEmitter(function(emitter) {
                    allowInterruption = emitter.allowInterruptionByMouseWheel() && allowInterruption;
                    return allowInterruption
                });
                return allowInterruption
            },
            _adjustWheelEvent: function(e) {
                var closestGestureEmitter = null;
                this._eachEmitter(function(emitter) {
                    if (!emitter.gesture) {
                        return
                    }
                    var direction = emitter.getDirection(e);
                    if ("horizontal" !== direction && !e.shiftKey || "vertical" !== direction && e.shiftKey) {
                        closestGestureEmitter = emitter;
                        return false
                    }
                });
                if (!closestGestureEmitter) {
                    return
                }
                var direction = closestGestureEmitter.getDirection(e),
                    verticalGestureDirection = "both" === direction && !e.shiftKey || "vertical" === direction,
                    prop = verticalGestureDirection ? "pageY" : "pageX";
                e[prop] += e.delta
            },
            isActive: function(element) {
                var result = false;
                this._eachEmitter(function(emitter) {
                    result = result || emitter.getElement().is(element)
                });
                return result
            }
        });
        var eventManager = new EventManager;
        var EMITTER_SUBSCRIPTION_DATA = "dxEmitterSubscription";
        var registerEmitter = function(emitterConfig) {
            var emitterClass = emitterConfig.emitter,
                emitterName = emitterConfig.events[0],
                emitterEvents = emitterConfig.events;
            each(emitterEvents, function(_, eventName) {
                registerEvent(eventName, {
                    noBubble: !emitterConfig.bubble,
                    setup: function(element) {
                        var subscriptions = dataUtils.data(element, EMITTER_SUBSCRIPTION_DATA) || {},
                            emitters = dataUtils.data(element, EMITTER_DATA) || {},
                            emitter = emitters[emitterName] || new emitterClass(element);
                        subscriptions[eventName] = true;
                        emitters[emitterName] = emitter;
                        dataUtils.data(element, EMITTER_DATA, emitters);
                        dataUtils.data(element, EMITTER_SUBSCRIPTION_DATA, subscriptions)
                    },
                    add: function(element, handleObj) {
                        var emitters = dataUtils.data(element, EMITTER_DATA),
                            emitter = emitters[emitterName];
                        emitter.configure(extend({
                            delegateSelector: handleObj.selector
                        }, handleObj.data), handleObj.type)
                    },
                    teardown: function(element) {
                        var subscriptions = dataUtils.data(element, EMITTER_SUBSCRIPTION_DATA),
                            emitters = dataUtils.data(element, EMITTER_DATA),
                            emitter = emitters[emitterName];
                        delete subscriptions[eventName];
                        var disposeEmitter = true;
                        each(emitterEvents, function(_, eventName) {
                            disposeEmitter = disposeEmitter && !subscriptions[eventName];
                            return disposeEmitter
                        });
                        if (disposeEmitter) {
                            if (eventManager.isActive(element)) {
                                eventManager.resetEmitter(emitter)
                            }
                            emitter && emitter.dispose();
                            delete emitters[emitterName]
                        }
                    }
                })
            })
        };
        module.exports = registerEmitter
    },
    /*!***************************************************************!*\
      !*** ./artifacts/transpiled/core/templates/empty_template.js ***!
      \***************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        exports.EmptyTemplate = void 0;
        var _createClass = function() {
            function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                    var descriptor = props[i];
                    descriptor.enumerable = descriptor.enumerable || false;
                    descriptor.configurable = true;
                    if ("value" in descriptor) {
                        descriptor.writable = true
                    }
                    Object.defineProperty(target, descriptor.key, descriptor)
                }
            }
            return function(Constructor, protoProps, staticProps) {
                if (protoProps) {
                    defineProperties(Constructor.prototype, protoProps)
                }
                if (staticProps) {
                    defineProperties(Constructor, staticProps)
                }
                return Constructor
            }
        }();
        var _renderer = __webpack_require__( /*! ../renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _template_base = __webpack_require__( /*! ./template_base */ 73);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }

        function _possibleConstructorReturn(self, call) {
            if (!self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called")
            }
            return call && ("object" === typeof call || "function" === typeof call) ? call : self
        }

        function _inherits(subClass, superClass) {
            if ("function" !== typeof superClass && null !== superClass) {
                throw new TypeError("Super expression must either be null or a function, not " + typeof superClass)
            }
            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    enumerable: false,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) {
                Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass
            }
        }
        exports.EmptyTemplate = function(_TemplateBase) {
            _inherits(EmptyTemplate, _TemplateBase);

            function EmptyTemplate() {
                _classCallCheck(this, EmptyTemplate);
                return _possibleConstructorReturn(this, (EmptyTemplate.__proto__ || Object.getPrototypeOf(EmptyTemplate)).apply(this, arguments))
            }
            _createClass(EmptyTemplate, [{
                key: "_renderCore",
                value: function() {
                    return (0, _renderer2.default)()
                }
            }]);
            return EmptyTemplate
        }(_template_base.TemplateBase)
    }, ,
    /*!******************************************************************!*\
      !*** ./artifacts/transpiled/core/templates/function_template.js ***!
      \******************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        exports.FunctionTemplate = void 0;
        var _createClass = function() {
            function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                    var descriptor = props[i];
                    descriptor.enumerable = descriptor.enumerable || false;
                    descriptor.configurable = true;
                    if ("value" in descriptor) {
                        descriptor.writable = true
                    }
                    Object.defineProperty(target, descriptor.key, descriptor)
                }
            }
            return function(Constructor, protoProps, staticProps) {
                if (protoProps) {
                    defineProperties(Constructor.prototype, protoProps)
                }
                if (staticProps) {
                    defineProperties(Constructor, staticProps)
                }
                return Constructor
            }
        }();
        var _template_base = __webpack_require__( /*! ./template_base */ 73);
        var _dom = __webpack_require__( /*! ../utils/dom */ 11);

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }

        function _possibleConstructorReturn(self, call) {
            if (!self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called")
            }
            return call && ("object" === typeof call || "function" === typeof call) ? call : self
        }

        function _inherits(subClass, superClass) {
            if ("function" !== typeof superClass && null !== superClass) {
                throw new TypeError("Super expression must either be null or a function, not " + typeof superClass)
            }
            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    enumerable: false,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) {
                Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass
            }
        }
        exports.FunctionTemplate = function(_TemplateBase) {
            _inherits(FunctionTemplate, _TemplateBase);

            function FunctionTemplate(render) {
                _classCallCheck(this, FunctionTemplate);
                var _this = _possibleConstructorReturn(this, (FunctionTemplate.__proto__ || Object.getPrototypeOf(FunctionTemplate)).call(this));
                _this._render = render;
                return _this
            }
            _createClass(FunctionTemplate, [{
                key: "_renderCore",
                value: function(options) {
                    return (0, _dom.normalizeTemplateElement)(this._render(options))
                }
            }]);
            return FunctionTemplate
        }(_template_base.TemplateBase)
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/core/utils/position.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var config = __webpack_require__( /*! ../config */ 29);
        var getDefaultAlignment = function(isRtlEnabled) {
            var rtlEnabled = isRtlEnabled || config().rtlEnabled;
            return rtlEnabled ? "right" : "left"
        };
        exports.getDefaultAlignment = getDefaultAlignment
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/data/abstract_store.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Class = __webpack_require__( /*! ../core/class */ 15),
            abstract = Class.abstract,
            EventsMixin = __webpack_require__( /*! ../core/events_mixin */ 85),
            each = __webpack_require__( /*! ../core/utils/iterator */ 3).each,
            errorsModule = __webpack_require__( /*! ./errors */ 37),
            dataUtils = __webpack_require__( /*! ./utils */ 41),
            compileGetter = __webpack_require__( /*! ../core/utils/data */ 20).compileGetter,
            storeHelper = __webpack_require__( /*! ./store_helper */ 83),
            queryByOptions = storeHelper.queryByOptions,
            Deferred = __webpack_require__( /*! ../core/utils/deferred */ 6).Deferred,
            noop = __webpack_require__( /*! ../core/utils/common */ 4).noop,
            storeImpl = {};
        var Store = Class.inherit({
            ctor: function(options) {
                var that = this;
                options = options || {};
                each(["onLoaded", "onLoading", "onInserted", "onInserting", "onUpdated", "onUpdating", "onPush", "onRemoved", "onRemoving", "onModified", "onModifying"], function(_, optionName) {
                    if (optionName in options) {
                        that.on(optionName.slice(2).toLowerCase(), options[optionName])
                    }
                });
                this._key = options.key;
                this._errorHandler = options.errorHandler;
                this._useDefaultSearch = true
            },
            _customLoadOptions: function() {
                return null
            },
            key: function() {
                return this._key
            },
            keyOf: function(obj) {
                if (!this._keyGetter) {
                    this._keyGetter = compileGetter(this.key())
                }
                return this._keyGetter(obj)
            },
            _requireKey: function() {
                if (!this.key()) {
                    throw errorsModule.errors.Error("E4005")
                }
            },
            load: function(options) {
                var that = this;
                options = options || {};
                this.fireEvent("loading", [options]);
                return this._withLock(this._loadImpl(options)).done(function(result) {
                    that.fireEvent("loaded", [result, options])
                })
            },
            _loadImpl: function(options) {
                return queryByOptions(this.createQuery(options), options).enumerate()
            },
            _withLock: function(task) {
                var result = new Deferred;
                task.done(function() {
                    var that = this,
                        args = arguments;
                    dataUtils.processRequestResultLock.promise().done(function() {
                        result.resolveWith(that, args)
                    })
                }).fail(function() {
                    result.rejectWith(this, arguments)
                });
                return result
            },
            createQuery: abstract,
            totalCount: function(options) {
                return this._totalCountImpl(options)
            },
            _totalCountImpl: function(options) {
                return queryByOptions(this.createQuery(options), options, true).count()
            },
            byKey: function(key, extraOptions) {
                return this._addFailHandlers(this._withLock(this._byKeyImpl(key, extraOptions)))
            },
            _byKeyImpl: abstract,
            insert: function(values) {
                var that = this;
                that.fireEvent("modifying");
                that.fireEvent("inserting", [values]);
                return that._addFailHandlers(that._insertImpl(values).done(function(callbackValues, callbackKey) {
                    that.fireEvent("inserted", [callbackValues, callbackKey]);
                    that.fireEvent("modified")
                }))
            },
            _insertImpl: abstract,
            update: function(key, values) {
                var that = this;
                that.fireEvent("modifying");
                that.fireEvent("updating", [key, values]);
                return that._addFailHandlers(that._updateImpl(key, values).done(function() {
                    that.fireEvent("updated", [key, values]);
                    that.fireEvent("modified")
                }))
            },
            _updateImpl: abstract,
            push: function(changes) {
                this._pushImpl(changes);
                this.fireEvent("push", [changes])
            },
            _pushImpl: noop,
            remove: function(key) {
                var that = this;
                that.fireEvent("modifying");
                that.fireEvent("removing", [key]);
                return that._addFailHandlers(that._removeImpl(key).done(function(callbackKey) {
                    that.fireEvent("removed", [callbackKey]);
                    that.fireEvent("modified")
                }))
            },
            _removeImpl: abstract,
            _addFailHandlers: function(deferred) {
                return deferred.fail(this._errorHandler).fail(errorsModule._errorHandler)
            }
        }).include(EventsMixin);
        Store.create = function(alias, options) {
            if (!(alias in storeImpl)) {
                throw errorsModule.errors.Error("E4020", alias)
            }
            return new storeImpl[alias](options)
        };
        Store.registerClass = function(type, alias) {
            if (alias) {
                storeImpl[alias] = type
            }
            return type
        };
        Store.inherit = function(inheritor) {
            return function(members, alias) {
                var type = inheritor.apply(this, [members]);
                Store.registerClass(type, alias);
                return type
            }
        }(Store.inherit);
        module.exports = Store
    },
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/ui/validation_engine.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _createClass = function() {
            function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                    var descriptor = props[i];
                    descriptor.enumerable = descriptor.enumerable || false;
                    descriptor.configurable = true;
                    if ("value" in descriptor) {
                        descriptor.writable = true
                    }
                    Object.defineProperty(target, descriptor.key, descriptor)
                }
            }
            return function(Constructor, protoProps, staticProps) {
                if (protoProps) {
                    defineProperties(Constructor.prototype, protoProps)
                }
                if (staticProps) {
                    defineProperties(Constructor, staticProps)
                }
                return Constructor
            }
        }();
        var _class = __webpack_require__( /*! ../core/class */ 15);
        var _class2 = _interopRequireDefault(_class);
        var _extend = __webpack_require__( /*! ../core/utils/extend */ 0);
        var _array = __webpack_require__( /*! ../core/utils/array */ 14);
        var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 3);
        var _events_mixin = __webpack_require__( /*! ../core/events_mixin */ 85);
        var _events_mixin2 = _interopRequireDefault(_events_mixin);
        var _errors = __webpack_require__( /*! ../core/errors */ 21);
        var _errors2 = _interopRequireDefault(_errors);
        var _common = __webpack_require__( /*! ../core/utils/common */ 4);
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var _type2 = _interopRequireDefault(_type);
        var _number = __webpack_require__( /*! ../localization/number */ 51);
        var _number2 = _interopRequireDefault(_number);
        var _message = __webpack_require__( /*! ../localization/message */ 10);
        var _message2 = _interopRequireDefault(_message);
        var _promise = __webpack_require__( /*! ../core/polyfills/promise */ 66);
        var _promise2 = _interopRequireDefault(_promise);
        var _deferred = __webpack_require__( /*! ../core/utils/deferred */ 6);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function _possibleConstructorReturn(self, call) {
            if (!self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called")
            }
            return call && ("object" === typeof call || "function" === typeof call) ? call : self
        }

        function _inherits(subClass, superClass) {
            if ("function" !== typeof superClass && null !== superClass) {
                throw new TypeError("Super expression must either be null or a function, not " + typeof superClass)
            }
            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    enumerable: false,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) {
                Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass
            }
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }
        var VALIDATION_STATUS_VALID = "valid",
            VALIDATION_STATUS_INVALID = "invalid",
            VALIDATION_STATUS_PENDING = "pending";
        var BaseRuleValidator = function() {
            function BaseRuleValidator() {
                _classCallCheck(this, BaseRuleValidator);
                this.NAME = "base"
            }
            _createClass(BaseRuleValidator, [{
                key: "defaultMessage",
                value: function(value) {
                    return _message2.default.getFormatter("validation-" + this.NAME)(value)
                }
            }, {
                key: "defaultFormattedMessage",
                value: function(value) {
                    return _message2.default.getFormatter("validation-" + this.NAME + "-formatted")(value)
                }
            }, {
                key: "_isValueEmpty",
                value: function(value) {
                    return !rulesValidators.required.validate(value, {})
                }
            }, {
                key: "validate",
                value: function(value, rule) {
                    var _this = this;
                    var valueArray = Array.isArray(value) ? value : [value];
                    var result = true;
                    if (valueArray.length) {
                        valueArray.every(function(itemValue) {
                            result = _this._validate(itemValue, rule);
                            return result
                        })
                    } else {
                        result = this._validate(null, rule)
                    }
                    return result
                }
            }]);
            return BaseRuleValidator
        }();
        var RequiredRuleValidator = function(_BaseRuleValidator) {
            _inherits(RequiredRuleValidator, _BaseRuleValidator);

            function RequiredRuleValidator() {
                _classCallCheck(this, RequiredRuleValidator);
                var _this2 = _possibleConstructorReturn(this, (RequiredRuleValidator.__proto__ || Object.getPrototypeOf(RequiredRuleValidator)).call(this));
                _this2.NAME = "required";
                return _this2
            }
            _createClass(RequiredRuleValidator, [{
                key: "_validate",
                value: function(value, rule) {
                    if (!_type2.default.isDefined(value)) {
                        return false
                    }
                    if (false === value) {
                        return false
                    }
                    value = String(value);
                    if (rule.trim || !_type2.default.isDefined(rule.trim)) {
                        value = value.trim()
                    }
                    return "" !== value
                }
            }]);
            return RequiredRuleValidator
        }(BaseRuleValidator);
        var NumericRuleValidator = function(_BaseRuleValidator2) {
            _inherits(NumericRuleValidator, _BaseRuleValidator2);

            function NumericRuleValidator() {
                _classCallCheck(this, NumericRuleValidator);
                var _this3 = _possibleConstructorReturn(this, (NumericRuleValidator.__proto__ || Object.getPrototypeOf(NumericRuleValidator)).call(this));
                _this3.NAME = "numeric";
                return _this3
            }
            _createClass(NumericRuleValidator, [{
                key: "_validate",
                value: function(value, rule) {
                    if (false !== rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }
                    if (rule.useCultureSettings && _type2.default.isString(value)) {
                        return !isNaN(_number2.default.parse(value))
                    } else {
                        return _type2.default.isNumeric(value)
                    }
                }
            }]);
            return NumericRuleValidator
        }(BaseRuleValidator);
        var RangeRuleValidator = function(_BaseRuleValidator3) {
            _inherits(RangeRuleValidator, _BaseRuleValidator3);

            function RangeRuleValidator() {
                _classCallCheck(this, RangeRuleValidator);
                var _this4 = _possibleConstructorReturn(this, (RangeRuleValidator.__proto__ || Object.getPrototypeOf(RangeRuleValidator)).call(this));
                _this4.NAME = "range";
                return _this4
            }
            _createClass(RangeRuleValidator, [{
                key: "_validate",
                value: function(value, rule) {
                    if (false !== rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }
                    var validNumber = rulesValidators.numeric.validate(value, rule),
                        validValue = _type2.default.isDefined(value) && "" !== value,
                        number = validNumber ? parseFloat(value) : validValue && value.valueOf(),
                        min = rule.min,
                        max = rule.max;
                    if (!(validNumber || _type2.default.isDate(value)) && !validValue) {
                        return false
                    }
                    if (_type2.default.isDefined(min)) {
                        if (_type2.default.isDefined(max)) {
                            return number >= min && number <= max
                        }
                        return number >= min
                    } else {
                        if (_type2.default.isDefined(max)) {
                            return number <= max
                        } else {
                            throw _errors2.default.Error("E0101")
                        }
                    }
                }
            }]);
            return RangeRuleValidator
        }(BaseRuleValidator);
        var StringLengthRuleValidator = function(_BaseRuleValidator4) {
            _inherits(StringLengthRuleValidator, _BaseRuleValidator4);

            function StringLengthRuleValidator() {
                _classCallCheck(this, StringLengthRuleValidator);
                var _this5 = _possibleConstructorReturn(this, (StringLengthRuleValidator.__proto__ || Object.getPrototypeOf(StringLengthRuleValidator)).call(this));
                _this5.NAME = "stringLength";
                return _this5
            }
            _createClass(StringLengthRuleValidator, [{
                key: "_validate",
                value: function(value, rule) {
                    value = _type2.default.isDefined(value) ? String(value) : "";
                    if (rule.trim || !_type2.default.isDefined(rule.trim)) {
                        value = value.trim()
                    }
                    if (rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }
                    return rulesValidators.range.validate(value.length, (0, _extend.extend)({}, rule))
                }
            }]);
            return StringLengthRuleValidator
        }(BaseRuleValidator);
        var CustomRuleValidator = function(_BaseRuleValidator5) {
            _inherits(CustomRuleValidator, _BaseRuleValidator5);

            function CustomRuleValidator() {
                _classCallCheck(this, CustomRuleValidator);
                var _this6 = _possibleConstructorReturn(this, (CustomRuleValidator.__proto__ || Object.getPrototypeOf(CustomRuleValidator)).call(this));
                _this6.NAME = "custom";
                return _this6
            }
            _createClass(CustomRuleValidator, [{
                key: "validate",
                value: function(value, rule) {
                    if (rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }
                    var validator = rule.validator,
                        dataGetter = validator && _type2.default.isFunction(validator.option) && validator.option("dataGetter"),
                        extraParams = _type2.default.isFunction(dataGetter) && dataGetter(),
                        params = {
                            value: value,
                            validator: validator,
                            rule: rule
                        };
                    if (extraParams) {
                        (0, _extend.extend)(params, extraParams)
                    }
                    return rule.validationCallback(params)
                }
            }]);
            return CustomRuleValidator
        }(BaseRuleValidator);
        var AsyncRuleValidator = function(_CustomRuleValidator) {
            _inherits(AsyncRuleValidator, _CustomRuleValidator);

            function AsyncRuleValidator() {
                _classCallCheck(this, AsyncRuleValidator);
                var _this7 = _possibleConstructorReturn(this, (AsyncRuleValidator.__proto__ || Object.getPrototypeOf(AsyncRuleValidator)).call(this));
                _this7.NAME = "async";
                return _this7
            }
            _createClass(AsyncRuleValidator, [{
                key: "validate",
                value: function(value, rule) {
                    if (!_type2.default.isDefined(rule.reevaluate)) {
                        (0, _extend.extend)(rule, {
                            reevaluate: true
                        })
                    }
                    if (rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }
                    var validator = rule.validator,
                        dataGetter = validator && _type2.default.isFunction(validator.option) && validator.option("dataGetter"),
                        extraParams = _type2.default.isFunction(dataGetter) && dataGetter(),
                        params = {
                            value: value,
                            validator: validator,
                            rule: rule
                        };
                    if (extraParams) {
                        (0, _extend.extend)(params, extraParams)
                    }
                    var callbackResult = rule.validationCallback(params);
                    if (!_type2.default.isPromise(callbackResult)) {
                        throw _errors2.default.Error("E0103")
                    }
                    return this._getWrappedPromise((0, _deferred.fromPromise)(callbackResult).promise())
                }
            }, {
                key: "_getWrappedPromise",
                value: function(promise) {
                    var deferred = new _deferred.Deferred;
                    promise.then(function(res) {
                        deferred.resolve(res)
                    }, function(err) {
                        deferred.resolve(_type2.default.isDefined(err) ? err : false)
                    });
                    return deferred.promise()
                }
            }]);
            return AsyncRuleValidator
        }(CustomRuleValidator);
        var CompareRuleValidator = function(_BaseRuleValidator6) {
            _inherits(CompareRuleValidator, _BaseRuleValidator6);

            function CompareRuleValidator() {
                _classCallCheck(this, CompareRuleValidator);
                var _this8 = _possibleConstructorReturn(this, (CompareRuleValidator.__proto__ || Object.getPrototypeOf(CompareRuleValidator)).call(this));
                _this8.NAME = "compare";
                return _this8
            }
            _createClass(CompareRuleValidator, [{
                key: "_validate",
                value: function(value, rule) {
                    if (!rule.comparisonTarget) {
                        throw _errors2.default.Error("E0102")
                    }
                    if (rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }(0, _extend.extend)(rule, {
                        reevaluate: true
                    });
                    var otherValue = rule.comparisonTarget(),
                        type = rule.comparisonType || "==";
                    switch (type) {
                        case "==":
                            return value == otherValue;
                        case "!=":
                            return value != otherValue;
                        case "===":
                            return value === otherValue;
                        case "!==":
                            return value !== otherValue;
                        case ">":
                            return value > otherValue;
                        case ">=":
                            return value >= otherValue;
                        case "<":
                            return value < otherValue;
                        case "<=":
                            return value <= otherValue
                    }
                }
            }]);
            return CompareRuleValidator
        }(BaseRuleValidator);
        var PatternRuleValidator = function(_BaseRuleValidator7) {
            _inherits(PatternRuleValidator, _BaseRuleValidator7);

            function PatternRuleValidator() {
                _classCallCheck(this, PatternRuleValidator);
                var _this9 = _possibleConstructorReturn(this, (PatternRuleValidator.__proto__ || Object.getPrototypeOf(PatternRuleValidator)).call(this));
                _this9.NAME = "pattern";
                return _this9
            }
            _createClass(PatternRuleValidator, [{
                key: "_validate",
                value: function(value, rule) {
                    if (false !== rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }
                    var pattern = rule.pattern;
                    if (_type2.default.isString(pattern)) {
                        pattern = new RegExp(pattern)
                    }
                    return pattern.test(value)
                }
            }]);
            return PatternRuleValidator
        }(BaseRuleValidator);
        var EmailRuleValidator = function(_BaseRuleValidator8) {
            _inherits(EmailRuleValidator, _BaseRuleValidator8);

            function EmailRuleValidator() {
                _classCallCheck(this, EmailRuleValidator);
                var _this10 = _possibleConstructorReturn(this, (EmailRuleValidator.__proto__ || Object.getPrototypeOf(EmailRuleValidator)).call(this));
                _this10.NAME = "email";
                return _this10
            }
            _createClass(EmailRuleValidator, [{
                key: "_validate",
                value: function(value, rule) {
                    if (false !== rule.ignoreEmptyValue && this._isValueEmpty(value)) {
                        return true
                    }
                    return rulesValidators.pattern.validate(value, (0, _extend.extend)({}, rule, {
                        pattern: /^[\d\w._-]+@([\d\w._-]+\.)+[\w]+$/i
                    }))
                }
            }]);
            return EmailRuleValidator
        }(BaseRuleValidator);
        var rulesValidators = {
            required: new RequiredRuleValidator,
            numeric: new NumericRuleValidator,
            range: new RangeRuleValidator,
            stringLength: new StringLengthRuleValidator,
            custom: new CustomRuleValidator,
            async: new AsyncRuleValidator,
            compare: new CompareRuleValidator,
            pattern: new PatternRuleValidator,
            email: new EmailRuleValidator
        };
        var GroupConfig = _class2.default.inherit({
            ctor: function(group) {
                this.group = group;
                this.validators = [];
                this._pendingValidators = [];
                this._onValidatorStatusChanged = this._onValidatorStatusChanged.bind(this);
                this._resetValidationInfo()
            },
            validate: function() {
                var _this11 = this;
                var result = {
                    isValid: true,
                    brokenRules: [],
                    validators: [],
                    status: VALIDATION_STATUS_VALID,
                    complete: null
                };
                this._unsubscribeFromAllChangeEvents();
                this._pendingValidators = [];
                this._resetValidationInfo();
                (0, _iterator.each)(this.validators, function(_, validator) {
                    var validatorResult = validator.validate();
                    result.isValid = result.isValid && validatorResult.isValid;
                    if (validatorResult.brokenRules) {
                        result.brokenRules = result.brokenRules.concat(validatorResult.brokenRules)
                    }
                    result.validators.push(validator);
                    if (validatorResult.status === VALIDATION_STATUS_PENDING) {
                        _this11._addPendingValidator(validator)
                    }
                    _this11._subscribeToChangeEvents(validator)
                });
                if (this._pendingValidators.length) {
                    result.status = VALIDATION_STATUS_PENDING
                } else {
                    result.status = result.isValid ? VALIDATION_STATUS_VALID : VALIDATION_STATUS_INVALID;
                    this._unsubscribeFromAllChangeEvents();
                    this._raiseValidatedEvent(result)
                }
                this._updateValidationInfo(result);
                return (0, _extend.extend)({}, this._validationInfo.result)
            },
            _subscribeToChangeEvents: function(validator) {
                validator.on("validating", this._onValidatorStatusChanged);
                validator.on("validated", this._onValidatorStatusChanged)
            },
            _unsubscribeFromChangeEvents: function(validator) {
                validator.off("validating", this._onValidatorStatusChanged);
                validator.off("validated", this._onValidatorStatusChanged)
            },
            _unsubscribeFromAllChangeEvents: function() {
                var _this12 = this;
                (0, _iterator.each)(this.validators, function(_, validator) {
                    _this12._unsubscribeFromChangeEvents(validator)
                })
            },
            _updateValidationInfo: function(result) {
                this._validationInfo.result = result;
                if (result.status !== VALIDATION_STATUS_PENDING) {
                    return
                }
                if (!this._validationInfo.deferred) {
                    this._validationInfo.deferred = new _deferred.Deferred;
                    this._validationInfo.result.complete = this._validationInfo.deferred.promise()
                }
            },
            _addPendingValidator: function(validator) {
                var foundValidator = (0, _common.grep)(this._pendingValidators, function(val) {
                    return val === validator
                })[0];
                if (!foundValidator) {
                    this._pendingValidators.push(validator)
                }
            },
            _removePendingValidator: function(validator) {
                var index = (0, _array.inArray)(validator, this._pendingValidators);
                if (index >= 0) {
                    this._pendingValidators.splice(index, 1)
                }
            },
            _orderBrokenRules: function(brokenRules) {
                var orderedRules = [];
                (0, _iterator.each)(this.validators, function(_, validator) {
                    var foundRules = (0, _common.grep)(brokenRules, function(rule) {
                        return rule.validator === validator
                    });
                    if (foundRules.length) {
                        orderedRules = orderedRules.concat(foundRules)
                    }
                });
                return orderedRules
            },
            _updateBrokenRules: function(result) {
                if (!this._validationInfo.result) {
                    return
                }
                var brokenRules = this._validationInfo.result.brokenRules;
                var rules = (0, _common.grep)(brokenRules, function(rule) {
                    return rule.validator !== result.validator
                });
                if (result.brokenRules) {
                    brokenRules = rules.concat(result.brokenRules)
                }
                this._validationInfo.result.brokenRules = this._orderBrokenRules(brokenRules)
            },
            _onValidatorStatusChanged: function(result) {
                if (result.status === VALIDATION_STATUS_PENDING) {
                    this._addPendingValidator(result.validator);
                    return
                }
                this._resolveIfComplete(result)
            },
            _resolveIfComplete: function(result) {
                this._removePendingValidator(result.validator);
                this._updateBrokenRules(result);
                if (!this._pendingValidators.length) {
                    this._unsubscribeFromAllChangeEvents();
                    if (!this._validationInfo.result) {
                        return
                    }
                    this._validationInfo.result.status = 0 === this._validationInfo.result.brokenRules.length ? VALIDATION_STATUS_VALID : VALIDATION_STATUS_INVALID;
                    this._validationInfo.result.isValid = this._validationInfo.result.status === VALIDATION_STATUS_VALID;
                    var res = (0, _extend.extend)({}, this._validationInfo.result, {
                            complete: null
                        }),
                        deferred = this._validationInfo.deferred;
                    this._resetValidationInfo();
                    this._raiseValidatedEvent(res);
                    deferred && setTimeout(function() {
                        deferred.resolve(res)
                    })
                }
            },
            _raiseValidatedEvent: function(result) {
                this.fireEvent("validated", [result])
            },
            _resetValidationInfo: function() {
                this._validationInfo = {
                    result: null,
                    deferred: null
                }
            },
            _synchronizeValidationInfo: function() {
                if (this._validationInfo.result) {
                    this._validationInfo.result.validators = this.validators
                }
            },
            removeRegisteredValidator: function(validator) {
                var index = (0, _array.inArray)(validator, this.validators);
                if (index > -1) {
                    this.validators.splice(index, 1);
                    this._synchronizeValidationInfo();
                    this._resolveIfComplete({
                        validator: validator
                    })
                }
            },
            registerValidator: function(validator) {
                if ((0, _array.inArray)(validator, this.validators) < 0) {
                    this.validators.push(validator);
                    this._synchronizeValidationInfo()
                }
            },
            reset: function() {
                (0, _iterator.each)(this.validators, function(_, validator) {
                    validator.reset()
                });
                this._pendingValidators = [];
                this._resetValidationInfo()
            }
        }).include(_events_mixin2.default);
        var ValidationEngine = {
            groups: [],
            getGroupConfig: function(group) {
                var result = (0, _common.grep)(this.groups, function(config) {
                    return config.group === group
                });
                if (result.length) {
                    return result[0]
                }
            },
            initGroups: function() {
                this.groups = [];
                this.addGroup()
            },
            addGroup: function(group) {
                var config = this.getGroupConfig(group);
                if (!config) {
                    config = new GroupConfig(group);
                    this.groups.push(config)
                }
                return config
            },
            removeGroup: function(group) {
                var config = this.getGroupConfig(group),
                    index = (0, _array.inArray)(config, this.groups);
                if (index > -1) {
                    this.groups.splice(index, 1)
                }
                return config
            },
            _setDefaultMessage: function(info) {
                var rule = info.rule,
                    validator = info.validator,
                    name = info.name;
                if (!_type2.default.isDefined(rule.message)) {
                    if (validator.defaultFormattedMessage && _type2.default.isDefined(name)) {
                        rule.message = validator.defaultFormattedMessage(name)
                    } else {
                        rule.message = validator.defaultMessage()
                    }
                }
            },
            _addBrokenRule: function(info) {
                var result = info.result,
                    rule = info.rule;
                if (!result.brokenRule) {
                    result.brokenRule = rule
                }
                if (!result.brokenRules) {
                    result.brokenRules = []
                }
                result.brokenRules.push(rule)
            },
            validate: function(value, rules, name) {
                var _this13 = this;
                var result = {
                    name: name,
                    value: value,
                    brokenRule: null,
                    brokenRules: null,
                    isValid: true,
                    validationRules: rules,
                    pendingRules: null,
                    status: VALIDATION_STATUS_VALID,
                    complete: null
                };
                var asyncRuleItems = [];
                (0, _iterator.each)(rules || [], function(_, rule) {
                    var ruleValidator = rulesValidators[rule.type];
                    var ruleValidationResult = void 0;
                    if (ruleValidator) {
                        if (_type2.default.isDefined(rule.isValid) && rule.value === value && !rule.reevaluate) {
                            if (!rule.isValid) {
                                result.isValid = false;
                                _this13._addBrokenRule({
                                    result: result,
                                    rule: rule
                                });
                                return false
                            }
                            return true
                        }
                        rule.value = value;
                        if ("async" === rule.type) {
                            asyncRuleItems.push({
                                rule: rule,
                                ruleValidator: ruleValidator
                            });
                            return true
                        }
                        ruleValidationResult = ruleValidator.validate(value, rule);
                        rule.isValid = ruleValidationResult;
                        if (!ruleValidationResult) {
                            result.isValid = false;
                            _this13._setDefaultMessage({
                                rule: rule,
                                validator: ruleValidator,
                                name: name
                            });
                            _this13._addBrokenRule({
                                result: result,
                                rule: rule
                            })
                        }
                        if (!rule.isValid) {
                            return false
                        }
                    } else {
                        throw _errors2.default.Error("E0100")
                    }
                });
                if (result.isValid && !result.brokenRules && asyncRuleItems.length) {
                    result = this._validateAsyncRules({
                        value: value,
                        items: asyncRuleItems,
                        result: result,
                        name: name
                    })
                }
                result.status = result.pendingRules ? VALIDATION_STATUS_PENDING : result.isValid ? VALIDATION_STATUS_VALID : VALIDATION_STATUS_INVALID;
                return result
            },
            _validateAsyncRules: function(_ref) {
                var _this14 = this;
                var result = _ref.result,
                    value = _ref.value,
                    items = _ref.items,
                    name = _ref.name;
                var asyncResults = [];
                (0, _iterator.each)(items, function(_, item) {
                    var validateResult = item.ruleValidator.validate(value, item.rule);
                    if (!_type2.default.isPromise(validateResult)) {
                        _this14._updateRuleConfig({
                            rule: item.rule,
                            ruleResult: _this14._getPatchedRuleResult(validateResult),
                            validator: item.ruleValidator,
                            name: name
                        })
                    } else {
                        if (!result.pendingRules) {
                            result.pendingRules = []
                        }
                        result.pendingRules.push(item.rule);
                        var asyncResult = validateResult.then(function(res) {
                            var ruleResult = _this14._getPatchedRuleResult(res);
                            _this14._updateRuleConfig({
                                rule: item.rule,
                                ruleResult: ruleResult,
                                validator: item.ruleValidator,
                                name: name
                            });
                            return ruleResult
                        });
                        asyncResults.push(asyncResult)
                    }
                });
                if (asyncResults.length) {
                    result.complete = _promise2.default.all(asyncResults).then(function(values) {
                        return _this14._getAsyncRulesResult({
                            result: result,
                            values: values
                        })
                    })
                }
                return result
            },
            _updateRuleConfig: function(_ref2) {
                var rule = _ref2.rule,
                    ruleResult = _ref2.ruleResult,
                    validator = _ref2.validator,
                    name = _ref2.name;
                rule.isValid = ruleResult.isValid;
                if (!ruleResult.isValid) {
                    if (_type2.default.isDefined(ruleResult.message) && _type2.default.isString(ruleResult.message) && ruleResult.message.length) {
                        rule.message = ruleResult.message
                    } else {
                        this._setDefaultMessage({
                            rule: rule,
                            validator: validator,
                            name: name
                        })
                    }
                }
            },
            _getPatchedRuleResult: function(ruleResult) {
                var result = void 0;
                var isValid = true;
                if (_type2.default.isObject(ruleResult)) {
                    result = (0, _extend.extend)({}, ruleResult);
                    if (!_type2.default.isDefined(result.isValid)) {
                        result.isValid = isValid
                    }
                } else {
                    result = {
                        isValid: _type2.default.isBoolean(ruleResult) ? ruleResult : isValid
                    }
                }
                return result
            },
            _getAsyncRulesResult: function(_ref3) {
                var _this15 = this;
                var values = _ref3.values,
                    result = _ref3.result;
                (0, _iterator.each)(values, function(index, val) {
                    if (false === val.isValid) {
                        result.isValid = val.isValid;
                        var rule = result.pendingRules[index];
                        _this15._addBrokenRule({
                            result: result,
                            rule: rule
                        })
                    }
                });
                result.pendingRules = null;
                result.complete = null;
                result.status = result.isValid ? VALIDATION_STATUS_VALID : VALIDATION_STATUS_INVALID;
                return result
            },
            registerValidatorInGroup: function(group, validator) {
                var groupConfig = ValidationEngine.addGroup(group);
                groupConfig.registerValidator.call(groupConfig, validator)
            },
            _shouldRemoveGroup: function(group, validatorsInGroup) {
                var isDefaultGroup = void 0 === group,
                    isValidationGroupInstance = group && "dxValidationGroup" === group.NAME;
                return !isDefaultGroup && !isValidationGroupInstance && !validatorsInGroup.length
            },
            removeRegisteredValidator: function(group, validator) {
                var config = ValidationEngine.getGroupConfig(group);
                if (config) {
                    config.removeRegisteredValidator.call(config, validator);
                    var validatorsInGroup = config.validators;
                    if (this._shouldRemoveGroup(group, validatorsInGroup)) {
                        this.removeGroup(group)
                    }
                }
            },
            validateGroup: function(group) {
                var groupConfig = ValidationEngine.getGroupConfig(group);
                if (!groupConfig) {
                    throw _errors2.default.Error("E0110")
                }
                return groupConfig.validate()
            },
            resetGroup: function(group) {
                var groupConfig = ValidationEngine.getGroupConfig(group);
                if (!groupConfig) {
                    throw _errors2.default.Error("E0110")
                }
                return groupConfig.reset()
            }
        };
        ValidationEngine.initGroups();
        module.exports = ValidationEngine
    },
    /*!*****************************************!*\
      !*** ./artifacts/transpiled/ui/list.js ***!
      \*****************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var ListEdit = __webpack_require__( /*! ./list/ui.list.edit.search */ 521),
            registerComponent = __webpack_require__( /*! ../core/component_registrator */ 8);
        registerComponent("dxList", ListEdit);
        module.exports = ListEdit
    },
    /*!*************************************************************************!*\
      !*** ./artifacts/transpiled/ui/list/ui.list.edit.decorator_registry.js ***!
      \*************************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend;
        exports.registry = {};
        exports.register = function(option, type, decoratorClass) {
            var decoratorsRegistry = exports.registry;
            var decoratorConfig = {};
            decoratorConfig[option] = decoratorsRegistry[option] ? decoratorsRegistry[option] : {};
            decoratorConfig[option][type] = decoratorClass;
            decoratorsRegistry = extend(decoratorsRegistry, decoratorConfig)
        }
    },
    /*!**********************************************!*\
      !*** ./artifacts/transpiled/ui/check_box.js ***!
      \**********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            eventsEngine = __webpack_require__( /*! ../events/core/events_engine */ 5),
            devices = __webpack_require__( /*! ../core/devices */ 16),
            extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            inkRipple = __webpack_require__( /*! ./widget/utils.ink_ripple */ 69),
            Editor = __webpack_require__( /*! ./editor/editor */ 49),
            registerComponent = __webpack_require__( /*! ../core/component_registrator */ 8),
            eventUtils = __webpack_require__( /*! ../events/utils */ 9),
            clickEvent = __webpack_require__( /*! ../events/click */ 19);
        var CHECKBOX_CLASS = "dx-checkbox",
            CHECKBOX_ICON_CLASS = "dx-checkbox-icon",
            CHECKBOX_CHECKED_CLASS = "dx-checkbox-checked",
            CHECKBOX_CONTAINER_CLASS = "dx-checkbox-container",
            CHECKBOX_TEXT_CLASS = "dx-checkbox-text",
            CHECKBOX_HAS_TEXT_CLASS = "dx-checkbox-has-text",
            CHECKBOX_INDETERMINATE_CLASS = "dx-checkbox-indeterminate",
            CHECKBOX_FEEDBACK_HIDE_TIMEOUT = 100;
        var CheckBox = Editor.inherit({
            _supportedKeys: function() {
                var click = function(e) {
                    e.preventDefault();
                    this._clickAction({
                        event: e
                    })
                };
                return extend(this.callBase(), {
                    space: click
                })
            },
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    hoverStateEnabled: true,
                    activeStateEnabled: true,
                    value: false,
                    text: "",
                    useInkRipple: false
                })
            },
            _defaultOptionsRules: function() {
                return this.callBase().concat([{
                    device: function() {
                        return "desktop" === devices.real().deviceType && !devices.isSimulator()
                    },
                    options: {
                        focusStateEnabled: true
                    }
                }])
            },
            _canValueBeChangedByClick: function() {
                return true
            },
            _feedbackHideTimeout: CHECKBOX_FEEDBACK_HIDE_TIMEOUT,
            _initMarkup: function() {
                this._renderSubmitElement();
                this._$container = $("<div>").addClass(CHECKBOX_CONTAINER_CLASS);
                this.setAria("role", "checkbox");
                this.$element().addClass(CHECKBOX_CLASS);
                this._renderValue();
                this._renderIcon();
                this._renderText();
                this.option("useInkRipple") && this._renderInkRipple();
                this.$element().append(this._$container);
                this.callBase()
            },
            _render: function() {
                this._renderClick();
                this.callBase()
            },
            _renderSubmitElement: function() {
                this._$submitElement = $("<input>").attr("type", "hidden").appendTo(this.$element())
            },
            _getSubmitElement: function() {
                return this._$submitElement
            },
            _renderInkRipple: function() {
                this._inkRipple = inkRipple.render({
                    waveSizeCoefficient: 2.5,
                    useHoldAnimation: false,
                    wavesNumber: 2,
                    isCentered: true
                })
            },
            _renderInkWave: function(element, dxEvent, doRender, waveIndex) {
                if (!this._inkRipple) {
                    return
                }
                var config = {
                    element: element,
                    event: dxEvent,
                    wave: waveIndex
                };
                if (doRender) {
                    this._inkRipple.showWave(config)
                } else {
                    this._inkRipple.hideWave(config)
                }
            },
            _updateFocusState: function(e, value) {
                this.callBase.apply(this, arguments);
                this._renderInkWave(this._$icon, e, value, 0)
            },
            _toggleActiveState: function($element, value, e) {
                this.callBase.apply(this, arguments);
                this._renderInkWave(this._$icon, e, value, 1)
            },
            _renderIcon: function() {
                this._$icon = $("<span>").addClass(CHECKBOX_ICON_CLASS).prependTo(this._$container)
            },
            _renderText: function() {
                var textValue = this.option("text");
                if (!textValue) {
                    if (this._$text) {
                        this._$text.remove();
                        this.$element().removeClass(CHECKBOX_HAS_TEXT_CLASS)
                    }
                    return
                }
                if (!this._$text) {
                    this._$text = $("<span>").addClass(CHECKBOX_TEXT_CLASS)
                }
                this._$text.text(textValue);
                this._$container.append(this._$text);
                this.$element().addClass(CHECKBOX_HAS_TEXT_CLASS)
            },
            _renderClick: function() {
                var that = this,
                    eventName = eventUtils.addNamespace(clickEvent.name, that.NAME);
                that._clickAction = that._createAction(that._clickHandler);
                eventsEngine.off(that.$element(), eventName);
                eventsEngine.on(that.$element(), eventName, function(e) {
                    that._clickAction({
                        event: e
                    })
                })
            },
            _clickHandler: function(args) {
                var that = args.component;
                that._saveValueChangeEvent(args.event);
                that.option("value", !that.option("value"))
            },
            _renderValue: function() {
                var $element = this.$element(),
                    checked = this.option("value"),
                    indeterminate = void 0 === checked;
                $element.toggleClass(CHECKBOX_CHECKED_CLASS, Boolean(checked));
                $element.toggleClass(CHECKBOX_INDETERMINATE_CLASS, indeterminate);
                this._getSubmitElement().val(checked);
                this.setAria("checked", indeterminate ? "mixed" : checked || "false")
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "useInkRipple":
                        this._invalidate();
                        break;
                    case "value":
                        this._renderValue();
                        this.callBase(args);
                        break;
                    case "text":
                        this._renderText();
                        this._renderDimensions();
                        break;
                    default:
                        this.callBase(args)
                }
            },
            _clean: function() {
                delete this._inkRipple;
                this.callBase()
            }
        });
        registerComponent("dxCheckBox", CheckBox);
        module.exports = CheckBox
    },
    /*!*********************************************************!*\
      !*** ./artifacts/transpiled/ui/shared/accessibility.js ***!
      \*********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _renderer = __webpack_require__( /*! ../../core/renderer */ 2);
        var _renderer2 = _interopRequireDefault(_renderer);
        var _events_engine = __webpack_require__( /*! ../../events/core/events_engine */ 5);
        var _events_engine2 = _interopRequireDefault(_events_engine);
        var _utils = __webpack_require__( /*! ../../events/utils */ 9);
        var _utils2 = _interopRequireDefault(_utils);
        var _extend = __webpack_require__( /*! ../../core/utils/extend */ 0);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        var FOCUS_STATE_CLASS = "dx-state-focused",
            FOCUS_DISABLED_CLASS = "dx-cell-focus-disabled",
            GRID_CELL_SELECTOR = ".dx-datagrid-rowsview .dx-datagrid-content .dx-row > td",
            TREELIST_CELL_SELECTOR = ".dx-treelist-rowsview .dx-treelist-content .dx-row > td",
            viewItemSelectorMap = {
                groupPanel: [".dx-datagrid-group-panel .dx-group-panel-item[tabindex]"],
                columnHeaders: [".dx-datagrid-headers .dx-header-row > td.dx-datagrid-action", ".dx-treelist-headers .dx-header-row > td.dx-treelist-action"],
                filterRow: [".dx-datagrid-headers .dx-datagrid-filter-row .dx-editor-cell input", ".dx-treelist-headers .dx-treelist-filter-row .dx-editor-cell input"],
                rowsView: [GRID_CELL_SELECTOR + "[tabindex]", "" + GRID_CELL_SELECTOR, TREELIST_CELL_SELECTOR + "[tabindex]", "" + TREELIST_CELL_SELECTOR],
                footer: [".dx-datagrid-total-footer .dx-datagrid-summary-item", ".dx-treelist-total-footer .dx-treelist-summary-item"],
                filterPanel: [".dx-datagrid-filter-panel .dx-icon-filter", ".dx-treelist-filter-panel .dx-icon-filter"],
                pager: [".dx-datagrid-pager [tabindex]", ".dx-treelist-pager [tabindex]"]
            };
        var isMouseDown = false,
            isHiddenFocusing = false,
            focusedElementInfo = null;

        function processKeyDown(viewName, instance, event, action, $mainElement, executeKeyDown) {
            var isHandled = fireKeyDownEvent(instance, event.originalEvent, executeKeyDown);
            if (isHandled) {
                return
            }
            var keyName = _utils2.default.normalizeKeyName(event);
            if ("enter" === keyName || "space" === keyName) {
                saveFocusedElementInfo(event.target, instance);
                action && action({
                    event: event
                })
            } else {
                if ("tab" === keyName) {
                    $mainElement.addClass(FOCUS_STATE_CLASS)
                } else {
                    module.exports.selectView(viewName, instance, event)
                }
            }
        }

        function saveFocusedElementInfo(target, instance) {
            var $target = (0, _renderer2.default)(target),
                ariaLabel = $target.attr("aria-label"),
                $activeElements = getActiveAccessibleElements(ariaLabel, instance.element()),
                targetIndex = $activeElements.index($target);
            focusedElementInfo = (0, _extend.extend)({}, {
                ariaLabel: ariaLabel,
                index: targetIndex
            }, {
                viewInstance: instance
            })
        }

        function getActiveAccessibleElements(ariaLabel, viewElement) {
            var $activeElements, $viewElement = (0, _renderer2.default)(viewElement);
            if (ariaLabel) {
                $activeElements = $viewElement.find('[aria-label="' + ariaLabel + '"][tabindex]')
            } else {
                $activeElements = $viewElement.find("[tabindex]")
            }
            return $activeElements
        }

        function findFocusedViewElement(viewSelectors) {
            for (var index in viewSelectors) {
                var selector = viewSelectors[index],
                    $focusViewElement = void 0;
                $focusViewElement = (0, _renderer2.default)(selector).first();
                if ($focusViewElement.length) {
                    return $focusViewElement
                }
            }
        }

        function fireKeyDownEvent(instance, event, executeAction) {
            var args = {
                event: event,
                handled: false
            };
            if (executeAction) {
                executeAction(args)
            } else {
                instance._createActionByOption("onKeyDown")(args)
            }
            return args.handled
        }
        module.exports = {
            hiddenFocus: function(element) {
                isHiddenFocusing = true;
                element.focus();
                isHiddenFocusing = false
            },
            registerKeyboardAction: function(viewName, instance, $element, selector, action, executeKeyDown) {
                if (instance.option("useLegacyKeyboardNavigation")) {
                    return
                }
                var $mainElement = (0, _renderer2.default)(instance.element());
                _events_engine2.default.on($element, "keydown", selector, function(e) {
                    return processKeyDown(viewName, instance, e, action, $mainElement, executeKeyDown)
                });
                _events_engine2.default.on($element, "mousedown", selector, function() {
                    isMouseDown = true;
                    $mainElement.removeClass(FOCUS_STATE_CLASS)
                });
                _events_engine2.default.on($element, "focusin", selector, function() {
                    if (!isMouseDown && !isHiddenFocusing) {
                        $mainElement.addClass(FOCUS_STATE_CLASS)
                    }
                    isMouseDown = false
                })
            },
            restoreFocus: function(instance) {
                if (!instance.option("useLegacyKeyboardNavigation") && focusedElementInfo) {
                    var viewInstance = focusedElementInfo.viewInstance;
                    if (viewInstance) {
                        var $activeElements = getActiveAccessibleElements(focusedElementInfo.ariaLabel, viewInstance.element()),
                            $targetElement = $activeElements.eq(focusedElementInfo.index);
                        focusedElementInfo = null;
                        _events_engine2.default.trigger($targetElement, "focus")
                    }
                }
            },
            selectView: function(viewName, instance, event) {
                var keyName = _utils2.default.normalizeKeyName(event);
                if (event.ctrlKey && ("upArrow" === keyName || "downArrow" === keyName)) {
                    var viewNames = Object.keys(viewItemSelectorMap),
                        viewItemIndex = viewNames.indexOf(viewName);
                    while (viewItemIndex >= 0 && viewItemIndex < viewNames.length) {
                        viewItemIndex = "upArrow" === keyName ? --viewItemIndex : ++viewItemIndex;
                        var _viewName = viewNames[viewItemIndex],
                            viewSelectors = viewItemSelectorMap[_viewName],
                            $focusViewElement = findFocusedViewElement(viewSelectors);
                        if ($focusViewElement && $focusViewElement.length) {
                            $focusViewElement.attr("tabindex", instance.option("tabindex") || 0);
                            _events_engine2.default.trigger($focusViewElement, "focus");
                            $focusViewElement.removeClass(FOCUS_DISABLED_CLASS);
                            break
                        }
                    }
                }
            },
            setTabIndex: function(instance, $element) {
                if (!instance.option("useLegacyKeyboardnavigation")) {
                    $element.attr("tabindex", instance.option("tabindex") || 0)
                }
            }
        }
    }, , , , ,
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/data/odata/utils.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var Class = __webpack_require__( /*! ../../core/class */ 15),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            typeUtils = __webpack_require__( /*! ../../core/utils/type */ 1),
            iteratorUtils = __webpack_require__( /*! ../../core/utils/iterator */ 3),
            each = __webpack_require__( /*! ../../core/utils/iterator */ 3).each,
            ajax = __webpack_require__( /*! ../../core/utils/ajax */ 62),
            _Guid = __webpack_require__( /*! ../../core/guid */ 34),
            isDefined = typeUtils.isDefined,
            isPlainObject = typeUtils.isPlainObject,
            grep = __webpack_require__( /*! ../../core/utils/common */ 4).grep,
            Deferred = __webpack_require__( /*! ../../core/utils/deferred */ 6).Deferred,
            errors = __webpack_require__( /*! ../errors */ 37).errors,
            dataUtils = __webpack_require__( /*! ../utils */ 41);
        var GUID_REGEX = /^(\{{0,1}([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}\}{0,1})$/;
        var VERBOSE_DATE_REGEX = /^\/Date\((-?\d+)((\+|-)?(\d+)?)\)\/$/;
        var ISO8601_DATE_REGEX = /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(\.\d+)?(Z|[-+]{1}\d{2}(:?)(\d{2})?)?$/;
        var JSON_VERBOSE_MIME_TYPE = "application/json;odata=verbose";
        var makeArray = function(value) {
            return "string" === typeUtils.type(value) ? value.split() : value
        };
        var hasDot = function(x) {
            return /\./.test(x)
        };
        var pad = function(text, length, right) {
            text = String(text);
            while (text.length < length) {
                text = right ? text + "0" : "0" + text
            }
            return text
        };

        function formatISO8601(date, skipZeroTime, skipTimezone) {
            var bag = [];
            var isZeroTime = function() {
                return date.getHours() + date.getMinutes() + date.getSeconds() + date.getMilliseconds() < 1
            };
            var padLeft2 = function(text) {
                return pad(text, 2)
            };
            bag.push(date.getFullYear());
            bag.push("-");
            bag.push(padLeft2(date.getMonth() + 1));
            bag.push("-");
            bag.push(padLeft2(date.getDate()));
            if (!(skipZeroTime && isZeroTime())) {
                bag.push("T");
                bag.push(padLeft2(date.getHours()));
                bag.push(":");
                bag.push(padLeft2(date.getMinutes()));
                bag.push(":");
                bag.push(padLeft2(date.getSeconds()));
                if (date.getMilliseconds()) {
                    bag.push(".");
                    bag.push(pad(date.getMilliseconds(), 3))
                }
                if (!skipTimezone) {
                    bag.push("Z")
                }
            }
            return bag.join("")
        }

        function parseISO8601(isoString) {
            var result = new Date(60 * new Date(0).getTimezoneOffset() * 1e3),
                chunks = isoString.replace("Z", "").split("T"),
                date = /(\d{4})-(\d{2})-(\d{2})/.exec(chunks[0]),
                time = /(\d{2}):(\d{2}):(\d{2})\.?(\d{0,7})?/.exec(chunks[1]);
            result.setFullYear(Number(date[1]));
            result.setMonth(Number(date[2]) - 1);
            result.setDate(Number(date[3]));
            if (Array.isArray(time) && time.length) {
                result.setHours(Number(time[1]));
                result.setMinutes(Number(time[2]));
                result.setSeconds(Number(time[3]));
                var fractional = (time[4] || "").slice(0, 3);
                fractional = pad(fractional, 3, true);
                result.setMilliseconds(Number(fractional))
            }
            return result
        }

        function isAbsoluteUrl(url) {
            return /^(?:[a-z]+:)?\/\//i.test(url)
        }

        function toAbsoluteUrl(basePath, relativePath) {
            var part;
            var baseParts = stripParams(basePath).split("/");
            var relativeParts = relativePath.split("/");

            function stripParams(url) {
                var index = url.indexOf("?");
                if (index > -1) {
                    return url.substr(0, index)
                }
                return url
            }
            baseParts.pop();
            while (relativeParts.length) {
                part = relativeParts.shift();
                if (".." === part) {
                    baseParts.pop()
                } else {
                    baseParts.push(part)
                }
            }
            return baseParts.join("/")
        }
        var param = function(params) {
            var result = [];
            for (var name in params) {
                result.push(name + "=" + params[name])
            }
            return result.join("&")
        };
        var ajaxOptionsForRequest = function(protocolVersion, request, options) {
            request = extend({
                async: true,
                method: "get",
                url: "",
                params: {},
                payload: null,
                headers: {},
                timeout: 3e4
            }, request);
            options = options || {};
            var beforeSend = options.beforeSend;
            if (beforeSend) {
                beforeSend(request)
            }
            var method = (request.method || "get").toLowerCase(),
                isGet = "get" === method,
                useJsonp = isGet && options.jsonp,
                params = extend({}, request.params),
                ajaxData = isGet ? params : formatPayload(request.payload),
                qs = !isGet && param(params),
                url = request.url,
                contentType = !isGet && JSON_VERBOSE_MIME_TYPE;
            if (qs) {
                url += (url.indexOf("?") > -1 ? "&" : "?") + qs
            }
            if (useJsonp) {
                ajaxData.$format = "json"
            }
            return {
                url: url,
                data: ajaxData,
                dataType: useJsonp ? "jsonp" : "json",
                jsonp: useJsonp && "$callback",
                method: method,
                async: request.async,
                timeout: request.timeout,
                headers: request.headers,
                contentType: contentType,
                accepts: {
                    json: [JSON_VERBOSE_MIME_TYPE, "text/plain"].join()
                },
                xhrFields: {
                    withCredentials: options.withCredentials
                }
            };

            function formatPayload(payload) {
                return JSON.stringify(payload, function(key, value) {
                    if (!(this[key] instanceof Date)) {
                        return value
                    }
                    value = formatISO8601(this[key]);
                    switch (protocolVersion) {
                        case 2:
                            return value.substr(0, value.length - 1);
                        case 3:
                        case 4:
                            return value;
                        default:
                            throw errors.Error("E4002")
                    }
                })
            }
        };
        var sendRequest = function sendRequest(protocolVersion, request, options) {
            var d = new Deferred;
            var ajaxOptions = ajaxOptionsForRequest(protocolVersion, request, options);
            ajax.sendRequest(ajaxOptions).always(function(obj, textStatus) {
                var extra, transformOptions = {
                        deserializeDates: options.deserializeDates,
                        fieldTypes: options.fieldTypes
                    },
                    tuple = interpretJsonFormat(obj, textStatus, transformOptions, ajaxOptions),
                    error = tuple.error,
                    data = tuple.data,
                    nextUrl = tuple.nextUrl;
                if (error) {
                    if (error.message !== dataUtils.XHR_ERROR_UNLOAD) {
                        d.reject(error)
                    }
                } else {
                    if (options.countOnly) {
                        if (isFinite(tuple.count)) {
                            d.resolve(tuple.count)
                        } else {
                            d.reject(new errors.Error("E4018"))
                        }
                    } else {
                        if (nextUrl && !options.isPaged) {
                            if (!isAbsoluteUrl(nextUrl)) {
                                nextUrl = toAbsoluteUrl(ajaxOptions.url, nextUrl)
                            }
                            sendRequest(protocolVersion, {
                                url: nextUrl
                            }, options).fail(d.reject).done(function(nextData) {
                                d.resolve(data.concat(nextData))
                            })
                        } else {
                            if (isFinite(tuple.count)) {
                                extra = {
                                    totalCount: tuple.count
                                }
                            }
                            d.resolve(data, extra)
                        }
                    }
                }
            });
            return d.promise()
        };
        var formatDotNetError = function(errorObj) {
            var message, currentError = errorObj;
            if ("message" in errorObj) {
                if (errorObj.message.value) {
                    message = errorObj.message.value
                } else {
                    message = errorObj.message
                }
            }
            while (currentError = currentError.innererror || currentError.internalexception) {
                message = currentError.message;
                if (currentError.internalexception && message.indexOf("inner exception") === -1) {
                    break
                }
            }
            return message
        };
        var errorFromResponse = function(obj, textStatus, ajaxOptions) {
            if ("nocontent" === textStatus) {
                return null
            }
            var message = "Unknown error",
                response = obj,
                httpStatus = 200,
                errorData = {
                    requestOptions: ajaxOptions
                };
            if ("success" !== textStatus) {
                httpStatus = obj.status;
                message = dataUtils.errorMessageFromXhr(obj, textStatus);
                try {
                    response = JSON.parse(obj.responseText)
                } catch (x) {}
            }
            var errorObj = response && (response.then && response || response.error || response["odata.error"] || response["@odata.error"]);
            if (errorObj) {
                message = formatDotNetError(errorObj) || message;
                errorData.errorDetails = errorObj;
                if (200 === httpStatus) {
                    httpStatus = 500
                }
                var customCode = Number(errorObj.code);
                if (isFinite(customCode) && customCode >= 400) {
                    httpStatus = customCode
                }
            }
            if (httpStatus >= 400 || 0 === httpStatus) {
                errorData.httpStatus = httpStatus;
                return extend(Error(message), errorData)
            }
            return null
        };
        var interpretJsonFormat = function(obj, textStatus, transformOptions, ajaxOptions) {
            var value, error = errorFromResponse(obj, textStatus, ajaxOptions);
            if (error) {
                return {
                    error: error
                }
            }
            if (!isPlainObject(obj)) {
                return {
                    data: obj
                }
            }
            if ("d" in obj && (Array.isArray(obj.d) || typeUtils.isObject(obj.d))) {
                value = interpretVerboseJsonFormat(obj, textStatus)
            } else {
                value = interpretLightJsonFormat(obj, textStatus)
            }
            transformTypes(value, transformOptions);
            return value
        };
        var interpretVerboseJsonFormat = function(obj) {
            var data = obj.d;
            if (!isDefined(data)) {
                return {
                    error: Error("Malformed or unsupported JSON response received")
                }
            }
            if (isDefined(data.results)) {
                data = data.results
            }
            return {
                data: data,
                nextUrl: obj.d.__next,
                count: parseInt(obj.d.__count, 10)
            }
        };
        var interpretLightJsonFormat = function(obj) {
            var data = obj;
            if (isDefined(data.value)) {
                data = data.value
            }
            return {
                data: data,
                nextUrl: obj["@odata.nextLink"],
                count: parseInt(obj["@odata.count"], 10)
            }
        };
        var EdmLiteral = Class.inherit({
            ctor: function(value) {
                this._value = value
            },
            valueOf: function() {
                return this._value
            }
        });
        var transformTypes = function transformTypes(obj, options) {
            options = options || {};
            each(obj, function(key, value) {
                if (null !== value && "object" === ("undefined" === typeof value ? "undefined" : _typeof(value))) {
                    if ("results" in value) {
                        obj[key] = value.results
                    }
                    transformTypes(obj[key], options)
                } else {
                    if ("string" === typeof value) {
                        var fieldTypes = options.fieldTypes,
                            canBeGuid = !fieldTypes || "String" !== fieldTypes[key];
                        if (canBeGuid && GUID_REGEX.test(value)) {
                            obj[key] = new _Guid(value)
                        }
                        if (false !== options.deserializeDates) {
                            if (value.match(VERBOSE_DATE_REGEX)) {
                                var date = new Date(Number(RegExp.$1) + 60 * RegExp.$2 * 1e3);
                                obj[key] = new Date(date.valueOf() + 60 * date.getTimezoneOffset() * 1e3)
                            } else {
                                if (ISO8601_DATE_REGEX.test(value)) {
                                    obj[key] = new Date(parseISO8601(obj[key]).valueOf())
                                }
                            }
                        }
                    }
                }
            })
        };
        var serializeDate = function(date) {
            return "datetime'" + formatISO8601(date, true, true) + "'"
        };
        var serializeString = function(value) {
            return "'" + value.replace(/'/g, "''") + "'"
        };
        var serializePropName = function(propName) {
            if (propName instanceof EdmLiteral) {
                return propName.valueOf()
            }
            return propName.replace(/\./g, "/")
        };
        var serializeValueV4 = function serializeValueV4(value) {
            if (value instanceof Date) {
                return formatISO8601(value, false, false)
            }
            if (value instanceof _Guid) {
                return value.valueOf()
            }
            if (Array.isArray(value)) {
                return "[" + value.map(function(item) {
                    return serializeValueV4(item)
                }).join(",") + "]"
            }
            return serializeValueV2(value)
        };
        var serializeValueV2 = function(value) {
            if (value instanceof Date) {
                return serializeDate(value)
            }
            if (value instanceof _Guid) {
                return "guid'" + value + "'"
            }
            if (value instanceof EdmLiteral) {
                return value.valueOf()
            }
            if ("string" === typeof value) {
                return serializeString(value)
            }
            return String(value)
        };
        var serializeValue = function(value, protocolVersion) {
            switch (protocolVersion) {
                case 2:
                case 3:
                    return serializeValueV2(value);
                case 4:
                    return serializeValueV4(value);
                default:
                    throw errors.Error("E4002")
            }
        };
        var serializeKey = function(key, protocolVersion) {
            if (isPlainObject(key)) {
                var parts = [];
                each(key, function(k, v) {
                    parts.push(serializePropName(k) + "=" + serializeValue(v, protocolVersion))
                });
                return parts.join()
            }
            return serializeValue(key, protocolVersion)
        };
        var keyConverters = {
            String: function(value) {
                return value + ""
            },
            Int32: function(value) {
                return Math.floor(value)
            },
            Int64: function(value) {
                if (value instanceof EdmLiteral) {
                    return value
                }
                return new EdmLiteral(value + "L")
            },
            Guid: function(value) {
                if (value instanceof _Guid) {
                    return value
                }
                return new _Guid(value)
            },
            Boolean: function(value) {
                return !!value
            },
            Single: function(value) {
                if (value instanceof EdmLiteral) {
                    return value
                }
                return new EdmLiteral(value + "f")
            },
            Decimal: function(value) {
                if (value instanceof EdmLiteral) {
                    return value
                }
                return new EdmLiteral(value + "m")
            }
        };
        var convertPrimitiveValue = function(type, value) {
            if (null === value) {
                return null
            }
            var converter = keyConverters[type];
            if (!converter) {
                throw errors.Error("E4014", type)
            }
            return converter(value)
        };
        var generateSelect = function(oDataVersion, select) {
            if (!select) {
                return
            }
            if (oDataVersion < 4) {
                return serializePropName(select.join())
            }
            return grep(select, hasDot, true).join()
        };
        var generateExpand = function(oDataVersion, expand, select) {
            var generatorV2 = function() {
                var hash = {};
                if (expand) {
                    iteratorUtils.each(makeArray(expand), function() {
                        hash[serializePropName(this)] = 1
                    })
                }
                if (select) {
                    iteratorUtils.each(makeArray(select), function() {
                        var path = this.split(".");
                        if (path.length < 2) {
                            return
                        }
                        path.pop();
                        hash[serializePropName(path.join("."))] = 1
                    })
                }
                return iteratorUtils.map(hash, function(k, v) {
                    return v
                }).join()
            };
            var generatorV4 = function() {
                var format = function(hash) {
                    var formatCore = function formatCore(hash) {
                        var result = "",
                            selectValue = [],
                            expandValue = [];
                        iteratorUtils.each(hash, function(key, value) {
                            if (Array.isArray(value)) {
                                [].push.apply(selectValue, value)
                            }
                            if (isPlainObject(value)) {
                                expandValue.push(key + formatCore(value))
                            }
                        });
                        if (selectValue.length || expandValue.length) {
                            result += "(";
                            if (selectValue.length) {
                                result += "$select=" + iteratorUtils.map(selectValue, serializePropName).join()
                            }
                            if (expandValue.length) {
                                if (selectValue.length) {
                                    result += ";"
                                }
                                result += "$expand=" + iteratorUtils.map(expandValue, serializePropName).join()
                            }
                            result += ")"
                        }
                        return result
                    };
                    var result = [];
                    iteratorUtils.each(hash, function(key, value) {
                        result.push(key + formatCore(value))
                    });
                    return result.join()
                };
                var parseTree = function(exprs, root, stepper) {
                    var parseCore = function parseCore(exprParts, root, stepper) {
                        var result = stepper(root, exprParts.shift(), exprParts);
                        if (false === result) {
                            return
                        }
                        parseCore(exprParts, result, stepper)
                    };
                    iteratorUtils.each(exprs, function(_, x) {
                        parseCore(x.split("."), root, stepper)
                    })
                };
                var hash = {};
                if (expand || select) {
                    if (expand) {
                        parseTree(makeArray(expand), hash, function(node, key, path) {
                            node[key] = node[key] || {};
                            if (!path.length) {
                                return false
                            }
                            return node[key]
                        })
                    }
                    if (select) {
                        parseTree(grep(makeArray(select), hasDot), hash, function(node, key, path) {
                            if (!path.length) {
                                node[key] = node[key] || [];
                                node[key].push(key);
                                return false
                            }
                            return node[key] = node[key] || {}
                        })
                    }
                    return format(hash)
                }
            };
            if (oDataVersion < 4) {
                return generatorV2()
            }
            return generatorV4()
        };
        exports.sendRequest = sendRequest;
        exports.serializePropName = serializePropName;
        exports.serializeValue = serializeValue;
        exports.serializeKey = serializeKey;
        exports.keyConverters = keyConverters;
        exports.convertPrimitiveValue = convertPrimitiveValue;
        exports.generateExpand = generateExpand;
        exports.generateSelect = generateSelect;
        exports.EdmLiteral = EdmLiteral;
        exports.OData__internals = {
            interpretJsonFormat: interpretJsonFormat
        }
    },
    /*!*********************************************!*\
      !*** ./artifacts/transpiled/core/action.js ***!
      \*********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ./renderer */ 2),
            config = __webpack_require__( /*! ./config */ 29),
            window = __webpack_require__( /*! ./utils/window */ 7).getWindow(),
            typeUtils = __webpack_require__( /*! ./utils/type */ 1),
            each = __webpack_require__( /*! ./utils/iterator */ 3).each,
            Class = __webpack_require__( /*! ./class */ 15),
            errors = __webpack_require__( /*! ./errors */ 21);
        var Action = Class.inherit({
            ctor: function(action, config) {
                config = config || {};
                this._action = action;
                this._context = config.context || window;
                this._beforeExecute = config.beforeExecute;
                this._afterExecute = config.afterExecute;
                this._component = config.component;
                this._validatingTargetName = config.validatingTargetName;
                var excludeValidators = this._excludeValidators = {};
                if (config.excludeValidators) {
                    for (var i = 0; i < config.excludeValidators.length; i++) {
                        excludeValidators[config.excludeValidators[i]] = true
                    }
                }
            },
            execute: function() {
                var e = {
                    action: this._action,
                    args: Array.prototype.slice.call(arguments),
                    context: this._context,
                    component: this._component,
                    validatingTargetName: this._validatingTargetName,
                    cancel: false,
                    handled: false
                };
                var beforeExecute = this._beforeExecute,
                    afterExecute = this._afterExecute;
                var argsBag = e.args[0] || {};
                if ("jQueryEvent" in argsBag && !argsBag.event) {
                    throw "The jQueryEvent field is deprecated. Please, use the `event` field instead"
                }
                if (!("jQueryEvent" in argsBag) && argsBag.event && config().useJQuery) {
                    Object.defineProperty(argsBag, "jQueryEvent", {
                        get: function() {
                            errors.log("W0003", "Handler argument", "jQueryEvent", "17.2", "Use the 'event' field instead");
                            return argsBag.event
                        },
                        set: function(value) {
                            errors.log("W0003", "Handler argument", "jQueryEvent", "17.2", "Use the 'event' field instead");
                            argsBag.event = value
                        }
                    })
                }
                if (!this._validateAction(e)) {
                    return
                }
                beforeExecute && beforeExecute.call(this._context, e);
                if (e.cancel) {
                    return
                }
                var result = this._executeAction(e);
                if (argsBag.cancel) {
                    return
                }
                afterExecute && afterExecute.call(this._context, e);
                return result
            },
            _validateAction: function(e) {
                var excludeValidators = this._excludeValidators,
                    executors = Action.executors;
                for (var name in executors) {
                    if (!excludeValidators[name]) {
                        var executor = executors[name];
                        if (executor.validate) {
                            executor.validate(e)
                        }
                        if (e.cancel) {
                            return false
                        }
                    }
                }
                return true
            },
            _executeAction: function(e) {
                var result, executors = Action.executors;
                for (var name in executors) {
                    var executor = executors[name];
                    if (executor.execute) {
                        executor.execute(e)
                    }
                    if (e.handled) {
                        result = e.result;
                        break
                    }
                }
                return result
            }
        });
        Action.executors = {};
        Action.registerExecutor = function(name, executor) {
            if (typeUtils.isPlainObject(name)) {
                each(name, Action.registerExecutor);
                return
            }
            Action.executors[name] = executor
        };
        Action.unregisterExecutor = function() {
            var args = [].slice.call(arguments);
            each(args, function() {
                delete Action.executors[this]
            })
        };
        Action.registerExecutor({
            undefined: {
                execute: function(e) {
                    if (!e.action) {
                        e.result = void 0;
                        e.handled = true
                    }
                }
            },
            func: {
                execute: function(e) {
                    if (typeUtils.isFunction(e.action)) {
                        e.result = e.action.call(e.context, e.args[0]);
                        e.handled = true
                    }
                }
            }
        });
        var createValidatorByTargetElement = function(condition) {
            return function(e) {
                if (!e.args.length) {
                    return
                }
                var args = e.args[0],
                    element = args[e.validatingTargetName] || args.element;
                if (element && condition($(element))) {
                    e.cancel = true
                }
            }
        };
        Action.registerExecutor({
            disabled: {
                validate: createValidatorByTargetElement(function($target) {
                    return $target.is(".dx-state-disabled, .dx-state-disabled *")
                })
            },
            readOnly: {
                validate: createValidatorByTargetElement(function($target) {
                    return $target.is(".dx-state-readonly, .dx-state-readonly *")
                })
            }
        });
        module.exports = Action
    },
    /*!************************************************!*\
      !*** ./artifacts/transpiled/core/component.js ***!
      \************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _createClass = function() {
            function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                    var descriptor = props[i];
                    descriptor.enumerable = descriptor.enumerable || false;
                    descriptor.configurable = true;
                    if ("value" in descriptor) {
                        descriptor.writable = true
                    }
                    Object.defineProperty(target, descriptor.key, descriptor)
                }
            }
            return function(Constructor, protoProps, staticProps) {
                if (protoProps) {
                    defineProperties(Constructor.prototype, protoProps)
                }
                if (staticProps) {
                    defineProperties(Constructor, staticProps)
                }
                return Constructor
            }
        }();

        function _toConsumableArray(arr) {
            if (Array.isArray(arr)) {
                for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
                    arr2[i] = arr[i]
                }
                return arr2
            } else {
                return Array.from(arr)
            }
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }
        var Config = __webpack_require__( /*! ./config */ 29),
            extend = __webpack_require__( /*! ./utils/extend */ 0).extend,
            optionManager = __webpack_require__( /*! ./option_manager */ 457).OptionManager,
            Class = __webpack_require__( /*! ./class */ 15),
            Action = __webpack_require__( /*! ./action */ 111),
            errors = __webpack_require__( /*! ./errors */ 21),
            commonUtils = __webpack_require__( /*! ./utils/common */ 4),
            typeUtils = __webpack_require__( /*! ./utils/type */ 1),
            objectUtils = __webpack_require__( /*! ./utils/object */ 47),
            deferredUtils = __webpack_require__( /*! ../core/utils/deferred */ 6),
            Deferred = deferredUtils.Deferred,
            when = deferredUtils.when,
            Callbacks = __webpack_require__( /*! ./utils/callbacks */ 26),
            EventsMixin = __webpack_require__( /*! ./events_mixin */ 85),
            publicComponentUtils = __webpack_require__( /*! ./utils/public_component */ 135),
            devices = __webpack_require__( /*! ./devices */ 16),
            isFunction = typeUtils.isFunction,
            noop = commonUtils.noop;
        var PostponedOperations = function() {
            function PostponedOperations() {
                _classCallCheck(this, PostponedOperations);
                this._postponedOperations = {}
            }
            _createClass(PostponedOperations, [{
                key: "add",
                value: function(key, fn, postponedPromise) {
                    if (key in this._postponedOperations) {
                        postponedPromise && this._postponedOperations[key].promises.push(postponedPromise)
                    } else {
                        var completePromise = new Deferred;
                        this._postponedOperations[key] = {
                            fn: fn,
                            completePromise: completePromise,
                            promises: postponedPromise ? [postponedPromise] : []
                        }
                    }
                    return this._postponedOperations[key].completePromise.promise()
                }
            }, {
                key: "callPostponedOperations",
                value: function() {
                    for (var key in this._postponedOperations) {
                        var operation = this._postponedOperations[key];
                        if (typeUtils.isDefined(operation)) {
                            if (operation.promises && operation.promises.length) {
                                when.apply(void 0, _toConsumableArray(operation.promises)).done(operation.fn).then(operation.completePromise.resolve)
                            } else {
                                operation.fn().done(operation.completePromise.resolve)
                            }
                        }
                    }
                    this._postponedOperations = {}
                }
            }]);
            return PostponedOperations
        }();
        var normalizeOptions = function(options, value) {
            if ("string" !== typeof options) {
                return options
            }
            var result = {};
            result[options] = value;
            return result
        };
        var Component = Class.inherit({
            _setDeprecatedOptions: function() {
                this._deprecatedOptions = {}
            },
            _getDeprecatedOptions: function() {
                return this._deprecatedOptions
            },
            _getOptionAliasesByName: function(optionName) {
                var _this = this;
                return Object.keys(this._deprecatedOptions).filter(function(aliasName) {
                    return optionName === _this._deprecatedOptions[aliasName].alias
                })
            },
            _getDefaultOptions: function() {
                return {
                    onInitialized: null,
                    onOptionChanged: null,
                    onDisposing: null,
                    defaultOptionsRules: null
                }
            },
            _defaultOptionsRules: function() {
                return []
            },
            _getOptionByRules: function(customRules) {
                var rules = this._defaultOptionsRules();
                if (Array.isArray(customRules)) {
                    rules = rules.concat(customRules)
                }
                return this._convertRulesToOptions(rules)
            },
            _setOptionsByDevice: function(customRules) {
                var rulesOptions = this._getOptionByRules(customRules);
                this._setOptionByStealth(rulesOptions)
            },
            _convertRulesToOptions: function(rules) {
                var options = {};
                var currentDevice = devices.current();
                var deviceMatch = function(device, filter) {
                    var filterArray = [];
                    Array.prototype.push.call(filterArray, filter);
                    return 1 === filterArray.length && typeUtils.isEmptyObject(filterArray[0]) || commonUtils.findBestMatches(device, filterArray).length > 0
                };
                for (var i = 0; i < rules.length; i++) {
                    var match, rule = rules[i],
                        deviceFilter = rule.device || {};
                    if (isFunction(deviceFilter)) {
                        match = deviceFilter(currentDevice)
                    } else {
                        match = deviceMatch(currentDevice, deviceFilter)
                    }
                    if (match) {
                        extend(options, rule.options)
                    }
                }
                return options
            },
            _isInitialOptionValue: function(name) {
                var optionValue = this.option(name),
                    initialOptionValue = this.initialOption(name),
                    isInitialOption = isFunction(optionValue) && isFunction(initialOptionValue) ? optionValue.toString() === initialOptionValue.toString() : commonUtils.equalByValue(optionValue, initialOptionValue);
                return isInitialOption
            },
            _setOptionsByReference: function() {
                this._optionsByReference = {}
            },
            _getOptionsByReference: function() {
                return this._optionsByReference
            },
            ctor: function(options) {
                var _this2 = this;
                this.NAME = publicComponentUtils.name(this.constructor);
                options = options || {};
                if (options.eventsStrategy) {
                    this.setEventsStrategy(options.eventsStrategy)
                }
                this._options = {};
                this._updateLockCount = 0;
                this._optionChangedCallbacks = options._optionChangedCallbacks || Callbacks();
                this._disposingCallbacks = options._disposingCallbacks || Callbacks();
                this.postponedOperations = new PostponedOperations;
                this.beginUpdate();
                try {
                    this._setOptionsByReference();
                    this._setDeprecatedOptions();
                    this._options = this._getDefaultOptions();
                    this._optionManager = new optionManager(this._options, this._getOptionsByReference(), this._deprecatedOptions);
                    this._optionManager.onChanging(function(name, previousValue, value) {
                        if (_this2._initialized) {
                            _this2._optionChanging(name, previousValue, value)
                        }
                    });
                    this._optionManager.onDeprecated(function(option, info) {
                        _this2._logDeprecatedWarning(option, info)
                    });
                    this._optionManager.onChanged(function(name, value, previousValue) {
                        _this2._notifyOptionChanged(name, value, previousValue)
                    });
                    if (options && options.onInitializing) {
                        options.onInitializing.apply(this, [options])
                    }
                    this._setOptionsByDevice(options.defaultOptionsRules);
                    this._initOptions(options)
                } finally {
                    this.endUpdate()
                }
            },
            _initOptions: function(options) {
                this.option(options)
            },
            _init: function() {
                this._createOptionChangedAction();
                this.on("disposing", function(args) {
                    this._disposingCallbacks.fireWith(this, [args])
                }.bind(this))
            },
            _logDeprecatedWarning: function(option, info) {
                var message = info.message || "Use the '" + info.alias + "' option instead";
                errors.log("W0001", this.NAME, option, info.since, message)
            },
            _createOptionChangedAction: function() {
                this._optionChangedAction = this._createActionByOption("onOptionChanged", {
                    excludeValidators: ["disabled", "readOnly"]
                })
            },
            _createDisposingAction: function() {
                this._disposingAction = this._createActionByOption("onDisposing", {
                    excludeValidators: ["disabled", "readOnly"]
                })
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "onDisposing":
                    case "onInitialized":
                        break;
                    case "onOptionChanged":
                        this._createOptionChangedAction();
                        break;
                    case "defaultOptionsRules":
                }
            },
            _dispose: function() {
                this._optionChangedCallbacks.empty();
                this._createDisposingAction();
                this._disposingAction();
                this._disposeEvents();
                this._optionManager.dispose();
                this._disposed = true
            },
            instance: function() {
                return this
            },
            beginUpdate: function() {
                this._updateLockCount++
            },
            endUpdate: function() {
                this._updateLockCount = Math.max(this._updateLockCount - 1, 0);
                if (!this._updateLockCount) {
                    this.postponedOperations.callPostponedOperations();
                    if (!this._initializing && !this._initialized) {
                        this._initializing = true;
                        try {
                            this._init()
                        } finally {
                            this._initializing = false;
                            this._updateLockCount++;
                            this._createActionByOption("onInitialized", {
                                excludeValidators: ["disabled", "readOnly"]
                            })();
                            this._updateLockCount--;
                            this._initialized = true
                        }
                    }
                }
            },
            _optionChanging: noop,
            _notifyOptionChanged: function(option, value, previousValue) {
                var that = this;
                if (this._initialized) {
                    var optionNames = [option].concat(that._getOptionAliasesByName(option));
                    for (var i = 0; i < optionNames.length; i++) {
                        var name = optionNames[i],
                            args = {
                                name: name.split(/[.[]/)[0],
                                fullName: name,
                                value: value,
                                previousValue: previousValue
                            };
                        that._optionChangedCallbacks.fireWith(that, [extend(that._defaultActionArgs(), args)]);
                        that._optionChangedAction(extend({}, args));
                        if (!that._disposed && this._cancelOptionChange !== args.name) {
                            that._optionChanged(args)
                        }
                    }
                }
            },
            initialOption: function(optionName) {
                var _this3 = this;
                if (!this._initialOptions) {
                    this._initialOptions = this._getDefaultOptions();
                    var rulesOptions = this._getOptionByRules(this._getOptionByStealth("defaultOptionsRules"));
                    this._optionManager.setValueByReference(this._initialOptions, rulesOptions)
                }
                optionName = optionName.replace(/\[/g, ".").replace(/\]/g, "");
                var fullPath = optionName.split(".");
                var value = void 0;
                fullPath.forEach(function(path) {
                    value = value ? value[path] : _this3._initialOptions[path]
                });
                value = typeUtils.isObject(value) ? objectUtils.clone(value) : value;
                return value
            },
            _defaultActionConfig: function() {
                return {
                    context: this,
                    component: this
                }
            },
            _defaultActionArgs: function() {
                return {
                    component: this
                }
            },
            _createAction: function(actionSource, config) {
                var action, that = this;
                return function(e) {
                    if (!arguments.length) {
                        e = {}
                    }
                    if (!typeUtils.isPlainObject(e)) {
                        e = {
                            actionValue: e
                        }
                    }
                    action = action || new Action(actionSource, extend(config, that._defaultActionConfig()));
                    return action.execute.call(action, extend(e, that._defaultActionArgs()))
                }
            },
            _createActionByOption: function(optionName, config) {
                var action, eventName, actionFunc, that = this;
                var result = function() {
                    if (!eventName) {
                        config = config || {};
                        if ("string" !== typeof optionName) {
                            throw errors.Error("E0008")
                        }
                        if (0 === optionName.indexOf("on")) {
                            eventName = that._getEventName(optionName)
                        }
                        if (0 !== optionName.indexOf("on")) {
                            throw Error("The '" + optionName + "' option name should start with 'on' prefix")
                        }
                        actionFunc = that.option(optionName)
                    }
                    if (!action && !actionFunc && !config.beforeExecute && !config.afterExecute && !that.hasEvent(eventName)) {
                        return
                    }
                    if (!action) {
                        var beforeExecute = config.beforeExecute;
                        config.beforeExecute = function(args) {
                            beforeExecute && beforeExecute.apply(that, arguments);
                            that.fireEvent(eventName, args.args)
                        };
                        action = that._createAction(actionFunc, config)
                    }
                    if (Config().wrapActionsBeforeExecute) {
                        var beforeActionExecute = that.option("beforeActionExecute") || noop;
                        var wrappedAction = beforeActionExecute(that, action, config) || action;
                        return wrappedAction.apply(that, arguments)
                    }
                    return action.apply(that, arguments)
                };
                if (!Config().wrapActionsBeforeExecute) {
                    var onActionCreated = that.option("onActionCreated") || noop;
                    result = onActionCreated(that, result, config) || result
                }
                return result
            },
            _getOptionByStealth: function(name) {
                return this._optionManager.getValueSilently(name)
            },
            _setOptionByStealth: function(options, value) {
                this._optionManager.setValueSilently(normalizeOptions(options, value))
            },
            _getEventName: function(actionName) {
                return actionName.charAt(2).toLowerCase() + actionName.substr(3)
            },
            hasActionSubscription: function(actionName) {
                return !!this.option(actionName) || this.hasEvent(this._getEventName(actionName))
            },
            isOptionDeprecated: function(name) {
                var deprecatedOptions = this._getDeprecatedOptions();
                return Object.prototype.hasOwnProperty.call(deprecatedOptions, name)
            },
            _setOptionSilent: function(name, value) {
                this._cancelOptionChange = name;
                this.option(name, value);
                this._cancelOptionChange = false
            },
            _getOptionValue: function(name, context) {
                var value = this.option(name);
                if (isFunction(value)) {
                    return value.bind(context)()
                }
                return value
            },
            option: function(options, value) {
                if (arguments.length < 2 && "object" !== typeUtils.type(options)) {
                    return this._optionManager.getValue(options)
                }
                this.beginUpdate();
                try {
                    this._optionManager.setValue(normalizeOptions(options, value))
                } finally {
                    this.endUpdate()
                }
            },
            resetOption: function(name) {
                if (!name) {
                    return
                }
                var defaultValue = this.initialOption(name);
                this.beginUpdate();
                this._optionManager.setValue(normalizeOptions(name, defaultValue), false);
                this.endUpdate()
            }
        }).include(EventsMixin);
        module.exports = Component;
        module.exports.PostponedOperations = PostponedOperations
    },
    /*!*************************************************!*\
      !*** ./artifacts/transpiled/animation/frame.js ***!
      \*************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var windowUtils = __webpack_require__( /*! ../core/utils/window */ 7),
            window = windowUtils.hasWindow() ? windowUtils.getWindow() : {},
            callOnce = __webpack_require__( /*! ../core/utils/call_once */ 61);
        var FRAME_ANIMATION_STEP_TIME = 1e3 / 60,
            request = function(callback) {
                return setTimeout(callback, FRAME_ANIMATION_STEP_TIME)
            },
            cancel = function(requestID) {
                clearTimeout(requestID)
            };
        var setAnimationFrameMethods = callOnce(function() {
            var nativeRequest = window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame,
                nativeCancel = window.cancelAnimationFrame || window.webkitCancelAnimationFrame || window.mozCancelAnimationFrame || window.oCancelAnimationFrame || window.msCancelAnimationFrame;
            if (nativeRequest && nativeCancel) {
                request = nativeRequest;
                cancel = nativeCancel
            }
            if (nativeRequest && !nativeCancel) {
                var canceledRequests = {};
                request = function(callback) {
                    var requestId = nativeRequest.call(window, function() {
                        try {
                            if (requestId in canceledRequests) {
                                return
                            }
                            callback.apply(this, arguments)
                        } finally {
                            delete canceledRequests[requestId]
                        }
                    });
                    return requestId
                };
                cancel = function(requestId) {
                    canceledRequests[requestId] = true
                }
            }
        });
        exports.requestAnimationFrame = function() {
            setAnimationFrameMethods();
            return request.apply(window, arguments)
        };
        exports.cancelAnimationFrame = function() {
            setAnimationFrameMethods();
            cancel.apply(window, arguments)
        }
    },
    /*!************************************************!*\
      !*** ./artifacts/transpiled/ui/scroll_view.js ***!
      \************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        module.exports = __webpack_require__( /*! ./scroll_view/ui.scroll_view */ 307)
    },
    /*!***********************************************!*\
      !*** ./artifacts/transpiled/ui/number_box.js ***!
      \***********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        module.exports = __webpack_require__( /*! ./number_box/number_box */ 542)
    },
    /*!***********************************************************!*\
      !*** ./artifacts/transpiled/ui/date_box/ui.date_utils.js ***!
      \***********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            dateSerialization = __webpack_require__( /*! ../../core/utils/date_serialization */ 55),
            isDate = __webpack_require__( /*! ../../core/utils/type */ 1).isDate,
            each = __webpack_require__( /*! ../../core/utils/iterator */ 3).each,
            dateLocalization = __webpack_require__( /*! ../../localization/date */ 33);
        var dateComponents = function() {
            return ["year", "day", "month", "day"]
        };
        var ONE_MINUTE = 6e4;
        var ONE_DAY = 60 * ONE_MINUTE * 24;
        var ONE_YEAR = 365 * ONE_DAY;
        var getStringFormat = function(format) {
            var formatType = "undefined" === typeof format ? "undefined" : _typeof(format);
            if ("string" === formatType) {
                return "format"
            }
            if ("object" === formatType && void 0 !== format.type) {
                return format.type
            }
            return null
        };
        var dateUtils = {
            SUPPORTED_FORMATS: ["date", "time", "datetime"],
            DATE_COMPONENT_TEXT_FORMATTER: function(value, name) {
                var $container = $("<div>").addClass("dx-dateview-formatter-container");
                $("<span>").text(value).addClass("dx-dateview-value-formatter").appendTo($container);
                $("<span>").text(name).addClass("dx-dateview-name-formatter").appendTo($container);
                return $container
            },
            ONE_MINUTE: ONE_MINUTE,
            ONE_DAY: ONE_DAY,
            ONE_YEAR: ONE_YEAR,
            MIN_DATEVIEW_DEFAULT_DATE: new Date(1900, 0, 1),
            MAX_DATEVIEW_DEFAULT_DATE: function() {
                var newDate = new Date;
                return new Date(newDate.getFullYear() + 50, newDate.getMonth(), newDate.getDate(), 23, 59, 59)
            }(),
            FORMATS_INFO: {
                date: {
                    getStandardPattern: function() {
                        return "yyyy-MM-dd"
                    },
                    components: dateComponents()
                },
                time: {
                    getStandardPattern: function() {
                        return "HH:mm"
                    },
                    components: ["hours", "minutes", "seconds", "milliseconds"]
                },
                datetime: {
                    getStandardPattern: function() {
                        var standardPattern;
                        ! function() {
                            var androidFormatPattern = "yyyy-MM-ddTHH:mmZ",
                                testDateString = "2000-01-01T01:01Z";
                            var $input = $("<input>").attr("type", "datetime");
                            $input.val(testDateString);
                            if ($input.val()) {
                                standardPattern = androidFormatPattern
                            }
                        }();
                        if (!standardPattern) {
                            standardPattern = "yyyy-MM-ddTHH:mm:ssZ"
                        }
                        dateUtils.FORMATS_INFO.datetime.getStandardPattern = function() {
                            return standardPattern
                        };
                        return standardPattern
                    },
                    components: dateComponents().concat(["hours", "minutes", "seconds", "milliseconds"])
                },
                "datetime-local": {
                    getStandardPattern: function() {
                        return "yyyy-MM-ddTHH:mm:ss"
                    },
                    components: dateComponents().concat(["hours", "minutes", "seconds"])
                }
            },
            FORMATS_MAP: {
                date: "shortdate",
                time: "shorttime",
                datetime: "shortdateshorttime"
            },
            SUBMIT_FORMATS_MAP: {
                date: "date",
                time: "time",
                datetime: "datetime-local"
            },
            toStandardDateFormat: function(date, type) {
                var pattern = dateUtils.FORMATS_INFO[type].getStandardPattern();
                return dateSerialization.serializeDate(date, pattern)
            },
            fromStandardDateFormat: function(text) {
                var date = dateSerialization.dateParser(text);
                return isDate(date) ? date : void 0
            },
            getMaxMonthDay: function(year, month) {
                return new Date(year, month + 1, 0).getDate()
            },
            mergeDates: function(oldValue, newValue, format) {
                if (!newValue) {
                    return newValue || null
                }
                if (!oldValue || isNaN(oldValue.getTime())) {
                    var now = new Date(null);
                    oldValue = new Date(now.getFullYear(), now.getMonth(), now.getDate())
                }
                var result = new Date(oldValue.valueOf());
                var formatInfo = dateUtils.FORMATS_INFO[format];
                each(formatInfo.components, function() {
                    var componentInfo = dateUtils.DATE_COMPONENTS_INFO[this];
                    result[componentInfo.setter](newValue[componentInfo.getter]())
                });
                return result
            },
            getLongestCaptionIndex: function(captionArray) {
                var i, longestIndex = 0,
                    longestCaptionLength = 0;
                for (i = 0; i < captionArray.length; ++i) {
                    if (captionArray[i].length > longestCaptionLength) {
                        longestIndex = i;
                        longestCaptionLength = captionArray[i].length
                    }
                }
                return longestIndex
            },
            formatUsesMonthName: function(format) {
                return dateLocalization.formatUsesMonthName(format)
            },
            formatUsesDayName: function(format) {
                return dateLocalization.formatUsesDayName(format)
            },
            getLongestDate: function(format, monthNames, dayNames) {
                var stringFormat = getStringFormat(format),
                    month = 9;
                if (!stringFormat || dateUtils.formatUsesMonthName(stringFormat)) {
                    month = dateUtils.getLongestCaptionIndex(monthNames)
                }
                var longestDate = new Date(1888, month, 21, 23, 59, 59, 999);
                if (!stringFormat || dateUtils.formatUsesDayName(stringFormat)) {
                    var date = longestDate.getDate() - longestDate.getDay() + dateUtils.getLongestCaptionIndex(dayNames);
                    longestDate.setDate(date)
                }
                return longestDate
            },
            normalizeTime: function(date) {
                date.setSeconds(0);
                date.setMilliseconds(0)
            }
        };
        dateUtils.DATE_COMPONENTS_INFO = {
            year: {
                getter: "getFullYear",
                setter: "setFullYear",
                formatter: function(value, date) {
                    var formatDate = new Date(date.getTime());
                    formatDate.setFullYear(value);
                    return dateLocalization.format(formatDate, "yyyy")
                },
                startValue: void 0,
                endValue: void 0
            },
            day: {
                getter: "getDate",
                setter: "setDate",
                formatter: function(value, date) {
                    var formatDate = new Date(date.getTime());
                    formatDate.setDate(value);
                    return dateLocalization.format(formatDate, "d")
                },
                startValue: 1,
                endValue: void 0
            },
            month: {
                getter: "getMonth",
                setter: "setMonth",
                formatter: function(value) {
                    return dateLocalization.getMonthNames()[value]
                },
                startValue: 0,
                endValue: 11
            },
            hours: {
                getter: "getHours",
                setter: "setHours",
                formatter: function(value) {
                    return dateLocalization.format(new Date(0, 0, 0, value), "hour")
                },
                startValue: 0,
                endValue: 23
            },
            minutes: {
                getter: "getMinutes",
                setter: "setMinutes",
                formatter: function(value) {
                    return dateLocalization.format(new Date(0, 0, 0, 0, value), "minute")
                },
                startValue: 0,
                endValue: 59
            },
            seconds: {
                getter: "getSeconds",
                setter: "setSeconds",
                formatter: function(value) {
                    return dateLocalization.format(new Date(0, 0, 0, 0, 0, value), "second")
                },
                startValue: 0,
                endValue: 59
            },
            milliseconds: {
                getter: "getMilliseconds",
                setter: "setMilliseconds",
                formatter: function(value) {
                    return dateLocalization.format(new Date(0, 0, 0, 0, 0, 0, value), "millisecond")
                },
                startValue: 0,
                endValue: 999
            }
        };
        module.exports = dateUtils
    },
    /*!*****************************************!*\
      !*** ./artifacts/transpiled/ui/form.js ***!
      \*****************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        module.exports = __webpack_require__( /*! ./form/ui.form */ 564)
    },
    /*!***************************************************************************!*\
      !*** ./artifacts/transpiled/ui/scheduler/ui.scheduler.publisher_mixin.js ***!
      \***************************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var publisherMixin = {
            notifyObserver: function(subject, args) {
                var observer = this.option("observer");
                if (observer) {
                    observer.fire(subject, args)
                }
            },
            invoke: function() {
                var observer = this.option("observer");
                if (observer) {
                    return observer.fire.apply(observer, arguments)
                }
            }
        };
        module.exports = publisherMixin
    }, , , , , ,
    /*!*************************************************************************!*\
      !*** ./artifacts/transpiled/events/core/event_registrator_callbacks.js ***!
      \*************************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var MemorizedCallbacks = __webpack_require__( /*! ../../core/memorized_callbacks */ 181);
        module.exports = new MemorizedCallbacks
    },
    /*!*******************************************************!*\
      !*** ./artifacts/transpiled/localization/currency.js ***!
      \*******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _extend = __webpack_require__( /*! ../core/utils/extend */ 0);
        module.exports = {
            _formatNumberCore: function(value, format, formatConfig) {
                if ("currency" === format) {
                    formatConfig.precision = formatConfig.precision || 0;
                    var result = this.format(value, (0, _extend.extend)({}, formatConfig, {
                        type: "fixedpoint"
                    }));
                    var currencyPart = this.getCurrencySymbol().symbol.replace("$", "$$$$");
                    result = result.replace(/^(\D*)(\d.*)/, "$1" + currencyPart + "$2");
                    return result
                }
                return this.callBase.apply(this, arguments)
            },
            getCurrencySymbol: function() {
                return {
                    symbol: "$"
                }
            },
            getOpenXmlCurrencyFormat: function() {
                return "$#,##0{0}_);\\($#,##0{0}\\)"
            }
        }
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/events/core/emitter.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            noop = __webpack_require__( /*! ../../core/utils/common */ 4).noop,
            Class = __webpack_require__( /*! ../../core/class */ 15),
            Callbacks = __webpack_require__( /*! ../../core/utils/callbacks */ 26),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            eventUtils = __webpack_require__( /*! ../utils */ 9);
        var Emitter = Class.inherit({
            ctor: function(element) {
                this._$element = $(element);
                this._cancelCallback = Callbacks();
                this._acceptCallback = Callbacks()
            },
            getElement: function() {
                return this._$element
            },
            validate: function(e) {
                return !eventUtils.isDxMouseWheelEvent(e)
            },
            validatePointers: function(e) {
                return 1 === eventUtils.hasTouches(e)
            },
            allowInterruptionByMouseWheel: function() {
                return true
            },
            configure: function(data) {
                extend(this, data)
            },
            addCancelCallback: function(callback) {
                this._cancelCallback.add(callback)
            },
            removeCancelCallback: function() {
                this._cancelCallback.empty()
            },
            _cancel: function(e) {
                this._cancelCallback.fire(this, e)
            },
            addAcceptCallback: function(callback) {
                this._acceptCallback.add(callback)
            },
            removeAcceptCallback: function() {
                this._acceptCallback.empty()
            },
            _accept: function(e) {
                this._acceptCallback.fire(this, e)
            },
            _requestAccept: function(e) {
                this._acceptRequestEvent = e
            },
            _forgetAccept: function() {
                this._accept(this._acceptRequestEvent);
                this._acceptRequestEvent = null
            },
            start: noop,
            move: noop,
            end: noop,
            cancel: noop,
            reset: function() {
                if (this._acceptRequestEvent) {
                    this._accept(this._acceptRequestEvent)
                }
            },
            _fireEvent: function(eventName, e, params) {
                var eventData = extend({
                    type: eventName,
                    originalEvent: e,
                    target: this._getEmitterTarget(e),
                    delegateTarget: this.getElement().get(0)
                }, params);
                e = eventUtils.fireEvent(eventData);
                if (e.cancel) {
                    this._cancel(e)
                }
                return e
            },
            _getEmitterTarget: function(e) {
                return (this.delegateSelector ? $(e.target).closest(this.delegateSelector) : this.getElement()).get(0)
            },
            dispose: noop
        });
        module.exports = Emitter
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/events/core/wheel.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 13),
            callOnce = __webpack_require__( /*! ../../core/utils/call_once */ 61),
            registerEvent = __webpack_require__( /*! ./event_registrator */ 71),
            eventUtils = __webpack_require__( /*! ../utils */ 9);
        var EVENT_NAME = "dxmousewheel",
            EVENT_NAMESPACE = "dxWheel";
        var getWheelEventName = callOnce(function() {
            return domAdapter.hasDocumentProperty("onwheel") ? "wheel" : "mousewheel"
        });
        var wheel = {
            setup: function(element) {
                var $element = $(element);
                eventsEngine.on($element, eventUtils.addNamespace(getWheelEventName(), EVENT_NAMESPACE), wheel._wheelHandler.bind(wheel))
            },
            teardown: function(element) {
                eventsEngine.off(element, "." + EVENT_NAMESPACE)
            },
            _wheelHandler: function(e) {
                var delta = this._getWheelDelta(e.originalEvent);
                eventUtils.fireEvent({
                    type: EVENT_NAME,
                    originalEvent: e,
                    delta: delta,
                    pointerType: "mouse"
                });
                e.stopPropagation()
            },
            _getWheelDelta: function(event) {
                return event.wheelDelta ? event.wheelDelta : 30 * -event.deltaY
            }
        };
        registerEvent(EVENT_NAME, wheel);
        exports.name = EVENT_NAME
    },
    /*!**************************************************************!*\
      !*** ./artifacts/transpiled/events/core/emitter.feedback.js ***!
      \**************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Class = __webpack_require__( /*! ../../core/class */ 15),
            commonUtils = __webpack_require__( /*! ../../core/utils/common */ 4),
            contains = __webpack_require__( /*! ../../core/utils/dom */ 11).contains,
            devices = __webpack_require__( /*! ../../core/devices */ 16),
            eventUtils = __webpack_require__( /*! ../utils */ 9),
            pointerEvents = __webpack_require__( /*! ../pointer */ 24),
            Emitter = __webpack_require__( /*! ./emitter */ 126),
            registerEmitter = __webpack_require__( /*! ./emitter_registrator */ 95);
        var ACTIVE_EVENT_NAME = "dxactive",
            INACTIVE_EVENT_NAME = "dxinactive",
            ACTIVE_TIMEOUT = 30,
            INACTIVE_TIMEOUT = 400;
        var FeedbackEvent = Class.inherit({
            ctor: function(timeout, fire) {
                this._timeout = timeout;
                this._fire = fire
            },
            start: function() {
                var that = this;
                this._schedule(function() {
                    that.force()
                })
            },
            _schedule: function(fn) {
                this.stop();
                this._timer = setTimeout(fn, this._timeout)
            },
            stop: function() {
                clearTimeout(this._timer)
            },
            force: function() {
                if (this._fired) {
                    return
                }
                this.stop();
                this._fire();
                this._fired = true
            },
            fired: function() {
                return this._fired
            }
        });
        var activeFeedback;
        var FeedbackEmitter = Emitter.inherit({
            ctor: function() {
                this.callBase.apply(this, arguments);
                this._active = new FeedbackEvent(0, commonUtils.noop);
                this._inactive = new FeedbackEvent(0, commonUtils.noop)
            },
            configure: function(data, eventName) {
                switch (eventName) {
                    case ACTIVE_EVENT_NAME:
                        data.activeTimeout = data.timeout;
                        break;
                    case INACTIVE_EVENT_NAME:
                        data.inactiveTimeout = data.timeout
                }
                this.callBase(data)
            },
            start: function(e) {
                if (activeFeedback) {
                    var activeChildExists = contains(this.getElement().get(0), activeFeedback.getElement().get(0));
                    var childJustActivated = !activeFeedback._active.fired();
                    if (activeChildExists && childJustActivated) {
                        this._cancel();
                        return
                    }
                    activeFeedback._inactive.force()
                }
                activeFeedback = this;
                this._initEvents(e);
                this._active.start()
            },
            _initEvents: function(e) {
                var that = this,
                    eventTarget = this._getEmitterTarget(e),
                    mouseEvent = eventUtils.isMouseEvent(e),
                    isSimulator = devices.isSimulator(),
                    deferFeedback = isSimulator || !mouseEvent,
                    activeTimeout = commonUtils.ensureDefined(this.activeTimeout, ACTIVE_TIMEOUT),
                    inactiveTimeout = commonUtils.ensureDefined(this.inactiveTimeout, INACTIVE_TIMEOUT);
                this._active = new FeedbackEvent(deferFeedback ? activeTimeout : 0, function() {
                    that._fireEvent(ACTIVE_EVENT_NAME, e, {
                        target: eventTarget
                    })
                });
                this._inactive = new FeedbackEvent(deferFeedback ? inactiveTimeout : 0, function() {
                    that._fireEvent(INACTIVE_EVENT_NAME, e, {
                        target: eventTarget
                    });
                    activeFeedback = null
                })
            },
            cancel: function(e) {
                this.end(e)
            },
            end: function(e) {
                var skipTimers = e.type !== pointerEvents.up;
                if (skipTimers) {
                    this._active.stop()
                } else {
                    this._active.force()
                }
                this._inactive.start();
                if (skipTimers) {
                    this._inactive.force()
                }
            },
            dispose: function() {
                this._active.stop();
                this._inactive.stop();
                this.callBase()
            },
            lockInactive: function() {
                this._active.force();
                this._inactive.stop();
                activeFeedback = null;
                this._cancel();
                return this._inactive.force.bind(this._inactive)
            }
        });
        FeedbackEmitter.lock = function(deferred) {
            var lockInactive = activeFeedback ? activeFeedback.lockInactive() : commonUtils.noop;
            deferred.done(lockInactive)
        };
        registerEmitter({
            emitter: FeedbackEmitter,
            events: [ACTIVE_EVENT_NAME, INACTIVE_EVENT_NAME]
        });
        exports.lock = FeedbackEmitter.lock;
        exports.active = ACTIVE_EVENT_NAME;
        exports.inactive = INACTIVE_EVENT_NAME
    },
    /*!****************************************************!*\
      !*** ./artifacts/transpiled/ui/collection/item.js ***!
      \****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            Class = __webpack_require__( /*! ../../core/class */ 15),
            each = __webpack_require__( /*! ../../core/utils/iterator */ 3).each,
            publicComponentUtils = __webpack_require__( /*! ../../core/utils/public_component */ 135);
        var INVISIBLE_STATE_CLASS = "dx-state-invisible",
            DISABLED_STATE_CLASS = "dx-state-disabled",
            ITEM_CONTENT_PLACEHOLDER_CLASS = "dx-item-content-placeholder";
        var forcibleWatcher = function(watchMethod, fn, callback) {
            var filteredCallback = function() {
                var oldValue;
                return function(value) {
                    if (oldValue !== value) {
                        callback(value, oldValue);
                        oldValue = value
                    }
                }
            }();
            return {
                dispose: watchMethod(fn, filteredCallback),
                force: function() {
                    filteredCallback(fn())
                }
            }
        };
        var CollectionItem = Class.inherit({
            ctor: function($element, options, rawData) {
                this._$element = $element;
                this._options = options;
                this._rawData = rawData;
                publicComponentUtils.attachInstanceToElement($element, this, this._dispose);
                this._render()
            },
            _render: function() {
                var $placeholder = $("<div>").addClass(ITEM_CONTENT_PLACEHOLDER_CLASS);
                this._$element.append($placeholder);
                this._watchers = [];
                this._renderWatchers()
            },
            _renderWatchers: function() {
                this._startWatcher("disabled", this._renderDisabled.bind(this));
                this._startWatcher("visible", this._renderVisible.bind(this))
            },
            _startWatcher: function(field, render) {
                var rawData = this._rawData,
                    exprGetter = this._options.fieldGetter(field);
                var watcher = forcibleWatcher(this._options.watchMethod(), function() {
                    return exprGetter(rawData)
                }, function(value, oldValue) {
                    this._dirty = true;
                    render(value, oldValue)
                }.bind(this));
                this._watchers.push(watcher)
            },
            setDataField: function() {
                this._dirty = false;
                each(this._watchers, function(_, watcher) {
                    watcher.force()
                });
                if (this._dirty) {
                    return true
                }
            },
            _renderDisabled: function(value, oldValue) {
                this._$element.toggleClass(DISABLED_STATE_CLASS, !!value)
            },
            _renderVisible: function(value, oldValue) {
                this._$element.toggleClass(INVISIBLE_STATE_CLASS, void 0 !== value && !value)
            },
            _dispose: function() {
                each(this._watchers, function(_, watcher) {
                    watcher.dispose()
                })
            }
        });
        CollectionItem.getInstance = function($element) {
            return publicComponentUtils.getInstanceByElement($element, this)
        };
        module.exports = CollectionItem
    },
    /*!*************************************************************!*\
      !*** ./artifacts/transpiled/localization/globalize/core.js ***!
      \*************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _globalize = __webpack_require__( /*! globalize */ 74);
        var _globalize2 = _interopRequireDefault(_globalize);
        var _core = __webpack_require__( /*! ../core */ 80);
        var _core2 = _interopRequireDefault(_core);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }
        if (_globalize2.default && _globalize2.default.load) {
            var likelySubtags = {
                supplemental: {
                    version: {
                        _cldrVersion: "28",
                        _unicodeVersion: "8.0.0",
                        _number: "$Revision: 11965 $"
                    },
                    likelySubtags: {
                        en: "en-Latn-US",
                        de: "de-Latn-DE",
                        ru: "ru-Cyrl-RU",
                        ja: "ja-Jpan-JP"
                    }
                }
            };
            if (!_globalize2.default.locale()) {
                _globalize2.default.load(likelySubtags);
                _globalize2.default.locale("en")
            }
            _core2.default.inject({
                locale: function(_locale) {
                    if (!_locale) {
                        return _globalize2.default.locale().locale
                    }
                    _globalize2.default.locale(_locale)
                }
            })
        }
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/events/double_click.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var eventsEngine = __webpack_require__( /*! ../events/core/events_engine */ 5),
            domUtils = __webpack_require__( /*! ../core/utils/dom */ 11),
            domAdapter = __webpack_require__( /*! ../core/dom_adapter */ 13),
            Class = __webpack_require__( /*! ../core/class */ 15),
            registerEvent = __webpack_require__( /*! ./core/event_registrator */ 71),
            clickEvent = __webpack_require__( /*! ./click */ 19),
            eventUtils = __webpack_require__( /*! ./utils */ 9);
        var DBLCLICK_EVENT_NAME = "dxdblclick",
            DBLCLICK_NAMESPACE = "dxDblClick",
            NAMESPACED_CLICK_EVENT = eventUtils.addNamespace(clickEvent.name, DBLCLICK_NAMESPACE),
            DBLCLICK_TIMEOUT = 300;
        var DblClick = Class.inherit({
            ctor: function() {
                this._handlerCount = 0;
                this._forgetLastClick()
            },
            _forgetLastClick: function() {
                this._firstClickTarget = null;
                this._lastClickTimeStamp = -DBLCLICK_TIMEOUT
            },
            add: function() {
                if (this._handlerCount <= 0) {
                    eventsEngine.on(domAdapter.getDocument(), NAMESPACED_CLICK_EVENT, this._clickHandler.bind(this))
                }
                this._handlerCount++
            },
            _clickHandler: function(e) {
                var timeStamp = e.timeStamp || Date.now();
                if (timeStamp - this._lastClickTimeStamp < DBLCLICK_TIMEOUT) {
                    eventUtils.fireEvent({
                        type: DBLCLICK_EVENT_NAME,
                        target: domUtils.closestCommonParent(this._firstClickTarget, e.target),
                        originalEvent: e
                    });
                    this._forgetLastClick()
                } else {
                    this._firstClickTarget = e.target;
                    this._lastClickTimeStamp = timeStamp
                }
            },
            remove: function() {
                this._handlerCount--;
                if (this._handlerCount <= 0) {
                    this._forgetLastClick();
                    eventsEngine.off(domAdapter.getDocument(), NAMESPACED_CLICK_EVENT)
                }
            }
        });
        registerEvent(DBLCLICK_EVENT_NAME, new DblClick);
        exports.name = DBLCLICK_EVENT_NAME
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/core/utils/error.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var extend = __webpack_require__( /*! ./extend */ 0).extend,
            consoleUtils = __webpack_require__( /*! ./console */ 75),
            stringUtils = __webpack_require__( /*! ./string */ 45),
            version = __webpack_require__( /*! ../version */ 133);
        var ERROR_URL = "http://js.devexpress.com/error/" + version.split(".").slice(0, 2).join("_") + "/";
        module.exports = function(baseErrors, errors) {
            var exports = {
                ERROR_MESSAGES: extend(errors, baseErrors),
                Error: function() {
                    return makeError([].slice.call(arguments))
                },
                log: function(id) {
                    var method = "log";
                    if (/^E\d+$/.test(id)) {
                        method = "error"
                    } else {
                        if (/^W\d+$/.test(id)) {
                            method = "warn"
                        }
                    }
                    consoleUtils.logger[method]("log" === method ? id : combineMessage([].slice.call(arguments)))
                }
            };
            var combineMessage = function(args) {
                var id = args[0];
                args = args.slice(1);
                return formatMessage(id, formatDetails(id, args))
            };
            var formatDetails = function(id, args) {
                args = [exports.ERROR_MESSAGES[id]].concat(args);
                return stringUtils.format.apply(this, args).replace(/\.*\s*?$/, "")
            };
            var formatMessage = function(id, details) {
                return stringUtils.format.apply(this, ["{0} - {1}. See:\n{2}", id, details, getErrorUrl(id)])
            };
            var makeError = function(args) {
                var id, details, message, url;
                id = args[0];
                args = args.slice(1);
                details = formatDetails(id, args);
                url = getErrorUrl(id);
                message = formatMessage(id, details);
                return extend(new Error(message), {
                    __id: id,
                    __details: details,
                    url: url
                })
            };
            var getErrorUrl = function(id) {
                return ERROR_URL + id
            };
            return exports
        }
    },
    /*!**********************************************!*\
      !*** ./artifacts/transpiled/core/version.js ***!
      \**********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        module.exports = "19.2.3"
    },
    /*!*************************************************************!*\
      !*** ./artifacts/transpiled/core/utils/resize_callbacks.js ***!
      \*************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var windowUtils = __webpack_require__( /*! ./window */ 7),
            domAdapter = __webpack_require__( /*! ../dom_adapter */ 13),
            Callbacks = __webpack_require__( /*! ./callbacks */ 26),
            readyCallbacks = __webpack_require__( /*! ./ready_callbacks */ 48),
            callOnce = __webpack_require__( /*! ./call_once */ 61);
        var resizeCallbacks = function() {
            var prevSize, callbacks = Callbacks(),
                originalCallbacksAdd = callbacks.add,
                originalCallbacksRemove = callbacks.remove;
            if (!windowUtils.hasWindow()) {
                return callbacks
            }
            var formatSize = function() {
                var documentElement = domAdapter.getDocumentElement();
                return {
                    width: documentElement.clientWidth,
                    height: documentElement.clientHeight
                }
            };
            var handleResize = function() {
                var now = formatSize();
                if (now.width === prevSize.width && now.height === prevSize.height) {
                    return
                }
                var changedDimension;
                if (now.width === prevSize.width) {
                    changedDimension = "height"
                }
                if (now.height === prevSize.height) {
                    changedDimension = "width"
                }
                prevSize = now;
                callbacks.fire(changedDimension)
            };
            var setPrevSize = callOnce(function() {
                prevSize = formatSize()
            });
            var removeListener;
            callbacks.add = function() {
                var result = originalCallbacksAdd.apply(callbacks, arguments);
                setPrevSize();
                readyCallbacks.add(function() {
                    if (!removeListener && callbacks.has()) {
                        removeListener = domAdapter.listen(windowUtils.getWindow(), "resize", handleResize)
                    }
                });
                return result
            };
            callbacks.remove = function() {
                var result = originalCallbacksRemove.apply(callbacks, arguments);
                if (!callbacks.has() && removeListener) {
                    removeListener();
                    removeListener = void 0
                }
                return result
            };
            return callbacks
        }();
        module.exports = resizeCallbacks
    },
    /*!*************************************************************!*\
      !*** ./artifacts/transpiled/core/utils/public_component.js ***!
      \*************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var dataUtils = __webpack_require__( /*! ../../core/element_data */ 40),
            eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            WeakMap = __webpack_require__( /*! ../polyfills/weak_map */ 180),
            isDefined = __webpack_require__( /*! ./type */ 1).isDefined,
            removeEvent = __webpack_require__( /*! ../remove_event */ 136);
        var COMPONENT_NAMES_DATA_KEY = "dxComponents",
            ANONYMOUS_COMPONENT_DATA_KEY = "dxPrivateComponent";
        var componentNames = new WeakMap,
            nextAnonymousComponent = 0;
        var getName = exports.name = function(componentClass, newName) {
            if (isDefined(newName)) {
                componentNames.set(componentClass, newName);
                return
            }
            if (!componentNames.has(componentClass)) {
                var generatedName = ANONYMOUS_COMPONENT_DATA_KEY + nextAnonymousComponent++;
                componentNames.set(componentClass, generatedName);
                return generatedName
            }
            return componentNames.get(componentClass)
        };
        exports.attachInstanceToElement = function($element, componentInstance, disposeFn) {
            var data = dataUtils.data($element.get(0)),
                name = getName(componentInstance.constructor);
            data[name] = componentInstance;
            if (disposeFn) {
                eventsEngine.one($element, removeEvent, function() {
                    disposeFn.call(componentInstance)
                })
            }
            if (!data[COMPONENT_NAMES_DATA_KEY]) {
                data[COMPONENT_NAMES_DATA_KEY] = []
            }
            data[COMPONENT_NAMES_DATA_KEY].push(name)
        };
        exports.getInstanceByElement = function($element, componentClass) {
            var name = getName(componentClass);
            return dataUtils.data($element.get(0), name)
        }
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/core/remove_event.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ./renderer */ 2);
        var beforeCleanData = __webpack_require__( /*! ./element_data */ 40).beforeCleanData;
        var eventsEngine = __webpack_require__( /*! ../events/core/events_engine */ 5);
        var registerEvent = __webpack_require__( /*! ../events/core/event_registrator */ 71);
        var eventName = "dxremove";
        var eventPropName = "dxRemoveEvent";
        beforeCleanData(function(elements) {
            elements = [].slice.call(elements);
            for (var i = 0; i < elements.length; i++) {
                var $element = $(elements[i]);
                if ($element.prop(eventPropName)) {
                    $element[0][eventPropName] = null;
                    eventsEngine.triggerHandler($element, eventName)
                }
            }
        });
        registerEvent(eventName, {
            noBubble: true,
            setup: function(element) {
                $(element).prop(eventPropName, true)
            }
        });
        module.exports = eventName
    },
    /*!***********************************************************************!*\
      !*** ./artifacts/transpiled/core/templates/child_default_template.js ***!
      \***********************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        exports.ChildDefaultTemplate = void 0;
        var _template_base = __webpack_require__( /*! ./template_base */ 73);

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }

        function _possibleConstructorReturn(self, call) {
            if (!self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called")
            }
            return call && ("object" === typeof call || "function" === typeof call) ? call : self
        }

        function _inherits(subClass, superClass) {
            if ("function" !== typeof superClass && null !== superClass) {
                throw new TypeError("Super expression must either be null or a function, not " + typeof superClass)
            }
            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    enumerable: false,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) {
                Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass
            }
        }
        exports.ChildDefaultTemplate = function(_TemplateBase) {
            _inherits(ChildDefaultTemplate, _TemplateBase);

            function ChildDefaultTemplate(name) {
                _classCallCheck(this, ChildDefaultTemplate);
                var _this = _possibleConstructorReturn(this, (ChildDefaultTemplate.__proto__ || Object.getPrototypeOf(ChildDefaultTemplate)).call(this));
                _this.name = name;
                return _this
            }
            return ChildDefaultTemplate
        }(_template_base.TemplateBase)
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/data/array_utils.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var _type = __webpack_require__( /*! ../core/utils/type */ 1);
        var _config = __webpack_require__( /*! ../core/config */ 29);
        var _config2 = _interopRequireDefault(_config);
        var _guid = __webpack_require__( /*! ../core/guid */ 34);
        var _guid2 = _interopRequireDefault(_guid);
        var _extend = __webpack_require__( /*! ../core/utils/extend */ 0);
        var _errors = __webpack_require__( /*! ./errors */ 37);
        var _object = __webpack_require__( /*! ../core/utils/object */ 47);
        var _object2 = _interopRequireDefault(_object);
        var _utils = __webpack_require__( /*! ./utils */ 41);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                "default": obj
            }
        }

        function hasKey(target, keyOrKeys) {
            var key, keys = "string" === typeof keyOrKeys ? keyOrKeys.split() : keyOrKeys.slice();
            while (keys.length) {
                key = keys.shift();
                if (key in target) {
                    return true
                }
            }
            return false
        }

        function findItems(keyInfo, items, key, groupCount) {
            var childItems, result;
            if (groupCount) {
                for (var i = 0; i < items.length; i++) {
                    childItems = items[i].items || items[i].collapsedItems || [];
                    result = findItems(keyInfo, childItems || [], key, groupCount - 1);
                    if (result) {
                        return result
                    }
                }
            } else {
                if (indexByKey(keyInfo, items, key) >= 0) {
                    return items
                }
            }
        }

        function getItems(keyInfo, items, key, groupCount) {
            if (groupCount) {
                return findItems(keyInfo, items, key, groupCount) || []
            }
            return items
        }

        function generateDataByKeyMap(keyInfo, array) {
            if (keyInfo.key() && !array._dataByKeyMap) {
                var dataByKeyMap = {};
                for (var i = 0, arrayLength = array.length; i < arrayLength; i++) {
                    dataByKeyMap[JSON.stringify(keyInfo.keyOf(array[i]))] = array[i]
                }
                array._dataByKeyMap = dataByKeyMap
            }
        }

        function getCacheValue(array, key) {
            if (array._dataByKeyMap) {
                return array._dataByKeyMap[JSON.stringify(key)]
            }
        }

        function getHasKeyCacheValue(array, key) {
            if (array._dataByKeyMap) {
                return array._dataByKeyMap[JSON.stringify(key)]
            }
            return true
        }

        function setDataByKeyMapValue(array, key, data) {
            if (array._dataByKeyMap) {
                array._dataByKeyMap[JSON.stringify(key)] = data
            }
        }

        function applyBatch(keyInfo, array, batchData, groupCount, useInsertIndex) {
            batchData.forEach(function(item) {
                var items = "insert" === item.type ? array : getItems(keyInfo, array, item.key, groupCount);
                generateDataByKeyMap(keyInfo, items);
                switch (item.type) {
                    case "update":
                        update(keyInfo, items, item.key, item.data, true);
                        break;
                    case "insert":
                        insert(keyInfo, items, item.data, useInsertIndex && (0, _type.isDefined)(item.index) ? item.index : -1, true);
                        break;
                    case "remove":
                        remove(keyInfo, items, item.key, true)
                }
            })
        }

        function update(keyInfo, array, key, data, isBatch) {
            var target, extendComplexObject = true,
                keyExpr = keyInfo.key();
            if (keyExpr) {
                if (hasKey(data, keyExpr) && !(0, _utils.keysEqual)(keyExpr, key, keyInfo.keyOf(data))) {
                    return !isBatch && (0, _utils.rejectedPromise)(_errors.errors.Error("E4017"))
                }
                target = getCacheValue(array, key);
                if (!target) {
                    var index = indexByKey(keyInfo, array, key);
                    if (index < 0) {
                        return !isBatch && (0, _utils.rejectedPromise)(_errors.errors.Error("E4009"))
                    }
                    target = array[index]
                }
            } else {
                target = key
            }
            _object2.default.deepExtendArraySafe(target, data, extendComplexObject);
            if (!isBatch) {
                if ((0, _config2.default)().useLegacyStoreResult) {
                    return (0, _utils.trivialPromise)(key, data)
                } else {
                    return (0, _utils.trivialPromise)(target, key)
                }
            }
        }

        function insert(keyInfo, array, data, index, isBatch) {
            var keyValue, obj, keyExpr = keyInfo.key();
            obj = (0, _type.isPlainObject)(data) ? (0, _extend.extend)({}, data) : data;
            if (keyExpr) {
                keyValue = keyInfo.keyOf(obj);
                if (void 0 === keyValue || "object" === ("undefined" === typeof keyValue ? "undefined" : _typeof(keyValue)) && (0, _type.isEmptyObject)(keyValue)) {
                    if (Array.isArray(keyExpr)) {
                        throw _errors.errors.Error("E4007")
                    }
                    keyValue = obj[keyExpr] = String(new _guid2.default)
                } else {
                    if (void 0 !== array[indexByKey(keyInfo, array, keyValue)]) {
                        return !isBatch && (0, _utils.rejectedPromise)(_errors.errors.Error("E4008"))
                    }
                }
            } else {
                keyValue = obj
            }
            if (index >= 0) {
                array.splice(index, 0, obj)
            } else {
                array.push(obj)
            }
            setDataByKeyMapValue(array, keyValue, obj);
            if (!isBatch) {
                return (0, _utils.trivialPromise)((0, _config2.default)().useLegacyStoreResult ? data : obj, keyValue)
            }
        }

        function remove(keyInfo, array, key, isBatch) {
            var index = indexByKey(keyInfo, array, key);
            if (index > -1) {
                array.splice(index, 1)
            }
            if (!isBatch) {
                return (0, _utils.trivialPromise)(key)
            }
        }

        function indexByKey(keyInfo, array, key) {
            var keyExpr = keyInfo.key();
            if (!getHasKeyCacheValue(array, key)) {
                return -1
            }
            for (var i = 0, arrayLength = array.length; i < arrayLength; i++) {
                if ((0, _utils.keysEqual)(keyExpr, keyInfo.keyOf(array[i]), key)) {
                    return i
                }
            }
            return -1
        }
        module.exports.applyBatch = applyBatch;
        module.exports.update = update;
        module.exports.insert = insert;
        module.exports.remove = remove;
        module.exports.indexByKey = indexByKey
    },
    /*!*****************************************************************************!*\
      !*** ./artifacts/transpiled/ui/file_manager/file_provider/file_provider.js ***!
      \*****************************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _createClass = function() {
            function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                    var descriptor = props[i];
                    descriptor.enumerable = descriptor.enumerable || false;
                    descriptor.configurable = true;
                    if ("value" in descriptor) {
                        descriptor.writable = true
                    }
                    Object.defineProperty(target, descriptor.key, descriptor)
                }
            }
            return function(Constructor, protoProps, staticProps) {
                if (protoProps) {
                    defineProperties(Constructor.prototype, protoProps)
                }
                if (staticProps) {
                    defineProperties(Constructor, staticProps)
                }
                return Constructor
            }
        }();
        var _data = __webpack_require__( /*! ../../../core/utils/data */ 20);
        var _uiFile_manager = __webpack_require__( /*! ../ui.file_manager.utils */ 161);
        var _common = __webpack_require__( /*! ../../../core/utils/common */ 4);
        var _date_serialization = __webpack_require__( /*! ../../../core/utils/date_serialization */ 55);
        var _iterator = __webpack_require__( /*! ../../../core/utils/iterator */ 3);

        function _possibleConstructorReturn(self, call) {
            if (!self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called")
            }
            return call && ("object" === typeof call || "function" === typeof call) ? call : self
        }

        function _inherits(subClass, superClass) {
            if ("function" !== typeof superClass && null !== superClass) {
                throw new TypeError("Super expression must either be null or a function, not " + typeof superClass)
            }
            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    enumerable: false,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) {
                Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass
            }
        }

        function _toConsumableArray(arr) {
            if (Array.isArray(arr)) {
                for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
                    arr2[i] = arr[i]
                }
                return arr2
            } else {
                return Array.from(arr)
            }
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function")
            }
        }
        var DEFAULT_FILE_UPLOAD_CHUNK_SIZE = 2e5;
        var FileProvider = function() {
            function FileProvider(options) {
                _classCallCheck(this, FileProvider);
                options = (0, _common.ensureDefined)(options, {});
                this._keyGetter = (0, _data.compileGetter)(this._getKeyExpr(options));
                this._nameGetter = (0, _data.compileGetter)(this._getNameExpr(options));
                this._isDirGetter = (0, _data.compileGetter)(this._getIsDirExpr(options));
                this._sizeGetter = (0, _data.compileGetter)(options.sizeExpr || "size");
                this._dateModifiedGetter = (0, _data.compileGetter)(options.dateModifiedExpr || "dateModified");
                this._thumbnailGetter = (0, _data.compileGetter)(options.thumbnailExpr || "thumbnail")
            }
            _createClass(FileProvider, [{
                key: "getItems",
                value: function(pathInfo) {
                    return []
                }
            }, {
                key: "renameItem",
                value: function(item, name) {}
            }, {
                key: "createFolder",
                value: function(parentFolder, name) {}
            }, {
                key: "deleteItems",
                value: function(items) {}
            }, {
                key: "moveItems",
                value: function(items, destinationFolder) {}
            }, {
                key: "copyItems",
                value: function(items, destinationFolder) {}
            }, {
                key: "uploadFileChunk",
                value: function(fileData, chunksInfo, destinationDirectory) {}
            }, {
                key: "abortFileUpload",
                value: function(fileData, chunksInfo, destinationDirectory) {}
            }, {
                key: "downloadItems",
                value: function(items) {}
            }, {
                key: "getItemContent",
                value: function(items) {}
            }, {
                key: "getFileUploadChunkSize",
                value: function() {
                    return DEFAULT_FILE_UPLOAD_CHUNK_SIZE
                }
            }, {
                key: "_getItemsByType",
                value: function(path, folders) {
                    return this.getItems(path).filter(function(item) {
                        return item.isDirectory === folders
                    })
                }
            }, {
                key: "_convertDataObjectsToFileItems",
                value: function(entries, pathInfo) {
                    var _this = this;
                    var result = [];
                    (0, _iterator.each)(entries, function(_, entry) {
                        var fileItem = _this._createFileItem(entry, pathInfo);
                        result.push(fileItem)
                    });
                    return result
                }
            }, {
                key: "_createFileItem",
                value: function(dataObj, pathInfo) {
                    var fileItem = new FileManagerItem(pathInfo, this._nameGetter(dataObj), (!!this._isDirGetter(dataObj)));
                    fileItem.size = this._sizeGetter(dataObj);
                    if (void 0 === fileItem.size) {
                        fileItem.size = 0
                    }
                    fileItem.dateModified = (0, _date_serialization.deserializeDate)(this._dateModifiedGetter(dataObj));
                    if (void 0 === fileItem.dateModified) {
                        fileItem.dateModified = new Date
                    }
                    if (fileItem.isDirectory) {
                        fileItem.hasSubDirs = this._hasSubDirs(dataObj)
                    }
                    fileItem.key = this._keyGetter(dataObj);
                    if (!fileItem.key) {
                        fileItem.key = fileItem.relativeName
                    }
                    fileItem.thumbnail = this._thumbnailGetter(dataObj) || "";
                    fileItem.dataItem = dataObj;
                    return fileItem
                }
            }, {
                key: "_hasSubDirs",
                value: function(dataObj) {
                    return true
                }
            }, {
                key: "_getKeyExpr",
                value: function(options) {
                    return options.keyExpr || this._defaultKeyExpr
                }
            }, {
                key: "_defaultKeyExpr",
                value: function(fileItem) {
                    if (2 === arguments.length) {
                        fileItem.__KEY__ = arguments[1];
                        return
                    }
                    return Object.prototype.hasOwnProperty.call(fileItem, "__KEY__") ? fileItem.__KEY__ : null
                }
            }, {
                key: "_getNameExpr",
                value: function(options) {
                    return options.nameExpr || "name"
                }
            }, {
                key: "_getIsDirExpr",
                value: function(options) {
                    return options.isDirectoryExpr || "isDirectory"
                }
            }]);
            return FileProvider
        }();
        var FileManagerItem = function() {
            function FileManagerItem(pathInfo, name, isDirectory) {
                _classCallCheck(this, FileManagerItem);
                this.name = name;
                this.pathInfo = pathInfo && [].concat(_toConsumableArray(pathInfo)) || [];
                this.parentPath = this._getPathByPathInfo(this.pathInfo);
                this.key = this.relativeName = (0, _uiFile_manager.pathCombine)(this.parentPath, name);
                this.isDirectory = isDirectory || false;
                this.isRoot = false;
                this.size = 0;
                this.dateModified = new Date;
                this.thumbnail = "";
                this.tooltipText = ""
            }
            _createClass(FileManagerItem, [{
                key: "getFullPathInfo",
                value: function() {
                    var pathInfo = [].concat(_toConsumableArray(this.pathInfo));
                    !this.isRoot && pathInfo.push({
                        key: this.key,
                        name: this.name
                    });
                    return pathInfo
                }
            }, {
                key: "getExtension",
                value: function() {
                    return this.isDirectory ? "" : (0, _uiFile_manager.getFileExtension)(this.name)
                }
            }, {
                key: "equals",
                value: function(item) {
                    return item && this.key === item.key
                }
            }, {
                key: "createClone",
                value: function() {
                    var result = new FileManagerItem(this.pathInfo, this.name, this.isDirectory);
                    result.key = this.key;
                    result.size = this.size;
                    result.dateModified = this.dateModified;
                    result.thumbnail = this.thumbnail;
                    result.tooltipText = this.tooltipText;
                    result.hasSubDirs = this.hasSubDirs;
                    result.dataItem = this.dataItem;
                    return result
                }
            }, {
                key: "_getPathByPathInfo",
                value: function(pathInfo) {
                    return pathInfo.map(function(info) {
                        return info.name
                    }).join(_uiFile_manager.PATH_SEPARATOR)
                }
            }]);
            return FileManagerItem
        }();
        var FileManagerRootItem = function(_FileManagerItem) {
            _inherits(FileManagerRootItem, _FileManagerItem);

            function FileManagerRootItem() {
                _classCallCheck(this, FileManagerRootItem);
                var _this2 = _possibleConstructorReturn(this, (FileManagerRootItem.__proto__ || Object.getPrototypeOf(FileManagerRootItem)).call(this, null, "Files", true));
                _this2.key = "__dxfmroot_394CED1B-58CF-4925-A5F8-042BC0822B31_51558CB8-C170-4655-A9E0-C454ED8EA2C1";
                _this2.relativeName = "";
                _this2.isRoot = true;
                return _this2
            }
            return FileManagerRootItem
        }(FileManagerItem);
        module.exports.FileProvider = FileProvider;
        module.exports.FileManagerItem = FileManagerItem;
        module.exports.FileManagerRootItem = FileManagerRootItem
    },
    /*!********************************************!*\
      !*** ./artifacts/transpiled/ui/popover.js ***!
      \********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var _typeof = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? function(obj) {
            return typeof obj
        } : function(obj) {
            return obj && "function" === typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
        };
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            windowUtils = __webpack_require__( /*! ../core/utils/window */ 7),
            window = windowUtils.getWindow(),
            getPublicElement = __webpack_require__( /*! ../core/utils/dom */ 11).getPublicElement,
            domAdapter = __webpack_require__( /*! ../core/dom_adapter */ 13),
            eventsEngine = __webpack_require__( /*! ../events/core/events_engine */ 5),
            registerComponent = __webpack_require__( /*! ../core/component_registrator */ 8),
            commonUtils = __webpack_require__( /*! ../core/utils/common */ 4),
            extend = __webpack_require__( /*! ../core/utils/extend */ 0).extend,
            translator = __webpack_require__( /*! ../animation/translator */ 27),
            positionUtils = __webpack_require__( /*! ../animation/position */ 78),
            typeUtils = __webpack_require__( /*! ../core/utils/type */ 1),
            mathUtils = __webpack_require__( /*! ../core/utils/math */ 30),
            eventUtils = __webpack_require__( /*! ../events/utils */ 9),
            Popup = __webpack_require__( /*! ./popup */ 43);
        var POPOVER_CLASS = "dx-popover",
            POPOVER_WRAPPER_CLASS = "dx-popover-wrapper",
            POPOVER_ARROW_CLASS = "dx-popover-arrow",
            POPOVER_WITHOUT_TITLE_CLASS = "dx-popover-without-title",
            POSITION_FLIP_MAP = {
                left: "right",
                top: "bottom",
                right: "left",
                bottom: "top",
                center: "center"
            },
            WEIGHT_OF_SIDES = {
                left: -1,
                top: -1,
                center: 0,
                right: 1,
                bottom: 1
            },
            POSITION_ALIASES = {
                top: {
                    my: "bottom center",
                    at: "top center",
                    collision: "fit flip"
                },
                bottom: {
                    my: "top center",
                    at: "bottom center",
                    collision: "fit flip"
                },
                right: {
                    my: "left center",
                    at: "right center",
                    collision: "flip fit"
                },
                left: {
                    my: "right center",
                    at: "left center",
                    collision: "flip fit"
                }
            },
            SIDE_BORDER_WIDTH_STYLES = {
                left: "borderLeftWidth",
                top: "borderTopWidth",
                right: "borderRightWidth",
                bottom: "borderBottomWidth"
            },
            getEventName = function(that, optionName) {
                var optionValue = that.option(optionName);
                return getEventNameByOption(optionValue)
            },
            getEventNameByOption = function(optionValue) {
                return typeUtils.isObject(optionValue) ? optionValue.name : optionValue
            },
            getEventDelay = function(that, optionName) {
                var optionValue = that.option(optionName);
                return typeUtils.isObject(optionValue) && optionValue.delay
            },
            attachEvent = function(that, name) {
                var delay, action, handler, eventName, target = that.option("target"),
                    isSelector = typeUtils.isString(target),
                    event = getEventName(that, name + "Event");
                if (!event || that.option("disabled")) {
                    return
                }
                eventName = eventUtils.addNamespace(event, that.NAME);
                action = that._createAction(function() {
                    delay = getEventDelay(that, name + "Event");
                    this._clearEventTimeout("hide" === name);
                    if (delay) {
                        this._timeouts[name] = setTimeout(function() {
                            that[name]()
                        }, delay)
                    } else {
                        that[name]()
                    }
                }.bind(that), {
                    validatingTargetName: "target"
                });
                handler = function(e) {
                    action({
                        event: e,
                        target: $(e.currentTarget)
                    })
                };
                var EVENT_HANDLER_NAME = "_" + name + "EventHandler";
                if (isSelector) {
                    that[EVENT_HANDLER_NAME] = handler;
                    eventsEngine.on(domAdapter.getDocument(), eventName, target, handler)
                } else {
                    var targetElement = getPublicElement($(target));
                    that[EVENT_HANDLER_NAME] = void 0;
                    eventsEngine.on(targetElement, eventName, handler)
                }
            },
            detachEvent = function(that, target, name, event) {
                var eventName = event || getEventName(that, name + "Event");
                if (!eventName) {
                    return
                }
                eventName = eventUtils.addNamespace(eventName, that.NAME);
                var EVENT_HANDLER_NAME = "_" + name + "EventHandler";
                if (that[EVENT_HANDLER_NAME]) {
                    eventsEngine.off(domAdapter.getDocument(), eventName, target, that[EVENT_HANDLER_NAME])
                } else {
                    eventsEngine.off(getPublicElement($(target)), eventName)
                }
            };
        var Popover = Popup.inherit({
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    target: window,
                    shading: false,
                    position: "bottom",
                    closeOnOutsideClick: true,
                    animation: {
                        show: {
                            type: "fade",
                            from: 0,
                            to: 1
                        },
                        hide: {
                            type: "fade",
                            to: 0
                        }
                    },
                    showTitle: false,
                    width: "auto",
                    height: "auto",
                    dragEnabled: false,
                    resizeEnabled: false,
                    fullScreen: false,
                    closeOnTargetScroll: true,
                    arrowPosition: "",
                    arrowOffset: 0,
                    boundaryOffset: {
                        h: 10,
                        v: 10
                    }
                })
            },
            _defaultOptionsRules: function() {
                return [{
                    device: {
                        platform: "ios"
                    },
                    options: {
                        arrowPosition: {
                            boundaryOffset: {
                                h: 20,
                                v: -10
                            },
                            collision: "fit"
                        }
                    }
                }, {
                    device: function() {
                        return !windowUtils.hasWindow()
                    },
                    options: {
                        animation: null
                    }
                }]
            },
            _init: function() {
                this.callBase();
                this._renderArrow();
                this._timeouts = {};
                this.$element().addClass(POPOVER_CLASS);
                this._wrapper().addClass(POPOVER_WRAPPER_CLASS)
            },
            _render: function() {
                this.callBase.apply(this, arguments);
                this._detachEvents(this.option("target"));
                this._attachEvents()
            },
            _detachEvents: function(target) {
                detachEvent(this, target, "show");
                detachEvent(this, target, "hide")
            },
            _attachEvents: function() {
                attachEvent(this, "show");
                attachEvent(this, "hide")
            },
            _renderArrow: function() {
                this._$arrow = $("<div>").addClass(POPOVER_ARROW_CLASS).prependTo(this.overlayContent())
            },
            _documentDownHandler: function(e) {
                if (this._isOutsideClick(e)) {
                    return this.callBase(e)
                }
                return true
            },
            _isOutsideClick: function(e) {
                return !$(e.target).closest(this.option("target")).length
            },
            _animate: function(animation) {
                if (animation && animation.to && "object" === _typeof(animation.to)) {
                    extend(animation.to, {
                        position: this._getContainerPosition()
                    })
                }
                this.callBase.apply(this, arguments)
            },
            _stopAnimation: function() {
                this.callBase.apply(this, arguments)
            },
            _renderTitle: function() {
                this._wrapper().toggleClass(POPOVER_WITHOUT_TITLE_CLASS, !this.option("showTitle"));
                this.callBase()
            },
            _renderPosition: function() {
                this.callBase();
                this._renderOverlayPosition()
            },
            _renderOverlayBoundaryOffset: commonUtils.noop,
            _renderOverlayPosition: function() {
                this._resetOverlayPosition();
                this._updateContentSize();
                var contentPosition = this._getContainerPosition();
                var resultLocation = positionUtils.setup(this._$content, contentPosition);
                var positionSide = this._getSideByLocation(resultLocation);
                this._togglePositionClass("dx-position-" + positionSide);
                this._toggleFlippedClass(resultLocation.h.flip, resultLocation.v.flip);
                var isArrowVisible = this._isHorizontalSide() || this._isVerticalSide();
                if (isArrowVisible) {
                    this._renderArrowPosition(positionSide)
                }
            },
            _resetOverlayPosition: function() {
                this._setContentHeight(true);
                this._togglePositionClass("dx-position-" + this._positionSide);
                translator.move(this._$content, {
                    left: 0,
                    top: 0
                });
                this._$arrow.css({
                    top: "auto",
                    right: "auto",
                    bottom: "auto",
                    left: "auto"
                })
            },
            _updateContentSize: function() {
                if (!this._$popupContent) {
                    return
                }
                var containerLocation = positionUtils.calculate(this._$content, this._getContainerPosition());
                if (containerLocation.h.oversize > 0 && this._isHorizontalSide() && !containerLocation.h.fit) {
                    var newContainerWidth = this._$content.width() - containerLocation.h.oversize;
                    this._$content.width(newContainerWidth)
                }
                if (containerLocation.v.oversize > 0 && this._isVerticalSide() && !containerLocation.v.fit) {
                    var newOverlayContentHeight = this._$content.height() - containerLocation.v.oversize,
                        newPopupContentHeight = this._$popupContent.height() - containerLocation.v.oversize;
                    this._$content.height(newOverlayContentHeight);
                    this._$popupContent.height(newPopupContentHeight)
                }
            },
            _getContainerPosition: function() {
                var offset = commonUtils.pairToObject(this._position.offset || "");
                var hOffset = offset.h;
                var vOffset = offset.v;
                var isVerticalSide = this._isVerticalSide();
                var isHorizontalSide = this._isHorizontalSide();
                if (isVerticalSide || isHorizontalSide) {
                    var isPopoverInside = this._isPopoverInside();
                    var sign = (isPopoverInside ? -1 : 1) * WEIGHT_OF_SIDES[this._positionSide];
                    var arrowSize = isVerticalSide ? this._$arrow.height() : this._$arrow.width();
                    var arrowSizeCorrection = this._getContentBorderWidth(this._positionSide);
                    var arrowOffset = sign * (arrowSize - arrowSizeCorrection);
                    isVerticalSide ? vOffset += arrowOffset : hOffset += arrowOffset
                }
                return extend({}, this._position, {
                    offset: hOffset + " " + vOffset
                })
            },
            _getContentBorderWidth: function(side) {
                var borderWidth = this._$content.css(SIDE_BORDER_WIDTH_STYLES[side]);
                return parseInt(borderWidth) || 0
            },
            _getSideByLocation: function(location) {
                var isFlippedByVertical = location.v.flip;
                var isFlippedByHorizontal = location.h.flip;
                return this._isVerticalSide() && isFlippedByVertical || this._isHorizontalSide() && isFlippedByHorizontal || this._isPopoverInside() ? POSITION_FLIP_MAP[this._positionSide] : this._positionSide
            },
            _togglePositionClass: function(positionClass) {
                this._$wrapper.removeClass("dx-position-left dx-position-right dx-position-top dx-position-bottom").addClass(positionClass)
            },
            _toggleFlippedClass: function(isFlippedHorizontal, isFlippedVertical) {
                this._$wrapper.toggleClass("dx-popover-flipped-horizontal", isFlippedHorizontal).toggleClass("dx-popover-flipped-vertical", isFlippedVertical)
            },
            _renderArrowPosition: function(side) {
                this._$arrow.css(POSITION_FLIP_MAP[side], -(this._isVerticalSide(side) ? this._$arrow.height() : this._$arrow.width()));
                var axis = this._isVerticalSide(side) ? "left" : "top";
                var sizeProperty = this._isVerticalSide(side) ? "outerWidth" : "outerHeight";
                var $target = $(this._position.of);
                var targetOffset = positionUtils.offset($target) || {
                    top: 0,
                    left: 0
                };
                var contentOffset = positionUtils.offset(this._$content);
                var arrowSize = this._$arrow[sizeProperty]();
                var contentLocation = contentOffset[axis];
                var contentSize = this._$content[sizeProperty]();
                var targetLocation = targetOffset[axis];
                var targetSize = $target.get(0).preventDefault ? 0 : $target[sizeProperty]();
                var min = Math.max(contentLocation, targetLocation);
                var max = Math.min(contentLocation + contentSize, targetLocation + targetSize);
                var arrowLocation;
                if ("start" === this.option("arrowPosition")) {
                    arrowLocation = min - contentLocation
                } else {
                    if ("end" === this.option("arrowPosition")) {
                        arrowLocation = max - contentLocation - arrowSize
                    } else {
                        arrowLocation = (min + max) / 2 - contentLocation - arrowSize / 2
                    }
                }
                var borderWidth = this._getContentBorderWidth(side);
                var finalArrowLocation = mathUtils.fitIntoRange(arrowLocation - borderWidth + this.option("arrowOffset"), borderWidth, contentSize - arrowSize - 2 * borderWidth);
                this._$arrow.css(axis, finalArrowLocation)
            },
            _isPopoverInside: function() {
                var position = this._transformStringPosition(this.option("position"), POSITION_ALIASES);
                var my = positionUtils.setup.normalizeAlign(position.my);
                var at = positionUtils.setup.normalizeAlign(position.at);
                return my.h === at.h && my.v === at.v
            },
            _setContentHeight: function(fullUpdate) {
                if (fullUpdate) {
                    this.callBase()
                }
            },
            _renderShadingPosition: function() {
                if (this.option("shading")) {
                    this._$wrapper.css({
                        top: 0,
                        left: 0
                    })
                }
            },
            _normalizePosition: function() {
                var position = extend({}, this._transformStringPosition(this.option("position"), POSITION_ALIASES));
                if (!position.of) {
                    position.of = this.option("target")
                }
                if (!position.collision) {
                    position.collision = "flip"
                }
                if (!position.boundaryOffset) {
                    position.boundaryOffset = this.option("boundaryOffset")
                }
                this._positionSide = this._getDisplaySide(position);
                this._position = position
            },
            _getDisplaySide: function(position) {
                var my = positionUtils.setup.normalizeAlign(position.my),
                    at = positionUtils.setup.normalizeAlign(position.at);
                var weightSign = WEIGHT_OF_SIDES[my.h] === WEIGHT_OF_SIDES[at.h] && WEIGHT_OF_SIDES[my.v] === WEIGHT_OF_SIDES[at.v] ? -1 : 1,
                    horizontalWeight = Math.abs(WEIGHT_OF_SIDES[my.h] - weightSign * WEIGHT_OF_SIDES[at.h]),
                    verticalWeight = Math.abs(WEIGHT_OF_SIDES[my.v] - weightSign * WEIGHT_OF_SIDES[at.v]);
                return horizontalWeight > verticalWeight ? at.h : at.v
            },
            _isVerticalSide: function(side) {
                side = side || this._positionSide;
                return "top" === side || "bottom" === side
            },
            _isHorizontalSide: function(side) {
                side = side || this._positionSide;
                return "left" === side || "right" === side
            },
            _clearEventTimeout: function(visibility) {
                clearTimeout(this._timeouts[visibility ? "show" : "hide"])
            },
            _clean: function() {
                this._detachEvents(this.option("target"));
                this.callBase.apply(this, arguments)
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "boundaryOffset":
                    case "arrowPosition":
                    case "arrowOffset":
                        this._renderGeometry();
                        break;
                    case "fullScreen":
                        if (args.value) {
                            this.option("fullScreen", false)
                        }
                        break;
                    case "target":
                        args.previousValue && this._detachEvents(args.previousValue);
                        this.callBase(args);
                        break;
                    case "showEvent":
                    case "hideEvent":
                        var name = args.name.substring(0, 4),
                            event = getEventNameByOption(args.previousValue);
                        this.hide();
                        detachEvent(this, this.option("target"), name, event);
                        attachEvent(this, name);
                        break;
                    case "visible":
                        this._clearEventTimeout(args.value);
                        this.callBase(args);
                        break;
                    default:
                        this.callBase(args)
                }
            },
            show: function(target) {
                if (target) {
                    this.option("target", target)
                }
                return this.callBase()
            }
        });
        registerComponent("dxPopover", Popover);
        module.exports = Popover
    },
    /*!****************************************************************!*\
      !*** ./artifacts/transpiled/ui/list/ui.list.edit.decorator.js ***!
      \****************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2),
            eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            noop = __webpack_require__( /*! ../../core/utils/common */ 4).noop,
            Class = __webpack_require__( /*! ../../core/class */ 15),
            swipeEvents = __webpack_require__( /*! ../../events/swipe */ 179),
            eventUtils = __webpack_require__( /*! ../../events/utils */ 9);
        var LIST_EDIT_DECORATOR = "dxListEditDecorator",
            SWIPE_START_EVENT_NAME = eventUtils.addNamespace(swipeEvents.start, LIST_EDIT_DECORATOR),
            SWIPE_UPDATE_EVENT_NAME = eventUtils.addNamespace(swipeEvents.swipe, LIST_EDIT_DECORATOR),
            SWIPE_END_EVENT_NAME = eventUtils.addNamespace(swipeEvents.end, LIST_EDIT_DECORATOR);
        var EditDecorator = Class.inherit({
            ctor: function(list) {
                this._list = list;
                this._init()
            },
            _init: noop,
            _shouldHandleSwipe: false,
            _attachSwipeEvent: function(config) {
                var swipeConfig = {
                    itemSizeFunc: function() {
                        if (this._clearSwipeCache) {
                            this._itemWidthCache = this._list.$element().width();
                            this._clearSwipeCache = false
                        }
                        return this._itemWidthCache
                    }.bind(this)
                };
                eventsEngine.on(config.$itemElement, SWIPE_START_EVENT_NAME, swipeConfig, this._itemSwipeStartHandler.bind(this));
                eventsEngine.on(config.$itemElement, SWIPE_UPDATE_EVENT_NAME, this._itemSwipeUpdateHandler.bind(this));
                eventsEngine.on(config.$itemElement, SWIPE_END_EVENT_NAME, this._itemSwipeEndHandler.bind(this))
            },
            _itemSwipeStartHandler: function(e) {
                var $itemElement = $(e.currentTarget);
                if ($itemElement.is(".dx-state-disabled, .dx-state-disabled *")) {
                    e.cancel = true;
                    return
                }
                clearTimeout(this._list._inkRippleTimer);
                this._swipeStartHandler($itemElement, e)
            },
            _itemSwipeUpdateHandler: function(e) {
                var $itemElement = $(e.currentTarget);
                this._swipeUpdateHandler($itemElement, e)
            },
            _itemSwipeEndHandler: function(e) {
                var $itemElement = $(e.currentTarget);
                this._swipeEndHandler($itemElement, e);
                this._clearSwipeCache = true
            },
            beforeBag: noop,
            afterBag: noop,
            _commonOptions: function() {
                return {
                    activeStateEnabled: this._list.option("activeStateEnabled"),
                    hoverStateEnabled: this._list.option("hoverStateEnabled"),
                    focusStateEnabled: this._list.option("focusStateEnabled")
                }
            },
            modifyElement: function(config) {
                if (this._shouldHandleSwipe) {
                    this._attachSwipeEvent(config);
                    this._clearSwipeCache = true
                }
            },
            afterRender: noop,
            handleClick: noop,
            handleKeyboardEvents: noop,
            handleEnterPressing: noop,
            handleContextMenu: noop,
            _swipeStartHandler: noop,
            _swipeUpdateHandler: noop,
            _swipeEndHandler: noop,
            visibilityChange: noop,
            getExcludedSelectors: noop,
            dispose: noop
        });
        module.exports = EditDecorator
    },
    /*!**********************************************!*\
      !*** ./artifacts/transpiled/ui/tree_view.js ***!
      \**********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        module.exports = __webpack_require__( /*! ./tree_view/ui.tree_view.search */ 355)
    },
    /*!***************************************************************!*\
      !*** ./artifacts/transpiled/ui/scheduler/utils.recurrence.js ***!
      \***************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var errors = __webpack_require__( /*! ../../core/errors */ 21),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            each = __webpack_require__( /*! ../../core/utils/iterator */ 3).each,
            inArray = __webpack_require__( /*! ../../core/utils/array */ 14).inArray,
            dateUtils = __webpack_require__( /*! ../../core/utils/date */ 22);
        var toMs = dateUtils.dateToMilliseconds;
        var leastDaysInWeek = 4;
        var intervalMap = {
            secondly: "seconds",
            minutely: "minutes",
            hourly: "hours",
            daily: "days",
            weekly: "weeks",
            monthly: "months",
            yearly: "years"
        };
        var dateSetterMap = {
            bysecond: function(date, value) {
                date.setSeconds(value)
            },
            byminute: function(date, value) {
                date.setMinutes(value)
            },
            byhour: function(date, value) {
                date.setHours(value)
            },
            bymonth: function(date, value) {
                date.setMonth(value)
            },
            bymonthday: function(date, value) {
                if (value < 0) {
                    var initialDate = new Date(date);
                    setDateByNegativeValue(initialDate, 1, -1);
                    var daysInMonth = initialDate.getDate();
                    if (daysInMonth >= Math.abs(value)) {
                        setDateByNegativeValue(date, 1, value)
                    } else {
                        setDateByNegativeValue(date, 2, value)
                    }
                } else {
                    date.setDate(value);
                    correctDate(date, value)
                }
            },
            byday: function(date, byDay, appointmentWeekStart, frequency, firstDayOfWeek) {
                var dayOfWeek = byDay;
                if (("DAILY" === frequency || "WEEKLY" === frequency) && (firstDayOfWeek && 0 !== byDay || !firstDayOfWeek && 0 === byDay)) {
                    dayOfWeek = 7
                }
                byDay += days[appointmentWeekStart] > dayOfWeek ? 7 : 0;
                date.setDate(date.getDate() - date.getDay() + byDay)
            },
            byweekno: function(date, weekNumber, weekStart) {
                var initialDate = new Date(date),
                    firstYearDate = new Date(initialDate.setMonth(0, 1)),
                    dayShift = firstYearDate.getDay() - days[weekStart],
                    firstDayOfYear = firstYearDate.getTime() - dayShift * toMs("day"),
                    newFirstYearDate = dayShift + 1;
                if (newFirstYearDate > leastDaysInWeek) {
                    date.setTime(firstDayOfYear + 7 * weekNumber * toMs("day"))
                } else {
                    date.setTime(firstDayOfYear + 7 * (weekNumber - 1) * toMs("day"))
                }
                var timezoneDiff = (date.getTimezoneOffset() - firstYearDate.getTimezoneOffset()) * toMs("minute");
                timezoneDiff && date.setTime(date.getTime() + timezoneDiff)
            },
            byyearday: function(date, dayOfYear) {
                date.setMonth(0, 1);
                date.setDate(dayOfYear)
            }
        };
        var setDateByNegativeValue = function(date, month, value) {
            var initialDate = new Date(date);
            date.setMonth(date.getMonth() + month);
            if (date.getMonth() - initialDate.getMonth() > month) {
                date.setDate(value + 1)
            }
            date.setDate(value + 1)
        };
        var dateGetterMap = {
            bysecond: function(date) {
                return date.getSeconds()
            },
            byminute: function(date) {
                return date.getMinutes()
            },
            byhour: function(date) {
                return date.getHours()
            },
            bymonth: function(date) {
                return date.getMonth()
            },
            bymonthday: function(date) {
                return date.getDate()
            },
            byday: function(date) {
                return date.getDay()
            },
            byweekno: function(date, weekStart) {
                var daysFromYearStart, current = new Date(date),
                    diff = leastDaysInWeek - current.getDay() + days[weekStart] - 1,
                    dayInMilliseconds = toMs("day");
                if (date.getDay() < days[weekStart]) {
                    diff -= 7
                }
                current.setHours(0, 0, 0);
                current.setDate(current.getDate() + diff);
                var yearStart = new Date(current.getFullYear(), 0, 1),
                    timezoneDiff = (yearStart.getTimezoneOffset() - current.getTimezoneOffset()) * toMs("minute");
                daysFromYearStart = 1 + (current - yearStart + timezoneDiff) / dayInMilliseconds;
                return Math.ceil(daysFromYearStart / 7)
            },
            byyearday: function(date) {
                var yearStart = new Date(date.getFullYear(), 0, 0),
                    timezoneDiff = date.getTimezoneOffset() - yearStart.getTimezoneOffset(),
                    diff = date - yearStart - timezoneDiff * toMs("minute"),
                    dayLength = toMs("day");
                return Math.floor(diff / dayLength)
            }
        };
        var ruleNames = ["freq", "interval", "byday", "byweekno", "byyearday", "bymonth", "bymonthday", "count", "until", "byhour", "byminute", "bysecond", "bysetpos", "wkst"],
            freqNames = ["DAILY", "WEEKLY", "MONTHLY", "YEARLY", "SECONDLY", "MINUTELY", "HOURLY"],
            days = {
                SU: 0,
                MO: 1,
                TU: 2,
                WE: 3,
                TH: 4,
                FR: 5,
                SA: 6
            },
            daysNames = {
                0: "SU",
                1: "MO",
                2: "TU",
                3: "WE",
                4: "TH",
                5: "FR",
                6: "SA"
            };
        var getTimeZoneOffset = function() {
            return (new Date).getTimezoneOffset()
        };
        var dateInRecurrenceRange = function(options) {
            var result = [];
            if (options.rule) {
                result = getDatesByRecurrence(options)
            }
            return !!result.length
        };
        var normalizeInterval = function(rule) {
            var interval = rule.interval,
                freq = rule.freq,
                intervalObject = {},
                intervalField = intervalMap[freq.toLowerCase()];
            if ("MONTHLY" === freq && rule.byday) {
                intervalField = intervalMap.daily
            }
            intervalObject[intervalField] = interval;
            return intervalObject
        };
        var getDatesByRecurrenceException = function(ruleValues, date) {
            var result = [];
            for (var i = 0, len = ruleValues.length; i < len; i++) {
                result[i] = getDateByAsciiString(ruleValues[i], date)
            }
            return result
        };
        var dateIsRecurrenceException = function(date, recurrenceException) {
            var result = false;
            if (!recurrenceException) {
                return result
            }
            var splitDates = recurrenceException.split(","),
                exceptDates = getDatesByRecurrenceException(splitDates, date),
                shortFormat = /\d{8}$/;
            for (var i = 0, len = exceptDates.length; i < len; i++) {
                if (splitDates[i].match(shortFormat)) {
                    var diffs = getDatePartDiffs(date, exceptDates[i]);
                    if (0 === diffs.years && 0 === diffs.months && 0 === diffs.days) {
                        result = true
                    }
                } else {
                    if (date.getTime() === exceptDates[i].getTime()) {
                        result = true
                    }
                }
            }
            return result
        };
        var doNextIteration = function(date, startIntervalDate, endIntervalDate, recurrenceRule, iterationCount) {
            var dateInInterval, matchCountIsCorrect = true;
            endIntervalDate = endIntervalDate.getTime();
            if (recurrenceRule.until) {
                if (recurrenceRule.until.getTime() < endIntervalDate) {
                    endIntervalDate = recurrenceRule.until.getTime()
                }
            }
            if (recurrenceRule.count) {
                if (iterationCount === recurrenceRule.count) {
                    matchCountIsCorrect = false
                }
            }
            dateInInterval = date.getTime() <= endIntervalDate;
            return dateInInterval && matchCountIsCorrect
        };
        var getDatesByRecurrence = function(options) {
            var dateRules, result = [],
                recurrenceRule = getRecurrenceRule(options.rule),
                iterationResult = {},
                rule = recurrenceRule.rule,
                recurrenceStartDate = options.start;
            if (!recurrenceRule.isValid || !rule.freq) {
                return result
            }
            rule.interval = normalizeInterval(rule);
            dateRules = splitDateRules(rule, options.firstDayOfWeek);
            var duration = options.end ? options.end.getTime() - options.start.getTime() : toMs("day");
            var config = {
                exception: options.exception,
                min: options.min,
                dateRules: dateRules,
                rule: rule,
                recurrenceStartDate: recurrenceStartDate,
                recurrenceEndDate: options.end,
                duration: duration
            };
            if (dateRules.length && rule.count) {
                var iteration = 0;
                getDatesByCount(dateRules, new Date(recurrenceStartDate), new Date(recurrenceStartDate), rule).forEach(function(currentDate, i) {
                    if (currentDate < options.max) {
                        iteration++;
                        iterationResult = pushToResult(iteration, iterationResult, currentDate, i, config, true)
                    }
                })
            } else {
                getDatesByRules(dateRules, new Date(recurrenceStartDate), rule).forEach(function(currentDate, i) {
                    var iteration = 0;
                    while (doNextIteration(currentDate, recurrenceStartDate, options.max, rule, iteration)) {
                        iteration++;
                        iterationResult = pushToResult(iteration, iterationResult, currentDate, i, config);
                        currentDate = incrementDate(currentDate, recurrenceStartDate, rule, i)
                    }
                })
            }
            if (rule.bysetpos) {
                each(iterationResult, function(iterationIndex, iterationDates) {
                    iterationResult[iterationIndex] = filterDatesBySetPos(iterationDates, rule.bysetpos)
                })
            }
            each(iterationResult, function(_, iterationDates) {
                result = result.concat(iterationDates)
            });
            result.sort(function(a, b) {
                return a - b
            });
            return result
        };
        var pushToResult = function(iteration, iterationResult, currentDate, i, config, verifiedField) {
            if (!iterationResult[iteration]) {
                iterationResult[iteration] = []
            }
            if (checkDate(currentDate, i, config, verifiedField)) {
                iterationResult[iteration].push(currentDate)
            }
            return iterationResult
        };
        var checkDate = function(currentDate, i, config, verifiedField) {
            if (!dateIsRecurrenceException(currentDate, config.exception)) {
                var duration = dateUtils.sameDate(currentDate, config.recurrenceEndDate) && config.recurrenceEndDate.getTime() > currentDate.getTime() ? config.recurrenceEndDate.getTime() - currentDate.getTime() : config.duration;
                if (currentDate.getTime() >= config.recurrenceStartDate.getTime() && currentDate.getTime() + duration > config.min.getTime()) {
                    return verifiedField || checkDateByRule(currentDate, [config.dateRules[i]], config.rule.wkst)
                }
            }
            return false
        };
        var filterDatesBySetPos = function(dates, bySetPos) {
            var resultArray = [];
            bySetPos.split(",").forEach(function(index) {
                index = Number(index);
                var dateIndex = index > 0 ? index - 1 : dates.length + index;
                if (dates[dateIndex]) {
                    resultArray.push(dates[dateIndex])
                }
            });
            return resultArray
        };
        var correctDate = function(originalDate, date) {
            if (originalDate.getDate() !== date) {
                originalDate.setDate(date)
            }
        };
        var incrementDate = function(date, originalStartDate, rule, iterationStep) {
            var initialDate = new Date(date),
                needCorrect = true;
            date = dateUtils.addInterval(date, rule.interval);
            if ("MONTHLY" === rule.freq && !rule.byday) {
                var expectedDate = originalStartDate.getDate();
                if (rule.bymonthday) {
                    expectedDate = Number(rule.bymonthday.split(",")[iterationStep]);
                    if (expectedDate < 0) {
                        initialDate.setMonth(initialDate.getMonth() + 1, 1);
                        dateSetterMap.bymonthday(initialDate, expectedDate);
                        date = initialDate;
                        needCorrect = false
                    }
                }
                needCorrect && correctDate(date, expectedDate)
            }
            if ("YEARLY" === rule.freq) {
                if (rule.byyearday) {
                    var dayNumber = Number(rule.byyearday.split(",")[iterationStep]);
                    dateSetterMap.byyearday(date, dayNumber)
                }
                var dateRules = splitDateRules(rule);
                for (var field in dateRules[iterationStep]) {
                    dateSetterMap[field] && dateSetterMap[field](date, dateRules[iterationStep][field], rule.wkst)
                }
            }
            return date
        };
        var getDatePartDiffs = function(date1, date2) {
            return {
                years: date1.getFullYear() - date2.getFullYear(),
                months: date1.getMonth() - date2.getMonth(),
                days: date1.getDate() - date2.getDate(),
                hours: date1.getHours() - date2.getHours(),
                minutes: date1.getMinutes() - date2.getMinutes(),
                seconds: date1.getSeconds() - date2.getSeconds()
            }
        };
        var getRecurrenceRule = function(recurrence) {
            var result = {
                rule: {},
                isValid: false
            };
            if (recurrence) {
                result.rule = parseRecurrenceRule(recurrence);
                result.isValid = validateRRule(result.rule, recurrence)
            }
            return result
        };
        var loggedWarnings = [];
        var validateRRule = function(rule, recurrence) {
            if (brokenRuleNameExists(rule) || inArray(rule.freq, freqNames) === -1 || wrongCountRule(rule) || wrongIntervalRule(rule) || wrongDayOfWeek(rule) || wrongByMonthDayRule(rule) || wrongByMonth(rule) || wrongUntilRule(rule)) {
                logBrokenRule(recurrence);
                return false
            }
            return true
        };
        var wrongUntilRule = function(rule) {
            var wrongUntil = false,
                until = rule.until;
            if (void 0 !== until && !(until instanceof Date)) {
                wrongUntil = true
            }
            return wrongUntil
        };
        var wrongCountRule = function(rule) {
            var wrongCount = false,
                count = rule.count;
            if (count && "string" === typeof count) {
                wrongCount = true
            }
            return wrongCount
        };
        var wrongByMonthDayRule = function(rule) {
            var wrongByMonthDay = false,
                byMonthDay = rule.bymonthday;
            if (byMonthDay && isNaN(parseInt(byMonthDay))) {
                wrongByMonthDay = true
            }
            return wrongByMonthDay
        };
        var wrongByMonth = function wrongByMonth(rule) {
            var wrongByMonth = false,
                byMonth = rule.bymonth;
            if (byMonth && isNaN(parseInt(byMonth))) {
                wrongByMonth = true
            }
            return wrongByMonth
        };
        var wrongIntervalRule = function(rule) {
            var wrongInterval = false,
                interval = rule.interval;
            if (interval && "string" === typeof interval) {
                wrongInterval = true
            }
            return wrongInterval
        };
        var wrongDayOfWeek = function(rule) {
            var daysByRule = daysFromByDayRule(rule),
                brokenDaysExist = false;
            each(daysByRule, function(_, day) {
                if (!Object.prototype.hasOwnProperty.call(days, day)) {
                    brokenDaysExist = true;
                    return false
                }
            });
            return brokenDaysExist
        };
        var brokenRuleNameExists = function(rule) {
            var brokenRuleExists = false;
            each(rule, function(ruleName) {
                if (inArray(ruleName, ruleNames) === -1) {
                    brokenRuleExists = true;
                    return false
                }
            });
            return brokenRuleExists
        };
        var logBrokenRule = function(recurrence) {
            if (inArray(recurrence, loggedWarnings) === -1) {
                errors.log("W0006", recurrence);
                loggedWarnings.push(recurrence)
            }
        };
        var parseRecurrenceRule = function(recurrence) {
            var ruleObject = {},
                ruleParts = recurrence.split(";");
            for (var i = 0, len = ruleParts.length; i < len; i++) {
                var rule = ruleParts[i].split("="),
                    ruleName = rule[0].toLowerCase(),
                    ruleValue = rule[1];
                ruleObject[ruleName] = ruleValue
            }
            var count = parseInt(ruleObject.count);
            if (!isNaN(count)) {
                ruleObject.count = count
            }
            if (ruleObject.interval) {
                var interval = parseInt(ruleObject.interval);
                if (!isNaN(interval)) {
                    ruleObject.interval = interval
                }
            } else {
                ruleObject.interval = 1
            }
            if (ruleObject.freq && ruleObject.until) {
                ruleObject.until = getDateByAsciiString(ruleObject.until)
            }
            return ruleObject
        };
        var getDateByAsciiString = function(string, initialDate) {
            if ("string" !== typeof string) {
                return string
            }
            var arrayDate = string.match(/(\d{4})(\d{2})(\d{2})(T(\d{2})(\d{2})(\d{2}))?(Z)?/);
            if (!arrayDate) {
                return null
            }
            var isUTC = void 0 !== arrayDate[8],
                currentOffset = initialDate ? initialDate.getTimezoneOffset() : resultUtils.getTimeZoneOffset(),
                date = new(Function.prototype.bind.apply(Date, prepareDateArrayToParse(arrayDate)));
            currentOffset = 6e4 * currentOffset;
            if (isUTC) {
                date = new Date(date.getTime() - currentOffset)
            }
            return date
        };
        var prepareDateArrayToParse = function(arrayDate) {
            arrayDate.shift();
            if (void 0 === arrayDate[3]) {
                arrayDate.splice(3)
            } else {
                arrayDate.splice(3, 1);
                arrayDate.splice(6)
            }
            arrayDate[1]--;
            arrayDate.unshift(null);
            return arrayDate
        };
        var daysFromByDayRule = function(rule) {
            var result = [];
            if (rule.byday) {
                if (Array.isArray(rule.byday)) {
                    result = rule.byday
                } else {
                    result = rule.byday.split(",")
                }
            }
            return result
        };
        var getAsciiStringByDate = function(date) {
            var currentOffset = 6e4 * resultUtils.getTimeZoneOffset();
            date = new Date(date.getTime() + currentOffset);
            return date.getFullYear() + ("0" + (date.getMonth() + 1)).slice(-2) + ("0" + date.getDate()).slice(-2) + "T" + ("0" + date.getHours()).slice(-2) + ("0" + date.getMinutes()).slice(-2) + ("0" + date.getSeconds()).slice(-2) + "Z"
        };
        var splitDateRules = function(rule) {
            var firstDayOfWeek = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : null;
            var result = [];
            if (firstDayOfWeek) {
                rule.fdow = firstDayOfWeek
            }
            if (!rule.wkst) {
                if (firstDayOfWeek) {
                    rule.wkst = daysNames[firstDayOfWeek]
                } else {
                    rule.wkst = "MO"
                }
            }
            if (rule.byweekno && !rule.byday) {
                var dayNames = Object.keys(days);
                for (var i = 0; i < days[rule.wkst]; i++) {
                    dayNames.push(dayNames.shift())
                }
                rule.byday = dayNames.join(",")
            }
            for (var field in dateSetterMap) {
                if (!rule[field]) {
                    continue
                }
                var ruleFieldValues = rule[field].split(","),
                    ruleArray = getDateRuleArray(field, ruleFieldValues);
                result = result.length ? extendObjectArray(ruleArray, result) : ruleArray
            }
            return result
        };
        var getDateRuleArray = function(field, values) {
            var result = [];
            for (var i = 0, length = values.length; i < length; i++) {
                var dateRule = {};
                dateRule[field] = handleRuleFieldValue(field, values[i]);
                result.push(dateRule)
            }
            return result
        };
        var handleRuleFieldValue = function(field, value) {
            var result = parseInt(value);
            if ("bymonth" === field) {
                result -= 1
            }
            if ("byday" === field) {
                result = days[value]
            }
            return result
        };
        var extendObjectArray = function(firstArray, secondArray) {
            var result = [];
            for (var i = 0, firstArrayLength = firstArray.length; i < firstArrayLength; i++) {
                for (var j = 0, secondArrayLength = secondArray.length; j < secondArrayLength; j++) {
                    result.push(extend({}, firstArray[i], secondArray[j]))
                }
            }
            return result
        };
        var getDatesByRules = function(dateRules, startDate, rule) {
            var result = [];
            for (var i = 0, len = dateRules.length; i < len; i++) {
                var current = dateRules[i],
                    updatedDate = new Date(startDate);
                for (var field in current) {
                    dateSetterMap[field] && dateSetterMap[field](updatedDate, current[field], rule.wkst, rule.freq, rule.fdow)
                }
                if (Array.isArray(updatedDate)) {
                    result = result.concat(updatedDate)
                } else {
                    result.push(new Date(updatedDate))
                }
            }
            if (!result.length) {
                result.push(startDate)
            }
            return result
        };
        var getDatesByCount = function(dateRules, startDate, recurrenceStartDate, rule) {
            var result = [],
                count = rule.count,
                counter = 0,
                date = prepareDate(startDate, dateRules);
            while (counter < count) {
                var dates = getDatesByRules(dateRules, date, rule);
                var checkedDates = [];
                for (var i = 0; i < dates.length; i++) {
                    if (dates[i].getTime() >= recurrenceStartDate.getTime()) {
                        checkedDates.push(dates[i])
                    }
                }
                var length = checkedDates.length;
                counter += length;
                var delCount = counter - count;
                if (counter > count) {
                    checkedDates.splice(length - delCount, delCount)
                }
                for (i = 0; i < checkedDates.length; i++) {
                    result.push(checkedDates[i])
                }
                var interval = rule.interval;
                if ("days" === Object.keys(interval)[0]) {
                    interval = {
                        weeks: 1
                    }
                }
                date = dateUtils.addInterval(date, interval)
            }
            return result
        };
        var prepareDate = function(startDate, dateRules) {
            var date = new Date(startDate);
            if (dateRules.length && dateRules[0].byday) {
                date.setDate(date.getDate() - date.getDay() + dateRules[0].byday)
            } else {
                date.setDate(1)
            }
            return date
        };
        var checkDateByRule = function(date, rules, weekStart) {
            var result = false;
            for (var i = 0; i < rules.length; i++) {
                var current = rules[i],
                    currentRuleResult = true;
                for (var field in current) {
                    var processNegative = "bymonthday" === field && current[field] < 0;
                    if (dateGetterMap[field] && !processNegative && current[field] !== dateGetterMap[field](date, weekStart)) {
                        currentRuleResult = false
                    }
                }
                result = result || currentRuleResult
            }
            return result || !rules.length
        };
        var getRecurrenceString = function(object) {
            if (!object || !object.freq) {
                return
            }
            var result = "";
            for (var field in object) {
                var value = object[field];
                if ("interval" === field && value < 2) {
                    continue
                }
                if ("until" === field) {
                    value = getAsciiStringByDate(value)
                }
                result += field + "=" + value + ";"
            }
            result = result.substring(0, result.length - 1);
            return result.toUpperCase()
        };
        var resultUtils = {
            getRecurrenceString: getRecurrenceString,
            getRecurrenceRule: getRecurrenceRule,
            getAsciiStringByDate: getAsciiStringByDate,
            getDatesByRecurrence: getDatesByRecurrence,
            dateInRecurrenceRange: dateInRecurrenceRange,
            getDateByAsciiString: getDateByAsciiString,
            daysFromByDayRule: daysFromByDayRule,
            getTimeZoneOffset: getTimeZoneOffset
        };
        module.exports = resultUtils
    }, , , , , ,
    /*!******************************************************!*\
      !*** ./artifacts/transpiled/bundles/modules/core.js ***!
      \******************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var windowUtils = __webpack_require__( /*! ../../core/utils/window */ 7);
        var window = windowUtils.getWindow();
        var DevExpress = window.DevExpress = window.DevExpress || {};
        var errors = DevExpress.errors = __webpack_require__( /*! ../../core/errors */ 21);
        if (DevExpress._DEVEXTREME_BUNDLE_INITIALIZED) {
            throw errors.Error("E0024")
        }
        DevExpress._DEVEXTREME_BUNDLE_INITIALIZED = true;
        DevExpress.clientExporter = __webpack_require__( /*! ../../exporter */ 175);
        DevExpress.excelExporter = __webpack_require__( /*! ../../exporter/exceljs/excelExporter */ 455);
        DevExpress.VERSION = __webpack_require__( /*! ../../core/version */ 133);
        DevExpress.Class = __webpack_require__( /*! ../../core/class */ 15);
        DevExpress.DOMComponent = __webpack_require__( /*! ../../core/dom_component */ 84);
        DevExpress.Component = __webpack_require__( /*! ../../core/component */ 112);
        DevExpress.registerComponent = __webpack_require__( /*! ../../core/component_registrator */ 8);
        DevExpress.devices = __webpack_require__( /*! ../../core/devices */ 16);
        DevExpress.Color = __webpack_require__( /*! ../../color */ 94);
        var animationFrame = __webpack_require__( /*! ../../animation/frame */ 113);
        DevExpress.EventsMixin = __webpack_require__( /*! ../../core/events_mixin */ 85);
        DevExpress.utils = {};
        DevExpress.utils.requestAnimationFrame = animationFrame.requestAnimationFrame;
        DevExpress.utils.cancelAnimationFrame = animationFrame.cancelAnimationFrame;
        DevExpress.utils.initMobileViewport = __webpack_require__( /*! ../../mobile/init_mobile_viewport/init_mobile_viewport */ 459).initMobileViewport;
        DevExpress.utils.extendFromObject = __webpack_require__( /*! ../../core/utils/extend */ 0).extendFromObject;
        DevExpress.utils.createComponents = __webpack_require__( /*! ../../core/utils/dom */ 11).createComponents;
        DevExpress.utils.triggerShownEvent = __webpack_require__( /*! ../../core/utils/dom */ 11).triggerShownEvent;
        DevExpress.utils.triggerHidingEvent = __webpack_require__( /*! ../../core/utils/dom */ 11).triggerHidingEvent;
        DevExpress.utils.resetActiveElement = __webpack_require__( /*! ../../core/utils/dom */ 11).resetActiveElement;
        DevExpress.utils.findBestMatches = __webpack_require__( /*! ../../core/utils/common */ 4).findBestMatches;
        DevExpress.createQueue = __webpack_require__( /*! ../../core/utils/queue */ 271).create;
        DevExpress.utils.dom = __webpack_require__( /*! ../../core/utils/dom */ 11);
        DevExpress.utils.common = __webpack_require__( /*! ../../core/utils/common */ 4);
        DevExpress.utils.date = __webpack_require__( /*! ../../core/utils/date */ 22);
        DevExpress.utils.browser = __webpack_require__( /*! ../../core/utils/browser */ 25);
        DevExpress.utils.inflector = __webpack_require__( /*! ../../core/utils/inflector */ 32);
        DevExpress.utils.iterator = __webpack_require__( /*! ../../core/utils/iterator */ 3);
        DevExpress.utils.readyCallbacks = __webpack_require__( /*! ../../core/utils/ready_callbacks */ 48);
        DevExpress.utils.resizeCallbacks = __webpack_require__( /*! ../../core/utils/resize_callbacks */ 134);
        DevExpress.utils.console = __webpack_require__( /*! ../../core/utils/console */ 75);
        DevExpress.utils.string = __webpack_require__( /*! ../../core/utils/string */ 45);
        DevExpress.utils.support = __webpack_require__( /*! ../../core/utils/support */ 44);
        DevExpress.utils.ajax = __webpack_require__( /*! ../../core/utils/ajax */ 62);
        DevExpress.viewPort = __webpack_require__( /*! ../../core/utils/view_port */ 72).value;
        DevExpress.hideTopOverlay = __webpack_require__( /*! ../../mobile/hide_top_overlay */ 213);
        DevExpress.formatHelper = __webpack_require__( /*! ../../format_helper */ 63);
        DevExpress.config = __webpack_require__( /*! ../../core/config */ 29);
        DevExpress.animationPresets = __webpack_require__( /*! ../../animation/presets/presets */ 182).presets;
        DevExpress.fx = __webpack_require__( /*! ../../animation/fx */ 39);
        DevExpress.TransitionExecutor = __webpack_require__( /*! ../../animation/transition_executor/transition_executor */ 289).TransitionExecutor;
        DevExpress.AnimationPresetCollection = __webpack_require__( /*! ../../animation/presets/presets */ 182).PresetCollection;
        DevExpress.events = __webpack_require__( /*! ../../events */ 290);
        DevExpress.events.click = __webpack_require__( /*! ../../events/click */ 19);
        DevExpress.events.utils = __webpack_require__( /*! ../../events/utils */ 9);
        DevExpress.events.GestureEmitter = __webpack_require__( /*! ../../events/gesture/emitter.gesture */ 159);
        DevExpress.localization = __webpack_require__( /*! ../../localization */ 462);
        DevExpress.templateRendered = __webpack_require__( /*! ../../core/templates/template_base */ 73).renderedCallbacks;
        DevExpress.setTemplateEngine = __webpack_require__( /*! ../../core/templates/template_engine_registry */ 160).setTemplateEngine;
        module.exports = DevExpress
    },
    /*!**********************************************!*\
      !*** ./artifacts/transpiled/events/hover.js ***!
      \**********************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var eventsEngine = __webpack_require__( /*! ../events/core/events_engine */ 5),
            dataUtils = __webpack_require__( /*! ../core/element_data */ 40),
            Class = __webpack_require__( /*! ../core/class */ 15),
            devices = __webpack_require__( /*! ../core/devices */ 16),
            registerEvent = __webpack_require__( /*! ./core/event_registrator */ 71),
            eventUtils = __webpack_require__( /*! ./utils */ 9),
            pointerEvents = __webpack_require__( /*! ./pointer */ 24);
        var HOVERSTART_NAMESPACE = "dxHoverStart",
            HOVERSTART = "dxhoverstart",
            POINTERENTER_NAMESPACED_EVENT_NAME = eventUtils.addNamespace(pointerEvents.enter, HOVERSTART_NAMESPACE),
            HOVEREND_NAMESPACE = "dxHoverEnd",
            HOVEREND = "dxhoverend",
            POINTERLEAVE_NAMESPACED_EVENT_NAME = eventUtils.addNamespace(pointerEvents.leave, HOVEREND_NAMESPACE);
        var Hover = Class.inherit({
            noBubble: true,
            ctor: function() {
                this._handlerArrayKeyPath = this._eventNamespace + "_HandlerStore"
            },
            setup: function(element) {
                dataUtils.data(element, this._handlerArrayKeyPath, {})
            },
            add: function(element, handleObj) {
                var that = this,
                    handler = function(e) {
                        that._handler(e)
                    };
                eventsEngine.on(element, this._originalEventName, handleObj.selector, handler);
                dataUtils.data(element, this._handlerArrayKeyPath)[handleObj.guid] = handler
            },
            _handler: function(e) {
                if (eventUtils.isTouchEvent(e) || devices.isSimulator()) {
                    return
                }
                eventUtils.fireEvent({
                    type: this._eventName,
                    originalEvent: e,
                    delegateTarget: e.delegateTarget
                })
            },
            remove: function(element, handleObj) {
                var handler = dataUtils.data(element, this._handlerArrayKeyPath)[handleObj.guid];
                eventsEngine.off(element, this._originalEventName, handleObj.selector, handler)
            },
            teardown: function(element) {
                dataUtils.removeData(element, this._handlerArrayKeyPath)
            }
        });
        var HoverStart = Hover.inherit({
            ctor: function() {
                this._eventNamespace = HOVERSTART_NAMESPACE;
                this._eventName = HOVERSTART;
                this._originalEventName = POINTERENTER_NAMESPACED_EVENT_NAME;
                this.callBase()
            },
            _handler: function(e) {
                var pointers = e.pointers || [];
                if (!pointers.length) {
                    this.callBase(e)
                }
            }
        });
        var HoverEnd = Hover.inherit({
            ctor: function() {
                this._eventNamespace = HOVEREND_NAMESPACE;
                this._eventName = HOVEREND;
                this._originalEventName = POINTERLEAVE_NAMESPACED_EVENT_NAME;
                this.callBase()
            }
        });
        registerEvent(HOVERSTART, new HoverStart);
        registerEvent(HOVEREND, new HoverEnd);
        exports.start = HOVERSTART;
        exports.end = HOVEREND
    },
    /*!***************************************************!*\
      !*** ./artifacts/transpiled/data/custom_store.js ***!
      \***************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../core/renderer */ 2),
            dataUtils = __webpack_require__( /*! ./utils */ 41),
            arrayUtils = __webpack_require__( /*! ./array_utils */ 138),
            isFunction = __webpack_require__( /*! ../core/utils/type */ 1).isFunction,
            config = __webpack_require__( /*! ../core/config */ 29),
            errors = __webpack_require__( /*! ./errors */ 37).errors,
            Store = __webpack_require__( /*! ./abstract_store */ 100),
            arrayQuery = __webpack_require__( /*! ./array_query */ 156),
            queryByOptions = __webpack_require__( /*! ./store_helper */ 83).queryByOptions,
            deferredUtils = __webpack_require__( /*! ../core/utils/deferred */ 6),
            Deferred = deferredUtils.Deferred,
            when = deferredUtils.when,
            fromPromise = deferredUtils.fromPromise;
        var TOTAL_COUNT = "totalCount",
            LOAD = "load",
            BY_KEY = "byKey",
            INSERT = "insert",
            UPDATE = "update",
            REMOVE = "remove";

        function isPromise(obj) {
            return obj && isFunction(obj.then)
        }

        function trivialPromise(value) {
            return (new Deferred).resolve(value).promise()
        }

        function ensureRequiredFuncOption(name, obj) {
            if (!isFunction(obj)) {
                throw errors.Error("E4011", name)
            }
        }

        function throwInvalidUserFuncResult(name) {
            throw errors.Error("E4012", name)
        }

        function createUserFuncFailureHandler(pendingDeferred) {
            function errorMessageFromXhr(promiseArguments) {
                var xhr = promiseArguments[0],
                    textStatus = promiseArguments[1];
                if (!xhr || !xhr.getResponseHeader) {
                    return null
                }
                return dataUtils.errorMessageFromXhr(xhr, textStatus)
            }
            return function(arg) {
                var error;
                if (arg instanceof Error) {
                    error = arg
                } else {
                    error = new Error(errorMessageFromXhr(arguments) || arg && String(arg) || "Unknown error")
                }
                if (error.message !== dataUtils.XHR_ERROR_UNLOAD) {
                    pendingDeferred.reject(error)
                }
            }
        }

        function invokeUserLoad(store, options) {
            var userResult, userFunc = store._loadFunc;
            ensureRequiredFuncOption(LOAD, userFunc);
            userResult = userFunc.apply(store, [options]);
            if (Array.isArray(userResult)) {
                userResult = trivialPromise(userResult)
            } else {
                if (null === userResult || void 0 === userResult) {
                    userResult = trivialPromise([])
                } else {
                    if (!isPromise(userResult)) {
                        throwInvalidUserFuncResult(LOAD)
                    }
                }
            }
            return fromPromise(userResult)
        }

        function invokeUserTotalCountFunc(store, options) {
            var userResult, userFunc = store._totalCountFunc;
            if (!isFunction(userFunc)) {
                throw errors.Error("E4021")
            }
            userResult = userFunc.apply(store, [options]);
            if (!isPromise(userResult)) {
                userResult = Number(userResult);
                if (!isFinite(userResult)) {
                    throwInvalidUserFuncResult(TOTAL_COUNT)
                }
                userResult = trivialPromise(userResult)
            }
            return fromPromise(userResult)
        }

        function invokeUserByKeyFunc(store, key, extraOptions) {
            var userResult, userFunc = store._byKeyFunc;
            ensureRequiredFuncOption(BY_KEY, userFunc);
            userResult = userFunc.apply(store, [key, extraOptions]);
            if (!isPromise(userResult)) {
                userResult = trivialPromise(userResult)
            }
            return fromPromise(userResult)
        }

        function runRawLoad(pendingDeferred, store, userFuncOptions, continuation) {
            if (store.__rawData) {
                continuation(store.__rawData)
            } else {
                var loadPromise = store.__rawDataPromise || invokeUserLoad(store, userFuncOptions);
                if (store._cacheRawData) {
                    store.__rawDataPromise = loadPromise
                }
                loadPromise.always(function() {
                    delete store.__rawDataPromise
                }).done(function(rawData) {
                    if (store._cacheRawData) {
                        store.__rawData = rawData
                    }
                    continuation(rawData)
                }).fail(createUserFuncFailureHandler(pendingDeferred))
            }
        }

        function runRawLoadWithQuery(pendingDeferred, store, options, countOnly) {
            options = options || {};
            var userFuncOptions = {};
            if ("userData" in options) {
                userFuncOptions.userData = options.userData
            }
            runRawLoad(pendingDeferred, store, userFuncOptions, function(rawData) {
                var itemsQuery, totalCountQuery, rawDataQuery = arrayQuery(rawData, {
                        errorHandler: store._errorHandler
                    }),
                    waitList = [];
                var items, totalCount;
                if (!countOnly) {
                    itemsQuery = queryByOptions(rawDataQuery, options);
                    if (itemsQuery === rawDataQuery) {
                        items = rawData.slice(0)
                    } else {
                        waitList.push(itemsQuery.enumerate().done(function(asyncResult) {
                            items = asyncResult
                        }))
                    }
                }
                if (options.requireTotalCount || countOnly) {
                    totalCountQuery = queryByOptions(rawDataQuery, options, true);
                    if (totalCountQuery === rawDataQuery) {
                        totalCount = rawData.length
                    } else {
                        waitList.push(totalCountQuery.count().done(function(asyncResult) {
                            totalCount = asyncResult
                        }))
                    }
                }
                when.apply($, waitList).done(function() {
                    if (countOnly) {
                        pendingDeferred.resolve(totalCount)
                    } else {
                        if (options.requireTotalCount) {
                            pendingDeferred.resolve(items, {
                                totalCount: totalCount
                            })
                        } else {
                            pendingDeferred.resolve(items)
                        }
                    }
                }).fail(function(x) {
                    pendingDeferred.reject(x)
                })
            })
        }

        function runRawLoadWithKey(pendingDeferred, store, key) {
            runRawLoad(pendingDeferred, store, {}, function(rawData) {
                var item, keyExpr = store.key();
                for (var i = 0, len = rawData.length; i < len; i++) {
                    item = rawData[i];
                    if (dataUtils.keysEqual(keyExpr, store.keyOf(rawData[i]), key)) {
                        pendingDeferred.resolve(item);
                        return
                    }
                }
                pendingDeferred.reject(errors.Error("E4009"))
            })
        }
        var CustomStore = Store.inherit({
            ctor: function(options) {
                options = options || {};
                this.callBase(options);
                this._useDefaultSearch = !!options.useDefaultSearch || "raw" === options.loadMode;
                this._loadMode = options.loadMode;
                this._cacheRawData = false !== options.cacheRawData;
                this._loadFunc = options[LOAD];
                this._totalCountFunc = options[TOTAL_COUNT];
                this._byKeyFunc = options[BY_KEY];
                this._insertFunc = options[INSERT];
                this._updateFunc = options[UPDATE];
                this._removeFunc = options[REMOVE]
            },
            createQuery: function() {
                throw errors.Error("E4010")
            },
            clearRawDataCache: function() {
                delete this.__rawData
            },
            _totalCountImpl: function(options) {
                var d = new Deferred;
                if ("raw" === this._loadMode && !this._totalCountFunc) {
                    runRawLoadWithQuery(d, this, options, true)
                } else {
                    invokeUserTotalCountFunc(this, options).done(function(count) {
                        d.resolve(Number(count))
                    }).fail(createUserFuncFailureHandler(d));
                    d = this._addFailHandlers(d)
                }
                return d.promise()
            },
            _pushImpl: function(changes) {
                if (this.__rawData) {
                    arrayUtils.applyBatch(this, this.__rawData, changes)
                }
            },
            _loadImpl: function(options) {
                var d = new Deferred;
                if ("raw" === this._loadMode) {
                    runRawLoadWithQuery(d, this, options, false)
                } else {
                    invokeUserLoad(this, options).done(function(data, extra) {
                        d.resolve(data, extra)
                    }).fail(createUserFuncFailureHandler(d));
                    d = this._addFailHandlers(d)
                }
                return d.promise()
            },
            _byKeyImpl: function(key, extraOptions) {
                var d = new Deferred;
                if (this._byKeyViaLoad()) {
                    this._requireKey();
                    runRawLoadWithKey(d, this, key)
                } else {
                    invokeUserByKeyFunc(this, key, extraOptions).done(function(obj) {
                        d.resolve(obj)
                    }).fail(createUserFuncFailureHandler(d))
                }
                return d.promise()
            },
            _byKeyViaLoad: function() {
                return "raw" === this._loadMode && !this._byKeyFunc
            },
            _insertImpl: function(values) {
                var userResult, that = this,
                    userFunc = that._insertFunc,
                    d = new Deferred;
                ensureRequiredFuncOption(INSERT, userFunc);
                userResult = userFunc.apply(that, [values]);
                if (!isPromise(userResult)) {
                    userResult = trivialPromise(userResult)
                }
                fromPromise(userResult).done(function(serverResponse) {
                    if (config().useLegacyStoreResult) {
                        d.resolve(values, serverResponse)
                    } else {
                        d.resolve(serverResponse || values, that.keyOf(serverResponse))
                    }
                }).fail(createUserFuncFailureHandler(d));
                return d.promise()
            },
            _updateImpl: function(key, values) {
                var userResult, userFunc = this._updateFunc,
                    d = new Deferred;
                ensureRequiredFuncOption(UPDATE, userFunc);
                userResult = userFunc.apply(this, [key, values]);
                if (!isPromise(userResult)) {
                    userResult = trivialPromise(userResult)
                }
                fromPromise(userResult).done(function(serverResponse) {
                    if (config().useLegacyStoreResult) {
                        d.resolve(key, values)
                    } else {
                        d.resolve(serverResponse || values, key)
                    }
                }).fail(createUserFuncFailureHandler(d));
                return d.promise()
            },
            _removeImpl: function(key) {
                var userResult, userFunc = this._removeFunc,
                    d = new Deferred;
                ensureRequiredFuncOption(REMOVE, userFunc);
                userResult = userFunc.apply(this, [key]);
                if (!isPromise(userResult)) {
                    userResult = trivialPromise()
                }
                fromPromise(userResult).done(function() {
                    d.resolve(key)
                }).fail(createUserFuncFailureHandler(d));
                return d.promise()
            }
        });
        module.exports = CustomStore
    },
    /*!************************************************************!*\
      !*** ./artifacts/transpiled/ui/widget/swatch_container.js ***!
      \************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var $ = __webpack_require__( /*! ../../core/renderer */ 2);
        var viewPortUtils = __webpack_require__( /*! ../../core/utils/view_port */ 72);
        var SWATCH_CONTAINER_CLASS_PREFIX = "dx-swatch-";
        var getSwatchContainer = function(element) {
            var $element = $(element);
            var swatchContainer = $element.closest('[class^="' + SWATCH_CONTAINER_CLASS_PREFIX + '"], [class*=" ' + SWATCH_CONTAINER_CLASS_PREFIX + '"]');
            var viewport = viewPortUtils.value();
            if (!swatchContainer.length) {
                return viewport
            }
            var swatchClassRegex = new RegExp("(\\s|^)(" + SWATCH_CONTAINER_CLASS_PREFIX + ".*?)(\\s|$)");
            var swatchClass = swatchContainer[0].className.match(swatchClassRegex)[2];
            var viewportSwatchContainer = viewport.children("." + swatchClass);
            if (!viewportSwatchContainer.length) {
                viewportSwatchContainer = $("<div>").addClass(swatchClass).appendTo(viewport)
            }
            return viewportSwatchContainer
        };
        module.exports = {
            getSwatchContainer: getSwatchContainer
        }
    },
    /*!**********************************************************!*\
      !*** ./artifacts/transpiled/events/gesture/swipeable.js ***!
      \**********************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var swipeEvents = __webpack_require__( /*! ../swipe */ 179),
            eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            DOMComponent = __webpack_require__( /*! ../../core/dom_component */ 84),
            each = __webpack_require__( /*! ../../core/utils/iterator */ 3).each,
            eventUtils = __webpack_require__( /*! ../utils */ 9),
            extend = __webpack_require__( /*! ../../core/utils/extend */ 0).extend,
            publicComponentUtils = __webpack_require__( /*! ../../core/utils/public_component */ 135);
        var DX_SWIPEABLE = "dxSwipeable",
            SWIPEABLE_CLASS = "dx-swipeable",
            ACTION_TO_EVENT_MAP = {
                onStart: swipeEvents.start,
                onUpdated: swipeEvents.swipe,
                onEnd: swipeEvents.end,
                onCancel: "dxswipecancel"
            };
        var Swipeable = DOMComponent.inherit({
            _getDefaultOptions: function() {
                return extend(this.callBase(), {
                    elastic: true,
                    immediate: false,
                    direction: "horizontal",
                    itemSizeFunc: null,
                    onStart: null,
                    onUpdated: null,
                    onEnd: null,
                    onCancel: null
                })
            },
            _render: function() {
                this.callBase();
                this.$element().addClass(SWIPEABLE_CLASS);
                this._attachEventHandlers()
            },
            _attachEventHandlers: function() {
                this._detachEventHandlers();
                if (this.option("disabled")) {
                    return
                }
                var NAME = this.NAME;
                this._createEventData();
                each(ACTION_TO_EVENT_MAP, function(actionName, eventName) {
                    var action = this._createActionByOption(actionName, {
                        context: this
                    });
                    eventName = eventUtils.addNamespace(eventName, NAME);
                    eventsEngine.on(this.$element(), eventName, this._eventData, function(e) {
                        return action({
                            event: e
                        })
                    })
                }.bind(this))
            },
            _createEventData: function() {
                this._eventData = {
                    elastic: this.option("elastic"),
                    itemSizeFunc: this.option("itemSizeFunc"),
                    direction: this.option("direction"),
                    immediate: this.option("immediate")
                }
            },
            _detachEventHandlers: function() {
                eventsEngine.off(this.$element(), "." + DX_SWIPEABLE)
            },
            _optionChanged: function(args) {
                switch (args.name) {
                    case "disabled":
                    case "onStart":
                    case "onUpdated":
                    case "onEnd":
                    case "onCancel":
                    case "elastic":
                    case "immediate":
                    case "itemSizeFunc":
                    case "direction":
                        this._detachEventHandlers();
                        this._attachEventHandlers();
                        break;
                    case "rtlEnabled":
                        break;
                    default:
                        this.callBase(args)
                }
            }
        });
        publicComponentUtils.name(Swipeable, DX_SWIPEABLE);
        module.exports = Swipeable
    },
    /*!**********************************************************************!*\
      !*** ./artifacts/transpiled/core/component_registrator_callbacks.js ***!
      \**********************************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var MemorizedCallbacks = __webpack_require__( /*! ./memorized_callbacks */ 181);
        module.exports = new MemorizedCallbacks
    },
    /*!*****************************************************!*\
      !*** ./artifacts/transpiled/events/pointer/base.js ***!
      \*****************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var eventsEngine = __webpack_require__( /*! ../../events/core/events_engine */ 5),
            browser = __webpack_require__( /*! ../../core/utils/browser */ 25),
            domAdapter = __webpack_require__( /*! ../../core/dom_adapter */ 13),
            Class = __webpack_require__( /*! ../../core/class */ 15),
            eventUtils = __webpack_require__( /*! ../utils */ 9);
        var POINTER_EVENTS_NAMESPACE = "dxPointerEvents";
        var BaseStrategy = Class.inherit({
            ctor: function(eventName, originalEvents) {
                this._eventName = eventName;
                this._originalEvents = eventUtils.addNamespace(originalEvents, POINTER_EVENTS_NAMESPACE);
                this._handlerCount = 0;
                this.noBubble = this._isNoBubble()
            },
            _isNoBubble: function() {
                var eventName = this._eventName;
                return "dxpointerenter" === eventName || "dxpointerleave" === eventName
            },
            _handler: function(e) {
                var delegateTarget = this._getDelegateTarget(e);
                return this._fireEvent({
                    type: this._eventName,
                    pointerType: e.pointerType || eventUtils.eventSource(e),
                    originalEvent: e,
                    delegateTarget: delegateTarget,
                    timeStamp: browser.mozilla ? (new Date).getTime() : e.timeStamp
                })
            },
            _getDelegateTarget: function(e) {
                var delegateTarget;
                if (this.noBubble) {
                    delegateTarget = e.delegateTarget
                }
                return delegateTarget
            },
            _fireEvent: function(args) {
                return eventUtils.fireEvent(args)
            },
            _setSelector: function(handleObj) {
                this._selector = this.noBubble && handleObj ? handleObj.selector : null
            },
            _getSelector: function() {
                return this._selector
            },
            setup: function() {
                return true
            },
            add: function(element, handleObj) {
                if (this._handlerCount <= 0 || this.noBubble) {
                    element = this.noBubble ? element : domAdapter.getDocument();
                    this._setSelector(handleObj);
                    var that = this;
                    eventsEngine.on(element, this._originalEvents, this._getSelector(), function(e) {
                        that._handler(e)
                    })
                }
                if (!this.noBubble) {
                    this._handlerCount++
                }
            },
            remove: function(handleObj) {
                this._setSelector(handleObj);
                if (!this.noBubble) {
                    this._handlerCount--
                }
            },
            teardown: function(element) {
                if (this._handlerCount && !this.noBubble) {
                    return
                }
                element = this.noBubble ? element : domAdapter.getDocument();
                if (this._originalEvents !== "." + POINTER_EVENTS_NAMESPACE) {
                    eventsEngine.off(element, this._originalEvents, this._getSelector())
                }
            },
            dispose: function(element) {
                element = this.noBubble ? element : domAdapter.getDocument();
                eventsEngine.off(element, this._originalEvents)
            }
        });
        module.exports = BaseStrategy
    },
    /*!**************************************************!*\
      !*** ./artifacts/transpiled/data/array_query.js ***!
      \**************************************************/
    /*! dynamic exports provided */
    /*! all exports used */
    function(module, exports, __webpack_require__) {
        var Class = __webpack_require__( /*! ../core/class */ 15),
            typeUtils = __webpack_require__( /*! ../core/utils/type */ 1),
            iteratorUtils = __webpack_require__( /*! ../core/utils/iterator */ 3),
            compileGetter = __webpack_require__( /*! ../core/utils/data */ 20).compileGetter,
            toComparable = __webpack_require__( /*! ../core/utils/data */ 20).toComparable,
            Deferred = __webpack_require__( /*! ../core/utils/deferred */ 6).Deferred,
            errorsModule = __webpack_require__( /*! ./errors */ 37),
            dataUtils = __webpack_require__( /*! ./utils */ 41);
        var Iterator = Class.inherit({
            toArray: function() {
                var result = [];
                this.reset();
                while (this.next()) {
                    result.push(this.current())
                }
                return result
            },
            countable: function() {
                return false
            }
        });
        var ArrayIterator = Iterator.inherit({
            ctor: function(array) {
                this.array = array;
                this.index = -1
            },
            next: function() {
                if (this.index + 1 < this.array.length) {
                    this.index++;
                    return true
                }
                return false
            },
            current: function() {
                return this.array[this.index]
            },
            reset: function() {
                this.index = -1
            },
            toArray: function() {
                return this.array.slice(0)
            },
            countable: function() {
                return true
            },
            count: function() {
                return this.array.length
            }
        });
        var WrappedIterator = Iterator.inherit({
            ctor: function(iter) {
                this.iter = iter
            },
            next: function() {
                return this.iter.next()
            },
            current: function() {
                return this.iter.current()
            },
            reset: function() {
                return this.iter.reset()
            }
        });
        var MapIterator = WrappedIterator.inherit({
            ctor: function(iter, mapper) {
                this.callBase(iter);
                this.index = -1;
                this.mapper = mapper
            },
            current: function() {
                return this.mapper(this.callBase(), this.index)
            },
            next: function() {
                var hasNext = this.callBase();
                if (hasNext) {
                    this.index++
                }
                return hasNext
            }
        });
        var defaultCompare = function(xValue, yValue) {
            xValue = toComparable(xValue);
            yValue = toComparable(yValue);
            if (null === xValue && null !== yValue) {
                return -1
            }
            if (null !== xValue && null === yValue) {
                return 1
            }
            if (void 0 === xValue && void 0 !== yValue) {
                return 1
            }
            if (void 0 !== xValue && void 0 === yValue) {
                return -1
            }
            if (xValue < yValue) {
                return -1
            }
            if (xValue > yValue) {
                return 1
            }
            return 0
        };
        var SortIterator = Iterator.inherit({
            ctor: function(iter, getter, desc, compare) {
                if (!(iter instanceof MapIterator)) {
                    iter = new MapIterator(iter, this._wrap)
                }
                this.iter = iter;
                this.rules = [{
                    getter: getter,
                    desc: desc,
                    compare: compare
                }]
            },
            thenBy: function(getter, desc, compare) {
                var result = new SortIterator(this.sortedIter || this.iter, getter, desc, compare);
                if (!this.sortedIter) {
                    result.rules = this.rules.concat(result.rules)
                }
                return result
            },
            next: function() {
                this._ensureSorted();
                return this.sortedIter.next()
            },
            current: function() {
                this._ensureSorted();
                return this.sortedIter.current()
            },
            reset: function() {
                delete this.sortedIter
            },
            countable: function() {
                return this.sortedIter || this.iter.countable()
            },
            count: function() {
                if (this.sortedIter) {
                    return this.sortedIter.count()
                }
                return this.iter.count()
            },
            _ensureSorted: function() {
                var that = this;
                if (that.sortedIter) {
                    return
                }
                iteratorUtils.each(that.rules, function() {
                    this.getter = compileGetter(this.getter)
                });
                that.sortedIter = new MapIterator(new ArrayIterator(this.iter.toArray().sort(function(x, y) {
                    return that._compare(x, y)
                })), that._unwrap)
            },
            _wrap: function(record, index) {
                return {
                    index: index,
                    value: record
                }
            },
            _unwrap: function(wrappedItem) {
                return wrappedItem.value
            },
            _compare: function(x, y) {
                var xIndex = x.index,
                    yIndex = y.index;
                x = x.value;
                y = y.value;
                if (x === y) {
                    return xIndex - yIndex
                }
                for (var i = 0, rulesCount = this.rules.length; i < rulesCount; i++) {
                    var rule = this.rules[i],
                        xValue = rule.getter(x),
                        yValue = rule.getter(y),
                        compare = rule.compare || defaultCompare,
                        compareResult = compare(xValue, yValue);
                    if (compareResult) {
                        return rule.desc ? -compareResult : compareResult
                    }
                }
                return xIndex - yIndex
            }
        });
        var compileCriteria = function() {
            var compileGroup = function(crit) {
                var ops = [];
                var isConjunctiveOperator = false;
                var isConjunctiveNextOperator = false;
                iteratorUtils.each(crit, function() {
                    if (Array.isArray(this) || typeUtils.isFunction(this)) {
                        if (ops.length > 1 && isConjunctiveOperator !== isConjunctiveNextOperator) {
                            throw new errorsModule.errors.Error("E4019")
                        }
                        ops.push(compileCriteria(this));
                        isConjunctiveOperator = isConjunctiveNextOperator;
                        isConjunctiveNextOperator = true
                    } else {
                        isConjunctiveNextOperator = dataUtils.isConjunctiveOperator(this)
                    }
                });
                return function(d) {
                    var result = isConjunctiveOperator;
                    for (var i = 0; i < ops.length; i++) {
                        if (ops[i](d) !== isConjunctiveOperator) {
                            result = !isConjunctiveOperator;
                            break
                        }
                    }
                    return result
                }
            };
            var toString = function(value) {
                return typeUtils.isDefined(value) ? value.toString() : ""
            };
            var compileBinary = function(crit) {
                crit = dataUtils.normalizeBinaryCriterion(crit);
                var getter = compileGetter(crit[0]),
                    op = crit[1],
                    value = crit[2];
                value = toComparable(value);
                switch (op.toLowerCase()) {
                    case "=":
                        return compileEquals(getter, value);
                    case "<>":
                        return compileEquals(getter, value, true);
                    case ">":
                        return function(obj) {
                            return toComparable(getter(obj)) > value
                        };
                    case "<":
                        return function(obj) {
                            return toComparable(getter(obj)) < value
                        };
                    case ">=":
                        return function(obj) {
                            return toComparable(getter(obj)) >= value
                        };
                    case "<=":
                        return function(obj) {
                            return toComparable(getter(obj)) <= value
                        };
                    case "startswith":
                        return function(obj) {
                            return 0 === toComparable(toString(getter(obj))).indexOf(value)
                        };
                    case "endswith":
                        return function(obj) {
                            var getterValue = toComparable(toString(getter(obj))),
                                searchValue = toString(value);
                            if (getterValue.length < searchValue.length) {
                                return false
                            }
                            return getterValue.lastIndexOf(value) === getterValue.length - value.length
                        };
                    case "contains":
                        return function(obj) {
                            return toComparable(toString(getter(obj))).indexOf(value) > -1
                        };
                    case "notcontains":
                        return function(obj) {
                            return toComparable(toString(getter(obj))).indexOf(value) === -1
                        }
                }
                throw errorsModule.errors.Error("E4003", op)
            };

            function compileEquals(getter, value, negate) {
                return function(obj) {
                    obj = toComparable(getter(obj));
                    var result = useStrictComparison(value) ? obj === value : obj == value;
                    if (negate) {
                        result = !result
                    }
                    return result
                }
            }

            function useStrictComparison(value) {
                return "" === value || 0 === value || false === value
            }

            function compileUnary(crit) {
                var op = crit[0],
                    criteria = compileCriteria(crit[1]);
                if ("!" === op) {
                    return function(obj) {
                        return !criteria(obj)
                    }
                }
                throw errorsModule.errors.Error("E4003", op)
            }
            return function(crit) {
                if (typeUtils.isFunction(crit)) {
                    return crit
                }
                if (dataUtils.isGroupCriterion(crit)) {
                    return compileGroup(crit)
                }
                if (dataUtils.isUnaryOperation(crit)) {
                    return compileUnary(crit)
                }
                return compileBinary(crit)
            }
        }();
        var FilterIterator = WrappedIterator.inherit({
            ctor: function(iter, criteria) {
                this.callBase(iter);
                this.criteria = compileCriteria(criteria)
            },
            next: function() {
                while (this.iter.next()) {
                    if (this.criteria(this.current())) {
                        return true
                    }
                }
                return false
            }
        });
        var GroupIterator = Iterator.inherit({
            ctor: function(iter, getter) {
                this.iter = iter;
                this.getter = getter
            },
            next: function() {
                this._ensureGrouped();
                return this.groupedIter.next()
            },
            current: function() {
                this._ens