/**
 * DevExtreme (ui/speed_dial_action/speed_dial_main_item.js)
 * Version: 19.2.3
 * Build date: Tue Oct 22 2019
 *
 * Copyright (c) 2012 - 2019 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
 */
"use strict";
var _renderer = require("../../core/renderer");
var _renderer2 = _interopRequireDefault(_renderer);
var _config = require("../../core/config");
var _config2 = _interopRequireDefault(_config);
var _extend = require("../../core/utils/extend");
var _events_engine = require("../../events/core/events_engine");
var _events_engine2 = _interopRequireDefault(_events_engine);
var _ui = require("../widget/ui.errors");
var _ui2 = _interopRequireDefault(_ui);
var _swatch_container = require("../widget/swatch_container");
var _speed_dial_item = require("./speed_dial_item");
var _speed_dial_item2 = _interopRequireDefault(_speed_dial_item);
var _themes = require("../themes");
var _themes2 = _interopRequireDefault(_themes);

function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
        "default": obj
    }
}
var FAB_MAIN_CLASS = "dx-fa-button-main";
var FAB_MAIN_CLASS_WITH_LABEL = "dx-fa-button-with-label";
var FAB_CLOSE_ICON_CLASS = "dx-fa-button-icon-close";
var INVISIBLE_STATE_CLASS = "dx-state-invisible";
var speedDialMainItem = null;
var SpeedDialMainItem = _speed_dial_item2.default.inherit({
    _actionItems: [],
    _isShadingShown: false,
    _getDefaultOptions: function() {
        var defaultOptions = {
            icon: "add",
            closeIcon: "close",
            position: {
                at: "right bottom",
                my: "right bottom",
                offset: {
                    x: -16,
                    y: -16
                }
            },
            maxSpeedDialActionCount: 5,
            hint: "",
            label: "",
            direction: "auto",
            actions: [],
            activeStateEnabled: true,
            hoverStateEnabled: true,
            indent: 55,
            childIndent: 40,
            childOffset: 9,
            callOverlayRenderShading: true,
            closeOnOutsideClick: true
        };
        return (0, _extend.extend)(this.callBase(), (0, _extend.extend)(defaultOptions, (0, _config2.default)().floatingActionButtonConfig, {
            shading: false
        }))
    },
    _defaultOptionsRules: function() {
        return this.callBase().concat([{
            device: function() {
                return _themes2.default.isMaterial()
            },
            options: {
                indent: 72,
                childIndent: 56,
                childOffset: 8
            }
        }])
    },
    _render: function() {
        this.$element().addClass(FAB_MAIN_CLASS);
        this.callBase();
        this._moveToContainer();
        this._renderCloseIcon();
        this._renderClick()
    },
    _renderLabel: function() {
        this.callBase();
        this.$element().toggleClass(FAB_MAIN_CLASS_WITH_LABEL, !!this._$label)
    },
    _renderCloseIcon: function() {
        this._$closeIcon = this._renderButtonIcon(this._$closeIcon, this._options.closeIcon, FAB_CLOSE_ICON_CLASS);
        this._$closeIcon.addClass(INVISIBLE_STATE_CLASS)
    },
    _renderClick: function() {
        this._clickAction = 1 === this._getVisibleActions().length ? this._createActionByOption("onClick") : this._createAction(this._clickHandler);
        this._setClickAction()
    },
    _defaultActionArgs: function() {
        var actions = this._getVisibleActions();
        return {
            component: 1 === actions.length ? actions[0] : this
        }
    },
    _getVisibleActions: function(actions) {
        var currentActions = actions || this.option("actions");
        return currentActions.filter(function(action) {
            return action.option("visible")
        })
    },
    _getCurrentOptions: function(actions) {
        var visibleActions = speedDialMainItem._getVisibleActions(actions);
        return 1 === visibleActions.length ? (0, _extend.extend)(visibleActions[0]._options, {
            position: this._getPosition()
        }) : (0, _extend.extend)(this._getDefaultOptions(), {
            visible: 0 !== visibleActions.length
        })
    },
    _clickHandler: function() {
        var actions = this._actionItems.filter(function(action) {
            return action.option("actionVisible")
        }).sort(function(action, nextAction) {
            return action.option("index") - nextAction.option("index")
        });
        if (1 === actions.length) {
            return
        }
        var lastActionIndex = actions.length - 1;
        for (var i = 0; i < actions.length; i++) {
            actions[i].option("animation", this._getActionAnimation(actions[i], i, lastActionIndex));
            actions[i].option("position", this._getActionPosition(actions, i));
            actions[i]._$wrapper.css("position", this._$wrapper.css("position"));
            actions[i].toggle()
        }
        if ((0, _config2.default)().floatingActionButtonConfig.shading) {
            this._isShadingShown = !this.option("shading");
            this.option("shading", this._isShadingShown)
        }
        this._$icon.toggleClass(INVISIBLE_STATE_CLASS);
        this._$closeIcon.toggleClass(INVISIBLE_STATE_CLASS)
    },
    _updateZIndexStackPosition: function() {
        this.callBase();
        var overlayStack = this._overlayStack();
        overlayStack.push(this)
    },
    _renderActions: function() {
        var _this = this;
        var actions = this.option("actions");
        var minActionButtonCount = 1;
        if (this._actionItems.length) {
            this._actionItems.forEach(function(actionItem) {
                actionItem.dispose();
                actionItem.$element().remove()
            });
            this._actionItems = []
        }
        if (actions.length === minActionButtonCount) {
            return
        }
        for (var i = 0; i < actions.length; i++) {
            var action = actions[i];
            var $actionElement = (0, _renderer2.default)("<div>").appendTo((0, _swatch_container.getSwatchContainer)(action.$element()));
            _events_engine2.default.off($actionElement, "click");
            _events_engine2.default.on($actionElement, "click", function() {
                _this._clickHandler()
            });
            action._options.actionComponent = action;
            action._options.parentPosition = this._getPosition();
            action._options.actionVisible = action._options.visible;
            this._actionItems.push(this._createComponent($actionElement, _speed_dial_item2.default, (0, _extend.extend)({}, action._options, {
                visible: false
            })))
        }
    },
    _getActionAnimation: function(action, index, lastActionIndex) {
        var actionAnimationDelay = 30;
        action._options.animation.show.delay = actionAnimationDelay * index;
        action._options.animation.hide.delay = actionAnimationDelay * (lastActionIndex - index);
        return action._options.animation
    },
    _getDirectionIndex: function(actions, direction) {
        var directionIndex = 1;
        if ("auto" === direction) {
            var contentHeight = this.$content().height();
            var actionsHeight = this.initialOption("indent") + this.initialOption("childIndent") * actions.length - contentHeight;
            var offsetTop = this.$content().offset().top;
            if (actionsHeight < offsetTop) {
                return -directionIndex
            } else {
                var offsetBottom = this._getContainer().height() - contentHeight - offsetTop;
                return offsetTop >= offsetBottom ? -directionIndex : directionIndex
            }
        }
        return "down" !== direction ? -directionIndex : directionIndex
    },
    _getActionPosition: function(actions, index) {
        var action = actions[index];
        var actionOffsetXValue = this.initialOption("childOffset");
        var actionOffsetX = action._options.label && !this._$label ? this._isPositionLeft(this._getPosition()) ? actionOffsetXValue : -actionOffsetXValue : 0;
        var actionOffsetYValue = this.initialOption("indent") + this.initialOption("childIndent") * index;
        var actionOffsetY = this._getDirectionIndex(actions, this.option("direction")) * actionOffsetYValue;
        var actionPositionAtMy = action._options.label ? this._isPositionLeft(this._getPosition()) ? "left" : "right" : "center";
        return {
            of: this.$content(),
            at: actionPositionAtMy,
            my: actionPositionAtMy,
            offset: {
                x: actionOffsetX,
                y: actionOffsetY
            }
        }
    },
    _outsideClickHandler: function(e) {
        if (this._isShadingShown) {
            var isShadingClick = (0, _renderer2.default)(e.target)[0] === this._$wrapper[0];
            if (isShadingClick) {
                this._clickHandler()
            }
        }
    },
    _setPosition: function() {
        if (this.option("visible")) {
            this._hide();
            this._show()
        }
    },
    _getPosition: function() {
        return this._getDefaultOptions().position
    },
    _getInkRippleContainer: function() {
        return this.$content()
    },
    _optionChanged: function(args) {
        switch (args.name) {
            case "actions":
                if (this._isVisible()) {
                    this._renderIcon()
                }
                this._renderCloseIcon();
                this._renderClick();
                this._renderActions();
                break;
            case "maxSpeedDialActionCount":
                this._renderActions();
                break;
            case "closeIcon":
                this._renderCloseIcon();
                break;
            case "position":
                this._setPosition();
                break;
            case "label":
                if (this._isVisible()) {
                    this._renderLabel()
                }
                this._setPosition();
                break;
            case "icon":
                if (this._isVisible()) {
                    this._renderIcon()
                }
                break;
            default:
                this.callBase(args)
        }
    }
});
exports.initAction = function(newAction) {
    delete newAction._options.onInitializing;
    var isActionExist = false;
    if (!speedDialMainItem) {
        var $fabMainElement = (0, _renderer2.default)("<div>").appendTo((0, _swatch_container.getSwatchContainer)(newAction.$element()));
        speedDialMainItem = newAction._createComponent($fabMainElement, SpeedDialMainItem, (0, _extend.extend)({}, newAction._options, {
            actions: [newAction]
        }))
    } else {
        var savedActions = speedDialMainItem.option("actions");
        savedActions.forEach(function(action) {
            if (action._options.id === newAction._options.id) {
                isActionExist = true;
                return newAction
            }
        });
        delete speedDialMainItem._options.position;
        if (!isActionExist) {
            if (speedDialMainItem._getVisibleActions(savedActions).length >= speedDialMainItem.option("maxSpeedDialActionCount")) {
                newAction.dispose();
                _ui2.default.log("W1014");
                return
            }
            savedActions.push(newAction);
            speedDialMainItem.option((0, _extend.extend)(speedDialMainItem._getCurrentOptions(savedActions), {
                actions: savedActions
            }))
        } else {
            if (1 === savedActions.length) {
                speedDialMainItem.option((0, _extend.extend)({}, savedActions[0]._options, {
                    actions: savedActions,
                    position: speedDialMainItem._getPosition()
                }))
            } else {
                speedDialMainItem.option((0, _extend.extend)(speedDialMainItem._getCurrentOptions(savedActions), {
                    actions: savedActions
                }))
            }
        }
    }
};
exports.disposeAction = function(actionId) {
    if (!speedDialMainItem) {
        return
    }
    var savedActions = speedDialMainItem.option("actions");
    var savedActionsCount = savedActions.length;
    savedActions = savedActions.filter(function(action) {
        return action._options.id !== actionId
    });
    if (savedActionsCount === savedActions.length) {
        return
    }
    if (!savedActions.length) {
        speedDialMainItem.dispose();
        speedDialMainItem.$element().remove();
        speedDialMainItem = null
    } else {
        if (1 === savedActions.length) {
            speedDialMainItem.option((0, _extend.extend)({}, savedActions[0]._options, {
                actions: savedActions
            }))
        } else {
            speedDialMainItem.option({
                actions: savedActions
            })
        }
    }
};
exports.repaint = function() {
    if (!speedDialMainItem) {
        return
    }
    var icon = 1 === speedDialMainItem.option("actions").length ? speedDialMainItem.option("actions")[0].option("icon") : speedDialMainItem._getDefaultOptions().icon;
    speedDialMainItem.option({
        actions: speedDialMainItem.option("actions"),
        icon: icon,
        closeIcon: speedDialMainItem._getDefaultOptions().closeIcon,
        position: speedDialMainItem._getPosition(),
        label: speedDialMainItem._getDefaultOptions().label,
        maxSpeedDialActionCount: speedDialMainItem._getDefaultOptions().maxSpeedDialActionCount
    })
};
