/**
 * DevExtreme (ui/validation/validation_mixin.js)
 * Version: 19.2.3
 * Build date: Tue Oct 22 2019
 *
 * Copyright (c) 2012 - 2019 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
 */
"use strict";
var VALIDATION_STATUS_VALID = "valid",
    VALIDATION_STATUS_INVALID = "invalid",
    VALIDATION_STATUS_PENDING = "pending";
var ValidationMixin = {
    _findGroup: function() {
        var group = this.option("validationGroup"),
            $dxGroup = void 0;
        if (!group) {
            $dxGroup = this.$element().parents(".dx-validationgroup").first();
            if ($dxGroup.length) {
                group = $dxGroup.dxValidationGroup("instance")
            } else {
                group = this._modelByElement(this.$element())
            }
        }
        return group
    },
    _initValidationOptions: function(options) {
        var _this = this;
        if (options) {
            var syncOptions = ["isValid", "validationStatus", "validationError", "validationErrors"];
            syncOptions.forEach(function(prop) {
                if (prop in options) {
                    _this._synchronizeValidationOptions({
                        name: prop,
                        value: options[prop]
                    })
                }
            })
        }
    },
    _synchronizeValidationOptions: function(_ref) {
        var name = _ref.name,
            value = _ref.value;
        if ("validationStatus" === name) {
            var isValid = value === VALIDATION_STATUS_VALID || value === VALIDATION_STATUS_PENDING;
            this.option("isValid") !== isValid && this.option("isValid", isValid);
            return
        }
        if ("isValid" === name) {
            var validationStatus = this.option("validationStatus");
            var newStatus = validationStatus;
            if (value && validationStatus === VALIDATION_STATUS_INVALID) {
                newStatus = VALIDATION_STATUS_VALID
            } else {
                if (!value && validationStatus !== VALIDATION_STATUS_INVALID) {
                    newStatus = VALIDATION_STATUS_INVALID
                }
            }
            newStatus !== validationStatus && this.option("validationStatus", newStatus);
            return
        }
        if ("validationErrors" === name) {
            var validationError = !value || !value.length ? null : value[0];
            this.option("validationError") !== validationError && this.option("validationError", validationError);
            return
        }
        if ("validationError" === name) {
            var validationErrors = this.option("validationErrors");
            if (!value && validationErrors) {
                this.option("validationErrors", null)
            } else {
                if (value && !validationErrors) {
                    this.option("validationErrors", [value])
                } else {
                    if (value && validationErrors && value !== validationErrors[0]) {
                        validationErrors[0] = value;
                        this.option("validationErrors", validationErrors.slice())
                    }
                }
            }
        }
    }
};
module.exports = ValidationMixin;
