/*
 Highcharts JS v7.2.2 (2020-08-24)

 Support for parallel coordinates in Highcharts

 (c) 2010-2019 Pawel Fus

 License: www.highcharts.com/license
*/
(function(b){"object"===typeof module&&module.exports?(b["default"]=b,module.exports=b):"function"===typeof define&&define.amd?define("highcharts/modules/parallel-coordinates",["highcharts"],function(e){b(e);b.Highcharts=e;return b}):b("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(b){function e(n,b,e,q){n.hasOwnProperty(b)||(n[b]=q.apply(null,e))}b=b?b._modules:{};e(b,"modules/parallel-coordinates.src.js",[b["parts/Globals.js"],b["parts/Utilities.js"]],function(b,f){function e(a){var c=
this.series&&this.series.chart,k=a.apply(this,Array.prototype.slice.call(arguments,1)),l;if(c&&c.hasParallelCoordinates&&!p(k.formattedValue)){var g=c.yAxis[this.x];var d=g.options;c=(l=u(d.tooltipValueFormat,d.labels.format))?b.format(l,r(this,{value:this.y}),c.time):g.isDatetimeAxis?c.time.dateFormat(c.time.resolveDTLFormat(d.dateTimeLabelFormats[g.tickPositions.info.unitName]).main,this.y):d.categories?d.categories[this.y]:this.y;k.formattedValue=k.point.formattedValue=c}return k}var q=f.arrayMax,
n=f.arrayMin,p=f.defined,y=f.erase,r=f.extend,u=f.pick,v=f.splat;f=b.Axis;var t=b.Chart,z=t.prototype,w=b.Axis.prototype,h=b.addEvent,A=b.wrap,m=b.merge,x={lineWidth:0,tickLength:0,opposite:!0,type:"category"};b.setOptions({chart:{parallelCoordinates:!1,parallelAxes:{lineWidth:1,title:{text:"",reserveSpace:!1},labels:{x:0,y:4,align:"center",reserveSpace:!1},offset:0}}});h(t,"init",function(a){a=a.args[0];var c=v(a.yAxis||{}),b=c.length,l=[];if(this.hasParallelCoordinates=a.chart&&a.chart.parallelCoordinates){for(this.setParallelInfo(a);b<=
this.parallelInfo.counter;b++)l.push({});a.legend||(a.legend={});void 0===a.legend.enabled&&(a.legend.enabled=!1);m(!0,a,{boost:{seriesThreshold:Number.MAX_VALUE},plotOptions:{series:{boostThreshold:Number.MAX_VALUE}}});a.yAxis=c.concat(l);a.xAxis=m(x,v(a.xAxis||{})[0])}});h(t,"update",function(a){a=a.options;a.chart&&(p(a.chart.parallelCoordinates)&&(this.hasParallelCoordinates=a.chart.parallelCoordinates),this.options.chart.parallelAxes=m(this.options.chart.parallelAxes,a.chart.parallelAxes));this.hasParallelCoordinates&&
(a.series&&this.setParallelInfo(a),this.yAxis.forEach(function(a){a.update({},!1)}))});r(z,{setParallelInfo:function(a){var c=this;a=a.series;c.parallelInfo={counter:0};a.forEach(function(a){a.data&&(c.parallelInfo.counter=Math.max(c.parallelInfo.counter,a.data.length-1))})}});w.keepProps.push("parallelPosition");h(f,"afterSetOptions",function(a){var c=this.chart,b=["left","width","height","top"];c.hasParallelCoordinates&&(c.inverted&&(b=b.reverse()),this.isXAxis?this.options=m(this.options,x,a.userOptions):
(this.options=m(this.options,this.chart.options.chart.parallelAxes,a.userOptions),this.parallelPosition=u(this.parallelPosition,c.yAxis.length),this.setParallelPosition(b,this.options)))});h(f,"getSeriesExtremes",function(a){if(this.chart&&this.chart.hasParallelCoordinates&&!this.isXAxis){var b=this.parallelPosition,k=[];this.series.forEach(function(a){a.visible&&p(a.yData[b])&&k.push(a.yData[b])});this.dataMin=n(k);this.dataMax=q(k);a.preventDefault()}});r(w,{setParallelPosition:function(a,b){var c=
(this.parallelPosition+.5)/(this.chart.parallelInfo.counter+1);this.chart.polar?b.angle=360*c:(b[a[0]]=100*c+"%",this[a[1]]=b[a[1]]=0,this[a[2]]=b[a[2]]=null,this[a[3]]=b[a[3]]=null)}});h(b.Series,"bindAxes",function(a){if(this.chart.hasParallelCoordinates){var b=this;this.chart.axes.forEach(function(a){b.insert(a.series);a.isDirty=!0});b.xAxis=this.chart.xAxis[0];b.yAxis=this.chart.yAxis[0];a.preventDefault()}});h(b.Series,"afterTranslate",function(){var a=this.chart,b=this.points,f=b&&b.length,
e=Number.MAX_VALUE,g;if(this.chart.hasParallelCoordinates){for(g=0;g<f;g++){var d=b[g];if(p(d.y)){d.plotX=a.polar?a.yAxis[g].angleRad||0:a.inverted?a.plotHeight-a.yAxis[g].top+a.plotTop:a.yAxis[g].left-a.plotLeft;d.clientX=d.plotX;d.plotY=a.yAxis[g].translate(d.y,!1,!0,null,!0);void 0!==h&&(e=Math.min(e,Math.abs(d.plotX-h)));var h=d.plotX;d.isInside=a.isInsidePlot(d.plotX,d.plotY,a.inverted)}else d.isNull=!0}this.closestPointRangePx=e}},{order:1});b.addEvent(b.Series,"destroy",function(){this.chart.hasParallelCoordinates&&
(this.chart.axes||[]).forEach(function(a){a&&a.series&&(y(a.series,this),a.isDirty=a.forceRedraw=!0)},this)});["line","spline"].forEach(function(a){A(b.seriesTypes[a].prototype.pointClass.prototype,"getLabelConfig",e)})});e(b,"masters/modules/parallel-coordinates.src.js",[],function(){})});
//# sourceMappingURL=parallel-coordinates.js.map