"use strict";

var Luci = Luci || {};

Luci.Button = function() {
  const buttonToggleIcon = document.querySelectorAll('.luci-button--toggle-icon');

  function toggleButtonIcon(e) {
    e.preventDefault();
    let iconOn = this.dataset.toggleIconOn;
    let iconOff = this.dataset.toggleIconOff;
    let iconElement = this.querySelector('.luci-icon use');
    let currentIcon = iconElement.getAttribute('xlink:href');

    if (currentIcon === '/icons/luci.svg#' + iconOff) {
      iconElement.setAttribute('xlink:href', '/icons/luci.svg#' + iconOn);
    } else {
      iconElement.setAttribute('xlink:href', '/icons/luci.svg#' + iconOff);
    }
  }

  const init = function init() {
    buttonToggleIcon.forEach(function (el) {
      el.addEventListener('click', toggleButtonIcon);
    });
  };

  return {
    init: init
  };
}();

document.addEventListener('DOMContentLoaded', function() {
  Luci.Button.init();
});
