"use strict";

function luciPopover() {
    const popoverObject = document.querySelectorAll('.luci-popover'),
        popoverButton = document.querySelectorAll('.luci-popover__trigger'),
        popoverAction = document.querySelectorAll('.luci-popover__action'),
        popoverDismiss = document.querySelectorAll('.luci-popover__dismiss'),
        popoverContent = document.querySelectorAll('.luci-popover__wrapper'),
        popoverOpenClass = 'luci-popover--is-open',
        popoverLink = document.querySelectorAll('.luci-popover .luci-link');

    let i;

    function closeAllPopovers(triggerClicked) {
        let targetTrigger = document.querySelector('.luci-popover--is-open .luci-popover__trigger');
        for (i = 0; i < popoverObject.length; i++) {
            popoverObject[i].classList.remove(popoverOpenClass);
        }
        if (popoverLink.length) {
            for (i = 0; i < popoverLink.length; i++) {
                popoverLink[i].blur();
            }
        }
        for (i = 0; i < popoverButton.length; i++) {
            popoverButton[i].setAttribute('aria-expanded', false);
        }
        for (i = 0; i < popoverContent.length; i++) {
            popoverContent[i].setAttribute('aria-hidden', true);
        }
        for (i = 0; i < popoverDismiss.length; i++) {
            popoverDismiss[i].blur();
        }
        if (targetTrigger && !triggerClicked) {
          targetTrigger.focus();
        }
    }

    function togglePopover(popover) {
        let target = popover.closest('.luci-popover');
        let content = target.querySelector('.luci-popover__wrapper');
        let inputArray = target.querySelectorAll('.luci-form__input');
        let actionArray = target.querySelectorAll('.luci-popover__action');

        if (target.classList.contains(popoverOpenClass)) {
            closeAllPopovers();
        } else {
            closeAllPopovers(true);
            target.classList.add(popoverOpenClass);
            popover.setAttribute('aria-expanded', true);
            content.setAttribute('aria-hidden', false);
            if (inputArray.length) {
              inputArray[0].focus();
            } else if (actionArray.length) {
              actionArray[0].focus();
            }
        }
    }

    function handlePopoverButtonClick(e) {
        e.preventDefault();
        togglePopover(this);
    }

    popoverButton.forEach(function(e){
        e.addEventListener('click', handlePopoverButtonClick);
    });

    function handlePopoverDismissClick() {
        closeAllPopovers();
    }

    popoverAction.forEach(function(e){
        e.addEventListener('click', handlePopoverDismissClick);
    });

    popoverDismiss.forEach(function(e){
        e.addEventListener('click', handlePopoverDismissClick);
    });

    //Stop Propagation on Popover Button and Content elements
    for (i = 0; i < popoverButton.length; i++) {
        popoverButton[i].addEventListener('click', function(e){e.stopPropagation();});
    }

    for (i = 0; i < popoverContent.length; i++) {
        popoverContent[i].addEventListener('click', function(e){e.stopPropagation();});
    }

    //Close All Popovers on body click
    document.addEventListener('click', function(event) {
      closeAllPopovers();
    });

    function handleDocumentKeydown(e) {
        //Esc key pressed
        if (e.keyCode === 27) {
            closeAllPopovers();
        }
    }

    document.addEventListener('keydown', handleDocumentKeydown);
}

document.addEventListener('DOMContentLoaded', function() {
    luciPopover();
});
