<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%
    Integer statusCode = (Integer) request.getAttribute("javax.servlet.error.status_code");
    String statusMessage = "Server error.";
    switch (statusCode) {
        case 400:
            statusMessage = "The request cannot be fulfilled due to bad syntax.";
            break;
        case 401:
            statusMessage = "Unauthorized, authentication required.";
            break;
        case 403:
            statusMessage = "The request was a legal request, but the server is refusing to respond to it.";
            break;
        case 404:
            statusMessage = "Page not found.";
            break;
        case 405:
            statusMessage = "Method not allowed.";
            break;
        case 406:
            statusMessage = "The server can only generate a response that is not accepted by the client.";
            break;
        case 407:
            statusMessage = "Proxy authentication required.";
            break;
        case 408:
            statusMessage = "The server timed out waiting for the request.";
            break;
        case 409:
            statusMessage = "The request could not be completed because of a conflict in the request";
            break;
        case 410:
            statusMessage = "Requested page no longer available.";
            break;
        case 411:
            statusMessage = "The \"Content-Length\" is not defined. The server will not accept the request without it.";
            break;
        case 412:
            statusMessage = "Precondition failed.";
            break;
        case 413:
            statusMessage = "Request entity too large.";
            break;
        case 414:
            statusMessage = "Request URI too long.";
            break;
        case 415:
            statusMessage = "The server will not accept the request, because the media type is not supported .";
            break;
        case 416:
            statusMessage = "The client has asked for a portion of the file, but the server cannot supply that portion.";
            break;
        case 417:
            statusMessage = "The server cannot meet the requirements of the Expect request-header field.";
            break;
        case 500:
            statusMessage = "Internal server error, uncaught exception.";
            break;
        case 501:
            statusMessage = "The server either does not recognize the request method, or it lacks the ability to fulfill the request.";
            break;
        case 502:
            statusMessage = "The server was acting as a gateway or proxy and received an invalid response from the upstream server.";
            break;
        case 503:
            statusMessage = "Service unavailable, unsupported servlet method.";
            break;
        case 504:
            statusMessage = "The server was acting as a gateway or proxy and did not receive a timely response from the upstream server.";
            break;
        case 505:
            statusMessage = "HTTP version not supported.";
            break;
        case 511:
            statusMessage = "Network authentication required.";
            break;
    }
%>
<html>
<head>
    <style>
        #errorDiv {
            text-align: left;
            font-size: 30px;
            color: #57A1D3;

        }

        #description {
            text-decoration-color: #333333;
            font-size: 15px;
        }

        body {
            background-color: #C3DCED;
            margin: 0;
            padding: 0;
            text-align: center;
            font-family: Arial;
        }

        .centered {
            position: fixed;
            display: inline-block;
            width: 30em;
            height: 18em;
            top: 0;
            bottom: 0;
            left: 0;
            right: 0;
            margin: auto;
        }

    </style>
    <title>
        Error Page
    </title>
</head>
<body>
<div align="middle" class="centered">
    <div id="errorDiv" align="left"><IMG src="/error/images/error.png" top="10" height="25" width="25" alt=""/> Error!
    </div>
    <p id="description" align="left">
        Unable to complete your action, please try again or <br>
        contact your system administrator.<br></p>

    <p style="font-size: 13px" align="left">Possible reason for error: <%=statusCode%> - <%=statusMessage%>
    </p>
</div>
</body>
</html>