"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function addUndefinedDefaults(value, _pointer, schema, _root) {
    if (value === undefined && schema) {
        if (schema.items || schema.type == 'array') {
            return [];
        }
        if (schema.properties || schema.type == 'object') {
            const newValue = {};
            for (const propName of Object.getOwnPropertyNames(schema.properties || {})) {
                newValue[propName] = undefined; // tslint:disable-line:no-any
            }
            return newValue;
        }
    }
    else if (schema
        && typeof value == 'object' && value
        && (schema.properties || schema.type == 'object')) {
        for (const propName of Object.getOwnPropertyNames(schema.properties || {})) {
            value[propName] = (propName in value)
                ? value[propName]
                : undefined; // tslint:disable-line:no-any
        }
    }
    return value;
}
exports.addUndefinedDefaults = addUndefinedDefaults;
//# sourceMappingURL=data:application/json;base64,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