"use strict";
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
const webpackOutputOptions = {
    colors: true,
    hash: true,
    timings: true,
    chunks: true,
    chunkModules: false,
    children: false,
    modules: false,
    reasons: false,
    warnings: true,
    errors: true,
    assets: true,
    version: false,
    errorDetails: false,
    moduleTrace: false,
};
const verboseWebpackOutputOptions = {
    children: true,
    assets: true,
    version: true,
    reasons: true,
    chunkModules: false,
    errorDetails: true,
    moduleTrace: true,
};
function getWebpackStatsConfig(verbose = false) {
    return verbose
        ? Object.assign(webpackOutputOptions, verboseWebpackOutputOptions)
        : webpackOutputOptions;
}
exports.getWebpackStatsConfig = getWebpackStatsConfig;
function getStatsConfig(wco) {
    const verbose = !!wco.buildOptions.verbose;
    return { stats: getWebpackStatsConfig(verbose) };
}
exports.getStatsConfig = getStatsConfig;
//# sourceMappingURL=data:application/json;base64,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