"use strict";
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
// tslint:disable
// TODO: cleanup this file, it's copied as is from Angular CLI.
Object.defineProperty(exports, "__esModule", { value: true });
// Force Webpack to throw compilation errors. Useful with karma-webpack when in single-run mode.
// Workaround for https://github.com/webpack-contrib/karma-webpack/issues/66
class KarmaWebpackFailureCb {
    constructor(callback) {
        this.callback = callback;
    }
    apply(compiler) {
        compiler.hooks.done.tap('KarmaWebpackFailureCb', (stats) => {
            if (stats.compilation.errors.length > 0) {
                this.callback(undefined, stats.compilation.errors.map((error) => error.message ? error.message : error.toString()));
            }
        });
    }
}
exports.KarmaWebpackFailureCb = KarmaWebpackFailureCb;
//# sourceMappingURL=data:application/json;base64,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