"use strict";
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@angular-devkit/core");
const rxjs_1 = require("rxjs");
const operators_1 = require("rxjs/operators");
class MissingFileReplacementException extends core_1.BaseException {
    constructor(path) {
        super(`The ${path} path in file replacements does not exist.`);
    }
}
exports.MissingFileReplacementException = MissingFileReplacementException;
function normalizeFileReplacements(fileReplacements, host, root) {
    if (fileReplacements.length === 0) {
        return rxjs_1.of([]);
    }
    // Ensure all the replacements exist.
    const errorOnFalse = (path) => operators_1.tap((exists) => {
        if (!exists) {
            throw new MissingFileReplacementException(core_1.getSystemPath(path));
        }
    });
    return rxjs_1.from(fileReplacements).pipe(operators_1.map(replacement => normalizeFileReplacement(replacement, root)), operators_1.concatMap(normalized => {
        return rxjs_1.from([normalized.replace, normalized.with]).pipe(operators_1.mergeMap(path => host.exists(path).pipe(errorOnFalse(path))), operators_1.ignoreElements(), operators_1.concat(rxjs_1.of(normalized)));
    }), operators_1.toArray());
}
exports.normalizeFileReplacements = normalizeFileReplacements;
function normalizeFileReplacement(fileReplacement, root) {
    const currentFormat = fileReplacement;
    const maybeOldFormat = fileReplacement;
    let replacePath;
    let withPath;
    if (maybeOldFormat.src && maybeOldFormat.replaceWith) {
        replacePath = core_1.normalize(maybeOldFormat.src);
        withPath = core_1.normalize(maybeOldFormat.replaceWith);
    }
    else {
        replacePath = core_1.normalize(currentFormat.replace);
        withPath = core_1.normalize(currentFormat.with);
    }
    // TODO: For 7.x should this only happen if not absolute?
    if (root) {
        replacePath = core_1.join(root, replacePath);
    }
    if (root) {
        withPath = core_1.join(root, withPath);
    }
    return { replace: replacePath, with: withPath };
}
//# sourceMappingURL=data:application/json;base64,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