"use strict";
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
const testing_1 = require("@angular-devkit/architect/testing");
const core_1 = require("@angular-devkit/core");
const devkitRoot = core_1.normalize(global._DevKitRoot); // tslint:disable-line:no-any
const workspaceRoot = core_1.join(devkitRoot, 'tests/angular_devkit/build_angular/hello-world-app/');
exports.host = new testing_1.TestProjectHost(workspaceRoot);
exports.outputPath = core_1.normalize('dist');
exports.browserTargetSpec = { project: 'app', target: 'build' };
exports.devServerTargetSpec = { project: 'app', target: 'serve' };
exports.extractI18nTargetSpec = { project: 'app', target: 'extract-i18n' };
exports.karmaTargetSpec = { project: 'app', target: 'test' };
exports.tslintTargetSpec = { project: 'app', target: 'lint' };
exports.protractorTargetSpec = { project: 'app-e2e', target: 'e2e' };
//# sourceMappingURL=data:application/json;base64,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