"use strict";
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
function mapObject(obj, mapper) {
    return Object.keys(obj).reduce((acc, k) => {
        acc[k] = mapper(k, obj[k]);
        return acc;
    }, {});
}
exports.mapObject = mapObject;
const copySymbol = Symbol();
// tslint:disable-next-line:no-any
function deepCopy(value) {
    if (Array.isArray(value)) {
        return value.map((o) => deepCopy(o));
    }
    else if (value && typeof value === 'object') {
        if (value[copySymbol]) {
            // This is a circular dependency. Just return the cloned value.
            return value[copySymbol];
        }
        if (value['toJSON']) {
            return JSON.parse(value['toJSON']());
        }
        const copy = new (Object.getPrototypeOf(value).constructor)();
        value[copySymbol] = copy;
        for (const key of Object.getOwnPropertyNames(value)) {
            copy[key] = deepCopy(value[key]);
        }
        value[copySymbol] = undefined;
        return copy;
    }
    else {
        return value;
    }
}
exports.deepCopy = deepCopy;
//# sourceMappingURL=data:application/json;base64,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