"use strict";
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@angular-devkit/core");
const rxjs_1 = require("rxjs");
const operators_1 = require("rxjs/operators");
const src_1 = require("../src");
exports.DefaultTimeout = 45000;
function runTargetSpec(host, targetSpec, overrides = {}, timeout = exports.DefaultTimeout, logger = new core_1.logging.NullLogger()) {
    targetSpec = Object.assign({}, targetSpec, { overrides });
    const workspaceFile = core_1.normalize('angular.json');
    const workspace = new core_1.experimental.workspace.Workspace(host.root(), host);
    // Emit when runArchitect$ completes or errors.
    // TODO: There must be a better way of doing this...
    let finalizeCB = () => { };
    const runArchitectFinalize$ = new rxjs_1.Observable(obs => {
        finalizeCB = () => obs.next();
    });
    // Load the workspace from the root of the host, then run a target.
    const runArchitect$ = workspace.loadWorkspaceFromHost(workspaceFile).pipe(operators_1.concatMap(ws => new src_1.Architect(ws).loadArchitect()), operators_1.concatMap(arch => arch.run(arch.getBuilderConfiguration(targetSpec), { logger })), operators_1.finalize(() => finalizeCB()));
    // Error out after the timeout if runArchitect$ hasn't finalized.
    const timeout$ = rxjs_1.timer(timeout).pipe(operators_1.takeUntil(runArchitectFinalize$), operators_1.concatMapTo(rxjs_1.throwError(`runTargetSpec timeout (${timeout}) reached.`)));
    return rxjs_1.merge(timeout$, runArchitect$);
}
exports.runTargetSpec = runTargetSpec;
//# sourceMappingURL=data:application/json;base64,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