/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { identifierName } from '../compile_metadata';
import * as o from '../output/output_ast';
import { Identifiers as R3 } from './r3_identifiers';
/**
 * Write a Renderer2 compatibility module factory to the output context.
 */
export function compileModuleFactory(outputCtx, module, backPatchReferenceOf, resolver) {
    const ngModuleFactoryVar = `${identifierName(module.type)}NgFactory`;
    const parentInjector = 'parentInjector';
    const createFunction = o.fn([new o.FnParam(parentInjector, o.DYNAMIC_TYPE)], [new o.IfStmt(o.THIS_EXPR.prop(R3.PATCH_DEPS).notIdentical(o.literal(true, o.INFERRED_TYPE)), [
            o.THIS_EXPR.prop(R3.PATCH_DEPS).set(o.literal(true, o.INFERRED_TYPE)).toStmt(),
            backPatchReferenceOf(module.type).callFn([]).toStmt()
        ])], o.INFERRED_TYPE, null, `${ngModuleFactoryVar}_Create`);
    const moduleFactoryLiteral = o.literalMap([
        { key: 'moduleType', value: outputCtx.importExpr(module.type.reference), quoted: false },
        { key: 'create', value: createFunction, quoted: false }
    ]);
    outputCtx.statements.push(o.variable(ngModuleFactoryVar).set(moduleFactoryLiteral).toDeclStmt(o.DYNAMIC_TYPE, [
        o.StmtModifier.Exported, o.StmtModifier.Final
    ]));
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicjNfbW9kdWxlX2ZhY3RvcnlfY29tcGlsZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi9wYWNrYWdlcy9jb21waWxlci9zcmMvcmVuZGVyMy9yM19tb2R1bGVfZmFjdG9yeV9jb21waWxlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTs7Ozs7O0dBTUc7QUFFSCxPQUFPLEVBQStDLGNBQWMsRUFBQyxNQUFNLHFCQUFxQixDQUFDO0FBRWpHLE9BQU8sS0FBSyxDQUFDLE1BQU0sc0JBQXNCLENBQUM7QUFHMUMsT0FBTyxFQUFDLFdBQVcsSUFBSSxFQUFFLEVBQUMsTUFBTSxrQkFBa0IsQ0FBQztBQUVuRDs7R0FFRztBQUNILE1BQU0sK0JBQ0YsU0FBd0IsRUFBRSxNQUErQixFQUN6RCxvQkFBbUUsRUFDbkUsUUFBaUM7SUFDbkMsTUFBTSxrQkFBa0IsR0FBRyxHQUFHLGNBQWMsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQztJQUVyRSxNQUFNLGNBQWMsR0FBRyxnQkFBZ0IsQ0FBQztJQUN4QyxNQUFNLGNBQWMsR0FBRyxDQUFDLENBQUMsRUFBRSxDQUN2QixDQUFDLElBQUksQ0FBQyxDQUFDLE9BQU8sQ0FBQyxjQUFjLEVBQUUsQ0FBQyxDQUFDLFlBQVksQ0FBQyxDQUFDLEVBQy9DLENBQUMsSUFBSSxDQUFDLENBQUMsTUFBTSxDQUNULENBQUMsQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxJQUFJLEVBQUUsQ0FBQyxDQUFDLGFBQWEsQ0FBQyxDQUFDLEVBQzlFO1lBQ0UsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLElBQUksRUFBRSxDQUFDLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQyxNQUFNLEVBQUU7WUFDOUUsb0JBQW9CLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDLE1BQU0sQ0FBQyxFQUFFLENBQUMsQ0FBQyxNQUFNLEVBQUU7U0FDdEQsQ0FBQyxDQUFDLEVBQ1AsQ0FBQyxDQUFDLGFBQWEsRUFBRSxJQUFJLEVBQUUsR0FBRyxrQkFBa0IsU0FBUyxDQUFDLENBQUM7SUFFM0QsTUFBTSxvQkFBb0IsR0FBRyxDQUFDLENBQUMsVUFBVSxDQUFDO1FBQ3hDLEVBQUMsR0FBRyxFQUFFLFlBQVksRUFBRSxLQUFLLEVBQUUsU0FBUyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxFQUFFLE1BQU0sRUFBRSxLQUFLLEVBQUM7UUFDdEYsRUFBQyxHQUFHLEVBQUUsUUFBUSxFQUFFLEtBQUssRUFBRSxjQUFjLEVBQUUsTUFBTSxFQUFFLEtBQUssRUFBQztLQUN0RCxDQUFDLENBQUM7SUFFSCxTQUFTLENBQUMsVUFBVSxDQUFDLElBQUksQ0FDckIsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsWUFBWSxFQUFFO1FBQ2xGLENBQUMsQ0FBQyxZQUFZLENBQUMsUUFBUSxFQUFFLENBQUMsQ0FBQyxZQUFZLENBQUMsS0FBSztLQUM5QyxDQUFDLENBQUMsQ0FBQztBQUNWLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgR29vZ2xlIEluYy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2FuZ3VsYXIuaW8vbGljZW5zZVxuICovXG5cbmltcG9ydCB7Q29tcGlsZU5nTW9kdWxlTWV0YWRhdGEsIENvbXBpbGVUeXBlTWV0YWRhdGEsIGlkZW50aWZpZXJOYW1lfSBmcm9tICcuLi9jb21waWxlX21ldGFkYXRhJztcbmltcG9ydCB7Q29tcGlsZU1ldGFkYXRhUmVzb2x2ZXJ9IGZyb20gJy4uL21ldGFkYXRhX3Jlc29sdmVyJztcbmltcG9ydCAqIGFzIG8gZnJvbSAnLi4vb3V0cHV0L291dHB1dF9hc3QnO1xuaW1wb3J0IHtPdXRwdXRDb250ZXh0fSBmcm9tICcuLi91dGlsJztcblxuaW1wb3J0IHtJZGVudGlmaWVycyBhcyBSM30gZnJvbSAnLi9yM19pZGVudGlmaWVycyc7XG5cbi8qKlxuICogV3JpdGUgYSBSZW5kZXJlcjIgY29tcGF0aWJpbGl0eSBtb2R1bGUgZmFjdG9yeSB0byB0aGUgb3V0cHV0IGNvbnRleHQuXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBjb21waWxlTW9kdWxlRmFjdG9yeShcbiAgICBvdXRwdXRDdHg6IE91dHB1dENvbnRleHQsIG1vZHVsZTogQ29tcGlsZU5nTW9kdWxlTWV0YWRhdGEsXG4gICAgYmFja1BhdGNoUmVmZXJlbmNlT2Y6IChtb2R1bGU6IENvbXBpbGVUeXBlTWV0YWRhdGEpID0+IG8uRXhwcmVzc2lvbixcbiAgICByZXNvbHZlcjogQ29tcGlsZU1ldGFkYXRhUmVzb2x2ZXIpIHtcbiAgY29uc3QgbmdNb2R1bGVGYWN0b3J5VmFyID0gYCR7aWRlbnRpZmllck5hbWUobW9kdWxlLnR5cGUpfU5nRmFjdG9yeWA7XG5cbiAgY29uc3QgcGFyZW50SW5qZWN0b3IgPSAncGFyZW50SW5qZWN0b3InO1xuICBjb25zdCBjcmVhdGVGdW5jdGlvbiA9IG8uZm4oXG4gICAgICBbbmV3IG8uRm5QYXJhbShwYXJlbnRJbmplY3Rvciwgby5EWU5BTUlDX1RZUEUpXSxcbiAgICAgIFtuZXcgby5JZlN0bXQoXG4gICAgICAgICAgby5USElTX0VYUFIucHJvcChSMy5QQVRDSF9ERVBTKS5ub3RJZGVudGljYWwoby5saXRlcmFsKHRydWUsIG8uSU5GRVJSRURfVFlQRSkpLFxuICAgICAgICAgIFtcbiAgICAgICAgICAgIG8uVEhJU19FWFBSLnByb3AoUjMuUEFUQ0hfREVQUykuc2V0KG8ubGl0ZXJhbCh0cnVlLCBvLklORkVSUkVEX1RZUEUpKS50b1N0bXQoKSxcbiAgICAgICAgICAgIGJhY2tQYXRjaFJlZmVyZW5jZU9mKG1vZHVsZS50eXBlKS5jYWxsRm4oW10pLnRvU3RtdCgpXG4gICAgICAgICAgXSldLFxuICAgICAgby5JTkZFUlJFRF9UWVBFLCBudWxsLCBgJHtuZ01vZHVsZUZhY3RvcnlWYXJ9X0NyZWF0ZWApO1xuXG4gIGNvbnN0IG1vZHVsZUZhY3RvcnlMaXRlcmFsID0gby5saXRlcmFsTWFwKFtcbiAgICB7a2V5OiAnbW9kdWxlVHlwZScsIHZhbHVlOiBvdXRwdXRDdHguaW1wb3J0RXhwcihtb2R1bGUudHlwZS5yZWZlcmVuY2UpLCBxdW90ZWQ6IGZhbHNlfSxcbiAgICB7a2V5OiAnY3JlYXRlJywgdmFsdWU6IGNyZWF0ZUZ1bmN0aW9uLCBxdW90ZWQ6IGZhbHNlfVxuICBdKTtcblxuICBvdXRwdXRDdHguc3RhdGVtZW50cy5wdXNoKFxuICAgICAgby52YXJpYWJsZShuZ01vZHVsZUZhY3RvcnlWYXIpLnNldChtb2R1bGVGYWN0b3J5TGl0ZXJhbCkudG9EZWNsU3RtdChvLkRZTkFNSUNfVFlQRSwgW1xuICAgICAgICBvLlN0bXRNb2RpZmllci5FeHBvcnRlZCwgby5TdG10TW9kaWZpZXIuRmluYWxcbiAgICAgIF0pKTtcbn1cbiJdfQ==