/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler/src/identifiers", ["require", "exports"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var CORE = '@angular/core';
    var Identifiers = /** @class */ (function () {
        function Identifiers() {
        }
        Identifiers.ANALYZE_FOR_ENTRY_COMPONENTS = {
            name: 'ANALYZE_FOR_ENTRY_COMPONENTS',
            moduleName: CORE,
        };
        Identifiers.ElementRef = { name: 'ElementRef', moduleName: CORE };
        Identifiers.NgModuleRef = { name: 'NgModuleRef', moduleName: CORE };
        Identifiers.ViewContainerRef = { name: 'ViewContainerRef', moduleName: CORE };
        Identifiers.ChangeDetectorRef = {
            name: 'ChangeDetectorRef',
            moduleName: CORE,
        };
        Identifiers.QueryList = { name: 'QueryList', moduleName: CORE };
        Identifiers.TemplateRef = { name: 'TemplateRef', moduleName: CORE };
        Identifiers.CodegenComponentFactoryResolver = {
            name: 'ɵCodegenComponentFactoryResolver',
            moduleName: CORE,
        };
        Identifiers.ComponentFactoryResolver = {
            name: 'ComponentFactoryResolver',
            moduleName: CORE,
        };
        Identifiers.ComponentFactory = { name: 'ComponentFactory', moduleName: CORE };
        Identifiers.ComponentRef = { name: 'ComponentRef', moduleName: CORE };
        Identifiers.NgModuleFactory = { name: 'NgModuleFactory', moduleName: CORE };
        Identifiers.createModuleFactory = {
            name: 'ɵcmf',
            moduleName: CORE,
        };
        Identifiers.moduleDef = {
            name: 'ɵmod',
            moduleName: CORE,
        };
        Identifiers.moduleProviderDef = {
            name: 'ɵmpd',
            moduleName: CORE,
        };
        Identifiers.RegisterModuleFactoryFn = {
            name: 'ɵregisterModuleFactory',
            moduleName: CORE,
        };
        Identifiers.inject = { name: 'inject', moduleName: CORE };
        Identifiers.INJECTOR = { name: 'INJECTOR', moduleName: CORE };
        Identifiers.Injector = { name: 'Injector', moduleName: CORE };
        Identifiers.defineInjectable = { name: 'defineInjectable', moduleName: CORE };
        Identifiers.InjectableDef = { name: 'ɵInjectableDef', moduleName: CORE };
        Identifiers.ViewEncapsulation = {
            name: 'ViewEncapsulation',
            moduleName: CORE,
        };
        Identifiers.ChangeDetectionStrategy = {
            name: 'ChangeDetectionStrategy',
            moduleName: CORE,
        };
        Identifiers.SecurityContext = {
            name: 'SecurityContext',
            moduleName: CORE,
        };
        Identifiers.LOCALE_ID = { name: 'LOCALE_ID', moduleName: CORE };
        Identifiers.TRANSLATIONS_FORMAT = {
            name: 'TRANSLATIONS_FORMAT',
            moduleName: CORE,
        };
        Identifiers.inlineInterpolate = {
            name: 'ɵinlineInterpolate',
            moduleName: CORE,
        };
        Identifiers.interpolate = { name: 'ɵinterpolate', moduleName: CORE };
        Identifiers.EMPTY_ARRAY = { name: 'ɵEMPTY_ARRAY', moduleName: CORE };
        Identifiers.EMPTY_MAP = { name: 'ɵEMPTY_MAP', moduleName: CORE };
        Identifiers.Renderer = { name: 'Renderer', moduleName: CORE };
        Identifiers.viewDef = { name: 'ɵvid', moduleName: CORE };
        Identifiers.elementDef = { name: 'ɵeld', moduleName: CORE };
        Identifiers.anchorDef = { name: 'ɵand', moduleName: CORE };
        Identifiers.textDef = { name: 'ɵted', moduleName: CORE };
        Identifiers.directiveDef = { name: 'ɵdid', moduleName: CORE };
        Identifiers.providerDef = { name: 'ɵprd', moduleName: CORE };
        Identifiers.queryDef = { name: 'ɵqud', moduleName: CORE };
        Identifiers.pureArrayDef = { name: 'ɵpad', moduleName: CORE };
        Identifiers.pureObjectDef = { name: 'ɵpod', moduleName: CORE };
        Identifiers.purePipeDef = { name: 'ɵppd', moduleName: CORE };
        Identifiers.pipeDef = { name: 'ɵpid', moduleName: CORE };
        Identifiers.nodeValue = { name: 'ɵnov', moduleName: CORE };
        Identifiers.ngContentDef = { name: 'ɵncd', moduleName: CORE };
        Identifiers.unwrapValue = { name: 'ɵunv', moduleName: CORE };
        Identifiers.createRendererType2 = { name: 'ɵcrt', moduleName: CORE };
        // type only
        Identifiers.RendererType2 = {
            name: 'RendererType2',
            moduleName: CORE,
        };
        // type only
        Identifiers.ViewDefinition = {
            name: 'ɵViewDefinition',
            moduleName: CORE,
        };
        Identifiers.createComponentFactory = { name: 'ɵccf', moduleName: CORE };
        return Identifiers;
    }());
    exports.Identifiers = Identifiers;
    function createTokenForReference(reference) {
        return { identifier: { reference: reference } };
    }
    exports.createTokenForReference = createTokenForReference;
    function createTokenForExternalReference(reflector, reference) {
        return createTokenForReference(reflector.resolveExternalReference(reference));
    }
    exports.createTokenForExternalReference = createTokenForExternalReference;
});
//# sourceMappingURL=data:application/json;base64,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