/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { makeParamDecorator } from '../util/decorators';
/**
 * Inject decorator and metadata.
 *
 * @Annotation
 */
export var Inject = makeParamDecorator('Inject', function (token) { return ({ token: token }); });
/**
 * Optional decorator and metadata.
 *
 * @Annotation
 */
export var Optional = makeParamDecorator('Optional');
/**
 * Self decorator and metadata.
 *
 * @Annotation
 */
export var Self = makeParamDecorator('Self');
/**
 * SkipSelf decorator and metadata.
 *
 * @Annotation
 */
export var SkipSelf = makeParamDecorator('SkipSelf');
/**
 * Host decorator and metadata.
 *
 * @Annotation
 */
export var Host = makeParamDecorator('Host');

//# sourceMappingURL=data:application/json;base64,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