/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { ɵstringify as stringify } from '@angular/core';
var _nextReferenceId = 0;
var MetadataOverrider = /** @class */ (function () {
    function MetadataOverrider() {
        this._references = new Map();
    }
    /**
     * Creates a new instance for the given metadata class
     * based on an old instance and overrides.
     */
    MetadataOverrider.prototype.overrideMetadata = function (metadataClass, oldMetadata, override) {
        var props = {};
        if (oldMetadata) {
            _valueProps(oldMetadata).forEach(function (prop) { return props[prop] = oldMetadata[prop]; });
        }
        if (override.set) {
            if (override.remove || override.add) {
                throw new Error("Cannot set and add/remove " + stringify(metadataClass) + " at the same time!");
            }
            setMetadata(props, override.set);
        }
        if (override.remove) {
            removeMetadata(props, override.remove, this._references);
        }
        if (override.add) {
            addMetadata(props, override.add);
        }
        return new metadataClass(props);
    };
    return MetadataOverrider;
}());
export { MetadataOverrider };
function removeMetadata(metadata, remove, references) {
    var removeObjects = new Set();
    var _loop_1 = function (prop) {
        var removeValue = remove[prop];
        if (removeValue instanceof Array) {
            removeValue.forEach(function (value) { removeObjects.add(_propHashKey(prop, value, references)); });
        }
        else {
            removeObjects.add(_propHashKey(prop, removeValue, references));
        }
    };
    for (var prop in remove) {
        _loop_1(prop);
    }
    var _loop_2 = function (prop) {
        var propValue = metadata[prop];
        if (propValue instanceof Array) {
            metadata[prop] = propValue.filter(function (value) { return !removeObjects.has(_propHashKey(prop, value, references)); });
        }
        else {
            if (removeObjects.has(_propHashKey(prop, propValue, references))) {
                metadata[prop] = undefined;
            }
        }
    };
    for (var prop in metadata) {
        _loop_2(prop);
    }
}
function addMetadata(metadata, add) {
    for (var prop in add) {
        var addValue = add[prop];
        var propValue = metadata[prop];
        if (propValue != null && propValue instanceof Array) {
            metadata[prop] = propValue.concat(addValue);
        }
        else {
            metadata[prop] = addValue;
        }
    }
}
function setMetadata(metadata, set) {
    for (var prop in set) {
        metadata[prop] = set[prop];
    }
}
function _propHashKey(propName, propValue, references) {
    var replacer = function (key, value) {
        if (typeof value === 'function') {
            value = _serializeReference(value, references);
        }
        return value;
    };
    return propName + ":" + JSON.stringify(propValue, replacer);
}
function _serializeReference(ref, references) {
    var id = references.get(ref);
    if (!id) {
        id = "" + stringify(ref) + _nextReferenceId++;
        references.set(ref, id);
    }
    return id;
}
function _valueProps(obj) {
    var props = [];
    // regular public props
    Object.keys(obj).forEach(function (prop) {
        if (!prop.startsWith('_')) {
            props.push(prop);
        }
    });
    // getters
    var proto = obj;
    while (proto = Object.getPrototypeOf(proto)) {
        Object.keys(proto).forEach(function (protoProp) {
            var desc = Object.getOwnPropertyDescriptor(proto, protoProp);
            if (!protoProp.startsWith('_') && desc && 'get' in desc) {
                props.push(protoProp);
            }
        });
    }
    return props;
}

//# sourceMappingURL=data:application/json;base64,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