(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('angular-highcharts'), require('@netapp/nwfjs_theme/icons/icons'), require('devextreme/ui/data_grid'), require('@angular/common'), require('@angular/forms'), require('devextreme-angular'), require('@uirouter/core'), require('rxjs'), require('rxjs/operators'), require('@angular/platform-browser'), require('angular-i18next'), require('@ng-bootstrap/ng-bootstrap'), require('@uirouter/angular'), require('@angular/core'), require('devextreme-angular/ui/nested/base/data-grid-column-dxi'), require('lodash-es')) :
    typeof define === 'function' && define.amd ? define('@netapp/nwfjs_angular_components', ['exports', 'angular-highcharts', '@netapp/nwfjs_theme/icons/icons', 'devextreme/ui/data_grid', '@angular/common', '@angular/forms', 'devextreme-angular', '@uirouter/core', 'rxjs', 'rxjs/operators', '@angular/platform-browser', 'angular-i18next', '@ng-bootstrap/ng-bootstrap', '@uirouter/angular', '@angular/core', 'devextreme-angular/ui/nested/base/data-grid-column-dxi', 'lodash-es'], factory) :
    (factory((global.netapp = global.netapp || {}, global.netapp.nwfjs_angular_components = {}),global.angularHighcharts,global.icons,global.DataGrid,global.ng.common,global.ng.forms,global.devextremeAngular,global.core,global.rxjs,global.rxjs.operators,global.ng.platformBrowser,global.i1,global.ngBootstrap,global.angular,global.ng.core,global.dataGridColumnDxi,global.lodashEs));
}(this, (function (exports,angularHighcharts,icons,DataGrid,common,forms,devextremeAngular,core,rxjs,operators,i2,i1,ngBootstrap,angular,i0,dataGridColumnDxi,lodashEs) { 'use strict';

    DataGrid = DataGrid && DataGrid.hasOwnProperty('default') ? DataGrid['default'] : DataGrid;

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var AlertComponent = /** @class */ (function () {
        function AlertComponent() {
            this.type = 'warning'; // this matches bootstrap's default which is warning.
            // this matches bootstrap's default which is warning.
            /* I just proxy these straight from ng-bootstrap/alert */
            this.dismissable = false;
            this.close = new i0.EventEmitter();
            this.isShowing = true;
        }
        /**
         * @return {?}
         */
        AlertComponent.prototype.onClose = /**
         * @return {?}
         */
            function () {
                this.isShowing = false;
                this.close.emit();
            };
        AlertComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-alert',
                        template: "\n  <ngb-alert [dismissible]=\"dismissable\" [type]=\"type\" *ngIf=\"isShowing\" (close)=\"onClose()\">\n  <div class=\"d-flex\">\n    <div *ngIf=\"type\">\n      <nwf-icon [severity]=\"type\"></nwf-icon>\n    </div>\n    <div class=\"flex-grow-1 ml-2\">\n       <ng-content></ng-content>\n    </div>\n  </div>\n</ngb-alert>\n  ",
                        styles: [":host .alert{color:#000;box-shadow:2px 2px 2px 0 rgba(0,0,0,.07)}:host .alert ::ng-deep h2{margin-top:4px;color:#252525;font-weight:600;font-size:16px}:host .alert ::ng-deep .close{color:#252525;opacity:1;min-height:32px;border-radius:.1rem}:host .alert.alert-success ::ng-deep .close:hover{color:#b4e697;background:#498128}:host .alert.alert-info ::ng-deep #base-layer{fill:#252525}:host .alert.alert-info ::ng-deep .close:hover{color:#fff7c0;background:#252525}:host .alert.alert-error ::ng-deep .close:hover{color:#fccdce;background:#da1e21}:host .alert.alert-warning ::ng-deep .close:hover{color:#ffe1a1;background:#f88402}"]
                    }] }
        ];
        /** @nocollapse */
        AlertComponent.ctorParameters = function () { return []; };
        AlertComponent.propDecorators = {
            type: [{ type: i0.Input }],
            dismissable: [{ type: i0.Input }],
            close: [{ type: i0.Output }]
        };
        return AlertComponent;
    }());

    /*! *****************************************************************************
    Copyright (c) Microsoft Corporation. All rights reserved.
    Licensed under the Apache License, Version 2.0 (the "License"); you may not use
    this file except in compliance with the License. You may obtain a copy of the
    License at http://www.apache.org/licenses/LICENSE-2.0

    THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
    WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
    MERCHANTABLITY OR NON-INFRINGEMENT.

    See the Apache Version 2.0 License for specific language governing permissions
    and limitations under the License.
    ***************************************************************************** */
    /* global Reflect, Promise */
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b)
                if (b.hasOwnProperty(p))
                    d[p] = b[p]; };
        return extendStatics(d, b);
    };
    function __extends(d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    }
    var __assign = function () {
        __assign = Object.assign || function __assign(t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    function __values(o) {
        var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
        if (m)
            return m.call(o);
        return {
            next: function () {
                if (o && i >= o.length)
                    o = void 0;
                return { value: o && o[i++], done: !o };
            }
        };
    }
    function __read(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    }
    function __spread() {
        for (var ar = [], i = 0; i < arguments.length; i++)
            ar = ar.concat(__read(arguments[i]));
        return ar;
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var NwfjsConfigService = /** @class */ (function () {
        function NwfjsConfigService(config) {
            this.appTitle = '';
            if (config) {
                this.appTitle = config.appTitle || this.appTitle;
                this.beaconInterval = config.beaconInterval || this.beaconInterval;
            }
        }
        /** @nocollapse */
        NwfjsConfigService.ctorParameters = function () {
            return [
                { type: undefined, decorators: [{ type: i0.Optional }] }
            ];
        };
        return NwfjsConfigService;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var NwfBeaconService = /** @class */ (function () {
        function NwfBeaconService(transitionService, config) {
            var _this = this;
            this.transitionService = transitionService;
            this.config = config;
            // Reset beacon on transition
            this.transitionService.onBefore({}, ( /**
             * @return {?}
             */function () {
                _this.ngOnDestroy();
                _this.ngOnInit();
            }));
            // Initial construction of the beacon service
            this.ngOnInit();
        }
        /**
         * @param {?} pollInterval
         * @return {?}
         */
        NwfBeaconService.prototype.setInterval = /**
         * @param {?} pollInterval
         * @return {?}
         */
            function (pollInterval) {
                this.resetTrigger();
                // Polling interval and signal to start the next request
                /** @type {?} */
                var pollIntervalObs = rxjs.interval(pollInterval);
                // Wait for previous poll to compolete before starting another
                /** @type {?} */
                var polling = rxjs.zip(pollIntervalObs, this.nextPoll.pipe(operators.takeUntil(this.destroyTrigger)));
                polling.pipe(operators.takeUntil(this.destroyTrigger)).subscribe(this.triggerLoad);
            };
        /**
         * @param {?} trigger
         * @return {?}
         */
        NwfBeaconService.prototype.setTrigger = /**
         * @param {?} trigger
         * @return {?}
         */
            function (trigger) {
                this.resetTrigger();
                trigger.pipe(operators.takeUntil(this.destroyTrigger), operators.takeUntil(this.destroy)).subscribe(this.triggerLoad);
            };
        // Trigger interval data request
        // Trigger interval data request
        /**
         * @return {?}
         */
        NwfBeaconService.prototype.start =
            // Trigger interval data request
            /**
             * @return {?}
             */
            function () {
                this.triggerLoad.next();
            };
        // Trigger manual data request
        // Trigger manual data request
        /**
         * @return {?}
         */
        NwfBeaconService.prototype.refresh =
            // Trigger manual data request
            /**
             * @return {?}
             */
            function () {
                this.manualLoad.next();
            };
        // Register service call to load data and return observable that emits the data
        // Register service call to load data and return observable that emits the data
        /**
         * @template T
         * @param {?} serviceCall
         * @return {?}
         */
        NwfBeaconService.prototype.register =
            // Register service call to load data and return observable that emits the data
            /**
             * @template T
             * @param {?} serviceCall
             * @return {?}
             */
            function (serviceCall) {
                /** @type {?} */
                var serviceObservable = this.loadData.pipe(operators.takeUntil(this.destroy), operators.concatMap(serviceCall), operators.share());
                this.services.push(serviceObservable);
                return serviceObservable;
            };
        /**
         * @private
         * @return {?}
         */
        NwfBeaconService.prototype.ngOnInit = /**
         * @private
         * @return {?}
         */
            function () {
                var _this = this;
                this.services = [];
                this.destroy = new rxjs.Subject();
                this.manualLoad = new rxjs.Subject();
                this.nextPoll = new rxjs.Subject();
                this.triggerLoad = new rxjs.Subject();
                this.destroyTrigger = new rxjs.Subject();
                /** @type {?} */
                var beaconInterval = lodashEs.get(this.config, 'beaconInterval');
                if (beaconInterval) {
                    this.setInterval(beaconInterval);
                }
                /*if(this.beaconListener) {
                    this.setTrigger(this.beaconListener.getBeacon());
                }*/
                // Load data triggers all the service calls
                this.loadData = rxjs.merge(this.triggerLoad.pipe(operators.map(( /**
                 * @return {?}
                 */function () { return NwfBeaconService.TRIGGER; }))), this.manualLoad.pipe(operators.map(( /**
                 * @return {?}
                 */function () { return NwfBeaconService.MANUAL; }))))
                    .pipe(operators.takeUntil(this.destroy), // complete all subscriptions on destroy
                operators.share());
                // We want to wait until all request are complete before firing off the next poll request
                this.loadComplete = this.loadData.pipe(operators.concatMap(( /**
                 * @param {?} value
                 * @return {?}
                 */function (value) { return rxjs.zip.apply(void 0, __spread([rxjs.of(value)], _this.services)); })), operators.share());
                this.loadComplete.pipe(operators.filter(( /**
                 * @param {?} __0
                 * @return {?}
                 */function (_a) {
                    var _b = __read(_a, 1), val = _b[0];
                    return val === NwfBeaconService.TRIGGER;
                }))).subscribe(this.nextPoll);
            };
        /**
         * @private
         * @return {?}
         */
        NwfBeaconService.prototype.resetTrigger = /**
         * @private
         * @return {?}
         */
            function () {
                if (this.destroyTrigger) {
                    this.destroyTrigger.next();
                    this.destroyTrigger.complete();
                }
                this.destroyTrigger = new rxjs.Subject();
            };
        // Clean up subjects
        // Clean up subjects
        /**
         * @private
         * @return {?}
         */
        NwfBeaconService.prototype.ngOnDestroy =
            // Clean up subjects
            /**
             * @private
             * @return {?}
             */
            function () {
                this.destroy.next();
                this.destroy.complete();
                this.destroyTrigger.next();
                this.destroyTrigger.complete();
                this.nextPoll.complete();
                this.manualLoad.complete();
                this.triggerLoad.complete();
            };
        NwfBeaconService.MANUAL = 'manual';
        NwfBeaconService.TRIGGER = 'trigger';
        NwfBeaconService.decorators = [
            { type: i0.Injectable }
        ];
        /** @nocollapse */
        NwfBeaconService.ctorParameters = function () {
            return [
                { type: core.TransitionService },
                { type: NwfjsConfigService }
            ];
        };
        return NwfBeaconService;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    /** @type {?} */
    var currentDate = new Date();
    /** @type {?} */
    var last13MonthsDate = new Date(currentDate.getTime() - (395 * 24 * 60 * 60 * 1000));
    var NwfDatetimePicker = /** @class */ (function () {
        function NwfDatetimePicker() {
            this.minDate = { year: last13MonthsDate.getFullYear(), month: last13MonthsDate.getMonth() + 1, day: last13MonthsDate.getDate() };
            this.maxDate = { year: currentDate.getFullYear(), month: currentDate.getMonth() + 1, day: currentDate.getDate() };
            this.navigation = 'arrows';
        }
        /**
         * @return {?}
         */
        NwfDatetimePicker.prototype.ngOnInit = /**
         * @return {?}
         */
            function () { };
        /**
         * Sets the min and max date for the widget. By default, minDate is the exact 13 months ago date and maxDate is the current date.
         * These dates are updated according to the min and max data provided in the argument of the function.
         * @param changes - SimpleChanges
         * @returns void
         */
        /**
         * Sets the min and max date for the widget. By default, minDate is the exact 13 months ago date and maxDate is the current date.
         * These dates are updated according to the min and max data provided in the argument of the function.
         * @param {?} changes - SimpleChanges
         * @return {?} void
         */
        NwfDatetimePicker.prototype.ngOnChanges = /**
         * Sets the min and max date for the widget. By default, minDate is the exact 13 months ago date and maxDate is the current date.
         * These dates are updated according to the min and max data provided in the argument of the function.
         * @param {?} changes - SimpleChanges
         * @return {?} void
         */
            function (changes) {
                // set maxDate, minDate if it exists in changes object.
                // else it takes default values defined above.
                if (changes.maxDate) {
                    // converting string to Date object.
                    /** @type {?} */
                    var maxDateObject = new Date(changes.maxDate.currentValue);
                    // creating NgbDateStruct model representation out of regular js date object.
                    this.maxDate = { year: maxDateObject.getFullYear(), month: maxDateObject.getMonth() + 1, day: maxDateObject.getDate() };
                }
                if (changes.minDate) {
                    // converting string to Date object.
                    /** @type {?} */
                    var minDateObject = new Date(changes.minDate.currentValue);
                    // creating NgbDateStruct model representation out of regular js date object.
                    this.minDate = { year: minDateObject.getFullYear(), month: minDateObject.getMonth() + 1, day: minDateObject.getDate() };
                }
            };
        /**
         *
         * writeValue() - Sets the datepickerModel, timePickerModel and startDate according to the date passed in the argument of the function.
         * @param datetimePickerValue - string
         * @returns void
         */
        /**
         *
         * writeValue() - Sets the datepickerModel, timePickerModel and startDate according to the date passed in the argument of the function.
         * @param {?} datetimePickerValue - string
         * @return {?} void
         */
        NwfDatetimePicker.prototype.writeValue = /**
         *
         * writeValue() - Sets the datepickerModel, timePickerModel and startDate according to the date passed in the argument of the function.
         * @param {?} datetimePickerValue - string
         * @return {?} void
         */
            function (datetimePickerValue) {
                if (datetimePickerValue) {
                    // converting string to Date object.
                    /** @type {?} */
                    var dateObject = new Date(datetimePickerValue);
                    // creating NgbDateStruct model representation out of regular js date object.
                    // we add +1 to month because NgbDateStruct month property takes in value as ISO format ie. month should be between 1-12,
                    // whereas getMonth returns month values from 0-11.
                    this.datepickerModel = { year: dateObject.getFullYear(), month: dateObject.getMonth() + 1, day: dateObject.getDate() };
                    this.startDate = { year: this.datepickerModel.year, month: this.datepickerModel.month };
                    // creating NgbTimeStruct model representation out of regular js date object.
                    this.timepickerModel = { hour: dateObject.getHours(), minute: dateObject.getMinutes(), second: 0 };
                }
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        NwfDatetimePicker.prototype.registerOnChange = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) { this._onChange = fn; };
        /**
         * @param {?} fn
         * @return {?}
         */
        NwfDatetimePicker.prototype.registerOnTouched = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) { };
        /**
         * @return {?}
         */
        NwfDatetimePicker.prototype.setDatetime = /**
         * @return {?}
         */
            function () {
                var _a = this.datepickerModel, year = _a.year, month = _a.month, day = _a.day;
                var _b = this.timepickerModel, hour = _b.hour, minute = _b.minute;
                /** @type {?} */
                var newDate = new Date(year, month - 1, day, hour, minute);
                this._onChange(newDate.toISOString());
            };
        NwfDatetimePicker.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-datetime-picker',
                        template: "\n        <ngb-datepicker [(ngModel)]=\"datepickerModel\" [maxDate]=\"maxDate\" [minDate]=\"minDate\" [startDate]=\"startDate\"\n            [navigation]=\"navigation\" firstDayOfWeek=\"7\" (ngModelChange)=\"setDatetime()\"></ngb-datepicker>\n        <div class=\"col my-2 p-0\">\n            <span class=\"label\">{{'nwfjs:time' | i18next}}:</span>\n            <ngb-timepicker [(ngModel)]=\"timepickerModel\" [meridian]=true (ngModelChange)=\"setDatetime()\"></ngb-timepicker>\n        </div>\n    ",
                        providers: [{
                                provide: forms.NG_VALUE_ACCESSOR,
                                useExisting: NwfDatetimePicker,
                                multi: true,
                            }],
                        styles: [".ngb-tp-input-container{color:red}.ngb-tp-input-container .form-control{width:60px}"]
                    }] }
        ];
        NwfDatetimePicker.propDecorators = {
            minDate: [{ type: i0.Input }],
            maxDate: [{ type: i0.Input }]
        };
        return NwfDatetimePicker;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var NwfDatetimeRangePicker = /** @class */ (function () {
        function NwfDatetimeRangePicker() {
        }
        /**
         * @return {?}
         */
        NwfDatetimeRangePicker.prototype.ngOnInit = /**
         * @return {?}
         */
            function () { };
        /**
         * @param {?} changes
         * @return {?}
         */
        NwfDatetimeRangePicker.prototype.ngOnChanges = /**
         * @param {?} changes
         * @return {?}
         */
            function (changes) { };
        /**
         * writeValue() - Sets the fromDate and toDate according to the input.
         * @param datetimeRangeValue - any
         * @returns void
         */
        /**
         * writeValue() - Sets the fromDate and toDate according to the input.
         * @param {?} datetimeRangeValue - any
         * @return {?} void
         */
        NwfDatetimeRangePicker.prototype.writeValue = /**
         * writeValue() - Sets the fromDate and toDate according to the input.
         * @param {?} datetimeRangeValue - any
         * @return {?} void
         */
            function (datetimeRangeValue) {
                var _a;
                if (datetimeRangeValue) {
                    _a = __read(datetimeRangeValue.split('~'), 2), this.fromDateISOString = _a[0], this.toDateISOString = _a[1];
                    // setting visible value.
                    this.setVisibleValue();
                }
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        NwfDatetimeRangePicker.prototype.registerOnChange = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) { this._onChange = fn; };
        /**
         * @param {?} fn
         * @return {?}
         */
        NwfDatetimeRangePicker.prototype.registerOnTouched = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) { };
        /**
         * setDatetimeRange() - Sets the fromDate and toDate from the ISOStrings
         * These dates are updated according to the min and max data provided in the argument of the function.
         * @param changes - SimpleChanges
         * @returns void
         */
        /**
         * setDatetimeRange() - Sets the fromDate and toDate from the ISOStrings
         * These dates are updated according to the min and max data provided in the argument of the function.
         * @return {?} void
         */
        NwfDatetimeRangePicker.prototype.setDatetimeRange = /**
         * setDatetimeRange() - Sets the fromDate and toDate from the ISOStrings
         * These dates are updated according to the min and max data provided in the argument of the function.
         * @return {?} void
         */
            function () {
                // create comma-separated range.
                /** @type {?} */
                var newDatetimeRange = this.fromDateISOString + "~" + this.toDateISOString;
                // setting visible value.
                this.setVisibleValue();
                // calling callback with sending the datetime range.
                this._onChange(newDatetimeRange);
            };
        /**
         * @return {?}
         */
        NwfDatetimeRangePicker.prototype.setVisibleValue = /**
         * @return {?}
         */
            function () {
                this.fromDate = new Date(this.fromDateISOString);
                this.toDate = new Date(this.toDateISOString);
            };
        NwfDatetimeRangePicker.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-datetime-range-picker',
                        template: "\n        <ng-template #datetimerangePickerTemplate>\n            <div class=\"d-flex\" data-netapp-id=\"datetime-range-picker\">\n                <div class=\"p-2 d-flex flex-column\" (click)=\"$event.stopPropagation()\" data-netapp-id=\"datetime-from-picker\">\n                    From:\n                    <nwf-datetime-picker [(ngModel)]=\"fromDateISOString\" [maxDate]=\"toDateISOString\" (ngModelChange)=\"setDatetimeRange()\"></nwf-datetime-picker>\n                </div>\n                <div class=\"p-2 d-flex flex-column\" (click)=\"$event.stopPropagation()\" data-netapp-id=\"datetime-to-picker\">\n                    To:\n                    <nwf-datetime-picker [(ngModel)]=\"toDateISOString\" [minDate]=\"fromDateISOString\" (ngModelChange)=\"setDatetimeRange()\"></nwf-datetime-picker>\n                </div>\n            </div>\n        </ng-template>\n        <button type=\"button\" class=\"btn btn-default datetimepicker-button form-control\" [ngbPopover]=\"datetimerangePickerTemplate\" placement=\"bottom-right\"\n        data-netapp-id=\"filter-widget-btn\">\n            <nwf-icon iconClass=\"icon-action-calendar\"></nwf-icon>\n            <span class=\"datetimepicker-value\" data-netapp-id=\"dateTimePicker-widget-label\">\n                {{ fromDate | i18nextFormat: { format: 'datetime' } }} to {{ toDate | i18nextFormat: { format: 'datetime' } }}\n            </span>\n        </button>\n    ",
                        providers: [{
                                provide: forms.NG_VALUE_ACCESSOR,
                                useExisting: NwfDatetimeRangePicker,
                                multi: true,
                            }],
                        styles: [".datetimepicker-button{width:190px;height:50px!important;display:flex}.datetimepicker-value{white-space:normal;text-align:initial;width:170px;margin:0}"]
                    }] }
        ];
        /** @nocollapse */
        NwfDatetimeRangePicker.ctorParameters = function () { return []; };
        return NwfDatetimeRangePicker;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    /**
     * This service is for observing column changes of the dxdatagrid through the onColumnsChanging event.
     *
     * Example:
     * onInitialized: (e) => {
     *     e.component.option("onColumnsChanging", (e) => {
     *         this.columnsChangingService.onColumnsChanging(e);
     *     });
     * }
     */
    var NwfColumnsChangingService = /** @class */ (function () {
        function NwfColumnsChangingService() {
            this.columnsChanging = new rxjs.Subject();
            this.columnsChanging$ = this.columnsChanging.asObservable().pipe(operators.debounceTime(10), operators.share());
        }
        /**
         * @param {?} event
         * @return {?}
         */
        NwfColumnsChangingService.prototype.onColumnsChanging = /**
         * @param {?} event
         * @return {?}
         */
            function (event) {
                this.columnsChanging.next(event);
            };
        NwfColumnsChangingService.decorators = [
            { type: i0.Injectable }
        ];
        return NwfColumnsChangingService;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var NwfElipsizerResizeService = /** @class */ (function () {
        function NwfElipsizerResizeService(columnsChangingService) {
            this.columnsChangingService = columnsChangingService;
            this.resizeEvent = new rxjs.Subject();
            this.resizeEvent$ = this.resizeEvent.asObservable().pipe(operators.share());
            this.columnsChangingService.columnsChanging$.subscribe(this.resizeEvent);
        }
        /**
         * @return {?}
         */
        NwfElipsizerResizeService.prototype.resize = /**
         * @return {?}
         */
            function () {
                this.resizeEvent.next();
            };
        NwfElipsizerResizeService.decorators = [
            { type: i0.Injectable }
        ];
        /** @nocollapse */
        NwfElipsizerResizeService.ctorParameters = function () {
            return [
                { type: NwfColumnsChangingService }
            ];
        };
        return NwfElipsizerResizeService;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var NwfElipsizer = /** @class */ (function () {
        function NwfElipsizer(el, renderer, elipsizerResizeService) {
            this.el = el;
            this.renderer = renderer;
            this.elipsizerResizeService = elipsizerResizeService;
            this.destroy = new rxjs.Subject();
        }
        /**
         * @param {?} event
         * @return {?}
         */
        NwfElipsizer.prototype.windowResize = /**
         * @param {?} event
         * @return {?}
         */
            function (event) {
                this.elipsize(false);
            };
        /**
         * @return {?}
         */
        NwfElipsizer.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                var _this = this;
                // subscribe to service to get resize calls
                this.elipsizerResizeService.resizeEvent$.pipe(operators.takeUntil(this.destroy)).subscribe(( /**
                 * @return {?}
                 */function () {
                    _this.elipsize(false);
                }));
            };
        /**
         * @return {?}
         */
        NwfElipsizer.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                // Complete subject
                this.destroy.next();
                this.destroy.complete();
            };
        /**
         * @param {?} changes
         * @return {?}
         */
        NwfElipsizer.prototype.ngOnChanges = /**
         * @param {?} changes
         * @return {?}
         */
            function (changes) {
                this.elipsize(true);
            };
        // Elipsize text by creating a dom element off screen, measuring it and removing text character by character.
        // ignoreSizeCheck - ignores the optimization that checkes for element size change and doesnt update the elipsized text if the size hasn't changed.
        // Elipsize text by creating a dom element off screen, measuring it and removing text character by character.
        // ignoreSizeCheck - ignores the optimization that checkes for element size change and doesnt update the elipsized text if the size hasn't changed.
        /**
         * @param {?} ignoreSizeCheck
         * @return {?}
         */
        NwfElipsizer.prototype.elipsize =
            // Elipsize text by creating a dom element off screen, measuring it and removing text character by character.
            // ignoreSizeCheck - ignores the optimization that checkes for element size change and doesnt update the elipsized text if the size hasn't changed.
            /**
             * @param {?} ignoreSizeCheck
             * @return {?}
             */
            function (ignoreSizeCheck) {
                /** @type {?} */
                var parentNode = this.renderer.parentNode(this.el.nativeElement);
                /** @type {?} */
                var computedStyle = window.getComputedStyle(parentNode);
                /** @type {?} */
                var myLeftPad = parseInt(computedStyle.getPropertyValue('padding-left'));
                /** @type {?} */
                var myRightPad = parseInt(computedStyle.getPropertyValue('padding-right'));
                /** @type {?} */
                var theBiggestICanBe = parentNode.offsetWidth - myLeftPad - myRightPad;
                if (theBiggestICanBe !== 0 && (ignoreSizeCheck || this.currentSizeOfElement !== theBiggestICanBe)) {
                    this.currentSizeOfElement = theBiggestICanBe;
                    // Create element off screen
                    /** @type {?} */
                    var textElement = this.renderer.createText(this.originalText);
                    /** @type {?} */
                    var tempElement = this.renderer.createElement(this.el.nativeElement.tagName.toLowerCase());
                    this.renderer.appendChild(tempElement, textElement);
                    this.renderer.setStyle(tempElement, 'width', 'auto');
                    this.renderer.setStyle(tempElement, 'white-space', 'nowrap');
                    this.renderer.setStyle(tempElement, 'overflow', 'visible');
                    this.renderer.setStyle(tempElement, 'position', 'absolute');
                    this.renderer.setStyle(tempElement, 'left', '-10000px');
                    // this.renderer.appendChild(document.body, tempElement);
                    this.renderer.appendChild(parentNode, tempElement);
                    // Loop of length of text removing one character at a time until its the proper size
                    /** @type {?} */
                    var finalName = this.originalText;
                    // Total length of string
                    /** @type {?} */
                    var index = textElement.textContent.length;
                    /** @type {?} */
                    var start = 0;
                    /** @type {?} */
                    var end = index;
                    if (tempElement.offsetWidth > theBiggestICanBe) {
                        while (end - start > 1) {
                            /** @type {?} */
                            var size = Math.round((start + end) / 2.0);
                            /** @type {?} */
                            var half = Math.round(size / 2.0);
                            finalName = this.originalText.slice(0, half) + String.fromCharCode(8230) + this.originalText.slice(index - half);
                            textElement.textContent = finalName;
                            if (tempElement.offsetWidth > theBiggestICanBe) {
                                end = size;
                            }
                            else {
                                start = size;
                            }
                        }
                    }
                    // Set final elipsized text
                    this.el.nativeElement.innerText = finalName;
                    // console.log('Final text', finalName);
                    // Remove element created of screen
                    // this.renderer.removeChild(document.body, tempElement);
                    this.renderer.removeChild(parentNode, tempElement);
                }
            };
        NwfElipsizer.decorators = [
            { type: i0.Directive, args: [{
                        selector: '[nwfElipsizer]',
                        host: {
                            '[style.white-space]': '"nowrap"',
                            '[style.display]': '"inline-block"',
                        },
                    },] }
        ];
        /** @nocollapse */
        NwfElipsizer.ctorParameters = function () {
            return [
                { type: i0.ElementRef },
                { type: i0.Renderer2 },
                { type: NwfElipsizerResizeService }
            ];
        };
        NwfElipsizer.propDecorators = {
            originalText: [{ type: i0.Input, args: ['nwfElipsizer',] }],
            windowResize: [{ type: i0.HostListener, args: ['window:resize', ['$event'],] }]
        };
        return NwfElipsizer;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var NwfLeftnavService = /** @class */ (function () {
        function NwfLeftnavService() {
            this.navData = [];
            this.leftnavIsCollapsed = false;
            this.leftNav = new rxjs.Subject();
            this.leftNav$ = this.leftNav.asObservable();
        }
        /**
         * @return {?}
         */
        NwfLeftnavService.prototype.toggle = /**
         * @return {?}
         */
            function () {
                this.leftnavIsCollapsed = !this.leftnavIsCollapsed;
                this.leftNav.next(this.leftnavIsCollapsed);
            };
        /* This is used in the feature tour */
        /* This is used in the feature tour */
        /**
         * @param {?} callback
         * @return {?}
         */
        NwfLeftnavService.prototype.recurseNavData = /* This is used in the feature tour */
            /**
             * @param {?} callback
             * @return {?}
             */
            function (callback) {
                var e_1, _a;
                /**
                 * @param {?} currentNode
                 * @return {?}
                 */
                function recurse(currentNode) {
                    var e_2, _a;
                    if (currentNode.children) {
                        try {
                            for (var _b = __values(currentNode.children), _c = _b.next(); !_c.done; _c = _b.next()) {
                                var child = _c.value;
                                recurse(child);
                            }
                        }
                        catch (e_2_1) {
                            e_2 = { error: e_2_1 };
                        }
                        finally {
                            try {
                                if (_c && !_c.done && (_a = _b.return))
                                    _a.call(_b);
                            }
                            finally {
                                if (e_2)
                                    throw e_2.error;
                            }
                        }
                        callback(currentNode);
                    }
                }
                try {
                    for (var _b = __values(this.navData), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var data = _c.value;
                        recurse(data);
                    }
                }
                catch (e_1_1) {
                    e_1 = { error: e_1_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_1)
                            throw e_1.error;
                    }
                }
            };
        NwfLeftnavService.decorators = [
            { type: i0.Injectable, args: [{
                        providedIn: 'root',
                    },] }
        ];
        /** @nocollapse */
        NwfLeftnavService.ctorParameters = function () { return []; };
        /** @nocollapse */ NwfLeftnavService.ngInjectableDef = i0.defineInjectable({ factory: function NwfLeftnavService_Factory() { return new NwfLeftnavService(); }, token: NwfLeftnavService, providedIn: "root" });
        return NwfLeftnavService;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var NwfFeatureTourService = /** @class */ (function () {
        function NwfFeatureTourService(leftnavService) {
            this.leftnavService = leftnavService;
            this.tours = {};
        }
        /**
         * @param {?} group
         * @param {?} pop
         * @param {?=} slf
         * @return {?}
         */
        NwfFeatureTourService.prototype.registerTour = /**
         * @param {?} group
         * @param {?} pop
         * @param {?=} slf
         * @return {?}
         */
            function (group, pop, slf) {
                var _this = this;
                var _a = __read(group.split('-'), 2), groupName = _a[0], order = _a[1];
                /** @type {?} */
                var orderInt = parseInt(order);
                if (!orderInt) {
                    /** @type {?} */
                    var tourGroup = this.tours[groupName];
                    orderInt = tourGroup && tourGroup.length ? tourGroup.length : 0;
                }
                this.addTourToGroup(groupName, orderInt, pop, slf);
                pop.hidden.subscribe(( /**
                 * @return {?}
                 */function () {
                    /** @type {?} */
                    var thisGroup = _this.tours[groupName];
                    /** @type {?} */
                    var nextInd;
                    for (var i = 0; i < thisGroup.length; i++) {
                        if (pop == thisGroup[i].pop) {
                            nextInd = i + 1;
                            break;
                        }
                    }
                    /** @type {?} */
                    var nextTour = thisGroup[nextInd];
                    if (nextTour) {
                        nextTour.pop.open();
                    }
                }));
            };
        /**
         * @param {?} group
         * @return {?}
         */
        NwfFeatureTourService.prototype.startTour = /**
         * @param {?} group
         * @return {?}
         */
            function (group) {
                var _a = __read(this.tours[group], 1), nextTour = _a[0];
                if (nextTour && nextTour.self) {
                    this.leftnavService.recurseNavData(( /**
                     * @param {?} node
                     * @return {?}
                     */function (node) {
                        if (node.children.indexOf(nextTour.self) !== -1) {
                            node.isCollapsed = false;
                        }
                    }));
                }
                nextTour.pop.open();
            };
        /**
         * @private
         * @param {?} group
         * @param {?} order
         * @param {?} pop
         * @param {?} slf
         * @return {?}
         */
        NwfFeatureTourService.prototype.addTourToGroup = /**
         * @private
         * @param {?} group
         * @param {?} order
         * @param {?} pop
         * @param {?} slf
         * @return {?}
         */
            function (group, order, pop, slf) {
                if (!this.tours[group]) {
                    this.tours[group] = [];
                }
                this.tours[group].splice(order, 1, { pop: pop, self: slf });
            };
        NwfFeatureTourService.decorators = [
            { type: i0.Injectable, args: [{
                        providedIn: 'root',
                    },] }
        ];
        /** @nocollapse */
        NwfFeatureTourService.ctorParameters = function () {
            return [
                { type: NwfLeftnavService }
            ];
        };
        /** @nocollapse */ NwfFeatureTourService.ngInjectableDef = i0.defineInjectable({ factory: function NwfFeatureTourService_Factory() { return new NwfFeatureTourService(i0.inject(NwfLeftnavService)); }, token: NwfFeatureTourService, providedIn: "root" });
        return NwfFeatureTourService;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var NwfFeatureTourDirective = /** @class */ (function () {
        function NwfFeatureTourDirective(featureTourService, self) {
            this.featureTourService = featureTourService;
            this.self = self;
            this.tourIsShowing = new i0.EventEmitter();
        }
        /**
         * @return {?}
         */
        NwfFeatureTourDirective.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                if (this.nwfFeatureTour) {
                    this.featureTourService.registerTour(this.nwfFeatureTour, this.myPop, this.item);
                }
            };
        NwfFeatureTourDirective.decorators = [
            { type: i0.Component, args: [{
                        selector: '[nwfFeatureTour]',
                        template: "\n  <ng-content></ng-content>\n  <ng-template #popContent><ng-container *ngComponentOutlet=\"component\"></ng-container>\n  <div class=\"d-flex justify-content-end\">\n  <button class=\"btn btn-primary\" (click)=\"p1.close()\">{{ 'nwfjs:close' | i18next }}</button>\n  </div>\n  </ng-template>\n  <div #p1=\"ngbPopover\" [ngbPopover]=\"popContent\" placement=\"right\"></div>\n  ",
                        styles: [":host { display: inline-block }"]
                    }] }
        ];
        /** @nocollapse */
        NwfFeatureTourDirective.ctorParameters = function () {
            return [
                { type: NwfFeatureTourService },
                { type: i0.ElementRef }
            ];
        };
        NwfFeatureTourDirective.propDecorators = {
            myPop: [{ type: i0.ViewChild, args: [ngBootstrap.NgbPopover,] }],
            p1: [{ type: i0.ViewChild, args: ['p1',] }],
            item: [{ type: i0.Input }, { type: i0.Optional }],
            nwfFeatureTour: [{ type: i0.Input }],
            component: [{ type: i0.Input }],
            tourIsShowing: [{ type: i0.Output }]
        };
        return NwfFeatureTourDirective;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var NwfHelpConfig = /** @class */ (function () {
        function NwfHelpConfig() {
            this.helpBasePath = '/OnCommand/help/netapp';
            this.helpContext = '';
        }
        NwfHelpConfig.decorators = [
            { type: i0.Injectable, args: [{ providedIn: 'root' },] }
        ];
        /** @nocollapse */
        NwfHelpConfig.ctorParameters = function () { return []; };
        /** @nocollapse */ NwfHelpConfig.ngInjectableDef = i0.defineInjectable({ factory: function NwfHelpConfig_Factory() { return new NwfHelpConfig(); }, token: NwfHelpConfig, providedIn: "root" });
        return NwfHelpConfig;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var HelpService = /** @class */ (function () {
        function HelpService(config) {
            this.config = config;
            /** @type {?} */
            var basePath = this.config.helpBasePath;
            /** @type {?} */
            var context = this.config.helpContext;
            //  Beginning of Webworks help API
            /** @type {?} */
            var WWHAPI_Object = ( /**
             * @param {?} ParamHelpURL
             * @param {?} ParamTargetWindow
             * @return {?}
             */function (ParamHelpURL, ParamTargetWindow) {
                // Location of the WebWorks Help system to be launched.
                // Location should be an absolute URL.
                //
                this.mAPIURL = ParamHelpURL + '/wwhelp/wwhimpl/api.htm';
                this.mWindow = null;
                this.mTargetWindow = ParamTargetWindow;
                this.fLaunchHelp = WWHAPI_LaunchHelp;
                this.fCloseHelp = WWHAPI_CloseHelp;
                this.fDisplayHelp = WWHAPI_DisplayHelp;
                this.fDisplayHelpWithNavigation = WWHAPI_DisplayHelpWithNavigation;
                this.fDisplayHelpWithContents = WWHAPI_DisplayHelpWithContents;
                this.fDisplayHelpWithIndex = WWHAPI_DisplayHelpWithIndex;
                this.fDisplayHelpWithSearch = WWHAPI_DisplayHelpWithSearch;
                this.fDisplayHelpWithFavorites = WWHAPI_DisplayHelpWithFavorites;
                this.fDisplayHelpNavigation = WWHAPI_DisplayHelpNavigation;
                this.fDisplayHelpContents = WWHAPI_DisplayHelpContents;
                this.fDisplayHelpIndex = WWHAPI_DisplayHelpIndex;
                this.fDisplayHelpSearch = WWHAPI_DisplayHelpSearch;
                this.fDisplayHelpFavorites = WWHAPI_DisplayHelpFavorites;
            });
            /**
             * @param {?} bParamSingle
             * @param {?} ParamContext
             * @param {?} ParamTopic
             * @param {?} ParamTab
             * @return {?}
             */
            function WWHAPI_LaunchHelp(bParamSingle, ParamContext, ParamTopic, ParamTab) {
                /** @type {?} */
                var VarParameters;
                /** @type {?} */
                var VarURL;
                /** @type {?} */
                var VarIndex;
                /** @type {?} */
                var VarMaxIndex;
                // Define parameters
                //
                VarParameters = new Array();
                if (bParamSingle) {
                    VarParameters[VarParameters.length] = 'single=true';
                }
                if (ParamContext != null) {
                    VarParameters[VarParameters.length] = 'context=' + ParamContext;
                    // Use the global configuration for the help context if one exists
                }
                else if (context != null) {
                    VarParameters[VarParameters.length] = 'context=' + context;
                }
                if (ParamTopic != null) {
                    VarParameters[VarParameters.length] = 'topic=' + ParamTopic;
                }
                if (ParamTab) {
                    VarParameters[VarParameters.length] = 'tab=' + ParamTab;
                }
                // Create URL
                //
                VarURL = this.mAPIURL;
                for (VarIndex = 0, VarMaxIndex = VarParameters.length; VarIndex < VarMaxIndex; VarIndex++) {
                    if (VarIndex == 0) {
                        VarURL += '?' + VarParameters[VarIndex];
                    }
                    else {
                        VarURL += '&' + VarParameters[VarIndex];
                    }
                }
                // Check to see if the window exists.  If it does, make the native call directly.
                // Otherwise, initialize the help system at the topic using URL params.
                //
                if ((this.mWindow != null) &&
                    (typeof (this.mWindow) != 'undefined') &&
                    (!this.mWindow.closed) &&
                    (this.mWindow.WWHHelp != null) &&
                    (typeof (this.mWindow.WWHHelp) != 'undefined')) {
                    this.mWindow.focus();
                    this.mWindow.WWHHelp.fSetContextDocument(VarURL);
                }
                else {
                    /* Customized this for our needs ! */
                    /** @type {?} */
                    var netappDesiredWidthAndHeight = 'height=768, width=1024';
                    if ((typeof (this.mTargetWindow) != 'undefined') &&
                        (this.mTargetWindow != null)) {
                        this.mWindow = window.open(VarURL, this.mTargetWindow, netappDesiredWidthAndHeight);
                    }
                    else {
                        this.mWindow = window.open(VarURL, null, netappDesiredWidthAndHeight);
                    }
                    // Ensure window is brought to the foreground
                    //
                    this.mWindow.focus();
                }
            }
            /**
             * @return {?}
             */
            function WWHAPI_CloseHelp() {
                if ((this.mWindow != null) &&
                    (typeof (this.mWindow) != 'undefined') &&
                    (!this.mWindow.closed) &&
                    (this.mWindow.WWHHelp != null) &&
                    (typeof (this.mWindow.WWHHelp) != 'undefined')) {
                    this.mWindow.close();
                }
            }
            /**
             * @param {?} ParamContext
             * @param {?} ParamTopic
             * @return {?}
             */
            function WWHAPI_DisplayHelp(ParamContext, ParamTopic) {
                this.fLaunchHelp(true, ParamContext, ParamTopic, null);
            }
            /**
             * @param {?} ParamContext
             * @param {?} ParamTopic
             * @return {?}
             */
            function WWHAPI_DisplayHelpWithNavigation(ParamContext, ParamTopic) {
                this.fLaunchHelp(false, ParamContext, ParamTopic, null);
            }
            /**
             * @param {?} ParamContext
             * @param {?} ParamTopic
             * @return {?}
             */
            function WWHAPI_DisplayHelpWithContents(ParamContext, ParamTopic) {
                this.fLaunchHelp(false, ParamContext, ParamTopic, 'contents');
            }
            /**
             * @param {?} ParamContext
             * @param {?} ParamTopic
             * @return {?}
             */
            function WWHAPI_DisplayHelpWithIndex(ParamContext, ParamTopic) {
                this.fLaunchHelp(false, ParamContext, ParamTopic, 'index');
            }
            /**
             * @param {?} ParamContext
             * @param {?} ParamTopic
             * @return {?}
             */
            function WWHAPI_DisplayHelpWithSearch(ParamContext, ParamTopic) {
                this.fLaunchHelp(false, ParamContext, ParamTopic, 'search');
            }
            /**
             * @param {?} ParamContext
             * @param {?} ParamTopic
             * @return {?}
             */
            function WWHAPI_DisplayHelpWithFavorites(ParamContext, ParamTopic) {
                this.fLaunchHelp(false, ParamContext, ParamTopic, 'favorites');
            }
            /**
             * @return {?}
             */
            function WWHAPI_DisplayHelpNavigation() {
                this.fLaunchHelp(false, null, null, null);
            }
            /**
             * @return {?}
             */
            function WWHAPI_DisplayHelpContents() {
                this.fLaunchHelp(false, null, null, 'contents');
            }
            /**
             * @return {?}
             */
            function WWHAPI_DisplayHelpIndex() {
                this.fLaunchHelp(false, null, null, 'index');
            }
            /**
             * @return {?}
             */
            function WWHAPI_DisplayHelpSearch() {
                this.fLaunchHelp(false, null, null, 'search');
            }
            /**
             * @return {?}
             */
            function WWHAPI_DisplayHelpFavorites() {
                this.fLaunchHelp(false, null, null, 'favorites');
            }
            // End of Webworks help API
            /* Now create me , we should not have two things, but one to configure. Fix later. */
            this.helpDirectiveWindow = new WWHAPI_Object(basePath + context, 'help_window');
        }
        HelpService.decorators = [
            { type: i0.Injectable }
        ];
        /** @nocollapse */
        HelpService.ctorParameters = function () {
            return [
                { type: NwfHelpConfig }
            ];
        };
        return HelpService;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var HelpDirective = /** @class */ (function () {
        function HelpDirective(element, helpService) {
            this.element = element;
            this.helpService = helpService;
        }
        /**
         * @return {?}
         */
        HelpDirective.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                /** @type {?} */
                var showIcon = this.showIcon == 'false' ? false : true;
                if (showIcon) {
                    /** @type {?} */
                    var icon = "\n\n<svg width=\"18px\" height=\"18px\" viewBox=\"0 0 18 18\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">\n    <g id=\"icon-info-help\" stroke=\"none\" stroke-width=\"1\" fill=\"none\" fill-rule=\"evenodd\">\n        <path d=\"M9,1 C4.6,1 1,4.6 1,9 C1,13.4 4.6,17 9,17 C13.4,17 17,13.4 17,9 C17,4.6 13.4,1 9,1 Z\" id=\"base-layer\" fill=\"#0067C5\"></path>\n        <path d=\"M9,2.75 C5.5625,2.75 2.75,5.5625 2.75,9 C2.75,12.4375 5.5625,15.25 9,15.25 C12.4375,15.25 15.25,12.4375 15.25,9 C15.25,5.5625 12.4375,2.75 9,2.75 Z\" id=\"background\" fill=\"#FFFFFF\"></path>\n        <path d=\"M8.204,12.375 L9.946,12.375 L9.946,14 L8.204,14 L8.204,12.375 Z M6.137,7.669 C6.137,7.19233095 6.20849928,6.75900195 6.3515,6.369 C6.49450071,5.97899805 6.70249864,5.64533472 6.9755,5.368 C7.24850137,5.09066528 7.57783141,4.87616743 7.9635,4.7245 C8.3491686,4.57283258 8.78033095,4.497 9.257,4.497 C9.65566866,4.497 10.026165,4.55549941 10.3685,4.6725 C10.710835,4.78950058 11.0098321,4.95849889 11.2655,5.1795 C11.5211679,5.4005011 11.7226659,5.67566502 11.87,6.005 C12.0173341,6.33433498 12.091,6.70699792 12.091,7.123 C12.091,7.42633485 12.0585003,7.6884989 11.9935,7.9095 C11.9284997,8.13050111 11.8418339,8.32116587 11.7335,8.4815 C11.6251661,8.64183414 11.5016674,8.7848327 11.363,8.9105 C11.2243326,9.0361673 11.0856674,9.15966606 10.947,9.281 C10.7823325,9.41966736 10.6306674,9.55399935 10.492,9.684 C10.3533326,9.81400065 10.2320005,9.95916586 10.128,10.1195 C10.0239995,10.2798341 9.94383361,10.4683323 9.8875,10.685 C9.83116638,10.9016678 9.803,11.1659984 9.803,11.478 L8.399,11.478 C8.399,11.0966648 8.41849981,10.7738347 8.4575,10.5095 C8.4965002,10.2451653 8.5593329,10.0133343 8.646,9.814 C8.7326671,9.61466567 8.8388327,9.43916742 8.9645,9.2875 C9.0901673,9.13583257 9.2396658,8.98633407 9.413,8.839 C9.55166736,8.71766606 9.6838327,8.60500052 9.8095,8.501 C9.9351673,8.39699948 10.0478328,8.28216729 10.1475,8.1565 C10.2471672,8.0308327 10.3251664,7.89000078 10.3815,7.734 C10.4378336,7.57799922 10.466,7.39166775 10.466,7.175 C10.466,6.9149987 10.4205005,6.69183427 10.3295,6.5055 C10.2384995,6.31916574 10.1280006,6.16966723 9.998,6.057 C9.86799935,5.94433277 9.72933407,5.86200026 9.582,5.81 C9.43466593,5.75799974 9.30466723,5.732 9.192,5.732 C8.65466398,5.732 8.25816794,5.90749824 8.0025,6.2585 C7.74683205,6.60950175 7.619,7.07966372 7.619,7.669 L6.137,7.669 Z\" id=\"glyph\" fill=\"#0067C5\"></path>\n    </g>\n</svg>\n  ";
                    this.element.nativeElement.innerHTML += icon;
                }
            };
        /**
         * @param {?} element
         * @return {?}
         */
        HelpDirective.prototype.onClick = /**
         * @param {?} element
         * @return {?}
         */
            function (element) {
                // element.setAttribute('launchUrl', baseContextId);
                if (typeof (this.guid) != 'undefined' && typeof (this.context) != 'undefined') {
                    // Launch context sesitive help topic.
                    this.helpService.helpDirectiveWindow.fDisplayHelpWithContents(this.context, this.guid);
                }
                else if (typeof (this.guid) != 'undefined') {
                    this.helpService.helpDirectiveWindow.fDisplayHelpWithNavigation(null, this.guid);
                }
                else {
                    this.helpService.helpDirectiveWindow.fDisplayHelpContents();
                }
            };
        HelpDirective.decorators = [
            { type: i0.Directive, args: [{
                        selector: '[nwf-help],nwf-help',
                        host: {
                            '(click)': 'onClick($event.target)',
                        },
                        inputs: ['guid', 'context', 'showIcon'],
                        providers: [HelpService],
                    },] }
        ];
        /** @nocollapse */
        HelpDirective.ctorParameters = function () {
            return [
                { type: i0.ElementRef },
                { type: HelpService }
            ];
        };
        return HelpDirective;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var HorizontalBarChartComponent = /** @class */ (function () {
        function HorizontalBarChartComponent(i18next, leftNavService, columnsChangingService) {
            this.i18next = i18next;
            this.leftNavService = leftNavService;
            this.columnsChangingService = columnsChangingService;
            this.totalValue = 100; // This bar can represent a value out of any totalValue given
            // This bar can represent a value out of any totalValue given
            this.seriesName = 'Value';
            this.showTooltip = true;
            // @Input() width = 300;
            this.height = 20;
            // Enables color zones for soft/hard limits values given
            this.zones = false;
            // Enables y-axis labels for bar chart to show range info like 25%, 50%, 100%
            this.axisLabels = false;
            this.axisUnit = '';
            this.legendsEnabled = false;
            this.plotLinesConfig = [];
            this.destroy = new rxjs.Subject();
            this.isUndefined = lodashEs.isUndefined;
        }
        /**
         * @return {?}
         */
        HorizontalBarChartComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                var _this = this;
                var e_1, _a;
                // If soft,hard limits are passed, we show plot lines on the bar chart accordingly
                if (this.softLimit) {
                    this.plotLinesConfig.push({
                        value: this.softLimit,
                        width: 2,
                        zIndex: 5,
                        className: 'nwf-soft-limit',
                    });
                }
                if (this.hardLimit) {
                    this.plotLinesConfig.push({
                        value: this.hardLimit,
                        width: 2,
                        zIndex: 5,
                        className: 'nwf-hard-limit',
                    });
                }
                // If 'zones' is true, we set default, soft & hard limit zones
                if (this.zones && this.softLimit && this.hardLimit) {
                    this.zonesConfig = [
                        {
                            value: this.softLimit >= this.currentValue ? this.softLimit - 1 : 0,
                            className: 'nwf-default-zone',
                        },
                        {
                            value: this.hardLimit,
                            className: 'nwf-soft-limit-zone',
                        }, {
                            className: 'nwf-hard-limit-zone',
                        },
                    ];
                }
                // Calculate chart height
                // when axis labels are shown, chart requires additional height i.e. +21 to current value:20
                if (this.axisLabels) {
                    this.height += 21;
                }
                if (this.legendsEnabled) {
                    this.height += 40;
                }
                // We allow only one bar for now with seriesData
                if (this.seriesData) {
                    try {
                        for (var _b = __values(this.seriesData), _c = _b.next(); !_c.done; _c = _b.next()) {
                            var series = _c.value;
                            series.pointPadding = 0;
                            series.groupPadding = 0;
                        }
                    }
                    catch (e_1_1) {
                        e_1 = { error: e_1_1 };
                    }
                    finally {
                        try {
                            if (_c && !_c.done && (_a = _b.return))
                                _a.call(_b);
                        }
                        finally {
                            if (e_1)
                                throw e_1.error;
                        }
                    }
                }
                this.chart = new angularHighcharts.Chart({
                    chart: {
                        type: 'bar',
                        height: this.height,
                        // width: this.width,
                        spacing: [0, 0, 0, 0],
                        styledMode: true,
                    },
                    tooltip: {
                        outside: true,
                        enabled: this.showTooltip,
                        useHTML: true,
                        formatter: /**
                         * @return {?}
                         */ function () {
                            /** @type {?} */
                            var templateData = {
                                seriesName: this.series.name,
                                tooltipCurrentValue: this.point['tooltipCurrentValue'],
                                tooltipSoftLimitValue: this.point['tooltipSoftLimitValue'],
                                tooltipHardLimitValue: this.point['tooltipHardLimitValue'],
                                softLimit: this.point['i18nRef'] ? this.point['i18nRef'].transform('nwfjs:softLimit') : '',
                                hardLimit: this.point['i18nRef'] ? this.point['i18nRef'].transform('nwfjs:hardLimit') : '',
                                exceedsHardLimit: this.point['i18nRef'] ? this.point['i18nRef'].transform('nwfjs:exceedsHardLimit') : '',
                                exceedsSoftLimit: this.point['i18nRef'] ? this.point['i18nRef'].transform('nwfjs:exceedsSoftLimit') : '',
                            };
                            /** @type {?} */
                            var tooltipBody = '<span class="tooltip-current-series">\u25CF </span>${seriesName}: ${tooltipCurrentValue}';
                            if (this.point['softLimit'] || this.point['hardLimit']) {
                                // If limits exceeded, show an additional header message about the breach
                                if (this.point.y >= this.point['hardLimit']) {
                                    tooltipBody = '${seriesName} ${exceedsHardLimit}<br\>' + tooltipBody;
                                }
                                else if (this.point.y >= this.point['softLimit']) {
                                    tooltipBody = '${seriesName} ${exceedsSoftLimit}<br\>' + tooltipBody;
                                }
                                // Appends Soft Limit, Hard Limit values to the tooltip
                                tooltipBody += '<br><span class="tooltip-soft-limit-series">\u25CF </span>${softLimit}: ${tooltipSoftLimitValue}';
                                tooltipBody += '<br><span class="tooltip-hard-limit-series">\u25CF </span>${hardLimit}: ${tooltipHardLimitValue}';
                            }
                            /** @type {?} */
                            var tooltip = lodashEs.template("<div class=\"nwf-highcharts-tooltip popover bs-popover-right\">\n                    <div class=\"arrow\"></div>\n                    <div class=\"popover-body\">" + tooltipBody + "</div>\n                    </div>\n                    ");
                            return tooltip(templateData);
                        },
                    },
                    title: {
                        text: '',
                    },
                    subtitle: {
                        text: '',
                    },
                    xAxis: {
                        gridLineColor: 'transparent',
                        visible: false,
                        title: {
                            text: null,
                        },
                        labels: {
                            enabled: false,
                        },
                    },
                    yAxis: {
                        max: this.totalValue,
                        endOnTick: false,
                        visible: true,
                        title: {
                            text: null,
                        },
                        labels: {
                            enabled: this.axisLabels,
                            format: '{value}' + this.axisUnit,
                            style: {
                                textOverflow: 'none',
                            },
                        },
                        plotLines: !this.zones ? this.plotLinesConfig : undefined,
                    },
                    plotOptions: {
                        bar: {
                            dataLabels: {
                                enabled: false,
                            },
                        },
                        series: {
                            zones: this.zonesConfig,
                            stacking: this.seriesData ? 'normal' : undefined,
                        },
                    },
                    legend: {
                        enabled: this.legendsEnabled,
                    },
                    credits: {
                        enabled: false,
                    },
                    series: this.seriesData ? this.seriesData : [( /** @type {?} */({
                            pointPadding: 0,
                            groupPadding: 0,
                            animation: false,
                            name: this.seriesName,
                            data: [{
                                    y: this.currentValue,
                                    softLimit: this.softLimit,
                                    hardLimit: this.hardLimit,
                                    // If we need to show custom strings in the tooltip, we use below values
                                    tooltipSoftLimitValue: this.tooltipSoftLimitValue ? this.tooltipSoftLimitValue : this.softLimit,
                                    tooltipHardLimitValue: this.tooltipHardLimitValue ? this.tooltipHardLimitValue : this.hardLimit,
                                    tooltipCurrentValue: this.tooltipCurrentValue ? this.tooltipCurrentValue : this.currentValue,
                                    i18nRef: this.i18next,
                                }],
                        }))],
                });
                rxjs.merge(this.leftNavService.leftNav$, this.columnsChangingService.columnsChanging$)
                    .pipe(operators.takeUntil(this.destroy), operators.delay(10))
                    .subscribe(( /**
             * @return {?}
             */function () {
                    _this.chart.ref.reflow();
                }));
            };
        /**
         * @return {?}
         */
        HorizontalBarChartComponent.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                // Signal end of subscription to observables
                this.destroy.next();
                this.destroy.complete();
            };
        HorizontalBarChartComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-horizontal-bar-chart',
                        template: "<div class=\"row no-gutters\">\n\n    <div class=\"col align-middle\" [chart]=\"chart\" [ngClass]=\"{ 'pr-1 col-lg-7 col-sm-12' : !isUndefined(labelPrimary) || !isUndefined(labelSecondary)}\">\n    </div>\n\n    <div class=\"col-lg-5 col-sm-12 d-flex flex-row align-items-center flex-wrap\"\n        *ngIf=\"!isUndefined(labelPrimary) || !isUndefined(labelSecondary)\">\n\n        <div class=\"inline-label pr-1\" [ngClass]=\"{ 'border-right-custom': !isUndefined(labelSecondary)}\"\n            *ngIf=\"!isUndefined(labelPrimary)\">\n            {{labelPrimary}}\n        </div>\n        <div class=\"px-1 inline-label\" *ngIf=\"!isUndefined(labelSecondary)\">\n            {{ labelSecondary}}\n        </div>\n\n    </div>\n</div>",
                        styles: ["::ng-deep .tooltip-current-series{color:#61dce8}::ng-deep .tooltip-soft-limit-series{color:#f88402}::ng-deep .tooltip-hard-limit-series{color:#da1e21}:host ::ng-deep .highcharts-background{fill:none}:host ::ng-deep .highcharts-plot-background{fill:#d7d7d7}:host ::ng-deep .highcharts-plot-line.nwf-soft-limit{stroke:#f88402;stroke-width:2px}:host ::ng-deep .highcharts-plot-line.nwf-hard-limit{stroke:#da1e21;stroke-width:2px}:host ::ng-deep .highcharts-point.nwf-default-zone{fill:#61dce8;stroke:#61dce8}:host ::ng-deep .highcharts-point.nwf-soft-limit-zone{fill:#f88402;stroke:#f88402}:host ::ng-deep .highcharts-point.nwf-hard-limit-zone{fill:#da1e21;stroke:#da1e21}:host ::ng-deep .highcharts-grid-line{stroke:transparent}:host ::ng-deep .highcharts-container{width:100%!important}:host ::ng-deep .highcharts-container>svg:first-child{width:100%!important}:host .inline-label{font-size:12px;font-weight:600}:host .border-right-custom{border-right:1px solid #000}"]
                    }] }
        ];
        /** @nocollapse */
        HorizontalBarChartComponent.ctorParameters = function () {
            return [
                { type: i1.I18NextPipe },
                { type: NwfLeftnavService },
                { type: NwfColumnsChangingService }
            ];
        };
        HorizontalBarChartComponent.propDecorators = {
            currentValue: [{ type: i0.Input }],
            totalValue: [{ type: i0.Input }],
            seriesName: [{ type: i0.Input }],
            showTooltip: [{ type: i0.Input }],
            labelPrimary: [{ type: i0.Input }],
            labelSecondary: [{ type: i0.Input }],
            softLimit: [{ type: i0.Input }],
            hardLimit: [{ type: i0.Input }],
            tooltipSoftLimitValue: [{ type: i0.Input }],
            tooltipHardLimitValue: [{ type: i0.Input }],
            tooltipCurrentValue: [{ type: i0.Input }],
            zones: [{ type: i0.Input }],
            axisLabels: [{ type: i0.Input }],
            axisUnit: [{ type: i0.Input }],
            seriesData: [{ type: i0.Input }],
            legendsEnabled: [{ type: i0.Input }]
        };
        return HorizontalBarChartComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var IconComponent = /** @class */ (function () {
        function IconComponent(sanitizer) {
            this.sanitizer = sanitizer;
            this.iconClass = ''; // they hand in kabob-case
            this.hasLoggedDep = false;
            this.stateMap = {
                ok: 'icon-status-ok-circlecheck',
                success: 'icon-status-ok-circlecheck',
                warning: 'icon-status-warning',
                critical: 'icon-status-critical',
                error: 'icon-status-error-full',
                info: 'icon-status-info',
            };
        }
        Object.defineProperty(IconComponent.prototype, "svgContent", {
            get: /**
             * @return {?}
             */ function () {
                /* if I have a severity, we load the right one */
                /** @type {?} */
                var isSeverity = false;
                if (this.severity && this.severity.toLowerCase() in this.stateMap) {
                    this.iconClass = this.stateMap[this.severity.toLowerCase()];
                    isSeverity = true;
                }
                /* I set a flag so I don't log over and over */
                if (!this.hasLoggedDep && !isSeverity) {
                    /* If they have sent me a key that I don't have warn them */
                    if (!(this.iconClass in icons.icons)) {
                        console.error("You tried to load <nwf-icon iconClass=\"" + this.iconClass + "\"> but it has been deprecated.");
                        this.hasLoggedDep = true;
                    }
                }
                /* return the actual html from the icons.js */
                return this.sanitizer.bypassSecurityTrustHtml(icons.icons[this.iconClass]);
            },
            enumerable: true,
            configurable: true
        });
        IconComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-icon',
                        template: "\n  <div [innerHTML]=\"svgContent\" class=\"{{iconClass}} nwf-icon {{class}}\"></div>\n  ",
                        styles: [":host{display:inline-flex;align-items:center;justify-content:center;line-height:0;pointer-events:none}:host+.nwf-icon-label{display:inline-block;vertical-align:top;margin-left:4px}"]
                    }] }
        ];
        /** @nocollapse */
        IconComponent.ctorParameters = function () {
            return [
                { type: i2.DomSanitizer }
            ];
        };
        IconComponent.propDecorators = {
            iconClass: [{ type: i0.Input }],
            severity: [{ type: i0.Input }, { type: i0.Optional }],
            class: [{ type: i0.Input }]
        };
        return IconComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var HeaderComponent = /** @class */ (function () {
        function HeaderComponent(element) {
            this.element = element;
            this.status = 'info';
        }
        /**
         * @return {?}
         */
        HeaderComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                /** @type {?} */
                var stateCls = "is-" + this.status;
                this.element.nativeElement.classList.add(stateCls);
            };
        HeaderComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-modal-header',
                        template: "\n  <nwf-icon [severity]=\"status\"></nwf-icon>\n  <h5 class=\"modal-title\"><ng-content></ng-content></h5>\n",
                        host: { class: 'modal-header' }
                    }] }
        ];
        /** @nocollapse */
        HeaderComponent.ctorParameters = function () {
            return [
                { type: i0.ElementRef }
            ];
        };
        HeaderComponent.propDecorators = {
            status: [{ type: i0.Input }]
        };
        return HeaderComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var NwfPageAlertService = /** @class */ (function () {
        function NwfPageAlertService() {
            this.pageAlert = new rxjs.Subject();
            this.pageAlert$ = this.pageAlert.asObservable();
        }
        // Method to Show Page Alert
        // Method to Show Page Alert
        /**
         * @param {?} message
         * @param {?} severity
         * @param {?=} fade
         * @return {?}
         */
        NwfPageAlertService.prototype.show =
            // Method to Show Page Alert
            /**
             * @param {?} message
             * @param {?} severity
             * @param {?=} fade
             * @return {?}
             */
            function (message, severity, fade) {
                this.pageAlert.next({ type: 'show', config: { message: message, severity: severity, fade: fade } });
            };
        // Method to Hide Page Alert
        // Method to Hide Page Alert
        /**
         * @return {?}
         */
        NwfPageAlertService.prototype.hide =
            // Method to Hide Page Alert
            /**
             * @return {?}
             */
            function () {
                this.pageAlert.next({ type: 'hide' });
            };
        NwfPageAlertService.decorators = [
            { type: i0.Injectable }
        ];
        return NwfPageAlertService;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var PageAlertComponent = /** @class */ (function () {
        function PageAlertComponent(element, pageAlertService, sanitizer, transitionService, i18next) {
            var _this = this;
            this.element = element;
            this.sanitizer = sanitizer;
            this.transitionService = transitionService;
            this.i18next = i18next;
            this.message = '';
            this.severity = 'ok';
            this.isShowing = false;
            this.extraInformation = '';
            this.showMoreInfo = false;
            this.subscription = pageAlertService.pageAlert$.subscribe(( /**
             * @param {?} data
             * @return {?}
             */function (data) {
                // TO check whether show is called or hide is called
                if (data.type === 'show') {
                    _this.show(data.config);
                }
                else {
                    _this.close();
                }
            }));
            /* I want to close when I exit this route */
            transitionService.onExit({
                exiting: '*',
            }, this.close.bind(this));
        }
        /**
         * @return {?}
         */
        PageAlertComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () { };
        /**
         * @return {?}
         */
        PageAlertComponent.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                // unsubscribe to ensure no memory leaks
                this.subscription.unsubscribe();
            };
        /**
         * @param {?} __0
         * @return {?}
         */
        PageAlertComponent.prototype.show = /**
         * @param {?} __0
         * @return {?}
         */
            function (_a) {
                var _this = this;
                var message = _a.message, severity = _a.severity, fade = _a.fade;
                this.resetFlags();
                // checking if message is object or not.
                if (typeof message === 'object') {
                    // setting extraInformation.
                    this.extraInformation = message.extraInformation || '';
                    // updating message.
                    message = message.message;
                }
                this.message = this.sanitizer.bypassSecurityTrustHtml(message);
                this.severity = severity;
                this.isShowing = true;
                if (fade) {
                    setTimeout(( /**
                     * @return {?}
                     */function () { return _this.close(); }), fade);
                }
            };
        /**
         * @return {?}
         */
        PageAlertComponent.prototype.close = /**
         * @return {?}
         */
            function () {
                this.isShowing = false;
            };
        /**
         * @return {?}
         */
        PageAlertComponent.prototype.toggleMoreInfoVisibility = /**
         * @return {?}
         */
            function () {
                if (this.showMoreInfo) {
                    this.showMoreInfo = false;
                    this.showMoreButtonText = this.i18next.transform('nwfjs:showMore');
                }
                else {
                    this.showMoreInfo = true;
                    this.showMoreButtonText = this.i18next.transform('nwfjs:hide');
                }
            };
        /**
         * @return {?}
         */
        PageAlertComponent.prototype.resetFlags = /**
         * @return {?}
         */
            function () {
                // resetting flags.
                this.extraInformation = '';
                this.showMoreInfo = false;
                this.showMoreButtonText = this.i18next.transform('nwfjs:showMore');
            };
        Object.defineProperty(PageAlertComponent.prototype, "stateClass", {
            get: /**
             * @return {?}
             */ function () {
                return "is-" + this.severity.toLowerCase();
            },
            enumerable: true,
            configurable: true
        });
        PageAlertComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-page-alert',
                        template: "\n    <div data-netapp-id=\"nwf-pageAlert\" class=\"nwf-page-alert {{stateClass}}\" *ngIf=\"isShowing\" role=\"alert\">\n        <div class=\"l-page-alert-icon\" data-netapp-id=\"pageAlertCtrl-icon\">\n            <nwf-icon [severity]=\"severity\"></nwf-icon>\n        </div>\n        <div class=\"page-alert-message-container\">\n            <div data-netapp-id=\"pageAlertCtrl-message\" class=\"page-alert-message\">\n                <span [innerHTML]=\"message\"></span>\n                <a href=\"javascript:void(0)\" *ngIf=\"extraInformation\" (click)=\"toggleMoreInfoVisibility()\">\n                    {{showMoreButtonText}}\n                </a>\n            </div>\n            <div [hidden]=\"!showMoreInfo\">\n            <div>{{extraInformation}}</div>\n            </div>\n        </div>\n        <div class=\"l-page-alert-close\" data-netapp-id=\"pageAlertCtrl-close-btn\" (click)=\"close()\">\n            <nwf-icon iconClass=\"icon-action-x\"></nwf-icon>\n        </div>\n    </div>\n  ",
                        styles: [":host{width:50%;position:fixed;top:60px;left:50%;z-index:9;margin-left:-25%}.nwf-page-alert{display:flex}.nwf-page-alert a{color:#2d6dde}.nwf-page-alert.is-ok{background-color:#b4e697}.nwf-page-alert.is-error{background-color:#fff}.nwf-page-alert.is-info{background-color:#fff7c0}.nwf-page-alert.is-critical{background-color:#fccdce}.nwf-page-alert.is-warning{background-color:#ffe1a1}.l-page-alert-icon{margin-left:7px;-ms-grid-row-align:center;align-self:center;margin-top:2px}.page-alert-message-container{display:flex;flex:9;flex-direction:column;justify-content:center;padding:10px}.page-alert-message{max-width:676px;overflow:hidden;text-overflow:ellipsis}.l-page-alert-close{display:flex;max-width:30px;cursor:pointer;flex:1;align-items:center;justify-content:center}"]
                    }] }
        ];
        /** @nocollapse */
        PageAlertComponent.ctorParameters = function () {
            return [
                { type: i0.ElementRef },
                { type: NwfPageAlertService },
                { type: i2.DomSanitizer },
                { type: angular.TransitionService },
                { type: i1.I18NextPipe }
            ];
        };
        PageAlertComponent.propDecorators = {
            message: [{ type: i0.Input }],
            severity: [{ type: i0.Input }]
        };
        return PageAlertComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var NwfPropertySheet = /** @class */ (function () {
        function NwfPropertySheet() {
        }
        NwfPropertySheet.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-property-sheet',
                        host: {
                            class: 'd-block',
                        },
                        template: "<ng-content></ng-content>",
                        styles: [":host{margin-bottom:-16px}:host ::ng-deep .row{margin-bottom:16px}:host.small ::ng-deep dd{font-size:12px;font-weight:600}"]
                    }] }
        ];
        /** @nocollapse */
        NwfPropertySheet.ctorParameters = function () { return []; };
        return NwfPropertySheet;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var NwfProperty = /** @class */ (function () {
        function NwfProperty(self) {
            this.self = self;
        }
        /**
         * @return {?}
         */
        NwfProperty.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
            };
        NwfProperty.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-property',
                        template: "<dl>\n  <ng-content select=\"dt\" class=\"dt\"></ng-content>\n  <ng-content select=\"dd\"></ng-content>\n  </dl>\n  ",
                        styles: ["dl{margin-bottom:16px}:host ::ng-deep dt{color:#565656;font-size:12px;font-weight:400;text-transform:uppercase}:host ::ng-deep dd{color:#454545;font-weight:400;font-size:18px;line-height:1.3;margin-bottom:0}:host ::ng-deep dd a{color:#2d6dde}:host ::ng-deep dd a:hover{color:#1e4a93}"]
                    }] }
        ];
        /** @nocollapse */
        NwfProperty.ctorParameters = function () {
            return [
                { type: i0.ElementRef }
            ];
        };
        return NwfProperty;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var NwfjsSharedComponentsModule = /** @class */ (function () {
        function NwfjsSharedComponentsModule() {
        }
        NwfjsSharedComponentsModule.decorators = [
            { type: i0.NgModule, args: [{
                        imports: [
                            common.CommonModule,
                            angularHighcharts.ChartModule,
                            forms.FormsModule,
                            ngBootstrap.NgbModule,
                            i1.I18NextModule,
                            angular.UIRouterModule,
                        ],
                        declarations: [IconComponent, HelpDirective, AlertComponent,
                            PageAlertComponent,
                            NwfDatetimePicker, NwfDatetimeRangePicker, NwfElipsizer,
                            HeaderComponent,
                            NwfPropertySheet,
                            NwfProperty,
                            NwfFeatureTourDirective,
                            HorizontalBarChartComponent,
                        ],
                        providers: [NwfPageAlertService, NwfElipsizerResizeService, NwfFeatureTourService, NwfBeaconService, NwfHelpConfig, NwfColumnsChangingService],
                        exports: [
                            IconComponent,
                            HelpDirective,
                            PageAlertComponent,
                            AlertComponent,
                            NwfDatetimePicker,
                            NwfDatetimeRangePicker,
                            NwfElipsizer,
                            HeaderComponent,
                            NwfPropertySheet,
                            NwfProperty,
                            NwfFeatureTourDirective,
                            HorizontalBarChartComponent,
                        ],
                    },] }
        ];
        return NwfjsSharedComponentsModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var NwfRoundUnit = /** @class */ (function () {
        function NwfRoundUnit(i18NextPipeFormatPipe) {
            this.i18NextPipeFormatPipe = i18NextPipeFormatPipe;
            this.units = ['bytes', 'KB', 'MB', 'GB', 'TB', 'PB'];
        }
        /**
         * @param {?} value
         * @param {?} config
         * @return {?}
         */
        NwfRoundUnit.prototype.transform = /**
         * @param {?} value
         * @param {?} config
         * @return {?}
         */
            function (value, config) {
                var unit = config.unit, statType = config.statType;
                /** @type {?} */
                var isPercent = (unit === '%');
                if (this.units.indexOf(unit) >= 0) {
                    var _a = this.getReadable(value, unit), newValue = _a.value, newUnit = _a.unit;
                    value = newValue;
                    unit = newUnit;
                }
                /** @type {?} */
                var text = this.round(value, isPercent, statType);
                if (text) { // parsing through number locale if value is truthy.if (value !== null) {
                    if (!isNaN(parseFloat(text))) {
                        // Use i18next formatting for number
                        text = this.i18NextPipeFormatPipe.transform(parseFloat(text), { format: 'number' });
                    }
                    if (unit) { // add unit only if unit is not undefined and not null
                        text += (isPercent ? '' : ' ') + unit;
                    }
                    return text;
                }
                else {
                    return 'N/A';
                }
            };
        /**
         * @param {?} value
         * @param {?=} isPercent
         * @param {?=} statType
         * @return {?}
         */
        NwfRoundUnit.prototype.round = /**
         * @param {?} value
         * @param {?=} isPercent
         * @param {?=} statType
         * @return {?}
         */
            function (value, isPercent, statType) {
                if (isPercent === void 0) {
                    isPercent = false;
                }
                if (statType === void 0) {
                    statType = '';
                }
                if (value === null) { //  return null if null
                    return null;
                }
                else if (value === 0) {
                    return '0';
                }
                if (isPercent) {
                    if (value < 1) { // "<1" if < 1
                        return '< 1';
                    }
                    else { // Whole number otherwise
                        return parseFloat(value).toFixed();
                    }
                }
                else {
                    if (value < 1) {
                        switch (statType) {
                            case 'latency':
                                return parseFloat(value).toFixed(3); // 3 decimal points between 0 and 1 for Latency
                            default:
                                return '< 1'; // "<1" if < 1 for everything else
                        }
                    }
                    else if (value < 10 && value >= 1) { // 2 decimal points between 1 and 10
                        return parseFloat(value).toFixed(2);
                    }
                    else if (value < 100 && value >= 10) { // 1 decimal point between 10 and  100
                        return parseFloat(value).toFixed(1);
                    }
                    else if (value >= 100) { // Whole number if greater than 100
                        return parseFloat(value).toFixed();
                    }
                    else {
                        return value;
                    }
                }
            };
        /**
         * @param {?} value
         * @param {?} unit
         * @return {?}
         */
        NwfRoundUnit.prototype.getReadable = /**
         * @param {?} value
         * @param {?} unit
         * @return {?}
         */
            function (value, unit) {
                /** @type {?} */
                var idx = this.units.indexOf(unit);
                /** @type {?} */
                var result;
                // we always need a value handling undefined case
                while (value && !(value >= 1 && value < 1024)) {
                    if (value < 1) {
                        // The current unit is too big
                        if (idx > 0) {
                            // Decrease the unit by one level
                            value *= 1024.0;
                            idx -= 1;
                        }
                        else {
                            // The current unit is KB, there is no smaller unit, we have the result
                            result = { value: value, unit: this.units[idx] };
                            break;
                        }
                    }
                    if (value >= 1024) {
                        // The current unit is too small
                        if (idx < this.units.length - 1) {
                            // Increase the unit by one level
                            value /= 1024.0;
                            idx += 1;
                        }
                        else {
                            // The current unit is PB, there is no bigger unit, we have the result
                            result = { value: value, unit: this.units[idx] };
                            break;
                        }
                    }
                }
                if (!result) {
                    // The give arguments are proper value and unit
                    result = { value: value, unit: this.units[idx] };
                }
                return result;
            };
        NwfRoundUnit.decorators = [
            { type: i0.Pipe, args: [{ name: 'NwfRoundUnit' },] }
        ];
        /** @nocollapse */
        NwfRoundUnit.ctorParameters = function () {
            return [
                { type: i1.I18NextFormatPipe }
            ];
        };
        return NwfRoundUnit;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var NwfjsSharedPipesModule = /** @class */ (function () {
        function NwfjsSharedPipesModule() {
        }
        NwfjsSharedPipesModule.decorators = [
            { type: i0.NgModule, args: [{
                        imports: [
                            i1.I18NextModule,
                        ],
                        declarations: [
                            NwfRoundUnit,
                        ],
                        exports: [
                            NwfRoundUnit,
                        ],
                    },] }
        ];
        return NwfjsSharedPipesModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    /* todo - the 'nwf*cellTemplate' stuff should really be constants since they are shared in the../schema/schema' */
    // nwf-grid-cell-templates
    // this component contains all the templates that are common across all the grids.
    // Currently it contains templates for checkboxTemplate, metricCellTemplate, dateCellTemplate, statusCellTemplate.
    // metric, date celTemplates are i18n compliant.
    var CellsComponent = /** @class */ (function () {
        function CellsComponent() {
            // Output Event handler. This selects a row on the grid.
            this.onRowSelect = new i0.EventEmitter();
        }
        /**
         * @param {?} data
         * @return {?}
         */
        CellsComponent.prototype.onSelect = /**
         * @param {?} data
         * @return {?}
         */
            function (data) {
                // emit the onRowSelect event containing rowData.
                // This event is handled by the consumer.
                this.onRowSelect.emit(data);
            };
        CellsComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-grid-cell-templates',
                        template: "\n    <div *dxTemplate=\"let cellInfo of 'nwfRadioBoxCellTemplate'\">\n      <div class=\"custom-control custom-radio\">\n          <input type=\"radio\" id=\"dx-data-grid-checkid-{{cellInfo.value}}\" data-netapp-id=\"cell-radiobtn\" class=\"custom-control-input\" [value]=\"cellInfo.value\" [checked]=\"cellInfo.component.isRowSelected(cellInfo.key) ? true : null\"\n          (click)=\"onSelect(cellInfo)\">\n          <label class=\"custom-control-label\" for=\"dx-data-grid-checkid-{{cellInfo.value}}\"></label>\n      </div>\n    </div>\n\n    <div *dxTemplate=\"let cellInfo of 'nwfNumberCellTemplate'\" attr.data-netapp-id=\"cell-{{cellInfo.column.dataField}}\">\n      {{cellInfo.value | i18nextFormat : { format: 'number'} }}\n    </div>\n\n    <div *dxTemplate=\"let cellInfo of 'nwfDateCellTemplate'\" attr.data-netapp-id=\"cell-{{cellInfo.column.dataField}}\">\n      {{cellInfo.value | i18nextFormat : { format: 'datetime' } }}\n    </div>\n\n    <div *dxTemplate=\"let cellInfo of 'nwfStatusCellTemplate'\" attr.data-netapp-id=\"cell-{{cellInfo.column.dataField}}\">\n      <nwf-icon [severity]=\"cellInfo.value\"></nwf-icon>\n    </div>\n\n\t<div *dxTemplate=\"let cellInfo of 'nwfMetricCellTemplate'\" attr.data-netapp-id=\"cell-{{cellInfo.column.dataField}}\">\n      {{cellInfo.value | NwfRoundUnit : {unit: cellInfo.column.unit, statType: cellInfo.column.name} }}\n    </div>\n\n    <div *dxTemplate=\"let cellInfo of 'nwfDefaultCellTemplate'\" attr.data-netapp-id=\"cell-{{cellInfo.column.dataField}}\">\n      {{cellInfo.value}}\n    </div>\n  "
                    }] }
        ];
        /** @nocollapse */
        CellsComponent.ctorParameters = function () { return []; };
        CellsComponent.propDecorators = {
            onRowSelect: [{ type: i0.Output }]
        };
        return CellsComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var ColumnChooserComponent = /** @class */ (function () {
        function ColumnChooserComponent(i18NextPipe) {
            this.i18NextPipe = i18NextPipe;
            this._availableColumns = [];
            this._columnsToDisplay = [];
            this.isInvalid = false;
            this.value = [];
        }
        /**
         * @return {?}
         */
        ColumnChooserComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.dataGrid.onContentReady.subscribe(( /**
                 * @param {?} data
                 * @return {?}
                 */function (data) {
                    _this.gridInstance = data.component.instance();
                    /** @type {?} */
                    var newColumns = _this.gridInstance.state().columns;
                    /** @type {?} */
                    var areColumnsEqual = lodashEs.isEqual(newColumns, _this.value);
                    if (!areColumnsEqual) {
                        // Update columns and refresh columns to display only if columns have changed
                        _this.value = newColumns;
                        _this.setColumnsToDisplay();
                    }
                }));
            };
        /**
         * @return {?}
         */
        ColumnChooserComponent.prototype.setColumnsToDisplay = /**
         * @return {?}
         */
            function () {
                var _this = this;
                /** @type {?} */
                var dxGridColumns = this.getAllColumnsOnDxGrid();
                // Remove all columns that are not shown in the column chooser
                /** @type {?} */
                var shownColumns = lodashEs.filter(dxGridColumns, ( /**
                 * @param {?} col
                 * @return {?}
                 */function (col) { return col.showInColumnChooser; }));
                // updating dxGridColumns with the value of column chooser.
                shownColumns.forEach(( /**
                 * @param {?} origCol
                 * @return {?}
                 */function (origCol) {
                    // find if a column in dxGridColumns also exist in value. Columns should have same dataField.
                    /** @type {?} */
                    var columnInValue = lodashEs.find(_this.value, ( /**
                     * @param {?} valueCol
                     * @return {?}
                     */function (valueCol) { return origCol.dataField === valueCol.dataField; }));
                    origCol = lodashEs.merge(origCol, columnInValue);
                }));
                // we set columnsToDisplay for visible columns and sort them in order of visibleIndex.
                this._columnsToDisplay = lodashEs.sortBy(lodashEs.filter(shownColumns, ( /**
                 * @param {?} col
                 * @return {?}
                 */function (col) { return col.visible; })), [( /**
                         * @param {?} o
                         * @return {?}
                         */function (o) { return o.visibleIndex; })]);
                // available columns are all columns with caption but are not visible.
                this._availableColumns = lodashEs.filter(shownColumns, ( /**
                 * @param {?} col
                 * @return {?}
                 */function (col) { return !col.visible; }));
            };
        /**
         * @return {?}
         */
        ColumnChooserComponent.prototype.togglePopover = /**
         * @return {?}
         */
            function () {
                this.ngbPopover.toggle();
            };
        /**
         * @return {?}
         */
        ColumnChooserComponent.prototype.closePopover = /**
         * @return {?}
         */
            function () {
                this.ngbPopover.close();
            };
        /**
         * @param {?} selection
         * @return {?}
         */
        ColumnChooserComponent.prototype.toggleSelection = /**
         * @param {?} selection
         * @return {?}
         */
            function (selection) {
                /** @type {?} */
                var isSel = selection.isSelected || null;
                if (!isSel) {
                    this.selectOption(selection);
                }
                else {
                    this.deselectColumn(selection);
                }
            };
        /**
         * @param {?} selIn
         * @return {?}
         */
        ColumnChooserComponent.prototype.deselectColumn = /**
         * @param {?} selIn
         * @return {?}
         */
            function (selIn) {
                delete selIn.isSelected;
            };
        /**
         * @param {?} selIn
         * @return {?}
         */
        ColumnChooserComponent.prototype.selectOption = /**
         * @param {?} selIn
         * @return {?}
         */
            function (selIn) {
                selIn.isSelected = true;
            };
        /**
         * @return {?}
         */
        ColumnChooserComponent.prototype.deSelectAvailableColumns = /**
         * @return {?}
         */
            function () {
                // Deselect means I am taking a selected column and moving it to available the [ < ]
                /** @type {?} */
                var columnsSelectedToHide = lodashEs.remove(this._columnsToDisplay, { isSelected: true });
                [].splice.apply(this._availableColumns, [this._availableColumns.length, 0].concat(columnsSelectedToHide));
                this.removeIsSelectedFromAllColumns(this._availableColumns);
            };
        /**
         * @param {?} availableColumns
         * @return {?}
         */
        ColumnChooserComponent.prototype.removeIsSelectedFromAllColumns = /**
         * @param {?} availableColumns
         * @return {?}
         */
            function (availableColumns) {
                var _this = this;
                lodashEs.forEach(availableColumns, ( /**
                 * @param {?} column
                 * @return {?}
                 */function (column) {
                    _this.deselectColumn(column);
                }));
            };
        /**
         * @return {?}
         */
        ColumnChooserComponent.prototype.selectAvailableColumns = /**
         * @return {?}
         */
            function () {
                // Find my self in the schema availableColumns so I Can be put back where I belong.
                /** @type {?} */
                var columnsSelectedToShow = lodashEs.remove(this._availableColumns, { isSelected: true });
                [].splice.apply(this._columnsToDisplay, [this._columnsToDisplay.length, 0].concat(columnsSelectedToShow));
                if (this._columnsToDisplay.length > 0) {
                    this.isInvalid = false;
                }
                this.removeIsSelectedFromAllColumns(this._columnsToDisplay);
            };
        /**
         * @param {?} fromIndex
         * @param {?} toIndex
         * @return {?}
         */
        ColumnChooserComponent.prototype.moveSelection = /**
         * @param {?} fromIndex
         * @param {?} toIndex
         * @return {?}
         */
            function (fromIndex, toIndex) {
                /** @type {?} */
                var sels = this._columnsToDisplay;
                /** @type {?} */
                var element = sels[fromIndex];
                if (fromIndex === 0 && toIndex === -1) {
                    return;
                }
                sels.splice(fromIndex, 1);
                sels.splice(toIndex, 0, element);
            };
        /**
         * @return {?}
         */
        ColumnChooserComponent.prototype.moveColumnsUp = /**
         * @return {?}
         */
            function () {
                var _this = this;
                /** @type {?} */
                var selectedAvailableColumns = lodashEs.filter(this._columnsToDisplay, { isSelected: true });
                lodashEs.forEach(selectedAvailableColumns, ( /**
                 * @param {?} optionToMove
                 * @return {?}
                 */function (optionToMove) {
                    /** @type {?} */
                    var idx = lodashEs.findIndex(_this._columnsToDisplay, { dataField: optionToMove.dataField });
                    if (idx > 0) {
                        // toIndex will be one greater than currentIndex.
                        /** @type {?} */
                        var toIndex = idx - 1;
                        /** @type {?} */
                        var doUpdate = false;
                        // toIndex has to be greater than -1.
                        while (toIndex > -1) {
                            /** @type {?} */
                            var toElement = _this._columnsToDisplay[toIndex];
                            // find element at toIndex and see if its fixed or not (i.e) cannot be reordered/hidden and it should not be selected.
                            // all selected elements are handled on their own.
                            if (toElement.allowReordering && !toElement.isSelected) {
                                toIndex = doUpdate ? toIndex + 1 : toIndex;
                                _this.moveSelection(idx, toIndex);
                                break;
                            }
                            else {
                                // else, we decrement the toIndex and move-on.
                                toIndex = toIndex - 1;
                                doUpdate = true;
                            }
                        }
                    }
                }));
            };
        /**
         * @return {?}
         */
        ColumnChooserComponent.prototype.moveColumnsDown = /**
         * @return {?}
         */
            function () {
                var _this = this;
                /** @type {?} */
                var selectedAvailableColumns = lodashEs.filter(this._columnsToDisplay, { isSelected: true }).reverse();
                lodashEs.forEach(selectedAvailableColumns, ( /**
                 * @param {?} optionToMove
                 * @return {?}
                 */function (optionToMove) {
                    // find index of selected column in columnsToDisplay.
                    /** @type {?} */
                    var idx = lodashEs.findIndex(_this._columnsToDisplay, { dataField: optionToMove.dataField });
                    if (idx < _this._columnsToDisplay.length - 1) {
                        // toIndex will be one greater than currentIndex.
                        // we also have a flag that tells us if we need to update toIndex or not.
                        /** @type {?} */
                        var toIndex = idx + 1;
                        /** @type {?} */
                        var doUpdate = false;
                        // we loop over till we reach the last index of columnsToDisplay as thats the max we can go down.
                        while (toIndex < _this._columnsToDisplay.length) {
                            // find element at toIndex and see if its fixed or not (i.e) cannot be reordered/hidden.
                            /** @type {?} */
                            var toElement = _this._columnsToDisplay[toIndex];
                            // if next column can be reordered, we jump to next to next spot.
                            if (toElement.allowReordering) {
                                // we move the selection.
                                toIndex = doUpdate ? toIndex - 1 : toIndex;
                                _this.moveSelection(idx, toIndex);
                                break;
                            }
                            else {
                                // else, we increment the toIndex and move on.
                                toIndex = toIndex + 1;
                                doUpdate = true;
                            }
                        }
                    }
                }));
            };
        /**
         * @return {?}
         */
        ColumnChooserComponent.prototype.cancel = /**
         * @return {?}
         */
            function () {
                this.setColumnsToDisplay();
                this.removeIsSelectedFromAllColumns(this._columnsToDisplay);
                this.removeIsSelectedFromAllColumns(this._availableColumns);
                this.closePopover();
            };
        /**
         * @return {?}
         */
        ColumnChooserComponent.prototype.apply = /**
         * @return {?}
         */
            function () {
                if (this._columnsToDisplay.length == 0) {
                    // show error msg
                    this.isInvalid = true;
                    // dont close the popover
                    return;
                }
                this.removeIsSelectedFromAllColumns(this._columnsToDisplay);
                this.removeIsSelectedFromAllColumns(this._availableColumns);
                this.updateIndexAndVisibilityOfColumns();
                this.closePopover();
            };
        /**
         * Method to update the index and visibility of grid columns and set it on the grid.
         */
        /**
         * Method to update the index and visibility of grid columns and set it on the grid.
         * @return {?}
         */
        ColumnChooserComponent.prototype.updateIndexAndVisibilityOfColumns = /**
         * Method to update the index and visibility of grid columns and set it on the grid.
         * @return {?}
         */
            function () {
                /** @type {?} */
                var gridInstance = this.gridInstance;
                this._columnsToDisplay.forEach(( /**
                 * @param {?} col
                 * @param {?} index
                 * @return {?}
                 */function (col, index) {
                    col.visibleIndex = index;
                }));
                gridInstance.beginUpdate();
                // _columnsToDisplay are columns on right side of column chooser, columns that are shown.
                // we loop over all _columnsToDisplay and set visible to true, and update visibleIndex.
                this._columnsToDisplay.forEach(( /**
                 * @param {?} col
                 * @param {?} visibleIndex
                 * @return {?}
                 */function (col, visibleIndex) {
                    gridInstance.columnOption(col.dataField, {
                        visible: true,
                        visibleIndex: visibleIndex,
                    });
                }));
                // _availableColumns are columns on left side of column chooser, columns that are hidden.
                // we loop over all availableColumns and set visible to false.
                this._availableColumns.forEach(( /**
                 * @param {?} __0
                 * @return {?}
                 */function (_a) {
                    var dataField = _a.dataField;
                    gridInstance.columnOption(dataField, {
                        visible: false,
                        visibleIndex: undefined,
                    });
                }));
                gridInstance.endUpdate();
            };
        /**
         * We find all columns on dx grid. Instead of using a method available on gridInstance directly, we use this way because
         * gridInstance.columnOption gives a complete column object (including default column settings),
         * whereas column object returned by gridInstance.option('columnms') only contains properties you explicitly set.
         * gridInstance.getVisibleColumns() method gives us the complete object but it only works for visible columns.
         */
        /**
         * We find all columns on dx grid. Instead of using a method available on gridInstance directly, we use this way because
         * gridInstance.columnOption gives a complete column object (including default column settings),
         * whereas column object returned by gridInstance.option('columnms') only contains properties you explicitly set.
         * gridInstance.getVisibleColumns() method gives us the complete object but it only works for visible columns.
         * @private
         * @return {?}
         */
        ColumnChooserComponent.prototype.getAllColumnsOnDxGrid = /**
         * We find all columns on dx grid. Instead of using a method available on gridInstance directly, we use this way because
         * gridInstance.columnOption gives a complete column object (including default column settings),
         * whereas column object returned by gridInstance.option('columnms') only contains properties you explicitly set.
         * gridInstance.getVisibleColumns() method gives us the complete object but it only works for visible columns.
         * @private
         * @return {?}
         */
            function () {
                /** @type {?} */
                var gridInstance = this.gridInstance;
                /** @type {?} */
                var columnsViaOptions = gridInstance && gridInstance.state().columns;
                if (columnsViaOptions) {
                    return columnsViaOptions.map(( /**
                     * @param {?} __0
                     * @return {?}
                     */function (_a) {
                        var dataField = _a.dataField;
                        return gridInstance.columnOption(dataField);
                    }));
                }
                else {
                    return;
                }
            };
        ColumnChooserComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-grid-column-chooser',
                        template: "<button [ngbPopover]=\"popContent\" [autoClose]=\"'outside'\" placement=\"bottom-right\" title=\"{{'nwfjs:columnChooserTitle' | i18next}}\" (click)=\"togglePopover()\"\n    triggers=\"none\" type=\"button\" class=\"btn btn-flat btn-icon text-dark\" data-netapp-id=\"nwf-column-chooser-btn\">\n    <nwf-icon iconClass=\"icon-action-settings\"></nwf-icon>\n</button>\n<ng-template #popContent>\n    <figure class=\"nwf-column-chooser\">\n        <div class=\"l-nwf-column-chooser-options\">\n            <h4>{{'nwfjs:columnChooserAvailableColumn' | i18next}}</h4>\n            <div class=\"nwf-column-chooser-options-no-msg\" *ngIf=\"!_availableColumns.length\">{{'nwfjs:columnChooserAllColumnSelected' | i18next}}</div>\n            <ul class=\"nwf-column-chooser-selections\" data-netapp-id=\"nwf-column-chooser-selections\" [ngClass]=\"{ 'is-empty': !_availableColumns.length }\">\n                <li class=\"nwf-column-chooser-option\" *ngFor=\"let selection of _availableColumns\" (click)=\"toggleSelection(selection)\" [ngClass]=\"{ 'is-selected': selection.isSelected }\">\n                    <span class=\"nwf-column-chooser-option-label\">{{selection.caption}}</span>\n                </li>\n            </ul>\n        </div>\n        <div class=\"l-nwf-column-chooser-controls\">\n            <button type=\"button\" class=\"btn btn-default\" (click)=\"deSelectAvailableColumns()\" data-netapp-id=\"nwf-column-chooser-select-option-btn\">\n                <nwf-icon iconClass=\"icon-misc-chevronleft\"></nwf-icon>\n            </button>\n            <span class=\"nwf-column-chooser-control-divider\"></span>\n            <button type=\"button\" class=\"btn btn-default\" (click)=\"selectAvailableColumns()\" data-netapp-id=\"nwf-column-chooser-select-option-btn\">\n                <nwf-icon iconClass=\"icon-misc-chevronright\"></nwf-icon>\n            </button>\n        </div>\n        <div class=\"l-nwf-column-chooser-selections\">\n            <h4>{{'nwfjs:columnChooserColumnToDisplay' | i18next}}</h4>\n            <ul class=\"nwf-column-chooser-selections\" data-netapp-id=\"nwf-column-chooser-selections\" [ngClass]=\"{'is-invalid': isInvalid}\"\n                [ngStyle]=\"{'overflow': isInvalid ? 'hidden' : ''}\">\n                <li class=\"nwf-column-chooser-option\" *ngFor=\"let selection of _columnsToDisplay;\" (click)=\"toggleSelection(selection)\" [ngClass]=\"{ 'is-selected': selection.isSelected, 'is-disabled': !(selection.allowHiding && selection.allowReordering) }\">\n                    <span class=\"nwf-column-chooser-option-label\">{{selection.caption}}</span>\n                </li>\n            </ul>\n            <div *ngIf=\"isInvalid\" class=\"invalid-feedback\">{{'nwfjs:isRequiredAtLeastOne' | i18next}}</div>\n        </div>\n\n        <div class=\"l-nwf-column-chooser-controls\">\n            <button type=\"button\" class=\"btn btn-default\" (click)=\"moveColumnsUp()\" data-netapp-id=\"nwf-column-chooser-select-option-btn\">\n                <nwf-icon iconClass=\"icon-misc-chevronup\"></nwf-icon>\n            </button>\n            <span class=\"nwf-column-chooser-control-divider\"></span>\n            <button class=\"btn btn-default\" (click)=\"moveColumnsDown()\" data-netapp-id=\"nwf-column-chooser-select-option-btn\">\n                <nwf-icon iconClass=\"icon-misc-chevrondown\"></nwf-icon>\n            </button>\n        </div>\n    </figure>\n    <footer class=\"d-flex mt-2\">\n        <div class=\"d-flex flex-fill justify-content-end\">\n            <button type=\"button\" class=\"btn btn-secondary mr-2\" (click)=\"cancel()\" data-netapp-id=\"nwf-column-chooser-close-btn\">{{'nwfjs:cancel' | i18next}}</button>\n            <button type=\"submit\" class=\"btn btn-primary\" (click)=\"apply()\" data-netapp-id=\"nwf-column-chooser-apply-btn\">{{'nwfjs:columnChooserApplyColumns' | i18next}}</button>\n        </div>\n    </footer>\n</ng-template>",
                        styles: [".dropdown-toggle::after{display:none}.nwf-column-chooser{display:flex;width:550px}.l-nwf-column-chooser-options{width:250px}.nwf-column-chooser-options-no-msg{position:absolute;padding-left:10px;top:45%}.nwf-column-chooser-option-label{flex:1}.nwf-column-chooser-option{padding:6px;border-bottom:1px solid #9c9c9c;display:flex;flex:1;cursor:pointer}.nwf-column-chooser-option.is-selected{background-color:#88c5ff}.nwf-column-chooser-option.is-disabled{pointer-events:none;cursor:pointer;background-color:#f2f2f2}.l-nwf-column-chooser-controls{display:flex;flex-direction:column;align-items:center;justify-content:center;padding:0 10px}.l-nwf-column-chooser-controls .btn{display:inline-block}.nwf-column-chooser-control-divider{height:10px}.l-nwf-column-chooser-selections{width:250px;display:flex;flex-direction:column}.nwf-column-chooser-selections{margin:0;padding:0;list-style:none;overflow-y:scroll;border:1px solid #c2c2c2;flex:1;max-height:328px;height:328px}.nwf-column-chooser-selections.is-empty{overflow-y:hidden}"]
                    }] }
        ];
        /** @nocollapse */
        ColumnChooserComponent.ctorParameters = function () {
            return [
                { type: i1.I18NextPipe }
            ];
        };
        ColumnChooserComponent.propDecorators = {
            dataGrid: [{ type: i0.Input }],
            ngbPopover: [{ type: i0.ViewChild, args: [ngBootstrap.NgbPopover,] }]
        };
        return ColumnChooserComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var ColumnVisibilityComponent = /** @class */ (function () {
        function ColumnVisibilityComponent() {
            this.orderedColumns = []; // our array of the columns in asc order
            // our array of the columns in asc order
            this.visible = {}; // our map of visiblity true / false
        }
        /**
         * @return {?}
         */
        ColumnVisibilityComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.myDrop.openChange.subscribe(( /**
                 * @return {?}
                 */function () {
                    _this.gridInstance = _this.dataGrid.instance;
                    _this.setColumns();
                }));
            };
        /**
         * @return {?}
         */
        ColumnVisibilityComponent.prototype.setColumns = /**
         * @return {?}
         */
            function () {
                var _this = this;
                /** @type {?} */
                var columns = this.gridInstance.option('columns');
                columns.forEach(( /**
                 * @param {?} __0
                 * @return {?}
                 */function (_a) {
                    var dataField = _a.dataField;
                    /** @type {?} */
                    var colObj = _this.gridInstance.columnOption(dataField);
                    // if columns are shown in columnChooser, then only we toggle the visibility flag and set it as part of ordered columns.
                    if (colObj.showInColumnChooser) {
                        _this.visible[dataField] = colObj.visible;
                        _this.orderedColumns[colObj.visibleIndex] = colObj;
                    }
                }));
            };
        /**
         * @param {?} event
         * @param {?} col
         * @return {?}
         */
        ColumnVisibilityComponent.prototype.notify = /**
         * @param {?} event
         * @param {?} col
         * @return {?}
         */
            function (event, col) {
                // we filter out command(eg checkbox column) columns as visibility only operates on non-command columns.
                // This ensures we dont toggle the visibility of checkbox column.
                /** @type {?} */
                var visibleColumns = this.gridInstance.getVisibleColumns().filter(( /**
                 * @param {?} item
                 * @return {?}
                 */function (item) { return !item.command; }));
                // if we have more than one visible column, or we are showing a column,
                // only then we toggle the visibility of the column.
                // this ensures we never run into case of having all hidden columns.
                if (visibleColumns.length > 1 || event.target.checked) {
                    this.gridInstance.beginUpdate();
                    this.gridInstance.columnOption(col, 'visible', event.target.checked);
                    this.gridInstance.endUpdate();
                }
                else {
                    // this ensures the last checkbox remains checked.
                    // so that we can never have all checkbox as unchecked i.e. all columns are unselected/hidden.
                    event.target.checked = true;
                }
            };
        /**
         * Unused for now.
         * Can be used if submit needed in any case
         */
        /**
         * Unused for now.
         * Can be used if submit needed in any case
         * @return {?}
         */
        ColumnVisibilityComponent.prototype.submit = /**
         * Unused for now.
         * Can be used if submit needed in any case
         * @return {?}
         */
            function () {
                this.gridInstance.beginUpdate();
                for (var dataField in this.visible) {
                    if (this.visible.hasOwnProperty(dataField)) {
                        /** @type {?} */
                        var columnVisibility = this.visible[dataField];
                        this.gridInstance.columnOption(dataField, 'visible', columnVisibility);
                    }
                }
                this.gridInstance.endUpdate();
                this.myDrop.close();
            };
        ColumnVisibilityComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-grid-column-visibility',
                        template: "<div ngbDropdown class=\"d-inline-block\" placement=\"bottom-right\" autoClose=\"outside\">\n  <button type=\"button\" class=\"btn btn-flat btn-icon-with-label\" ngbDropdownToggle>\n    <nwf-icon iconClass=\"icon-view-visible\"></nwf-icon><span class=\"nwf-icon-label\">{{'nwfjs:showHide' | i18next}}</span>\n  </button>\n  <div ngbDropdownMenu>\n    <dx-scroll-view>\n      <div class=\"dropdown-checkbox-item pl-4 mb-1\" *ngFor=\"let column of orderedColumns\">\n        <div class=\"custom-control custom-checkbox\" *ngIf=\"column.allowHiding !== false\">\n          <input type=\"checkbox\" [name]=\"column.dataField\" [id]=\"column.dataField\" class=\"custom-control-input\"\n            [(ngModel)]=\"visible[column.dataField]\" (change)=\"notify($event, column.dataField)\">\n          <label class=\"custom-control-label w-100\" [attr.for]=\"column.dataField\">{{column.caption}}</label>\n        </div>\n      </div>\n    </dx-scroll-view>\n  </div>\n</div>",
                        styles: [":host ::ng-deep .dx-scrollable-container{max-height:50vh}.dropdown-menu{padding-top:20px;padding-bottom:20px;max-height:60vh}.dropdown-checkbox-item{margin-right:20px}.custom-control-label{cursor:pointer;white-space:nowrap}"]
                    }] }
        ];
        /** @nocollapse */
        ColumnVisibilityComponent.ctorParameters = function () { return []; };
        ColumnVisibilityComponent.propDecorators = {
            myDrop: [{ type: i0.ViewChild, args: [ngBootstrap.NgbDropdown,] }],
            dataGrid: [{ type: i0.Input }]
        };
        return ColumnVisibilityComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    /** @type {?} */
    var containsOptions = [{
            name: 'nwfjs:contains', value: 'contains',
        }, {
            name: 'nwfjs:startsWith', value: 'startswith',
        }];
    /** @type {?} */
    var resourceContainsOptions = [{
            name: 'nwfjs:nameContains', value: 'contains',
        }, {
            name: 'nwfjs:nameStartsWith', value: 'startswith',
        }];
    /** @type {?} */
    var isOption = { name: 'nwfjs:is', value: '=' };
    /** @type {?} */
    var booleanOptions = [
        isOption,
        { name: 'nwfjs:isNot', value: '<>' },
    ];
    /** @type {?} */
    var numericOptions = [{
            name: 'nwfjs:greaterThan', value: '>',
        }, {
            name: 'nwfjs:lessThan', value: '<',
        }];
    var FilterConfig = {
        'string': {
            inputType: 'text',
            options: containsOptions,
        },
        'associatedobjects': {
            inputType: 'text',
            options: containsOptions,
        },
        'volumetype': {
            inputType: 'select',
            options: [
                isOption,
            ],
        },
        'resource': {
            inputType: 'text',
            options: resourceContainsOptions,
        },
        'resource_null': {
            inputType: 'text',
            options: __spread(resourceContainsOptions, [{ name: 'nwfjs:is', value: '=', default: 'null' },
                { name: 'nwfjs:isNot', value: '<>', default: 'null' },]),
        },
        'metric': {
            inputType: 'number',
            options: numericOptions,
        },
        'enum': {
            inputType: 'select',
            options: booleanOptions,
        },
        'enum-single': {
            inputType: 'select',
            options: [
                isOption,
            ],
        },
        'enum-multiple': {
            inputType: 'multiselect',
            options: booleanOptions,
        },
        'number': {
            inputType: 'number',
            options: numericOptions,
        },
        'datetime': {
            inputType: 'dateTime',
            options: [{
                    name: 'nwfjs:inTheLast', value: 'lst',
                }, {
                    name: 'nwfjs:between', value: 'between',
                }, {
                    name: 'nwfjs:greaterThan', value: '>=',
                }, {
                    name: 'nwfjs:lessThan', value: '<=',
                }],
        },
    };

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    /**
     * A filter criterion consist of filter property, operator and a value.
     * Each filter-property have a list of operators.
     * Filter criterion row gets a critierion(filter) from parent filterGroup, and it breaks that criterion down into property, operator and a value.
     * Filter property and type means same thing and are interchangeable
     */
    var FilterCriterionRowComponent = /** @class */ (function () {
        function FilterCriterionRowComponent() {
            this.deleteCriterion = new i0.EventEmitter();
            this.config = FilterConfig;
        }
        /**
         * @return {?}
         */
        FilterCriterionRowComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                // on birth, we set the operator and value based on incoming filter property.
                this.setColumnBasedOnCriteria();
            };
        /**
         * @description method to set the operator and value of a particular criterion when property dropdown value is changed.
         * Whenever we change the filter property, we update the operator and reset the value associated with the filter, so that we can start fresh for the new filter.
         * @param id
         */
        /**
         * \@description method to set the operator and value of a particular criterion when property dropdown value is changed.
         * Whenever we change the filter property, we update the operator and reset the value associated with the filter, so that we can start fresh for the new filter.
         * @return {?}
         */
        FilterCriterionRowComponent.prototype.updateCriterion = /**
         * \@description method to set the operator and value of a particular criterion when property dropdown value is changed.
         * Whenever we change the filter property, we update the operator and reset the value associated with the filter, so that we can start fresh for the new filter.
         * @return {?}
         */
            function () {
                // updating the new criterion.
                this.setColumnBasedOnCriteria();
                // resetting the form group with default criteria.
                this.criteria.reset(this.initCriterion(this.selectedColumn));
            };
        /**
         * @param {?} change
         * @return {?}
         */
        FilterCriterionRowComponent.prototype.updateOperator = /**
         * @param {?} change
         * @return {?}
         */
            function (change) {
                var _this = this;
                /** @type {?} */
                var selectedOperator = change.target.value;
                // If there is a default value associate with the selected operator we want to set the criteria to have that value
                /** @type {?} */
                var defaultValue = lodashEs.find(this.config[this.selectedColumn.dataType].options, ( /**
                 * @param {?} option
                 * @return {?}
                 */function (option) { return option.value === selectedOperator; })).default;
                if (defaultValue) {
                    this.criteria.reset({ property: this.selectedColumn.dataField, operator: selectedOperator, value: defaultValue });
                    // If the current value of the criteria is the same as the default value associated with the previous operator we want to clear it away
                }
                else if (this.previousOperator &&
                    lodashEs.find(this.config[this.selectedColumn.dataType].options, ( /**
                     * @param {?} option
                     * @return {?}
                     */function (option) { return option.value === _this.previousOperator; })).default === this.criteria.controls.value.value) {
                    this.criteria.reset({ property: this.selectedColumn.dataField, operator: selectedOperator, value: '' });
                }
                this.previousOperator = selectedOperator;
            };
        /**
         * Method to get the default filter critierion based on filter property.
         * @param property Filter property (type)
         */
        /**
         * Method to get the default filter critierion based on filter property.
         * @private
         * @param {?} __0
         * @return {?}
         */
        FilterCriterionRowComponent.prototype.initCriterion = /**
         * Method to get the default filter critierion based on filter property.
         * @private
         * @param {?} __0
         * @return {?}
         */
            function (_a) {
                var dataField = _a.dataField, dataType = _a.dataType;
                this.previousOperator = this.config[dataType].options[0].value;
                return {
                    property: dataField,
                    operator: this.config[dataType].options[0].value,
                    value: '',
                };
            };
        /**
         * This method finds the property to be set to individual criterion
         * from properties passed-in.
         */
        /**
         * This method finds the property to be set to individual criterion
         * from properties passed-in.
         * @private
         * @return {?}
         */
        FilterCriterionRowComponent.prototype.setColumnBasedOnCriteria = /**
         * This method finds the property to be set to individual criterion
         * from properties passed-in.
         * @private
         * @return {?}
         */
            function () {
                var _this = this;
                // update property based on new selection.
                this.selectedColumn = this.dxColumns.filter(( /**
                 * @param {?} prop
                 * @return {?}
                 */function (prop) {
                    return prop.dataField === _this.criteria.value.property;
                }))[0];
                // update prevoious operator based on criteria
                this.previousOperator = this.criteria.controls.operator.value;
                // updating operator list based on new filter property.
                this.propertyTypeConfig = this.config[this.selectedColumn.dataType];
            };
        FilterCriterionRowComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-grid-filter-criterion-row',
                        template: "<div [formGroup]=\"criteria\" class=\"d-flex mb-2 w-100\">\n\n    <!-- Property -->\n    <div class=\"filter-criterion-control mr-1\">\n        <select class=\"custom-select\" data-netapp-id=\"filter-widget-select-type\" (change)=\"updateCriterion()\" formControlName=\"property\">\n            <option *ngFor=\"let dxColumn of dxColumns\" [value]=\"dxColumn.dataField\">{{dxColumn.caption}}</option>\n        </select>\n    </div>\n\n    <!-- Operator -->\n    <div class=\"filter-criterion-control mr-1\">\n        <select class=\"custom-select\" data-netapp-id=\"filter-widget-select-operator\" (change)=\"updateOperator($event)\" formControlName=\"operator\">\n            <option *ngFor=\"let operator of propertyTypeConfig.options\" [value]=\"operator.value\">{{operator.name | i18next}}\n            </option>\n        </select>\n    </div>\n\n    <!-- Value -->\n    <div class=\"mr-1\" [ngSwitch]=\"propertyTypeConfig.inputType\">\n        <div *ngSwitchCase=\"'text'\" class=\"align-items-center\">\n            <input type=\"text\" [hidden]=\"criteria.controls.operator.value === '<>' || criteria.controls.operator.value === '='\"\n            class=\"form-control filter-criterion-control\" required data-netapp-id=\"filter-searchText\" formControlName=\"value\">\n            <div *ngIf=\"criteria.controls.operator.value === '<>' || criteria.controls.operator.value === '='\" class=\"form-control\">\n                {{'nwfjs:empty' | i18next}}\n            </div>\n        </div>\n\n        <div *ngSwitchCase=\"'number'\" class=\"d-flex align-items-center\">\n            <input type=\"number\" *ngSwitchCase=\"'number'\" class=\"form-control filter-criterion-control\" required data-netapp-id=\"filter-searchText\" formControlName=\"value\"\n                step=\"any\">\n            <!-- unit -->\n            <div class=\"px-2\" *ngIf=\"selectedColumn.unit\" data-netapp-id=\"filter-widget-unit\">{{selectedColumn.unit}}</div>\n        </div>\n        <select class=\"custom-select filter-criterion-control\" data-netapp-id=\"filter-widget-property-options\" required formControlName=\"value\" *ngSwitchCase=\"'select'\">\n            <option [selected]=\"!criteria.value\" value>{{'nwfjs:choose' | i18next}}</option>\n            <option [selected]=\"criteria.value.value == option.id\" *ngFor=\"let option of selectedColumn.editorOptions\" [value]=\"option.id\">{{option.label}}\n                </option>\n        </select>\n\n        <nwf-grid-filter-multiselect [options]=\"selectedColumn.editorOptions\" required *ngSwitchCase=\"'multiselect'\" formControlName=\"value\">\n        </nwf-grid-filter-multiselect>\n\n        <nwf-grid-filter-criterion-date [operator]=\"criteria.controls.operator.value\" *ngSwitchCase=\"'dateTime'\" formControlName=\"value\"></nwf-grid-filter-criterion-date>\n\n        <div *ngIf=\"criteria.invalid && (criteria.controls.value.touched || criteria.controls.value.dirty)\" class=\"invalid-feedback\">\n            <span *ngSwitchCase=\"'select'\">{{'nwfjs:isRequiredInvalidMessage' | i18next}}</span>\n            <span *ngSwitchCase=\"'multiselect'\">{{'nwfjs:isRequiredAtLeastOne' | i18next}}</span>\n            <span *ngSwitchCase=\"'dateTime'\">{{'nwfjs:isInvalidTimeMessage' | i18next}}</span>\n            <span *ngSwitchCase=\"'text'\">{{'nwfjs:isRequiredInvalidMessage' | i18next}}</span>\n            <span *ngSwitchCase=\"'number'\">{{'nwfjs:isNumberInvalidMessage' | i18next}}</span>\n        </div>\n    </div>\n\n    <!-- remove button -->\n    <div class=\"d-flex flex-fill justify-content-end\">\n        <div>\n            <button type=\"button\" class=\"btn btn-default btn-delete-criterion\" data-netapp-id=\"filter-widget-remove-criteria-btn\" (click)=\"deleteCriterion.emit();$event.stopPropagation();\">\n                <nwf-icon iconClass=\"icon-action-delete\"></nwf-icon>\n            </button>\n        </div>\n    </div>\n</div>",
                        styles: [".filter-criterion-control {\n            width: 200px;\n        }"]
                    }] }
        ];
        /** @nocollapse */
        FilterCriterionRowComponent.ctorParameters = function () { return []; };
        FilterCriterionRowComponent.propDecorators = {
            dxColumns: [{ type: i0.Input }],
            criteria: [{ type: i0.Input }],
            deleteCriterion: [{ type: i0.Output }]
        };
        return FilterCriterionRowComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var NwfFilterCriterionDateComponent = /** @class */ (function () {
        function NwfFilterCriterionDateComponent(i18NextPipe) {
            var e_1, _a;
            this.datetime = '';
            // List of default date selections for the user
            this.dateRangeList = [
                { id: 'LAST_1h', label: '' },
                { id: 'LAST_24h', label: '' },
                { id: 'LAST_72h', label: '' },
                { id: 'LAST_7d', label: '' },
                { id: 'LAST_30d', label: '' },
                { id: 'LAST_390d', label: '' },
            ];
            try {
                // i18n the values (displayed label in the drop down)
                for (var _b = __values(this.dateRangeList), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var dateRangeList = _c.value;
                    // pop in the the label translated (the key is e.g. last_1h)
                    dateRangeList.label = i18NextPipe.transform("nwfjs:" + dateRangeList.id.toLowerCase());
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
        }
        /**
         * @param {?} changes
         * @return {?}
         */
        NwfFilterCriterionDateComponent.prototype.ngOnChanges = /**
         * @param {?} changes
         * @return {?}
         */
            function (changes) {
                // on every operator change, we set the dateTime, dateTimeVisibleValue based on operator value.
                // we can have 3 types of operator.
                // 1. <=, >=, 2. between, 3. in the last(last)
                if (!changes.operator.isFirstChange()) {
                    // if current value is <=, >=, we set dateTimeVisibleValue to current Date
                    if (['<=', '>='].indexOf(changes.operator.currentValue) !== -1) {
                        this.datetime = new Date().toISOString();
                        this.datetimeVisibleValue = new Date();
                    }
                    else if (changes.operator.currentValue === 'between') {
                        this.datetime = new Date().toISOString() + "~" + new Date().toISOString();
                    }
                    else {
                        this.datetime = '';
                    }
                    // sending out new value.
                    this.onValueModelChange(this.datetime);
                }
            };
        /**
         * Writes a new value to the element.
         * This method will be called by the forms API to write to the view when programmatic (model -> view) changes are requested.
         * This is incoming 'value' into the component.This value is pre-set value to datetime widget.
         * @param value
         */
        /**
         * Writes a new value to the element.
         * This method will be called by the forms API to write to the view when programmatic (model -> view) changes are requested.
         * This is incoming 'value' into the component.This value is pre-set value to datetime widget.
         * @param {?} value
         * @return {?}
         */
        NwfFilterCriterionDateComponent.prototype.writeValue = /**
         * Writes a new value to the element.
         * This method will be called by the forms API to write to the view when programmatic (model -> view) changes are requested.
         * This is incoming 'value' into the component.This value is pre-set value to datetime widget.
         * @param {?} value
         * @return {?}
         */
            function (value) {
                // we default datetime to last_72h, in case there is no value set.
                this.datetime = value;
                this.datetimeVisibleValue = new Date(this.datetime);
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        NwfFilterCriterionDateComponent.prototype.registerOnChange = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) { this._onChange = fn; };
        /**
         * @param {?} fn
         * @return {?}
         */
        NwfFilterCriterionDateComponent.prototype.registerOnTouched = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) { };
        /**
         * This method is called whenever model tied to the component changes.
         * This is outgoing value from this widget.
         * @param newModelValue
         */
        /**
         * This method is called whenever model tied to the component changes.
         * This is outgoing value from this widget.
         * @param {?} newDateValue
         * @return {?}
         */
        NwfFilterCriterionDateComponent.prototype.onValueModelChange = /**
         * This method is called whenever model tied to the component changes.
         * This is outgoing value from this widget.
         * @param {?} newDateValue
         * @return {?}
         */
            function (newDateValue) {
                this.datetimeVisibleValue = new Date(newDateValue);
                this._onChange(newDateValue);
            };
        NwfFilterCriterionDateComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-grid-filter-criterion-date',
                        template: "\n    <select class=\"form-control mr-2\" required data-netapp-id=\"filter-widget-select-operator\" *ngIf=\"operator === 'lst'\"\n    (change)=\"onValueModelChange($event.target.value)\" [(ngModel)]=\"datetime\">\n        <option [selected]=\"!datetime\" value>{{'nwfjs:choose' | i18next}}</option>\n        <option [selected]=\"datetime == dateRange.id\" *ngFor=\"let dateRange of dateRangeList\" [value]=\"dateRange.id\">{{dateRange.label}}</option>\n    </select>\n\n    <div *ngIf=\"operator === 'between'\" (click)=\"$event.stopPropagation()\">\n        <nwf-datetime-range-picker [(ngModel)]=\"datetime\" (ngModelChange)=\"onValueModelChange($event)\"></nwf-datetime-range-picker>\n    </div>\n\n    <div *ngIf=\"operator === '>=' || operator === '<='\" (click)=\"$event.stopPropagation()\">\n        <ng-template #datetimePickerTemplate>\n            <nwf-datetime-picker [(ngModel)]=\"datetime\" (ngModelChange)=\"onValueModelChange($event)\"></nwf-datetime-picker>\n        </ng-template>\n        <button type=\"button\" class=\"btn btn-default d-flex align-items-center form-control\" [ngbPopover]=\"datetimePickerTemplate\" placement=\"bottom\" data-netapp-id=\"filter-widget-btn\">\n            <nwf-icon iconClass=\"icon-action-calendar\"></nwf-icon>\n            <label data-netapp-id=\"dateTimePicker-widget-label\">{{ datetimeVisibleValue | i18nextFormat: { format: 'datetime' } }}</label>\n        </button>\n    </div>\n    ",
                        providers: [{
                                provide: forms.NG_VALUE_ACCESSOR,
                                useExisting: NwfFilterCriterionDateComponent,
                                multi: true,
                            }]
                    }] }
        ];
        /** @nocollapse */
        NwfFilterCriterionDateComponent.ctorParameters = function () {
            return [
                { type: i1.I18NextPipe }
            ];
        };
        NwfFilterCriterionDateComponent.propDecorators = {
            operator: [{ type: i0.Input }]
        };
        return NwfFilterCriterionDateComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    /** @type {?} */
    var nextId = 0;
    var FilterMultiselectComponent = /** @class */ (function () {
        function FilterMultiselectComponent() {
            this.id = "nwf-filter-multiselect-" + nextId++;
            this.valueModel = {};
            // the private data used within
            this._optionsIconClasses = [
                'ok',
                'warning',
                'critical',
                'error',
                'information',
            ];
            this._valDelimiter = '|';
        }
        /**
         * @param {?} changes
         * @return {?}
         */
        FilterMultiselectComponent.prototype.ngOnChanges = /**
         * @param {?} changes
         * @return {?}
         */
            function (changes) {
                if (changes.options) {
                    // I need to intitalize my options
                    this.setOptionIcons();
                }
            };
        /**
         * Writes a new value to the element.
         * This method will be called by the forms API to write to the view when programmatic (model -> view) changes are requested.
         * This is incoming 'value' into the component. This value is pre-set value to multiselect.
         * @param value
         */
        /**
         * Writes a new value to the element.
         * This method will be called by the forms API to write to the view when programmatic (model -> view) changes are requested.
         * This is incoming 'value' into the component. This value is pre-set value to multiselect.
         * @param {?} value
         * @return {?}
         */
        FilterMultiselectComponent.prototype.writeValue = /**
         * Writes a new value to the element.
         * This method will be called by the forms API to write to the view when programmatic (model -> view) changes are requested.
         * This is incoming 'value' into the component. This value is pre-set value to multiselect.
         * @param {?} value
         * @return {?}
         */
            function (value) {
                var _this = this;
                if (value) {
                    // each multiselect is a string separated by a '|'. So we split the string on '|' to get individual values selected on a multiselect.
                    // eg: a|b|c. This translates to a b c should be selected in multiselect widget, hence setting them to true.
                    value.split(this._valDelimiter).forEach(( /**
                     * @param {?} iValue
                     * @return {?}
                     */function (iValue) { return _this.valueModel[iValue] = true; }));
                }
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        FilterMultiselectComponent.prototype.registerOnChange = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) { this._onChange = fn; };
        /**
         * @param {?} fn
         * @return {?}
         */
        FilterMultiselectComponent.prototype.registerOnTouched = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) { };
        /**
         * This method is called whenever model tied to the component changes. This invoked change handler on the component
         * that can be handled by the widget's consumer.
         * This is outgoing value from this widget.
         */
        /**
         * This method is called whenever model tied to the component changes. This invoked change handler on the component
         * that can be handled by the widget's consumer.
         * This is outgoing value from this widget.
         * @return {?}
         */
        FilterMultiselectComponent.prototype.onValueModelChange = /**
         * This method is called whenever model tied to the component changes. This invoked change handler on the component
         * that can be handled by the widget's consumer.
         * This is outgoing value from this widget.
         * @return {?}
         */
            function () {
                /** @type {?} */
                var vArr = [];
                // looping over the entire object and pulling out keys that have true value
                for (var val in this.valueModel) {
                    // filter out keys whose value is false.
                    if (!this.valueModel[val]) {
                        continue;
                    }
                    vArr.push(val);
                }
                // joining keys by '|' delimiter.
                this._onChange(vArr.join(this._valDelimiter));
            };
        /**
         * This method sets the icon next to option label.
         * It also sets all checkboxes to false initially.
         */
        /**
         * This method sets the icon next to option label.
         * It also sets all checkboxes to false initially.
         * @return {?}
         */
        FilterMultiselectComponent.prototype.setOptionIcons = /**
         * This method sets the icon next to option label.
         * It also sets all checkboxes to false initially.
         * @return {?}
         */
            function () {
                var _this = this;
                // reset model if options are set.
                this.valueModel = {};
                this.options.map(( /**
                 * @param {?} option
                 * @return {?}
                 */function (option) {
                    /** @type {?} */
                    var optionLowercase = option.id.toLowerCase();
                    // setting all checkboxes as unchecked initially.
                    _this.valueModel[option.id] = false;
                    if (_this._optionsIconClasses.indexOf(optionLowercase) !== -1) {
                        option.iconClass = optionLowercase;
                    }
                }));
            };
        FilterMultiselectComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-grid-filter-multiselect',
                        template: "\n    <div class=\"border border-secondary filter-multiselect-list w-100\">\n        <div data-netapp-id=\"filter-multiselect-list-option\" class=\"d-flex align-items-center p-1 filter-multiselect-list-option\" *ngFor=\"let option of options; let i = index\">\n            <div class=\"custom-control custom-checkbox\">\n                <input type=\"checkbox\" id=\"{{id}}-{{i}}\" data-netapp-id=\"filter-multiselect-list-option-checkbox\" class=\"custom-control-input p-2\" name=\"filter-multiselect-list-option-checkbox\"  [(ngModel)]=\"valueModel[option.id]\" (change)=\"onValueModelChange()\">\n                <label class=\"custom-control-label\" for=\"{{id}}-{{i}}\">\n                    <nwf-icon *ngIf=\"option.iconClass\" severity=\"{{option.iconClass}}\" class=\"option-icon\"></nwf-icon>\n                    <span class=\"pl-2\">{{ option.label ? option.label : option.id }}</span>\n                </label>\n            </div>\n        </div>\n    </div>\n    ",
                        providers: [{
                                provide: forms.NG_VALUE_ACCESSOR,
                                useExisting: FilterMultiselectComponent,
                                multi: true,
                            }],
                        styles: [".filter-multiselect-list{max-height:100px;overflow-y:auto}.filter-multiselect-list-option:hover{cursor:pointer}.filter-multiselect-list-option-label{width:170px}"]
                    }] }
        ];
        FilterMultiselectComponent.propDecorators = {
            options: [{ type: i0.Input }],
            id: [{ type: i0.Input }]
        };
        return FilterMultiselectComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var NwfFilterComponent = /** @class */ (function () {
        function NwfFilterComponent(_fb) {
            this._fb = _fb;
            this.nwfFilters = [];
            this.config = FilterConfig;
            this.initialColumns = [];
        }
        /**
         * @return {?}
         */
        NwfFilterComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.dataGrid.onContentReady.subscribe(( /**
                 * @param {?} data
                 * @return {?}
                 */function (data) {
                    _this.gridInstance = data.component.instance();
                    // getting new columns.
                    /** @type {?} */
                    var columnOnDxGrid = _this.getAllColumnsOnDxGrid().map(( /**
                     * @param {?} col
                     * @return {?}
                     */function (col) { return col.dataField; }));
                    // when intialColumns is set, we compare it with columnsOnDxGrid and
                    // and only update intialColumns when its different than columnsOnDxGrid.
                    // This happens when we reset the columns on the grid.
                    if (_this.initialColumns.length !== 0) {
                        /** @type {?} */
                        var areColumnsEqual = lodashEs.isEqual(columnOnDxGrid, _this.initialColumns);
                        // if new columns different than initialColumns, we reset the filter widget.
                        if (!areColumnsEqual) {
                            _this.initialColumns = columnOnDxGrid;
                            // setting the filter widget if columns are not same.
                            _this.setDxGridFilterOnNwfFilterWidget();
                        }
                    }
                    else {
                        // setting the initialColumns.
                        _this.initialColumns = columnOnDxGrid;
                        // setting the filter widget for the first time.
                        _this.setDxGridFilterOnNwfFilterWidget();
                    }
                }));
            };
        /**
         * @return {?}
         */
        NwfFilterComponent.prototype.setDxGridFilterOnNwfFilterWidget = /**
         * @return {?}
         */
            function () {
                // get columns from gridInstance.
                /** @type {?} */
                var gridDxColumns = this.getAllColumnsOnDxGrid();
                // columns having allowFiltering as true are only allowed in the filter widget.
                this.filterableColumns = gridDxColumns.filter(( /**
                 * @param {?} dxColumn
                 * @return {?}
                 */function (dxColumn) { return (dxColumn.allowFiltering && dxColumn.showInColumnChooser); }));
                /** @type {?} */
                var dxGridFilter = this.gridInstance.state().filterValue || [];
                // set value on filter widget.
                this.dxToNwfFilterConverter(dxGridFilter);
                // create the filter form group - its a group of filter criterion.
                this.createFormGroup();
            };
        /**
         * @return {?}
         */
        NwfFilterComponent.prototype.togglePopover = /**
         * @return {?}
         */
            function () {
                this._ngbPopover.toggle();
            };
        /**
         * Creates the form that holds all the filter criterion as formControl inside it.
         * FormGroup holds the state of the filter widget.
         */
        /**
         * Creates the form that holds all the filter criterion as formControl inside it.
         * FormGroup holds the state of the filter widget.
         * @return {?}
         */
        NwfFilterComponent.prototype.createFormGroup = /**
         * Creates the form that holds all the filter criterion as formControl inside it.
         * FormGroup holds the state of the filter widget.
         * @return {?}
         */
            function () {
                var _this = this;
                /** @type {?} */
                var tempFormArray = [];
                // if  nwfFilters, that means filter is preset,
                if (this.nwfFilters.length > 0) {
                    // each nwf filter is represented as a criterion in filter widget.
                    // so now, we loop over all nwfFilters and create criterion for each of them,
                    // and push them into formArray.
                    this.nwfFilters.forEach(( /**
                     * @param {?} c
                     * @return {?}
                     */function (c) {
                        tempFormArray.push(_this.initCriterion(c));
                    }));
                }
                else {
                    // add default criterion.
                    tempFormArray.push(this.initCriterion());
                }
                // filterFormGrp consists of array of crtierions.
                this.filterFormGrp = this._fb.group({
                    criterion: new forms.FormArray(tempFormArray),
                });
            };
        /**
         * @description adds a new default criterion on click of "Add Filter" button
         */
        /**
         * \@description adds a new default criterion on click of "Add Filter" button
         * @return {?}
         */
        NwfFilterComponent.prototype.addCriterion = /**
         * \@description adds a new default criterion on click of "Add Filter" button
         * @return {?}
         */
            function () {
                /** @type {?} */
                var formArray = this.getFormArray();
                // push new formControl(new criterion) to formArray.
                formArray.push(this.initCriterion());
            };
        /**
         * Method to create a new filter criterion. Each filter criterion is form group of 3 form controls.
         * 1. property, 2. operator, 3. value.
         * @param criterion new filter criterion
         */
        /**
         * Method to create a new filter criterion. Each filter criterion is form group of 3 form controls.
         * 1. property, 2. operator, 3. value.
         * @param {?=} criterion new filter criterion
         * @return {?}
         */
        NwfFilterComponent.prototype.initCriterion = /**
         * Method to create a new filter criterion. Each filter criterion is form group of 3 form controls.
         * 1. property, 2. operator, 3. value.
         * @param {?=} criterion new filter criterion
         * @return {?}
         */
            function (criterion) {
                if (criterion === void 0) {
                    criterion = this.getCriterionObject();
                }
                // creating a form group that contains formControl for filter-criterion-row component.
                return this._fb.group({
                    property: new forms.FormControl(criterion.property.dataField),
                    operator: new forms.FormControl(criterion.operator.value),
                    value: new forms.FormControl(criterion.value),
                });
            };
        /**
         * @description deletes a criterion from current criterion, else deletes all the applied criterion. Invoked on clicking Trash icon.
         * @param id
         */
        /**
         * \@description deletes a criterion from current criterion, else deletes all the applied criterion. Invoked on clicking Trash icon.
         * @param {?} criterionIndex
         * @return {?}
         */
        NwfFilterComponent.prototype.deleteCriterion = /**
         * \@description deletes a criterion from current criterion, else deletes all the applied criterion. Invoked on clicking Trash icon.
         * @param {?} criterionIndex
         * @return {?}
         */
            function (criterionIndex) {
                // delete criterion from formArray.
                /** @type {?} */
                var formArray = this.getFormArray();
                // when we have more than 1 criteria, this means we only delete the criterion at that index passed-in
                if (formArray.length > 1) {
                    // deleting criterion from fromArray (formArray is array of criterion)
                    formArray.removeAt(criterionIndex);
                }
                else {
                    // this case applies, when we delete the only available criterion in the filter.
                    // this means delete single/last criterion = filter reset.
                    this.reset();
                }
            };
        /**
         * @description deletes all the criterion.
         */
        /**
         * \@description deletes all the criterion.
         * @return {?}
         */
        NwfFilterComponent.prototype.reset = /**
         * \@description deletes all the criterion.
         * @return {?}
         */
            function () {
                // reset the formArray, so that form will come fresh on hitting filter button again.
                this.filterFormGrp = this._fb.group({
                    criterion: new forms.FormArray([]),
                });
                // clear existing filters and update it on gridInstance.
                this.apply();
                /** @type {?} */
                var formArray = this.getFormArray();
                // Adds the default criterion to filter, which will shown up when filter is opened again.
                formArray.push(this.initCriterion());
            };
        /**
         * @return {?}
         */
        NwfFilterComponent.prototype.getFormArray = /**
         * @return {?}
         */
            function () {
                return ( /** @type {?} */(this.filterFormGrp.get('criterion')));
            };
        /**
         * @description applies the filter on dx grid instance on hitting Apply button.
         */
        /**
         * \@description applies the filter on dx grid instance on hitting Apply button.
         * @return {?}
         */
        NwfFilterComponent.prototype.apply = /**
         * \@description applies the filter on dx grid instance on hitting Apply button.
         * @return {?}
         */
            function () {
                // We touch all formGroups to ensure validation is invoked without manually touching them.
                this.validateAllFormFields(this.filterFormGrp.controls.criterion['controls']);
                // When we click on the submit button, we want to submit the form only if it is valid.
                // To validate all form fields, we need to iterate throughout all form controls and mark them as touched.
                if (this.filterFormGrp.valid) {
                    // set new filters on the grid.
                    this.setFiltersOnDxGridInstance();
                    // closing the popover.
                    this._ngbPopover.close();
                }
            };
        /**
         * @param {?} formControls
         * @return {?}
         */
        NwfFilterComponent.prototype.validateAllFormFields = /**
         * @param {?} formControls
         * @return {?}
         */
            function (formControls) {
                // We mark all formControl as 'touched' programatically,
                // This makes sure Angular validation is triggered for every formControl without
                // touching it manually.
                formControls.forEach(( /**
                 * @param {?} formGroup
                 * @return {?}
                 */function (formGroup) {
                    for (var field in formGroup.controls) {
                        if (formGroup.controls.hasOwnProperty(field)) {
                            /** @type {?} */
                            var control = formGroup.get(field);
                            if (control instanceof forms.FormControl) {
                                control.markAsTouched({ onlySelf: true });
                            }
                        }
                    }
                }));
            };
        /**
         * @return {?}
         */
        NwfFilterComponent.prototype.setFiltersOnDxGridInstance = /**
         * @return {?}
         */
            function () {
                var _this = this;
                // set new filters on gridInstance.
                /** @type {?} */
                var dxFilters = [];
                // start updating the grid instance.
                this.dataGrid.instance.beginUpdate();
                // clearing the existing filters(if any).
                this.dataGrid.instance.option('filterValue', null);
                // this.dataGrid.instance.clearFilter();
                // we loop over filter form group and create an array containing filters in dx compatible format.
                this.filterFormGrp.get('criterion').value.forEach(( /**
                 * @param {?} criterion
                 * @param {?} index
                 * @param {?} array
                 * @return {?}
                 */function (criterion, index, array) {
                    var property = criterion.property, operator = criterion.operator, value = criterion.value;
                    /** @type {?} */
                    var column = _this.getPropertyById(property);
                    switch (column.dataType.toLowerCase()) {
                        case 'datetime':
                        case 'date':
                            switch (operator) {
                                case 'between':
                                    var _a = __read(value.split('~'), 2), fromDateISOString = _a[0], toDateISOString = _a[1];
                                    value = [new Date(fromDateISOString), new Date(toDateISOString)];
                                    break;
                                case '<=':
                                case '>=':
                                    // we convert the value into JS date object, because in this case the value returned from datetime widget is an ISO string.
                                    value = new Date(value);
                                    break;
                                default:
                                    break;
                            }
                            break;
                        case 'enum-multiple':
                            /** @type {?} */
                            var possibleValues = value.split('|');
                            if (operator === '<>') {
                                operator = 'noneof';
                            }
                            else {
                                operator = 'anyof';
                            }
                            value = possibleValues;
                            break;
                        default:
                            break;
                    }
                    //
                    if (array.length === 1) {
                        dxFilters.push(property);
                        dxFilters.push(operator);
                        dxFilters.push(value);
                    }
                    else {
                        dxFilters.push([property, operator, value]);
                        if (index < array.length - 1) {
                            dxFilters.push('and');
                        }
                    }
                }));
                // set filters on gridInstance.
                this.dataGrid.instance.option('filterValue', dxFilters);
                // update nwfFilters with new filters applied.
                // this ensures count shown on filter widget is updated, when new filters are applied.
                this.dxToNwfFilterConverter(dxFilters);
                // end update. this is now gonna fire loadOptions call with new filters.
                this.dataGrid.instance.endUpdate();
            };
        /**
         * @description cancel on hitting 'Cancel' button.
         */
        /**
         * \@description cancel on hitting 'Cancel' button.
         * @return {?}
         */
        NwfFilterComponent.prototype.cancel = /**
         * \@description cancel on hitting 'Cancel' button.
         * @return {?}
         */
            function () {
                // we want to reset the filter widget to the previous state, without submitting any pending changes.
                // we leverage 'createFormGroup' method to set filterWidget state.
                this.createFormGroup();
                // closing the popover.
                this._ngbPopover.close();
            };
        /**
         * @return {?}
         */
        NwfFilterComponent.prototype.getCriterionObject = /**
         * @return {?}
         */
            function () {
                /** @type {?} */
                var firstParam = this.filterableColumns[0];
                return {
                    property: firstParam,
                    operator: this.getOperatorOptions(firstParam.dataType)[0],
                    value: '',
                };
            };
        /**
         * @description fetch the property from the original params passed into the widget.
         * @param id
         */
        /**
         * \@description fetch the property from the original params passed into the widget.
         * @param {?} id
         * @return {?}
         */
        NwfFilterComponent.prototype.getPropertyById = /**
         * \@description fetch the property from the original params passed into the widget.
         * @param {?} id
         * @return {?}
         */
            function (id) {
                return this.filterableColumns.filter(( /**
                 * @param {?} property
                 * @return {?}
                 */function (property) { return property.dataField === id; }))[0];
            };
        /**
         * @description method that return the options from filter config bundle based on the type passed, returns an object containing inputType and options.
         * @param paramType
         */
        /**
         * \@description method that return the options from filter config bundle based on the type passed, returns an object containing inputType and options.
         * @param {?} paramType
         * @return {?}
         */
        NwfFilterComponent.prototype.getOperatorOptions = /**
         * \@description method that return the options from filter config bundle based on the type passed, returns an object containing inputType and options.
         * @param {?} paramType
         * @return {?}
         */
            function (paramType) {
                return this.config[paramType].options;
            };
        /**
         * @description: method to create the applied criteria from appliedFilters coming from filter widget consumer.
         * This allows to preset the filterWidget this it he VALUE of the filter widget.
         * @param
         */
        /**
         * \@description: method to create the applied criteria from appliedFilters coming from filter widget consumer.
         * This allows to preset the filterWidget this it he VALUE of the filter widget.
         * @param {?} dxGridFilters
         * @return {?}
         */
        NwfFilterComponent.prototype.dxToNwfFilterConverter = /**
         * \@description: method to create the applied criteria from appliedFilters coming from filter widget consumer.
         * This allows to preset the filterWidget this it he VALUE of the filter widget.
         * @param {?} dxGridFilters
         * @return {?}
         */
            function (dxGridFilters) {
                var _this = this;
                if (dxGridFilters.length == 3 && this.getPropertyById(dxGridFilters[0])) {
                    this.nwfFilters = [this.getFilterCriterionFromDxFilter(dxGridFilters)];
                }
                else {
                    // multiple filters are connected by an 'and'. So we remove 'and' from dxGridFilter
                    // to get actual filters, and then create filter crtierion from each filter in dxGridFilter.
                    this.nwfFilters = dxGridFilters.filter(( /**
                     * @param {?} filter
                     * @return {?}
                     */function (filter) { return filter !== 'and'; })).map(( /**
                     * @param {?} filter
                     * @return {?}
                     */function (filter) {
                        return _this.getFilterCriterionFromDxFilter(filter);
                    }));
                }
            };
        /**
         * @param {?} filter
         * @return {?}
         */
        NwfFilterComponent.prototype.getFilterCriterionFromDxFilter = /**
         * @param {?} filter
         * @return {?}
         */
            function (filter) {
                var _a = __read(filter, 3), filterName = _a[0], operator = _a[1], value = _a[2];
                // get schema column object based on filterName(id).
                /** @type {?} */
                var schemaColumnObject = this.getPropertyById(filterName);
                // get filter operator options.
                /** @type {?} */
                var operatorOptions = this.getOperatorOptions(schemaColumnObject.dataType);
                // For 'anyof' operator, this means we are in multiselect list case.
                if (operator === 'anyof') {
                    operator = '=';
                    value = value.join('|');
                }
                if (operator === 'noneof') {
                    operator = '<>';
                    value = value.join('|');
                }
                // For 'between' operator we convert the date to ISOString and join the value using '~' sign.
                // This format is required by 'nwf-datetime-range-picker' component
                if (operator === 'between') {
                    value = value.map(( /**
                     * @param {?} val
                     * @return {?}
                     */function (val) { return val.toISOString(); })).join('~');
                }
                // we return property, operator, value which is the format required by filterCriterionRow.
                return {
                    property: schemaColumnObject,
                    operator: operatorOptions.filter(( /**
                     * @param {?} operatorOption
                     * @return {?}
                     */function (operatorOption) { return operatorOption.value === operator; }))[0],
                    value: value,
                };
            };
        /**
         * We find all columns on dx grid. Instead of using a method available on gridInstance directly, we use this way because
         * gridInstance.columnOption gives a complete column object (including default column settings),
         * whereas column object returned by gridInstance.option('columnms') only contains properties you explicitly set.
         * gridInstance.getVisibleColumns() method gives us the complete object but it only works for visible columns.
         */
        /**
         * We find all columns on dx grid. Instead of using a method available on gridInstance directly, we use this way because
         * gridInstance.columnOption gives a complete column object (including default column settings),
         * whereas column object returned by gridInstance.option('columnms') only contains properties you explicitly set.
         * gridInstance.getVisibleColumns() method gives us the complete object but it only works for visible columns.
         * @private
         * @return {?}
         */
        NwfFilterComponent.prototype.getAllColumnsOnDxGrid = /**
         * We find all columns on dx grid. Instead of using a method available on gridInstance directly, we use this way because
         * gridInstance.columnOption gives a complete column object (including default column settings),
         * whereas column object returned by gridInstance.option('columnms') only contains properties you explicitly set.
         * gridInstance.getVisibleColumns() method gives us the complete object but it only works for visible columns.
         * @private
         * @return {?}
         */
            function () {
                /** @type {?} */
                var gridInstance = this.gridInstance;
                /** @type {?} */
                var columnsViaOptions = gridInstance && gridInstance.state().columns;
                if (columnsViaOptions) {
                    return columnsViaOptions.map(( /**
                     * @param {?} __0
                     * @return {?}
                     */function (_a) {
                        var dataField = _a.dataField;
                        return gridInstance.columnOption(dataField);
                    }));
                }
                else {
                    return;
                }
            };
        NwfFilterComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-grid-filter',
                        template: "<ng-template #filterWidgetTemplate>\n    <div *ngIf=\"!filterableColumns\">\n        <div class=\"m-3\">{{'nwfjs:filterWidgetError' | i18next}}</div>\n    </div>\n    <form novalidate autocomplete=\"off\" *ngIf=\"filterableColumns\" [formGroup]=\"filterFormGrp\" (ngSubmit)=\"apply()\">\n        <div formArrayName=\"criterion\">\n            <nwf-grid-filter-criterion-row *ngFor=\"let criteria of filterFormGrp.get('criterion')['controls']; let i=index\" [dxColumns]=\"filterableColumns\"\n                [criteria]=\"criteria\" (deleteCriterion)=\"deleteCriterion(i)\">\n            </nwf-grid-filter-criterion-row>\n        </div>\n\n        <button type=\"button\" *ngIf=\"filterFormGrp.get('criterion')['controls'].length < 4\" class=\"my-3 btn btn-default\" (click)=\"addCriterion();$event.stopPropagation();\"\n            data-netapp-id=\"filter-widget-add-filter-btn\">\n            <nwf-icon iconClass=\"icon-action-add\"></nwf-icon>\n            <span class=\"nwf-icon-label\">{{'nwfjs:filterWidgetAddFilter' | i18next}}</span>\n        </button>\n\n        <div class=\"d-flex\">\n            <button type=\"button\" data-netapp-id=\"filter-widget-remove-btn\" class=\"btn btn-secondary mr-auto\" (click)=\"reset()\" [disabled]=\"nwfFilters.length <= 0\"\n                data-netapp-id=\"filter-widget-reset-btn\">{{'nwfjs:reset' | i18next}}\n            </button>\n            <button type=\"button\" class=\"btn btn-secondary mr-2\" (click)=\"cancel()\" data-netapp-id=\"filter-widget-close-btn\">{{'nwfjs:cancel' | i18next}}</button>\n            <button class=\"btn btn-primary\" type=\"submit\" data-netapp-id=\"filter-widget-apply-btn\">{{'nwfjs:filterWidgetApplyFilter' | i18next}}</button>\n        </div>\n    </form>\n</ng-template>\n<button [ngbPopover]=\"filterWidgetTemplate\" [autoClose]=\"'outside'\" triggers=\"manual\" placement=\"bottom-left\" container=\"body\"\n    (click)=\"togglePopover()\" type=\"button\" class=\"btn btn-flat btn-icon\" data-netapp-id=\"filter-widget-btn\">\n    <nwf-icon iconClass=\"icon-action-filter\"></nwf-icon>\n    <span class=\"badge badge-light\" *ngIf=\"nwfFilters.length > 0\">\n        {{nwfFilters.length}}\n    </span>\n</button>",
                        styles: [".filter-badge-light{background:#1e4a93;color:#fff;font-weight:700}.btn-delete-criterion{height:35px}"]
                    }] }
        ];
        /** @nocollapse */
        NwfFilterComponent.ctorParameters = function () {
            return [
                { type: forms.FormBuilder }
            ];
        };
        NwfFilterComponent.propDecorators = {
            _ngbPopover: [{ type: i0.ViewChild, args: [ngBootstrap.NgbPopover,] }],
            dataGrid: [{ type: i0.Input }]
        };
        return NwfFilterComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var FooterComponent = /** @class */ (function () {
        function FooterComponent(i18NextPipe) {
            this.i18NextPipe = i18NextPipe;
            this.usePagination = true;
            this.isSelectionEnabled = false;
        }
        Object.defineProperty(FooterComponent.prototype, "title", {
            get: /**
             * @return {?}
             */ function () {
                return this.i18NextPipe.transform(this.titleKey, { count: this.selectedRowsCount });
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(FooterComponent.prototype, "titlePlural", {
            get: /**
             * @return {?}
             */ function () {
                return this.i18NextPipe.transform(this.titleKey, { count: 2 });
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        FooterComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.dataGrid.onContentReady.subscribe(( /**
                 * @param {?} data
                 * @return {?}
                 */function (data) {
                    /** @type {?} */
                    var gridInstance = data.component.instance();
                    /** @type {?} */
                    var pageIndex = gridInstance.pageIndex();
                    _this.currentPage = pageIndex + 1;
                    _this.limit = gridInstance.pageSize();
                    _this.offset = _this.limit * pageIndex;
                    _this.totalRecords = gridInstance.totalCount();
                    _this.selectedRowsCount = gridInstance.getSelectedRowKeys().length;
                }));
                // we listen to onSelectionChanged event and update the selected rows count based on that.
                this.dataGrid.onSelectionChanged.subscribe(( /**
                 * @param {?} selectedItems
                 * @return {?}
                 */function (selectedItems) {
                    _this.selectedRowsCount = selectedItems.selectedRowsData.length;
                }));
            };
        /**
         * @param {?} newPageNumber
         * @return {?}
         */
        FooterComponent.prototype.pageChangeHandler = /**
         * @param {?} newPageNumber
         * @return {?}
         */
            function (newPageNumber) {
                this.dataGrid.instance.pageIndex(newPageNumber - 1);
            };
        FooterComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-grid-footer',
                        template: "\n    <nav class=\"navbar navbar-expand-lg bg-light px-2 py-1\" *ngIf=\"totalRecords\">\n        <div class=\"w-100\" *ngIf=\"isSelectionEnabled\">\n            <div data-netapp-id=\"grid-footer-row-selected-count\" *ngIf=\"selectedRowsCount\">\n                {{'nwfjs:gridFooterSelectedCount' | i18next: { title: title, count: selectedRowsCount} }}\n            </div>\n        </div>\n        <div class=\"w-100\" [ngClass]=\"{ 'text-center': isSelectionEnabled }\">\n            <div class=\"paginator-page-info\" data-netapp-id=\"paginator-count-message\"\n            *ngIf=\"usePagination\">\n              {{'nwfjs:paginatorShowRecords' | i18next: { pageStart: offset + 1,\n                pageEnd: offset + limit > totalRecords ? totalRecords : offset + limit ,\n                totalRecords: totalRecords, title: titlePlural } }}\n            </div>\n        </div>\n        <div class=\"w-100 d-flex justify-content-end\">\n            <ng-content *ngIf=\"!usePagination\"></ng-content>\n            <nwf-grid-paginator *ngIf=\"usePagination && totalRecords > 0\" [maxSize]=\"5\"\n            [pageSize]=\"limit\" (pageChange)=\"pageChangeHandler($event)\"\n            [collectionSize]=\"totalRecords\" [(page)]=\"currentPage\" class=\"pagination\">\n            </nwf-grid-paginator>\n        </div>\n    </nav>\n    ",
                        providers: [],
                        styles: [".paginator-page-info { white-space: nowrap; }"]
                    }] }
        ];
        /** @nocollapse */
        FooterComponent.ctorParameters = function () {
            return [
                { type: i1.I18NextPipe }
            ];
        };
        FooterComponent.propDecorators = {
            dataGrid: [{ type: i0.Input }],
            titleKey: [{ type: i0.Input }],
            usePagination: [{ type: i0.Input }],
            isSelectionEnabled: [{ type: i0.Input }]
        };
        return FooterComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var NwfGridOptionsService = /** @class */ (function () {
        function NwfGridOptionsService(columnsChangingService) {
            this.columnsChangingService = columnsChangingService;
        }
        /**
         * Set the global options on the DxDataGrid with defaults from nwfjs and passed in values
         * @param options for overriding the default options
         */
        /**
         * Set the global options on the DxDataGrid with defaults from nwfjs and passed in values
         * @param {?=} options for overriding the default options
         * @return {?}
         */
        NwfGridOptionsService.prototype.setGridDefaultOptions = /**
         * Set the global options on the DxDataGrid with defaults from nwfjs and passed in values
         * @param {?=} options for overriding the default options
         * @return {?}
         */
            function (options) {
                var _this = this;
                if (options === void 0) {
                    options = {};
                }
                DataGrid.defaultOptions(lodashEs.merge({
                    device: { deviceType: 'desktop' },
                    options: {
                        // following options are standard for all nwfjs grids.
                        allowColumnResizing: true,
                        allowColumnReordering: true,
                        showColumnLines: false,
                        showRowLines: true,
                        hoverStateEnabled: true,
                        // this property synchronize the filter row, header filter, and filter builder.
                        // The synchronized filter expression is stored in the filterValue option.
                        filterSyncEnabled: true,
                        // This disables right click context menus.
                        onContextMenuPreparing: 
                        // This disables right click context menus.
                        /**
                         * @param {?} e
                         * @return {?}
                         */
                        function (e) {
                            e.items = [];
                        },
                        onInitialized: ( /**
                         * @param {?} e
                         * @return {?}
                         */function (e) {
                            // Wire onColumnsChanging event to service observable
                            e.component.option('onColumnsChanging', ( /**
                             * @param {?} columnChangeEvent
                             * @return {?}
                             */function (columnChangeEvent) {
                                _this.columnsChangingService.onColumnsChanging(columnChangeEvent);
                            }));
                        }),
                        pager: {
                            visible: false,
                        },
                        scrolling: {
                            useNative: false,
                        },
                    },
                }, options));
            };
        NwfGridOptionsService.decorators = [
            { type: i0.Injectable }
        ];
        /** @nocollapse */
        NwfGridOptionsService.ctorParameters = function () {
            return [
                { type: NwfColumnsChangingService }
            ];
        };
        return NwfGridOptionsService;
    }());
    // Our custom 'lst' operation. This is used by filterWidget 'in the last' operator for datetime values.
    /** @type {?} */
    var NwfFilterBuilderCustomOperations = [{
            name: 'lst',
            caption: 'Last',
            dataTypes: ['date', 'datetime'],
            hasValue: false,
            calculateFilterExpression: /**
             * @param {?} filterValue
             * @param {?} field
             * @return {?}
             */ function (filterValue, field) {
                /** @type {?} */
                var newStartDate = new Date();
                /** @type {?} */
                var hours = new Date().getHours();
                switch (filterValue.toLowerCase()) {
                    case 'last_1h':
                        newStartDate.setHours(hours - 1);
                        break;
                    case 'last_24h':
                        newStartDate.setHours(hours - 24);
                        break;
                    case 'last_72h':
                        newStartDate.setHours(hours - 72);
                        break;
                    case 'last_7d':
                        newStartDate.setHours(hours - (7 * 24));
                        break;
                    case 'last_30d':
                        newStartDate.setHours(hours - (30 * 24));
                        break;
                    case 'last_390d':
                        newStartDate.setHours(hours - (390 * 24));
                        break;
                }
                return [[field.dataField, '>=', newStartDate], 'and', [field.dataField, '<=', new Date()]];
            },
        }];

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var NwfGridPaginatorComponent = /** @class */ (function (_super) {
        __extends(NwfGridPaginatorComponent, _super);
        function NwfGridPaginatorComponent() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        NwfGridPaginatorComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-grid-paginator',
                        template: "\n    <ul [class]=\"'pagination' + (size ? ' pagination-' + size : '')\">\n      <li *ngIf=\"boundaryLinks\" class=\"page-item\"\n        [class.disabled]=\"!hasPrevious() || disabled\">\n        <a aria-label=\"First\" i18n-aria-label=\"@@ngb.pagination.first-aria\" class=\"page-link\" href\n          (click)=\"selectPage(1); $event.preventDefault()\" [attr.tabindex]=\"(hasPrevious() ? null : '-1')\">\n          <span aria-hidden=\"true\" i18n=\"@@ngb.pagination.first\">&laquo;&laquo;</span>\n        </a>\n      </li>\n\n      <li *ngIf=\"directionLinks\" class=\"page-item\"\n        [class.disabled]=\"!hasPrevious() || disabled\">\n        <a aria-label=\"Previous\" i18n-aria-label=\"@@ngb.pagination.previous-aria\" class=\"page-link\" href\n          (click)=\"selectPage(page-1); $event.preventDefault()\" [attr.tabindex]=\"(hasPrevious() ? null : '-1')\">\n          <span aria-hidden=\"true\" i18n=\"@@ngb.pagination.previous\">&laquo;</span>\n        </a>\n      </li>\n      <li *ngFor=\"let pageNumber of pages\" class=\"page-item\" [class.active]=\"pageNumber === page\"\n        [class.disabled]=\"isEllipsis(pageNumber) || disabled\">\n        <a *ngIf=\"isEllipsis(pageNumber)\" class=\"page-link\">...</a>\n        <a *ngIf=\"!isEllipsis(pageNumber)\" class=\"page-link\" href (click)=\"selectPage(pageNumber); $event.preventDefault()\">\n          {{pageNumber}}\n          <span *ngIf=\"pageNumber === page\" class=\"sr-only\">(current)</span>\n        </a>\n      </li>\n      <li *ngIf=\"directionLinks\" class=\"page-item\" [class.disabled]=\"!hasNext() || disabled\">\n        <a aria-label=\"Next\" i18n-aria-label=\"@@ngb.pagination.next-aria\" class=\"page-link\" href\n          (click)=\"selectPage(page+1); $event.preventDefault()\" [attr.tabindex]=\"(hasNext() ? null : '-1')\">\n          <span aria-hidden=\"true\" i18n=\"@@ngb.pagination.next\">&raquo;</span>\n        </a>\n      </li>\n\n      <li *ngIf=\"boundaryLinks\" class=\"page-item\" [class.disabled]=\"!hasNext() || disabled\">\n        <a aria-label=\"Last\" i18n-aria-label=\"@@ngb.pagination.last-aria\" class=\"page-link\" href\n          (click)=\"selectPage(pageCount); $event.preventDefault()\" [attr.tabindex]=\"(hasNext() ? null : '-1')\">\n          <span aria-hidden=\"true\" i18n=\"@@ngb.pagination.last\">&raquo;&raquo;</span>\n        </a>\n      </li>\n    </ul>\n    ",
                        styles: [".page-item.active .btn{color:#454545!important;font-weight:700;pointer-events:none}.page-item.disabled .btn{pointer-events:none;color:#9c9c9c}ul{margin-bottom:0}"]
                    }] }
        ];
        return NwfGridPaginatorComponent;
    }(ngBootstrap.NgbPagination));

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var SearchComponent = /** @class */ (function () {
        function SearchComponent(i18NextPipe) {
            this.i18NextPipe = i18NextPipe;
            this.keyUp = new rxjs.Subject();
            this.value = '';
        }
        Object.defineProperty(SearchComponent.prototype, "type", {
            get: /**
             * @return {?}
             */ function () {
                return this.i18NextPipe.transform(this.typeKey);
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        SearchComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.dataGrid.onContentReady.subscribe(( /**
                 * @param {?} data
                 * @return {?}
                 */function (data) {
                    /** @type {?} */
                    var gridInstance = data.component.instance();
                    _this.value = gridInstance.state().searchText;
                    _this.setSearchOnDxGrid();
                }));
                // on keyUp, we get the value of the event,
                // wait for 3s, and then set the search on dxGridInstance.
                this.keyUp
                    .pipe(operators.map(( /**
             * @param {?} event
             * @return {?}
             */function (event) { return event.target.value; })))
                    .pipe(operators.debounceTime(300))
                    .subscribe(( /**
             * @return {?}
             */function () { return _this.setSearchOnDxGrid(); }));
            };
        /**
         * Method to reset the input to empty, and update dxGrid instance.
         */
        /**
         * Method to reset the input to empty, and update dxGrid instance.
         * @return {?}
         */
        SearchComponent.prototype.resetInput = /**
         * Method to reset the input to empty, and update dxGrid instance.
         * @return {?}
         */
            function () {
                this.value = '';
                this.setSearchOnDxGrid();
            };
        /**
         * @return {?}
         */
        SearchComponent.prototype.setSearchOnDxGrid = /**
         * @return {?}
         */
            function () {
                // apply search text.
                this.dataGrid.instance.searchByText(this.value);
            };
        SearchComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-grid-search',
                        template: "<div class=\"btn-group\">\n    <nwf-icon iconClass=\"icon-view-search\" class=\"text-secondary grid-search-icon\"></nwf-icon>\n    <input #searchInput class=\"form-control grid-search-input\" type=\"text\" (keyup)=\"keyUp.next($event)\" [placeholder]=\"'nwfjs:searchPlaceholderText' | i18next: { type: type }\"\n    [(ngModel)]=\"value\" data-netapp-id=\"angular-search-enter-input\" name=\"angular-grid-search-input\">\n    <div (click)=\"resetInput()\" *ngIf=\"value?.length\" class=\"grid-search-clear-icon\">\n    <nwf-icon iconClass=\"icon-action-close\" data-netapp-id=\"search-clear-input\"></nwf-icon>\n    </div>\n    </div>",
                        styles: ["::host{white-space:nowrap}.text-secondary{position:absolute;display:flex;align-items:center;left:10px;height:100%}.grid-search-input{text-indent:20px;width:250px}.grid-search-input::-ms-clear{display:none}.grid-search-clear-icon{z-index:100;position:absolute;display:flex;align-items:center;right:5px;top:8px;cursor:pointer}"]
                    }] }
        ];
        /** @nocollapse */
        SearchComponent.ctorParameters = function () {
            return [
                { type: i1.I18NextPipe }
            ];
        };
        SearchComponent.propDecorators = {
            typeKey: [{ type: i0.Input }],
            dataGrid: [{ type: i0.Input }]
        };
        return SearchComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    /** @type {?} */
    var allComponents = [
        NwfGridPaginatorComponent, SearchComponent, ColumnChooserComponent, ColumnVisibilityComponent,
        NwfFilterComponent, FilterMultiselectComponent, FilterCriterionRowComponent,
        NwfFilterCriterionDateComponent, FooterComponent, CellsComponent,
    ];
    var NwfGridModule = /** @class */ (function () {
        function NwfGridModule() {
        }
        NwfGridModule.decorators = [
            { type: i0.NgModule, args: [{
                        imports: [
                            ngBootstrap.NgbModule,
                            common.CommonModule,
                            i2.BrowserModule,
                            forms.ReactiveFormsModule,
                            forms.FormsModule,
                            i1.I18NextModule,
                            NwfjsSharedComponentsModule,
                            devextremeAngular.DxDataGridModule,
                            devextremeAngular.DxScrollViewModule,
                            NwfjsSharedPipesModule,
                        ],
                        providers: [NwfGridOptionsService],
                        declarations: allComponents,
                        exports: allComponents,
                    },] }
        ];
        /** @nocollapse */
        NwfGridModule.ctorParameters = function () { return []; };
        return NwfGridModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var AboutModalComponent = /** @class */ (function () {
        function AboutModalComponent(activeModal) {
            this.activeModal = activeModal;
        }
        /**
         * @return {?}
         */
        AboutModalComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
            };
        AboutModalComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-about-modal',
                        template: "\n  <div class=\"modal-header\">\n    <h5 class=\"modal-title\">{{ 'nwfjs:aboutProduct' | i18next: {productName: productName} }}</h5>\n</div>\n<div class=\"modal-body\">\n    <div class=\"nwf-about-main-panel\">\n\n        <!-- First row -->\n        <div class=\"nwf-about-row\">\n            <!-- Content panel\n                    This has 3 login cells. 1. Logo, 2. vertical line and 3. company information -->\n            <div class=\"nwf-about-cell\">\n                <div class=\"nwf-about-logo-panel\">\n                    <!-- Application logo-->\n                    <div class=\"nwf-about-row\">\n                        <div class=\"nwf-about-logo\"></div>\n                    </div>\n                </div>\n\n            </div>\n\n            <div class=\"nwf-about-cell\">\n                <!-- Form panel inline-table-->\n                <div class=\"nwf-about-form-panel\">\n\n                    <!-- This is just the one that is handed in -->\n\n                    <!-- Product name -->\n                    <div class=\"nwf-about-row\" *ngIf=\"productName\">\n                        <p class=\"nwf-about-product-name\" data-netapp-id=\"aboutDialog-product-name\">\n                            {{productName}}\n                        </p>\n                    </div>\n\n                    <!-- Version number -->\n                    <div class=\"nwf-about-row\" *ngIf=\"version\">\n                        <p class=\"nwf-about-version-number\" data-netapp-id=\"aboutDialog-version\">\n                            {{'nwfjs:version' | i18next:{version: version} }}\n                        </p>\n                    </div>\n\n                    <!-- System ID -->\n                    <div class=\"nwf-about-row\" *ngIf=\"systemId\">\n                        <p class=\"nwf-about-version-number\" data-netapp-id=\"aboutDialog-UUID\">\n                            {{'nwfjs:systemId' | i18next:{systemId: systemId} }}\n                        </p>\n                    </div>\n\n                    <!-- Session ID -->\n                    <div class=\"nwf-about-row\" *ngIf=\"sessionId\">\n                        <p class=\"nwf-about-sessionId\" data-netapp-id=\"aboutDialog-UUID\">\n                            {{'nwfjs:sessionId' | i18next:{sessionId: sessionId} }}\n                        </p>\n                    </div>\n\n\n                    <!-- Confidentiality text -->\n                    <div class=\"nwf-about-row\">\n                        <p class=\"nwf-about-confidentiality-text\" data-netapp-id=\"aboutDialog-conftext\">\n                            {{confText}}\n                        </p>\n                    </div>\n\n                    <!-- Copyright information  -->\n                    <div class=\"nwf-about-row\">\n                        <p class=\"nwf-about-copyright-info\">\n                            <span class=\"copyright-symbol\">&copy; &nbsp;</span>{{copyright}}\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n<div class=\"modal-footer\">\n    <button class=\"btn btn-primary\" (click)=\"activeModal.close()\" data-netapp-id=\"aboutDialog-ok-button\" autofocus>{{'nwfjs:OK' | i18next}}</button>\n</div>\n\n  ",
                        styles: [".nwf-about-row{display:table-row}.nwf-about-main-panel{display:table;height:100%;width:100%;padding:20px}.nwf-about-header{height:100%;width:100%;margin:0;background-color:#fff;color:#fff;padding:0}.nwf-about-logo{background-image:url(data:image/png;base64,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);background-repeat:no-repeat;width:77px;height:89px;margin-top:6px}.nwf-about-brand-logo{vertical-align:middle;display:inline-block}.nwf-about-vert-line{padding:0 29px}.nwf-about-form-panel{display:inline-table;vertical-align:middle;padding-left:25px}.nwf-about-logo-panel{display:inline-table}.nwf-about-sessionId,.nwf-about-systemId,.nwf-about-version-number{color:#0067c5;display:table-cell;padding-bottom:10px}.nwf-about-product-name{font-size:20px;color:#0067c5;display:table-cell;padding-bottom:10px}.nwf-about-confidentiality-text{color:#454545;text-transform:uppercase;display:table-cell;padding-bottom:10px}.nwf-about-copyright-info{color:#454545;display:table-cell;padding-bottom:10px}.nwf-about-center-cell{display:table-cell;text-align:center}.nwf-about-cell{display:table-cell;vertical-align:top}.copyright-symbol{font-family:Arial,\"Helvetica Neue\",Helvetica,sans-serif;font-size:12px}"]
                    }] }
        ];
        /** @nocollapse */
        AboutModalComponent.ctorParameters = function () {
            return [
                { type: ngBootstrap.NgbActiveModal }
            ];
        };
        return AboutModalComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var AboutComponent = /** @class */ (function () {
        function AboutComponent(modalService) {
            this.modalService = modalService;
        }
        /**
         * @param {?} e
         * @return {?}
         */
        AboutComponent.prototype.onClick = /**
         * @param {?} e
         * @return {?}
         */
            function (e) {
                /** @type {?} */
                var modalRef = this.modalService.open(AboutModalComponent);
                /** @type {?} */
                var ci = modalRef.componentInstance;
                /* I'd like a cleaner way to do this, but this works for now */
                ci.productName = this.productName;
                ci.version = this.version;
                ci.systemId = this.systemId;
                ci.confText = this.confText;
                ci.copyright = this.copyright;
            };
        /**
         * @return {?}
         */
        AboutComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
            };
        AboutComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-about',
                        host: {
                            class: 'dropdown-item',
                        },
                        template: "{{\"nwfjs:about\" | i18next}}"
                    }] }
        ];
        /** @nocollapse */
        AboutComponent.ctorParameters = function () {
            return [
                { type: ngBootstrap.NgbModal }
            ];
        };
        AboutComponent.propDecorators = {
            productName: [{ type: i0.Input }],
            version: [{ type: i0.Input }],
            systemId: [{ type: i0.Input }],
            confText: [{ type: i0.Input }],
            copyright: [{ type: i0.Input }],
            onClick: [{ type: i0.HostListener, args: ['click', ['$event'],] }]
        };
        return AboutComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var AppTitleComponent = /** @class */ (function () {
        function AppTitleComponent() {
            this.showLogo = true;
        }
        AppTitleComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-app-title',
                        host: {
                            class: 'navbar-brand mr-auto ml-2 p-0',
                        },
                        template: "\n    <div class=\"d-inline-flex align-items-center\">\n    <nwf-icon *ngIf=\"showLogo\" iconClass=\"icon-nav-ngraphic-titlebar\"></nwf-icon>\n    <div class=\"nwf-app-title\">\n    {{title}}\n      <span class=\"pl-2\" *ngIf=\"extraHref && extraHrefLabel\"><a class=\"nwf-app-title-extra\" href=\"{{extraHref}}\">{{extraHrefLabel}}</a></span>\n    </div>\n    </div>\n  ",
                        styles: [":host{color:#fff}.nwf-app-title{font-size:24px;font-weight:400}.l-nwf-app-title-extra{vertical-align:middle}.nwf-app-title-extra{color:inherit;font-size:12px}"]
                    }] }
        ];
        /** @nocollapse */
        AppTitleComponent.ctorParameters = function () { return []; };
        AppTitleComponent.propDecorators = {
            title: [{ type: i0.Input }],
            extraHref: [{ type: i0.Input }],
            extraHrefLabel: [{ type: i0.Input }],
            showLogo: [{ type: i0.Input }]
        };
        return AppTitleComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var GlobalSearchComponent = /** @class */ (function () {
        function GlobalSearchComponent() {
        }
        /**
         * @return {?}
         */
        GlobalSearchComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
            };
        /**
         * @return {?}
         */
        GlobalSearchComponent.prototype.focusInput = /**
         * @return {?}
         */
            function () {
                this.inputEl.nativeElement.focus();
            };
        GlobalSearchComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-global-search-input',
                        template: "<div class=\"input-group\">\n  <label class=\"sr-only\" for=\"global-search\">Search</label>\n  <input class=\"form-control py-2 border-0\" type=\"search\" value=\"search\" id=\"global-search\" #globalSearch>\n  <span class=\"input-group-append\" (click)=\"focusInput()\">\n    <div class=\"input-group-text border-0\"><nwf-icon iconClass=\"icon-view-search\"></nwf-icon></div>\n  </span>\n</div>",
                        styles: ["input{width:300px;background-color:#173e77;border-color:#173e77}.input-group-text{background-color:#173e77;color:#fff}"]
                    }] }
        ];
        /** @nocollapse */
        GlobalSearchComponent.ctorParameters = function () { return []; };
        GlobalSearchComponent.propDecorators = {
            inputEl: [{ type: i0.ViewChild, args: ['globalSearch',] }]
        };
        return GlobalSearchComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var GlobalnavPrimaryCenterComponent = /** @class */ (function () {
        function GlobalnavPrimaryCenterComponent() {
        }
        GlobalnavPrimaryCenterComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-globalnav-primary-center',
                        host: {
                            class: 'd-flex justify-content-center flex-grow-1',
                        },
                        template: "\n  <ng-content></ng-content>\n  ",
                        styles: [""]
                    }] }
        ];
        /** @nocollapse */
        GlobalnavPrimaryCenterComponent.ctorParameters = function () { return []; };
        return GlobalnavPrimaryCenterComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var GlobalnavPrimaryToolsComponent = /** @class */ (function () {
        function GlobalnavPrimaryToolsComponent() {
            this.isCollapsed = true;
        }
        GlobalnavPrimaryToolsComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-globalnav-primary-tools',
                        host: {
                            class: 'text-nowrap h-100',
                        },
                        template: "\n\n\n<ng-content></ng-content>\n\n\n  ",
                        styles: [":host ::ng-deep .nwf-admin-nav-menu{display:flex;margin:0;padding-left:0;align-items:center;height:100%}:host ::ng-deep .nwf-admin-nav-menu>li{height:100%;width:100%;color:#fff;list-style-type:none}:host ::ng-deep .nwf-admin-nav-menu>li:hover{color:#4faaff}:host ::ng-deep .nwf-admin-nav-menu .dropdown-toggle::after{display:none}:host ::ng-deep .nwf-admin-nav-menu-item{height:100%;color:inherit;display:flex;padding-left:15px;padding-right:15px;align-content:center;cursor:pointer}:host ::ng-deep .nwf-admin-nav-menu-item[aria-expanded=true]{background-color:#0a2d6c}"]
                    }] }
        ];
        return GlobalnavPrimaryToolsComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var GlobalnavPrimaryComponent = /** @class */ (function () {
        function GlobalnavPrimaryComponent(leftnavService) {
            this.leftnavService = leftnavService;
        }
        GlobalnavPrimaryComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-globalnav-primary',
                        host: {
                            class: 'navbar navbar-expand-md flex-nowrap p-0',
                        },
                        template: "\n  <button class=\"btn leftnav-toggler rounded-0 h-100 p-0 shadow-none\" type=\"button\" (click)=\"leftnavService.toggle()\">\n  <nwf-icon iconClass=\"icon-nav-menu\"></nwf-icon>\n  </button>\n  <ng-content></ng-content>\n  ",
                        styles: [":host{height:53px;background-color:#1e4a93;box-shadow:0 3px 0 0 rgba(0,0,0,.08)}.leftnav-toggler{color:#fff;width:53px;min-width:53px;background-color:#0a2d6c}.leftnav-toggler:focus{box-shadow:none!important}.leftnav-toggler:hover{color:#4faaff}"]
                    }] }
        ];
        /** @nocollapse */
        GlobalnavPrimaryComponent.ctorParameters = function () {
            return [
                { type: NwfLeftnavService }
            ];
        };
        return GlobalnavPrimaryComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var GlobalnavSecondaryMenusComponent = /** @class */ (function () {
        function GlobalnavSecondaryMenusComponent() {
        }
        /**
         * @return {?}
         */
        GlobalnavSecondaryMenusComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
            };
        GlobalnavSecondaryMenusComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-globalnav-secondary-menus',
                        template: "\n  <ng-content></ng-content>\n   ",
                        styles: [":host{display:flex}:host ::ng-deep .nwf-globalnav-secondary-menu{padding:0;margin:0;list-style-type:none;white-space:nowrap;display:flex}:host ::ng-deep .nwf-globalnav-secondary-menu>li{display:flex;align-items:center;border-right:1px solid #c2c2c2;background-color:#f2f2f2}:host ::ng-deep .nwf-globalnav-secondary-menu>li:first-child{border-left:1px solid #c2c2c2}:host ::ng-deep .nwf-globalnav-secondary-menu>li.open{border-bottom-color:transparent;background-color:#fff}:host ::ng-deep .nwf-globalnav-secondary-menu-item{height:41px;line-height:41px;padding:0 10px;color:#000}"]
                    }] }
        ];
        /** @nocollapse */
        GlobalnavSecondaryMenusComponent.ctorParameters = function () { return []; };
        return GlobalnavSecondaryMenusComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var GlobalnavSecondarySearchComponent = /** @class */ (function () {
        function GlobalnavSecondarySearchComponent() {
        }
        /**
         * @return {?}
         */
        GlobalnavSecondarySearchComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
            };
        GlobalnavSecondarySearchComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-globalnav-secondary-search',
                        host: {
                            class: 'navbar-nav ml-auto',
                        },
                        template: "\n  <ng-content></ng-content>\n   ",
                        styles: ["\n  :host {\n\n}\n"]
                    }] }
        ];
        /** @nocollapse */
        GlobalnavSecondarySearchComponent.ctorParameters = function () { return []; };
        return GlobalnavSecondarySearchComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var GlobalnavSecondaryComponent = /** @class */ (function () {
        function GlobalnavSecondaryComponent() {
        }
        GlobalnavSecondaryComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-globalnav-secondary',
                        host: {
                            class: 'navbar navbar-expand p-0',
                        },
                        template: "\n  <ng-content></ng-content>\n   ",
                        styles: [":host{background-color:#f2f2f2}"]
                    }] }
        ];
        /** @nocollapse */
        GlobalnavSecondaryComponent.ctorParameters = function () { return []; };
        return GlobalnavSecondaryComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var GlobalnavComponent = /** @class */ (function () {
        function GlobalnavComponent() {
        }
        /**
         * @return {?}
         */
        GlobalnavComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () { };
        GlobalnavComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-globalnav',
                        host: {
                            class: 'fixed-top',
                        },
                        template: "<ng-content></ng-content>",
                        styles: [""]
                    }] }
        ];
        /** @nocollapse */
        GlobalnavComponent.ctorParameters = function () { return []; };
        return GlobalnavComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var LeftnavItemComponent = /** @class */ (function () {
        function LeftnavItemComponent(stateService) {
            this.stateService = stateService;
            this.isTopLevel = false;
        }
        /**
         * @return {?}
         */
        LeftnavItemComponent.prototype.toggleCollapsed = /**
         * @return {?}
         */
            function () {
                this.item.isCollapsed = !this.item.isCollapsed;
            };
        /**
         * @return {?}
         */
        LeftnavItemComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
            };
        /**
         * @return {?}
         */
        LeftnavItemComponent.prototype.onClick = /**
         * @return {?}
         */
            function () {
                if (this.item.children) {
                    this.toggleCollapsed();
                }
                else if (this.stateService.$current.parent.name === this.item.sref) {
                    this.stateService.go('^', {}, { reload: true });
                }
                else {
                    this.stateService.go(this.item.sref, this.item.srefParams);
                }
            };
        LeftnavItemComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: '[nwfLeftnavItem]',
                        template: "\n\n<!-- the item -->\n  <a class=\"nwf-leftnav-item-link flex-grow-1\" (click)=\"onClick()\"\n  attr.data-netapp-id=\"leftnav-item-{{item.label | lowercase}}-link\"\n  [ngClass]=\"{'is-active': item.isActive, 'is-toplevel': isTopLevel, 'is-open': !item.isCollapsed }\"\n  [nwfFeatureTour]=\"item.featureTourComponent ? 'leftNav-' + item.featureTourOrder : null\"\n  [component]=\"item.featureTourComponent || null\"\n  [item]=\"item\">\n  <span *ngIf=\"item.icon && false\" class=\"nwf-leftnav-item-icon\">\n  <nwf-icon [iconClass]=\"item.icon\"></nwf-icon>\n  </span>\n  <span class=\"nwf-leftnav-item-label\">{{item.label | i18next }}</span>\n  <nwf-icon class=\"nwf-leftnav-item-toggler\" *ngIf=\"item.children && item.children.length\" [iconClass]=\"item.isCollapsed ? 'icon-misc-chevrondown' : 'icon-misc-chevronup'\"></nwf-icon>\n  </a>\n\n\n  <ul *ngIf=\"item.children?.length\" class=\"nwf-leftnav-items pl-0\" [ngbCollapse]=\"item.isCollapsed\" attr.data-netapp-id=\"leftnav-item-group-{{item.label | lowercase}}\">\n    <li *ngFor=\"let item of item.children | keyvalue\" nwfLeftnavItem [item]=\"item.value\" class=\"nwf-leftnav-item is-submenu d-block flex-grow-1\" attr.data-netapp-id=\"leftnav-item-{{item.value.label | lowercase}}\"></li>\n  </ul>",
                        providers: [ngBootstrap.NgbCollapse],
                        styles: [":host{color:#fff;line-height:16px}:host:hover{color:#fff}:host[istoplevel]:first-child{border-top:1px solid #08214b}:host[istoplevel] ul{border-bottom:1px solid #08214b}a.nwf-leftnav-item-link{display:flex;align-items:center;padding:8px 8px 8px 12px;text-transform:capitalize;font-weight:400;letter-spacing:0}a.nwf-leftnav-item-link:hover{background:#7ba1e5}a.nwf-leftnav-item-link:hover ::ng-deep #base-layer{fill:#fff}a.nwf-leftnav-item-link.is-active{background-color:#a5bfed;color:#131313}a.nwf-leftnav-item-link.is-open{border-bottom:none!important}a.nwf-leftnav-item-link.is-toplevel{border-bottom:1px solid #08214b;padding:12px;border-left:4px solid transparent;letter-spacing:1px;font-weight:700;text-transform:uppercase}a.nwf-leftnav-item-link.is-toplevel.is-active{color:#fff;background-color:#08214b;border-left-color:#a5bfed}a.nwf-leftnav-item-link.is-toplevel.is-active:hover{background-color:#030d1d}a.nwf-leftnav-item-link:not([href]){cursor:pointer}nwf-icon.nwf-leftnav-item-toggler{margin-right:12px}nwf-icon.nwf-leftnav-item-toggler ::ng-deep #base-layer{fill:#a5bfed}.nwf-leftnav-item-label{margin-left:12px;flex-grow:1}.is-submenu .nwf-leftnav-item-label{margin-left:16px}"]
                    }] }
        ];
        /** @nocollapse */
        LeftnavItemComponent.ctorParameters = function () {
            return [
                { type: core.StateService }
            ];
        };
        LeftnavItemComponent.propDecorators = {
            item: [{ type: i0.Input }],
            isTopLevel: [{ type: i0.Input }]
        };
        return LeftnavItemComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var LeftnavComponent = /** @class */ (function () {
        function LeftnavComponent(leftnavService, transitionService, stateService) {
            this.leftnavService = leftnavService;
            this.transitionService = transitionService;
            this.stateService = stateService;
            this.keepOtherSectionsOpen = true;
        }
        /**
         * @return {?}
         */
        LeftnavComponent.prototype.repaintStateHighlight = /**
         * @return {?}
         */
            function () {
                var _this = this;
                var _a = this.stateService, current = _a.current, params = _a.params;
                setTimeout(( /**
                 * @return {?}
                 */function () { _this.markActiveState(_this.navData, current, params); }), 0);
            };
        /**
         * @return {?}
         */
        LeftnavComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                var _this = this;
                // Set my navData on the leftnavService so others (like feature tour ) can open a tree of items programatically.
                this.leftnavService.navData = this.navData;
                /* On Enter I recurse to find out what to highlight */
                this.transitionService.onSuccess({}, ( /**
                 * @param {?} trans
                 * @return {?}
                 */function (trans) {
                    _this.repaintStateHighlight();
                }));
                this.closeAll(this.navData);
                /* I have to find out on load where I am as well */
                this.repaintStateHighlight();
            };
        /*
         * Recurse through the navData, marking the active state, and
         * all its parents. Return true if we found a match.
         * An item is active if it's name and params matches
         * An item is also active if any of it's child is active.
         */
        /*
           * Recurse through the navData, marking the active state, and
           * all its parents. Return true if we found a match.
           * An item is active if it's name and params matches
           * An item is also active if any of it's child is active.
           */
        /**
         * @param {?} navData
         * @param {?} state
         * @param {?=} params
         * @return {?}
         */
        LeftnavComponent.prototype.markActiveState = /*
           * Recurse through the navData, marking the active state, and
           * all its parents. Return true if we found a match.
           * An item is active if it's name and params matches
           * An item is also active if any of it's child is active.
           */
            /**
             * @param {?} navData
             * @param {?} state
             * @param {?=} params
             * @return {?}
             */
            function (navData, state, params) {
                var _this = this;
                if (params === void 0) {
                    params = null;
                }
                return lodashEs.reduce(navData, ( /**
                 * @param {?} matched
                 * @param {?} item
                 * @return {?}
                 */function (matched, item) {
                    /** @type {?} */
                    var matchesChild = false;
                    if (item.children) {
                        matchesChild = _this.markActiveState(item.children, state, params);
                    }
                    if (_this.keepOtherSectionsOpen) {
                        /* If it's already open leave if; if it needs to be open, do it */
                        if (matchesChild) {
                            item.isCollapsed = false;
                        }
                    }
                    else {
                        item.isCollapsed = !matchesChild;
                    }
                    /** @type {?} */
                    var hasNameMatch = ((state.name === item.sref) || (state.parent === item.sref));
                    /** @type {?} */
                    var hasParamMatch = lodashEs.isMatch(params, item.srefParams || {});
                    item.isActive = matchesChild
                        || (hasNameMatch && hasParamMatch);
                    matched = matched || item.isActive;
                    return matched;
                }), false);
            };
        /**
         * @param {?} navData
         * @return {?}
         */
        LeftnavComponent.prototype.closeAll = /**
         * @param {?} navData
         * @return {?}
         */
            function (navData) {
                var _this = this;
                lodashEs.forEach(navData, ( /**
                 * @param {?} item
                 * @return {?}
                 */function (item) {
                    item.isCollapsed = true;
                    if (navData.children) {
                        _this.closeAll(navData.children);
                    }
                }));
            };
        LeftnavComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-left-nav',
                        template: "\n  <dx-scroll-view>\n  <nav class=\"leftnav\" role=\"navigation\">\n  <ul class=\"nwf-leftnav-items p-0 m-0\">\n      <li class=\"nwf-leftnav-item d-block\" *ngFor=\"let item of navData | keyvalue\" nwfLeftnavItem isTopLevel=\"true\" [item]=\"item.value\" attr.data-netapp-id=\"leftnav-item-{{item.value.label | lowercase}}\"></li>\n  </ul>\n  </nav>\n  </dx-scroll-view>\n  ",
                        styles: ["nav.leftnav{display:flex;flex-direction:column;font-size:90%;top:0;padding-top:25px;overflow-x:hidden;overflow-y:auto;position:-webkit-sticky;position:sticky}"]
                    }] }
        ];
        /** @nocollapse */
        LeftnavComponent.ctorParameters = function () {
            return [
                { type: NwfLeftnavService },
                { type: core.TransitionService },
                { type: core.StateService }
            ];
        };
        LeftnavComponent.propDecorators = {
            navData: [{ type: i0.Input }]
        };
        return LeftnavComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var LoginFailedComponent = /** @class */ (function () {
        function LoginFailedComponent(activeModal) {
            this.activeModal = activeModal;
        }
        /**
         * @return {?}
         */
        LoginFailedComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
            };
        LoginFailedComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-login-failed',
                        template: "\n  <div class=\"modal-content\">\n  <div class=\"modal-header is-error\">\n      <nwf-icon *ngIf=\"errorCode !== 0\" iconClass=\"icon-status-warning\"></nwf-icon>\n      <nwf-icon *ngIf=\"errorCode === 0\" iconClass=\"icon-status-error-full\"></nwf-icon>\n      <h5 class=\"modal-title\" data-netapp-id=\"loginPage-errorDialog-title\">{{'nwfjs:error' | i18next}}</h5>\n  </div>\n  <div class=\"modal-body\" data-netapp-id=\"loginPage-errorDialog-msg\">\n      <p *ngIf=\"errorCode !== 0\">{{'nwfjs:loginFailedAuthenticationFailed' | i18next}}</p>\n      <p *ngIf=\"errorCode === 0\">{{'nwfjs:loginFailedUnableAccessServer' | i18next}}</p>\n  </div>\n  <div class=\"modal-footer\">\n      <button class=\"btn btn-primary\" (click)=\"activeModal.close()\" data-netapp-id=\"loginPage-erroDialog-ok-button\" autofocus>{{'nwfjs:OK' | i18next}}</button>\n  </div>\n</div>\n  "
                    }] }
        ];
        /** @nocollapse */
        LoginFailedComponent.ctorParameters = function () {
            return [
                { type: ngBootstrap.NgbActiveModal }
            ];
        };
        LoginFailedComponent.propDecorators = {
            errorCode: [{ type: i0.Input }]
        };
        return LoginFailedComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var LoginForgotPasswordComponent = /** @class */ (function () {
        function LoginForgotPasswordComponent(activeModal) {
            this.activeModal = activeModal;
        }
        /**
         * @return {?}
         */
        LoginForgotPasswordComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
            };
        LoginForgotPasswordComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-forgot-password',
                        template: "\n  <div class=\"modal-content\">\n  <div class=\"modal-header is-info\">\n      <nwf-icon iconClass=\"icon-Info\"></nwf-icon>\n      <h5 class=\"modal-title\" data-netapp-id=\"resetPassword-dialog-title\">{{'nwfjs:info' | i18next}}</h5>\n  </div>\n  <div class=\"modal-body\" data-netapp-id=\"resetPassword-dialog-content\">\n      <p>{{'nwfjs:loginForgetPasswordResetEmailSent' | i18next: {username: username} }}</p>\n  </div>\n\n  <div class=\"modal-footer\">\n      <button class=\"btn btn-primary\" (click)=\"activeModal.close()\" data-netapp-id=\"resetPassword-dialog-ok-button\" autofocus>{{'nwfjs:OK' | i18next}}</button>\n  </div>\n</div>\n\n\n  "
                    }] }
        ];
        /** @nocollapse */
        LoginForgotPasswordComponent.ctorParameters = function () {
            return [
                { type: ngBootstrap.NgbActiveModal }
            ];
        };
        LoginForgotPasswordComponent.propDecorators = {
            username: [{ type: i0.Input }]
        };
        return LoginForgotPasswordComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    /** @type {?} */
    var APP_TITLE_ROOT = new i0.InjectionToken('NwfAppTitleRoot');

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var NwfTitleService = /** @class */ (function (_super) {
        __extends(NwfTitleService, _super);
        function NwfTitleService(i18nextPipe, doc, appTitleRoot) {
            var _this = _super.call(this, doc) || this;
            _this.i18nextPipe = i18nextPipe;
            _this.appTitleRoot = appTitleRoot;
            _this.firstTitleSegment = _this.appTitleRoot || '';
            _this.sep = ' | ';
            return _this;
        }
        /**
         * @param {?} title
         * @return {?}
         */
        NwfTitleService.prototype.setTitle = /**
         * @param {?} title
         * @return {?}
         */
            function (title) {
                var _this = this;
                /** @type {?} */
                var titlesPipeSep = '';
                /** @type {?} */
                var titles = [];
                /* If I have a firstTitle, I push it on first */
                if (this.firstTitleSegment != '') {
                    titles.push(this.firstTitleSegment);
                }
                /* If I am an array, I concatenate that array, otherwise I am a string and I just push it on */
                if (title instanceof Array) {
                    titles = __spread(titles, title);
                }
                else {
                    titles.push(title);
                }
                /* finally produce my pipe sep string, passing each over the i18next pipe so they can pass me i18n:keys */
                titlesPipeSep = titles.filter(( /**
                 * @param {?} item
                 * @return {?}
                 */function (item) { return item !== ''; })).map(( /**
                 * @param {?} item
                 * @return {?}
                 */function (item) {
                    return _this.i18nextPipe.transform(item);
                })).join(this.sep);
                /* Call the regular super for setTitle, now we just have a normal string */
                return _super.prototype.setTitle.call(this, titlesPipeSep);
            };
        NwfTitleService.decorators = [
            { type: i0.Injectable, args: [{
                        providedIn: 'root',
                    },] }
        ];
        /** @nocollapse */
        NwfTitleService.ctorParameters = function () {
            return [
                { type: i1.I18NextPipe },
                { type: undefined, decorators: [{ type: i0.Inject, args: [i2.DOCUMENT,] }] },
                { type: undefined, decorators: [{ type: i0.Optional }, { type: i0.Inject, args: [APP_TITLE_ROOT,] }] }
            ];
        };
        /** @nocollapse */ NwfTitleService.ngInjectableDef = i0.defineInjectable({ factory: function NwfTitleService_Factory() { return new NwfTitleService(i0.inject(i1.I18NextPipe), i0.inject(i2.DOCUMENT), i0.inject(APP_TITLE_ROOT, 8)); }, token: NwfTitleService, providedIn: "root" });
        return NwfTitleService;
    }(i2.Title));

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var LoginComponent = /** @class */ (function () {
        function LoginComponent(NwfAuthService, $state, modalService, titleService) {
            var _this = this;
            this.NwfAuthService = NwfAuthService;
            this.$state = $state;
            this.modalService = modalService;
            this.titleService = titleService;
            this.showHelp = true;
            this.isOemVendor = false;
            this.titleElement = null;
            this.username = null;
            this.password = null;
            // Forgot Password is off by default and enabled when I have provided it
            this.hasForgotPassword = false;
            this.hasResetPassword = false;
            this.forgotPasswordMode = false;
            // Reset Password
            this.resetPasswordMode = false;
            this.authToken = null;
            this.resetPasswordMatch = true;
            this.cnter = 0;
            this.loadingObs = rxjs.interval(1000).pipe(operators.map(( /**
             * @param {?} value
             * @return {?}
             */function (value) {
                _this.cnter++;
                if (_this.cnter > 3) {
                    _this.cnter = 0;
                }
                return lodashEs.repeat('.', _this.cnter);
            })));
            this.creds = { username: '', password: '' };
            this.resetCreds = { username: '', newPassword: '', confirmNewPassword: '', authToken: '' };
            this.forgotCreds = { username: '' };
            /* I detect the presence of a forgotPassword and resetPassword methods in the strategy */
            if (NwfAuthService.forgotPassword) {
                this.hasForgotPassword = true;
            }
            if (NwfAuthService.resetPassword) {
                this.hasResetPassword = true;
            }
            this.titleService.setTitle('nwfjs:login');
        }
        /**
         * @return {?}
         */
        LoginComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                // If the server sends a user and authToken, the only use case we have is that user has send a request to reset the password with this URL.
                // Set the boolean to reset password to be true.
                /** @type {?} */
                var search = document.location.search;
                if (this.hasResetPassword && search) {
                    /** @type {?} */
                    var split = search.split('?');
                    /** @type {?} */
                    var $stateParams = split[split.length - 1].split('&');
                    /** @type {?} */
                    var stateParams_1 = {};
                    $stateParams.forEach(( /**
                     * @param {?} item
                     * @return {?}
                     */function (item) {
                        /** @type {?} */
                        var pair = item.split('=');
                        stateParams_1[pair[0]] = pair[1];
                    }));
                    if (stateParams_1.user !== undefined && stateParams_1.authToken !== undefined) {
                        this.username = stateParams_1.user;
                        this.resetPasswordMode = true;
                        this.forgotPasswordMode = false;
                        this.authToken = stateParams_1.authToken;
                    }
                }
                this.updateHrefs();
            };
        /**
         * @return {?}
         */
        LoginComponent.prototype.authenticate = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.inFlight = true;
                /** @type {?} */
                var returnToOriginalState = ( /**
                 * @return {?}
                 */function () {
                    /** @type {?} */
                    var state = _this.returnTo.state();
                    /** @type {?} */
                    var params = _this.returnTo.params();
                    /** @type {?} */
                    var options = __assign({}, _this.returnTo.options(), { reload: true });
                    _this.$state.go(state, params, options);
                });
                /** @type {?} */
                var showError = ( /**
                 * @param {?} error
                 * @return {?}
                 */function (error) {
                    /** @type {?} */
                    var errorCode = error.status;
                    _this.inFlight = false;
                    /** @type {?} */
                    var failedMdl = _this.modalService.open(LoginFailedComponent);
                    failedMdl.componentInstance.errorCode = errorCode;
                });
                /** @type {?} */
                var stop = ( /**
                 * @return {?}
                 */function () { return _this.inFlight = false; });
                var _a = this.creds, username = _a.username, password = _a.password;
                this.NwfAuthService.authenticate(username, password)
                    .then(returnToOriginalState)
                    .catch(showError)
                    .then(stop, stop);
            };
        /*
        responsible for having the right links and determining if this is vendorized or not
        */
        /*
            responsible for having the right links and determining if this is vendorized or not
            */
        /**
         * @return {?}
         */
        LoginComponent.prototype.updateHrefs = /*
            responsible for having the right links and determining if this is vendorized or not
            */
            /**
             * @return {?}
             */
            function () {
                /** @type {?} */
                var netappHome = 'http://netapp.com';
                if (!this.homeHref) {
                    this.homeHref = netappHome;
                }
                if (!this.supportHref) {
                    this.supportHref = 'http://mysupport.netapp.com';
                }
                this.isOemVendor = false;
                if (this.homeHref !== netappHome) {
                    this.isOemVendor = true;
                }
            };
        // forgot password on submit.
        // forgot password on submit.
        /**
         * @return {?}
         */
        LoginComponent.prototype.forgotPasswordSubmit =
            // forgot password on submit.
            /**
             * @return {?}
             */
            function () {
                /* @todo KM forgotCreds
                        return this.authStrategy.forgotPasswordAuthenticateFn(credentials).then(() => {
                            var forgotPasswordToggle = this.$uibModal.open({
                                template: loginForgotPasswordTemplate,
                                controller: ['$scope', 'forgotPasswordName', function ($scope, forgotPasswordName) {
                                    $scope.username = forgotPasswordName;
                                }],
                                resolve: {
                                    forgotPasswordName: function () {
                                        return credentials.username;
                                    }
                                }
                            });
        
                            //Once done do back to the Login form.
                            forgotPasswordToggle.result.then(() => {
                                this.forgotPasswordToggleFn();
                            });
                        });
                        */
            };
        // Reset password on submit.
        // Reset password on submit.
        /**
         * @return {?}
         */
        LoginComponent.prototype.resetPasswordSubmit =
            // Reset password on submit.
            /**
             * @return {?}
             */
            function () {
                // Check if passwords match
                this.resetPasswordMatch = true;
                if (this.resetCreds.newPassword !== this.resetCreds.confirmNewPassword) {
                    this.resetPasswordMatch = false;
                    return;
                }
                /* wenow haave this.resetCreds.
                    var data = {
                        user: this.username,
                        newPassword: this.newPassword,
                        confirmNewPassword: this.confirmNewPassword,
                        authToken: this.authToken
                    };
        
                    // Controller used by reset password modal instance on success. The user is redirected to login page.
                    this.resetPasswordSuccessController = ['$scope', '$uibModalInstance',
                        function ($scope, $uibModalInstance) {
                            $scope.ok = function () {
                                $uibModalInstance.close();
                                window.location.href = '/';
                            };
                        }
                    ];
            */
                /*
                return this.authStrategy.resetPasswordFn(data).then(() => {
                    this.message = this.$i18next.t("nwfjs:resetPasswordSucceed");
                    this.success = true;
        
                    //Show the modal with success message from the server.
                    this.$uibModal.open({
                        template: loginResetPasswordResultTemplate,
                        scope: this,
                        controller: this.resetPasswordSuccessController
                    });
                }).catch(function (error) {
                    this.message = this.$i18next.t("nwfjs:resetPasswordFailed");
                    if (error != null) {
                        this.message = error.message;
                    }
                    this.success = false;
                    //Show the  modal with failure message from the server.
        
                    this.$uibModal.open({
                        template: loginResetPasswordResultTemplate,
                        scope: this,
                        controller: this.loginFailedController
                    });
                });
                */
            };
        // Reset password on cancel.
        // Reset password on cancel.
        /**
         * @return {?}
         */
        LoginComponent.prototype.resetPasswordCancelFn =
            // Reset password on cancel.
            /**
             * @return {?}
             */
            function () {
                window.location.href = document.location.origin;
            };
        LoginComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-login',
                        template: "\n    <div class=\"nwf-login-overlay\">\n    <div class=\"nwf-login-dialog\">\n    <header class=\"nwf-login-banner-logo\"></header>\n    <div class=\"nwf-login-body\">\n        <h2 class=\"nwf-login-dialog-title-primary\">{{appTitle}}</h2>\n        <h3 class=\"nwf-login-dialog-title-secondary\"></h3>\n        <h5>{{message}}</h5>\n        <!-- Login form -->\n        <form #authForm=\"ngForm\" (ngSubmit)=\"authForm.valid && authenticate()\" *ngIf=\"!forgotPasswordMode && !resetPasswordMode\"\n            id=\"nwf-login-form\" class=\"nwf-validatable\" [ngClass]=\"{'ng-submitted': authForm.submitted }\">\n            <div class=\"form-group l-username\">\n                    <input class=\"nwf-login-input form-control form-control-lg\" name=\"username\" #username=\"ngModel\" [(ngModel)]=\"creds.username\"\n                        data-netapp-id=\"loginPage-username-input\" autocomplete=\"off\" autofocus required placeholder=\"{{'nwfjs:username' | i18next}}\">\n                    <div *ngIf=\"username.invalid && (authForm.submitted || username.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next}}\n                    </div>\n            </div>\n            <div class=\"form-group\">\n                    <input class=\"nwf-login-input form-control form-control-lg\" type=\"password\" name=\"password\" #password=\"ngModel\" [(ngModel)]=\"creds.password\"\n                        data-netapp-id=\"loginPage-password-input\" autocomplete=\"off\" placeholder=\"{{'nwfjs:password' | i18next}}\"\n                        required>\n                    <div *ngIf=\"password.invalid && (authForm.submitted || password.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next}}\n                    </div>\n            </div>\n            <div class=\"form-group l-submit-btn mb-0\">\n                <button type=\"submit\" class=\"nwf-login-input nwf-login-submit btn btn-primary btn-lg\"\n                    data-netapp-id=\"loginPage-signIn-button\">\n                    <div>{{'nwfjs:signIn' | i18next}} <span class=\"loading position-absolute\" [hidden]=\"!inFlight\">{{loadingObs | async}}</span></div>\n                </button>\n            </div>\n            <p *ngIf=\"hasForgotPassword\" class=\"nwf-login-forgot\">\n                <a class=\"nwf-is-link-like\" (click)=\"this.forgotPasswordMode = !this.forgotPasswordMode\" data-netapp-id=\"loginPage-forgot-password-link\">{{'nwfjs:forgetPassword' | i18next}}</a>\n            </p>\n        </form>\n\n        <!-- Forgot Password Form -->\n        <form #forgotFrm=\"ngForm\" class=\"nwf-validatable\" *ngIf=\"forgotPasswordMode\" (ngSubmit)=\"forgotFrm.valid && forgotPasswordSubmit()\" [ngClass]=\"{'ng-submitted': forgotFrm.submitted }\">\n\n            <div class=\"nwf-forgot-password-title-panel\">\n                <div class=\"nwf-forgot-password-text\" data-netapp-id=\"loginPage-forgot-password-text\">\n                    <h4>{{'nwfjs:enterResetUsername' | i18next}}</h4>\n                </div>\n            </div>\n            <div class=\"form-group\">\n                    <input class=\"nwf-login-input form-control form-control-lg\" name=\"username\" #username=\"ngModel\" [(ngModel)]=\"forgotCreds.username\"\n                        data-netapp-id=\"loginPage-username-input\" autocomplete=\"off\" placeholder=\"{{'nwfjs:usernameToReset' | i18next}}\"\n                        required>\n                    <div *ngIf=\"username.invalid && (forgotFrm.submitted || username.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next }}\n                    </div>\n            </div>\n            <div class=\"form-group\">\n            <!-- Submit/Cancel for Forgot Password  -->\n            <div class=\"nwf-login-row\">\n                <div class=\"nwf-login-button-panel\">\n                    <button class=\"btn btn-primary mr-2\" data-netapp-id=\"forgotPassword-submit-button\">{{'nwfjs:submit' | i18next}}</button>\n                    <button class=\"btn btn-secondary\" (click)=\"forgotPasswordMode = false\" data-netapp-id=\"forgotPassword-cancel-button\" type=\"button\">{{'nwfjs:cancel' | i18next}}</button>\n                </div>\n            </div>\n            </div>\n        </form>\n\n        <!-- Reset password Form -->\n        <form #resetFrm=\"ngForm\"  *ngIf=\"resetPasswordMode\" (ngSubmit)=\"resetFrm.valid && resetPasswordSubmit()\" [ngClass]=\"{'ng-submitted': resetFrm.submitted }\">\n\n            <dl>\n                <dt>{{'nwfjs:currentUsername' | i18next}}</dt>\n                <dd>\n                    <input class=\"nwf-login-input form-control form-control-lg\" name=\"username\" #username=\"ngModel\" autocomplete=\"off\" [(ngModel)]=\"resetCreds.username\"\n                        data-netapp-id=\"loginPage-username-input\" title=\"{{'nwfjs:usernameCannotChange' | i18next}}\" required>\n                    <div *ngIf=\"username.invalid && (resetFrm.submitted || username.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next }}\n                    </div>\n                </dd>\n                <dt>{{'nwfjs:newPassword' | i18next}}</dt>\n                <dd>\n                    <input class=\"nwf-login-input form-control form-control-lg\" autocomplete=\"off\" name=\"newPassword\" #newPassword=\"ngModel\"\n                        type=\"password\" [(ngModel)]=\"resetCreds.newPassword\" data-netapp-id=\"loginPage-new-password-input\" placeholder=\"{{'nwfjs:typeNewPassword' | i18next}}\" required>\n                    <div *ngIf=\"newPassword.invalid && (resetFrm.submitted || newPassword.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next }}\n                    </div>\n                </dd>\n                <dt>{{'nwfjs:confirmNewPassword' | i18next}}</dt>\n                <dd>\n                    <input class=\"nwf-login-input form-control form-control-lg\" autocomplete=\"off\" name=\"confirmNewPassword\" #confirmNewPassword=\"ngModel\"\n                        type=\"password\" [(ngModel)]=\"resetCreds.confirmNewPassword\" name=\"confirmNewPassword\" data-netapp-id=\"loginPage-confirm-new-password-input\"\n                        placeholder=\"{{'nwfjs:typeNewPasswordAgain' | i18next}}\" required>\n                    <div *ngIf=\"confirmNewPassword.invalid && (resetFrm.submitted || confirmNewPassword.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next }}\n                    </div>\n                    <div *ngIf=\"!resetPasswordMatch\" class=\"invalid-feedback\">\n                        {{'nwfjs:changePasswordNotMatch' | i18next}}\n                    </div>\n                </dd>\n            </dl>\n\n            <div class=\"nwf-login-button-panel\">\n                <button class=\"btn btn-primary mr-2\" data-netapp-id=\"resetPassword-submit-button\">{{'nwfjs:submit' | i18next}}</button>\n                <button class=\"btn btn-secondary\" data-netapp-id=\"resetPassword-cancel-button\" (click)=\"resetPasswordCancelFn()\" type=\"button\">{{'nwfjs:cancel' | i18next}}</button>\n            </div>\n        </form>\n    </div>\n    <footer class=\"nwf-login-links\">\n        <!-- support -->\n        <a *ngIf=\"!isOemVendor\" [href]=\"supportHref\" target=\"_blank\">{{'nwfjs:netappSupport' | i18next}}</a>\n        <a *ngIf=\"isOemVendor\" [href]=\"supportHref\" target=\"_blank\">{{supportLabel}}</a> |\n        <!-- help -->\n        <span *ngIf=\"\"><a nwf-help showIcon=\"false\" class=\"nwf-is-link-like\">{{'nwfjs:help' | i18next}}</a> |</span>\n        <!-- home -->\n        <a *ngIf=\"!isOemVendor\" href=\"http://netapp.com\" target=\"_blank\">{{'nwfjs:netapp' | i18next}}</a>\n        <a *ngIf=\"isOemVendor\" [href]=\"homeHref\" target=\"_blank\">{{homeLabel}}</a>\n    </footer>\n    </div>\n</div>\n    ",
                        styles: ["nwf-login{width:100%;height:100%;top:0;background-repeat:no-repeat;background-size:cover;display:flex;justify-content:center;align-items:flex-start}.nwf-login-dialog{padding:40px 40px 25px}.l-username{margin-top:2rem}.l-submit-btn{margin-top:2.5rem}h2{font-size:26px;color:#131313}#nwf-login-form[ng-reflect-klass]{margin-top:20px}#nwf-login-form[ng-reflect-klass] dd{margin-bottom:1.2rem}.nwf-login-submit{position:relative}.nwf-login-banner-logo{background-image:url(data:image/png;base64,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);width:100%;background-repeat:no-repeat;height:24px;align-self:flex-start;margin-bottom:10px}.nwf-login-dialog-title-primary{font-size:24px;margin-top:0;margin-bottom:10px}.nwf-login-input{width:100%;margin:5px 0}.nwf-login-forgot{margin:5px 0;align-self:flex-end}.nwf-login-links{margin-top:10px;text-align:center}.nwf-login-overlay{width:100%;position:fixed;left:0;top:0;z-index:1049;height:100%}.nwf-login-button-panel{display:block;text-align:right}"]
                    }] }
        ];
        /** @nocollapse */
        LoginComponent.ctorParameters = function () {
            return [
                { type: undefined, decorators: [{ type: i0.Inject, args: ['NwfAuthService',] }] },
                { type: core.StateService },
                { type: ngBootstrap.NgbModal },
                { type: NwfTitleService }
            ];
        };
        LoginComponent.propDecorators = {
            returnTo: [{ type: i0.Input }],
            appTitle: [{ type: i0.Input }],
            supportHref: [{ type: i0.Input }],
            supportLabel: [{ type: i0.Input }],
            helpHref: [{ type: i0.Input }],
            helpLabel: [{ type: i0.Input }],
            homeHref: [{ type: i0.Input }],
            homeLabel: [{ type: i0.Input }],
            showHelp: [{ type: i0.Input }]
        };
        return LoginComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var ResetPasswordResultComponent = /** @class */ (function () {
        function ResetPasswordResultComponent(activeModal) {
            this.activeModal = activeModal;
            this.isSuccess = true;
        }
        /**
         * @return {?}
         */
        ResetPasswordResultComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
            };
        ResetPasswordResultComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-reset-password-result',
                        template: "\n  <div class=\"modal-content\">\n  <div class=\"modal-header is-info\" *ngIf=\"isSuccess\">\n      <nwf-icon iconClass=\"icon-Info\"></nwf-icon>\n      <h5 class=\"modal-title\" data-netapp-id=\"loginPage-errorDialog-title\">{{'nwfjs:info' | i18next}}</h5>\n  </div>\n\n  <div class=\"modal-header is-error\" *ngIf=\"!isSuccess\">\n      <nwf-icon iconClass=\"icon-Warning\"></nwf-icon>\n      <h5 class=\"modal-title\" data-netapp-id=\"loginPage-errorDialog-title\">{{'nwfjs:error' | i18next}}</h5>\n  </div>\n\n  <div class=\"modal-body\" data-netapp-id=\"resetPassword-server-message\">\n      <p>{{message}}</p>\n  </div>\n\n  <div class=\"modal-footer\">\n      <button class=\"btn btn-primary\" (click)=\"activeModal.close()\" data-netapp-id=\"resetPasswordResponse-dialog-ok-button\" autofocus>{{'nwfjs:OK' | i18next}}</button>\n  </div>\n</div>\n\n\n  "
                    }] }
        ];
        /** @nocollapse */
        ResetPasswordResultComponent.ctorParameters = function () {
            return [
                { type: ngBootstrap.NgbActiveModal }
            ];
        };
        ResetPasswordResultComponent.propDecorators = {
            message: [{ type: i0.Input }],
            isSuccess: [{ type: i0.Input }]
        };
        return ResetPasswordResultComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var ResetPasswordComponent = /** @class */ (function () {
        function ResetPasswordComponent(activeModal) {
            this.activeModal = activeModal;
        }
        /**
         * @return {?}
         */
        ResetPasswordComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
            };
        ResetPasswordComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-reset-password',
                        template: "\n  <div class=\"modal-content\">\n  <div class=\"modal-header is-info\">\n      <nwf-icon iconClass=\"icon-Warning\"></nwf-icon>\n      <h5 class=\"modal-title\" data-netapp-id=\"resetPassword-errorDialog-title\">{{'nwfjs:info' | i18next}}</h5>\n  </div>\n  <div class=\"modal-body\" data-netapp-id=\"resetPassword-errorDialog-content\">\n      <p>\n          {{ 'nwfjs:loginForgetPasswordResetEmailSent' | i18next: {username: username} }}\n      </p>\n  </div>\n\n  <div class=\"modal-footer\">\n      <button class=\"btn btn-primary\" (click)=\"activeModal.close()\" data-netapp-id=\"resetPassword-errorDialog-ok-button\" autofocus>{{'nwfjs:OK' | i18next}}</button>\n  </div>\n</div>\n\n  "
                    }] }
        ];
        /** @nocollapse */
        ResetPasswordComponent.ctorParameters = function () {
            return [
                { type: ngBootstrap.NgbActiveModal }
            ];
        };
        return ResetPasswordComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var UserNoExistComponent = /** @class */ (function () {
        function UserNoExistComponent(activeModal) {
            this.activeModal = activeModal;
        }
        /**
         * @return {?}
         */
        UserNoExistComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
            };
        UserNoExistComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-user-noexist',
                        template: "\n  <div class=\"modal-content\">\n  <div class=\"modal-header is-error\">\n      <nwf-icon iconClass=\"icon-Warning\"></nwf-icon>\n      <h5 class=\"modal-title\" data-netapp-id=\"userNotExists-errorDialog-title\">{{'nwfjs:error' | i18next}}</h5>\n  </div>\n  <div class=\"modal-body\" data-netapp-id=\"userNotExists-errorDialog-content\">\n      <p>{{'nwfjs:loginUsernameNotExist' | i18next}}</p>\n      <p>{{'nwfjs:loginVerifyUsernameTryAgain' | i18next}}</p>\n  </div>\n  <div class=\"modal-footer\">\n      <button class=\"btn btn-primary\" (click)=\"activeModal.close()\" data-netapp-id=\"userNotExists-errorDialog-ok-button\" autofocus>{{'nwfjs:OK' | i18next}}</button>\n  </div>\n</div>\n  "
                    }] }
        ];
        /** @nocollapse */
        UserNoExistComponent.ctorParameters = function () {
            return [
                { type: ngBootstrap.NgbActiveModal }
            ];
        };
        return UserNoExistComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var LogoutFailedComponent = /** @class */ (function () {
        function LogoutFailedComponent(activeModal) {
            this.activeModal = activeModal;
        }
        /**
         * @return {?}
         */
        LogoutFailedComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
            };
        LogoutFailedComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-logout-failed',
                        template: "\n  <div class=\"modal-content\">\n  <div class=\"modal-header is-error\">\n      <nwf-icon iconClass=\"icon-status-warning\"></nwf-icon>\n      <h5 class=\"modal-title\" data-netapp-id=\"logOut-errorDialog-title\">{{'nwfjs:error' | i18next}}</h5>\n  </div>\n  <div class=\"modal-body\" data-netapp-id=\"logOut-errorDialog-content\">\n      <b>{{'nwfjs:logoutFailed' | i18next}}</b>\n      <br>\n      <p>{{'nwfjs:logoutSignOutNow' | i18next}}</p>\n  </div>\n  <div class=\"modal-footer\">\n      <button class=\"btn btn-primary\" (click)=\"activeModal.close()\" data-netapp-id=\"logOut-errorDialog-ok-button\">{{'nwfjs:OK' | i18next}}</button>\n  </div>\n</div>\n\n  "
                    }] }
        ];
        /** @nocollapse */
        LogoutFailedComponent.ctorParameters = function () {
            return [
                { type: ngBootstrap.NgbActiveModal }
            ];
        };
        LogoutFailedComponent.propDecorators = {
            errorCode: [{ type: i0.Input }]
        };
        return LogoutFailedComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var LogoutComponent = /** @class */ (function () {
        function LogoutComponent(NwfAuthService, modalService, $state) {
            this.NwfAuthService = NwfAuthService;
            this.modalService = modalService;
            this.$state = $state;
        }
        /**
         * @return {?}
         */
        LogoutComponent.prototype.logout = /**
         * @return {?}
         */
            function () {
                var _this = this;
                /** @type {?} */
                var showError = ( /**
                 * @param {?} error
                 * @return {?}
                 */function (error) {
                    /** @type {?} */
                    var errorCode = error.status;
                    /** @type {?} */
                    var failedMdl = _this.modalService.open(LogoutFailedComponent);
                    failedMdl.componentInstance.errorCode = errorCode;
                });
                /** @type {?} */
                var returnToOriginalState = ( /**
                 * @return {?}
                 */function () {
                    _this.$state.go(_this.returnState);
                });
                return this.NwfAuthService.logout().then(returnToOriginalState).catch(showError);
            };
        /**
         * @return {?}
         */
        LogoutComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
            };
        LogoutComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nwf-logout',
                        host: {
                            'class': 'dropdown-item',
                            'data-netapp-id': 'nav-logOut-link',
                        },
                        template: "\n{{'nwfjs:logout' | i18next}}\n  "
                    }] }
        ];
        /** @nocollapse */
        LogoutComponent.ctorParameters = function () {
            return [
                { type: undefined, decorators: [{ type: i0.Inject, args: ['NwfAuthService',] }] },
                { type: ngBootstrap.NgbModal },
                { type: angular.StateService }
            ];
        };
        LogoutComponent.propDecorators = {
            returnState: [{ type: i0.Input }],
            logout: [{ type: i0.HostListener, args: ['click',] }]
        };
        return LogoutComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var MainbodyComponent = /** @class */ (function () {
        function MainbodyComponent(leftnavService) {
            this.leftnavService = leftnavService;
            this.top = '53px';
            this.asideWidth = '300px';
            this.leftnavWidth = '200px';
            this.isLeftnavVisible = true;
            this.isAsideVisible = false;
            this.leftnavConfig = null;
        }
        Object.defineProperty(MainbodyComponent.prototype, "mainPaddingTop", {
            get: /**
             * @return {?}
             */ function () {
                return parseInt(this.top) + 15 + 'px';
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(MainbodyComponent.prototype, "mainMarginLeft", {
            get: /**
             * @return {?}
             */ function () {
                /** @type {?} */
                var marginLeft = '0px';
                if (this.isLeftnavVisible) {
                    marginLeft = this.leftnavWidth;
                }
                return marginLeft;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(MainbodyComponent.prototype, "mainMarginRight", {
            get: /**
             * @return {?}
             */ function () {
                /** @type {?} */
                var marginRight = '0px';
                if (this.isAsideVisible) {
                    marginRight = this.asideWidth;
                }
                return marginRight;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        MainbodyComponent.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                if (this.subscription) {
                    this.subscription.unsubscribe();
                }
            };
        /**
         * @return {?}
         */
        MainbodyComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.subscription = this.leftnavService.leftNav$.subscribe(( /**
                 * @param {?} hideLeftNav
                 * @return {?}
                 */function (hideLeftNav) {
                    if (hideLeftNav) {
                        _this.isLeftnavVisible = false;
                    }
                    else {
                        _this.isLeftnavVisible = true;
                    }
                }));
            };
        MainbodyComponent.decorators = [
            { type: i0.Component, args: [{
                        template: "\n  <div class=\"l-nwf-mainbody\">\n        <nav class=\"nwf-sidebar\" [hidden]=\"!isLeftnavVisible\" [ngStyle]=\"{ paddingTop: top, width: leftnavWidth }\">\n          <ng-content *ngIf=\"!leftnavConfig\" select=\"nwf-left-nav\"></ng-content>\n          <nwf-left-nav *ngIf=\"leftnavConfig\" [navData]=\"leftnavConfig\"></nwf-left-nav>\n        </nav>\n        <main class=\"px-4\" [ngStyle]=\"{  marginLeft: mainMarginLeft, marginRight: mainMarginRight, paddingTop: mainPaddingTop }\" ui-view></main>\n        <aside class=\"\" [hidden]=\"!isAsideVisible\" [ngStyle]=\"{ paddingTop: top, width: asideWidth }\"><ng-content select=\".aside\"></ng-content></aside>\n  </div>\n  ",
                        selector: 'nwf-mainbody',
                        host: {
                            class: 'w-100',
                        },
                        styles: [".nwf-sidebar{position:fixed;top:0;bottom:0;left:0;z-index:100;background-color:#0a2d6c;box-shadow:3px 0 0 0 rgba(0,0,0,.1)}aside{position:fixed;top:0;bottom:0;right:0;background-color:#0a2d6c}[hidden]{display:none!important}"]
                    }] }
        ];
        /** @nocollapse */
        MainbodyComponent.ctorParameters = function () {
            return [
                { type: NwfLeftnavService }
            ];
        };
        MainbodyComponent.propDecorators = {
            top: [{ type: i0.Input }],
            asideWidth: [{ type: i0.Input }],
            leftnavWidth: [{ type: i0.Input }],
            isLeftnavVisible: [{ type: i0.Input }],
            isAsideVisible: [{ type: i0.Input }],
            leftnavConfig: [{ type: i0.Input }]
        };
        return MainbodyComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var ShellModule = /** @class */ (function () {
        function ShellModule() {
        }
        ShellModule.decorators = [
            { type: i0.NgModule, args: [{
                        imports: [
                            devextremeAngular.DxTemplateModule,
                            devextremeAngular.DxPopoverModule,
                            devextremeAngular.DxScrollViewModule,
                            common.CommonModule,
                            forms.FormsModule,
                            NwfjsSharedComponentsModule,
                            i1.I18NextModule,
                            ngBootstrap.NgbModule,
                            angular.UIRouterModule,
                        ],
                        providers: [NwfLeftnavService, NwfTitleService],
                        declarations: [
                            GlobalnavComponent,
                            AppTitleComponent,
                            GlobalnavPrimaryComponent,
                            GlobalnavPrimaryCenterComponent,
                            GlobalnavPrimaryToolsComponent,
                            GlobalnavSecondaryComponent,
                            GlobalnavSecondaryMenusComponent,
                            GlobalnavSecondarySearchComponent,
                            GlobalSearchComponent,
                            AboutComponent,
                            AboutModalComponent,
                            LeftnavComponent,
                            LeftnavItemComponent,
                            LoginComponent,
                            LoginFailedComponent,
                            ResetPasswordComponent,
                            ResetPasswordResultComponent,
                            LoginForgotPasswordComponent,
                            UserNoExistComponent,
                            LogoutComponent,
                            LogoutFailedComponent,
                            MainbodyComponent,
                        ],
                        entryComponents: [
                            AboutModalComponent,
                            LoginFailedComponent,
                            ResetPasswordComponent,
                            ResetPasswordResultComponent,
                            LoginForgotPasswordComponent,
                            UserNoExistComponent,
                            LogoutFailedComponent,
                            MainbodyComponent,
                            LeftnavComponent,
                        ],
                        exports: [
                            GlobalnavComponent,
                            AppTitleComponent,
                            GlobalnavPrimaryComponent,
                            GlobalnavPrimaryCenterComponent,
                            GlobalnavPrimaryToolsComponent,
                            GlobalnavSecondaryComponent,
                            GlobalnavSecondaryMenusComponent,
                            GlobalnavSecondarySearchComponent,
                            GlobalSearchComponent,
                            AboutComponent,
                            LeftnavComponent,
                            LoginComponent,
                            LogoutComponent,
                            MainbodyComponent,
                        ],
                    },] }
        ];
        return ShellModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var NwfjsComponentsModule = /** @class */ (function () {
        function NwfjsComponentsModule() {
        }
        /**
         * @param {?} config
         * @return {?}
         */
        NwfjsComponentsModule.forRoot = /**
         * @param {?} config
         * @return {?}
         */
            function (config) {
                return {
                    ngModule: NwfjsComponentsModule,
                    providers: [
                        { provide: NwfjsConfigService, useValue: config },
                    ],
                };
            };
        NwfjsComponentsModule.decorators = [
            { type: i0.NgModule, args: [{
                        imports: [
                            ShellModule,
                            NwfGridModule,
                        ],
                        declarations: [],
                        exports: [
                            ShellModule,
                            NwfGridModule,
                        ],
                    },] }
        ];
        return NwfjsComponentsModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var NwfGridSchemaProcessor = /** @class */ (function () {
        function NwfGridSchemaProcessor(schemaObject, schemaIdToDxColumn, customSchemaTypeToDxColumn) {
            /* First, we take the schemaIdToDxColumn and mix it over our own standard definition ,
                so we allow the user to provide us with custom schemaType to DxColumns,
                but we also handle a standard dataType provided by nwf, to make it easy.
                Note: this schemaTypeToDxColumn we have in this class is married to um's ftm.
            */
            if (schemaIdToDxColumn === void 0) {
                schemaIdToDxColumn = {};
            }
            this.columns = [];
            this.filterableColumns = [];
            this.schemaTypeToDxColumn = {
                dateTime: NwfDateColumn,
                metric: NwfMetricColumn,
                number: NwfNumberColumn,
            };
            for (var columnId in schemaObject) {
                if (schemaObject.hasOwnProperty(columnId)) {
                    /** @type {?} */
                    var schemaProp = schemaObject[columnId];
                    /** @type {?} */
                    var hasMatchingId = columnId in schemaIdToDxColumn ? true : false;
                    // updating schemaTypeToDxColumn mapping.
                    this.schemaTypeToDxColumn = lodashEs.assign({}, this.schemaTypeToDxColumn, customSchemaTypeToDxColumn);
                    /** @type {?} */
                    var hasMatchingType = schemaProp.type in this.schemaTypeToDxColumn ? true : false;
                    /** @type {?} */
                    var dxColumnObject = void 0;
                    /* First I see if the id has an associated columnId from the caller's schemaIdToDxColumn map.
                        This is because I want to allow the user to easily customize the cell based on the id.
                        for example, they tell me how to render a clusterObject. If it has a matching id, it wins over the nwf
                        mapped type.
                    */
                    if (hasMatchingId) {
                        dxColumnObject = new schemaIdToDxColumn[schemaProp.id](schemaProp);
                    }
                    else if (hasMatchingType) {
                        /* There is no matching Id, so I next try to create a column based on the schemaProp's type.
                            This is so I can best render a column's value based on the type (date, number) to a nice i18n default.
                        */
                        dxColumnObject = new this.schemaTypeToDxColumn[schemaProp.type](schemaProp);
                    }
                    else {
                        /* now I dont know */
                        dxColumnObject = new NwfSchemaColumn(schemaProp);
                    }
                    this.columns.push(dxColumnObject);
                    // finding all filterable properties.
                    if (schemaProp.filterable) {
                        this.filterableColumns.push(schemaProp);
                    }
                }
            }
        }
        return NwfGridSchemaProcessor;
    }());
    var NwfSchemaColumn = /** @class */ (function (_super) {
        __extends(NwfSchemaColumn, _super);
        function NwfSchemaColumn(schemaProp) {
            var _this = _super.call(this) || this;
            _this.allowHeaderFiltering = false;
            _this.alignment = 'left';
            _this.visible = true;
            _this.allowFiltering = true;
            _this.allowSorting = true;
            _this.allowHiding = true;
            _this.allowReordering = true;
            _this.cellTemplate = 'nwfDefaultCellTemplate';
            _this.width = '100%';
            var id = schemaProp.id, label = schemaProp.label, type = schemaProp.type, options = schemaProp.options, visible = schemaProp.visible;
            // the dataField is how dx identifies the column, for us it is the same as the id, name is needed because that is how
            // we identify the column by name later to set options.
            _this.name = _this.dataField = id;
            // set a descriptive or friendly name for the column.
            _this.caption = label;
            // our type field is pretty close to the default dataTypes (which are just lowercased strings)
            // this can be improved if we have other types, but I bet it will work.
            _this.dataType = type.toLowerCase();
            // we allow search only for columns having 'resource','string', or associatedObjects dataType;
            _this.allowSearch = ['resource', 'string', 'associatedObjects'].indexOf(_this.dataType) !== -1;
            _this.allowFiltering = lodashEs.get(schemaProp, 'filterable', _this.allowFiltering);
            _this.allowSorting = lodashEs.get(schemaProp, 'sortable', _this.allowSorting);
            // editorOptions becomes options for 'enum-single' and 'enum-multiple' values.
            _this.editorOptions = options;
            _this.showInColumnChooser = visible;
            return _this;
        }
        return NwfSchemaColumn;
    }(dataGridColumnDxi.DxiDataGridColumn));
    var NwfNumberColumn = /** @class */ (function (_super) {
        __extends(NwfNumberColumn, _super);
        function NwfNumberColumn(schemaProp) {
            var _this = _super.call(this, schemaProp) || this;
            _this.cellTemplate = 'nwfNumberCellTemplate';
            return _this;
        }
        return NwfNumberColumn;
    }(NwfSchemaColumn));
    var NwfMetricColumn = /** @class */ (function (_super) {
        __extends(NwfMetricColumn, _super);
        function NwfMetricColumn(schemaProp) {
            var _this = _super.call(this, schemaProp) || this;
            _this.cellTemplate = 'nwfMetricCellTemplate';
            _this.unit = schemaProp.unit;
            return _this;
        }
        return NwfMetricColumn;
    }(NwfSchemaColumn));
    var NwfDateColumn = /** @class */ (function (_super) {
        __extends(NwfDateColumn, _super);
        function NwfDateColumn(schemaProp) {
            var _this = _super.call(this, schemaProp) || this;
            _this.cellTemplate = 'nwfDateCellTemplate';
            return _this;
        }
        return NwfDateColumn;
    }(NwfSchemaColumn));
    var NwfStatusColumn = /** @class */ (function (_super) {
        __extends(NwfStatusColumn, _super);
        // creating a cell template based on UX requirements.
        function NwfStatusColumn(schemaProp) {
            var _this = _super.call(this, schemaProp) || this;
            _this.alignment = 'center';
            _this.width = 80;
            _this.cellTemplate = 'nwfStatusCellTemplate';
            _this.calculateSortValue = ( /**
             * @param {?} __0
             * @return {?}
             */function (_a) {
                var status = _a.status;
                // we assign 'z' to critical so that it shows as first,last when sorted alphabettically
                // for possible status values.
                if (status.toLowerCase() === 'critical') {
                    status = 'z'; // Critical are always displayed at the top
                }
                return status;
            });
            return _this;
        }
        return NwfStatusColumn;
    }(NwfSchemaColumn));

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */

    exports.NwfjsComponentsModule = NwfjsComponentsModule;
    exports.NwfjsSharedComponentsModule = NwfjsSharedComponentsModule;
    exports.NwfjsSharedPipesModule = NwfjsSharedPipesModule;
    exports.LoginComponent = LoginComponent;
    exports.NwfjsConfigService = NwfjsConfigService;
    exports.NwfPageAlertService = NwfPageAlertService;
    exports.NwfTitleService = NwfTitleService;
    exports.NwfLeftnavService = NwfLeftnavService;
    exports.NwfElipsizerResizeService = NwfElipsizerResizeService;
    exports.NwfFeatureTourService = NwfFeatureTourService;
    exports.NwfBeaconService = NwfBeaconService;
    exports.NwfColumnsChangingService = NwfColumnsChangingService;
    exports.NwfMainbodyComponent = MainbodyComponent;
    exports.NwfLeftnavComponent = LeftnavComponent;
    exports.NwfRoundUnit = NwfRoundUnit;
    exports.NwfHelpConfig = NwfHelpConfig;
    exports.NwfGridOptionsService = NwfGridOptionsService;
    exports.NwfFilterBuilderCustomOperations = NwfFilterBuilderCustomOperations;
    exports.NwfGridSchemaProcessor = NwfGridSchemaProcessor;
    exports.NwfSchemaColumn = NwfSchemaColumn;
    exports.NwfNumberColumn = NwfNumberColumn;
    exports.NwfMetricColumn = NwfMetricColumn;
    exports.NwfDateColumn = NwfDateColumn;
    exports.NwfStatusColumn = NwfStatusColumn;
    exports.APP_TITLE_ROOT = APP_TITLE_ROOT;
    exports.ɵe = AlertComponent;
    exports.ɵg = NwfDatetimePicker;
    exports.ɵh = NwfDatetimeRangePicker;
    exports.ɵi = NwfElipsizer;
    exports.ɵm = NwfFeatureTourDirective;
    exports.ɵc = HelpDirective;
    exports.ɵd = HelpService;
    exports.ɵn = HorizontalBarChartComponent;
    exports.ɵb = IconComponent;
    exports.ɵj = HeaderComponent;
    exports.ɵf = PageAlertComponent;
    exports.ɵk = NwfPropertySheet;
    exports.ɵl = NwfProperty;
    exports.ɵbr = CellsComponent;
    exports.ɵbk = ColumnChooserComponent;
    exports.ɵbl = ColumnVisibilityComponent;
    exports.ɵbo = FilterCriterionRowComponent;
    exports.ɵbp = NwfFilterCriterionDateComponent;
    exports.ɵbn = FilterMultiselectComponent;
    exports.ɵbm = NwfFilterComponent;
    exports.ɵbq = FooterComponent;
    exports.ɵbh = NwfGridModule;
    exports.ɵbi = NwfGridPaginatorComponent;
    exports.ɵbj = SearchComponent;
    exports.ɵy = AboutModalComponent;
    exports.ɵx = AboutComponent;
    exports.ɵp = AppTitleComponent;
    exports.ɵw = GlobalSearchComponent;
    exports.ɵr = GlobalnavPrimaryCenterComponent;
    exports.ɵs = GlobalnavPrimaryToolsComponent;
    exports.ɵq = GlobalnavPrimaryComponent;
    exports.ɵu = GlobalnavSecondaryMenusComponent;
    exports.ɵv = GlobalnavSecondarySearchComponent;
    exports.ɵt = GlobalnavSecondaryComponent;
    exports.ɵo = GlobalnavComponent;
    exports.ɵz = LeftnavItemComponent;
    exports.ɵba = LoginFailedComponent;
    exports.ɵbd = LoginForgotPasswordComponent;
    exports.ɵbc = ResetPasswordResultComponent;
    exports.ɵbb = ResetPasswordComponent;
    exports.ɵbe = UserNoExistComponent;
    exports.ɵbg = LogoutFailedComponent;
    exports.ɵbf = LogoutComponent;
    exports.ɵa = ShellModule;

    Object.defineProperty(exports, '__esModule', { value: true });

})));

//# sourceMappingURL=netapp-nwfjs_angular_components.umd.js.map