/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { Chart } from 'angular-highcharts';
import { I18NextPipe } from 'angular-i18next';
import { template } from 'lodash-es';
import { isUndefined } from 'lodash-es';
import { merge, Subject } from 'rxjs';
import { delay, takeUntil } from 'rxjs/operators';
import { NwfLeftnavService } from '../../shell/leftnav/leftnav.service';
import { NwfColumnsChangingService } from '../grid-columns-changing.service';
export class HorizontalBarChartComponent {
    /**
     * @param {?} i18next
     * @param {?} leftNavService
     * @param {?} columnsChangingService
     */
    constructor(i18next, leftNavService, columnsChangingService) {
        this.i18next = i18next;
        this.leftNavService = leftNavService;
        this.columnsChangingService = columnsChangingService;
        this.totalValue = 100; // This bar can represent a value out of any totalValue given
        // This bar can represent a value out of any totalValue given
        this.seriesName = 'Value';
        this.showTooltip = true;
        // @Input() width = 300;
        this.height = 20;
        // Enables color zones for soft/hard limits values given
        this.zones = false;
        // Enables y-axis labels for bar chart to show range info like 25%, 50%, 100%
        this.axisLabels = false;
        this.axisUnit = '';
        this.legendsEnabled = false;
        this.plotLinesConfig = [];
        this.destroy = new Subject();
        this.isUndefined = isUndefined;
    }
    /**
     * @return {?}
     */
    ngOnInit() {
        // If soft,hard limits are passed, we show plot lines on the bar chart accordingly
        if (this.softLimit) {
            this.plotLinesConfig.push({
                value: this.softLimit,
                width: 2,
                zIndex: 5,
                className: 'nwf-soft-limit',
            });
        }
        if (this.hardLimit) {
            this.plotLinesConfig.push({
                value: this.hardLimit,
                width: 2,
                zIndex: 5,
                className: 'nwf-hard-limit',
            });
        }
        // If 'zones' is true, we set default, soft & hard limit zones
        if (this.zones && this.softLimit && this.hardLimit) {
            this.zonesConfig = [
                {
                    value: this.softLimit >= this.currentValue ? this.softLimit - 1 : 0,
                    className: 'nwf-default-zone',
                },
                {
                    value: this.hardLimit,
                    className: 'nwf-soft-limit-zone',
                }, {
                    className: 'nwf-hard-limit-zone',
                },
            ];
        }
        // Calculate chart height
        // when axis labels are shown, chart requires additional height i.e. +21 to current value:20
        if (this.axisLabels) {
            this.height += 21;
        }
        if (this.legendsEnabled) {
            this.height += 40;
        }
        // We allow only one bar for now with seriesData
        if (this.seriesData) {
            for (const series of this.seriesData) {
                series.pointPadding = 0;
                series.groupPadding = 0;
            }
        }
        this.chart = new Chart({
            chart: {
                type: 'bar',
                height: this.height,
                // width: this.width,
                spacing: [0, 0, 0, 0],
                styledMode: true,
            },
            tooltip: {
                outside: true,
                enabled: this.showTooltip,
                useHTML: true,
                /**
                 * @return {?}
                 */
                formatter() {
                    /** @type {?} */
                    const templateData = {
                        seriesName: this.series.name,
                        tooltipCurrentValue: this.point['tooltipCurrentValue'],
                        tooltipSoftLimitValue: this.point['tooltipSoftLimitValue'],
                        tooltipHardLimitValue: this.point['tooltipHardLimitValue'],
                        softLimit: this.point['i18nRef'] ? this.point['i18nRef'].transform('nwfjs:softLimit') : '',
                        hardLimit: this.point['i18nRef'] ? this.point['i18nRef'].transform('nwfjs:hardLimit') : '',
                        exceedsHardLimit: this.point['i18nRef'] ? this.point['i18nRef'].transform('nwfjs:exceedsHardLimit') : '',
                        exceedsSoftLimit: this.point['i18nRef'] ? this.point['i18nRef'].transform('nwfjs:exceedsSoftLimit') : '',
                    };
                    /** @type {?} */
                    let tooltipBody = '<span class="tooltip-current-series">\u25CF </span>${seriesName}: ${tooltipCurrentValue}';
                    if (this.point['softLimit'] || this.point['hardLimit']) {
                        // If limits exceeded, show an additional header message about the breach
                        if (this.point.y >= this.point['hardLimit']) {
                            tooltipBody = '${seriesName} ${exceedsHardLimit}<br\>' + tooltipBody;
                        }
                        else if (this.point.y >= this.point['softLimit']) {
                            tooltipBody = '${seriesName} ${exceedsSoftLimit}<br\>' + tooltipBody;
                        }
                        // Appends Soft Limit, Hard Limit values to the tooltip
                        tooltipBody += '<br><span class="tooltip-soft-limit-series">\u25CF </span>${softLimit}: ${tooltipSoftLimitValue}';
                        tooltipBody += '<br><span class="tooltip-hard-limit-series">\u25CF </span>${hardLimit}: ${tooltipHardLimitValue}';
                    }
                    /** @type {?} */
                    const tooltip = template(`<div class="nwf-highcharts-tooltip popover bs-popover-right">
                    <div class="arrow"></div>
                    <div class="popover-body">${tooltipBody}</div>
                    </div>
                    `);
                    return tooltip(templateData);
                },
            },
            title: {
                text: '',
            },
            subtitle: {
                text: '',
            },
            xAxis: {
                gridLineColor: 'transparent',
                visible: false,
                title: {
                    text: null,
                },
                labels: {
                    enabled: false,
                },
            },
            yAxis: {
                max: this.totalValue,
                endOnTick: false,
                visible: true,
                title: {
                    text: null,
                },
                labels: {
                    enabled: this.axisLabels,
                    format: '{value}' + this.axisUnit,
                    style: {
                        textOverflow: 'none',
                    },
                },
                plotLines: !this.zones ? this.plotLinesConfig : undefined,
            },
            plotOptions: {
                bar: {
                    dataLabels: {
                        enabled: false,
                    },
                },
                series: {
                    zones: this.zonesConfig,
                    stacking: this.seriesData ? 'normal' : undefined,
                },
            },
            legend: {
                enabled: this.legendsEnabled,
            },
            credits: {
                enabled: false,
            },
            series: this.seriesData ? this.seriesData : [(/** @type {?} */ ({
                    pointPadding: 0,
                    groupPadding: 0,
                    animation: false,
                    name: this.seriesName,
                    data: [{
                            y: this.currentValue,
                            softLimit: this.softLimit,
                            hardLimit: this.hardLimit,
                            // If we need to show custom strings in the tooltip, we use below values
                            tooltipSoftLimitValue: this.tooltipSoftLimitValue ? this.tooltipSoftLimitValue : this.softLimit,
                            tooltipHardLimitValue: this.tooltipHardLimitValue ? this.tooltipHardLimitValue : this.hardLimit,
                            tooltipCurrentValue: this.tooltipCurrentValue ? this.tooltipCurrentValue : this.currentValue,
                            i18nRef: this.i18next,
                        }],
                }))],
        });
        merge(this.leftNavService.leftNav$, this.columnsChangingService.columnsChanging$)
            .pipe(takeUntil(this.destroy), delay(10))
            .subscribe((/**
         * @return {?}
         */
        () => {
            this.chart.ref.reflow();
        }));
    }
    /**
     * @return {?}
     */
    ngOnDestroy() {
        // Signal end of subscription to observables
        this.destroy.next();
        this.destroy.complete();
    }
}
HorizontalBarChartComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-horizontal-bar-chart',
                template: "<div class=\"row no-gutters\">\n\n    <div class=\"col align-middle\" [chart]=\"chart\" [ngClass]=\"{ 'pr-1 col-lg-7 col-sm-12' : !isUndefined(labelPrimary) || !isUndefined(labelSecondary)}\">\n    </div>\n\n    <div class=\"col-lg-5 col-sm-12 d-flex flex-row align-items-center flex-wrap\"\n        *ngIf=\"!isUndefined(labelPrimary) || !isUndefined(labelSecondary)\">\n\n        <div class=\"inline-label pr-1\" [ngClass]=\"{ 'border-right-custom': !isUndefined(labelSecondary)}\"\n            *ngIf=\"!isUndefined(labelPrimary)\">\n            {{labelPrimary}}\n        </div>\n        <div class=\"px-1 inline-label\" *ngIf=\"!isUndefined(labelSecondary)\">\n            {{ labelSecondary}}\n        </div>\n\n    </div>\n</div>",
                styles: ["::ng-deep .tooltip-current-series{color:#61dce8}::ng-deep .tooltip-soft-limit-series{color:#f88402}::ng-deep .tooltip-hard-limit-series{color:#da1e21}:host ::ng-deep .highcharts-background{fill:none}:host ::ng-deep .highcharts-plot-background{fill:#d7d7d7}:host ::ng-deep .highcharts-plot-line.nwf-soft-limit{stroke:#f88402;stroke-width:2px}:host ::ng-deep .highcharts-plot-line.nwf-hard-limit{stroke:#da1e21;stroke-width:2px}:host ::ng-deep .highcharts-point.nwf-default-zone{fill:#61dce8;stroke:#61dce8}:host ::ng-deep .highcharts-point.nwf-soft-limit-zone{fill:#f88402;stroke:#f88402}:host ::ng-deep .highcharts-point.nwf-hard-limit-zone{fill:#da1e21;stroke:#da1e21}:host ::ng-deep .highcharts-grid-line{stroke:transparent}:host ::ng-deep .highcharts-container{width:100%!important}:host ::ng-deep .highcharts-container>svg:first-child{width:100%!important}:host .inline-label{font-size:12px;font-weight:600}:host .border-right-custom{border-right:1px solid #000}"]
            }] }
];
/** @nocollapse */
HorizontalBarChartComponent.ctorParameters = () => [
    { type: I18NextPipe },
    { type: NwfLeftnavService },
    { type: NwfColumnsChangingService }
];
HorizontalBarChartComponent.propDecorators = {
    currentValue: [{ type: Input }],
    totalValue: [{ type: Input }],
    seriesName: [{ type: Input }],
    showTooltip: [{ type: Input }],
    labelPrimary: [{ type: Input }],
    labelSecondary: [{ type: Input }],
    softLimit: [{ type: Input }],
    hardLimit: [{ type: Input }],
    tooltipSoftLimitValue: [{ type: Input }],
    tooltipHardLimitValue: [{ type: Input }],
    tooltipCurrentValue: [{ type: Input }],
    zones: [{ type: Input }],
    axisLabels: [{ type: Input }],
    axisUnit: [{ type: Input }],
    seriesData: [{ type: Input }],
    legendsEnabled: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    HorizontalBarChartComponent.prototype.currentValue;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.totalValue;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.seriesName;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.showTooltip;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.labelPrimary;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.labelSecondary;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.softLimit;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.hardLimit;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.tooltipSoftLimitValue;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.tooltipHardLimitValue;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.tooltipCurrentValue;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.height;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.zones;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.axisLabels;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.axisUnit;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.seriesData;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.legendsEnabled;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.chart;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.chartWithPlotLines;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.plotLinesConfig;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.zonesConfig;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.destroy;
    /** @type {?} */
    HorizontalBarChartComponent.prototype.isUndefined;
    /**
     * @type {?}
     * @private
     */
    HorizontalBarChartComponent.prototype.i18next;
    /**
     * @type {?}
     * @private
     */
    HorizontalBarChartComponent.prototype.leftNavService;
    /**
     * @type {?}
     * @private
     */
    HorizontalBarChartComponent.prototype.columnsChangingService;
}
//# sourceMappingURL=data:application/json;base64,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