/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, ElementRef, Input } from '@angular/core';
export class HeaderComponent {
    /**
     * @param {?} element
     */
    constructor(element) {
        this.element = element;
        this.status = 'info';
    }
    /**
     * @return {?}
     */
    ngOnInit() {
        /** @type {?} */
        const stateCls = `is-` + this.status;
        this.element.nativeElement.classList.add(stateCls);
    }
}
HeaderComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-modal-header',
                template: "\n  <nwf-icon [severity]=\"status\"></nwf-icon>\n  <h5 class=\"modal-title\"><ng-content></ng-content></h5>\n",
                host: { class: 'modal-header' }
            }] }
];
/** @nocollapse */
HeaderComponent.ctorParameters = () => [
    { type: ElementRef }
];
HeaderComponent.propDecorators = {
    status: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    HeaderComponent.prototype.status;
    /**
     * @type {?}
     * @private
     */
    HeaderComponent.prototype.element;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaGVhZGVyLmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiJuZzovL0BuZXRhcHAvbndmanNfYW5ndWxhcl9jb21wb25lbnRzLyIsInNvdXJjZXMiOlsibGliL2NvbXBvbmVudHMvbW9kYWxzL2hlYWRlci9oZWFkZXIuY29tcG9uZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7QUFBQSxPQUFPLEVBQUUsU0FBUyxFQUFFLFVBQVUsRUFBRSxLQUFLLEVBQVUsTUFBTSxlQUFlLENBQUM7QUFPckUsTUFBTSxPQUFPLGVBQWU7Ozs7SUFJMUIsWUFBb0IsT0FBbUI7UUFBbkIsWUFBTyxHQUFQLE9BQU8sQ0FBWTtRQUZ2QixXQUFNLEdBQVcsTUFBTSxDQUFDO0lBRUcsQ0FBQzs7OztJQUVyQyxRQUFROztjQUNQLFFBQVEsR0FBRyxLQUFLLEdBQUcsSUFBSSxDQUFDLE1BQU07UUFDcEMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxhQUFhLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUNyRCxDQUFDOzs7WUFkRixTQUFTLFNBQUM7Z0JBQ1QsUUFBUSxFQUFFLGtCQUFrQjtnQkFDNUIseUhBQXNDO2dCQUN0QyxJQUFJLEVBQUUsRUFBRSxLQUFLLEVBQUUsY0FBYyxFQUFFO2FBQ2hDOzs7O1lBTm1CLFVBQVU7OztxQkFTM0IsS0FBSzs7OztJQUFOLGlDQUF3Qzs7Ozs7SUFFNUIsa0NBQTJCIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29tcG9uZW50LCBFbGVtZW50UmVmLCBJbnB1dCwgT25Jbml0IH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5cbkBDb21wb25lbnQoe1xuICBzZWxlY3RvcjogJ253Zi1tb2RhbC1oZWFkZXInLFxuICB0ZW1wbGF0ZVVybDogJy4vaGVhZGVyLmNvbXBvbmVudC5odG1sJyxcbiAgaG9zdDogeyBjbGFzczogJ21vZGFsLWhlYWRlcicgfSxcbn0pXG5leHBvcnQgY2xhc3MgSGVhZGVyQ29tcG9uZW50IGltcGxlbWVudHMgT25Jbml0IHtcblxuICBASW5wdXQoKSBwdWJsaWMgc3RhdHVzOiBzdHJpbmcgPSAnaW5mbyc7XG5cbiAgY29uc3RydWN0b3IocHJpdmF0ZSBlbGVtZW50OiBFbGVtZW50UmVmKSB7IH1cblxuICBwdWJsaWMgbmdPbkluaXQoKSB7XG4gICAgY29uc3Qgc3RhdGVDbHMgPSBgaXMtYCArIHRoaXMuc3RhdHVzO1xuICAgIHRoaXMuZWxlbWVudC5uYXRpdmVFbGVtZW50LmNsYXNzTGlzdC5hZGQoc3RhdGVDbHMpO1xuICB9XG5cbn1cbiJdfQ==