/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, ElementRef, Input } from '@angular/core';
import { DomSanitizer } from '@angular/platform-browser';
import { TransitionService } from '@uirouter/angular';
import { I18NextPipe } from 'angular-i18next';
import { NwfPageAlertService } from './page-alert.service';
export class PageAlertComponent {
    /**
     * @param {?} element
     * @param {?} pageAlertService
     * @param {?} sanitizer
     * @param {?} transitionService
     * @param {?} i18next
     */
    constructor(element, pageAlertService, sanitizer, transitionService, i18next) {
        this.element = element;
        this.sanitizer = sanitizer;
        this.transitionService = transitionService;
        this.i18next = i18next;
        this.message = '';
        this.severity = 'ok';
        this.isShowing = false;
        this.extraInformation = '';
        this.showMoreInfo = false;
        this.subscription = pageAlertService.pageAlert$.subscribe((/**
         * @param {?} data
         * @return {?}
         */
        (data) => {
            // TO check whether show is called or hide is called
            if (data.type === 'show') {
                this.show(data.config);
            }
            else {
                this.close();
            }
        }));
        /* I want to close when I exit this route */
        transitionService.onExit({
            exiting: '*',
        }, this.close.bind(this));
    }
    /**
     * @return {?}
     */
    ngOnInit() { }
    /**
     * @return {?}
     */
    ngOnDestroy() {
        // unsubscribe to ensure no memory leaks
        this.subscription.unsubscribe();
    }
    /**
     * @param {?} __0
     * @return {?}
     */
    show({ message, severity, fade }) {
        this.resetFlags();
        // checking if message is object or not.
        if (typeof message === 'object') {
            // setting extraInformation.
            this.extraInformation = message.extraInformation || '';
            // updating message.
            message = message.message;
        }
        this.message = this.sanitizer.bypassSecurityTrustHtml(message);
        this.severity = severity;
        this.isShowing = true;
        if (fade) {
            setTimeout((/**
             * @return {?}
             */
            () => this.close()), fade);
        }
    }
    /**
     * @return {?}
     */
    close() {
        this.isShowing = false;
    }
    /**
     * @return {?}
     */
    toggleMoreInfoVisibility() {
        if (this.showMoreInfo) {
            this.showMoreInfo = false;
            this.showMoreButtonText = this.i18next.transform('nwfjs:showMore');
        }
        else {
            this.showMoreInfo = true;
            this.showMoreButtonText = this.i18next.transform('nwfjs:hide');
        }
    }
    /**
     * @return {?}
     */
    resetFlags() {
        // resetting flags.
        this.extraInformation = '';
        this.showMoreInfo = false;
        this.showMoreButtonText = this.i18next.transform('nwfjs:showMore');
    }
    /**
     * @return {?}
     */
    get stateClass() {
        return `is-${this.severity.toLowerCase()}`;
    }
}
PageAlertComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-page-alert',
                template: `
    <div data-netapp-id="nwf-pageAlert" class="nwf-page-alert {{stateClass}}" *ngIf="isShowing" role="alert">
        <div class="l-page-alert-icon" data-netapp-id="pageAlertCtrl-icon">
            <nwf-icon [severity]="severity"></nwf-icon>
        </div>
        <div class="page-alert-message-container">
            <div data-netapp-id="pageAlertCtrl-message" class="page-alert-message">
                <span [innerHTML]="message"></span>
                <a href="javascript:void(0)" *ngIf="extraInformation" (click)="toggleMoreInfoVisibility()">
                    {{showMoreButtonText}}
                </a>
            </div>
            <div [hidden]="!showMoreInfo">
            <div>{{extraInformation}}</div>
            </div>
        </div>
        <div class="l-page-alert-close" data-netapp-id="pageAlertCtrl-close-btn" (click)="close()">
            <nwf-icon iconClass="icon-action-x"></nwf-icon>
        </div>
    </div>
  `,
                styles: [":host{width:50%;position:fixed;top:60px;left:50%;z-index:9;margin-left:-25%}.nwf-page-alert{display:flex}.nwf-page-alert a{color:#2d6dde}.nwf-page-alert.is-ok{background-color:#b4e697}.nwf-page-alert.is-error{background-color:#fff}.nwf-page-alert.is-info{background-color:#fff7c0}.nwf-page-alert.is-critical{background-color:#fccdce}.nwf-page-alert.is-warning{background-color:#ffe1a1}.l-page-alert-icon{margin-left:7px;-ms-grid-row-align:center;align-self:center;margin-top:2px}.page-alert-message-container{display:flex;flex:9;flex-direction:column;justify-content:center;padding:10px}.page-alert-message{max-width:676px;overflow:hidden;text-overflow:ellipsis}.l-page-alert-close{display:flex;max-width:30px;cursor:pointer;flex:1;align-items:center;justify-content:center}"]
            }] }
];
/** @nocollapse */
PageAlertComponent.ctorParameters = () => [
    { type: ElementRef },
    { type: NwfPageAlertService },
    { type: DomSanitizer },
    { type: TransitionService },
    { type: I18NextPipe }
];
PageAlertComponent.propDecorators = {
    message: [{ type: Input }],
    severity: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    PageAlertComponent.prototype.message;
    /** @type {?} */
    PageAlertComponent.prototype.severity;
    /** @type {?} */
    PageAlertComponent.prototype.isShowing;
    /** @type {?} */
    PageAlertComponent.prototype.extraInformation;
    /** @type {?} */
    PageAlertComponent.prototype.showMoreInfo;
    /** @type {?} */
    PageAlertComponent.prototype.showMoreButtonText;
    /**
     * @type {?}
     * @private
     */
    PageAlertComponent.prototype.subscription;
    /**
     * @type {?}
     * @private
     */
    PageAlertComponent.prototype.element;
    /**
     * @type {?}
     * @private
     */
    PageAlertComponent.prototype.sanitizer;
    /**
     * @type {?}
     * @private
     */
    PageAlertComponent.prototype.transitionService;
    /**
     * @type {?}
     * @private
     */
    PageAlertComponent.prototype.i18next;
}
//# sourceMappingURL=data:application/json;base64,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