/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input, ViewChild } from '@angular/core';
import { NgbDropdown } from '@ng-bootstrap/ng-bootstrap';
import { DxDataGridComponent } from 'devextreme-angular';
export class ColumnVisibilityComponent {
    constructor() {
        this.orderedColumns = []; // our array of the columns in asc order
        // our array of the columns in asc order
        this.visible = {}; // our map of visiblity true / false
    }
    /**
     * @return {?}
     */
    ngOnInit() {
        this.myDrop.openChange.subscribe((/**
         * @return {?}
         */
        () => {
            this.gridInstance = this.dataGrid.instance;
            this.setColumns();
        }));
    }
    /**
     * @return {?}
     */
    setColumns() {
        /** @type {?} */
        const columns = this.gridInstance.option('columns');
        columns.forEach((/**
         * @param {?} __0
         * @return {?}
         */
        ({ dataField }) => {
            /** @type {?} */
            const colObj = this.gridInstance.columnOption(dataField);
            // if columns are shown in columnChooser, then only we toggle the visibility flag and set it as part of ordered columns.
            if (colObj.showInColumnChooser) {
                this.visible[dataField] = colObj.visible;
                this.orderedColumns[colObj.visibleIndex] = colObj;
            }
        }));
    }
    /**
     * @param {?} event
     * @param {?} col
     * @return {?}
     */
    notify(event, col) {
        // we filter out command(eg checkbox column) columns as visibility only operates on non-command columns.
        // This ensures we dont toggle the visibility of checkbox column.
        /** @type {?} */
        const visibleColumns = this.gridInstance.getVisibleColumns().filter((/**
         * @param {?} item
         * @return {?}
         */
        function (item) { return !item.command; }));
        // if we have more than one visible column, or we are showing a column,
        // only then we toggle the visibility of the column.
        // this ensures we never run into case of having all hidden columns.
        if (visibleColumns.length > 1 || event.target.checked) {
            this.gridInstance.beginUpdate();
            this.gridInstance.columnOption(col, 'visible', event.target.checked);
            this.gridInstance.endUpdate();
        }
        else {
            // this ensures the last checkbox remains checked.
            // so that we can never have all checkbox as unchecked i.e. all columns are unselected/hidden.
            event.target.checked = true;
        }
    }
    /**
     * Unused for now.
     * Can be used if submit needed in any case
     * @return {?}
     */
    submit() {
        this.gridInstance.beginUpdate();
        for (const dataField in this.visible) {
            if (this.visible.hasOwnProperty(dataField)) {
                /** @type {?} */
                const columnVisibility = this.visible[dataField];
                this.gridInstance.columnOption(dataField, 'visible', columnVisibility);
            }
        }
        this.gridInstance.endUpdate();
        this.myDrop.close();
    }
}
ColumnVisibilityComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-grid-column-visibility',
                template: "<div ngbDropdown class=\"d-inline-block\" placement=\"bottom-right\" autoClose=\"outside\">\n  <button type=\"button\" class=\"btn btn-flat btn-icon-with-label\" ngbDropdownToggle>\n    <nwf-icon iconClass=\"icon-view-visible\"></nwf-icon><span class=\"nwf-icon-label\">{{'nwfjs:showHide' | i18next}}</span>\n  </button>\n  <div ngbDropdownMenu>\n    <dx-scroll-view>\n      <div class=\"dropdown-checkbox-item pl-4 mb-1\" *ngFor=\"let column of orderedColumns\">\n        <div class=\"custom-control custom-checkbox\" *ngIf=\"column.allowHiding !== false\">\n          <input type=\"checkbox\" [name]=\"column.dataField\" [id]=\"column.dataField\" class=\"custom-control-input\"\n            [(ngModel)]=\"visible[column.dataField]\" (change)=\"notify($event, column.dataField)\">\n          <label class=\"custom-control-label w-100\" [attr.for]=\"column.dataField\">{{column.caption}}</label>\n        </div>\n      </div>\n    </dx-scroll-view>\n  </div>\n</div>",
                styles: [":host ::ng-deep .dx-scrollable-container{max-height:50vh}.dropdown-menu{padding-top:20px;padding-bottom:20px;max-height:60vh}.dropdown-checkbox-item{margin-right:20px}.custom-control-label{cursor:pointer;white-space:nowrap}"]
            }] }
];
/** @nocollapse */
ColumnVisibilityComponent.ctorParameters = () => [];
ColumnVisibilityComponent.propDecorators = {
    myDrop: [{ type: ViewChild, args: [NgbDropdown,] }],
    dataGrid: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    ColumnVisibilityComponent.prototype.myDrop;
    /** @type {?} */
    ColumnVisibilityComponent.prototype.gridInstance;
    /** @type {?} */
    ColumnVisibilityComponent.prototype.orderedColumns;
    /** @type {?} */
    ColumnVisibilityComponent.prototype.visible;
    /**
     * @type {?}
     * @private
     */
    ColumnVisibilityComponent.prototype.dataGrid;
}
//# sourceMappingURL=data:application/json;base64,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