/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
import { I18NextPipe } from 'angular-i18next';
export class NwfFilterCriterionDateComponent {
    /**
     * @param {?} i18NextPipe
     */
    constructor(i18NextPipe) {
        this.datetime = '';
        // List of default date selections for the user
        this.dateRangeList = [
            { id: 'LAST_1h', label: '' },
            { id: 'LAST_24h', label: '' },
            { id: 'LAST_72h', label: '' },
            { id: 'LAST_7d', label: '' },
            { id: 'LAST_30d', label: '' },
            { id: 'LAST_390d', label: '' },
        ];
        // i18n the values (displayed label in the drop down)
        for (let dateRangeList of this.dateRangeList) {
            // pop in the the label translated (the key is e.g. last_1h)
            dateRangeList.label = i18NextPipe.transform(`nwfjs:${dateRangeList.id.toLowerCase()}`);
        }
    }
    /**
     * @param {?} changes
     * @return {?}
     */
    ngOnChanges(changes) {
        // on every operator change, we set the dateTime, dateTimeVisibleValue based on operator value.
        // we can have 3 types of operator.
        // 1. <=, >=, 2. between, 3. in the last(last)
        if (!changes.operator.isFirstChange()) {
            // if current value is <=, >=, we set dateTimeVisibleValue to current Date
            if (['<=', '>='].indexOf(changes.operator.currentValue) !== -1) {
                this.datetime = new Date().toISOString();
                this.datetimeVisibleValue = new Date();
            }
            else if (changes.operator.currentValue === 'between') {
                this.datetime = `${new Date().toISOString()}~${new Date().toISOString()}`;
            }
            else {
                this.datetime = '';
            }
            // sending out new value.
            this.onValueModelChange(this.datetime);
        }
    }
    /**
     * Writes a new value to the element.
     * This method will be called by the forms API to write to the view when programmatic (model -> view) changes are requested.
     * This is incoming 'value' into the component.This value is pre-set value to datetime widget.
     * @param {?} value
     * @return {?}
     */
    writeValue(value) {
        // we default datetime to last_72h, in case there is no value set.
        this.datetime = value;
        this.datetimeVisibleValue = new Date(this.datetime);
    }
    /**
     * @param {?} fn
     * @return {?}
     */
    registerOnChange(fn) { this._onChange = fn; }
    /**
     * @param {?} fn
     * @return {?}
     */
    registerOnTouched(fn) { }
    /**
     * This method is called whenever model tied to the component changes.
     * This is outgoing value from this widget.
     * @param {?} newDateValue
     * @return {?}
     */
    onValueModelChange(newDateValue) {
        this.datetimeVisibleValue = new Date(newDateValue);
        this._onChange(newDateValue);
    }
}
NwfFilterCriterionDateComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-grid-filter-criterion-date',
                template: `
    <select class="form-control mr-2" required data-netapp-id="filter-widget-select-operator" *ngIf="operator === 'lst'"
    (change)="onValueModelChange($event.target.value)" [(ngModel)]="datetime">
        <option [selected]="!datetime" value>{{'nwfjs:choose' | i18next}}</option>
        <option [selected]="datetime == dateRange.id" *ngFor="let dateRange of dateRangeList" [value]="dateRange.id">{{dateRange.label}}</option>
    </select>

    <div *ngIf="operator === 'between'" (click)="$event.stopPropagation()">
        <nwf-datetime-range-picker [(ngModel)]="datetime" (ngModelChange)="onValueModelChange($event)"></nwf-datetime-range-picker>
    </div>

    <div *ngIf="operator === '>=' || operator === '<='" (click)="$event.stopPropagation()">
        <ng-template #datetimePickerTemplate>
            <nwf-datetime-picker [(ngModel)]="datetime" (ngModelChange)="onValueModelChange($event)"></nwf-datetime-picker>
        </ng-template>
        <button type="button" class="btn btn-default d-flex align-items-center form-control" [ngbPopover]="datetimePickerTemplate" placement="bottom" data-netapp-id="filter-widget-btn">
            <nwf-icon iconClass="icon-action-calendar"></nwf-icon>
            <label data-netapp-id="dateTimePicker-widget-label">{{ datetimeVisibleValue | i18nextFormat: { format: 'datetime' } }}</label>
        </button>
    </div>
    `,
                providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: NwfFilterCriterionDateComponent,
                        multi: true,
                    }]
            }] }
];
/** @nocollapse */
NwfFilterCriterionDateComponent.ctorParameters = () => [
    { type: I18NextPipe }
];
NwfFilterCriterionDateComponent.propDecorators = {
    operator: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    NwfFilterCriterionDateComponent.prototype.operator;
    /** @type {?} */
    NwfFilterCriterionDateComponent.prototype.datetime;
    /** @type {?} */
    NwfFilterCriterionDateComponent.prototype.datetimeVisibleValue;
    /** @type {?} */
    NwfFilterCriterionDateComponent.prototype.dateRangeList;
    /**
     * @type {?}
     * @private
     */
    NwfFilterCriterionDateComponent.prototype._onChange;
}
//# sourceMappingURL=data:application/json;base64,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