/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Injectable } from '@angular/core';
import DataGrid from 'devextreme/ui/data_grid';
import { merge } from 'lodash-es';
import { NwfColumnsChangingService } from '../components/grid-columns-changing.service';
export class NwfGridOptionsService {
    /**
     * @param {?} columnsChangingService
     */
    constructor(columnsChangingService) {
        this.columnsChangingService = columnsChangingService;
    }
    /**
     * Set the global options on the DxDataGrid with defaults from nwfjs and passed in values
     * @param {?=} options for overriding the default options
     * @return {?}
     */
    setGridDefaultOptions(options = {}) {
        DataGrid.defaultOptions(merge({
            device: { deviceType: 'desktop' },
            options: {
                // following options are standard for all nwfjs grids.
                allowColumnResizing: true,
                allowColumnReordering: true,
                showColumnLines: false,
                showRowLines: true,
                hoverStateEnabled: true,
                // this property synchronize the filter row, header filter, and filter builder.
                // The synchronized filter expression is stored in the filterValue option.
                filterSyncEnabled: true,
                // This disables right click context menus.
                /**
                 * @param {?} e
                 * @return {?}
                 */
                onContextMenuPreparing(e) {
                    e.items = [];
                },
                onInitialized: (/**
                 * @param {?} e
                 * @return {?}
                 */
                (e) => {
                    // Wire onColumnsChanging event to service observable
                    e.component.option('onColumnsChanging', (/**
                     * @param {?} columnChangeEvent
                     * @return {?}
                     */
                    (columnChangeEvent) => {
                        this.columnsChangingService.onColumnsChanging(columnChangeEvent);
                    }));
                }),
                pager: {
                    visible: false,
                },
                scrolling: {
                    useNative: false,
                },
            },
        }, options));
    }
}
NwfGridOptionsService.decorators = [
    { type: Injectable }
];
/** @nocollapse */
NwfGridOptionsService.ctorParameters = () => [
    { type: NwfColumnsChangingService }
];
if (false) {
    /**
     * @type {?}
     * @private
     */
    NwfGridOptionsService.prototype.columnsChangingService;
}
// Our custom 'lst' operation. This is used by filterWidget 'in the last' operator for datetime values.
/** @type {?} */
export const NwfFilterBuilderCustomOperations = [{
        name: 'lst',
        caption: 'Last',
        dataTypes: ['date', 'datetime'],
        hasValue: false,
        /**
         * @param {?} filterValue
         * @param {?} field
         * @return {?}
         */
        calculateFilterExpression(filterValue, field) {
            /** @type {?} */
            const newStartDate = new Date();
            /** @type {?} */
            const hours = new Date().getHours();
            switch (filterValue.toLowerCase()) {
                case 'last_1h':
                    newStartDate.setHours(hours - 1);
                    break;
                case 'last_24h':
                    newStartDate.setHours(hours - 24);
                    break;
                case 'last_72h':
                    newStartDate.setHours(hours - 72);
                    break;
                case 'last_7d':
                    newStartDate.setHours(hours - (7 * 24));
                    break;
                case 'last_30d':
                    newStartDate.setHours(hours - (30 * 24));
                    break;
                case 'last_390d':
                    newStartDate.setHours(hours - (390 * 24));
                    break;
            }
            return [[field.dataField, '>=', newStartDate], 'and', [field.dataField, '<=', new Date()]];
        },
    }];
//# sourceMappingURL=data:application/json;base64,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