/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { CommonModule } from '@angular/common';
import { NgModule } from '@angular/core';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { BrowserModule } from '@angular/platform-browser';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { I18NextModule } from 'angular-i18next';
import { DxDataGridModule, DxScrollViewModule } from 'devextreme-angular';
import { NwfjsSharedComponentsModule } from '../components/nwfjs.shared-components.module';
import { NwfjsSharedPipesModule } from '../pipes/nwfjs.shared-pipes.module';
import { CellsComponent } from './cells/cells.component';
import { ColumnChooserComponent } from './column-chooser/column-chooser.component';
import { ColumnVisibilityComponent } from './column-visibility/column-visibility.component';
import { FilterCriterionRowComponent } from './filter/filter-criterion-row/filter-criterion-row.component';
import { NwfFilterCriterionDateComponent } from './filter/filter-date/filter-date.component';
// filter components
import { FilterMultiselectComponent } from './filter/filter-multiselect/filter-multiselect.component';
import { NwfFilterComponent } from './filter/filter.component';
import { FooterComponent } from './footer/footer.component';
import { NwfGridOptionsService } from './grid-options.service';
// grid components
import { NwfGridPaginatorComponent } from './paginator/paginator.component';
import { SearchComponent } from './search/search.component';
/** @type {?} */
const allComponents = [
    NwfGridPaginatorComponent, SearchComponent, ColumnChooserComponent, ColumnVisibilityComponent,
    NwfFilterComponent, FilterMultiselectComponent, FilterCriterionRowComponent,
    NwfFilterCriterionDateComponent, FooterComponent, CellsComponent,
];
export class NwfGridModule {
    constructor() { }
}
NwfGridModule.decorators = [
    { type: NgModule, args: [{
                imports: [
                    NgbModule,
                    CommonModule,
                    BrowserModule,
                    ReactiveFormsModule,
                    FormsModule,
                    I18NextModule,
                    NwfjsSharedComponentsModule,
                    DxDataGridModule,
                    DxScrollViewModule,
                    NwfjsSharedPipesModule,
                ],
                providers: [NwfGridOptionsService],
                declarations: allComponents,
                exports: allComponents,
            },] }
];
/** @nocollapse */
NwfGridModule.ctorParameters = () => [];
//# sourceMappingURL=data:application/json;base64,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