/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component } from '@angular/core';
import { NgbActiveModal } from '@ng-bootstrap/ng-bootstrap';
export class UserNoExistComponent {
    /**
     * @param {?} activeModal
     */
    constructor(activeModal) {
        this.activeModal = activeModal;
    }
    /**
     * @return {?}
     */
    ngOnInit() {
    }
}
UserNoExistComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-user-noexist',
                template: `
  <div class="modal-content">
  <div class="modal-header is-error">
      <nwf-icon iconClass="icon-Warning"></nwf-icon>
      <h5 class="modal-title" data-netapp-id="userNotExists-errorDialog-title">{{'nwfjs:error' | i18next}}</h5>
  </div>
  <div class="modal-body" data-netapp-id="userNotExists-errorDialog-content">
      <p>{{'nwfjs:loginUsernameNotExist' | i18next}}</p>
      <p>{{'nwfjs:loginVerifyUsernameTryAgain' | i18next}}</p>
  </div>
  <div class="modal-footer">
      <button class="btn btn-primary" (click)="activeModal.close()" data-netapp-id="userNotExists-errorDialog-ok-button" autofocus>{{'nwfjs:OK' | i18next}}</button>
  </div>
</div>
  `
            }] }
];
/** @nocollapse */
UserNoExistComponent.ctorParameters = () => [
    { type: NgbActiveModal }
];
if (false) {
    /** @type {?} */
    UserNoExistComponent.prototype.activeModal;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXNlci1ub2V4aXN0LmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiJuZzovL0BuZXRhcHAvbndmanNfYW5ndWxhcl9jb21wb25lbnRzLyIsInNvdXJjZXMiOlsibGliL3NoZWxsL2xvZ2luL3VzZXItbm9leGlzdC5jb21wb25lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7OztBQUFBLE9BQU8sRUFBRSxTQUFTLEVBQVUsTUFBTSxlQUFlLENBQUM7QUFDbEQsT0FBTyxFQUFFLGNBQWMsRUFBRSxNQUFNLDRCQUE0QixDQUFDO0FBcUI1RCxNQUFNLE9BQU8sb0JBQW9COzs7O0lBRS9CLFlBQW1CLFdBQTJCO1FBQTNCLGdCQUFXLEdBQVgsV0FBVyxDQUFnQjtJQUFJLENBQUM7Ozs7SUFFNUMsUUFBUTtJQUNmLENBQUM7OztZQXhCRixTQUFTLFNBQUM7Z0JBQ1QsUUFBUSxFQUFFLGtCQUFrQjtnQkFDNUIsUUFBUSxFQUFFOzs7Ozs7Ozs7Ozs7OztHQWNUO2FBRUY7Ozs7WUFwQlEsY0FBYzs7OztJQXVCVCwyQ0FBa0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb21wb25lbnQsIE9uSW5pdCB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgTmdiQWN0aXZlTW9kYWwgfSBmcm9tICdAbmctYm9vdHN0cmFwL25nLWJvb3RzdHJhcCc7XG5cbkBDb21wb25lbnQoe1xuICBzZWxlY3RvcjogJ253Zi11c2VyLW5vZXhpc3QnLFxuICB0ZW1wbGF0ZTogYFxuICA8ZGl2IGNsYXNzPVwibW9kYWwtY29udGVudFwiPlxuICA8ZGl2IGNsYXNzPVwibW9kYWwtaGVhZGVyIGlzLWVycm9yXCI+XG4gICAgICA8bndmLWljb24gaWNvbkNsYXNzPVwiaWNvbi1XYXJuaW5nXCI+PC9ud2YtaWNvbj5cbiAgICAgIDxoNSBjbGFzcz1cIm1vZGFsLXRpdGxlXCIgZGF0YS1uZXRhcHAtaWQ9XCJ1c2VyTm90RXhpc3RzLWVycm9yRGlhbG9nLXRpdGxlXCI+e3snbndmanM6ZXJyb3InIHwgaTE4bmV4dH19PC9oNT5cbiAgPC9kaXY+XG4gIDxkaXYgY2xhc3M9XCJtb2RhbC1ib2R5XCIgZGF0YS1uZXRhcHAtaWQ9XCJ1c2VyTm90RXhpc3RzLWVycm9yRGlhbG9nLWNvbnRlbnRcIj5cbiAgICAgIDxwPnt7J253ZmpzOmxvZ2luVXNlcm5hbWVOb3RFeGlzdCcgfCBpMThuZXh0fX08L3A+XG4gICAgICA8cD57eydud2Zqczpsb2dpblZlcmlmeVVzZXJuYW1lVHJ5QWdhaW4nIHwgaTE4bmV4dH19PC9wPlxuICA8L2Rpdj5cbiAgPGRpdiBjbGFzcz1cIm1vZGFsLWZvb3RlclwiPlxuICAgICAgPGJ1dHRvbiBjbGFzcz1cImJ0biBidG4tcHJpbWFyeVwiIChjbGljayk9XCJhY3RpdmVNb2RhbC5jbG9zZSgpXCIgZGF0YS1uZXRhcHAtaWQ9XCJ1c2VyTm90RXhpc3RzLWVycm9yRGlhbG9nLW9rLWJ1dHRvblwiIGF1dG9mb2N1cz57eydud2ZqczpPSycgfCBpMThuZXh0fX08L2J1dHRvbj5cbiAgPC9kaXY+XG48L2Rpdj5cbiAgYCxcbiAgc3R5bGVzOiBbXSxcbn0pXG5leHBvcnQgY2xhc3MgVXNlck5vRXhpc3RDb21wb25lbnQgaW1wbGVtZW50cyBPbkluaXQge1xuXG4gIGNvbnN0cnVjdG9yKHB1YmxpYyBhY3RpdmVNb2RhbDogTmdiQWN0aXZlTW9kYWwpIHsgfVxuXG4gIHB1YmxpYyBuZ09uSW5pdCgpIHtcbiAgfVxuXG59XG4iXX0=