/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { NgbActiveModal } from '@ng-bootstrap/ng-bootstrap';
export class LogoutFailedComponent {
    /**
     * @param {?} activeModal
     */
    constructor(activeModal) {
        this.activeModal = activeModal;
    }
    /**
     * @return {?}
     */
    ngOnInit() {
    }
}
LogoutFailedComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-logout-failed',
                template: `
  <div class="modal-content">
  <div class="modal-header is-error">
      <nwf-icon iconClass="icon-status-warning"></nwf-icon>
      <h5 class="modal-title" data-netapp-id="logOut-errorDialog-title">{{'nwfjs:error' | i18next}}</h5>
  </div>
  <div class="modal-body" data-netapp-id="logOut-errorDialog-content">
      <b>{{'nwfjs:logoutFailed' | i18next}}</b>
      <br>
      <p>{{'nwfjs:logoutSignOutNow' | i18next}}</p>
  </div>
  <div class="modal-footer">
      <button class="btn btn-primary" (click)="activeModal.close()" data-netapp-id="logOut-errorDialog-ok-button">{{'nwfjs:OK' | i18next}}</button>
  </div>
</div>

  `
            }] }
];
/** @nocollapse */
LogoutFailedComponent.ctorParameters = () => [
    { type: NgbActiveModal }
];
LogoutFailedComponent.propDecorators = {
    errorCode: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    LogoutFailedComponent.prototype.errorCode;
    /** @type {?} */
    LogoutFailedComponent.prototype.activeModal;
}
//# sourceMappingURL=data:application/json;base64,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