/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { CommonModule } from '@angular/common';
import { NgModule } from '@angular/core';
import { FormsModule } from '@angular/forms';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { UIRouterModule } from '@uirouter/angular';
import { I18NextModule } from 'angular-i18next';
import { DxPopoverModule, DxScrollViewModule, DxTemplateModule } from 'devextreme-angular';
import { NwfjsSharedComponentsModule } from '../components/nwfjs.shared-components.module';
import { AboutModalComponent } from './about/about-modal.component';
import { AboutComponent } from './about/about.component';
import { AppTitleComponent } from './app-title/app-title.component';
import { GlobalSearchComponent } from './global-search/global-search.component';
import { GlobalnavPrimaryCenterComponent } from './globalnav-primary-center/globalnav-primary-center.component';
import { GlobalnavPrimaryToolsComponent } from './globalnav-primary-tools/globalnav-primary-tools.component';
import { GlobalnavPrimaryComponent } from './globalnav-primary/globalnav-primary.component';
import { GlobalnavSecondaryMenusComponent } from './globalnav-secondary-menus/globalnav-secondary-menus.component';
import { GlobalnavSecondarySearchComponent } from './globalnav-secondary-search/globalnav-secondary-search.component';
import { GlobalnavSecondaryComponent } from './globalnav-secondary/globalnav-secondary.component';
import { GlobalnavComponent } from './globalnav/globalnav.component';
import { LeftnavItemComponent } from './leftnav/leftnav-item.component';
import { LeftnavComponent } from './leftnav/leftnav.component';
import { NwfLeftnavService } from './leftnav/leftnav.service';
import { LoginFailedComponent } from './login/login-failed.component';
import { LoginForgotPasswordComponent } from './login/login-forgot-password.component';
import { LoginComponent } from './login/login.component';
import { ResetPasswordResultComponent } from './login/reset-password-result.component';
import { ResetPasswordComponent } from './login/reset-password.component';
import { UserNoExistComponent } from './login/user-noexist.component';
import { LogoutFailedComponent } from './logout/logout-failed.component';
import { LogoutComponent } from './logout/logout.component';
import { MainbodyComponent } from './mainbody/mainbody.component';
import { NwfTitleService } from './title/title.service';
export class ShellModule {
}
ShellModule.decorators = [
    { type: NgModule, args: [{
                imports: [
                    DxTemplateModule,
                    DxPopoverModule,
                    DxScrollViewModule,
                    CommonModule,
                    FormsModule,
                    NwfjsSharedComponentsModule,
                    I18NextModule,
                    NgbModule,
                    UIRouterModule,
                ],
                providers: [NwfLeftnavService, NwfTitleService],
                declarations: [
                    GlobalnavComponent,
                    AppTitleComponent,
                    GlobalnavPrimaryComponent,
                    GlobalnavPrimaryCenterComponent,
                    GlobalnavPrimaryToolsComponent,
                    GlobalnavSecondaryComponent,
                    GlobalnavSecondaryMenusComponent,
                    GlobalnavSecondarySearchComponent,
                    GlobalSearchComponent,
                    AboutComponent,
                    AboutModalComponent,
                    LeftnavComponent,
                    LeftnavItemComponent,
                    LoginComponent,
                    LoginFailedComponent,
                    ResetPasswordComponent,
                    ResetPasswordResultComponent,
                    LoginForgotPasswordComponent,
                    UserNoExistComponent,
                    LogoutComponent,
                    LogoutFailedComponent,
                    MainbodyComponent,
                ],
                entryComponents: [
                    AboutModalComponent,
                    LoginFailedComponent,
                    ResetPasswordComponent,
                    ResetPasswordResultComponent,
                    LoginForgotPasswordComponent,
                    UserNoExistComponent,
                    LogoutFailedComponent,
                    MainbodyComponent,
                    LeftnavComponent,
                ],
                exports: [
                    GlobalnavComponent,
                    AppTitleComponent,
                    GlobalnavPrimaryComponent,
                    GlobalnavPrimaryCenterComponent,
                    GlobalnavPrimaryToolsComponent,
                    GlobalnavSecondaryComponent,
                    GlobalnavSecondaryMenusComponent,
                    GlobalnavSecondarySearchComponent,
                    GlobalSearchComponent,
                    AboutComponent,
                    LeftnavComponent,
                    LoginComponent,
                    LogoutComponent,
                    MainbodyComponent,
                ],
            },] }
];
//# sourceMappingURL=data:application/json;base64,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